/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.primitives;

import adalid.commons.util.NumUtils;
import adalid.core.NativeQuerySegment;
import adalid.core.Primitive;
import adalid.core.Project;
import adalid.core.XS2;
import adalid.core.enums.DivisorRule;
import adalid.core.enums.NumericFieldType;
import adalid.core.enums.RowsAggregateOp;
import adalid.core.enums.ScalarOp;
import adalid.core.enums.SpecialNumericValue;
import adalid.core.enums.SymbolPosition;
import adalid.core.expressions.BooleanComparisonX;
import adalid.core.expressions.CharacterOrderedPairX;
import adalid.core.expressions.CharacterScalarX;
import adalid.core.expressions.NumericOrderedPairX;
import adalid.core.expressions.NumericScalarX;
import adalid.core.expressions.XB;
import adalid.core.interfaces.IntervalizedArtifact;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Operator;
import adalid.core.interfaces.Property;
import adalid.core.sql.NativeQuery;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class NumericPrimitive
extends Primitive
implements IntervalizedArtifact,
NumericExpression {
    private static final Logger logger = Logger.getLogger(NumericPrimitive.class);
    private static final String EOL = "\n";
    private Object _calculableValue;
    private Object _initialValue;
    private Object _defaultValue;
    private Object _currentValue;
    private Object _minValue;
    private Object _maxValue;
    private Number _minNumber;
    private Number _maxNumber;
    private final Map<Locale, String> _localizedRangeErrorMessage = new LinkedHashMap<Locale, String>();
    private NumericFieldType _converterType = NumericFieldType.UNSPECIFIED;
    private int _divisor = -1;
    private DivisorRule _divisorRule = DivisorRule.UNSPECIFIED;
    private String _symbol = "";
    private SymbolPosition _symbolPosition = SymbolPosition.UNSPECIFIED;
    private Boolean _symbolSeparator;
    private String _specialConverterName = "";
    private String _specialValidatorName = "";

    @Override
    public boolean finalise() {
        boolean ok = super.finalise();
        if (ok && (this.isPrimaryKeyProperty() || this.isSequenceProperty())) {
            this._calculableValue = null;
            this._initialValue = null;
            this._defaultValue = null;
            this._currentValue = null;
            this._minValue = null;
            this._maxValue = null;
            this._divisor = 0;
            this._divisorRule = DivisorRule.UNSPECIFIED;
            this._symbol = null;
            this._symbolSeparator = false;
            this._symbolPosition = SymbolPosition.UNSPECIFIED;
            this._converterType = NumericFieldType.UNSPECIFIED;
            this._specialConverterName = null;
            this._specialValidatorName = null;
        }
        return ok;
    }

    @Override
    public void finish() {
        if (this.isFinished()) {
            logger.warn((Object)(this.getFullName() + " already finished! "));
            Project.increaseParserWarningCount();
            return;
        }
        super.finish();
    }

    @Override
    public Object getCalculableValue() {
        return this.toDataType(this._calculableValue);
    }

    public void setCalculableValueExpression(NumericExpression expression) {
        this._calculableValue = this.validCalculableValue(expression) ? expression : null;
    }

    @Override
    public Object getInitialValue() {
        return this.toDataType(this._initialValue);
    }

    public boolean isPrimitiveInitialValue() {
        return this._initialValue instanceof Number;
    }

    public boolean isSpecialInitialValue() {
        return this._initialValue instanceof SpecialNumericValue;
    }

    public boolean isExpressInitialValue() {
        return this._initialValue instanceof NumericExpression;
    }

    public boolean isDefinedInitialValue() {
        return this._initialValue != null;
    }

    public void setInitialValue(Number initialValue) {
        this._initialValue = this.validInitialValue(initialValue) ? initialValue : null;
    }

    public void setInitialValue(SpecialNumericValue initialValue) {
        this._initialValue = this.validInitialValue(initialValue) ? initialValue : null;
    }

    public void setInitialValue(NumericExpression initialValue) {
        this._initialValue = this.validInitialValue(initialValue) ? initialValue : null;
    }

    @Override
    public Object getDefaultValue() {
        return this.toDataType(this._defaultValue);
    }

    public boolean isPrimitiveDefaultValue() {
        return this._defaultValue instanceof Number;
    }

    public boolean isSpecialDefaultValue() {
        return this._defaultValue instanceof SpecialNumericValue;
    }

    public boolean isExpressDefaultValue() {
        return this._defaultValue instanceof NumericExpression;
    }

    public boolean isDefinedDefaultValue() {
        return this._defaultValue != null;
    }

    public void setDefaultValue(Number defaultValue) {
        this._defaultValue = this.validDefaultValue(defaultValue) ? defaultValue : null;
    }

    public void setDefaultValue(SpecialNumericValue defaultValue) {
        this._defaultValue = this.validDefaultValue(defaultValue) ? defaultValue : null;
    }

    public void setDefaultValue(NumericExpression defaultValue) {
        this._defaultValue = this.validDefaultValue(defaultValue) ? defaultValue : null;
    }

    @Override
    public Object getCurrentValue() {
        return this.toDataType(this._currentValue);
    }

    public boolean isPrimitiveCurrentValue() {
        return this._currentValue instanceof Number;
    }

    public boolean isSpecialCurrentValue() {
        return this._currentValue instanceof SpecialNumericValue;
    }

    public boolean isExpressCurrentValue() {
        return this._currentValue instanceof NumericExpression;
    }

    public boolean isDefinedCurrentValue() {
        return this._currentValue != null;
    }

    public void setCurrentValue(Number currentValue) {
        this._currentValue = this.validCurrentValue(currentValue) ? currentValue : null;
    }

    public void setCurrentValue(SpecialNumericValue currentValue) {
        this._currentValue = this.validCurrentValue(currentValue) ? currentValue : null;
    }

    public void setCurrentValue(NumericExpression currentValue) {
        this._currentValue = this.validCurrentValue(currentValue) ? currentValue : null;
    }

    @Override
    public Object getMinValue() {
        return this._minValue == null ? this._minNumber : (this._minValue instanceof Number ? this.primitiveMinValue() : this.toDataType(this._minValue));
    }

    public Number getPrimitiveMinValue() {
        return this._minValue == null ? (Number)this._minNumber : (Number)(this._minValue instanceof Number ? (Number)this.primitiveMinValue() : (Number)this._minNumber);
    }

    private Number primitiveMinValue() {
        Number value = (Number)this._minValue;
        return this._minNumber == null ? (Number)value : (Number)(this.compare(value, this._minNumber) > 0 ? (Number)value : (Number)this._minNumber);
    }

    public boolean isPrimitiveMinValue() {
        return this._minValue == null ? this._minNumber != null : this._minValue instanceof Number;
    }

    public boolean isSpecialMinValue() {
        return this._minValue instanceof SpecialNumericValue;
    }

    public boolean isExpressMinValue() {
        return this._minValue instanceof NumericExpression;
    }

    public boolean isDefinedMinValue() {
        return this._minValue != null;
    }

    public void setMinValue(Number minValue) {
        this._minValue = minValue;
    }

    public void setMinValue(SpecialNumericValue minValue) {
        this._minValue = minValue;
    }

    public void setMinValue(NumericExpression minValue) {
        this._minValue = this.validMinimumValue(minValue) ? minValue : null;
    }

    @Override
    public Object getMaxValue() {
        return this._maxValue == null ? this._maxNumber : (this._maxValue instanceof Number ? this.primitiveMaxValue() : this.toDataType(this._maxValue));
    }

    public Number getPrimitiveMaxValue() {
        return this._maxValue == null ? (Number)this._maxNumber : (Number)(this._maxValue instanceof Number ? (Number)this.primitiveMaxValue() : (Number)this._maxNumber);
    }

    private Number primitiveMaxValue() {
        Number value = (Number)this._maxValue;
        return this._maxNumber == null ? (Number)value : (Number)(this.compare(value, this._maxNumber) < 0 ? (Number)value : (Number)this._maxNumber);
    }

    public boolean isPrimitiveMaxValue() {
        return this._maxValue == null ? this._maxNumber != null : this._maxValue instanceof Number;
    }

    public boolean isSpecialMaxValue() {
        return this._maxValue instanceof SpecialNumericValue;
    }

    public boolean isExpressMaxValue() {
        return this._maxValue instanceof NumericExpression;
    }

    public boolean isDefinedMaxValue() {
        return this._maxValue != null;
    }

    public void setMaxValue(Number maxValue) {
        this._maxValue = maxValue;
    }

    public void setMaxValue(SpecialNumericValue maxValue) {
        this._maxValue = maxValue;
    }

    public void setMaxValue(NumericExpression maxValue) {
        this._maxValue = this.validMaximumValue(maxValue) ? maxValue : null;
    }

    public Number getMinNumber() {
        return this._minNumber;
    }

    protected void setMinNumber(Number minNumber) {
        this._minNumber = minNumber;
    }

    public Number getMaxNumber() {
        return this._maxNumber;
    }

    protected void setMaxNumber(Number maxNumber) {
        this._maxNumber = maxNumber;
    }

    private int compare(Number x, Number y) {
        BigDecimal bx = new BigDecimal(x.toString());
        BigDecimal by = new BigDecimal(y.toString());
        return bx.compareTo(by);
    }

    private Object toDataType(Object value) {
        if (value instanceof NumericExpression) {
            NumericExpression nx = (NumericExpression)value;
            Operator nxop = nx.getOperator();
            Class<?> nxdt = nx instanceof NumericPrimitive ? nx.getDataType() : null;
            Class<?> mydt = this.getDataType();
            if (mydt != null && !mydt.equals(nxdt) && nxop != null) {
                if (Byte.class.isAssignableFrom(mydt)) {
                    if (!ScalarOp.TO_BYTE.equals(nxop)) {
                        return nx.toByte();
                    }
                } else if (Short.class.isAssignableFrom(mydt)) {
                    if (!ScalarOp.TO_SHORT.equals(nxop)) {
                        return nx.toShort();
                    }
                } else if (Integer.class.isAssignableFrom(mydt)) {
                    if (!ScalarOp.TO_INTEGER.equals(nxop)) {
                        return nx.toInteger();
                    }
                } else if (Long.class.isAssignableFrom(mydt)) {
                    if (!ScalarOp.TO_LONG.equals(nxop)) {
                        return nx.toLong();
                    }
                } else if (Float.class.isAssignableFrom(mydt)) {
                    if (!ScalarOp.TO_FLOAT.equals(nxop)) {
                        return nx.toFloat();
                    }
                } else if (Double.class.isAssignableFrom(mydt)) {
                    if (!ScalarOp.TO_DOUBLE.equals(nxop)) {
                        return nx.toDouble();
                    }
                } else if (BigInteger.class.isAssignableFrom(mydt)) {
                    if (!ScalarOp.TO_BIG_INTEGER.equals(nxop)) {
                        return nx.toBigInteger();
                    }
                } else if (BigDecimal.class.isAssignableFrom(mydt) && !ScalarOp.TO_BIG_DECIMAL.equals(nxop)) {
                    return nx.toBigDecimal();
                }
            }
        }
        return value;
    }

    public int getIntegerDigits() {
        int maxDigits = this.digits(this._maxValue);
        int minDigits = this.digits(this._minValue);
        return maxDigits > 0 && minDigits > 0 ? (maxDigits > minDigits ? maxDigits : minDigits) : 0;
    }

    private int digits(Object obj) {
        return this.integral(obj) ? StringUtils.removeStart((String)StringUtils.substringBefore((String)obj.toString(), (String)"."), (String)"-").length() : 0;
    }

    private boolean integral(Object obj) {
        return obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof BigInteger || obj instanceof BigDecimal;
    }

    @Override
    public String getDefaultRangeErrorMessage() {
        return this.getLocalizedRangeErrorMessage(null);
    }

    @Override
    public void setDefaultRangeErrorMessage(String message) {
        this.setLocalizedRangeErrorMessage(null, message);
    }

    @Override
    public String getLocalizedRangeErrorMessage(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedRangeErrorMessage.get(l);
    }

    @Override
    public void setLocalizedRangeErrorMessage(Locale locale, String message) {
        Locale l = this.localeWritingKey(locale);
        if (message == null) {
            this._localizedRangeErrorMessage.remove(l);
        } else {
            this._localizedRangeErrorMessage.put(l, message);
        }
    }

    @Override
    public Object getDataGenMin() {
        Object dataGenMin = super.getDataGenMin();
        if (dataGenMin != null) {
            return dataGenMin;
        }
        if (this._minValue == null) {
            return 0;
        }
        Integer min = this.objectToInteger(this._minValue);
        return min != null ? (Number)min : (Number)this.javaGenMin();
    }

    @Override
    public Object getDataGenMax() {
        Object dataGenMax = super.getDataGenMax();
        if (dataGenMax != null) {
            return dataGenMax;
        }
        if (this._maxValue == null) {
            return this.javaGenMax();
        }
        Integer max = this.objectToInteger(this._maxValue);
        return max != null ? (Number)max : (Number)this.javaGenMax();
    }

    private Integer objectToInteger(Object obj) {
        if (obj instanceof Number) {
            try {
                return NumUtils.newInteger(obj);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private Number javaGenMin() {
        return this.isByteData() ? -128 : (this.isShortData() ? Short.MIN_VALUE : Integer.MIN_VALUE);
    }

    private Number javaGenMax() {
        return this.isByteData() ? 127 : (this.isShortData() ? Short.MAX_VALUE : 0x7FFFFFF8);
    }

    public NumericFieldType getConverterType() {
        return this._converterType;
    }

    public void setConverterType(NumericFieldType type) {
        XS2.checkAccess();
        this._converterType = type == null ? NumericFieldType.UNSPECIFIED : type;
    }

    public int getDivisor() {
        return this._divisor;
    }

    public void setDivisor(int divisor) {
        XS2.checkAccess();
        this._divisor = divisor;
    }

    public DivisorRule getDivisorRule() {
        return this._divisorRule;
    }

    public void setDivisorRule(DivisorRule rule) {
        XS2.checkAccess();
        this._divisorRule = rule == null ? DivisorRule.UNSPECIFIED : rule;
    }

    public String getSymbol() {
        return this._symbol;
    }

    public void setSymbol(String symbol) {
        XS2.checkAccess();
        this._symbol = symbol;
    }

    public SymbolPosition getSymbolPosition() {
        return this._symbolPosition;
    }

    public void setSymbolPosition(SymbolPosition position) {
        XS2.checkAccess();
        this._symbolPosition = position == null ? SymbolPosition.UNSPECIFIED : position;
    }

    public Boolean isSymbolSeparator() {
        return this._symbolSeparator;
    }

    public void setSymbolSeparator(boolean separator) {
        XS2.checkAccess();
        this._symbolSeparator = separator;
    }

    public String getSpecialConverterName() {
        return this._specialConverterName;
    }

    public void setSpecialConverterName(String converter) {
        XS2.checkAccess();
        this._specialConverterName = converter;
    }

    public String getSpecialValidatorName() {
        return this._specialValidatorName;
    }

    public void setSpecialValidatorName(String validator) {
        XS2.checkAccess();
        this._specialValidatorName = validator;
    }

    public void keepSumOn(Property ... properties) {
        this.addAggregate(RowsAggregateOp.SUM, properties);
    }

    public void keepTallyOn(Property ... properties) {
        this.addAggregate(RowsAggregateOp.TALLY, properties);
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            if (this._minValue != null) {
                string = (String)string + fee + tab + "minValue" + faa + this.getValueString(this._minValue) + foo;
            }
            if (this._maxValue != null) {
                string = (String)string + fee + tab + "maxValue" + faa + this.getValueString(this._maxValue) + foo;
            }
        }
        return string;
    }

    public NativeQuerySegment isIn(NativeQuery y) {
        return NativeQuerySegment.of(XB.Numeric.Comparison.isIn((NumericExpression)this, y));
    }

    public NativeQuerySegment isNotIn(NativeQuery y) {
        return NativeQuerySegment.of(XB.Numeric.Comparison.isNotIn((NumericExpression)this, y));
    }

    @Override
    public BooleanComparisonX isNull() {
        return XB.Numeric.Comparison.isNull(this);
    }

    @Override
    public BooleanComparisonX isNotNull() {
        return XB.Numeric.Comparison.isNotNull(this);
    }

    @Override
    public BooleanComparisonX isEqualTo(Number y) {
        return XB.Numeric.Comparison.isEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isEqualTo(SpecialNumericValue y) {
        return XB.Numeric.Comparison.isEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isEqualTo(NumericExpression y) {
        return XB.Numeric.Comparison.isEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNotEqualTo(Number y) {
        return XB.Numeric.Comparison.isNotEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNotEqualTo(SpecialNumericValue y) {
        return XB.Numeric.Comparison.isNotEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNotEqualTo(NumericExpression y) {
        return XB.Numeric.Comparison.isNotEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isGreaterThan(Number y) {
        return XB.Numeric.Comparison.isGreaterThan((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isGreaterThan(SpecialNumericValue y) {
        return XB.Numeric.Comparison.isGreaterThan((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isGreaterThan(NumericExpression y) {
        return XB.Numeric.Comparison.isGreaterThan((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isGreaterOrEqualTo(Number y) {
        return XB.Numeric.Comparison.isGreaterOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isGreaterOrEqualTo(SpecialNumericValue y) {
        return XB.Numeric.Comparison.isGreaterOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isGreaterOrEqualTo(NumericExpression y) {
        return XB.Numeric.Comparison.isGreaterOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isLessThan(Number y) {
        return XB.Numeric.Comparison.isLessThan((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isLessThan(SpecialNumericValue y) {
        return XB.Numeric.Comparison.isLessThan((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isLessThan(NumericExpression y) {
        return XB.Numeric.Comparison.isLessThan((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isLessOrEqualTo(Number y) {
        return XB.Numeric.Comparison.isLessOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isLessOrEqualTo(SpecialNumericValue y) {
        return XB.Numeric.Comparison.isLessOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isLessOrEqualTo(NumericExpression y) {
        return XB.Numeric.Comparison.isLessOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isIn(NumericExpression ... y) {
        return XB.Numeric.Comparison.isIn((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNotIn(NumericExpression ... y) {
        return XB.Numeric.Comparison.isNotIn((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isBetween(NumericExpression minimo, NumericExpression maximo) {
        return XB.Numeric.Comparison.isBetween(this, minimo, maximo);
    }

    @Override
    public BooleanComparisonX isNotBetween(NumericExpression minimo, NumericExpression maximo) {
        return XB.Numeric.Comparison.isNotBetween(this, minimo, maximo);
    }

    @Override
    public BooleanComparisonX isNullOrEqualTo(Number y) {
        return XB.Numeric.Comparison.isNullOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrEqualTo(SpecialNumericValue y) {
        return XB.Numeric.Comparison.isNullOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrEqualTo(NumericExpression y) {
        return XB.Numeric.Comparison.isNullOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrNotEqualTo(Number y) {
        return XB.Numeric.Comparison.isNullOrNotEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrNotEqualTo(SpecialNumericValue y) {
        return XB.Numeric.Comparison.isNullOrNotEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrNotEqualTo(NumericExpression y) {
        return XB.Numeric.Comparison.isNullOrNotEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrGreaterThan(Number y) {
        return XB.Numeric.Comparison.isNullOrGreaterThan((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrGreaterThan(SpecialNumericValue y) {
        return XB.Numeric.Comparison.isNullOrGreaterThan((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrGreaterThan(NumericExpression y) {
        return XB.Numeric.Comparison.isNullOrGreaterThan((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrGreaterOrEqualTo(Number y) {
        return XB.Numeric.Comparison.isNullOrGreaterOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrGreaterOrEqualTo(SpecialNumericValue y) {
        return XB.Numeric.Comparison.isNullOrGreaterOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrGreaterOrEqualTo(NumericExpression y) {
        return XB.Numeric.Comparison.isNullOrGreaterOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrLessThan(Number y) {
        return XB.Numeric.Comparison.isNullOrLessThan((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrLessThan(SpecialNumericValue y) {
        return XB.Numeric.Comparison.isNullOrLessThan((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrLessThan(NumericExpression y) {
        return XB.Numeric.Comparison.isNullOrLessThan((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrLessOrEqualTo(Number y) {
        return XB.Numeric.Comparison.isNullOrLessOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrLessOrEqualTo(SpecialNumericValue y) {
        return XB.Numeric.Comparison.isNullOrLessOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrLessOrEqualTo(NumericExpression y) {
        return XB.Numeric.Comparison.isNullOrLessOrEqualTo((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrIn(NumericExpression ... y) {
        return XB.Numeric.Comparison.isNullOrIn((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrNotIn(NumericExpression ... y) {
        return XB.Numeric.Comparison.isNullOrNotIn((NumericExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrBetween(NumericExpression minimo, NumericExpression maximo) {
        return XB.Numeric.Comparison.isNullOrBetween(this, minimo, maximo);
    }

    @Override
    public BooleanComparisonX isNullOrNotBetween(NumericExpression minimo, NumericExpression maximo) {
        return XB.Numeric.Comparison.isNullOrNotBetween(this, minimo, maximo);
    }

    @Override
    public NumericOrderedPairX coalesce(Number y) {
        return XB.Numeric.OrderedPair.coalesce((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX coalesce(SpecialNumericValue y) {
        return XB.Numeric.OrderedPair.coalesce((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX coalesce(NumericExpression y) {
        return XB.Numeric.OrderedPair.coalesce((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX nullIf(Number y) {
        return XB.Numeric.OrderedPair.nullIf((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX nullIf(SpecialNumericValue y) {
        return XB.Numeric.OrderedPair.nullIf((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX nullIf(NumericExpression y) {
        return XB.Numeric.OrderedPair.nullIf((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX max(Number y) {
        return XB.Numeric.OrderedPair.max((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX max(SpecialNumericValue y) {
        return XB.Numeric.OrderedPair.max((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX max(NumericExpression y) {
        return XB.Numeric.OrderedPair.max((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX min(Number y) {
        return XB.Numeric.OrderedPair.min((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX min(SpecialNumericValue y) {
        return XB.Numeric.OrderedPair.min((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX min(NumericExpression y) {
        return XB.Numeric.OrderedPair.min((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX plus(Number y) {
        return XB.Numeric.OrderedPair.xPlusY((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX plus(SpecialNumericValue y) {
        return XB.Numeric.OrderedPair.xPlusY((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX plus(NumericExpression y) {
        return XB.Numeric.OrderedPair.xPlusY((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX minus(Number y) {
        return XB.Numeric.OrderedPair.xMinusY((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX minus(SpecialNumericValue y) {
        return XB.Numeric.OrderedPair.xMinusY((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX minus(NumericExpression y) {
        return XB.Numeric.OrderedPair.xMinusY((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX times(Number y) {
        return XB.Numeric.OrderedPair.xTimesY((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX times(SpecialNumericValue y) {
        return XB.Numeric.OrderedPair.xTimesY((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX times(NumericExpression y) {
        return XB.Numeric.OrderedPair.xTimesY((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX over(Number y) {
        return XB.Numeric.OrderedPair.xOverY((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX over(SpecialNumericValue y) {
        return XB.Numeric.OrderedPair.xOverY((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX over(NumericExpression y) {
        return XB.Numeric.OrderedPair.xOverY((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX toThe(Number y) {
        return XB.Numeric.OrderedPair.xToTheY((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX toThe(SpecialNumericValue y) {
        return XB.Numeric.OrderedPair.xToTheY((NumericExpression)this, y);
    }

    @Override
    public NumericOrderedPairX toThe(NumericExpression y) {
        return XB.Numeric.OrderedPair.xToTheY((NumericExpression)this, y);
    }

    @Override
    public NumericScalarX defaultWhenNull() {
        return XB.Numeric.Scalar.defaultWhenNull(this);
    }

    @Override
    public NumericScalarX nullWhenDefault() {
        return XB.Numeric.Scalar.nullWhenDefault(this);
    }

    @Override
    public NumericScalarX abs() {
        return XB.Numeric.Scalar.abs(this);
    }

    @Override
    public NumericScalarX chs() {
        return XB.Numeric.Scalar.chs(this);
    }

    @Override
    public NumericScalarX inv() {
        return XB.Numeric.Scalar.inv(this);
    }

    @Override
    public NumericScalarX toBigDecimal() {
        return XB.Numeric.Scalar.toBigDecimal(this);
    }

    @Override
    public NumericScalarX toBigInteger() {
        return XB.Numeric.Scalar.toBigInteger(this);
    }

    @Override
    public NumericScalarX toByte() {
        return XB.Numeric.Scalar.toByte(this);
    }

    @Override
    public NumericScalarX toShort() {
        return XB.Numeric.Scalar.toShort(this);
    }

    @Override
    public NumericScalarX toInteger() {
        return XB.Numeric.Scalar.toInteger(this);
    }

    @Override
    public NumericScalarX toLong() {
        return XB.Numeric.Scalar.toLong(this);
    }

    @Override
    public NumericScalarX toDouble() {
        return XB.Numeric.Scalar.toDouble(this);
    }

    @Override
    public NumericScalarX toFloat() {
        return XB.Numeric.Scalar.toFloat(this);
    }

    @Override
    public CharacterScalarX toCharString() {
        return XB.Character.Scalar.toCharString(this);
    }

    @Override
    public CharacterScalarX toLocaleString() {
        return XB.Character.Scalar.toLocaleString(this);
    }

    @Override
    public CharacterOrderedPairX toZeroPaddedString(NumericExpression len) {
        return XB.Character.OrderedPair.toZeroPaddedString((NumericExpression)this, len);
    }

    @Override
    public CharacterOrderedPairX toZeroPaddedString(int len) {
        return XB.Character.OrderedPair.toZeroPaddedString((NumericExpression)this, len);
    }
}

