/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.primitives;

import adalid.commons.util.TimeUtils;
import adalid.core.NativeQuerySegment;
import adalid.core.Primitive;
import adalid.core.XS2;
import adalid.core.enums.ScalarOp;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.expressions.BooleanComparisonX;
import adalid.core.expressions.CharacterScalarX;
import adalid.core.expressions.NumericOrderedPairX;
import adalid.core.expressions.NumericScalarX;
import adalid.core.expressions.TemporalOrderedPairX;
import adalid.core.expressions.TemporalScalarX;
import adalid.core.expressions.XB;
import adalid.core.interfaces.IntervalizedArtifact;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Operator;
import adalid.core.interfaces.TemporalExpression;
import adalid.core.sql.NativeQuery;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public abstract class TemporalPrimitive
extends Primitive
implements IntervalizedArtifact,
TemporalExpression {
    private static final Calendar calendar = Calendar.getInstance();
    private Object _calculableValue;
    private Object _initialValue;
    private Object _defaultValue;
    private Object _currentValue;
    private Object _minValue;
    private Object _maxValue;
    private java.util.Date _minDate;
    private java.util.Date _maxDate;
    private final Map<Locale, String> _localizedRangeErrorMessage = new LinkedHashMap<Locale, String>();
    private String _specialConverterName;
    private String _specialValidatorName;

    public static long getEpochInMillis() {
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    private Class<? extends java.util.Date> dataType() {
        return this.getDataType();
    }

    @Override
    public Object getCalculableValue() {
        return this.toDataType(this._calculableValue);
    }

    public void setCalculableValueExpression(TemporalExpression expression) {
        this._calculableValue = this.validCalculableValue(expression) ? expression : null;
    }

    @Override
    public Object getInitialValue() {
        return this.toDataType(this._initialValue);
    }

    public boolean isPrimitiveInitialValue() {
        return this._initialValue instanceof java.util.Date;
    }

    public boolean isSpecialInitialValue() {
        return this._initialValue instanceof SpecialTemporalValue;
    }

    public boolean isExpressInitialValue() {
        return this._initialValue instanceof TemporalExpression;
    }

    public boolean isDefinedInitialValue() {
        return this._initialValue != null;
    }

    public void setInitialValue(String initialValue) {
        this.setInitialValue(TimeUtils.jdbcObject(initialValue, this.dataType()));
    }

    public void setInitialValue(java.util.Date initialValue) {
        this._initialValue = this.validInitialValue(initialValue) ? initialValue : null;
    }

    public void setInitialValue(SpecialTemporalValue initialValue) {
        this._initialValue = this.validInitialValue(initialValue) ? initialValue : null;
    }

    public void setInitialValue(TemporalExpression initialValue) {
        this._initialValue = this.validInitialValue(initialValue) ? initialValue : null;
    }

    @Override
    public Object getDefaultValue() {
        return this.toDataType(this._defaultValue);
    }

    public boolean isPrimitiveDefaultValue() {
        return this._defaultValue instanceof java.util.Date;
    }

    public boolean isSpecialDefaultValue() {
        return this._defaultValue instanceof SpecialTemporalValue;
    }

    public boolean isExpressDefaultValue() {
        return this._defaultValue instanceof TemporalExpression;
    }

    public boolean isDefinedDefaultValue() {
        return this._defaultValue != null;
    }

    public void setDefaultValue(String defaultValue) {
        this.setDefaultValue(TimeUtils.jdbcObject(defaultValue, this.dataType()));
    }

    public void setDefaultValue(java.util.Date defaultValue) {
        this._defaultValue = this.validDefaultValue(defaultValue) ? defaultValue : null;
    }

    public void setDefaultValue(SpecialTemporalValue defaultValue) {
        this._defaultValue = this.validDefaultValue(defaultValue) ? defaultValue : null;
    }

    public void setDefaultValue(TemporalExpression defaultValue) {
        this._defaultValue = this.validDefaultValue(defaultValue) ? defaultValue : null;
    }

    @Override
    public Object getCurrentValue() {
        return this.toDataType(this._currentValue);
    }

    public boolean isPrimitiveCurrentValue() {
        return this._currentValue instanceof java.util.Date;
    }

    public boolean isSpecialCurrentValue() {
        return this._currentValue instanceof SpecialTemporalValue;
    }

    public boolean isExpressCurrentValue() {
        return this._currentValue instanceof TemporalExpression;
    }

    public boolean isDefinedCurrentValue() {
        return this._currentValue != null;
    }

    public void setCurrentValue(String currentValue) {
        this.setCurrentValue(TimeUtils.jdbcObject(currentValue, this.dataType()));
    }

    public void setCurrentValue(java.util.Date currentValue) {
        this._currentValue = this.validCurrentValue(currentValue) ? currentValue : null;
    }

    public void setCurrentValue(SpecialTemporalValue currentValue) {
        this._currentValue = this.validCurrentValue(currentValue) ? currentValue : null;
    }

    public void setCurrentValue(TemporalExpression currentValue) {
        this._currentValue = this.validCurrentValue(currentValue) ? currentValue : null;
    }

    @Override
    public Object getMinValue() {
        return this._minValue == null ? this._minDate : (this._minValue instanceof java.util.Date ? this.primitiveMinValue() : this.toDataType(this._minValue));
    }

    public java.util.Date getPrimitiveMinValue() {
        return this._minValue == null ? this._minDate : (this._minValue instanceof java.util.Date ? this.primitiveMinValue() : this._minDate);
    }

    private java.util.Date primitiveMinValue() {
        java.util.Date value = (java.util.Date)this._minValue;
        return this._minDate == null ? value : (value.compareTo(this._minDate) > 0 ? value : this._minDate);
    }

    public boolean isPrimitiveMinValue() {
        return this._minValue == null ? this._minDate != null : this._minValue instanceof java.util.Date;
    }

    public boolean isSpecialMinValue() {
        return this._minValue instanceof SpecialTemporalValue;
    }

    public boolean isExpressMinValue() {
        return this._minValue instanceof TemporalExpression;
    }

    public boolean isDefinedMinValue() {
        return this._minValue != null;
    }

    public void setMinValue(String minValue) {
        this.setMinValue(TimeUtils.jdbcObject(minValue, this.dataType()));
    }

    public void setMinValue(java.util.Date minValue) {
        this._minValue = minValue;
    }

    public void setMinValue(SpecialTemporalValue minValue) {
        this._minValue = minValue;
    }

    public void setMinValue(TemporalExpression minValue) {
        this._minValue = this.validMinimumValue(minValue) ? minValue : null;
    }

    @Override
    public Object getMaxValue() {
        return this._maxValue == null ? this._maxDate : (this._maxValue instanceof java.util.Date ? this.primitiveMaxValue() : this.toDataType(this._maxValue));
    }

    public java.util.Date getPrimitiveMaxValue() {
        return this._maxValue == null ? this._maxDate : (this._maxValue instanceof java.util.Date ? this.primitiveMaxValue() : this._maxDate);
    }

    private java.util.Date primitiveMaxValue() {
        java.util.Date value = (java.util.Date)this._maxValue;
        return this._maxDate == null ? value : (value.compareTo(this._maxDate) < 0 ? value : this._maxDate);
    }

    public boolean isPrimitiveMaxValue() {
        return this._maxValue == null ? this._maxDate != null : this._maxValue instanceof java.util.Date;
    }

    public boolean isSpecialMaxValue() {
        return this._maxValue instanceof SpecialTemporalValue;
    }

    public boolean isExpressMaxValue() {
        return this._maxValue instanceof TemporalExpression;
    }

    public boolean isDefinedMaxValue() {
        return this._maxValue != null;
    }

    public void setMaxValue(String maxValue) {
        this.setMaxValue(TimeUtils.jdbcObject(maxValue, this.dataType()));
    }

    public void setMaxValue(java.util.Date maxValue) {
        this._maxValue = maxValue;
    }

    public void setMaxValue(SpecialTemporalValue maxValue) {
        this._maxValue = maxValue;
    }

    public void setMaxValue(TemporalExpression maxValue) {
        this._maxValue = this.validMaximumValue(maxValue) ? maxValue : null;
    }

    public java.util.Date getMinDate() {
        return this._minDate;
    }

    protected void setMinDate(java.util.Date minDate) {
        this._minDate = minDate;
    }

    public java.util.Date getMaxDate() {
        return this._maxDate;
    }

    protected void setMaxDate(java.util.Date maxDate) {
        this._maxDate = maxDate;
    }

    private Object toDataType(Object value) {
        if (value instanceof TemporalExpression) {
            TemporalExpression tx = (TemporalExpression)value;
            Operator txop = tx.getOperator();
            Class<?> txdt = tx instanceof TemporalPrimitive ? tx.getDataType() : null;
            Class<?> mydt = this.getDataType();
            if (mydt != null && !mydt.equals(txdt) && txop != null) {
                if (Date.class.isAssignableFrom(mydt)) {
                    if (!ScalarOp.TO_DATE.equals(txop)) {
                        return tx.toDate();
                    }
                } else if (Time.class.isAssignableFrom(mydt)) {
                    if (!ScalarOp.TO_TIME.equals(txop)) {
                        return tx.toTime();
                    }
                } else if (Timestamp.class.isAssignableFrom(mydt) && !ScalarOp.TO_TIMESTAMP.equals(txop)) {
                    return tx.toTimestamp();
                }
            }
        }
        return value;
    }

    @Override
    public String getDefaultRangeErrorMessage() {
        return this.getLocalizedRangeErrorMessage(null);
    }

    @Override
    public void setDefaultRangeErrorMessage(String message) {
        this.setLocalizedRangeErrorMessage(null, message);
    }

    @Override
    public String getLocalizedRangeErrorMessage(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedRangeErrorMessage.get(l);
    }

    @Override
    public void setLocalizedRangeErrorMessage(Locale locale, String message) {
        Locale l = this.localeWritingKey(locale);
        if (message == null) {
            this._localizedRangeErrorMessage.remove(l);
        } else {
            this._localizedRangeErrorMessage.put(l, message);
        }
    }

    public String getSpecialConverterName() {
        return this._specialConverterName;
    }

    public void setSpecialConverterName(String converter) {
        XS2.checkAccess();
        this._specialConverterName = converter;
    }

    public String getSpecialValidatorName() {
        return this._specialValidatorName;
    }

    public void setSpecialValidatorName(String validator) {
        XS2.checkAccess();
        this._specialValidatorName = validator;
    }

    public NativeQuerySegment isIn(NativeQuery y) {
        return NativeQuerySegment.of(XB.Temporal.Comparison.isIn((TemporalExpression)this, y));
    }

    public NativeQuerySegment isNotIn(NativeQuery y) {
        return NativeQuerySegment.of(XB.Temporal.Comparison.isNotIn((TemporalExpression)this, y));
    }

    @Override
    public BooleanComparisonX isNull() {
        return XB.Temporal.Comparison.isNull(this);
    }

    @Override
    public BooleanComparisonX isNotNull() {
        return XB.Temporal.Comparison.isNotNull(this);
    }

    @Override
    public BooleanComparisonX isEqualTo(java.util.Date y) {
        return XB.Temporal.Comparison.isEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isEqualTo(SpecialTemporalValue y) {
        return XB.Temporal.Comparison.isEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isEqualTo(TemporalExpression y) {
        return XB.Temporal.Comparison.isEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNotEqualTo(java.util.Date y) {
        return XB.Temporal.Comparison.isNotEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNotEqualTo(SpecialTemporalValue y) {
        return XB.Temporal.Comparison.isNotEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNotEqualTo(TemporalExpression y) {
        return XB.Temporal.Comparison.isNotEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isGreaterThan(java.util.Date y) {
        return XB.Temporal.Comparison.isGreaterThan((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isGreaterThan(SpecialTemporalValue y) {
        return XB.Temporal.Comparison.isGreaterThan((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isGreaterThan(TemporalExpression y) {
        return XB.Temporal.Comparison.isGreaterThan((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isGreaterOrEqualTo(java.util.Date y) {
        return XB.Temporal.Comparison.isGreaterOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isGreaterOrEqualTo(SpecialTemporalValue y) {
        return XB.Temporal.Comparison.isGreaterOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isGreaterOrEqualTo(TemporalExpression y) {
        return XB.Temporal.Comparison.isGreaterOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isLessThan(java.util.Date y) {
        return XB.Temporal.Comparison.isLessThan((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isLessThan(SpecialTemporalValue y) {
        return XB.Temporal.Comparison.isLessThan((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isLessThan(TemporalExpression y) {
        return XB.Temporal.Comparison.isLessThan((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isLessOrEqualTo(java.util.Date y) {
        return XB.Temporal.Comparison.isLessOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isLessOrEqualTo(SpecialTemporalValue y) {
        return XB.Temporal.Comparison.isLessOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isLessOrEqualTo(TemporalExpression y) {
        return XB.Temporal.Comparison.isLessOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isIn(TemporalExpression ... y) {
        return XB.Temporal.Comparison.isIn((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNotIn(TemporalExpression ... y) {
        return XB.Temporal.Comparison.isNotIn((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isBetween(TemporalExpression minimo, TemporalExpression maximo) {
        return XB.Temporal.Comparison.isBetween(this, minimo, maximo);
    }

    @Override
    public BooleanComparisonX isNotBetween(TemporalExpression minimo, TemporalExpression maximo) {
        return XB.Temporal.Comparison.isNotBetween(this, minimo, maximo);
    }

    @Override
    public BooleanComparisonX isNullOrEqualTo(java.util.Date y) {
        return XB.Temporal.Comparison.isNullOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrEqualTo(SpecialTemporalValue y) {
        return XB.Temporal.Comparison.isNullOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrEqualTo(TemporalExpression y) {
        return XB.Temporal.Comparison.isNullOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrNotEqualTo(java.util.Date y) {
        return XB.Temporal.Comparison.isNullOrNotEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrNotEqualTo(SpecialTemporalValue y) {
        return XB.Temporal.Comparison.isNullOrNotEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrNotEqualTo(TemporalExpression y) {
        return XB.Temporal.Comparison.isNullOrNotEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrGreaterThan(java.util.Date y) {
        return XB.Temporal.Comparison.isNullOrGreaterThan((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrGreaterThan(SpecialTemporalValue y) {
        return XB.Temporal.Comparison.isNullOrGreaterThan((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrGreaterThan(TemporalExpression y) {
        return XB.Temporal.Comparison.isNullOrGreaterThan((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrGreaterOrEqualTo(java.util.Date y) {
        return XB.Temporal.Comparison.isNullOrGreaterOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrGreaterOrEqualTo(SpecialTemporalValue y) {
        return XB.Temporal.Comparison.isNullOrGreaterOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrGreaterOrEqualTo(TemporalExpression y) {
        return XB.Temporal.Comparison.isNullOrGreaterOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrLessThan(java.util.Date y) {
        return XB.Temporal.Comparison.isNullOrLessThan((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrLessThan(SpecialTemporalValue y) {
        return XB.Temporal.Comparison.isNullOrLessThan((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrLessThan(TemporalExpression y) {
        return XB.Temporal.Comparison.isNullOrLessThan((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrLessOrEqualTo(java.util.Date y) {
        return XB.Temporal.Comparison.isNullOrLessOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrLessOrEqualTo(SpecialTemporalValue y) {
        return XB.Temporal.Comparison.isNullOrLessOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrLessOrEqualTo(TemporalExpression y) {
        return XB.Temporal.Comparison.isNullOrLessOrEqualTo((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrIn(TemporalExpression ... y) {
        return XB.Temporal.Comparison.isNullOrIn((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrNotIn(TemporalExpression ... y) {
        return XB.Temporal.Comparison.isNullOrNotIn((TemporalExpression)this, y);
    }

    @Override
    public BooleanComparisonX isNullOrBetween(TemporalExpression minimo, TemporalExpression maximo) {
        return XB.Temporal.Comparison.isNullOrBetween(this, minimo, maximo);
    }

    @Override
    public BooleanComparisonX isNullOrNotBetween(TemporalExpression minimo, TemporalExpression maximo) {
        return XB.Temporal.Comparison.isNullOrNotBetween(this, minimo, maximo);
    }

    @Override
    public TemporalOrderedPairX coalesce(java.util.Date y) {
        return XB.Temporal.OrderedPair.coalesce((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX coalesce(SpecialTemporalValue y) {
        return XB.Temporal.OrderedPair.coalesce((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX coalesce(TemporalExpression y) {
        return XB.Temporal.OrderedPair.coalesce((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX nullIf(java.util.Date y) {
        return XB.Temporal.OrderedPair.nullIf((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX nullIf(SpecialTemporalValue y) {
        return XB.Temporal.OrderedPair.nullIf((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX nullIf(TemporalExpression y) {
        return XB.Temporal.OrderedPair.nullIf((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX max(java.util.Date y) {
        return XB.Temporal.OrderedPair.max((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX max(SpecialTemporalValue y) {
        return XB.Temporal.OrderedPair.max((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX max(TemporalExpression y) {
        return XB.Temporal.OrderedPair.max((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX min(java.util.Date y) {
        return XB.Temporal.OrderedPair.min((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX min(SpecialTemporalValue y) {
        return XB.Temporal.OrderedPair.min((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX min(TemporalExpression y) {
        return XB.Temporal.OrderedPair.min((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX addYears(Number y) {
        return XB.Temporal.OrderedPair.addYears((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX addYears(NumericExpression y) {
        return XB.Temporal.OrderedPair.addYears((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX addMonths(Number y) {
        return XB.Temporal.OrderedPair.addMonths((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX addMonths(NumericExpression y) {
        return XB.Temporal.OrderedPair.addMonths((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX addWeeks(Number y) {
        return XB.Temporal.OrderedPair.addWeeks((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX addWeeks(NumericExpression y) {
        return XB.Temporal.OrderedPair.addWeeks((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX addDays(Number y) {
        return XB.Temporal.OrderedPair.addDays((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX addDays(NumericExpression y) {
        return XB.Temporal.OrderedPair.addDays((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX addHours(Number y) {
        return XB.Temporal.OrderedPair.addHours((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX addHours(NumericExpression y) {
        return XB.Temporal.OrderedPair.addHours((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX addMinutes(Number y) {
        return XB.Temporal.OrderedPair.addMinutes((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX addMinutes(NumericExpression y) {
        return XB.Temporal.OrderedPair.addMinutes((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX addSeconds(Number y) {
        return XB.Temporal.OrderedPair.addSeconds((TemporalExpression)this, y);
    }

    @Override
    public TemporalOrderedPairX addSeconds(NumericExpression y) {
        return XB.Temporal.OrderedPair.addSeconds((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInYears(java.util.Date y) {
        return XB.Temporal.OrderedPair.diffInYears((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInYears(SpecialTemporalValue y) {
        return XB.Temporal.OrderedPair.diffInYears((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInYears(TemporalExpression y) {
        return XB.Temporal.OrderedPair.diffInYears((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInMonths(java.util.Date y) {
        return XB.Temporal.OrderedPair.diffInMonths((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInMonths(SpecialTemporalValue y) {
        return XB.Temporal.OrderedPair.diffInMonths((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInMonths(TemporalExpression y) {
        return XB.Temporal.OrderedPair.diffInMonths((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInWeeks(java.util.Date y) {
        return XB.Temporal.OrderedPair.diffInWeeks((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInWeeks(SpecialTemporalValue y) {
        return XB.Temporal.OrderedPair.diffInWeeks((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInWeeks(TemporalExpression y) {
        return XB.Temporal.OrderedPair.diffInWeeks((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInDays(java.util.Date y) {
        return XB.Temporal.OrderedPair.diffInDays((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInDays(SpecialTemporalValue y) {
        return XB.Temporal.OrderedPair.diffInDays((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInDays(TemporalExpression y) {
        return XB.Temporal.OrderedPair.diffInDays((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInHours(java.util.Date y) {
        return XB.Temporal.OrderedPair.diffInHours((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInHours(SpecialTemporalValue y) {
        return XB.Temporal.OrderedPair.diffInHours((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInHours(TemporalExpression y) {
        return XB.Temporal.OrderedPair.diffInHours((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInMinutes(java.util.Date y) {
        return XB.Temporal.OrderedPair.diffInMinutes((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInMinutes(SpecialTemporalValue y) {
        return XB.Temporal.OrderedPair.diffInMinutes((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInMinutes(TemporalExpression y) {
        return XB.Temporal.OrderedPair.diffInMinutes((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInSeconds(java.util.Date y) {
        return XB.Temporal.OrderedPair.diffInSeconds((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInSeconds(SpecialTemporalValue y) {
        return XB.Temporal.OrderedPair.diffInSeconds((TemporalExpression)this, y);
    }

    @Override
    public NumericOrderedPairX diffInSeconds(TemporalExpression y) {
        return XB.Temporal.OrderedPair.diffInSeconds((TemporalExpression)this, y);
    }

    @Override
    public TemporalScalarX defaultWhenNull() {
        return XB.Temporal.Scalar.defaultWhenNull(this);
    }

    @Override
    public TemporalScalarX nullWhenDefault() {
        return XB.Temporal.Scalar.nullWhenDefault(this);
    }

    @Override
    public TemporalScalarX toDate() {
        return XB.Temporal.Scalar.toDate(this);
    }

    @Override
    public TemporalScalarX toTime() {
        return XB.Temporal.Scalar.toTime(this);
    }

    @Override
    public TemporalScalarX toTimestamp() {
        return XB.Temporal.Scalar.toTimestamp(this);
    }

    @Override
    public TemporalScalarX firstDateOfMonth() {
        return XB.Temporal.Scalar.firstDateOfMonth(this);
    }

    @Override
    public TemporalScalarX firstDateOfQuarter() {
        return XB.Temporal.Scalar.firstDateOfQuarter(this);
    }

    @Override
    public TemporalScalarX firstDateOfSemester() {
        return XB.Temporal.Scalar.firstDateOfSemester(this);
    }

    @Override
    public TemporalScalarX firstDateOfYear() {
        return XB.Temporal.Scalar.firstDateOfYear(this);
    }

    @Override
    public TemporalScalarX lastDateOfMonth() {
        return XB.Temporal.Scalar.lastDateOfMonth(this);
    }

    @Override
    public TemporalScalarX lastDateOfQuarter() {
        return XB.Temporal.Scalar.lastDateOfQuarter(this);
    }

    @Override
    public TemporalScalarX lastDateOfSemester() {
        return XB.Temporal.Scalar.lastDateOfSemester(this);
    }

    @Override
    public TemporalScalarX lastDateOfYear() {
        return XB.Temporal.Scalar.lastDateOfYear(this);
    }

    @Override
    public CharacterScalarX toCharString() {
        return XB.Character.Scalar.toCharString(this);
    }

    @Override
    public CharacterScalarX toLocaleString() {
        return XB.Character.Scalar.toLocaleString(this);
    }

    @Override
    public NumericScalarX extractYear() {
        return XB.Temporal.Scalar.extractYear(this);
    }

    @Override
    public NumericScalarX extractMonth() {
        return XB.Temporal.Scalar.extractMonth(this);
    }

    @Override
    public NumericScalarX extractDay() {
        return XB.Temporal.Scalar.extractDay(this);
    }

    @Override
    public NumericScalarX extractHour() {
        return XB.Temporal.Scalar.extractHour(this);
    }

    @Override
    public NumericScalarX extractMinute() {
        return XB.Temporal.Scalar.extractMinute(this);
    }

    @Override
    public NumericScalarX extractSecond() {
        return XB.Temporal.Scalar.extractSecond(this);
    }
}

