/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.programmers;

import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.ObjUtils;
import adalid.commons.util.StrUtils;
import adalid.commons.util.TimeUtils;
import adalid.core.Instance;
import adalid.core.Operation;
import adalid.core.Primitive;
import adalid.core.Project;
import adalid.core.data.types.CharacterData;
import adalid.core.enums.ComparisonOp;
import adalid.core.enums.DataAggregateOp;
import adalid.core.enums.InheritanceMappingStrategy;
import adalid.core.enums.QueryJoinOp;
import adalid.core.enums.RowsAggregateOp;
import adalid.core.enums.ScalarOp;
import adalid.core.enums.SortOption;
import adalid.core.enums.SpecialBooleanValue;
import adalid.core.enums.SpecialCharacterValue;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.SpecialNumericValue;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.enums.SqlQualifierType;
import adalid.core.enums.StandardRelationalOp;
import adalid.core.enums.ViewFieldAggregation;
import adalid.core.enums.VirtualEntityType;
import adalid.core.expressions.VariantX;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CalculableProperty;
import adalid.core.interfaces.ComparisonX;
import adalid.core.interfaces.ConditionalX;
import adalid.core.interfaces.DataAggregateX;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NamedValue;
import adalid.core.interfaces.NaryVectorX;
import adalid.core.interfaces.Operator;
import adalid.core.interfaces.OrderedPairX;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.RowsAggregateX;
import adalid.core.interfaces.ScalarX;
import adalid.core.interfaces.Segment;
import adalid.core.interfaces.SqlProgrammer;
import adalid.core.interfaces.TypedArtifact;
import adalid.core.interfaces.ValuedArtifact;
import adalid.core.programmers.AbstractProgrammer;
import adalid.core.programmers.ParameterizedExpression;
import adalid.core.sql.NativeQuery;
import adalid.core.sql.QueryJoin;
import adalid.core.sql.QueryTable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractSqlProgrammer
extends AbstractProgrammer
implements SqlProgrammer {
    private static final Logger logger = Logger.getLogger(SqlProgrammer.class);
    private static final String EMPTY = "";
    private static final String EXPRESSION_DOLLAR_INFIX = "$";
    private static final String EXPRESSION_SELECT_INFIX = "$select_";
    protected static final ExtendedProperties bootstrapping = PropertiesHandler.getBootstrapping();
    protected static final String SEP$ = ",";
    protected static final String SEPX = ", ";
    private final String[] NEVER_NULL = new String[]{"current_user", "current_date", "current_time", "current_timestamp", "localtime", "localtimestamp"};
    private final Set<String> sqlComparisonExpressionMessages = new LinkedHashSet<String>();

    protected String getIsNull() {
        return "is null";
    }

    protected String getIsNotNull() {
        return "is not null";
    }

    protected String getIsTrue() {
        return "is true";
    }

    protected String getIsFalse() {
        return "is false";
    }

    protected String getEQ() {
        return "=";
    }

    protected String getNEQ() {
        return "<>";
    }

    protected String getGT() {
        return ">";
    }

    protected String getLTEQ() {
        return "<=";
    }

    protected String getGTEQ() {
        return ">=";
    }

    protected String getLT() {
        return "<";
    }

    protected String getLike() {
        return "like";
    }

    protected String getNotLike() {
        return "not like";
    }

    protected String getIn() {
        return "in";
    }

    protected String getNotIn() {
        return "not in";
    }

    protected String getIsNullOr() {
        return "is null or";
    }

    protected String getIsNotNullAnd() {
        return "is not null and";
    }

    protected String getBetween() {
        return "between";
    }

    protected String getNotBetween() {
        return "not between";
    }

    protected String getExists() {
        return "exists";
    }

    protected String getNotExists() {
        return "not exists";
    }

    protected String[] neverNull() {
        return this.NEVER_NULL;
    }

    protected boolean neverNull(String columna) {
        return ArrayUtils.contains((Object[])this.neverNull(), (Object)columna.toLowerCase());
    }

    protected String getIsNullOr(String columna) {
        return this.getIsNullOr(columna, false);
    }

    protected String getIsNullOr(String columna, boolean b) {
        Object columnb = b ? EMPTY : columna + " ";
        return this.neverNull(columna) ? columnb : columna + " " + this.getIsNullOr() + " " + (String)columnb;
    }

    protected String getIsNotNullAnd(String columna) {
        return this.getIsNotNullAnd(columna, false);
    }

    protected String getIsNotNullAnd(String columna, boolean b) {
        Object columnb = b ? EMPTY : columna + " ";
        return columnb;
    }

    protected abstract String getRestricted();

    protected abstract String getCascade();

    protected abstract String getNullify();

    protected abstract String getNoAction();

    protected String getInnerJoin() {
        return "inner join";
    }

    protected String getLeftJoin() {
        return "left outer join";
    }

    protected String getRightJoin() {
        return "right outer join";
    }

    protected String getFullJoin() {
        return "full join";
    }

    protected String getCrossJoin() {
        return "cross join";
    }

    protected String getDefaultJoin() {
        return "join";
    }

    protected String getCount() {
        return "count";
    }

    protected String getMaximum() {
        return "max";
    }

    protected String getMinimum() {
        return "min";
    }

    protected String getSum() {
        return "sum";
    }

    protected String getAverage() {
        return "avg";
    }

    protected String getConcat() {
        return "||";
    }

    protected String getAnd() {
        return "and";
    }

    protected String getOr() {
        return "or";
    }

    protected String getAdd() {
        return "+";
    }

    protected String getMultiply() {
        return "*";
    }

    protected String getCoalesce() {
        return "coalesce";
    }

    protected String getNot() {
        return "not";
    }

    protected String getModulus() {
        return "abs";
    }

    protected String getOpposite() {
        return "(-1)*";
    }

    protected String getReciprocal() {
        return "1/";
    }

    protected String getNz() {
        return "coalesce";
    }

    protected String getCast() {
        return "cast";
    }

    protected String getAscending() {
        return "asc";
    }

    protected String getDescending() {
        return "desc";
    }

    protected String getTrue() {
        return "true";
    }

    protected String getFalse() {
        return "false";
    }

    protected String getCurrentDate() {
        return "current_date";
    }

    protected String getCurrentTime() {
        return "current_time";
    }

    protected String getCurrentTimestamp() {
        return "current_timestamp";
    }

    protected String getNull() {
        return "null";
    }

    protected String getNotNull() {
        return "not null";
    }

    protected String getZeroChar() {
        return "' '";
    }

    protected String getZeroString() {
        return "''";
    }

    protected String getZeroNumber() {
        return "0";
    }

    protected String getZeroDate() {
        return "'1970-01-01'";
    }

    protected String getZeroTime() {
        return "'00:00:00'";
    }

    protected String getZeroTimestamp() {
        return "'1970-01-01 00:00:00'";
    }

    protected String getSelect() {
        return "select";
    }

    protected String getInto() {
        return "into";
    }

    protected String getFrom() {
        return "from";
    }

    protected String getAs() {
        return "as";
    }

    protected String getOn() {
        return "on";
    }

    protected String getWhere() {
        return "where";
    }

    protected String getOrderBy() {
        return "order by";
    }

    protected String getCase() {
        return "case";
    }

    protected String getWhen() {
        return "when";
    }

    protected String getThen() {
        return "then";
    }

    protected String getElse() {
        return "else";
    }

    protected String getEnd() {
        return "end";
    }

    protected String getCaseWhenThenPattern() {
        return "case when {0} then {1} end";
    }

    protected String getCaseWhenThenElsePattern() {
        return "case when {0} then {1} else {2} end";
    }

    protected String getLikeSingle() {
        return "_";
    }

    protected String getLikeString() {
        return "%";
    }

    protected String getVariablesPrefix() {
        return "_";
    }

    protected String getVariablesSuffix() {
        return EXPRESSION_DOLLAR_INFIX;
    }

    protected String getRecordVariableName() {
        return this.getSqlVariableName("record");
    }

    protected String getRecordVariableName(int index) {
        return this.getSqlVariableName("record" + index);
    }

    protected String getRowVariableName() {
        return this.getSqlVariableName("row");
    }

    protected String getRowVariableName(int index) {
        return this.getSqlVariableName("row" + index);
    }

    protected String getValueVariableName() {
        return this.getSqlVariableName("value");
    }

    protected String getValueVariableName(int index) {
        return this.getSqlVariableName("value" + index);
    }

    @Override
    public String getString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return obj.toString().replace("'", "''");
        }
        if (obj instanceof Date) {
            return TimeUtils.jdbcDateString(obj);
        }
        if (obj instanceof Time) {
            return TimeUtils.jdbcTimeString(obj);
        }
        if (obj instanceof java.util.Date) {
            return TimeUtils.jdbcTimestampString(obj);
        }
        return obj.toString();
    }

    @Override
    public String getDelimitedString(Object obj) {
        String string = this.getString(obj);
        if (string == null) {
            return null;
        }
        if (obj instanceof String) {
            return "'" + string + "'";
        }
        if (obj instanceof Date) {
            return "'" + string + "'";
        }
        if (obj instanceof Time) {
            return "'" + string + "'";
        }
        if (obj instanceof java.util.Date) {
            return "'" + string + "'";
        }
        return string;
    }

    public String escapeQuotes(String string) {
        return StringUtils.replace((String)string, (String)"'", (String)"''");
    }

    @Override
    public String getSqlIdentifier(String string) {
        return this.getSqlIdentifier(null, string, null);
    }

    @Override
    public String getSqlIdentifier(String prefix, String string, String suffix) {
        return StrUtils.getIdentificadorSql(prefix, string, suffix, this.getMaxIdentifierLength());
    }

    @Override
    public String getSqlishName(Artifact artifact) {
        return artifact == null ? null : this.getArtifactSqlName(artifact, 0);
    }

    @Override
    public String getSqlName(Artifact artifact) {
        int maxIdentifierLength = this.getMaxIdentifierLength();
        return this.getSqlName(null, artifact, null, maxIdentifierLength);
    }

    @Override
    public String getSqlName(Artifact artifact, int maxIdentifierLength) {
        return this.getSqlName(null, artifact, null, maxIdentifierLength);
    }

    @Override
    public String getSqlName(String prefix, Artifact artifact) {
        int maxIdentifierLength = this.getMaxIdentifierLength();
        return this.getSqlName(prefix, artifact, null, maxIdentifierLength);
    }

    @Override
    public String getSqlName(String prefix, Artifact artifact, int maxIdentifierLength) {
        return this.getSqlName(prefix, artifact, null, maxIdentifierLength);
    }

    @Override
    public String getSqlName(Artifact artifact, String suffix) {
        int maxIdentifierLength = this.getMaxIdentifierLength();
        return this.getSqlName(null, artifact, suffix, maxIdentifierLength);
    }

    @Override
    public String getSqlName(Artifact artifact, String suffix, int maxIdentifierLength) {
        return this.getSqlName(null, artifact, suffix, maxIdentifierLength);
    }

    @Override
    public String getSqlName(String prefix, Artifact artifact, String suffix) {
        int maxIdentifierLength = this.getMaxIdentifierLength();
        return this.getSqlName(prefix, artifact, suffix, maxIdentifierLength);
    }

    @Override
    public String getSqlName(String prefix, Artifact artifact, String suffix, int maxIdentifierLength) {
        String fullName = this.getFullLengthSqlName(artifact);
        if (fullName == null) {
            return null;
        }
        String lowerPrefix = prefix == null ? null : StrUtils.getLowerHumplessCase(prefix);
        String lowerSuffix = suffix == null ? null : StrUtils.getLowerHumplessCase(suffix);
        int max = this.getMaxIdentifierLength(maxIdentifierLength);
        return StrUtils.getIdentificadorSql(lowerPrefix, fullName, lowerSuffix, max);
    }

    private String getFullLengthSqlName(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        String sqlName = artifact.getSqlName();
        if (StringUtils.isNotBlank((String)sqlName)) {
            return StrUtils.getLowerHumplessCase(sqlName);
        }
        return artifact instanceof Property ? this.getPropertySqlName(artifact, 0) : this.getArtifactSqlName(artifact, 0);
    }

    private int getMaxIdentifierLength(int maxIdentifierLength) {
        int mil = this.getMaxIdentifierLength();
        return Math.max(Math.min(maxIdentifierLength, mil), 0);
    }

    @Override
    public String getSqlAlias(Property property, QueryTable queryTable) {
        if (property == null || queryTable == null) {
            return null;
        }
        int index = queryTable.getSubqueryIndex();
        for (Property p : queryTable.getColumns()) {
            if (p != property) continue;
            String name = index == 0 ? this.getPropertySqlName(p) : this.getPropertySqlAlias(p, queryTable);
            return name;
        }
        for (QueryJoin j : queryTable.getJoins()) {
            String name = this.getSqlAlias(property, j.getRightTable());
            if (name == null) continue;
            return name;
        }
        return null;
    }

    @Override
    public Property getProperty(String sqlAlias, QueryTable queryTable) {
        if (sqlAlias == null || queryTable == null) {
            return null;
        }
        for (Property p : queryTable.getColumns()) {
            String alias = this.getSqlAlias(p, queryTable);
            if (!sqlAlias.equals(alias)) continue;
            return p;
        }
        for (QueryJoin j : queryTable.getJoins()) {
            Property p = this.getProperty(sqlAlias, j.getRightTable());
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @Override
    public String getSqlQualifiedName(Property property, QueryTable queryTable) {
        if (property == null || queryTable == null) {
            return null;
        }
        boolean calculable = property.isCalculable();
        if (calculable) {
            String expression = this.getCalculableColumnValueExpression(queryTable, property);
            if (expression != null) {
                return expression;
            }
        } else {
            QueryTable qt = queryTable.containingQueryTableOf(property);
            if (qt != null) {
                String name = qt.getAlias() + "." + this.getPropertySqlName(property);
                return name;
            }
        }
        return null;
    }

    private String getPropertySqlAlias(Property property, QueryTable queryTable) {
        String prefix = queryTable.getPrefix();
        String string = this.getSqlName((Artifact)property, 0);
        String suffix = queryTable.getSuffix();
        return this.getSqlIdentifier(prefix, string, suffix);
    }

    private String getPropertySqlName(Artifact artifact) {
        int maxIdentifierLength = this.getMaxIdentifierLength();
        return this.getPropertySqlName(artifact, maxIdentifierLength);
    }

    private String getPropertySqlName(Artifact artifact, int maxIdentifierLength) {
        String sqlName = artifact.getSqlName();
        if (StringUtils.isNotBlank((String)sqlName)) {
            return StrUtils.getIdentificadorSql(StrUtils.getLowerHumplessCase(sqlName), maxIdentifierLength);
        }
        String name = this.getArtifactFixedCaseName(artifact);
        PersistentEntity pent = artifact.getDeclaringFieldPersistentEntityRoot();
        if (pent != null) {
            String discriminatorValue = pent.getDiscriminatorValue();
            boolean notTable = pent.isNotTable();
            boolean discriminated = StringUtils.isNotBlank((String)discriminatorValue);
            if (notTable && discriminated) {
                String prefix = EMPTY;
                String string = StrUtils.getLowerHumplessCase(name);
                String suffix = "_x" + discriminatorValue.toLowerCase();
                return StrUtils.getIdentificadorSql(prefix, string, suffix, maxIdentifierLength);
            }
        }
        return StrUtils.getIdentificadorSql(StrUtils.getLowerHumplessCase(name), maxIdentifierLength);
    }

    private String getArtifactSqlName(Artifact artifact, int maxIdentifierLength) {
        String name = this.getArtifactFixedCaseName(artifact);
        return StrUtils.getIdentificadorSql(StrUtils.getLowerHumplessCase(name), maxIdentifierLength);
    }

    private String getArtifactFixedCaseName(Artifact artifact) {
        String NAME;
        String name = artifact.getName();
        return StringUtils.equals((String)name, (String)(NAME = StringUtils.upperCase((String)name))) ? StringUtils.lowerCase((String)name) : name;
    }

    private String getSqlParameterName(Artifact artifact) {
        return "${" + this.getSqlQualifiedName(artifact) + "}";
    }

    @Override
    public String getSqlQualifiedName(Artifact artifact) {
        Object p;
        if (artifact.getDeclaringField() == null || artifact.getDeclaringArtifact() == null) {
            p = this.getSqlName(artifact);
        } else {
            p = this.getSqlQualifiedName(artifact.getDeclaringArtifact()) + "." + this.getSqlName(artifact);
            if (artifact.getDeclaringField().getType().isArray()) {
                p = (String)p + "_" + artifact.getDeclaringFieldIndex();
            }
            p = StringUtils.removeStart((String)p, (String)".");
        }
        return p;
    }

    @Override
    public String getSqlVariableName(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        String prefix = this.getVariablesPrefix();
        String suffix = this.getVariablesSuffix();
        return this.getSqlName(prefix, artifact, suffix);
    }

    @Override
    public String getSqlVariableName(String name) {
        if (name == null) {
            return null;
        }
        String prefix = this.getVariablesPrefix();
        String string = StrUtils.getLowerHumplessCase(name);
        String suffix = this.getVariablesSuffix();
        return this.getSqlIdentifier(prefix, string, suffix);
    }

    @Override
    public String getSqlDiscriminatorValue(PersistentEntity entity) {
        Property discriminatorProperty = entity.getDiscriminatorProperty();
        if (discriminatorProperty != null) {
            String discriminatorValue = entity.getDiscriminatorValue();
            if (discriminatorValue != null) {
                Class<?> dataClass = discriminatorProperty.getDataClass();
                if (CharacterData.class.isAssignableFrom(dataClass)) {
                    return "'" + discriminatorValue + "'";
                }
                return discriminatorValue;
            }
            if (entity.isAbstractClass()) {
                return null;
            }
            return this.getNull();
        }
        return null;
    }

    @Override
    public List<String> getSqlDiscriminatorValues(PersistentEntity entity) {
        ArrayList<String> values = new ArrayList<String>();
        String value = this.getSqlDiscriminatorValue(entity);
        if (value != null) {
            values.add(value);
        }
        List<Entity> extensionsList = entity.getExtensionsList();
        for (Entity ext : extensionsList) {
            PersistentEntity pent;
            if (!(ext instanceof PersistentEntity) || (value = this.getSqlDiscriminatorValue(pent = (PersistentEntity)ext)) == null) continue;
            values.add(value);
        }
        Collections.sort(values);
        return values;
    }

    @Override
    public String getSqlSchemaName(PersistentEntity entity) {
        Entity base = entity.getBaseRoot();
        PersistentEntity pent = base instanceof PersistentEntity ? (PersistentEntity)base : null;
        InheritanceMappingStrategy ims = pent == null ? null : pent.getInheritanceMappingStrategy();
        return InheritanceMappingStrategy.SINGLE_TABLE.equals((Object)ims) ? this.getSqlSchemaName(pent) : StringUtils.trimToEmpty((String)entity.getSchema());
    }

    @Override
    public String getSqlTableName(PersistentEntity entity) {
        Entity base = entity.getBaseRoot();
        PersistentEntity pent = base instanceof PersistentEntity ? (PersistentEntity)base : null;
        InheritanceMappingStrategy ims = pent == null ? null : pent.getInheritanceMappingStrategy();
        return InheritanceMappingStrategy.SINGLE_TABLE.equals((Object)ims) ? this.getSqlTableName(pent) : this.getSqlName(entity.getRoot());
    }

    @Override
    public String getSqlFunctionName(ViewFieldAggregation aggregation) {
        if (aggregation == null) {
            return null;
        }
        switch (aggregation) {
            case COUNT: {
                return "COUNT";
            }
            case MINIMUM: {
                return "MIN";
            }
            case MAXIMUM: {
                return "MAX";
            }
            case SUM: {
                return "SUM";
            }
            case AVERAGE: {
                return "AVG";
            }
            case DEVIATION: {
                return "STDDEV";
            }
        }
        return "COUNT";
    }

    @Override
    public String getSqlSchemaQualifier(PersistentEntity entity) {
        String schema = this.getSqlSchemaName(entity);
        return StringUtils.isBlank((String)schema) ? EMPTY : schema.trim() + ".";
    }

    @Override
    public String getSqlSchemaQualifiedName(PersistentEntity entity) {
        return StrUtils.getQualifiedName(this.getSqlName(entity), this.getSqlSchemaName(entity));
    }

    @Override
    public String getSqlSchemaQualifiedShortName(PersistentEntity entity) {
        return StrUtils.getQualifiedShortName(this.getSqlName(entity), this.getSqlSchemaName(entity));
    }

    @Override
    public String getSqlSchemaUnqualifiedShortName(PersistentEntity entity) {
        return StrUtils.getUnqualifiedShortName(this.getSqlName(entity), this.getSqlSchemaName(entity));
    }

    @Override
    public String getSqlSchemaQualifiedTableName(PersistentEntity entity) {
        return StrUtils.getQualifiedName(this.getSqlTableName(entity), this.getSqlSchemaName(entity));
    }

    @Override
    public String getSqlSchemaQualifiedShortTableName(PersistentEntity entity) {
        return StrUtils.getQualifiedShortName(this.getSqlTableName(entity), this.getSqlSchemaName(entity));
    }

    @Override
    public String getSqlSchemaUnqualifiedShortTableName(PersistentEntity entity) {
        return StrUtils.getUnqualifiedShortName(this.getSqlTableName(entity), this.getSqlSchemaName(entity));
    }

    @Override
    public String getSqlNull(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        if (artifact instanceof Property) {
            return this.getSqlNull((Property)artifact);
        }
        return null;
    }

    private String getSqlNull(Property p) {
        if (p.isNullable()) {
            return EMPTY;
        }
        PersistentEntity declaringEntity = p.getDeclaringPersistentEntityRoot();
        return declaringEntity != null && declaringEntity.isTable() ? this.getNotNull() : EMPTY;
    }

    @Override
    public String getSqlInitialValue(Artifact artifact) {
        QueryTable queryTable = null;
        return this.getSqlInitialValue(artifact, queryTable);
    }

    @Override
    public String getSqlInitialValue(Artifact artifact, QueryTable queryTable) {
        Object initialValue = this.getInitialValue(artifact);
        Class<?> dataType = this.getDataType(artifact);
        return initialValue == null || dataType == null ? null : this.getSqlValue(initialValue, dataType, queryTable);
    }

    @Override
    public String getSqlDefaultValue(Artifact artifact) {
        QueryTable queryTable = null;
        return this.getSqlDefaultValue(artifact, queryTable);
    }

    @Override
    public String getSqlDefaultValue(Artifact artifact, QueryTable queryTable) {
        Object defaultValue = this.getDefaultValue(artifact);
        Class<?> dataType = this.getDataType(artifact);
        return defaultValue == null || dataType == null ? null : this.getSqlValue(defaultValue, dataType, queryTable);
    }

    @Override
    public String getSqlCurrentValue(Artifact artifact) {
        QueryTable queryTable = null;
        return this.getSqlCurrentValue(artifact, queryTable);
    }

    @Override
    public String getSqlCurrentValue(Artifact artifact, QueryTable queryTable) {
        Object currentValue = this.getCurrentValue(artifact);
        Class<?> dataType = this.getDataType(artifact);
        return currentValue == null || dataType == null ? null : this.getSqlValue(currentValue, dataType, queryTable);
    }

    public String getSqlValue(Object object) {
        return this.getSqlValue(object, null);
    }

    public String getSqlValue(Object object, QueryTable queryTable) {
        return object == null ? null : this.getSqlValue(object, object.getClass(), queryTable);
    }

    private String getSqlValue(Object object, Class<?> type, QueryTable queryTable) {
        if (object == null || type == null) {
            return null;
        }
        if (object instanceof Property) {
            Property property = (Property)object;
            return queryTable == null ? null : this.getQualifiedName(property, queryTable, SqlQualifierType.RECORD);
        }
        if (object instanceof Expression) {
            Expression expression = (Expression)object;
            return queryTable == null ? null : this.getSqlExpression((Object)expression, queryTable, SqlQualifierType.RECORD);
        }
        if (object instanceof Instance) {
            return this.getDelimitedString(((Instance)object).getInstanceKeyValue());
        }
        if (object instanceof Artifact) {
            Artifact artifact = (Artifact)object;
            return this.getSqlQualifiedName(artifact);
        }
        if (object instanceof SpecialBooleanValue) {
            SpecialBooleanValue value = (SpecialBooleanValue)object;
            return this.getSpecialBooleanValue(value);
        }
        if (object instanceof SpecialCharacterValue) {
            SpecialCharacterValue value = (SpecialCharacterValue)object;
            return this.getSpecialCharacterValue(value);
        }
        if (object instanceof SpecialEntityValue) {
            SpecialEntityValue value = (SpecialEntityValue)object;
            return this.getSpecialEntityValue(value);
        }
        if (object instanceof SpecialNumericValue) {
            SpecialNumericValue value = (SpecialNumericValue)object;
            return this.getSpecialNumericValue(value);
        }
        if (object instanceof SpecialTemporalValue) {
            SpecialTemporalValue value = (SpecialTemporalValue)object;
            return this.getSpecialTemporalValue(value);
        }
        if (object instanceof NamedValue) {
            NamedValue value = (NamedValue)object;
            return value.name();
        }
        return this.getDelimitedString(object);
    }

    protected abstract String getSpecialBooleanValue(SpecialBooleanValue var1);

    protected abstract String getSpecialCharacterValue(SpecialCharacterValue var1);

    protected abstract String getSpecialEntityValue(SpecialEntityValue var1);

    protected abstract String getSpecialNumericValue(SpecialNumericValue var1);

    protected abstract String getSpecialTemporalValue(SpecialTemporalValue var1);

    private Class<?> getDataType(Artifact artifact) {
        TypedArtifact typedArtifact = artifact instanceof TypedArtifact ? (TypedArtifact)artifact : null;
        return typedArtifact == null ? null : typedArtifact.getDataType();
    }

    private Object getInitialValue(Artifact artifact) {
        ValuedArtifact valuedArtifact = artifact instanceof ValuedArtifact ? (ValuedArtifact)artifact : null;
        return valuedArtifact == null ? null : valuedArtifact.getInitialValue();
    }

    private Object getDefaultValue(Artifact artifact) {
        ValuedArtifact valuedArtifact = artifact instanceof ValuedArtifact ? (ValuedArtifact)artifact : null;
        return valuedArtifact == null ? null : valuedArtifact.getDefaultValue();
    }

    private Object getCurrentValue(Artifact artifact) {
        ValuedArtifact valuedArtifact = artifact instanceof ValuedArtifact ? (ValuedArtifact)artifact : null;
        return valuedArtifact == null ? null : valuedArtifact.getCurrentValue();
    }

    @Override
    public String getSqlExpression(Object object) {
        QueryTable queryTable = null;
        return this.getSqlExpression(object, queryTable);
    }

    @Override
    public String getSqlExpression(Object object, QueryTable queryTable) {
        return this.getSqlExpression(object, queryTable, SqlQualifierType.RECORD);
    }

    @Override
    public String getSqlExpression(Object object, QueryTable queryTable, SqlQualifierType qualifier) {
        return this.getSqlExpression(object, (Object)queryTable, qualifier, null, false);
    }

    @Override
    public String getSqlExpression(Object object, Map<String, QueryTable> queryTablesMap) {
        return this.getSqlExpression(object, queryTablesMap, SqlQualifierType.RECORD);
    }

    @Override
    public String getSqlExpression(Object object, Map<String, QueryTable> queryTablesMap, SqlQualifierType qualifier) {
        return this.getSqlExpression(object, queryTablesMap, qualifier, null, false);
    }

    @Override
    public ParameterizedExpression getSqlParameterizedExpression(Object object) {
        QueryTable queryTable = null;
        return this.getSqlParameterizedExpression(object, queryTable);
    }

    @Override
    public ParameterizedExpression getSqlParameterizedExpression(Object object, QueryTable queryTable) {
        return this.getSqlParameterizedExpression(object, queryTable, SqlQualifierType.RECORD);
    }

    @Override
    public ParameterizedExpression getSqlParameterizedExpression(Object object, QueryTable queryTable, SqlQualifierType qualifier) {
        ParameterizedExpression px = new ParameterizedExpression();
        String expression = this.getSqlExpression(object, (Object)queryTable, qualifier, px, false);
        px.setExpression(expression);
        return px;
    }

    @Override
    public ParameterizedExpression getSqlParameterizedExpression(Object object, Map<String, QueryTable> queryTablesMap) {
        return this.getSqlParameterizedExpression(object, queryTablesMap, SqlQualifierType.RECORD);
    }

    @Override
    public ParameterizedExpression getSqlParameterizedExpression(Object object, Map<String, QueryTable> queryTablesMap, SqlQualifierType qualifier) {
        ParameterizedExpression px = new ParameterizedExpression();
        String expression = this.getSqlExpression(object, queryTablesMap, qualifier, px, false);
        px.setExpression(expression);
        return px;
    }

    protected String getSqlExpression(Object object, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px, boolean enclose) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            Object[] objects = (Object[])object;
            return this.getSqlExpression(objects, queryObject, qualifier, px, enclose);
        }
        if (object instanceof Entity && queryObject instanceof QueryTable && object.equals(((QueryTable)queryObject).getEntity())) {
            Entity entity = (Entity)object;
            Property property = entity.getPrimaryKeyProperty();
            return this.getSqlExpression(property, queryObject, qualifier, px, enclose);
        }
        if (object instanceof Property) {
            Property property = (Property)object;
            return queryObject == null ? this.getPropertySqlName(property) : this.getQualifiedName(property, queryObject, qualifier, px);
        }
        if (object instanceof ScalarX) {
            Expression expression = (Expression)object;
            return this.getSqlExpression(expression, queryObject, qualifier, px, false);
        }
        if (object instanceof Expression) {
            Expression expression = (Expression)object;
            return this.getSqlExpression(expression, queryObject, qualifier, px, enclose);
        }
        if (object instanceof Instance) {
            Instance instance = (Instance)object;
            return this.getDelimitedString(instance.getInstanceKeyValue());
        }
        if (object instanceof SpecialBooleanValue) {
            SpecialBooleanValue value = (SpecialBooleanValue)object;
            return this.getSpecialBooleanValue(value);
        }
        if (object instanceof SpecialCharacterValue) {
            SpecialCharacterValue value = (SpecialCharacterValue)object;
            return this.getSpecialCharacterValue(value);
        }
        if (object instanceof SpecialEntityValue) {
            SpecialEntityValue value = (SpecialEntityValue)object;
            return this.getSpecialEntityValue(value);
        }
        if (object instanceof SpecialNumericValue) {
            SpecialNumericValue value = (SpecialNumericValue)object;
            return this.getSpecialNumericValue(value);
        }
        if (object instanceof SpecialTemporalValue) {
            SpecialTemporalValue value = (SpecialTemporalValue)object;
            return this.getSpecialTemporalValue(value);
        }
        if (object instanceof NamedValue) {
            NamedValue namedValue = (NamedValue)object;
            return this.getNamedValueName(namedValue, px);
        }
        if (object instanceof NativeQuery) {
            NativeQuery nativeQuery = (NativeQuery)object;
            return nativeQuery.getString(qualifier);
        }
        if (object instanceof Artifact) {
            Artifact artifact = (Artifact)object;
            return this.getSqlQualifiedName(artifact);
        }
        return this.getDelimitedString(object);
    }

    protected String getSqlExpression(Object[] objects, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px, boolean enclose) {
        if (objects == null) {
            return null;
        }
        ArrayList<String> expressions = new ArrayList<String>();
        for (Object object : objects) {
            String expression = this.getSqlExpression(object, queryObject, qualifier, px, enclose);
            if (!StringUtils.isNotBlank((String)expression)) continue;
            expressions.add(expression);
        }
        return expressions.isEmpty() ? null : StrUtils.encloseSqlExpression(StringUtils.join(expressions, (String)SEPX));
    }

    protected String getSqlExpression(Expression expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px, boolean enclose) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof Property) {
            Property property = (Property)((Object)expression);
            return queryObject == null ? this.getPropertySqlName(property) : this.getQualifiedName(property, queryObject, qualifier, px);
        }
        String string = expression instanceof ComparisonX ? this.getSqlComparisonExpression((ComparisonX)expression, queryObject, qualifier, px) : (expression instanceof ConditionalX ? this.getSqlConditionalExpression((ConditionalX)expression, queryObject, qualifier, px) : (expression instanceof DataAggregateX ? this.getSqlDataAggregateExpression((DataAggregateX)expression, queryObject, qualifier, px) : (expression instanceof RowsAggregateX ? this.getSqlRowsAggregateExpression((RowsAggregateX)expression, queryObject, qualifier, px) : (expression instanceof NaryVectorX ? this.getSqlNaryVectorExpression((NaryVectorX)expression, queryObject, qualifier, px) : (expression instanceof OrderedPairX ? this.getSqlOrderedPairExpression((OrderedPairX)expression, queryObject, qualifier, px) : (expression instanceof ScalarX ? this.getSqlScalarExpression((ScalarX)expression, queryObject, qualifier, px) : (expression instanceof VariantX ? this.getSqlVariantExpression((VariantX)expression, queryObject, qualifier, px) : this.getDelimitedString(expression))))))));
        return enclose ? StrUtils.encloseSqlExpression(string) : StrUtils.discloseSqlExpression(string);
    }

    protected String getSqlComparisonExpression(ComparisonX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        Object pattern;
        ComparisonOp operator = expression.getOperator();
        Object x = expression.getX();
        Object y = expression.getY();
        Object z = expression.getZ();
        if (operator == null || x == null) {
            return null;
        }
        boolean primitive = x instanceof Primitive;
        if (x instanceof Expression && !primitive && !this.validExpressionOperator(operator)) {
            String sx;
            Expression ex = (Expression)x;
            Artifact ay = y instanceof Artifact ? (Artifact)y : null;
            String string = sx = ex.isNotDeclared() ? ex.toString() : ex.getFullName();
            Object sy = y == null ? EMPTY : " to " + (ay == null || ay.isNotDeclared() ? y.toString() : ay.getFullName());
            String message = operator + " cannot be used to compare expression " + sx + (String)sy;
            boolean added = this.sqlComparisonExpressionMessages.add(message);
            if (added) {
                logger.error((Object)message);
                Project.increaseWriterErrorCount();
            }
        }
        String arg1 = this.getSqlExpression(x, queryObject, qualifier, px, true);
        String arg2 = this.getSqlExpression(y, queryObject, qualifier, px, true);
        String arg3 = this.getSqlExpression(z, queryObject, qualifier, px, true);
        switch (operator) {
            case EXISTS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = this.getExists() + " ({0})";
                break;
            }
            case NOT_EXISTS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = this.getNotExists() + " ({0})";
                break;
            }
            case IS_NULL: {
                pattern = "{0} " + this.getIsNull();
                break;
            }
            case IS_NOT_NULL: {
                pattern = "{0} " + this.getIsNotNull();
                break;
            }
            case IS_TRUE: {
                pattern = primitive ? this.primitiveIsTruePattern() : this.expressionIsTruePattern();
                pattern = this.getIsNotNullAnd(arg1, true) + (String)pattern;
                break;
            }
            case IS_FALSE: {
                pattern = primitive ? this.primitiveIsFalsePattern() : this.expressionIsFalsePattern();
                pattern = this.getIsNotNullAnd(arg1, true) + (String)pattern;
                break;
            }
            case IS_NULL_OR_TRUE: {
                pattern = primitive ? this.primitiveIsTruePattern() : this.expressionIsTruePattern();
                pattern = this.getIsNullOr(arg1, true) + (String)pattern;
                break;
            }
            case IS_NULL_OR_FALSE: {
                pattern = primitive ? this.primitiveIsFalsePattern() : this.expressionIsFalsePattern();
                pattern = this.getIsNullOr(arg1, true) + (String)pattern;
                break;
            }
            case EQ: {
                pattern = this.getIsNotNullAnd(arg1) + this.getEQ() + " " + arg2;
                break;
            }
            case NEQ: {
                pattern = this.getIsNotNullAnd(arg1) + this.getNEQ() + " " + arg2;
                break;
            }
            case GT: {
                pattern = this.getIsNotNullAnd(arg1) + this.getGT() + " " + arg2;
                break;
            }
            case GTEQ: {
                pattern = this.getIsNotNullAnd(arg1) + this.getGTEQ() + " " + arg2;
                break;
            }
            case LT: {
                pattern = this.getIsNotNullAnd(arg1) + this.getLT() + " " + arg2;
                break;
            }
            case LTEQ: {
                pattern = this.getIsNotNullAnd(arg1) + this.getLTEQ() + " " + arg2;
                break;
            }
            case STARTS_WITH: {
                pattern = this.getIsNotNullAnd(arg1) + this.getLike() + " " + this.startsWithArgument(1);
                break;
            }
            case NOT_STARTS_WITH: {
                pattern = this.getIsNotNullAnd(arg1) + this.getNotLike() + " " + this.startsWithArgument(1);
                break;
            }
            case CONTAINS: {
                pattern = this.getIsNotNullAnd(arg1) + this.getLike() + " " + this.containsArgument(1);
                break;
            }
            case NOT_CONTAINS: {
                pattern = this.getIsNotNullAnd(arg1) + this.getNotLike() + " " + this.containsArgument(1);
                break;
            }
            case ENDS_WITH: {
                pattern = this.getIsNotNullAnd(arg1) + this.getLike() + " " + this.endsWithArgument(1);
                break;
            }
            case NOT_ENDS_WITH: {
                pattern = this.getIsNotNullAnd(arg1) + this.getNotLike() + " " + this.endsWithArgument(1);
                break;
            }
            case IS_IN: {
                pattern = this.getIsNotNullAnd(arg1) + this.getIn() + " " + StrUtils.encloseSqlExpression(arg2);
                break;
            }
            case IS_NOT_IN: {
                pattern = this.getIsNotNullAnd(arg1) + this.getNotIn() + " " + StrUtils.encloseSqlExpression(arg2);
                break;
            }
            case IS_BETWEEN: {
                pattern = this.getIsNotNullAnd(arg1) + this.getBetween() + " " + arg2 + " " + this.getAnd() + " " + arg3;
                break;
            }
            case IS_NOT_BETWEEN: {
                pattern = this.getIsNotNullAnd(arg1) + this.getNotBetween() + " " + arg2 + " " + this.getAnd() + " " + arg3;
                break;
            }
            case IS_NULL_OR_EQ: {
                pattern = this.getIsNullOr(arg1) + this.getEQ() + " " + arg2;
                break;
            }
            case IS_NULL_OR_NEQ: {
                pattern = this.getIsNullOr(arg1) + this.getNEQ() + " " + arg2;
                break;
            }
            case IS_NULL_OR_GT: {
                pattern = this.getIsNullOr(arg1) + this.getGT() + " " + arg2;
                break;
            }
            case IS_NULL_OR_LTEQ: {
                pattern = this.getIsNullOr(arg1) + this.getLTEQ() + " " + arg2;
                break;
            }
            case IS_NULL_OR_GTEQ: {
                pattern = this.getIsNullOr(arg1) + this.getGTEQ() + " " + arg2;
                break;
            }
            case IS_NULL_OR_LT: {
                pattern = this.getIsNullOr(arg1) + this.getLT() + " " + arg2;
                break;
            }
            case IS_NULL_OR_STARTS_WITH: {
                pattern = this.getIsNullOr(arg1) + this.getLike() + " " + this.startsWithArgument(1);
                break;
            }
            case IS_NULL_OR_NOT_STARTS_WITH: {
                pattern = this.getIsNullOr(arg1) + this.getNotLike() + " " + this.startsWithArgument(1);
                break;
            }
            case IS_NULL_OR_CONTAINS: {
                pattern = this.getIsNullOr(arg1) + this.getLike() + " " + this.containsArgument(1);
                break;
            }
            case IS_NULL_OR_NOT_CONTAINS: {
                pattern = this.getIsNullOr(arg1) + this.getNotLike() + " " + this.containsArgument(1);
                break;
            }
            case IS_NULL_OR_ENDS_WITH: {
                pattern = this.getIsNullOr(arg1) + this.getLike() + " " + this.endsWithArgument(1);
                break;
            }
            case IS_NULL_OR_NOT_ENDS_WITH: {
                pattern = this.getIsNullOr(arg1) + this.getNotLike() + " " + this.endsWithArgument(1);
                break;
            }
            case IS_NULL_OR_IN: {
                pattern = this.getIsNullOr(arg1) + this.getIn() + " " + StrUtils.encloseSqlExpression(arg2);
                break;
            }
            case IS_NULL_OR_NOT_IN: {
                pattern = this.getIsNullOr(arg1) + this.getNotIn() + " " + StrUtils.encloseSqlExpression(arg2);
                break;
            }
            case IS_NULL_OR_BETWEEN: {
                pattern = this.getIsNullOr(arg1) + this.getBetween() + " " + arg2 + " " + this.getAnd() + " " + arg3;
                break;
            }
            case IS_NULL_OR_NOT_BETWEEN: {
                pattern = this.getIsNullOr(arg1) + this.getNotBetween() + " " + arg2 + " " + this.getAnd() + " " + arg3;
                break;
            }
            default: {
                pattern = this.call((Operator)operator, z == null ? (y == null ? 1 : 2) : 3);
            }
        }
        return AbstractSqlProgrammer.format((String)pattern, arg1, arg2, arg3);
    }

    protected boolean validExpressionOperator(ComparisonOp operator) {
        return true;
    }

    protected String primitiveIsTruePattern() {
        return "{0} " + this.getIsTrue();
    }

    protected String primitiveIsFalsePattern() {
        return "{0} " + this.getIsFalse();
    }

    protected String expressionIsTruePattern() {
        return "({0})";
    }

    protected String expressionIsFalsePattern() {
        return "not({0})";
    }

    protected String getSqlConditionalExpression(ConditionalX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        BooleanExpression b = expression.getBooleanExpression();
        Object x = expression.getThenValue();
        Object y = expression.getElseValue();
        if (b == null || x == null) {
            return null;
        }
        String arg0 = this.getSqlExpression(b, queryObject, qualifier, px, true);
        String arg1 = this.getSqlExpression(x, queryObject, qualifier, px, true);
        String arg2 = this.getSqlExpression(y, queryObject, qualifier, px, true);
        String pattern = y == null ? this.getCaseWhenThenPattern() : this.getCaseWhenThenElsePattern();
        return AbstractSqlProgrammer.format(pattern, arg0, arg1, arg2);
    }

    protected String getSqlDataAggregateExpression(DataAggregateX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        String string;
        DataAggregateOp operator = expression.getOperator();
        Object[] operands = expression.getOperands();
        if (operator == null || operands == null || operands.length < 2) {
            return null;
        }
        String[] arguments = new String[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            arguments[i] = this.getSqlExpression(operands[i], queryObject, qualifier, px, true);
        }
        switch (operator) {
            case COUNT: {
                string = this.count(arguments);
                break;
            }
            case MAXIMUM: {
                string = this.maximum(arguments);
                break;
            }
            case MINIMUM: {
                string = this.minimum(arguments);
                break;
            }
            case AND: {
                string = this.and(arguments);
                break;
            }
            case NAND: {
                string = this.not(this.and(arguments));
                break;
            }
            case OR: {
                string = this.or(arguments);
                break;
            }
            case NOR: {
                string = this.not(this.or(arguments));
                break;
            }
            case NAXOR: {
                string = this.xor(arguments);
                break;
            }
            case NAXNOR: {
                string = this.not(this.xor(arguments));
                break;
            }
            case NOR_OR_NAXOR: {
                string = this.or(this.not(this.or(arguments)), this.xor(arguments));
                break;
            }
            case CONCAT: {
                string = this.connect(this.getConcat(), arguments);
                break;
            }
            case SUM: {
                string = this.connect(this.getAdd(), arguments);
                break;
            }
            case PRODUCT: {
                string = this.connect(this.getMultiply(), arguments);
                break;
            }
            case AVERAGE: {
                string = this.average(arguments);
                break;
            }
            default: {
                string = this.call((Operator)operator, arguments);
            }
        }
        return string;
    }

    protected String getSqlRowsAggregateExpression(RowsAggregateX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        Object errmsg = EMPTY;
        if (expression == null || queryObject == null) {
            return null;
        }
        errmsg = (String)errmsg + "failed to generate code for expression " + this.stringOf(expression);
        Entity declaringEntity = expression.getDeclaringEntity();
        if (declaringEntity == null) {
            logger.error(errmsg);
            return null;
        }
        errmsg = (String)errmsg + " at entity " + this.stringOf(declaringEntity);
        String function = this.getSqlSchemaQualifiedShortExpressionSelectFunctionName(expression);
        if (function == null) {
            logger.error(errmsg);
            return null;
        }
        Entity dimension = expression.getDimension();
        Property argument = dimension instanceof Property ? (Property)((Object)dimension) : null;
        String argname = argument == null ? EMPTY : this.getQualifiedName(argument, queryObject, qualifier, px);
        return function + "(" + argname + ")";
    }

    protected abstract String getSqlNaryVectorExpression(NaryVectorX var1, Object var2, SqlQualifierType var3, ParameterizedExpression var4);

    protected abstract String getSqlOrderedPairExpression(OrderedPairX var1, Object var2, SqlQualifierType var3, ParameterizedExpression var4);

    protected abstract String getSqlScalarExpression(ScalarX var1, Object var2, SqlQualifierType var3, ParameterizedExpression var4);

    protected String toCharStringPattern(Object operand) {
        Class<?> clazz;
        Class<?> clazz2 = operand == null ? null : (clazz = operand instanceof TypedArtifact ? ((TypedArtifact)operand).getDataType() : operand.getClass());
        if (clazz == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return "to_char({0}, 'YYYYMMDD')";
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return "to_char({0}, 'HH24MISS')";
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return "to_char({0}, 'YYYYMMDDHH24MISS')";
        }
        return this.defaultCharStringPattern();
    }

    protected String toZeroPaddedStringPattern(Object x, Object y) {
        Integer w = x == null || y == null ? null : ObjUtils.toInteger(y);
        int width = w == null || w < 0 ? 0 : w;
        return this.defaultZeroPaddedStringPattern(width);
    }

    protected abstract String defaultCharStringPattern();

    protected abstract String defaultZeroPaddedStringPattern(int var1);

    protected String getSqlVariantExpression(VariantX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        Expression foreignExpression;
        Object errmsg = EMPTY;
        if (expression == null || queryObject == null) {
            return null;
        }
        errmsg = (String)errmsg + "failed to generate code for expression " + this.stringOf(expression);
        Entity declaringEntity = expression.getDeclaringEntity();
        if (declaringEntity == null) {
            logger.error(errmsg);
            return null;
        }
        errmsg = (String)errmsg + " at entity " + this.stringOf(declaringEntity);
        String function = this.getSqlSchemaQualifiedShortExpressionFunctionName(expression);
        Property argument = expression.getExpressionFunctionArgument();
        if (function == null || argument == null) {
            logger.error(errmsg);
            return null;
        }
        boolean doubtful = declaringEntity.isRootInstance();
        if (doubtful && (foreignExpression = expression.getForeignExpression()) instanceof RowsAggregateX) {
            RowsAggregateX foreignRowsAggregateX = (RowsAggregateX)foreignExpression;
            String select = this.getSqlSchemaQualifiedShortExpressionSelectFunctionName(foreignRowsAggregateX);
            if (select != null) {
                Entity dimension = foreignRowsAggregateX.getDimension();
                if (dimension == null) {
                    function = select;
                    argument = null;
                    doubtful = false;
                } else if (declaringEntity.getClass().isAssignableFrom(dimension.getClass())) {
                    function = select;
                    doubtful = false;
                }
            }
            if (doubtful) {
                errmsg = (String)errmsg + "; cannot bind it to its foreign expression " + this.stringOf(foreignExpression);
                errmsg = (String)errmsg + " at entity " + this.stringOf(foreignExpression.getDeclaringEntity());
            }
        }
        if (doubtful) {
            logger.error(errmsg);
            return null;
        }
        if (argument == null) {
            return function + "()";
        }
        return function + "(" + this.getQualifiedName(argument, queryObject, qualifier, px) + ")";
    }

    @Override
    public String getSqlOperationFunctionName(Operation operation) {
        int maxIdentifierLength = this.getMaxIdentifierLength();
        return this.getSqlOperationFunctionName(operation, maxIdentifierLength);
    }

    @Override
    public String getSqlOperationFunctionName(Operation operation, int maxIdentifierLength) {
        if (operation == null) {
            return null;
        }
        Entity e = operation.getDeclaringEntity();
        String r = e == null ? EMPTY : this.getSqlName((Artifact)e.getRoot(), 0) + EXPRESSION_DOLLAR_INFIX;
        String x = this.getSqlName((Artifact)operation, 0);
        int max = this.getMaxIdentifierLength(maxIdentifierLength);
        return StrUtils.getIdentificadorSql(r + x, max);
    }

    @Override
    public String getSqlSchemaQualifiedOperationFunctionName(Operation operation) {
        if (operation == null) {
            return null;
        }
        String name = this.getSqlOperationFunctionName(operation);
        PersistentEntity pent = operation.getDeclaringPersistentEntity();
        return pent == null ? name : StrUtils.getQualifiedName(name, this.getSqlSchemaName(pent));
    }

    @Override
    public String getSqlSchemaQualifiedOperationFunctionName(Operation operation, int maxIdentifierLength) {
        if (operation == null) {
            return null;
        }
        String name = this.getSqlOperationFunctionName(operation, maxIdentifierLength);
        PersistentEntity pent = operation.getDeclaringPersistentEntity();
        return pent == null ? name : StrUtils.getQualifiedName(name, this.getSqlSchemaName(pent));
    }

    @Override
    public String getSqlSchemaQualifiedShortOperationFunctionName(Operation operation) {
        if (operation == null) {
            return null;
        }
        String name = this.getSqlOperationFunctionName(operation);
        PersistentEntity pent = operation.getDeclaringPersistentEntity();
        return pent == null ? name : StrUtils.getQualifiedShortName(name, this.getSqlSchemaName(pent));
    }

    @Override
    public String getSqlSchemaQualifiedShortOperationFunctionName(Operation operation, int maxIdentifierLength) {
        if (operation == null) {
            return null;
        }
        String name = this.getSqlOperationFunctionName(operation, maxIdentifierLength);
        PersistentEntity pent = operation.getDeclaringPersistentEntity();
        return pent == null ? name : StrUtils.getQualifiedShortName(name, this.getSqlSchemaName(pent));
    }

    @Override
    public String getSqlExpressionFunctionName(Expression expression) {
        int maxIdentifierLength = this.getMaxIdentifierLength();
        return this.getSqlExpressionFunctionName(expression, maxIdentifierLength);
    }

    @Override
    public String getSqlExpressionFunctionName(Expression expression, int maxIdentifierLength) {
        if (expression == null) {
            return null;
        }
        Entity e = expression.getDeclaringEntity();
        String r = e == null ? EMPTY : this.getSqlName((Artifact)e.getRoot(), 0) + EXPRESSION_DOLLAR_INFIX;
        String x = this.getSqlName((Artifact)expression, 0);
        int max = this.getMaxIdentifierLength(maxIdentifierLength);
        return StrUtils.getIdentificadorSql(r + x, max);
    }

    @Override
    public String getSqlSchemaQualifiedExpressionFunctionName(Expression expression) {
        if (expression == null) {
            return null;
        }
        String name = this.getSqlExpressionFunctionName(expression);
        PersistentEntity pent = expression.getDeclaringPersistentEntity();
        return pent == null ? name : StrUtils.getQualifiedName(name, this.getSqlSchemaName(pent));
    }

    @Override
    public String getSqlSchemaQualifiedExpressionFunctionName(Expression expression, int maxIdentifierLength) {
        if (expression == null) {
            return null;
        }
        String name = this.getSqlExpressionFunctionName(expression, maxIdentifierLength);
        PersistentEntity pent = expression.getDeclaringPersistentEntity();
        return pent == null ? name : StrUtils.getQualifiedName(name, this.getSqlSchemaName(pent));
    }

    @Override
    public String getSqlSchemaQualifiedShortExpressionFunctionName(Expression expression) {
        if (expression == null) {
            return null;
        }
        String name = this.getSqlExpressionFunctionName(expression);
        PersistentEntity pent = expression.getDeclaringPersistentEntity();
        return pent == null ? name : StrUtils.getQualifiedShortName(name, this.getSqlSchemaName(pent));
    }

    @Override
    public String getSqlSchemaQualifiedShortExpressionFunctionName(Expression expression, int maxIdentifierLength) {
        if (expression == null) {
            return null;
        }
        String name = this.getSqlExpressionFunctionName(expression, maxIdentifierLength);
        PersistentEntity pent = expression.getDeclaringPersistentEntity();
        return pent == null ? name : StrUtils.getQualifiedShortName(name, this.getSqlSchemaName(pent));
    }

    @Override
    public String getSqlExpressionSelectFunctionName(Expression expression) {
        int maxIdentifierLength = this.getMaxIdentifierLength();
        return this.getSqlExpressionSelectFunctionName(expression, maxIdentifierLength);
    }

    @Override
    public String getSqlExpressionSelectFunctionName(Expression expression, int maxIdentifierLength) {
        if (expression == null) {
            return null;
        }
        Entity e = expression instanceof RowsAggregateX ? expression.getDeclaringEntity() : null;
        String r = e == null ? EMPTY : this.getSqlName((Artifact)e.getRoot(), 0) + EXPRESSION_SELECT_INFIX;
        String x = this.getSqlName((Artifact)expression, 0);
        int max = this.getMaxIdentifierLength(maxIdentifierLength);
        return StrUtils.getIdentificadorSql(r + x, max);
    }

    @Override
    public String getSqlSchemaQualifiedExpressionSelectFunctionName(Expression expression) {
        if (expression == null) {
            return null;
        }
        String name = this.getSqlExpressionSelectFunctionName(expression);
        PersistentEntity pent = expression instanceof RowsAggregateX ? expression.getDeclaringPersistentEntity() : null;
        return pent == null ? name : StrUtils.getQualifiedName(name, this.getSqlSchemaName(pent));
    }

    @Override
    public String getSqlSchemaQualifiedExpressionSelectFunctionName(Expression expression, int maxIdentifierLength) {
        if (expression == null) {
            return null;
        }
        String name = this.getSqlExpressionSelectFunctionName(expression, maxIdentifierLength);
        PersistentEntity pent = expression instanceof RowsAggregateX ? expression.getDeclaringPersistentEntity() : null;
        return pent == null ? name : StrUtils.getQualifiedName(name, this.getSqlSchemaName(pent));
    }

    @Override
    public String getSqlSchemaQualifiedShortExpressionSelectFunctionName(Expression expression) {
        if (expression == null) {
            return null;
        }
        String name = this.getSqlExpressionSelectFunctionName(expression);
        PersistentEntity pent = expression instanceof RowsAggregateX ? expression.getDeclaringPersistentEntity() : null;
        return pent == null ? name : StrUtils.getQualifiedShortName(name, this.getSqlSchemaName(pent));
    }

    @Override
    public String getSqlSchemaQualifiedShortExpressionSelectFunctionName(Expression expression, int maxIdentifierLength) {
        if (expression == null) {
            return null;
        }
        String name = this.getSqlExpressionSelectFunctionName(expression, maxIdentifierLength);
        PersistentEntity pent = expression instanceof RowsAggregateX ? expression.getDeclaringPersistentEntity() : null;
        return pent == null ? name : StrUtils.getQualifiedShortName(name, this.getSqlSchemaName(pent));
    }

    private String stringOf(Expression e) {
        return e == null ? "?" : (e.getName() != null ? e.getName() : (e.getParentExpression() != null ? this.stringOf(e.getParentExpression()) + "[" + e.toString() + "]" : e.toString()));
    }

    private String stringOf(Entity e) {
        return e == null ? "?" : (e.getName() != null ? e.getName() : e.toString());
    }

    protected String getSqlExpressionDefaultValue(Expression expression) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = expression == null ? null : expression.getDataType();
        if (clazz == null) {
            return this.getNull();
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return this.getFalse();
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return this.getZeroChar();
        }
        if (String.class.isAssignableFrom(clazz)) {
            return this.getZeroString();
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return this.getZeroNumber();
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return this.getZeroNumber();
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return this.getZeroNumber();
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return this.getZeroNumber();
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return this.getZeroNumber();
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return this.getZeroNumber();
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return this.getZeroNumber();
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return this.getZeroNumber();
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return this.getZeroDate();
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return this.getZeroTime();
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return this.getZeroTimestamp();
        }
        return this.getNull();
    }

    @Override
    public String getSqlSortOption(SortOption sortOption) {
        if (sortOption != null) {
            switch (sortOption) {
                case ASC: {
                    return this.getAscending();
                }
                case DESC: {
                    return this.getDescending();
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public String getSqlJoinOperator(QueryJoinOp operator) {
        if (operator != null) {
            switch (operator) {
                case INNER: {
                    return this.getInnerJoin();
                }
                case LEFT: {
                    return this.getLeftJoin();
                }
                case RIGHT: {
                    return this.getRightJoin();
                }
                case FULL: {
                    return this.getFullJoin();
                }
                case CROSS: {
                    return this.getCrossJoin();
                }
            }
            return this.getDefaultJoin();
        }
        return null;
    }

    @Override
    public String getSqlJoinQualifier(QueryTable queryTable) {
        int index = queryTable == null ? 0 : queryTable.getSubqueryIndex();
        return index == 0 ? this.getRowVariableName() : this.getRecordVariableName(index);
    }

    @Override
    public Map<String, Property> getSelectColumnsMap(QueryTable queryTable) {
        LinkedHashMap<String, Property> map = new LinkedHashMap<String, Property>();
        for (Property p : queryTable.getColumns()) {
            String alias = this.getPropertySqlAlias(p, queryTable);
            map.put(alias, p);
        }
        for (QueryJoin j : queryTable.getJoins()) {
            map.putAll(this.getSelectColumnsMap(j.getRightTable()));
        }
        return map;
    }

    @Override
    public String getSqlSelectStatement(Expression expression) {
        QueryTable queryTable = null;
        return this.getSqlSelectStatement(expression, queryTable);
    }

    @Override
    public String getSqlSelectStatement(Expression expression, QueryTable queryTable) {
        if (expression instanceof RowsAggregateX) {
            return this.getSqlSelectStatement((RowsAggregateX)expression, queryTable);
        }
        return null;
    }

    protected String getSqlSelectStatement(RowsAggregateX expression, QueryTable queryTable) {
        String function;
        RowsAggregateOp operator = expression.getOperator();
        Object measure = expression.getMeasure();
        Segment filter = expression.getFilter();
        Entity dimension = expression.getDimension();
        if (operator == null || measure == null) {
            return null;
        }
        switch (operator) {
            case COUNT: {
                function = this.getCount();
                break;
            }
            case MAXIMUM: {
                function = this.getMaximum();
                break;
            }
            case MINIMUM: {
                function = this.getMinimum();
                break;
            }
            case SUM: {
                function = this.getSum();
                break;
            }
            case AVERAGE: {
                function = this.getAverage();
                break;
            }
            default: {
                function = operator.name().toLowerCase();
            }
        }
        String argument = this.getSqlExpression(measure, (Object)queryTable, SqlQualifierType.ALIAS, null, false);
        if (argument == null && operator.equals(RowsAggregateOp.COUNT)) {
            argument = "*";
        }
        ArrayList<Property> referencedColumns = new ArrayList<Property>();
        if (measure instanceof Property) {
            referencedColumns.add((Property)measure);
        } else if (measure instanceof Expression) {
            referencedColumns.addAll(((Expression)measure).getReferencedColumnsList());
        }
        if (filter != null) {
            referencedColumns.addAll(filter.getReferencedColumnsList());
        }
        if (dimension instanceof Property) {
            referencedColumns.add((Property)((Object)dimension));
        }
        Object string = this.getSelect();
        string = (String)string + EOL$ + function + "(" + argument + ")";
        string = (String)string + EOL$ + this.getInto() + " " + this.getValueVariableName();
        string = (String)string + EOL$ + this.getSelectFrom(queryTable, queryTable, referencedColumns, false);
        String where = this.getWhere();
        if (filter != null) {
            string = (String)string + EOL$ + where + " " + this.getSqlExpression(filter, (Object)queryTable, SqlQualifierType.ALIAS, null, false);
            where = this.getAnd();
        }
        if (dimension != null) {
            string = (String)string + EOL$ + where + " " + this.getSqlExpression(dimension, (Object)queryTable, SqlQualifierType.ALIAS, null, false);
            string = (String)string + " " + this.getEQ() + " " + this.getSqlVariableName(dimension);
        }
        return string;
    }

    @Override
    public String getSqlSelectStatement(QueryTable queryTable, List<Property> referencedColumns, boolean into, boolean indent) {
        Object string = this.getSelect();
        string = (String)string + this.getSelectColumns(queryTable, queryTable, referencedColumns, indent);
        if (into) {
            string = (String)string + EOL$ + this.getInto() + " " + this.getSqlJoinQualifier(queryTable);
        }
        string = (String)string + EOL$ + this.getSelectFrom(queryTable, queryTable, referencedColumns, indent);
        return string;
    }

    private String getSelectColumns(QueryTable rootQueryTable, QueryTable queryTable, List<Property> referencedColumns, boolean indent) {
        Object string = EMPTY;
        String tab = indent ? StringUtils.repeat((String)TAB$, (int)queryTable.getDepth()) : EMPTY;
        for (Property p : queryTable.getColumns()) {
            if (referencedColumns != null && !referencedColumns.isEmpty() && !referencedColumns.contains(p)) continue;
            String name = this.getPropertySqlName(p);
            String alias = this.getPropertySqlAlias(p, queryTable);
            boolean calculable = p.isCalculable();
            if (calculable) {
                String expression;
                if (VirtualEntityType.LINE.equals((Object)rootQueryTable.getVirtualEntityType()) || (expression = this.fixCalculableColumnValueExpression(rootQueryTable, p)) == null) continue;
                string = (String)string + EOL$ + tab + expression;
                string = (String)string + " " + this.getAs() + " " + alias;
                string = (String)string + SEP$;
                continue;
            }
            string = (String)string + EOL$ + tab + queryTable.getAlias() + "." + name;
            if (!name.equals(alias)) {
                string = (String)string + " " + this.getAs() + " " + alias;
            }
            string = (String)string + SEP$;
        }
        for (QueryJoin j : queryTable.getJoins()) {
            String s = this.getSelectColumns(rootQueryTable, j.getRightTable(), referencedColumns, indent);
            if (!StringUtils.isNotBlank((String)s)) continue;
            string = (String)string + s + SEP$;
        }
        return StringUtils.removeEnd((String)string, (String)SEP$);
    }

    private String getSelectFrom(QueryTable rootQueryTable, QueryTable queryTable, List<Property> referencedColumns, boolean indent) {
        String string = this.getFrom() + " " + queryTable.getName();
        if (!queryTable.getName().equals(queryTable.getAlias())) {
            string = string + " " + queryTable.getAlias();
        }
        string = string + this.getSelectJoins(rootQueryTable, queryTable, this.referencedColumnsForJoins(referencedColumns), indent);
        return string;
    }

    private List<Property> referencedColumnsForJoins(List<Property> referencedColumns) {
        if (referencedColumns == null || referencedColumns.isEmpty()) {
            return referencedColumns;
        }
        LinkedHashSet<Property> set = new LinkedHashSet<Property>();
        for (Property referencedColumn : referencedColumns) {
            if (referencedColumn.isCalculable()) {
                if (!(referencedColumn instanceof CalculableProperty)) continue;
                Object calculableValue = ((CalculableProperty)referencedColumn).getCalculableValue();
                if (calculableValue instanceof Property) {
                    Property valueProperty = (Property)calculableValue;
                    set.add(valueProperty);
                    continue;
                }
                if (!(calculableValue instanceof Expression)) continue;
                Expression valueExpression = (Expression)calculableValue;
                List<Property> referencedColumnsList = valueExpression.getReferencedColumnsList();
                for (Property referencedByExpression : referencedColumnsList) {
                    set.add(referencedByExpression);
                }
                continue;
            }
            set.add(referencedColumn);
        }
        return new ArrayList<Property>(set);
    }

    private String getSelectJoins(QueryTable rootQueryTable, QueryTable queryTable, List<Property> referencedColumns, boolean indent) {
        Object string = EMPTY;
        boolean norc = referencedColumns == null || referencedColumns.isEmpty();
        for (QueryJoin j : queryTable.getJoins()) {
            boolean calculable = j.getLeftColumn().isCalculable();
            if (calculable || !norc && !this.containsAny(j.getRightTable(), referencedColumns, indent)) continue;
            string = (String)string + this.getSelectJoin(rootQueryTable, j, referencedColumns, indent);
        }
        return string;
    }

    private String getSelectJoin(QueryTable rootQueryTable, QueryJoin queryJoin, List<Property> referencedColumns, boolean indent) {
        Object string = EMPTY;
        QueryTable lt = queryJoin.getLeftTable();
        QueryTable rt = queryJoin.getRightTable();
        Property lc = queryJoin.getLeftColumn();
        Property rc = queryJoin.getRightColumn();
        String nested = this.getSelectJoins(rootQueryTable, rt, referencedColumns, indent);
        String joinop = this.getSqlJoinOperator(queryJoin.getOperator());
        boolean b = StringUtils.isNotBlank((String)nested);
        String tab = indent ? StringUtils.repeat((String)TAB$, (int)lt.getDepth()) : EMPTY;
        string = (String)string + EOL$ + tab + joinop + (b ? "(" : " ") + rt.getName();
        if (!rt.getName().equals(rt.getAlias())) {
            string = (String)string + " " + rt.getAlias();
        }
        string = (String)string + (String)(b ? nested + ")" + EOL$ + tab : " ");
        string = (String)string + this.getOn() + " " + rt.getAlias() + "." + this.getPropertySqlName(rc);
        string = (String)string + " " + this.getEQ() + " " + lt.getAlias() + "." + this.getPropertySqlName(lc);
        return string;
    }

    private String getCalculableColumnValueExpression(QueryTable queryTable, Property property) {
        if (property instanceof CalculableProperty) {
            Object calculableValue = ((CalculableProperty)property).getCalculableValue();
            if (calculableValue == null) {
                return this.getNull();
            }
            if (calculableValue instanceof Property) {
                Property p = (Property)calculableValue;
                QueryTable qt = queryTable.containingQueryTableOf(p);
                return qt == null ? null : qt.getAlias() + "." + this.getPropertySqlName(p);
            }
            if (calculableValue instanceof Expression) {
                return this.getSqlExpression(calculableValue, queryTable, SqlQualifierType.ALIAS);
            }
        }
        return this.getNull();
    }

    private String fixCalculableColumnValueExpression(QueryTable queryTable, Property property) {
        Object calculableValue;
        if (property instanceof CalculableProperty && (calculableValue = ((CalculableProperty)property).getCalculableValue()) == null) {
            Entity root;
            Entity dent;
            QueryTable qt = queryTable.containingQueryTableOf(property);
            if (qt != null && StringUtils.isBlank((String)qt.getSuffix()) && (dent = property.getDeclaringEntity()) != null && !dent.isRootInstance() && (root = dent.getRoot()) instanceof PersistentEntity) {
                QueryTable rootQueryTable = ((PersistentEntity)root).getQueryTable();
                Property propertyAtRoot = property.getPropertyAtRoot();
                String expression = this.getCalculableColumnValueExpression(rootQueryTable, propertyAtRoot);
                return this.fixCalculableColumnValueExpression(expression, propertyAtRoot);
            }
            return this.getNull();
        }
        String expression = this.getCalculableColumnValueExpression(queryTable, property);
        return this.fixCalculableColumnValueExpression(expression, property);
    }

    protected String fixCalculableColumnValueExpression(String expression, Property property) {
        return expression;
    }

    private boolean containsAny(QueryTable queryTable, List<Property> referencedColumns, boolean indent) {
        for (Property p : queryTable.getColumns()) {
            if (!referencedColumns.contains(p)) continue;
            return true;
        }
        for (QueryJoin j : queryTable.getJoins()) {
            if (!this.containsAny(j.getRightTable(), referencedColumns, indent)) continue;
            return true;
        }
        return false;
    }

    private String getQualifiedName(Property property, Object queryObject, SqlQualifierType qualifier) {
        return this.getQualifiedName(property, queryObject, qualifier, null);
    }

    private String getQualifiedName(Property property, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        switch (qualifier) {
            case ALIAS: {
                return this.getAliasQualifiedName(property, queryObject, px);
            }
            case RECORD: {
                return this.getRecordQualifiedName(property, queryObject, px);
            }
            case SUFFIX: {
                return this.getUnqualifiedButSuffixedName(property, queryObject, px);
            }
        }
        return this.getQualifiedName(property, px);
    }

    private String getQualifiedName(Property property, ParameterizedExpression px) {
        if (px == null) {
            return this.getSqlQualifiedName(property);
        }
        String name = this.getSqlParameterName(property);
        px.getParametersMap().put(name, property);
        return name;
    }

    private String getAliasQualifiedName(Property property, Object queryObject, ParameterizedExpression px) {
        Map queryTablesMap;
        QueryTable queryTable = queryObject instanceof QueryTable ? (QueryTable)queryObject : null;
        Map map = queryTablesMap = queryObject instanceof Map ? (Map)queryObject : null;
        return queryTable != null ? this.getAliasQualifiedName(property, queryTable, px) : (queryTablesMap != null ? this.getAliasQualifiedName(property, queryTablesMap, px) : this.getQualifiedName(property, px));
    }

    private String getAliasQualifiedName(Property property, QueryTable queryTable, ParameterizedExpression px) {
        int index = queryTable.getSubqueryIndex();
        for (Property p : queryTable.getColumns()) {
            if (p != property) continue;
            return queryTable.getAlias() + "." + this.getPropertySqlName(p);
        }
        for (QueryJoin j : queryTable.getJoins()) {
            String name = this.getAliasQualifiedName(property, j.getRightTable(), px);
            if (name == null) continue;
            return name;
        }
        return index == 0 ? this.getQualifiedName(property, px) : null;
    }

    private String getAliasQualifiedName(Property property, Map<String, QueryTable> queryTablesMap, ParameterizedExpression px) {
        for (String key : queryTablesMap.keySet()) {
            QueryTable queryTable = queryTablesMap.get(key);
            if (!queryTable.contains(property)) continue;
            return key + "_" + this.getAliasQualifiedName(property, queryTable, px);
        }
        return this.getSqlVariableName(property);
    }

    private String getRecordQualifiedName(Property property, Object queryObject, ParameterizedExpression px) {
        Map queryTablesMap;
        QueryTable queryTable = queryObject instanceof QueryTable ? (QueryTable)queryObject : null;
        Map map = queryTablesMap = queryObject instanceof Map ? (Map)queryObject : null;
        return queryTable != null ? this.getRecordQualifiedName(property, queryTable, px) : (queryTablesMap != null ? this.getRecordQualifiedName(property, queryTablesMap, px) : this.getQualifiedName(property, px));
    }

    private String getRecordQualifiedName(Property property, QueryTable queryTable, ParameterizedExpression px) {
        String name;
        int index = queryTable.getSubqueryIndex();
        String qualifier = this.getSqlJoinQualifier(queryTable);
        for (Property p : queryTable.getColumns()) {
            if (p != property) continue;
            String name2 = index == 0 ? this.getPropertySqlName(p) : this.getPropertySqlAlias(p, queryTable);
            return qualifier + "." + name2;
        }
        for (QueryJoin j : queryTable.getJoins()) {
            name = this.getRecordQualifiedName(property, j.getRightTable(), px);
            if (name == null) continue;
            return name;
        }
        if (index == 0) {
            Entity entity;
            Property primaryKeyProperty;
            if (property instanceof Entity && px == null && (primaryKeyProperty = (entity = (Entity)((Object)property)).getPrimaryKeyProperty()) != null) {
                name = this.getSqlName(primaryKeyProperty);
                return qualifier + "." + name;
            }
            String qualifiedName = this.getQualifiedName(property, px);
            return qualifiedName;
        }
        return null;
    }

    private String getRecordQualifiedName(Property property, Map<String, QueryTable> queryTablesMap, ParameterizedExpression px) {
        for (String key : queryTablesMap.keySet()) {
            QueryTable queryTable = queryTablesMap.get(key);
            if (!queryTable.contains(property)) continue;
            return key + "_" + this.getRecordQualifiedName(property, queryTable, px);
        }
        return this.getSqlVariableName(property);
    }

    private String getUnqualifiedButSuffixedName(Property property, Object queryObject, ParameterizedExpression px) {
        Map queryTablesMap;
        QueryTable queryTable = queryObject instanceof QueryTable ? (QueryTable)queryObject : null;
        Map map = queryTablesMap = queryObject instanceof Map ? (Map)queryObject : null;
        return queryTable != null ? this.getUnqualifiedButSuffixedName(property, queryTable, px) : (queryTablesMap != null ? this.getUnqualifiedButSuffixedName(property, queryTablesMap, px) : this.getQualifiedName(property, px));
    }

    private String getUnqualifiedButSuffixedName(Property property, QueryTable queryTable, ParameterizedExpression px) {
        int index = queryTable.getSubqueryIndex();
        for (Property p : queryTable.getColumns()) {
            if (p != property) continue;
            String name = index == 0 ? this.getPropertySqlName(p) : this.getPropertySqlAlias(p, queryTable);
            return name;
        }
        for (QueryJoin j : queryTable.getJoins()) {
            String name = this.getUnqualifiedButSuffixedName(property, j.getRightTable(), px);
            if (name == null) continue;
            return name;
        }
        return index == 0 ? this.getQualifiedName(property, px) : null;
    }

    private String getUnqualifiedButSuffixedName(Property property, Map<String, QueryTable> queryTablesMap, ParameterizedExpression px) {
        for (String key : queryTablesMap.keySet()) {
            QueryTable queryTable = queryTablesMap.get(key);
            if (!queryTable.contains(property)) continue;
            return key + "." + this.getUnqualifiedButSuffixedName(property, queryTable, px);
        }
        return this.getSqlVariableName(property);
    }

    private String getNamedValueName(NamedValue namedValue, ParameterizedExpression px) {
        String name = namedValue.name();
        if (px != null) {
            px.getNamedValuesMap().put(name, namedValue);
        }
        return name;
    }

    @Override
    public String getSqlSelectStatement(QueryJoin queryJoin, List<Property> referencedColumns, boolean into, boolean where, boolean indent) {
        Object string = this.getSqlSelectStatement(queryJoin.getRightTable(), referencedColumns, into, indent);
        if (where) {
            string = (String)string + EOL$ + this.getSelectWhere(queryJoin);
        }
        return string;
    }

    private String getSelectWhere(QueryJoin queryJoin) {
        Object string = this.getWhere();
        QueryTable lt = queryJoin.getLeftTable();
        QueryTable rt = queryJoin.getRightTable();
        Property lc = queryJoin.getLeftColumn();
        Property rc = queryJoin.getRightColumn();
        string = (String)string + " " + rt.getAlias() + "." + this.getPropertySqlName(rc);
        string = (String)string + " " + this.getEQ() + " " + this.getSqlJoinQualifier(lt) + "." + this.getPropertySqlName(lc);
        return string;
    }

    @Override
    public String getSqlStandardRelationalExpression(String arg1, StandardRelationalOp operator) {
        return this.getSqlStandardRelationalExpression(arg1, operator, "?");
    }

    @Override
    public String getSqlStandardRelationalExpression(String arg1, StandardRelationalOp op, String arg2) {
        String expression;
        StandardRelationalOp operator = op == null ? StandardRelationalOp.EQ : op;
        switch (operator) {
            case UNSPECIFIED: 
            case EQ: {
                expression = this.getIsNotNullAnd(arg1) + this.getEQ() + " " + arg2;
                break;
            }
            case NEQ: {
                expression = this.getIsNotNullAnd(arg1) + this.getNEQ() + " " + arg2;
                break;
            }
            case GT: {
                expression = this.getIsNotNullAnd(arg1) + this.getGT() + " " + arg2;
                break;
            }
            case GTEQ: {
                expression = this.getIsNotNullAnd(arg1) + this.getGTEQ() + " " + arg2;
                break;
            }
            case LT: {
                expression = this.getIsNotNullAnd(arg1) + this.getLT() + " " + arg2;
                break;
            }
            case LTEQ: {
                expression = this.getIsNotNullAnd(arg1) + this.getLTEQ() + " " + arg2;
                break;
            }
            case LIKE: {
                expression = this.getIsNotNullAnd(arg1) + this.getLike() + " " + this.startsWithArgument(1);
                break;
            }
            case NOT_LIKE: {
                expression = this.getIsNotNullAnd(arg1) + this.getNotLike() + " " + this.startsWithArgument(1);
                break;
            }
            case IS_NULL_OR_EQ: {
                expression = this.getIsNullOr(arg1) + this.getEQ() + " " + arg2;
                break;
            }
            case IS_NULL_OR_NEQ: {
                expression = this.getIsNullOr(arg1) + this.getNEQ() + " " + arg2;
                break;
            }
            case IS_NULL_OR_GT: {
                expression = this.getIsNullOr(arg1) + this.getGT() + " " + arg2;
                break;
            }
            case IS_NULL_OR_LTEQ: {
                expression = this.getIsNullOr(arg1) + this.getLTEQ() + " " + arg2;
                break;
            }
            case IS_NULL_OR_GTEQ: {
                expression = this.getIsNullOr(arg1) + this.getGTEQ() + " " + arg2;
                break;
            }
            case IS_NULL_OR_LT: {
                expression = this.getIsNullOr(arg1) + this.getLT() + " " + arg2;
                break;
            }
            case IS_NULL_OR_LIKE: {
                expression = this.getIsNullOr(arg1) + this.getLike() + " " + this.startsWithArgument(1);
                break;
            }
            case IS_NULL_OR_NOT_LIKE: {
                expression = this.getIsNullOr(arg1) + this.getNotLike() + " " + this.startsWithArgument(1);
                break;
            }
            default: {
                expression = arg1 + " " + this.getEQ() + " " + arg2;
            }
        }
        return expression;
    }

    private String startsWithArgument(int index) {
        String argx = "{" + index + "}";
        String like = "'" + this.getLikeString() + "'";
        return argx + this.getConcat() + like;
    }

    private String containsArgument(int index) {
        String argx = "{" + index + "}";
        String like = "'" + this.getLikeString() + "'";
        return like + this.getConcat() + argx + this.getConcat() + like;
    }

    private String endsWithArgument(int index) {
        String argx = "{" + index + "}";
        String like = "'" + this.getLikeString() + "'";
        return like + this.getConcat() + argx;
    }

    private String average(String ... strings) {
        String case$ = this.getAverageCasePattern();
        String arg0$ = this.join(EMPTY, this.getAdd(), strings);
        String arg1$ = this.count(strings);
        String[] placeHolders = new String[]{"{0}", "{1}"};
        String[] argumentList = new String[]{arg0$, arg1$};
        return StringUtils.replaceEach((String)case$, (String[])placeHolders, (String[])argumentList);
    }

    protected String getAverageCasePattern() {
        return "case when {1} = 0 then null else {0} / {1} end";
    }

    private String count(String ... strings) {
        String case$ = this.getCountCasePattern();
        int i = 0;
        String[] strings1 = new String[strings.length];
        for (String expresion : strings) {
            if (!StringUtils.isNotBlank((String)expresion)) continue;
            strings1[i++] = case$.replace("{0}", this.singleQuotedOrInParentheses(expresion));
        }
        return this.join(EMPTY, this.getAdd(), strings1);
    }

    protected String getCountCasePattern() {
        return "case when {0} is null then 0 else 1 end";
    }

    private String maximum(String ... strings) {
        return this.imum(this.getGTEQ(), strings);
    }

    private String minimum(String ... strings) {
        return this.imum(this.getLTEQ(), strings);
    }

    private String imum(String comparador, String ... strings) {
        Object case$ = "case ";
        String when$ = "when {1} then {0} ";
        String else$ = "else null end";
        String conector = this.getAnd();
        String[] placeHolders = new String[]{"{0}", "{1}"};
        Object[] strings1 = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            String arg1$;
            String arg0$ = strings[i];
            if (!StringUtils.isNotBlank((String)arg0$)) continue;
            Arrays.fill(strings1, EMPTY);
            int i1 = 0;
            for (int j = 0; j < strings.length; ++j) {
                if (i == j || !StringUtils.isNotBlank((String)(arg1$ = strings[j]))) continue;
                strings1[i1++] = this.join(EMPTY, comparador, arg0$, arg1$);
            }
            arg1$ = this.join(EMPTY, conector, (String[])strings1);
            case$ = (String)case$ + StringUtils.replaceEach((String)when$, (String[])placeHolders, (String[])new String[]{arg0$, arg1$});
        }
        return (String)case$ + else$;
    }

    protected String bind(String op1, String string) {
        String op1$ = StringUtils.trimToEmpty((String)op1);
        String expresion = StringUtils.trimToEmpty((String)string);
        if (StringUtils.isNotBlank((String)op1$) && StringUtils.isNotBlank((String)expresion)) {
            return op1$ + this.inParentheses(expresion);
        }
        return expresion;
    }

    protected String call(Operator operator, int arguments) {
        String function = operator.name().toLowerCase();
        return this.call(function, arguments);
    }

    protected String call(String function, int arguments) {
        String[] placeHolders = null;
        if (arguments > 0) {
            placeHolders = new String[arguments];
            for (int i = 0; i < arguments; ++i) {
                placeHolders[i] = "{" + i + "}";
            }
        }
        return this.call(function, placeHolders);
    }

    protected String call(Operator operator, String ... arguments) {
        String function = operator.name().toLowerCase();
        return this.call(function, arguments);
    }

    protected String call(String function, String ... arguments) {
        String string = arguments == null || arguments.length == 0 ? "()" : StrUtils.encloseSqlExpression(StringUtils.join((Object[])arguments, (String)SEPX));
        return function + string;
    }

    protected String join(String op1, String op2, String ... strings) {
        String op1$ = StringUtils.equals((String)op1, (String)op2) ? EMPTY : StringUtils.trimToEmpty((String)op1);
        String op2$ = " " + StringUtils.trimToEmpty((String)op2) + " ";
        Object expresiones = EMPTY;
        boolean b = op1$.equals(this.getCast()) || op1$.equals(this.getCoalesce());
        int n = 0;
        for (String string : strings) {
            if (!StringUtils.isNotBlank((String)string)) continue;
            String expresion = b ? StringUtils.trimToEmpty((String)string) : this.caseSingleQuotedOrInParentheses(string);
            expresiones = (String)expresiones + op2$ + expresion;
            ++n;
        }
        if (n > 0) {
            expresiones = StringUtils.removeStart((String)expresiones, (String)op2$);
            if (StringUtils.isNotBlank((String)op1$)) {
                return op1$ + this.inParentheses((String)expresiones);
            }
        }
        return this.inParentheses((String)expresiones);
    }

    protected String and(String ... arguments) {
        return this.connect(this.getAnd(), arguments);
    }

    protected String or(String ... arguments) {
        return this.connect(this.getOr(), arguments);
    }

    protected String xor(String ... arguments) {
        int l = arguments.length;
        int m = l - 1;
        int n = 0;
        for (int i = 1; i < l; ++i) {
            n += i;
        }
        String[] ands = new String[n];
        int index = 0;
        for (int i = 0; i < m; ++i) {
            for (int j = i + 1; j < l; ++j) {
                ands[index++] = this.and(arguments[i], arguments[j]);
            }
        }
        return this.and(this.or(arguments), this.not(this.or(ands)));
    }

    protected String not(String argument) {
        return this.getNot() + StrUtils.encloseSqlExpression(argument);
    }

    protected String connect(char connective, String ... arguments) {
        return StrUtils.encloseSqlExpression(StringUtils.join((Object[])arguments, (String)(connective + " ")));
    }

    protected String connect(String connective, String ... arguments) {
        return StrUtils.encloseSqlExpression(StringUtils.join((Object[])arguments, (String)(" " + connective + " ")));
    }

    private boolean isCase(String string) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        String case$ = this.getCase() + " ";
        String end$ = " " + this.getEnd();
        String s = StringUtils.trimToEmpty((String)string);
        return StringUtils.startsWithIgnoreCase((String)s, (String)case$) && StringUtils.endsWithIgnoreCase((String)s, (String)end$);
    }

    private boolean isSingle(String string) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        String s = StringUtils.trimToEmpty((String)string);
        return !s.contains(" ");
    }

    private boolean isQuoted(String string) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        String s = StringUtils.trimToEmpty((String)string);
        return StrUtils.isDelimited(s, '\'');
    }

    private boolean isInParentheses(String string) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        String[] searchStrings = (String[])ArrayUtils.add((Object[])this.stringsOperadorExpresionUnario(), (Object)this.getCoalesce());
        String s = this.removeStart(string, searchStrings);
        return StrUtils.isDelimited(s, '(', ')');
    }

    private String[] stringsOperadorExpresionUnario() {
        ScalarOp[] enums = ScalarOp.values();
        String[] strings = null;
        for (ScalarOp sop : enums) {
            String string = this.getString(sop);
            if (!StringUtils.isNotBlank((String)string)) continue;
            strings = (String[])ArrayUtils.add(strings, (Object)StringUtils.trimToEmpty((String)string));
        }
        return strings;
    }

    private String removeStart(String string, String[] searchStrings) {
        String s = StringUtils.trimToEmpty((String)string);
        for (String searchString : searchStrings) {
            String p;
            if (!StringUtils.isNotBlank((String)searchString) || !StringUtils.startsWithIgnoreCase((String)s, (String)(p = StringUtils.trimToEmpty((String)searchString)))) continue;
            return StringUtils.trimToEmpty((String)StringUtils.removeStartIgnoreCase((String)s, (String)p));
        }
        return s;
    }

    private String caseSingleQuotedOrInParentheses(String string) {
        String s = StringUtils.trimToEmpty((String)string);
        boolean b = StringUtils.isBlank((String)s) || this.isCase(s);
        return b ? s : this.singleQuotedOrInParentheses(s);
    }

    private String singleQuotedOrInParentheses(String string) {
        String s = StringUtils.trimToEmpty((String)string);
        boolean b = StringUtils.isBlank((String)s) || this.isSingle(s);
        return b ? s : this.quotedOrInParentheses(s);
    }

    private String quotedOrInParentheses(String string) {
        String s = StringUtils.trimToEmpty((String)string);
        boolean b = StringUtils.isBlank((String)s) || this.isQuoted(s);
        return b ? s : this.inParentheses(s);
    }

    private String inParentheses(String string) {
        String s = StringUtils.trimToEmpty((String)string);
        boolean b = StringUtils.isBlank((String)s) || this.isInParentheses(s);
        return b ? s : "(" + s + ")";
    }
}

