/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.wrappers;

import adalid.commons.bundles.Bundle;
import adalid.commons.i18n.Linguist;
import adalid.commons.interfaces.Wrapper;
import adalid.commons.util.StrUtils;
import adalid.core.Operation;
import adalid.core.enums.KeyProperty;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BundleProgrammer;
import adalid.core.interfaces.DataArtifact;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityReference;
import adalid.core.interfaces.JavaProgrammer;
import adalid.core.interfaces.Parameter;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.SqlProgrammer;
import adalid.core.primitives.NumericPrimitive;
import adalid.core.programmers.ChiefProgrammer;
import adalid.core.programmers.ParameterizedExpression;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;

public class ArtifactWrapper
implements Wrapper {
    private final Artifact _artifact;
    private final DataArtifact _dataArtifact;
    private final Property _property;

    public ArtifactWrapper(Artifact artifact) {
        this._artifact = artifact;
        this._dataArtifact = this._artifact instanceof DataArtifact ? (DataArtifact)this._artifact : null;
        this._property = this._artifact instanceof Property ? (Property)this._artifact : null;
    }

    @Override
    public Artifact getWrapped() {
        return this._artifact;
    }

    public String getDottedName() {
        String string = this._artifact.getName();
        return StrUtils.getLowerCaseIdentifier(string, '.');
    }

    public String getDottedAlias() {
        String string = StrUtils.coalesce(this._artifact.getAlias(), this._artifact.getName());
        return StrUtils.getLowerCaseIdentifier(string, '.');
    }

    public String getHyphenatedName() {
        String string = this._artifact.getName();
        return StrUtils.getLowerCaseIdentifier(string, '-');
    }

    public String getHyphenatedAlias() {
        String string = StrUtils.coalesce(this._artifact.getAlias(), this._artifact.getName());
        return StrUtils.getLowerCaseIdentifier(string, '-');
    }

    public String getUnderscoredName() {
        String string = this._artifact.getName();
        return StrUtils.getLowerCaseIdentifier(string, '_');
    }

    public String getUnderscoredAlias() {
        String string = StrUtils.coalesce(this._artifact.getAlias(), this._artifact.getName());
        return StrUtils.getLowerCaseIdentifier(string, '_');
    }

    public String getWordyName() {
        String string = this._artifact.getName();
        return StrUtils.getWordyString(string);
    }

    public String getWordyAlias() {
        String string = StrUtils.coalesce(this._artifact.getAlias(), this._artifact.getName());
        return StrUtils.getWordyString(string);
    }

    public String getValidDefaultLabel() {
        return StrUtils.coalesce(this.getDefaultLabel(), this.getSomeLabel());
    }

    public String getValidDefaultShortLabel() {
        return this.getValidDefaultShortLabel(true);
    }

    public String getValidDefaultShortLabel(boolean b) {
        return StrUtils.coalesce(this.getDefaultShortLabel(), this.getDefaultLabel(), this.getSomeShortLabel(b));
    }

    public String getValidDefaultCollectionLabel() {
        return StrUtils.coalesce(this.getDefaultCollectionLabel(), this.pluralOfValidDefaultLabel(true));
    }

    private String pluralOfValidDefaultLabel(boolean capitalize) {
        Linguist linguist = Bundle.getLinguist();
        if (linguist == null) {
            return this.getValidDefaultLabel();
        }
        String plural = linguist.pluralOfMultiwordExpression(this.getValidDefaultLabel());
        return capitalize ? linguist.capitalize(plural) : plural;
    }

    public String getValidDefaultCollectionShortLabel() {
        return StrUtils.coalesce(this.getDefaultCollectionShortLabel(), this.getDefaultCollectionLabel(), this.pluralOfValidDefaultShortLabel(true));
    }

    private String pluralOfValidDefaultShortLabel(boolean capitalize) {
        Linguist linguist = Bundle.getLinguist();
        if (linguist == null) {
            return this.getValidDefaultShortLabel();
        }
        String plural = linguist.pluralOfMultiwordExpression(this.getValidDefaultShortLabel());
        return capitalize ? linguist.capitalize(plural) : plural;
    }

    public String getValidDefaultDescription() {
        return StrUtils.coalesce(this.getDefaultDescription(), this.getValidDefaultLabel());
    }

    public String getValidDefaultShortDescription() {
        return StrUtils.coalesce(this.getDefaultShortDescription(), this.getValidDefaultDescription());
    }

    public String getValidDefaultTooltip() {
        return StrUtils.coalesce(this.getDefaultTooltip(), this.getValidDefaultShortDescription());
    }

    public String getValidDefaultSymbol() {
        return StrUtils.coalesce(this.getDefaultSymbol(), this.someSymbol());
    }

    protected String someSymbol() {
        Artifact defaultArtifact = this.defaultArtifact();
        if (defaultArtifact instanceof NumericPrimitive) {
            NumericPrimitive numericPrimitive = (NumericPrimitive)defaultArtifact;
            return StringUtils.trimToEmpty((String)numericPrimitive.getSymbol());
        }
        return "";
    }

    protected String getDefaultLabel() {
        return this.defaultArtifact().getDefaultLabel();
    }

    protected String getDefaultShortLabel() {
        return this.defaultArtifact().getDefaultShortLabel();
    }

    protected String getDefaultCollectionLabel() {
        return this._artifact.getDefaultCollectionLabel();
    }

    protected String getDefaultCollectionShortLabel() {
        return this._artifact.getDefaultCollectionShortLabel();
    }

    protected String getDefaultDescription() {
        String defaultDescription = this.defaultArtifact().getDefaultDescription();
        return defaultDescription == null ? this.linkedPropertyDefaultDescription() : defaultDescription;
    }

    private String linkedPropertyDefaultDescription() {
        Property linkedProperty = this.linkedProperty();
        return linkedProperty == null ? null : linkedProperty.getDefaultDescription();
    }

    protected String getDefaultShortDescription() {
        String defaultShortDescription = this.defaultArtifact().getDefaultShortDescription();
        return defaultShortDescription == null ? this.linkedPropertyDefaultShortDescription() : defaultShortDescription;
    }

    private String linkedPropertyDefaultShortDescription() {
        Property linkedProperty = this.linkedProperty();
        return linkedProperty == null ? null : linkedProperty.getDefaultShortDescription();
    }

    protected String getDefaultTooltip() {
        String defaultTooltip = this.defaultArtifact().getDefaultTooltip();
        return defaultTooltip == null ? this.linkedPropertyDefaultTooltip() : defaultTooltip;
    }

    private String linkedPropertyDefaultTooltip() {
        Property linkedProperty = this.linkedProperty();
        return linkedProperty == null ? null : linkedProperty.getDefaultTooltip();
    }

    protected String getDefaultSymbol() {
        String defaultSymbol = this.defaultArtifact().getDefaultSymbol();
        return defaultSymbol == null ? this.linkedPropertyDefaultSymbol() : defaultSymbol;
    }

    private String linkedPropertyDefaultSymbol() {
        Property linkedProperty = this.linkedProperty();
        return linkedProperty == null ? null : linkedProperty.getDefaultSymbol();
    }

    private Artifact defaultArtifact() {
        return this._dataArtifact != null && this._dataArtifact.isProperty() ? this._property.getPropertyAtRoot() : this._artifact;
    }

    private Property linkedProperty() {
        Parameter parameter;
        Property linkedProperty;
        if (this._dataArtifact != null && this._dataArtifact.isParameter() && (linkedProperty = (parameter = (Parameter)this._dataArtifact).getLinkedProperty()) != null) {
            return linkedProperty.getPropertyAtRoot();
        }
        return null;
    }

    protected String getSomeLabel() {
        Parameter parameter;
        Entity declaringOperationEntity;
        String string = this.getWordyName();
        Entity declaringEntity = this._artifact.getDeclaringEntity();
        Operation declaringOperation = this._artifact.getDeclaringOperation();
        Entity entity = declaringOperationEntity = declaringOperation == null ? null : declaringOperation.getDeclaringEntity();
        if (this._artifact instanceof Property && declaringEntity != null) {
            Property property = (Property)this._artifact;
            if (!property.isNotDeclared()) {
                string = this._artifact.equals(declaringEntity.getPrimaryKeyProperty()) ? this.labelOf(declaringEntity, KeyProperty.PRIMARY_KEY) : (this._artifact.equals(declaringEntity.getSequenceProperty()) ? this.labelOf(declaringEntity, KeyProperty.SEQUENCE) : (this._artifact.equals(declaringEntity.getVersionProperty()) ? this.labelOf(declaringEntity, KeyProperty.VERSION) : (this._artifact.equals(declaringEntity.getBusinessKeyProperty()) ? this.labelOf(declaringEntity, KeyProperty.BUSINESS_KEY) : (this._artifact.equals(declaringEntity.getNumericKeyProperty()) ? this.labelOf(declaringEntity, KeyProperty.NUMERIC_KEY) : (this._artifact.equals(declaringEntity.getCharacterKeyProperty()) ? this.labelOf(declaringEntity, KeyProperty.CHARACTER_KEY) : (this._artifact.equals(declaringEntity.getNameProperty()) ? this.labelOf(declaringEntity, KeyProperty.NAME) : (this._artifact.equals(declaringEntity.getDescriptionProperty()) ? this.labelOf(declaringEntity, KeyProperty.DESCRIPTION) : (this._artifact.equals(declaringEntity.getImageProperty()) ? this.labelOf(declaringEntity, KeyProperty.IMAGE) : (this._artifact.equals(declaringEntity.getInactiveIndicatorProperty()) ? this.labelOf(declaringEntity, KeyProperty.INACTIVE_INDICATOR) : (this._artifact.equals(declaringEntity.getUrlProperty()) ? this.labelOf(declaringEntity, KeyProperty.URL) : (this._artifact.equals(declaringEntity.getParentProperty()) ? this.labelOf(declaringEntity, KeyProperty.PARENT) : (this._artifact.equals(declaringEntity.getOwnerProperty()) ? this.labelOf(declaringEntity, KeyProperty.OWNER) : (this._artifact.equals(declaringEntity.getUserProperty()) ? this.labelOf(declaringEntity, KeyProperty.USER) : (this._artifact instanceof EntityReference ? StrUtils.removeWords(string, EntityReference.class) : StrUtils.removeWords(string, property.getDataType())))))))))))))));
            }
        } else if (this._artifact instanceof Parameter && declaringOperationEntity != null && !(parameter = (Parameter)this._artifact).isNotDeclared()) {
            string = this._artifact instanceof EntityReference ? StrUtils.removeWords(string, EntityReference.class) : StrUtils.removeWords(string, parameter.getDataType());
        }
        string = StringUtils.trim((String)StringUtils.replace((String)string, (String)"  ", (String)" "));
        return StringUtils.isNotBlank((String)string) ? string : this.getWordyName();
    }

    protected String getSomeShortLabel(boolean b) {
        Parameter parameter;
        String declaringOperationEntityName;
        String string = this.getWordyName();
        Entity declaringEntity = this._artifact.getDeclaringEntity();
        String declaringEntityName = declaringEntity == null ? null : StrUtils.getWordyString(declaringEntity.getName());
        Operation declaringOperation = this._artifact.getDeclaringOperation();
        Entity declaringOperationEntity = declaringOperation == null ? null : declaringOperation.getDeclaringEntity();
        String string2 = declaringOperationEntityName = declaringOperationEntity == null ? null : StrUtils.getWordyString(declaringOperationEntity.getName());
        if (this._artifact instanceof Property && declaringEntity != null) {
            Property property = (Property)this._artifact;
            if (!property.isNotDeclared()) {
                if (this._artifact.equals(declaringEntity.getPrimaryKeyProperty())) {
                    string = this.shortLabelOf(declaringEntity, KeyProperty.PRIMARY_KEY, b);
                } else if (this._artifact.equals(declaringEntity.getSequenceProperty())) {
                    string = this.shortLabelOf(declaringEntity, KeyProperty.SEQUENCE, b);
                } else if (this._artifact.equals(declaringEntity.getVersionProperty())) {
                    string = this.shortLabelOf(declaringEntity, KeyProperty.VERSION, b);
                } else if (this._artifact.equals(declaringEntity.getBusinessKeyProperty())) {
                    string = this.shortLabelOf(declaringEntity, KeyProperty.BUSINESS_KEY, b);
                } else if (this._artifact.equals(declaringEntity.getNumericKeyProperty())) {
                    string = this.shortLabelOf(declaringEntity, KeyProperty.NUMERIC_KEY, b);
                } else if (this._artifact.equals(declaringEntity.getCharacterKeyProperty())) {
                    string = this.shortLabelOf(declaringEntity, KeyProperty.CHARACTER_KEY, b);
                } else if (this._artifact.equals(declaringEntity.getNameProperty())) {
                    string = this.shortLabelOf(declaringEntity, KeyProperty.NAME, b);
                } else if (this._artifact.equals(declaringEntity.getDescriptionProperty())) {
                    string = this.shortLabelOf(declaringEntity, KeyProperty.DESCRIPTION, b);
                } else if (this._artifact.equals(declaringEntity.getImageProperty())) {
                    string = this.shortLabelOf(declaringEntity, KeyProperty.IMAGE, b);
                } else if (this._artifact.equals(declaringEntity.getInactiveIndicatorProperty())) {
                    string = this.shortLabelOf(declaringEntity, KeyProperty.INACTIVE_INDICATOR, b);
                } else if (this._artifact.equals(declaringEntity.getUrlProperty())) {
                    string = this.shortLabelOf(declaringEntity, KeyProperty.URL, b);
                } else if (this._artifact.equals(declaringEntity.getParentProperty())) {
                    string = this.shortLabelOf(declaringEntity, KeyProperty.PARENT, b);
                } else if (this._artifact.equals(declaringEntity.getOwnerProperty())) {
                    string = this.shortLabelOf(declaringEntity, KeyProperty.OWNER, b);
                } else if (this._artifact.equals(declaringEntity.getUserProperty())) {
                    string = this.shortLabelOf(declaringEntity, KeyProperty.USER, b);
                } else if (this._artifact instanceof EntityReference) {
                    string = StrUtils.removeWords(string, EntityReference.class);
                    string = StrUtils.removeWholeWord(string, declaringEntityName);
                } else {
                    string = StrUtils.removeWords(string, property.getDataType());
                    string = StrUtils.removeWholeWord(string, declaringEntityName);
                }
            }
        } else if (this._artifact instanceof Parameter && declaringOperationEntity != null && !(parameter = (Parameter)this._artifact).isNotDeclared()) {
            if (this._artifact instanceof EntityReference) {
                string = StrUtils.removeWords(string, EntityReference.class);
                string = StrUtils.removeWholeWord(string, declaringOperationEntityName);
            } else {
                string = StrUtils.removeWords(string, parameter.getDataType());
                string = StrUtils.removeWholeWord(string, declaringOperationEntityName);
            }
        }
        string = StringUtils.trim((String)StringUtils.replace((String)string, (String)"  ", (String)" "));
        return StringUtils.isNotBlank((String)string) ? string : this.getWordyName();
    }

    private String labelOf(Entity entity) {
        String label = entity == null ? null : entity.getDefaultLabel();
        String name = entity == null ? null : entity.getName();
        return StringUtils.isNotBlank((String)label) ? label : StrUtils.removeWords(StrUtils.getWordyString(name), EntityReference.class);
    }

    private String shortLabelOf(Entity entity) {
        String label = entity == null ? null : entity.getDefaultShortLabel();
        return StringUtils.isNotBlank((String)label) ? label : this.labelOf(entity);
    }

    private String labelOf(Entity entity, KeyProperty keyProperty) {
        if (entity.depth() == 0) {
            if (KeyProperty.PRIMARY_KEY.equals((Object)keyProperty)) {
                return this.labelOf(entity);
            }
            if (KeyProperty.VERSION.equals((Object)keyProperty)) {
                return this.keyLabelOf(entity, keyProperty, false);
            }
        }
        if (entity.depth() == 1) {
            if (KeyProperty.BUSINESS_KEY.equals((Object)keyProperty)) {
                return this.keyLabelOf(entity, keyProperty, false);
            }
            if (KeyProperty.NAME.equals((Object)keyProperty)) {
                return this.keyLabelOf(entity, keyProperty, false);
            }
        }
        return this.shortWordyLabel(entity, false);
    }

    private String shortLabelOf(Entity entity, KeyProperty keyProperty, boolean b) {
        if (entity.depth() == 0) {
            if (KeyProperty.PRIMARY_KEY.equals((Object)keyProperty)) {
                return this.shortLabelOf(entity);
            }
            if (KeyProperty.VERSION.equals((Object)keyProperty)) {
                return keyProperty.getLabel();
            }
            return this.shortKeyLabelOf(entity);
        }
        if (b && entity.depth() == 1) {
            if (KeyProperty.BUSINESS_KEY.equals((Object)keyProperty)) {
                return this.keyLabelOf(entity, keyProperty, true);
            }
            if (KeyProperty.NAME.equals((Object)keyProperty)) {
                return this.keyLabelOf(entity, keyProperty, true);
            }
        }
        return this.shortWordyName(entity.getRoot());
    }

    private String keyLabelOf(Entity entity, KeyProperty keyProperty, boolean shortest) {
        String pattern = keyProperty.getLabelPattern();
        String label = shortest ? this.shortLabelOf(entity) : this.labelOf(entity);
        String connector = entity.getResourceGender() == null ? "" : entity.getResourceGender().getConnector();
        String string = MessageFormat.format(pattern, label, connector);
        string = StringUtils.trim((String)StringUtils.replace((String)string, (String)"  ", (String)" "));
        return string;
    }

    private String shortKeyLabelOf(Entity entity) {
        String string = this.getWordyName();
        String declaringEntityName = StrUtils.getWordyString(entity.getName());
        Property property = (Property)this._artifact;
        string = StrUtils.removeWords(string, property.getDataType());
        string = StrUtils.removeWholeWord(string, declaringEntityName);
        return string;
    }

    private String shortWordyLabel(Entity entity, boolean shortest) {
        String name = this.shortWordyName(entity.getRoot());
        String connector = entity.getResourceGender() == null ? "" : entity.getResourceGender().getConnector();
        String label = shortest ? this.shortLabelOf(entity) : this.labelOf(entity);
        String string = StringUtils.trim((String)StringUtils.replace((String)(name + " " + connector + " " + label), (String)"  ", (String)" "));
        return string;
    }

    private String shortWordyName(Entity entity) {
        return StrUtils.removeWholeWord(this.getWordyName(), StrUtils.getWordyString(entity.getName()));
    }

    public String getBundleWordyName() {
        return this.getBundleValueString(this.getWordyName());
    }

    public String getBundleWordyAlias() {
        return this.getBundleValueString(this.getWordyAlias());
    }

    public String getBundleDefaultLabel() {
        return this.getBundleValueString(this.getDefaultLabel());
    }

    public String getBundleDefaultShortLabel() {
        return this.getBundleValueString(this.getDefaultShortLabel());
    }

    public String getBundleDefaultCollectionLabel() {
        return this.getBundleValueString(this.getDefaultCollectionLabel());
    }

    public String getBundleDefaultCollectionShortLabel() {
        return this.getBundleValueString(this.getDefaultCollectionShortLabel());
    }

    public String getBundleDefaultDescription() {
        return this.getBundleValueString(this.getDefaultDescription());
    }

    public String getBundleDefaultShortDescription() {
        return this.getBundleValueString(this.getDefaultShortDescription());
    }

    public String getBundleDefaultTooltip() {
        return this.getBundleValueString(this.getDefaultTooltip());
    }

    public String getBundleDefaultSymbol() {
        return this.getBundleValueString(this.getDefaultSymbol());
    }

    public String getBundleValidDefaultLabel() {
        return this.getBundleValueString(this.getValidDefaultLabel());
    }

    public String getBundleValidDefaultShortLabel() {
        return this.getBundleValueString(this.getValidDefaultShortLabel());
    }

    public String getBundleValidDefaultCollectionLabel() {
        return this.getBundleValueString(this.getValidDefaultCollectionLabel());
    }

    public String getBundleValidDefaultCollectionShortLabel() {
        return this.getBundleValueString(this.getValidDefaultCollectionShortLabel());
    }

    public String getBundleValidDefaultDescription() {
        return this.getBundleValueString(this.getValidDefaultDescription());
    }

    public String getBundleValidDefaultShortDescription() {
        return this.getBundleValueString(this.getValidDefaultShortDescription());
    }

    public String getBundleValidDefaultTooltip() {
        return this.getBundleValueString(this.getValidDefaultTooltip());
    }

    public String getBundleValidDefaultSymbol() {
        return this.getBundleValueString(this.getValidDefaultSymbol());
    }

    public String getBundleKey() {
        BundleProgrammer bundleProgrammer = ChiefProgrammer.getBundleProgrammer();
        return bundleProgrammer == null ? null : bundleProgrammer.getKeyString(this._artifact);
    }

    protected String getBundleValueString(String string) {
        BundleProgrammer bundleProgrammer = ChiefProgrammer.getBundleProgrammer();
        return bundleProgrammer == null ? StrUtils.getStringJava(string) : bundleProgrammer.getValueString(string);
    }

    public String getJavaClassName() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaClassName(this._artifact);
    }

    public String getJavaConstantName() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaConstantName(this._artifact);
    }

    public String getJavaLowerConstantName() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaLowerConstantName(this._artifact);
    }

    public String getJavaVariableName() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaVariableName(this._artifact);
    }

    public String getJavaName() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaName(this._artifact);
    }

    public String getJavaCapitalizedName() {
        return this.getJavaClassName();
    }

    public String getJavaUncapitalizedName() {
        return this.getJavaVariableName();
    }

    public String getJavaWordyName() {
        return this.getJavaString(this.getWordyName());
    }

    public String getJavaWordyAlias() {
        return this.getJavaString(this.getWordyAlias());
    }

    public String getJavaDefaultLabel() {
        return this.getJavaString(this.getDefaultLabel());
    }

    public String getJavaDefaultShortLabel() {
        return this.getJavaString(this.getDefaultShortLabel());
    }

    public String getJavaDefaultCollectionLabel() {
        return this.getJavaString(this.getDefaultCollectionLabel());
    }

    public String getJavaDefaultCollectionShortLabel() {
        return this.getJavaString(this.getDefaultCollectionShortLabel());
    }

    public String getJavaDefaultDescription() {
        return this.getJavaString(this.getDefaultDescription());
    }

    public String getJavaDefaultShortDescription() {
        return this.getJavaString(this.getDefaultShortDescription());
    }

    public String getJavaDefaultTooltip() {
        return this.getJavaString(this.getDefaultTooltip());
    }

    public String getJavaDefaultSymbol() {
        return this.getJavaString(this.getDefaultSymbol());
    }

    public String getJavaValidDefaultLabel() {
        return this.getJavaString(this.getValidDefaultLabel());
    }

    public String getJavaValidDefaultShortLabel() {
        return this.getJavaString(this.getValidDefaultShortLabel());
    }

    public String getJavaValidDefaultCollectionLabel() {
        return this.getJavaString(this.getValidDefaultCollectionLabel());
    }

    public String getJavaValidDefaultCollectionShortLabel() {
        return this.getJavaString(this.getValidDefaultCollectionShortLabel());
    }

    public String getJavaValidDefaultDescription() {
        return this.getJavaString(this.getValidDefaultDescription());
    }

    public String getJavaValidDefaultShortDescription() {
        return this.getJavaString(this.getValidDefaultShortDescription());
    }

    public String getJavaValidDefaultTooltip() {
        return this.getJavaString(this.getValidDefaultTooltip());
    }

    public String getJavaValidDefaultSymbol() {
        return this.getJavaString(this.getValidDefaultSymbol());
    }

    protected String getJavaString(String string) {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? StrUtils.getStringJava(string) : javaProgrammer.getJavaString(string);
    }

    public String getHtmlWordyName() {
        return this.getHtmlString(this.getWordyName());
    }

    public String getHtmlWordyAlias() {
        return this.getHtmlString(this.getWordyAlias());
    }

    public String getHtmlDefaultLabel() {
        return this.getHtmlString(this.getDefaultLabel());
    }

    public String getHtmlDefaultShortLabel() {
        return this.getHtmlString(this.getDefaultShortLabel());
    }

    public String getHtmlDefaultCollectionLabel() {
        return this.getHtmlString(this.getDefaultCollectionLabel());
    }

    public String getHtmlDefaultCollectionShortLabel() {
        return this.getHtmlString(this.getDefaultCollectionShortLabel());
    }

    public String getHtmlDefaultDescription() {
        return this.getHtmlFormattedString(this.getDefaultDescription());
    }

    public String getXhtmlDefaultDescription() {
        return this.getXhtmlFormattedString(this.getDefaultDescription());
    }

    public String getHtmlDefaultShortDescription() {
        return this.getHtmlString(this.getDefaultShortDescription());
    }

    public String getHtmlDefaultTooltip() {
        return this.getHtmlString(this.getDefaultTooltip());
    }

    public String getHtmlDefaultSymbol() {
        return this.getHtmlString(this.getDefaultSymbol());
    }

    public String getHtmlValidDefaultLabel() {
        return this.getHtmlString(this.getValidDefaultLabel());
    }

    public String getHtmlValidDefaultShortLabel() {
        return this.getHtmlString(this.getValidDefaultShortLabel());
    }

    public String getHtmlValidDefaultCollectionLabel() {
        return this.getHtmlString(this.getValidDefaultCollectionLabel());
    }

    public String getHtmlValidDefaultCollectionShortLabel() {
        return this.getHtmlString(this.getValidDefaultCollectionShortLabel());
    }

    public String getHtmlValidDefaultDescription() {
        return this.getHtmlString(this.getValidDefaultDescription());
    }

    public String getHtmlValidDefaultShortDescription() {
        return this.getHtmlString(this.getValidDefaultShortDescription());
    }

    public String getHtmlValidDefaultTooltip() {
        return this.getHtmlString(this.getValidDefaultTooltip());
    }

    public String getHtmlValidDefaultSymbol() {
        return this.getHtmlString(this.getValidDefaultSymbol());
    }

    protected String getHtmlString(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        String html = StrUtils.getStringHtml(string);
        return html.replaceAll("\\p{Cntrl}", "");
    }

    protected String getHtmlFormattedString(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        String br = "<br>";
        String nbsp = "&nbsp;";
        String ulli = "<ul><li>";
        String lili = "</li><li>";
        String liul = "</li></ul>";
        String ULLI = "\n\r\n\t";
        String LILI = "\n\t";
        String LIUL = "\n\r\n";
        String[] BULLETS = new String[]{"*", "-", "&bull;", "&middot;"};
        String html = StrUtils.getStringHtml(StringUtils.capitalize((String)string));
        for (String bullet : BULLETS) {
            html = StringUtils.replace((String)html, (String)("\n\r\n\t" + bullet + "\t"), (String)"<ul><li>");
            html = StringUtils.replace((String)html, (String)("\n\r\n\t" + bullet), (String)"<ul><li>");
        }
        for (String bullet : BULLETS) {
            html = StringUtils.replace((String)html, (String)("\n\t" + bullet + "\t"), (String)"</li><li>");
            html = StringUtils.replace((String)html, (String)("\n\t" + bullet), (String)"</li><li>");
        }
        html = html.replace("\n\r\n", "</li></ul>").replace("\b", "&nbsp;").replace("\n", "<br>").replace("\t", StringUtils.repeat((String)"&nbsp;", (int)8));
        String[] a = new String[]{"<a href=", ">", "</a>"};
        String[] A = new String[]{"\r\f", "\f\f", "\f\r"};
        for (int i = 0; i < A.length; ++i) {
            html = StringUtils.replace((String)html, (String)A[i], (String)a[i]);
        }
        return html.replaceAll("\\p{Cntrl}", "");
    }

    protected String getXhtmlString(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        String br1 = "<br>";
        String br2 = "<br/>";
        String html = this.getHtmlString(string);
        return StringUtils.replace((String)html, (String)"<br>", (String)"<br/>");
    }

    protected String getXhtmlFormattedString(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        String br1 = "<br>";
        String br2 = "<br/>";
        String html = this.getHtmlFormattedString(string);
        return StringUtils.replace((String)html, (String)"<br>", (String)"<br/>");
    }

    public String getXmlWordyName() {
        return this.getXmlString(this.getWordyName());
    }

    public String getXmlWordyAlias() {
        return this.getXmlString(this.getWordyAlias());
    }

    public String getXmlDefaultLabel() {
        return this.getXmlString(this.getDefaultLabel());
    }

    public String getXmlDefaultShortLabel() {
        return this.getXmlString(this.getDefaultShortLabel());
    }

    public String getXmlDefaultCollectionLabel() {
        return this.getXmlString(this.getDefaultCollectionLabel());
    }

    public String getXmlDefaultCollectionShortLabel() {
        return this.getXmlString(this.getDefaultCollectionShortLabel());
    }

    public String getXmlDefaultDescription() {
        return this.getXmlString(this.getDefaultDescription());
    }

    public String getXmlDefaultShortDescription() {
        return this.getXmlString(this.getDefaultShortDescription());
    }

    public String getXmlDefaultTooltip() {
        return this.getXmlString(this.getDefaultTooltip());
    }

    public String getXmlDefaultSymbol() {
        return this.getXmlString(this.getDefaultSymbol());
    }

    public String getXmlValidDefaultLabel() {
        return this.getXmlString(this.getValidDefaultLabel());
    }

    public String getXmlValidDefaultShortLabel() {
        return this.getXmlString(this.getValidDefaultShortLabel());
    }

    public String getXmlValidDefaultCollectionLabel() {
        return this.getXmlString(this.getValidDefaultCollectionLabel());
    }

    public String getXmlValidDefaultCollectionShortLabel() {
        return this.getXmlString(this.getValidDefaultCollectionShortLabel());
    }

    public String getXmlValidDefaultDescription() {
        return this.getXmlString(this.getValidDefaultDescription());
    }

    public String getXmlValidDefaultShortDescription() {
        return this.getXmlString(this.getValidDefaultShortDescription());
    }

    public String getXmlValidDefaultTooltip() {
        return this.getXmlString(this.getValidDefaultTooltip());
    }

    public String getXmlValidDefaultSymbol() {
        return this.getXmlString(this.getValidDefaultSymbol());
    }

    protected String getXmlString(String string) {
        return StrUtils.getStringXml(string);
    }

    public String getSqlishName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlishName(this._artifact);
    }

    public String getSqlName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlName(this._artifact);
    }

    public String getSqlName(int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlName(this._artifact, maxIdentifierLength);
    }

    public String getPrefixedSqlName(String prefix) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlName(prefix, this._artifact);
    }

    public String getPrefixedSqlName(String prefix, int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlName(prefix, this._artifact, maxIdentifierLength);
    }

    public String getSuffixedSqlName(String suffix) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlName(this._artifact, suffix);
    }

    public String getSuffixedSqlName(String suffix, int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlName(this._artifact, suffix, maxIdentifierLength);
    }

    public String getAffixedSqlName(String prefix, String suffix) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlName(prefix, this._artifact, suffix);
    }

    public String getAffixedSqlName(String prefix, String suffix, int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlName(prefix, this._artifact, suffix, maxIdentifierLength);
    }

    public String getSqlQualifiedName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlQualifiedName(this._artifact);
    }

    public String getSqlVariableName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlVariableName(this._artifact);
    }

    public String getSqlDefaultLabel() {
        return this.getSqlString(this.getDefaultLabel());
    }

    public String getSqlDefaultShortLabel() {
        return this.getSqlString(this.getDefaultShortLabel());
    }

    public String getSqlDefaultCollectionLabel() {
        return this.getSqlString(this.getDefaultCollectionLabel());
    }

    public String getSqlDefaultCollectionShortLabel() {
        return this.getSqlString(this.getDefaultCollectionShortLabel());
    }

    public String getSqlDefaultDescription() {
        return this.getSqlString(this.getDefaultDescription());
    }

    public String getSqlDefaultShortDescription() {
        return this.getSqlString(this.getDefaultShortDescription());
    }

    public String getSqlDefaultTooltip() {
        return this.getSqlString(this.getDefaultTooltip());
    }

    public String getSqlDefaultSymbol() {
        return this.getSqlString(this.getDefaultSymbol());
    }

    public String getSqlValidDefaultLabel() {
        return this.getSqlString(this.getValidDefaultLabel());
    }

    public String getSqlValidDefaultShortLabel() {
        return this.getSqlString(this.getValidDefaultShortLabel());
    }

    public String getSqlValidDefaultShortLabel(boolean b) {
        return this.getSqlString(this.getValidDefaultShortLabel(b));
    }

    public String getSqlValidDefaultCollectionLabel() {
        return this.getSqlString(this.getValidDefaultCollectionLabel());
    }

    public String getSqlValidDefaultCollectionShortLabel() {
        return this.getSqlString(this.getValidDefaultCollectionShortLabel());
    }

    public String getSqlValidDefaultDescription() {
        return this.getSqlString(this.getValidDefaultDescription());
    }

    public String getSqlValidDefaultShortDescription() {
        return this.getSqlString(this.getValidDefaultShortDescription());
    }

    public String getSqlValidDefaultTooltip() {
        return this.getSqlString(this.getValidDefaultTooltip());
    }

    public String getSqlValidDefaultSymbol() {
        return this.getSqlString(this.getValidDefaultSymbol());
    }

    protected String getSqlString(String string) {
        if (string == null) {
            return null;
        }
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer.getString(string.replaceAll("\\p{Cntrl}", ""));
    }

    public String getSqlExpression() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlExpression(this._artifact);
    }

    public ParameterizedExpression getSqlParameterizedExpression() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlParameterizedExpression(this._artifact);
    }
}

