/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.wrappers;

import adalid.core.data.types.StringData;
import adalid.core.enums.InheritanceMappingStrategy;
import adalid.core.interfaces.DataArtifact;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.IntervalizedArtifact;
import adalid.core.interfaces.JavaProgrammer;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.SqlProgrammer;
import adalid.core.programmers.ChiefProgrammer;
import adalid.core.programmers.ParameterizedExpression;
import adalid.core.sql.QueryTable;
import adalid.core.wrappers.ArtifactWrapper;

public class DataArtifactWrapper
extends ArtifactWrapper {
    private final DataArtifact _dataArtifact;
    private final StringData _stringDataArtifact;
    private final IntervalizedArtifact _intervalizedArtifact;

    public DataArtifactWrapper(DataArtifact dataArtifact) {
        super(dataArtifact);
        this._dataArtifact = dataArtifact;
        this._stringDataArtifact = this._dataArtifact instanceof StringData ? (StringData)this._dataArtifact : null;
        this._intervalizedArtifact = this._dataArtifact instanceof IntervalizedArtifact ? (IntervalizedArtifact)this._dataArtifact : null;
    }

    @Override
    public DataArtifact getWrapped() {
        return this._dataArtifact;
    }

    public String getBundleDefaultRegexErrorMessage() {
        return this._stringDataArtifact == null ? null : this.getBundleValueString(this._stringDataArtifact.getDefaultRegexErrorMessage());
    }

    public String getBundleDefaultRangeErrorMessage() {
        return this._intervalizedArtifact == null ? null : this.getBundleValueString(this._intervalizedArtifact.getDefaultRangeErrorMessage());
    }

    public String getJavaGetter() {
        return "get" + this.getJavaCapitalizedName();
    }

    public String getJavaSetter() {
        return "set" + this.getJavaCapitalizedName();
    }

    public String getJavaType() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaType(this._dataArtifact);
    }

    public String getJavaPrimitiveType() {
        Entity entity = this._dataArtifact instanceof Entity ? (Entity)this._dataArtifact : null;
        DataArtifact dataArtifact = entity != null ? entity.getPrimaryKeyProperty() : this._dataArtifact;
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaType(dataArtifact);
    }

    public String getJavaPrimitiveTypeName() {
        Entity entity = this._dataArtifact instanceof Entity ? (Entity)this._dataArtifact : null;
        DataArtifact dataArtifact = entity != null ? entity.getPrimaryKeyProperty() : this._dataArtifact;
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaTypeName(dataArtifact);
    }

    public String getJavaTypeSimpleName() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaTypeSimpleName(this._dataArtifact);
    }

    public String getJavaInitialValue() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaInitialValue(this._dataArtifact);
    }

    public String getJavaDefaultValue() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaDefaultValue(this._dataArtifact);
    }

    public String getJavaCurrentValue() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaCurrentValue(this._dataArtifact);
    }

    public String getJavaMaximumValue() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaMaximumValue(this._dataArtifact);
    }

    public String getJavaMinimumValue() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaMinimumValue(this._dataArtifact);
    }

    public String getJavaNullifyingValue() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaNullifyingValue(this._dataArtifact);
    }

    public String getJavaPrimitiveValue(Object object) {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaPrimitiveValue(object, this.getJavaPrimitiveType());
    }

    public ParameterizedExpression getJavaParameterizedExpression() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaParameterizedExpression(this._dataArtifact);
    }

    public String getSqlColumnTableName() {
        PersistentEntity pent = this._dataArtifact.isProperty() ? this._dataArtifact.getDeclaringFieldPersistentEntityTableRoot() : null;
        return pent == null ? null : this.sqlTableName(pent);
    }

    private String sqlTableName(Entity entity) {
        Entity base = entity.getBaseRoot();
        PersistentEntity pent = base instanceof PersistentEntity ? (PersistentEntity)base : null;
        InheritanceMappingStrategy ims = pent == null ? null : pent.getInheritanceMappingStrategy();
        return InheritanceMappingStrategy.SINGLE_TABLE.equals((Object)ims) ? this.sqlTableName(pent) : this.sqlName(entity.getRoot());
    }

    private String sqlName(Entity entity) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlName(entity);
    }

    public String getSqlType() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlType(this._dataArtifact);
    }

    public boolean isSqlCharacterLargeObject() {
        return this._stringDataArtifact != null && this.getSqlMaxLength() == null;
    }

    public Integer getSqlMaxLength() {
        Integer maxLength;
        Integer n = maxLength = this._stringDataArtifact == null ? null : this._stringDataArtifact.getMaxLength();
        if (maxLength == null) {
            return null;
        }
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        if (sqlProgrammer == null) {
            return maxLength;
        }
        int maxVarcharLength = sqlProgrammer.getMaxVarcharLength();
        return maxLength > maxVarcharLength ? null : maxLength;
    }

    public String getSqlParameterType() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlParameterType(this._dataArtifact);
    }

    public String getSqlNull() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlNull(this._dataArtifact);
    }

    public String getSqlInitialValue() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlInitialValue(this._dataArtifact);
    }

    public String getSqlInitialValue(QueryTable queryTable) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlInitialValue(this._dataArtifact, queryTable);
    }

    public String getSqlDefaultValue() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlDefaultValue(this._dataArtifact);
    }

    public String getSqlDefaultValue(QueryTable queryTable) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlDefaultValue(this._dataArtifact, queryTable);
    }

    public String getSqlCurrentValue() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlCurrentValue(this._dataArtifact);
    }

    public String getSqlCurrentValue(QueryTable queryTable) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlCurrentValue(this._dataArtifact, queryTable);
    }
}

