/*
 * Decompiled with CFR 0.152.
 */
package adalid.jee2;

import adalid.jee2.ProjectDependencyClassifier;
import adalid.jee2.ProjectDependencyScope;
import adalid.jee2.ProjectDependencyType;
import org.apache.commons.lang.StringUtils;

public class ProjectDependency {
    private final String _groupId;
    private final String _artifactId;
    private final String _version;
    private String _classifier;
    private String _scope;
    private String _systemPath;
    private String _type;
    private boolean _optional;
    private final boolean _valid;

    public static final ProjectDependency of(String groupId, String artifactId, String version) {
        return new ProjectDependency(groupId, artifactId, version);
    }

    private ProjectDependency(String groupId, String artifactId, String version) {
        this._groupId = StringUtils.trimToNull((String)groupId);
        this._artifactId = StringUtils.trimToNull((String)artifactId);
        this._version = StringUtils.trimToNull((String)version);
        this._valid = this._groupId != null && this._artifactId != null && this._version != null;
    }

    public String getGroupId() {
        return this._groupId;
    }

    public String getArtifactId() {
        return this._artifactId;
    }

    public String getVersion() {
        return this._version;
    }

    public String getClassifier() {
        return this._classifier;
    }

    public ProjectDependency setClassifier(String classifier) {
        this._classifier = StringUtils.trimToNull((String)classifier);
        return this;
    }

    public ProjectDependency setClassifier(ProjectDependencyClassifier classifier) {
        this._classifier = classifier == null ? null : classifier.getMavenClassifier();
        return this;
    }

    public String getScope() {
        return this._scope;
    }

    public ProjectDependency setScope(ProjectDependencyScope scope) {
        this._scope = scope == null ? null : scope.getMavenScope();
        return this;
    }

    public String getSystemPath() {
        return this._systemPath;
    }

    public ProjectDependency setSystemPath(String systemPath) {
        this._systemPath = StringUtils.trimToNull((String)systemPath);
        return this;
    }

    public String getType() {
        return this._type;
    }

    public ProjectDependency setType(String type) {
        this._type = StringUtils.trimToNull((String)type);
        return this;
    }

    public ProjectDependency setType(ProjectDependencyType type) {
        this._type = type == null ? null : type.getMavenType();
        return this;
    }

    public boolean isOptional() {
        return this._optional;
    }

    public ProjectDependency setOptional(boolean optional) {
        this._optional = optional;
        return this;
    }

    public boolean isValid() {
        return this._valid;
    }
}

