/*
 * Decompiled with CFR 0.152.
 */
package adalid.jee2.meta.proyecto.base;

import adalid.commons.ProjectObjectModelReader;
import adalid.commons.enums.LoggingLevel;
import adalid.commons.interfaces.SubjectProject;
import adalid.commons.properties.Dictionary;
import adalid.commons.util.StrUtils;
import adalid.core.EntityCollection;
import adalid.core.Operation;
import adalid.core.Project;
import adalid.core.annotations.ProjectModule;
import adalid.core.enums.DatabaseLockingMechanism;
import adalid.core.enums.Kleenean;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Parameter;
import adalid.core.interfaces.Property;
import adalid.jee2.ProjectObjectModel;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import meta.entidad.comun.auditoria.ArchivoAdjunto;
import meta.entidad.comun.configuracion.basica.ClaseRecurso;
import meta.entidad.comun.configuracion.basica.DominioParametro;
import meta.entidad.comun.configuracion.basica.Funcion;
import meta.entidad.comun.configuracion.basica.FuncionParametro;
import meta.entidad.comun.configuracion.basica.Pagina;
import meta.entidad.comun.configuracion.basica.Parametro;
import meta.entidad.comun.control.acceso.Usuario;
import meta.proyecto.comun.EntidadesBasicas;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;

public class ProyectoBase
extends Project
implements SubjectProject {
    private static final String BASE_NAME = ProyectoBase.class.getName();
    private static final ResourceBundle RB = ResourceBundle.getBundle(BASE_NAME);
    private static final String PAGE_MAIN_FORM_ID = "mainForm";
    private static final String PAGE_NORTH_FORM_ID = "northForm";
    private static final String PAGE_DATA_TABLE_ID = "dataTable";
    private static final String PAGE_DATA_TABLE_FILTER_ID = "filter";
    private static final String PAGE_DETAIL_PANEL_GRID_ID = "panelDetalle";
    private static final String PAGE_DIALOG_HEADER_ELEMENT_ID = "dialogHeaderElement";
    private static final String PAGE_MESSAGES_ID = "messages";
    private static final String PAGE_TREE_ID = "tree";
    private static final String PAGE_WIZARD_ID = "panelDetalle";
    private static final String PAGE_DATA_TABLE_COLUMN_SUFFIX = "DataTableColumn";
    private static final String PAGE_DETAIL_PANEL_DIV_SUFFIX = "PanelDetalle";
    private static final String PAGE_FIELD_SUFFIX = "Field";
    protected static final String URL_ZIP_THIRD_PARTY_DIR = "third.party.dir.zip.url";
    protected static final String THIRD_PARTY_DIR_LINUX = "third.party.dir.linux";
    protected static final String THIRD_PARTY_DIR_WINDOWS = "third.party.dir.windows";
    protected static final String THIRD_PARTY_DIR_VERSION = "third.party.dir.version";
    protected static final String VERSION_THIRD_PARTY_DIR = "third.party.dir.version";
    private static final String ADALID_SCHEMA = StringUtils.trimToEmpty((String)ProyectoBase.getString("adalid.schema"));
    private final ProjectObjectModel pom = new ProjectObjectModel();
    @ProjectModule(menu=Kleenean.FALSE, role=Kleenean.FALSE)
    EntidadesBasicas entidadesBasicas;
    private boolean _dictionaryEnabled;
    private Dictionary _entitiesDictionary;
    private Dictionary _entityParametersDictionary;
    private Dictionary _operationsDictionary;
    private Dictionary _operationParametersDictionary;
    private Dictionary _pagesDictionary;
    private Dictionary _parametersDictionary;
    private String _baseFolderName;
    private String _databaseName;
    private String _databaseFormerSchemaName;
    private String _rootFolderName;
    private String _roleCodePrefix;
    private String _messageDigestAlgorithm;
    private boolean _sqlBusinessAuditTrail;
    private DatabaseLockingMechanism _databaseLockingMechanism;

    public String getPageMainFormID() {
        return PAGE_MAIN_FORM_ID;
    }

    public String getPageNorthFormID() {
        return PAGE_NORTH_FORM_ID;
    }

    public String getPageDataTableID() {
        return PAGE_DATA_TABLE_ID;
    }

    public String getPageDataTableFilterID() {
        return PAGE_DATA_TABLE_FILTER_ID;
    }

    public String getPageDetailPanelGridID() {
        return "panelDetalle";
    }

    public String getPageDialogHeaderElementID() {
        return PAGE_DIALOG_HEADER_ELEMENT_ID;
    }

    public String getPageMessagesID() {
        return PAGE_MESSAGES_ID;
    }

    public String getPageTreeID() {
        return PAGE_TREE_ID;
    }

    public String getPageWizardID() {
        return "panelDetalle";
    }

    public String getPageDataTableColumnSuffix() {
        return PAGE_DATA_TABLE_COLUMN_SUFFIX;
    }

    public String getPageDetailPanelDivSuffix() {
        return PAGE_DETAIL_PANEL_DIV_SUFFIX;
    }

    public String getPageFieldSuffix() {
        return PAGE_FIELD_SUFFIX;
    }

    public static String getEsquemaEntidadesComunes() {
        return ADALID_SCHEMA;
    }

    public static Level getDictionaryLevel() {
        return Dictionary.getInfoLevel();
    }

    public static void setDictionaryLevel(Level level) {
        Dictionary.setInfoLevel(level);
    }

    public static LoggingLevel getDictionaryLoggingLevel() {
        return LoggingLevel.getLoggingLevel(ProyectoBase.getDictionaryLevel());
    }

    public static void setDictionaryLoggingLevel(LoggingLevel level) {
        ProyectoBase.setDictionaryLevel(level.getLevel());
    }

    private static String getString(String key) {
        try {
            String string = RB.getString(key);
            return StringUtils.trimToNull((String)string);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ProyectoBase() {
        this.init();
    }

    private void init() {
        this.setUserEntityClass(Usuario.class);
        this.setUploadedFileEntityClass(ArchivoAdjunto.class);
    }

    @Override
    protected boolean afterWriting(boolean ok) {
        boolean afterWriting = super.afterWriting(ok);
        boolean storeDictionary = this.storeDictionary();
        boolean checkDictionary = this.checkDictionary();
        return afterWriting && storeDictionary && checkDictionary;
    }

    @Override
    public ProjectObjectModelReader getProjectObjectModel() {
        return this.pom;
    }

    @Override
    public String getAdalidProjectVersion() {
        return this.pom.getProjectVersionNumber();
    }

    @Override
    protected void logAdalidProjectVersion() {
        this.pom.logProjectVersion();
    }

    public boolean isDictionaryEnabled() {
        return this._dictionaryEnabled;
    }

    public void enableDictionary() {
        this.enableDictionary(this.getAlias());
    }

    public void enableDictionary(String subdir) {
        Dictionary.reset();
        String folder = subdir != null && subdir.matches("^\\w+$") ? subdir : this.getAlias();
        this._dictionaryEnabled = true;
        this._entitiesDictionary = Dictionary.load(ClaseRecurso.class, folder);
        this._entityParametersDictionary = Dictionary.load(DominioParametro.class, folder);
        this._operationsDictionary = Dictionary.load(Funcion.class, folder);
        this._operationParametersDictionary = Dictionary.load(FuncionParametro.class, folder);
        this._pagesDictionary = Dictionary.load(Pagina.class, folder);
        this._parametersDictionary = Dictionary.load(Parametro.class, folder);
    }

    private boolean storeDictionary() {
        if (this._dictionaryEnabled) {
            this._entitiesDictionary.store();
            this._entityParametersDictionary.store();
            this._operationsDictionary.store();
            this._operationParametersDictionary.store();
            this._pagesDictionary.store();
            this._parametersDictionary.store();
        }
        return true;
    }

    private boolean checkDictionary() {
        if (this._dictionaryEnabled) {
            Dictionary.printSummary();
            return Dictionary.getErrorCount() == 0;
        }
        return true;
    }

    public Set<String> getEntityKeys() {
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.getEntitiesMap().keySet());
        return set;
    }

    public Set<String> getOperationKeys() {
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.getDefaultCrudOperationKeys());
        set.addAll(this.getUserDefinedOperationKeys());
        return set;
    }

    public Set<String> getDefaultCrudOperationKeys() {
        TreeSet<String> set = new TreeSet<String>();
        List<Entity> entities = this.getEntitiesList();
        String[] operations = Operation.getCrudOperationKeys();
        for (Entity entity : entities) {
            String simpleName = entity.getDataType().getSimpleName();
            for (String name : operations) {
                set.add(simpleName + "." + name);
            }
        }
        return set;
    }

    public Set<String> getUserDefinedOperationKeys() {
        TreeSet<String> set = new TreeSet<String>();
        List<Entity> entities = this.getEntitiesList();
        for (Entity entity : entities) {
            String simpleName = entity.getDataType().getSimpleName();
            for (Operation operation : entity.getOperationsList()) {
                set.add(simpleName + "." + operation.getName());
            }
        }
        return set;
    }

    public Set<String> getPageKeys() {
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.getDisplaysMap().keySet());
        return set;
    }

    public Set<String> getParameterKeys() {
        TreeSet<String> set = new TreeSet<String>();
        List<Entity> entities = this.getEntitiesList();
        for (Entity entity : entities) {
            String simpleName = entity.getDataType().getSimpleName();
            for (Property property : entity.getPropertiesList()) {
                set.add(simpleName + "." + property.getName());
            }
            for (Operation operation : entity.getOperationsList()) {
                for (Parameter parameter : operation.getParametersList()) {
                    set.add(simpleName + "." + operation.getName() + "." + parameter.getName());
                }
            }
        }
        return set;
    }

    public String getEntityNumber(Entity entity) {
        return entity == null ? "?" : this.getEntityNumber(entity.getDataType());
    }

    public String getEntityNumber(Class<?> clazz) {
        return clazz == null || clazz.equals(Entity.class) || !Entity.class.isAssignableFrom(clazz) ? "?" : this.getEntityNumber(clazz.getSimpleName());
    }

    public String getEntityNumber(String key) {
        return StringUtils.isBlank((String)key) ? "?" : this.longNumericCode(key, this._entitiesDictionary);
    }

    public String getEntityParameterNumber(String key) {
        return StringUtils.isBlank((String)key) ? "?" : this.longNumericCode(key, this._entityParametersDictionary);
    }

    public String getOperationNumber(Operation operation) {
        if (operation == null) {
            return "?";
        }
        String name = operation.getName();
        Entity declaringEntity = operation.getDeclaringEntity();
        return this.getOperationNumber(name, declaringEntity);
    }

    public String getOperationNumber(String name, Entity declaringEntity) {
        if (StringUtils.isBlank((String)name) || declaringEntity == null) {
            return "?";
        }
        String simpleName = declaringEntity.getDataType().getSimpleName();
        String key = simpleName + "." + name;
        return this.getOperationNumber(key);
    }

    public String getOperationNumber(String key) {
        return StringUtils.isBlank((String)key) ? "?" : this.longNumericCode(key, this._operationsDictionary);
    }

    public String getOperationParameterNumber(String key) {
        return StringUtils.isBlank((String)key) ? "?" : this.longNumericCode(key, this._operationParametersDictionary);
    }

    public String getPageNumber(String key) {
        return StringUtils.isBlank((String)key) ? "?" : this.longNumericCode(key, this._pagesDictionary);
    }

    public String getParameterNumber(Artifact artifact) {
        if (artifact == null) {
            return "?";
        }
        Artifact declaringArtifact = artifact.getDeclaringArtifact();
        if (declaringArtifact instanceof Entity) {
            if (artifact instanceof Property || artifact instanceof EntityCollection) {
                String name = artifact.getName();
                Entity declaringEntity = (Entity)declaringArtifact;
                return this.getParameterNumber(name, declaringEntity);
            }
        } else if (declaringArtifact instanceof Operation && artifact instanceof Parameter) {
            String name = artifact.getName();
            Operation declaringOperation = (Operation)declaringArtifact;
            return this.getParameterNumber(name, declaringOperation);
        }
        return "?";
    }

    public String getParameterNumber(String name, Entity declaringEntity) {
        if (StringUtils.isBlank((String)name) || declaringEntity == null) {
            return "?";
        }
        String simpleName = declaringEntity.getDataType().getSimpleName();
        String key = simpleName + "." + name;
        return this.getParameterNumber(key);
    }

    public String getParameterNumber(String name, Operation declaringOperation) {
        if (StringUtils.isBlank((String)name) || declaringOperation == null) {
            return "?";
        }
        Entity declaringEntity = declaringOperation.getDeclaringEntity();
        if (declaringEntity == null) {
            return "?";
        }
        String simpleName = declaringEntity.getDataType().getSimpleName();
        String key = simpleName + "." + declaringOperation.getName() + "." + name;
        return this.getParameterNumber(key);
    }

    public String getParameterNumber(String key) {
        return StringUtils.isBlank((String)key) ? "?" : this.longNumericCode(key, this._parametersDictionary);
    }

    private String longNumericCode(String key, Dictionary dictionary) {
        String humplessKey = StrUtils.getHumplessCase(key, '_');
        String numericCode = StrUtils.getLongNumericKeyCode(humplessKey);
        if (dictionary != null) {
            String value = dictionary.getProperty(key);
            if (Dictionary.isValidNumericCode(value)) {
                numericCode = value;
                dictionary.putProperty(key, numericCode);
            } else {
                dictionary.setProperty(key, numericCode);
            }
        }
        return numericCode;
    }

    @Override
    public String getBaseFolderName() {
        return StringUtils.defaultIfBlank((String)this._baseFolderName, (String)this.getDefaultBaseFolderName());
    }

    public void setBaseFolderName(String baseFolderName) {
        this._baseFolderName = StrUtils.getFileName(baseFolderName);
    }

    public String getDatabaseName() {
        return StringUtils.defaultIfBlank((String)this._databaseName, (String)this.getDefaultDatabaseName());
    }

    public void setDatabaseName(String databaseName) {
        this._databaseName = StrUtils.getLowerCaseIdentifier(databaseName, '-');
    }

    public String getDatabaseFormerSchemaName() {
        return StringUtils.defaultIfBlank((String)this._databaseFormerSchemaName, (String)this.getDefaultDatabaseFormerSchemaName());
    }

    public void setDatabaseFormerSchemaName(String databaseFormerSchemaName) {
        this._databaseFormerSchemaName = StrUtils.getLowerCaseIdentifier(databaseFormerSchemaName, '_');
    }

    public String getRootFolderName() {
        return StringUtils.defaultIfBlank((String)this._rootFolderName, (String)this.getDefaultRootFolderName());
    }

    public void setRootFolderName(String rootFolderName) {
        this._rootFolderName = StrUtils.getFileName(rootFolderName);
    }

    public String getRoleCodePrefix() {
        return StringUtils.trimToEmpty((String)this._roleCodePrefix);
    }

    public void setRoleCodePrefix(String roleCodePrefix) {
        this._roleCodePrefix = StrUtils.diacriticlessAscii(roleCodePrefix);
    }

    public String getMessageDigestAlgorithm() {
        return StringUtils.defaultIfBlank((String)this._messageDigestAlgorithm, (String)this.getDefaultMessageDigestAlgorithm());
    }

    public void setMessageDigestAlgorithm(String messageDigestAlgorithm) {
        this._messageDigestAlgorithm = StrUtils.getIdentifier(messageDigestAlgorithm, '-');
    }

    public boolean isSqlBusinessAuditTrail() {
        return this._sqlBusinessAuditTrail;
    }

    public void setSqlBusinessAuditTrail(boolean enabled) {
        this._sqlBusinessAuditTrail = enabled;
    }

    public DatabaseLockingMechanism getDatabaseLockingMechanism() {
        return this._databaseLockingMechanism == null ? this.getDefaultDatabaseLockingMechanism() : this._databaseLockingMechanism;
    }

    public void setDatabaseLockingMechanism(DatabaseLockingMechanism databaseLockingMechanism) {
        this._databaseLockingMechanism = databaseLockingMechanism;
    }

    protected String getDefaultBaseFolderName() {
        return this.getAlias();
    }

    protected String getDefaultDatabaseName() {
        return this.getAlias();
    }

    protected String getDefaultDatabaseFormerSchemaName() {
        return "former";
    }

    protected String getDefaultRootFolderName() {
        return this.getAlias();
    }

    protected String getDefaultMessageDigestAlgorithm() {
        return "MD5";
    }

    protected DatabaseLockingMechanism getDefaultDatabaseLockingMechanism() {
        return DatabaseLockingMechanism.ENTITY_VERSIONING;
    }

    static {
        ProyectoBase.setLocale(SPANISH);
    }
}

