/*
 * Decompiled with CFR 0.152.
 */
package adalid.jee2.meta.proyecto.base;

import adalid.commons.util.BitUtils;
import adalid.commons.util.StrUtils;
import adalid.jee2.meta.proyecto.base.ProyectoMaven;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class ProyectoMavenPrime
extends ProyectoMaven {
    private static final Logger logger = Logger.getLogger(ProyectoMavenPrime.class);
    protected static final String PRIMEFACES_THEME = "primefaces.theme";
    protected static final String PRIMEFACES_THEME_GROUP_ID = "primefaces.theme.groupId";
    protected static final String PRIMEFACES_THEME_ARTIFACT_ID = "primefaces.theme.artifactId";
    protected static final String PRIMEFACES_THEME_VERSION = "primefaces.theme.version";
    protected static final String PRIMEFACES_THEME_SWITCHING_ENABLED = "primefaces.theme.switching.enabled";
    protected static final String PRIMEFACES_VERSION = "primefaces.version";
    protected static final String VERSION_PRIMEFACES = "primefaces.version";
    protected static final String DEFAULT_THEME = "hot-sneaks";
    protected static final String DEFAULT_THEME_VERSION = "[1.0.10,)";
    protected static final String DEFAULT_THEME_GROUP_ID = "org.primefaces.themes";
    protected static final String DEFAULT_ALL_THEMES_ARTIFACT_ID = "all-themes";
    private String _theme;
    private String _themeGroupId;
    private String _themeArtifactId;
    private String _themeVersion;
    private Boolean _themeSwitchingEnabled;
    private int _themeDialogWidthSubtrahend = 64;
    private int _themeDialogHeightSubtrahend = 80;
    private DialogPosition _themeDialogPosition = DialogPosition.CENTER;

    @Override
    protected void loadPrivateProperties(Level level, ExtendedProperties properties) {
        super.loadPrivateProperties(level, properties);
        if (this._themeSwitchingEnabled == null) {
            this.setThemeSwitchingEnabled(BitUtils.valueOf(properties.getString(PRIMEFACES_THEME_SWITCHING_ENABLED)));
            logger.log((Priority)level, (Object)("primefaces.theme.switching.enabled=" + this._themeSwitchingEnabled));
        }
        if (this._theme == null) {
            this.setTheme(properties.getString(PRIMEFACES_THEME));
            logger.log((Priority)level, (Object)("primefaces.theme=" + this.getTheme()));
        }
        if (this._themeGroupId == null) {
            this.setThemeGroupId(properties.getString(PRIMEFACES_THEME_GROUP_ID));
            logger.log((Priority)level, (Object)("primefaces.theme.groupId=" + this.getThemeGroupId()));
        }
        if (this._themeArtifactId == null) {
            this.setThemeArtifactId(properties.getString(PRIMEFACES_THEME_ARTIFACT_ID));
            logger.log((Priority)level, (Object)("primefaces.theme.artifactId=" + this.getThemeArtifactId()));
        }
        if (this._themeVersion == null) {
            this.setThemeVersion(properties.getString(PRIMEFACES_THEME_VERSION));
            logger.log((Priority)level, (Object)("primefaces.theme.version=" + this.getThemeVersion()));
        }
    }

    public String getTheme() {
        return StringUtils.defaultIfBlank((String)this._theme, (String)this.getDefaultTheme());
    }

    public void setTheme(String theme) {
        this._theme = StrUtils.getMavenIdentifier(theme);
    }

    protected String getDefaultTheme() {
        return DEFAULT_THEME;
    }

    public int getThemeDialogWidthSubtrahend() {
        return this._themeDialogWidthSubtrahend;
    }

    public void setThemeDialogWidthSubtrahend(int subtrahend) {
        this._themeDialogWidthSubtrahend = subtrahend < 0 ? 0 : (subtrahend > 320 ? 320 : subtrahend);
    }

    public int getThemeDialogHeightSubtrahend() {
        return this._themeDialogHeightSubtrahend;
    }

    public void setThemeDialogHeightSubtrahend(int subtrahend) {
        this._themeDialogHeightSubtrahend = subtrahend < 0 ? 0 : (subtrahend > 240 ? 240 : subtrahend);
    }

    public DialogPosition getThemeDialogPosition() {
        return this._themeDialogPosition;
    }

    public void setThemeDialogPosition(DialogPosition position) {
        this._themeDialogPosition = position == null ? DialogPosition.CENTER : position;
    }

    public String getThemeGroupId() {
        return StringUtils.defaultIfBlank((String)this._themeGroupId, (String)this.getDefaultThemeGroupId());
    }

    public void setThemeGroupId(String groupId) {
        this._themeGroupId = StrUtils.getMavenIdentifier(groupId);
    }

    protected String getDefaultThemeGroupId() {
        return DEFAULT_THEME_GROUP_ID;
    }

    public String getThemeArtifactId() {
        return StringUtils.defaultIfBlank((String)this._themeArtifactId, (String)this.getDefaultThemeArtifactId());
    }

    public void setThemeArtifactId(String artifactId) {
        this._themeArtifactId = StrUtils.getMavenIdentifier(artifactId);
    }

    protected String getDefaultThemeArtifactId() {
        return this.isThemeSwitchingEnabled() ? DEFAULT_ALL_THEMES_ARTIFACT_ID : this.getTheme();
    }

    public String getThemeVersion() {
        return StringUtils.defaultIfBlank((String)this._themeVersion, (String)this.getDefaultThemeVersion());
    }

    public void setThemeVersion(String version) {
        this._themeVersion = StrUtils.getMavenVersion(version);
    }

    protected String getDefaultThemeVersion() {
        return DEFAULT_THEME_VERSION;
    }

    public boolean isThemeSwitchingEnabled() {
        return BitUtils.valueOf(this._themeSwitchingEnabled);
    }

    public void setThemeSwitchingEnabled(boolean enabled) {
        this._themeSwitchingEnabled = enabled;
    }

    protected static enum DialogPosition {
        CENTER,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        LEFT_TOP,
        LEFT_BOTTOM,
        RIGHT_TOP,
        RIGHT_BOTTOM;

    }
}

