/*
 * Decompiled with CFR 0.152.
 */
package adalid.util;

import adalid.commons.properties.BootstrappingFile;
import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.FilUtils;
import adalid.util.ProjectObjectModel;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Utility {
    private static final Logger logger = Logger.getLogger(Utility.class);
    private static final String ARGS_FAILED = "method getArguments failed";
    private static final String ARGS_SUFFIX = ".args";
    private static final String USER_DIR = System.getProperty("user.dir");
    private static ProjectObjectModel pom;

    private static ProjectObjectModel pom() {
        if (pom == null) {
            pom = new ProjectObjectModel();
        }
        return pom;
    }

    protected static String getAdalidProjectVersion() {
        return Utility.pom().getProjectVersionNumber();
    }

    protected static void logAdalidProjectVersion() {
        Utility.pom().logProjectVersion();
    }

    public static String chooseDirectory(String path) {
        String currentDirectoryPath = FilUtils.isDirectory(path) ? path : USER_DIR;
        JFileChooser chooser = new JFileChooser(currentDirectoryPath);
        chooser.setFileSelectionMode(1);
        int option = chooser.showOpenDialog(null);
        return option == 0 ? chooser.getSelectedFile().getPath() : null;
    }

    public static String chooseFile(String path) {
        return Utility.chooseFile(path, null);
    }

    public static String chooseFile(String path, FileFilter filter) {
        return Utility.chooseFile(path, filter, true);
    }

    public static String chooseFile(String path, FileFilter filter, boolean acceptAllFileFilterUsed) {
        int option;
        String currentDirectoryPath = FilUtils.isDirectory(path) ? path : USER_DIR;
        JFileChooser chooser = new JFileChooser(currentDirectoryPath);
        chooser.setFileSelectionMode(0);
        if (filter != null) {
            chooser.addChoosableFileFilter(filter);
            chooser.setFileFilter(filter);
            chooser.setAcceptAllFileFilterUsed(acceptAllFileFilterUsed);
        }
        return (option = chooser.showOpenDialog(null)) == 0 ? chooser.getSelectedFile().getPath() : null;
    }

    public static String[] getArguments(Class<?> clazz) {
        return Utility.getArguments(clazz == null ? null : clazz.getName());
    }

    public static String[] getArguments(String clazz) {
        String[] arguments = null;
        if (clazz == null) {
            logger.error((Object)"method getArguments failed; null value for clazz parameter");
        } else {
            ExtendedProperties properties = PropertiesHandler.getPrivateProperties();
            arguments = Utility.getArguments(clazz, properties, Level.TRACE);
            if (arguments == null) {
                properties = PropertiesHandler.getBootstrapping();
                arguments = Utility.getArguments(clazz, properties, Level.INFO);
            }
        }
        return arguments == null ? new String[]{} : arguments;
    }

    private static String[] getArguments(String clazz, ExtendedProperties properties, Level level) {
        if (properties == null) {
            logger.log((Priority)level, (Object)"method getArguments failed; properties is null");
        } else if (properties.isEmpty()) {
            logger.log((Priority)level, (Object)"method getArguments failed; properties is empty");
        } else {
            String key = clazz + ARGS_SUFFIX;
            try {
                String[] strings = properties.getStringArray(key);
                if (strings != null && strings.length != 0) {
                    return strings;
                }
                logger.log((Priority)level, (Object)("method getArguments failed; property " + key + " not found"));
            }
            catch (Exception e) {
                logger.log((Priority)level, (Object)("method getArguments failed; " + key + " not properly defined (" + e + ")"));
            }
        }
        return null;
    }

    public static void setBootstrappingFileName(String name) {
        BootstrappingFile.setName(name);
    }
}

