/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.io;

import java.io.File;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;

public class FileNameRegexFilter
extends FileFilter {
    private final String _description;
    private final Pattern _pattern;
    private final boolean _dirs;

    public FileNameRegexFilter(String description, String regex) {
        this(description, regex, true);
    }

    public FileNameRegexFilter(String description, String regex, boolean dirs) {
        if (regex == null) {
            throw new IllegalArgumentException("regex is null");
        }
        this._description = description;
        this._pattern = Pattern.compile(regex);
        this._dirs = dirs;
    }

    @Override
    public boolean accept(File f) {
        return f != null && (this._dirs && f.isDirectory() || f.isFile() && this._pattern.matcher(f.getName()).matches());
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public Pattern getPattern() {
        return this._pattern;
    }

    public String toString() {
        return super.toString() + "[description=" + this.getDescription() + ", regex=" + this._pattern + "]";
    }
}

