/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.io;

import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.FilUtils;
import adalid.util.Utility;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

class SysCmdCommand {
    private static final Logger logger = Logger.getLogger(Utility.class);
    private static final String HOME = System.getProperty("user.home");
    private static final String WIN_CLI = "cmd.exe";
    private static final String WIN_CMD = "cmd.exe /c start ";
    String command;
    List<String> env;
    File dir;

    SysCmdCommand(String command, List<String> env, File dir) {
        this.command = command;
        this.env = env != null ? env : new ArrayList();
        this.dir = dir;
    }

    String[] command() {
        return StringUtils.split((String)this.command, (char)' ');
    }

    String[] env() {
        return this.env == null || this.env.isEmpty() ? null : this.env.toArray(new String[this.env.size()]);
    }

    SysCmdCommand forWindows() {
        logger.debug((Object)("cmd=" + this.command));
        logger.debug((Object)("dir=" + this.dir));
        if (StringUtils.endsWithIgnoreCase((String)this.command, (String)".bat") && !StringUtils.startsWithIgnoreCase((String)this.command, (String)WIN_CLI)) {
            String comando = StringUtils.startsWithIgnoreCase((String)this.command, (String)this.dir.getAbsolutePath()) ? this.command : this.dir.getAbsolutePath() + File.separator + this.command;
            String hyphens = StringUtils.repeat((String)"-", (int)comando.length());
            ArrayList<Object> list = new ArrayList<Object>();
            list.add("@cd /d " + this.dir.getAbsolutePath());
            list.add("@echo " + hyphens);
            list.add("@echo " + comando);
            list.add("@echo " + hyphens);
            list.add("@call " + this.command);
            list.add("@exit");
            logger.trace((Object)("bat=" + list));
            File cf = new File(this.command);
            File pf = cf.isAbsolute() ? cf.getParentFile() : this.dir;
            String dp = this.delimitedPath(pf);
            String nx = cf.getName();
            File file = new File(HOME, "resources/scripts/windows/runtime/" + dp + nx);
            Path path = Paths.get(file.getPath(), new String[0]);
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, list, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                this.command = WIN_CMD + file.getName();
                this.dir = file.getParentFile();
            }
            catch (IOException ex) {
                logger.fatal((Object)ex);
            }
        }
        logger.debug((Object)("cmd=" + this.command));
        logger.debug((Object)("dir=" + this.dir));
        return this;
    }

    String delimitedPath(File dir) {
        char separator;
        String dp;
        String root = PropertiesHandler.getRootFolder().getAbsolutePath();
        String path = dir.getAbsolutePath();
        if (path.startsWith(root)) {
            path = path.substring(root.length());
        }
        return (dp = FilUtils.delimitedPath(path, separator = '$')) == null ? "" : dp + separator;
    }
}

