/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.io;

import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.ThrowableUtils;
import adalid.util.Utility;
import adalid.util.io.SysCmdCommand;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SysCmdRunner
extends Utility {
    private static final Logger logger = Logger.getLogger(Utility.class);
    public static final String MORE_INTERACTIVE = SysCmdRunner.class.getSimpleName() + "=";
    public static final String LESS_INTERACTIVE = MORE_INTERACTIVE + SysCmdRunner.class.getCanonicalName();
    private static final boolean RTX = false;

    public static void main(String[] args) {
        SysCmdRunner.executeSystemCommand();
    }

    public static Process executeSystemCommand() {
        return SysCmdRunner.executeSystemCommand(null);
    }

    public static Process executeSystemCommand(String folder) {
        return SysCmdRunner.executeSystemCommand(folder, null);
    }

    public static Process executeSystemCommand(String folder, String command) {
        List<String> env = null;
        return SysCmdRunner.executeSystemCommand(folder, command, env);
    }

    public static Process executeSystemCommand(String folder, String command, String ... vars) {
        List<String> env = vars == null || vars.length == 0 ? null : Arrays.asList(vars);
        return SysCmdRunner.executeSystemCommand(folder, command, env);
    }

    public static Process executeSystemCommand(String folder, String command, List<String> env) {
        File dir = SysCmdRunner.directoryOf(folder);
        return SysCmdRunner.executeSystemCommand(dir, SysCmdRunner.commandOf(dir, command), env);
    }

    public static void executeFile() {
        SysCmdRunner.executeFile(null);
    }

    public static void log(Process process) {
        if (process != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    logger.info((Object)line);
                }
            }
            catch (IOException ex) {
                logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
        }
    }

    public static void send(Process process, String string) {
        if (process != null) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));){
                writer.write(string);
            }
            catch (IOException ex) {
                logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
        }
    }

    public static void executeFile(String folder) {
        File f;
        String command;
        File dir = SysCmdRunner.directoryOf(folder);
        while ((command = SysCmdRunner.commandOf(dir, null)) != null && (f = new File(command)).isFile()) {
            SysCmdRunner.executeSystemCommand(dir, command, null);
            dir = f.getParentFile();
            SysCmdRunner.sleep(3000L);
        }
    }

    private static File directoryOf(String folder) {
        File dir;
        if (StringUtils.isBlank((String)folder)) {
            File rootFolder = PropertiesHandler.getRootFolder();
            logger.info((Object)("root-folder=" + rootFolder));
            folder = rootFolder.getAbsolutePath();
        }
        if (!(dir = new File(folder)).isAbsolute()) {
            File rootFolder = PropertiesHandler.getRootFolder();
            logger.info((Object)("root-folder=" + rootFolder));
            dir = new File(rootFolder, folder);
        }
        logger.info((Object)("working-dir=" + dir));
        return dir;
    }

    private static String commandOf(File dir, String command) {
        if (StringUtils.isBlank((String)command) && StringUtils.isBlank((String)(command = SysCmdRunner.chooseFile(dir.getAbsolutePath(), new FileNameExtensionFilter("*.bat", "bat"))))) {
            return null;
        }
        return command;
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            logger.fatal((Object)ex);
        }
    }

    private static Process executeSystemCommand(File dir, String command, List<String> env) {
        if (dir == null || command == null) {
            return null;
        }
        SysCmdCommand scc = new SysCmdCommand(command, env, dir).forWindows();
        SysCmdRunner.addLessInteractiveEnvironmentVariable(scc.env);
        try {
            return SysCmdRunner.start(scc);
        }
        catch (IOException ex) {
            logger.fatal((Object)ex);
            return null;
        }
    }

    private static Process execute(SysCmdCommand scc) throws IOException {
        logger.info((Object)("cmd=" + scc.command));
        logger.info((Object)("env=" + Arrays.toString(scc.env())));
        logger.info((Object)("dir=" + scc.dir));
        return Runtime.getRuntime().exec(scc.command, scc.env(), scc.dir);
    }

    private static Process start(SysCmdCommand scc) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(scc.command());
        if (scc.env != null && !scc.env.isEmpty()) {
            logger.trace((Object)("env=" + scc.env));
            Map<String, String> environment = processBuilder.environment();
            for (String var : scc.env) {
                String[] tokens = StringUtils.split((String)var, (char)'=');
                if (tokens == null || tokens.length != 2) continue;
                environment.put(tokens[0], tokens[1]);
            }
        }
        processBuilder.directory(scc.dir);
        processBuilder.redirectErrorStream(true);
        logger.info((Object)("cmd=" + processBuilder.command()));
        logger.info((Object)("env=" + processBuilder.environment()));
        logger.info((Object)("dir=" + processBuilder.directory()));
        return processBuilder.start();
    }

    private static boolean addLessInteractiveEnvironmentVariable(List<String> env) {
        if (env == null) {
            return false;
        }
        for (String var : env) {
            if (!StringUtils.startsWithIgnoreCase((String)var, (String)MORE_INTERACTIVE)) continue;
            return false;
        }
        env.add(LESS_INTERACTIVE);
        return true;
    }

    public static List<String> systemEnvironmentList() {
        Map<String, String> env = System.getenv();
        ArrayList<String> list = new ArrayList<String>();
        for (String key : env.keySet()) {
            String var = key + "=" + env.get(key);
            list.add(var);
        }
        return list;
    }
}

