/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.commons.velocity.Writer;
import adalid.util.sql.SqlReader;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SqlWriter
extends SqlReader {
    private static final Logger logger = Logger.getLogger(SqlWriter.class);
    private String _projectAlias;
    private static String PROJECT_ALIAS_PATTERN = "^[a-z][a-z0-9]*$";
    private boolean _createAndDropDefaults;
    private String _targetMetaProjectsPackage;
    private String _targetMetaEntitiesPackage;

    public SqlWriter() {
        this.init();
    }

    public SqlWriter(String[] args) {
        super(args);
        this.init();
    }

    private void init() {
        this.setSelectTemplatesPath("templates/meta/java/sql/select/010");
    }

    public String getProjectAlias() {
        return this._projectAlias == null ? this.defaultProjectAlias() : this._projectAlias;
    }

    public void setProjectAlias(String alias) {
        if (StringUtils.isBlank((String)alias)) {
            logger.warn((Object)("null value for alias parameter; project alias remains " + this.getProjectAlias()));
        } else if (!alias.matches(PROJECT_ALIAS_PATTERN)) {
            logger.warn((Object)(alias + " is an invalid project alias; project alias remains " + this.getProjectAlias()));
        } else if (alias.equalsIgnoreCase("meta") || alias.equalsIgnoreCase("workspace")) {
            logger.warn((Object)(alias + " is a restricted project alias; project alias remains " + this.getProjectAlias()));
        } else {
            this._projectAlias = alias;
        }
    }

    private String defaultProjectAlias() {
        boolean oracle = StringUtils.equalsIgnoreCase((String)this._dbms, (String)"oracle");
        return (oracle ? this._schema : this._database).toLowerCase();
    }

    private boolean checkProjectAlias() {
        String alias = this.getProjectAlias();
        if (StringUtils.isBlank((String)alias)) {
            logger.error((Object)"invalid project alias; generation aborted");
            return false;
        }
        if (!alias.matches(PROJECT_ALIAS_PATTERN)) {
            logger.error((Object)(alias + " is an invalid project alias; generation aborted"));
            return false;
        }
        if (alias.equalsIgnoreCase("meta") || alias.equalsIgnoreCase("workspace")) {
            logger.error((Object)(alias + " is a restricted project alias; generation aborted"));
            return false;
        }
        return true;
    }

    public boolean isCreateAndDropDefaults() {
        return this._createAndDropDefaults;
    }

    public void setCreateAndDropDefaults(boolean b) {
        this._createAndDropDefaults = b;
    }

    @Override
    public String getTargetMetajavaPackage() {
        return this.getDefaultPackage() + "." + this.getProjectAlias();
    }

    public String getTargetMetaProjectsPackage() {
        return StringUtils.isNotBlank((String)this._targetMetaProjectsPackage) ? this._targetMetaProjectsPackage : this.getTargetMetajavaPackage();
    }

    public void setTargetMetaProjectsPackage(String packageName) {
        this._targetMetaProjectsPackage = packageName;
    }

    public String getTargetMetaEntitiesPackage() {
        return StringUtils.isNotBlank((String)this._targetMetaEntitiesPackage) ? this._targetMetaEntitiesPackage : this.getTargetMetajavaPackage() + ".entities";
    }

    public void setTargetMetaEntitiesPackage(String packageName) {
        this._targetMetaEntitiesPackage = packageName;
    }

    public boolean write() {
        logger.info((Object)"write");
        boolean ok = this.checkProjectAlias();
        if (ok && this.read(true)) {
            Writer writer = new Writer(this, "reader");
            writer.write("meta-java-sql");
            return true;
        }
        return false;
    }

    @Override
    protected boolean beforeReadBuild() {
        if (this._createAndDropDefaults) {
            try {
                this.getSqlAid().createDefaults();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    protected boolean beforeReadClose() {
        if (this._createAndDropDefaults) {
            try {
                this.getSqlAid().dropDefaults();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return true;
    }
}

