/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql.io;

import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.StrUtils;
import adalid.util.Utility;
import adalid.util.io.RegexPathFilter;
import adalid.util.io.SmallFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SQLDeveloperDDLFixer
extends Utility {
    private static final Logger logger = Logger.getLogger(SQLDeveloperDDLFixer.class);
    private static final String B = "^";
    private static final String E = "$";
    private static final String X = ".*";
    private static final String S = RegexPathFilter.SEPARATOR;
    private static final String D = "\\.";
    private static final String COMMENT_LINE_REGEX = "^--.*$";
    private static final String ALTER_TABLE_REGEX = "^.*\\bALTER TABLE\\b";
    private static final String TABLE_NAME_REGEX = "\\s*\\\"\\w+\\\"\\.\\\"\\w+\\\"\\s*";
    private static final String COLUMN_NAME_REGEX = "\\s*\\\"\\w+\\\"\\s*";
    private static final String MODIFY_REGEX = "\\bMODIFY\\b";
    private static final String COMMENT_COMMAND_REGEX = "^.*\\bCOMMENT ON\\b.*\\bIS\\b.*$";
    private static final String MODIFY_COMMAND_REGEX = "^.*\\bALTER TABLE\\b\\s*\\\"\\w+\\\"\\.\\\"\\w+\\\"\\s*\\bMODIFY\\b.*$";
    private static final String NOT_NULL_COMMAND_REGEX = "^.*\\bALTER TABLE\\b\\s*\\\"\\w+\\\"\\.\\\"\\w+\\\"\\s*\\bMODIFY\\b\\s*\\(\\s*\\\"\\w+\\\"\\s*\\s*NOT NULL ENABLE\\);$";
    private static final String GRANT_COMMAND_REGEX = "^.*\\bGRANT\\b.*\\bON\\b.*\\bTO\\b.*$";
    private static final String CREATE_UNIQUE_INDEX_REGEX = "^.*\\bCREATE UNIQUE INDEX\\b";
    private static final String CREATE_PK_INDEX_COMMAND_REGEX_1 = "^.*\\bCREATE UNIQUE INDEX\\b.*\\b\\w+PK___\\b.*\\bON\\b.*$";
    private static final String CREATE_PK_INDEX_COMMAND_REGEX_2 = "^.*\\bCREATE UNIQUE INDEX\\b.*\\bPK_\\w+\\b.*\\bON\\b.*$";
    private static final String CREATE_UK_INDEX_COMMAND_REGEX_1 = "^.*\\bCREATE UNIQUE INDEX\\b.*\\b\\w+UK_\\d{3}___\\b.*\\bON\\b.*$";
    private static final String CREATE_UK_INDEX_COMMAND_REGEX_2 = "^.*\\bCREATE UNIQUE INDEX\\b.*\\bUK_\\w+\\b.*\\bON\\b.*$";
    private static final String LAST_COMMAND_LINE_REGEX = "^.*;$";
    private static final String[] CODERS = new String[]{"FUNCTIONS", "PACKAGES", "PACKAGE_BODIES", "PROCEDURES", "TRIGGERS"};
    private static final String[] SECURE = new String[]{"FUNCTIONS", "PACKAGES", "PACKAGE_BODIES", "PROCEDURES", "TRIGGERS", "MATERIALIZED_VIEWS", "SEQUENCES", "TABLES", "VIEWS"};
    private static final String[] OTHERS = new String[]{"CONSTRAINTS", "DROPS", "INDEXES", "MATERIALIZED_VIEWS", "REF_CONSTRAINTS", "SEQUENCES", "TABLES", "VIEWS"};
    private static final String USER_DIR = System.getProperty("user.dir");
    private final File rootFolder = PropertiesHandler.getRootFolder();
    private final Path rootFolderPath;
    private final File resourcesFolder;
    private final Path resourcesFolderPath;
    private final File baseFolder;
    private final Path baseFolderPath;
    private final Map<Path, SmallFile> files;
    private final Map<String, Integer> fileTypes;
    private boolean detailAll;
    private List<String> detailPatterns;
    private int filteredCommands;
    private int readingWarnings;
    private int readingErrors;
    private int filesCopied;
    private int filesSkipped;
    private int writingErrors;
    private Sorting sorting;
    private Filtering filtering;

    public static void main(String[] args) {
        SQLDeveloperDDLFixer.replace(USER_DIR);
    }

    public static boolean replace(String path) {
        return SQLDeveloperDDLFixer.replace(path, false);
    }

    public static boolean replace(String path, boolean detail) {
        logger.info((Object)("replace" + StrUtils.enclose(path)));
        SQLDeveloperDDLFixer fileBrowser = new SQLDeveloperDDLFixer(path, detail);
        return fileBrowser.replace();
    }

    public static boolean replace(String path, List<String> details) {
        logger.info((Object)("replace" + StrUtils.enclose(path)));
        SQLDeveloperDDLFixer fileBrowser = new SQLDeveloperDDLFixer(path, details);
        return fileBrowser.replace();
    }

    private SQLDeveloperDDLFixer(String path) {
        if (this.rootFolder == null) {
            throw new RuntimeException("root folder is missing or invalid");
        }
        this.rootFolderPath = Paths.get(this.rootFolder.getPath(), new String[0]);
        logger.info((Object)("root-folder=" + this.rootFolderPath));
        path = SQLDeveloperDDLFixer.chooseDirectory(path);
        if (path == null) {
            throw new IllegalArgumentException("null folder path");
        }
        File file = new File(path);
        this.resourcesFolder = file.isAbsolute() ? file : new File(this.rootFolder.getAbsolutePath(), path);
        this.resourcesFolderPath = Paths.get(this.resourcesFolder.getPath(), new String[0]);
        logger.info((Object)("resources-folder=" + this.resourcesFolderPath));
        if (this.resourcesFolder.isDirectory()) {
            if (this.resourcesFolder.isHidden()) {
                throw new IllegalArgumentException(this.resourcesFolderPath + " is a hidden directory");
            }
        } else {
            throw new IllegalArgumentException(this.resourcesFolderPath + " is not a directory");
        }
        this.baseFolder = this.resourcesFolder.getParentFile();
        this.baseFolderPath = Paths.get(this.baseFolder.getPath(), new String[0]);
        logger.info((Object)("base-folder=" + this.baseFolderPath));
        this.files = new TreeMap<Path, SmallFile>();
        this.fileTypes = new TreeMap<String, Integer>();
    }

    private SQLDeveloperDDLFixer(String path, boolean detail) {
        this(path);
        this.detailAll = detail;
    }

    private SQLDeveloperDDLFixer(String path, List<String> details) {
        this(path);
        this.detailAll = false;
        this.detailPatterns = details;
    }

    private boolean replace() {
        logger.info((Object)("replace" + StrUtils.enclose(this.resourcesFolderPath.getFileName().toString())));
        this.init();
        this.readFiles();
        this.printSummary();
        return this.readingErrors == 0;
    }

    private void init() {
        this.filteredCommands = 0;
        this.readingWarnings = 0;
        this.readingErrors = 0;
        this.filesCopied = 0;
        this.filesSkipped = 0;
        this.writingErrors = 0;
        this.sorting();
        this.filtering();
    }

    private void sorting() {
        String message = "Sort commands";
        String title = "Choose";
        int type = 3;
        Sorting[] values = Sorting.values();
        Sorting initialValue = values[0];
        logger.info((Object)("Choose " + message + " " + Arrays.toString((Object[])values)));
        Object value = JOptionPane.showInputDialog(null, message, "Choose", 3, null, (Object[])values, (Object)initialValue);
        this.sorting = value == null ? Sorting.NONE : (Sorting)((Object)value);
        logger.info((Object)this.sorting);
    }

    private void filtering() {
        String message = "Filter commands";
        String title = "Choose";
        int type = 3;
        Filtering[] values = Filtering.values();
        Filtering initialValue = values[0];
        logger.info((Object)("Choose " + message + " " + Arrays.toString((Object[])values)));
        Object value = JOptionPane.showInputDialog(null, message, "Choose", 3, null, (Object[])values, (Object)initialValue);
        this.filtering = value == null ? Filtering.NONE : (Filtering)((Object)value);
        logger.info((Object)this.filtering);
    }

    private boolean readFiles() {
        Collection list = FileUtils.listFiles((File)this.resourcesFolder, (IOFileFilter)this.fileFilter(), (IOFileFilter)this.dirFilter());
        for (File file : list) {
            SmallFile sf = new SmallFile(file.getPath());
            sf.read();
            Charset charset = sf.getCharset();
            String name = sf.getName();
            String extension = StringUtils.defaultIfBlank((String)sf.getExtension().toLowerCase(), (String)"?");
            if (charset == null) {
                ++this.readingErrors;
                logger.error((Object)(name + " could not be read using any of the specified character sets "));
                continue;
            }
            if (sf.isEmpty()) {
                ++this.readingWarnings;
                logger.warn((Object)(name + " is empty "));
                continue;
            }
            this.files.put(sf.getPath(), sf);
            this.updateFileTypes("" + charset);
            this.updateFileTypes(charset + " / " + extension);
            this.rewrite(sf);
        }
        return true;
    }

    private boolean rewrite(SmallFile smallSource) {
        List<String> sourceLines = smallSource.read();
        ArrayList<String> targetLines = new ArrayList<String>();
        ArrayList<String> sortedLines = new ArrayList<String>();
        ArrayList modifyLines = new ArrayList();
        ArrayList<String> listOfLines = sortedLines;
        String folder = smallSource.getPath().getParent().getFileName().toString();
        boolean coders = ArrayUtils.contains((Object[])CODERS, (Object)folder);
        boolean secure = ArrayUtils.contains((Object[])SECURE, (Object)folder);
        boolean others = ArrayUtils.contains((Object[])OTHERS, (Object)folder);
        boolean tables = folder.equals("TABLES");
        boolean constraints = folder.equals("CONSTRAINTS");
        boolean indexes = folder.equals("INDEXES");
        boolean triggers = folder.equals("TRIGGERS");
        boolean materialized_views = folder.equals("MATERIALIZED_VIEWS");
        boolean header = true;
        boolean sorted = Sorting.ALPHABETICALLY.equals((Object)this.sorting);
        boolean modify = Sorting.MODIFY_COMMANDS_FIRST.equals((Object)this.sorting);
        boolean filterAllAbove = Filtering.ALL_OF_THE_ABOVE.equals((Object)this.filtering);
        boolean filterAllButNN = Filtering.ALL_BUT_NOT_NULL.equals((Object)this.filtering);
        boolean filterAllButIX = Filtering.ALL_BUT_PK_UK_IX.equals((Object)this.filtering);
        boolean filterComments = filterAllAbove || filterAllButNN || filterAllButIX || Filtering.COMMENT.equals((Object)this.filtering);
        boolean filterGranting = filterAllAbove || filterAllButNN || filterAllButIX || Filtering.GRANT.equals((Object)this.filtering);
        boolean filterNotNulls = filterAllAbove || filterAllAbove || filterAllButIX || Filtering.NOT_NULL_ENABLE.equals((Object)this.filtering);
        boolean filterDeferred = filterAllAbove || filterAllButNN || filterAllButIX || Filtering.SEGMENT_CREATION_DEFERRED.equals((Object)this.filtering);
        boolean filterPKyIndex = filterAllAbove || filterAllButNN || filterAllAbove || Filtering.PK_INDEX.equals((Object)this.filtering);
        boolean filterUKyIndex = filterAllAbove || filterAllButNN || filterAllAbove || Filtering.UK_INDEX.equals((Object)this.filtering);
        sorted &= others & !materialized_views;
        modify &= constraints;
        filterComments &= others;
        filterGranting &= secure;
        filterNotNulls &= constraints;
        filterDeferred &= tables;
        filterPKyIndex &= indexes;
        filterUKyIndex &= indexes;
        Object command = "";
        boolean complete = true;
        if (smallSource.isNotEmpty()) {
            for (String line : sourceLines) {
                String newline;
                boolean headline;
                boolean skipline = StringUtils.isBlank((String)line);
                boolean bl = headline = skipline || line.matches(COMMENT_LINE_REGEX);
                if (header && headline) {
                    targetLines.add(line);
                    continue;
                }
                if (others && headline) continue;
                header = false;
                if (modify && ((String)command).isEmpty() && line.matches(MODIFY_COMMAND_REGEX)) {
                    listOfLines = modifyLines;
                }
                String string = newline = complete ? "" : "\n";
                if (line.equals("/")) {
                    if (!triggers || !((String)command).trim().isEmpty()) {
                        if (((String)command).isEmpty()) {
                            if (!complete) {
                                listOfLines.add((String)command);
                            }
                        } else {
                            this.add((String)command, listOfLines, filterComments, filterGranting, filterNotNulls, filterDeferred, filterPKyIndex, filterUKyIndex);
                        }
                    }
                    listOfLines.add(line);
                    complete = true;
                } else if (line.matches(LAST_COMMAND_LINE_REGEX)) {
                    command = (String)command + newline + this.split(line);
                    this.add((String)command, listOfLines, filterComments, filterGranting, filterNotNulls, filterDeferred, filterPKyIndex, filterUKyIndex);
                    complete = true;
                } else {
                    command = (String)command + newline + this.split(line);
                    complete = false;
                }
                if (!complete) continue;
                listOfLines = sortedLines;
                command = "";
            }
        }
        if (modify) {
            modifyLines.sort(null);
            targetLines.addAll(modifyLines);
        }
        if (modify || sorted) {
            sortedLines.sort(null);
        }
        targetLines.addAll(sortedLines);
        if (this.rewrite(smallSource, targetLines)) {
            ++this.filesCopied;
        }
        return true;
    }

    private boolean rewrite(SmallFile smallSource, List<String> lines) {
        String target = smallSource.getName();
        String shorty = StringUtils.removeStartIgnoreCase((String)target, (String)this.resourcesFolderPath.toString());
        logger.trace((Object)("rewrite " + shorty));
        try {
            Files.write(smallSource.getPath(), lines, smallSource.getCharset(), new OpenOption[0]);
            return true;
        }
        catch (IOException ex) {
            ++this.writingErrors;
            logger.fatal((Object)ex);
            logger.fatal((Object)("\t" + shorty + " could not be rewritten "));
            return false;
        }
    }

    private boolean add(String command, List<String> listOfLines, boolean filterComments, boolean filterGranting, boolean filterNotNulls, boolean filterDeferred, boolean filterPKyIndex, boolean filterUKyIndex) {
        if (command.isEmpty()) {
            return false;
        }
        if (filterComments && this.matches(command, COMMENT_COMMAND_REGEX)) {
            ++this.filteredCommands;
        } else if (filterGranting && this.matches(command, GRANT_COMMAND_REGEX)) {
            ++this.filteredCommands;
        } else if (filterNotNulls && this.matches(command, NOT_NULL_COMMAND_REGEX)) {
            ++this.filteredCommands;
        } else if (filterPKyIndex && this.matches(command, CREATE_PK_INDEX_COMMAND_REGEX_1)) {
            ++this.filteredCommands;
        } else if (filterPKyIndex && this.matches(command, CREATE_PK_INDEX_COMMAND_REGEX_2)) {
            ++this.filteredCommands;
        } else if (filterUKyIndex && this.matches(command, CREATE_UK_INDEX_COMMAND_REGEX_1)) {
            ++this.filteredCommands;
        } else if (filterUKyIndex && this.matches(command, CREATE_UK_INDEX_COMMAND_REGEX_2)) {
            ++this.filteredCommands;
        } else {
            if (filterDeferred) {
                command = command.replace("SEGMENT CREATION DEFERRED", "");
            }
            return listOfLines.add(command);
        }
        return false;
    }

    private boolean matches(String command, String regex) {
        return command.replace('\n', ' ').trim().matches(regex);
    }

    private String split(String line) {
        return line.length() < 2499 ? line : line.replaceAll(",\\s+", ",\n");
    }

    private void updateFileTypes(String type) {
        if (this.fileTypes.containsKey(type)) {
            int count = this.fileTypes.get(type);
            this.fileTypes.put(type, ++count);
        } else {
            this.fileTypes.put(type, 1);
        }
    }

    private void printSummary() {
        logger.info((Object)(this.filteredCommands + " filtered commands "));
        logger.info((Object)(this.readingWarnings + " reading warnings "));
        logger.info((Object)(this.readingErrors + " reading errors "));
        logger.info((Object)(this.filesCopied + " files rewritten "));
        logger.info((Object)(this.filesSkipped + " files skipped "));
        logger.info((Object)(this.writingErrors + " writing errors "));
    }

    private void printDetail(String type) {
        if (this.detailAll || this.matches(type)) {
            String baseFolderPathString = this.baseFolderPath.toString();
            String tab = type.contains("/") ? "\t" : "";
            for (SmallFile sf : this.files.values()) {
                Charset charset = sf.getCharset();
                String extension = StringUtils.defaultIfBlank((String)sf.getExtension(), (String)"?");
                if (charset == null || !type.equals(charset + " / " + extension)) continue;
                logger.info((Object)(tab + "\t" + StringUtils.removeStartIgnoreCase((String)sf.getName(), (String)baseFolderPathString)));
            }
        }
    }

    private boolean matches(String type) {
        if (this.detailPatterns == null || this.detailPatterns.isEmpty()) {
            return false;
        }
        for (String regex : this.detailPatterns) {
            if (!type.matches(regex)) continue;
            return true;
        }
        return false;
    }

    private IOFileFilter fileFilter() {
        IOFileFilter fileFileFilter = FileFilterUtils.fileFileFilter();
        IOFileFilter[] ayes = new IOFileFilter[]{new RegexFileFilter("^.*\\.sql$")};
        IOFileFilter ayesFileFilter = FileFilterUtils.or((IOFileFilter[])ayes);
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{fileFileFilter, ayesFileFilter});
        return filter;
    }

    private IOFileFilter dirFilter() {
        IOFileFilter makeCVSSVNAware = FileFilterUtils.makeCVSAware((IOFileFilter)FileFilterUtils.makeSVNAware(null));
        IOFileFilter[] noes = new IOFileFilter[]{new RegexFileFilter("^.*\\.git$"), new RegexFileFilter("^build$"), new RegexFileFilter("^dist$"), new RegexFileFilter("^target$")};
        IOFileFilter noesFileFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])noes));
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{makeCVSSVNAware, noesFileFilter});
        return filter;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public Path getRootFolderPath() {
        return this.rootFolderPath;
    }

    public File getResourcesFolder() {
        return this.resourcesFolder;
    }

    public Path getResourcesFolderPath() {
        return this.resourcesFolderPath;
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public Path getBaseFolderPath() {
        return this.baseFolderPath;
    }

    public int getReadingWarnings() {
        return this.readingWarnings;
    }

    public int getReadingErrors() {
        return this.readingErrors;
    }

    public Map<Path, SmallFile> getFiles() {
        return this.files;
    }

    public Map<String, Integer> getFileTypes() {
        return this.fileTypes;
    }

    private static enum Filtering {
        NONE,
        COMMENT,
        GRANT,
        NOT_NULL_ENABLE,
        SEGMENT_CREATION_DEFERRED,
        PK_INDEX,
        UK_INDEX,
        ALL_OF_THE_ABOVE,
        ALL_BUT_NOT_NULL,
        ALL_BUT_PK_UK_IX;

    }

    private static enum Sorting {
        NONE,
        ALPHABETICALLY,
        MODIFY_COMMANDS_FIRST;

    }
}

