/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.auditoria;

import adalid.core.AbstractPersistentEntity;
import adalid.core.ProcessOperation;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.Filter;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.ProcessOperationClass;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.QueryMapping;
import adalid.core.annotations.SegmentProperty;
import adalid.core.annotations.StringField;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.SortOption;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.properties.BinaryProperty;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.control.acceso.Usuario;

@EntityClass(independent=Kleenean.TRUE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.MASCULINE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE, onload=SelectOnloadOption.EXECUTE, sortOption=SortOption.DESC)
@EntityInsertOperation(enabled=Kleenean.FALSE)
@EntityUpdateOperation(enabled=Kleenean.FALSE)
@EntityDeleteOperation(enabled=Kleenean.FALSE)
@EntityTableView(enabled=Kleenean.TRUE)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
public class ArchivoAdjunto
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @FileReference(blobField="octetos", loadField="fechaHoraCarga")
    @ColumnField(nullable=Kleenean.FALSE, unique=Kleenean.TRUE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.FALSE)
    @StringField(maxLength=200)
    public StringProperty archivoServidor;
    @NameProperty
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE)
    @StringField(maxLength=200)
    public StringProperty archivoCliente;
    @OwnerProperty
    @SegmentProperty
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    @QueryMapping(mapKeyProperties=Kleenean.FALSE)
    public Usuario propietario;
    @PropertyField(table=Kleenean.TRUE, search=Kleenean.TRUE, report=Kleenean.TRUE)
    @StringField(maxLength=36)
    public StringProperty codigoUsuarioPropietario;
    @PropertyField(table=Kleenean.FALSE, search=Kleenean.TRUE, report=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty nombreUsuarioPropietario;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public TimestampProperty fechaHoraCarga;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, overlay=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty tipoContenido;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public LongProperty longitud;
    @PropertyField(hidden=Kleenean.TRUE)
    public BinaryProperty octetos;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.FALSE, search=Kleenean.TRUE)
    public BooleanProperty restaurable;
    protected RestaurarArchivoServidorWeb restaurarArchivoServidorWeb;
    protected EliminarArchivoServidorWeb eliminarArchivoServidorWeb;
    protected EliminarTotalmente eliminarTotalmente;

    @Deprecated
    ArchivoAdjunto() {
        this(null, null);
    }

    public ArchivoAdjunto(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "attached file");
        this.setLocalizedLabel(SPANISH, "archivo adjunto");
        this.setLocalizedShortLabel(ENGLISH, "attachment");
        this.setLocalizedShortLabel(SPANISH, "adjunto");
        this.setLocalizedCollectionLabel(ENGLISH, "Attached Files");
        this.setLocalizedCollectionLabel(SPANISH, "Archivos Adjuntos");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Attachments");
        this.setLocalizedCollectionShortLabel(SPANISH, "Adjuntos");
        this.setLocalizedDescription(ENGLISH, "audit trail of the execution of file upload operations on the server");
        this.setLocalizedDescription(SPANISH, "rastro de auditor\u00eda de la ejecuci\u00f3n de operaciones de carga de archivos en el servidor");
    }

    public BinaryProperty getBlobProperty() {
        return this.octetos;
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.propietario.setInitialValue(SpecialEntityValue.CURRENT_USER);
        this.propietario.setDefaultValue(SpecialEntityValue.CURRENT_USER);
        this.fechaHoraCarga.setInitialValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.fechaHoraCarga.setDefaultValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.restaurable.setInitialValue(false);
        this.restaurable.setDefaultValue(false);
        this.archivoServidor.setLocalizedDescription(ENGLISH, "file name on the application server");
        this.archivoServidor.setLocalizedDescription(SPANISH, "nombre del archivo en el servidor de aplicaciones");
        this.archivoServidor.setLocalizedLabel(ENGLISH, "attached file's server file name");
        this.archivoServidor.setLocalizedLabel(SPANISH, "archivo servidor del archivo adjunto");
        this.archivoServidor.setLocalizedShortLabel(ENGLISH, "server file");
        this.archivoServidor.setLocalizedShortLabel(SPANISH, "archivo servidor");
        this.archivoServidor.setLocalizedTooltip(ENGLISH, "open the attached file");
        this.archivoServidor.setLocalizedTooltip(SPANISH, "abrir el archivo adjunto");
        this.archivoCliente.setLocalizedDescription(ENGLISH, "name of the original file (file on the computer of the user who made the upload)");
        this.archivoCliente.setLocalizedDescription(SPANISH, "nombre del archivo original (archivo en el computador del usuario que realiz\u00f3 la carga)");
        this.archivoCliente.setLocalizedLabel(ENGLISH, "attached file's client file name");
        this.archivoCliente.setLocalizedLabel(SPANISH, "archivo cliente del archivo adjunto");
        this.archivoCliente.setLocalizedShortLabel(ENGLISH, "client file");
        this.archivoCliente.setLocalizedShortLabel(SPANISH, "archivo cliente");
        this.propietario.setLocalizedDescription(ENGLISH, "user who made the upload");
        this.propietario.setLocalizedDescription(SPANISH, "usuario que realiz\u00f3 la carga");
        this.propietario.setLocalizedLabel(ENGLISH, "attached file's owner");
        this.propietario.setLocalizedLabel(SPANISH, "propietario del archivo adjunto");
        this.propietario.setLocalizedShortLabel(ENGLISH, "owner");
        this.propietario.setLocalizedShortLabel(SPANISH, "propietario");
        this.codigoUsuarioPropietario.setLocalizedDescription(ENGLISH, "code of the user who made the upload");
        this.codigoUsuarioPropietario.setLocalizedDescription(SPANISH, "c\u00f3digo del usuario que realiz\u00f3 la carga");
        this.codigoUsuarioPropietario.setLocalizedLabel(ENGLISH, "owner");
        this.codigoUsuarioPropietario.setLocalizedLabel(SPANISH, "propietario");
        this.nombreUsuarioPropietario.setLocalizedDescription(ENGLISH, "name of the user who made the upload");
        this.nombreUsuarioPropietario.setLocalizedDescription(SPANISH, "nombre del usuario que realiz\u00f3 la carga");
        this.nombreUsuarioPropietario.setLocalizedLabel(ENGLISH, "owner name");
        this.nombreUsuarioPropietario.setLocalizedLabel(SPANISH, "nombre del propietario");
        this.fechaHoraCarga.setLocalizedDescription(ENGLISH, "date and time the upload was made");
        this.fechaHoraCarga.setLocalizedDescription(SPANISH, "fecha y hora en la que se realiz\u00f3 la carga");
        this.fechaHoraCarga.setLocalizedLabel(ENGLISH, "upload timestamp");
        this.fechaHoraCarga.setLocalizedLabel(SPANISH, "fecha hora carga");
        this.tipoContenido.setLocalizedDescription(ENGLISH, "MIME type (Multipurpose Internet Mail Extensions) that corresponds to the content of the file");
        this.tipoContenido.setLocalizedDescription(SPANISH, "tipo MIME (Multipurpose Internet Mail Extensions) que corresponde al contenido del archivo");
        this.tipoContenido.setLocalizedLabel(ENGLISH, "content type");
        this.tipoContenido.setLocalizedLabel(SPANISH, "tipo contenido");
        this.longitud.setLocalizedDescription(ENGLISH, "file size, in bytes");
        this.longitud.setLocalizedDescription(SPANISH, "tama\u00f1o del archivo, en bytes");
        this.longitud.setLocalizedLabel(ENGLISH, "length");
        this.longitud.setLocalizedLabel(SPANISH, "longitud");
        this.octetos.setLocalizedDescription(ENGLISH, "file content, in bytes");
        this.octetos.setLocalizedDescription(SPANISH, "contenido del archivo, en bytes");
        this.octetos.setLocalizedLabel(ENGLISH, "bytes");
        this.octetos.setLocalizedLabel(SPANISH, "octetos");
        this.restaurable.setLocalizedDescription(ENGLISH, "indicator that shows whether or not the file can be restored after being removed from the application server");
        this.restaurable.setLocalizedDescription(SPANISH, "indicador que muestra si el archivo puede, o no, ser restaurado despu\u00e9s de ser eliminado del servidor de aplicaciones");
        this.restaurable.setLocalizedLabel(ENGLISH, "restorable");
        this.restaurable.setLocalizedLabel(SPANISH, "restaurable");
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    @ProcessOperationClass(builtIn=true)
    public class EliminarTotalmente
    extends ProcessOperation {
        @InstanceReference
        @Filter(owner=Kleenean.FALSE, segment=Kleenean.FALSE)
        protected ArchivoAdjunto archivoAdjunto;
        protected Check check101;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "completely delete the file");
            this.setLocalizedLabel(SPANISH, "eliminar totalmente el archivo");
            this.setLocalizedDescription(ENGLISH, "delete the file from both the web server and the database;after completely deleting the file, it can no longer be restored");
            this.setLocalizedDescription(SPANISH, "eliminar el archivo tanto del servidor web como de la base de datos; despu\u00e9s de eliminar totalmente el archivo, \u00e9ste no podr\u00e1 ser restaurado");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.archivoAdjunto.restaurable.setCurrentValue(false);
            this.archivoAdjunto.setLocalizedLabel(ENGLISH, "attached file");
            this.archivoAdjunto.setLocalizedLabel(SPANISH, "archivo adjunto");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.archivoAdjunto.restaurable.isTrue();
            this.check101.setLocalizedDescription(ENGLISH, "the file is restorable");
            this.check101.setLocalizedDescription(SPANISH, "el archivo es restaurable");
            this.check101.setLocalizedErrorMessage(ENGLISH, "the file is not restorable");
            this.check101.setLocalizedErrorMessage(SPANISH, "el archivo no es restaurable");
        }
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    @ProcessOperationClass(builtIn=true)
    public class RestaurarArchivoServidorWeb
    extends ProcessOperation {
        @InstanceReference
        @Filter(owner=Kleenean.FALSE, segment=Kleenean.FALSE)
        protected ArchivoAdjunto archivoAdjunto;
        protected Check check101;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "restore the file on the web server");
            this.setLocalizedLabel(SPANISH, "restaurar el archivo del servidor web");
            this.setLocalizedDescription(ENGLISH, "restore the file on the web server using the file stored in the database");
            this.setLocalizedDescription(SPANISH, "restaurar el archivo del servidor web con el contenido del archivo almacenado en la base de datos");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.archivoAdjunto.setLocalizedLabel(ENGLISH, "attached file");
            this.archivoAdjunto.setLocalizedLabel(SPANISH, "archivo adjunto");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.archivoAdjunto.restaurable.isTrue();
            this.check101.setLocalizedDescription(ENGLISH, "the file is restorable");
            this.check101.setLocalizedDescription(SPANISH, "el archivo es restaurable");
            this.check101.setLocalizedErrorMessage(ENGLISH, "the file is not restorable");
            this.check101.setLocalizedErrorMessage(SPANISH, "el archivo no es restaurable");
        }
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    @ProcessOperationClass(builtIn=true)
    public class EliminarArchivoServidorWeb
    extends ProcessOperation {
        @InstanceReference
        @Filter(owner=Kleenean.FALSE, segment=Kleenean.FALSE)
        protected ArchivoAdjunto archivoAdjunto;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "delete the file from the web server");
            this.setLocalizedLabel(SPANISH, "eliminar el archivo del servidor web");
            this.setLocalizedDescription(ENGLISH, "delete the file only from the web server; if the file is stored in the database, it will remain stored in the database and it could be restored later; but if the file is not stored in the databas, it can no longer be restored");
            this.setLocalizedDescription(SPANISH, "eliminar el archivo solo del servidor web; si el archivo est\u00e1 almacenado en la base de datos, permanecer\u00e1 almacenado en la base de datos y podr\u00e1 ser restaurado posteriormente; pero si el archivo no est\u00e1 almacenado en la base de datos, \u00e9ste no podr\u00e1 ser restaurado");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.archivoAdjunto.setLocalizedLabel(ENGLISH, "attached file");
            this.archivoAdjunto.setLocalizedLabel(SPANISH, "archivo adjunto");
        }
    }
}

