/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.control.acceso;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Instance;
import adalid.core.ProcessOperation;
import adalid.core.annotations.Allocation;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.ConstructionOperationClass;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InactiveIndicator;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.ProcessOperationClass;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.Segment;
import adalid.core.interfaces.State;
import adalid.core.parameters.BooleanParameter;
import adalid.core.parameters.StringParameter;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.control.acceso.ConjuntoSegmento;
import meta.entidad.comun.control.acceso.TipoRol;

@EntityClass(independent=Kleenean.TRUE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.MASCULINE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE, onload=SelectOnloadOption.EXECUTE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.TRUE, inserts=Kleenean.TRUE, updates=Kleenean.TRUE)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.TRUE)
public class Rol
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @BusinessKey
    @StringField(maxLength=100)
    public StringProperty codigoRol;
    @NameProperty
    public StringProperty nombreRol;
    @DescriptionProperty
    public StringProperty descripcionRol;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public BooleanProperty esSuperRol;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public BooleanProperty esRolEspecial;
    @InactiveIndicator
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(hidden=Kleenean.TRUE)
    public BooleanProperty esRolInactivo;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    @Allocation(maxDepth=1, maxRound=0)
    public TipoRol tipoRol;
    public Instance SUPER_GESTOR;
    public Instance SUPER_LECTOR;
    public Instance OPERADOR;
    protected Segment modificables;
    protected Segment rolesBasicos;
    protected Segment rolesAgregados;
    protected Segment rolesEspeciales;
    protected Segment rolesOrdinarios;
    protected Segment rolesActivos;
    protected Segment rolesInactivos;
    protected State desactivable;
    protected State reactivable;
    protected Copiar copiar;
    protected Desactivar desactivar;
    protected Reactivar reactivar;
    protected ModificarConjunto modificarConjunto;
    protected PropagarFavoritos propagarFavoritos;
    protected PropagarFiltros propagarFiltros;
    protected PropagarVistas propagarVistas;

    @Deprecated
    Rol() {
        this(null, null);
    }

    public Rol(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "role");
        this.setLocalizedLabel(SPANISH, "rol");
        this.setLocalizedCollectionLabel(ENGLISH, "Roles");
        this.setLocalizedCollectionLabel(SPANISH, "Roles");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.esSuperRol.setInitialValue(false);
        this.esSuperRol.setDefaultValue(false);
        this.esRolEspecial.setInitialValue(false);
        this.esRolEspecial.setDefaultValue(false);
        this.esRolInactivo.setInitialValue(false);
        this.esRolInactivo.setDefaultValue(false);
        this.codigoRol.setLocalizedLabel(ENGLISH, "role code");
        this.codigoRol.setLocalizedLabel(SPANISH, "c\u00f3digo del rol");
        this.codigoRol.setLocalizedShortLabel(ENGLISH, "code");
        this.codigoRol.setLocalizedShortLabel(SPANISH, "c\u00f3digo");
        this.nombreRol.setLocalizedLabel(ENGLISH, "role name");
        this.nombreRol.setLocalizedLabel(SPANISH, "nombre del rol");
        this.nombreRol.setLocalizedShortLabel(ENGLISH, "name");
        this.nombreRol.setLocalizedShortLabel(SPANISH, "nombre");
        this.descripcionRol.setLocalizedLabel(ENGLISH, "role description");
        this.descripcionRol.setLocalizedLabel(SPANISH, "descripci\u00f3n del rol");
        this.descripcionRol.setLocalizedShortLabel(ENGLISH, "description");
        this.descripcionRol.setLocalizedShortLabel(SPANISH, "descripci\u00f3n");
        this.esSuperRol.setLocalizedLabel(ENGLISH, "super role");
        this.esSuperRol.setLocalizedLabel(SPANISH, "s\u00faper rol");
        this.esSuperRol.setLocalizedShortLabel(ENGLISH, "super");
        this.esSuperRol.setLocalizedShortLabel(SPANISH, "s\u00faper");
        this.esRolEspecial.setLocalizedLabel(ENGLISH, "special role");
        this.esRolEspecial.setLocalizedLabel(SPANISH, "rol especial");
        this.esRolEspecial.setLocalizedShortLabel(ENGLISH, "special");
        this.esRolEspecial.setLocalizedShortLabel(SPANISH, "especial");
        this.esRolInactivo.setLocalizedLabel(ENGLISH, "inactive role");
        this.esRolInactivo.setLocalizedLabel(SPANISH, "rol inactivo");
        this.esRolInactivo.setLocalizedShortLabel(ENGLISH, "inactive");
        this.esRolInactivo.setLocalizedShortLabel(SPANISH, "inactivo");
        this.esRolInactivo.setLocalizedDescription(ENGLISH, "inactive role");
        this.esRolInactivo.setLocalizedDescription(SPANISH, "rol inactivo");
        this.tipoRol.setLocalizedLabel(ENGLISH, "role type");
        this.tipoRol.setLocalizedLabel(SPANISH, "tipo de rol");
        this.tipoRol.setLocalizedShortLabel(ENGLISH, "type");
        this.tipoRol.setLocalizedShortLabel(SPANISH, "tipo");
    }

    public Instance getAdministratorRoleInstance() {
        return this.SUPER_GESTOR;
    }

    public Instance getAuditorRoleInstance() {
        return this.SUPER_LECTOR;
    }

    public Instance getBasicRoleInstance() {
        return this.OPERADOR;
    }

    @Override
    protected void settleInstances() {
        super.settleInstances();
        this.SUPER_GESTOR.newInstanceField((Property)this.id, 101);
        this.SUPER_GESTOR.newInstanceField(this.codigoRol, "SuperGestor");
        this.SUPER_GESTOR.newInstanceField(this.nombreRol, "S\u00faper Gestor");
        this.SUPER_GESTOR.newInstanceField(this.descripcionRol, "Permite ejecutar todas las funciones del sistema");
        this.SUPER_GESTOR.newInstanceField((Property)this.esSuperRol, true);
        this.SUPER_GESTOR.newInstanceField((Property)this.esRolEspecial, true);
        this.SUPER_GESTOR.newInstanceField(this.tipoRol, this.tipoRol.GESTOR);
        this.SUPER_LECTOR.newInstanceField((Property)this.id, 102);
        this.SUPER_LECTOR.newInstanceField(this.codigoRol, "SuperLector");
        this.SUPER_LECTOR.newInstanceField(this.nombreRol, "S\u00faper Lector");
        this.SUPER_LECTOR.newInstanceField(this.descripcionRol, "Permite ejecutar todas las funciones de lectura del sistema");
        this.SUPER_LECTOR.newInstanceField((Property)this.esSuperRol, true);
        this.SUPER_LECTOR.newInstanceField((Property)this.esRolEspecial, true);
        this.SUPER_LECTOR.newInstanceField(this.tipoRol, this.tipoRol.LECTOR);
        this.OPERADOR.newInstanceField((Property)this.id, 103);
        this.OPERADOR.newInstanceField(this.codigoRol, "Operador");
        this.OPERADOR.newInstanceField(this.nombreRol, "Operador");
        this.OPERADOR.newInstanceField(this.descripcionRol, "Permite ejecutar todas las funciones p\u00fablicas del sistema");
        this.OPERADOR.newInstanceField((Property)this.esSuperRol, false);
        this.OPERADOR.newInstanceField((Property)this.esRolEspecial, true);
        this.OPERADOR.newInstanceField(this.tipoRol, this.tipoRol.OPERADOR);
        this.SUPER_GESTOR.newInstanceField(this.codigoRol, "SuperManager", ENGLISH);
        this.SUPER_GESTOR.newInstanceField(this.codigoRol, "SuperGestor", SPANISH);
        this.SUPER_GESTOR.newInstanceField(this.nombreRol, "Super Manager", ENGLISH);
        this.SUPER_GESTOR.newInstanceField(this.nombreRol, "S\u00faper Gestor", SPANISH);
        this.SUPER_GESTOR.newInstanceField(this.descripcionRol, "Allows to execute all application's functions", ENGLISH);
        this.SUPER_GESTOR.newInstanceField(this.descripcionRol, "Permite ejecutar todas las funciones del sistema", SPANISH);
        this.SUPER_LECTOR.newInstanceField(this.codigoRol, "SuperReader", ENGLISH);
        this.SUPER_LECTOR.newInstanceField(this.codigoRol, "SuperLector", SPANISH);
        this.SUPER_LECTOR.newInstanceField(this.nombreRol, "Super Reader", ENGLISH);
        this.SUPER_LECTOR.newInstanceField(this.nombreRol, "S\u00faper Lector", SPANISH);
        this.SUPER_LECTOR.newInstanceField(this.descripcionRol, "Allows to execute all application's reading functions", ENGLISH);
        this.SUPER_LECTOR.newInstanceField(this.descripcionRol, "Permite ejecutar todas las funciones de lectura del sistema", SPANISH);
        this.OPERADOR.newInstanceField(this.codigoRol, "Operator", ENGLISH);
        this.OPERADOR.newInstanceField(this.codigoRol, "Operador", SPANISH);
        this.OPERADOR.newInstanceField(this.nombreRol, "Operator", ENGLISH);
        this.OPERADOR.newInstanceField(this.nombreRol, "Operador", SPANISH);
        this.OPERADOR.newInstanceField(this.descripcionRol, "Allows to execute all application's public functions", ENGLISH);
        this.OPERADOR.newInstanceField(this.descripcionRol, "Permite ejecutar todas las funciones p\u00fablicas del sistema", SPANISH);
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.modificables = this.id.isGreaterOrEqualTo(10000L);
        this.rolesBasicos = this.id.isLessThan(10000L);
        this.rolesAgregados = this.id.isGreaterOrEqualTo(10000L);
        this.rolesEspeciales = this.esRolEspecial.isTrue();
        this.rolesOrdinarios = this.esRolEspecial.isFalse();
        this.rolesActivos = this.esRolInactivo.isFalse();
        this.rolesInactivos = this.esRolInactivo.isTrue();
        this.reactivable = this.rolesOrdinarios.and(this.rolesInactivos);
        this.desactivable = this.rolesOrdinarios.and(this.rolesActivos);
        this.modificables.setLocalizedDescription(ENGLISH, "the role is not a basic configuration role");
        this.modificables.setLocalizedDescription(SPANISH, "el rol no es un rol de configuraci\u00f3n b\u00e1sica del sistema");
        this.modificables.setLocalizedErrorMessage(ENGLISH, "the role is a basic configuration role; it can't be modified or deleted");
        this.modificables.setLocalizedErrorMessage(SPANISH, "el rol es un rol de configuraci\u00f3n b\u00e1sica del sistema; no se permite modificarlo ni eliminarlo");
        this.rolesBasicos.setLocalizedCollectionLabel(ENGLISH, "Basic configuration roles");
        this.rolesBasicos.setLocalizedCollectionLabel(SPANISH, "Roles de configuraci\u00f3n b\u00e1sica del sistema");
        this.rolesBasicos.setLocalizedCollectionShortLabel(ENGLISH, "Basic roles");
        this.rolesBasicos.setLocalizedCollectionShortLabel(SPANISH, "Roles b\u00e1sicos");
        this.rolesBasicos.setLocalizedDescription(ENGLISH, "the role is a basic configuration role");
        this.rolesBasicos.setLocalizedDescription(SPANISH, "el rol es un rol de configuraci\u00f3n b\u00e1sica del sistema");
        this.rolesBasicos.setLocalizedErrorMessage(ENGLISH, "the role is not a basic configuration role");
        this.rolesBasicos.setLocalizedErrorMessage(SPANISH, "el rol no es un rol de configuraci\u00f3n b\u00e1sica del sistema");
        this.rolesAgregados.setLocalizedCollectionLabel(ENGLISH, "User defined roles");
        this.rolesAgregados.setLocalizedCollectionLabel(SPANISH, "Roles definidos por el usuario");
        this.rolesAgregados.setLocalizedCollectionShortLabel(ENGLISH, "User defined roles");
        this.rolesAgregados.setLocalizedCollectionShortLabel(SPANISH, "Roles definidos por el usuario");
        this.rolesAgregados.setLocalizedDescription(ENGLISH, "the role is a user defined role");
        this.rolesAgregados.setLocalizedDescription(SPANISH, "el rol es un rol definido por el usuario");
        this.rolesAgregados.setLocalizedErrorMessage(ENGLISH, "the role is not a user defined role");
        this.rolesAgregados.setLocalizedErrorMessage(SPANISH, "el rol no es un rol definido por el usuario");
        this.rolesEspeciales.setLocalizedDescription(ENGLISH, "the role is a special role");
        this.rolesEspeciales.setLocalizedDescription(SPANISH, "el rol es un rol especial");
        this.rolesEspeciales.setLocalizedErrorMessage(ENGLISH, "the role is not a special role");
        this.rolesEspeciales.setLocalizedErrorMessage(SPANISH, "el rol no es un rol especial");
        this.rolesOrdinarios.setLocalizedDescription(ENGLISH, "the role is not a special role");
        this.rolesOrdinarios.setLocalizedDescription(SPANISH, "el rol no es un rol especial");
        this.rolesOrdinarios.setLocalizedErrorMessage(ENGLISH, "the role is a special role");
        this.rolesOrdinarios.setLocalizedErrorMessage(SPANISH, "el rol es un rol especial");
        this.rolesActivos.setLocalizedDescription(ENGLISH, "the role is an active role");
        this.rolesActivos.setLocalizedDescription(SPANISH, "el rol es un rol activo");
        this.rolesActivos.setLocalizedErrorMessage(ENGLISH, "the role is an inactive role");
        this.rolesActivos.setLocalizedErrorMessage(SPANISH, "el rol es un rol inactivo");
        this.rolesInactivos.setLocalizedDescription(ENGLISH, "the role is an inactive role");
        this.rolesInactivos.setLocalizedDescription(SPANISH, "el rol es un rol inactivo");
        this.rolesInactivos.setLocalizedErrorMessage(ENGLISH, "the role is an active role");
        this.rolesInactivos.setLocalizedErrorMessage(SPANISH, "el rol es un rol activo");
        this.desactivable.setLocalizedDescription(ENGLISH, "active role");
        this.desactivable.setLocalizedDescription(SPANISH, "rol activo");
        this.reactivable.setLocalizedDescription(ENGLISH, "inactive role");
        this.reactivable.setLocalizedDescription(SPANISH, "rol inactivo");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.addSelectSegment(this.rolesBasicos, this.rolesAgregados);
        this.setUpdateFilter(this.modificables);
        this.setDeleteFilter(this.modificables);
    }

    @Override
    protected void settleOperations() {
        super.settleOperations();
        this.desactivar.addTransition(this.desactivable, this.reactivable);
        this.reactivar.addTransition(this.reactivable, this.desactivable);
    }

    @OperationClass(asynchronous=Kleenean.TRUE)
    @ProcessOperationClass
    public class PropagarFavoritos
    extends ProcessOperation {
        @InstanceReference
        protected Rol rol;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "propagate favorites");
            this.setLocalizedLabel(SPANISH, "propagar favoritos");
            this.setLocalizedDescription(ENGLISH, "produce a copy of the favorites of the role for each user of the role");
            this.setLocalizedDescription(SPANISH, "producir una copia de los favoritos asociados al rol para cada usuario asociado al rol");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.rol.setLocalizedLabel(ENGLISH, "role");
            this.rol.setLocalizedLabel(SPANISH, "rol");
            this.rol.setLocalizedDescription(ENGLISH, "Code of the role whose favorites you want to propagate; it is a required datum and has no default value");
            this.rol.setLocalizedDescription(SPANISH, "C\u00f3digo del rol cuyos favoritos desea propagar; es un dato obligatorio y no tiene valor por omisi\u00f3n");
        }
    }

    @OperationClass(asynchronous=Kleenean.TRUE)
    @ProcessOperationClass
    public class PropagarFiltros
    extends ProcessOperation {
        @InstanceReference
        protected Rol rol;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "propagate filters");
            this.setLocalizedLabel(SPANISH, "propagar filtros");
            this.setLocalizedDescription(ENGLISH, "produce a copy of the filters of the role for each user of the role");
            this.setLocalizedDescription(SPANISH, "producir una copia de los filtros asociados al rol para cada usuario asociado al rol");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.rol.setLocalizedLabel(ENGLISH, "role");
            this.rol.setLocalizedLabel(SPANISH, "rol");
            this.rol.setLocalizedDescription(ENGLISH, "Code of the role whose filters you want to propagate; it is a required datum and has no default value");
            this.rol.setLocalizedDescription(SPANISH, "C\u00f3digo del rol cuyos filtros desea propagar; es un dato obligatorio y no tiene valor por omisi\u00f3n");
        }
    }

    @OperationClass(asynchronous=Kleenean.TRUE)
    @ProcessOperationClass
    public class PropagarVistas
    extends ProcessOperation {
        @InstanceReference
        protected Rol rol;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "propagate views");
            this.setLocalizedLabel(SPANISH, "propagar vistas");
            this.setLocalizedDescription(ENGLISH, "produce a copy of the views of the role for each user of the role");
            this.setLocalizedDescription(SPANISH, "producir una copia de las vistas asociadas al rol para cada usuario asociado al rol");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.rol.setLocalizedLabel(ENGLISH, "role");
            this.rol.setLocalizedLabel(SPANISH, "rol");
            this.rol.setLocalizedDescription(ENGLISH, "Code of the role whose views you want to propagate; it is a required datum and has no default value");
            this.rol.setLocalizedDescription(SPANISH, "C\u00f3digo del rol cuyas vistas desea propagar; es un dato obligatorio y no tiene valor por omisi\u00f3n");
        }
    }

    @ProcessOperationClass
    public class ModificarConjunto
    extends ProcessOperation {
        @InstanceReference
        protected Rol rol;
        @ParameterField(required=Kleenean.TRUE)
        protected ConjuntoSegmento conjuntoSegmento;
        @ParameterField(required=Kleenean.TRUE)
        protected BooleanParameter soloSegmentadas;
        protected Check check101;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "change segment set");
            this.setLocalizedLabel(SPANISH, "modificar conjunto");
            this.setLocalizedDescription(ENGLISH, "modify the segment set of the functions of the role");
            this.setLocalizedDescription(SPANISH, "modificar el conjunto de segmentos de las funciones asociadas al rol");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.rol.setLocalizedLabel(ENGLISH, "role");
            this.rol.setLocalizedLabel(SPANISH, "rol");
            this.rol.setLocalizedDescription(ENGLISH, "Code of the role whose functions you want to modify; it is a required datum and has no default value");
            this.rol.setLocalizedDescription(SPANISH, "C\u00f3digo del rol cuyas funciones asociadas desea modificar; es un dato obligatorio y no tiene valor por omisi\u00f3n");
            this.conjuntoSegmento.setLocalizedLabel(ENGLISH, "segment set");
            this.conjuntoSegmento.setLocalizedLabel(SPANISH, "conjunto de segmentos");
            this.conjuntoSegmento.setLocalizedShortLabel(ENGLISH, "segment set");
            this.conjuntoSegmento.setLocalizedShortLabel(SPANISH, "conjunto");
            this.conjuntoSegmento.setLocalizedDescription(ENGLISH, "Code of the new segment set for functions; it is a required datum and has no default value");
            this.conjuntoSegmento.setLocalizedDescription(SPANISH, "C\u00f3digo del nuevo conjunto de segmentos para las funciones; es un dato obligatorio y no tiene valor por omisi\u00f3n");
            this.soloSegmentadas.setLocalizedLabel(ENGLISH, "only those already segmented");
            this.soloSegmentadas.setLocalizedLabel(SPANISH, "solo las ya segmentadas");
            this.soloSegmentadas.setLocalizedDescription(ENGLISH, "Determines if all functions will be modified, or only those already authorized to a segment set; it is a required datum and has no default value");
            this.soloSegmentadas.setLocalizedDescription(SPANISH, "Determina si ser\u00e1n modificadas todas las funciones, o solo las que ya est\u00e1n autorizadas a un conjunto de segmentos; es un dato obligatorio y no tiene valor por omisi\u00f3n");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.rol.id.isGreaterOrEqualTo(10000L);
            this.check101.setLocalizedDescription(ENGLISH, "the role is not a basic configuration role");
            this.check101.setLocalizedDescription(SPANISH, "el rol no es un rol de configuraci\u00f3n b\u00e1sica del sistema");
            this.check101.setLocalizedErrorMessage(ENGLISH, "the role is a basic configuration role; it can't be modified");
            this.check101.setLocalizedErrorMessage(SPANISH, "el rol es un rol de configuraci\u00f3n b\u00e1sica del sistema; no se permite modificarlo");
        }
    }

    @OperationClass(access=OperationAccess.PRIVATE)
    public class Reactivar
    extends ProcessOperation {
        @InstanceReference
        protected Rol rol;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "reactivate");
            this.setLocalizedLabel(SPANISH, "reactivar");
            this.setLocalizedDescription(ENGLISH, "reactivate an inactive role");
            this.setLocalizedDescription(SPANISH, "reactivar un rol inactivo");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.rol.esRolInactivo.setCurrentValue(false);
            this.rol.setLocalizedLabel(ENGLISH, "role");
            this.rol.setLocalizedLabel(SPANISH, "rol");
            this.rol.setLocalizedDescription(ENGLISH, "Code of the role you want to reactivate; it is a required datum and has no default value");
            this.rol.setLocalizedDescription(SPANISH, "C\u00f3digo del rol que desea reactivar; es un dato obligatorio y no tiene valor por omisi\u00f3n");
        }
    }

    @OperationClass(access=OperationAccess.PRIVATE)
    public class Desactivar
    extends ProcessOperation {
        @InstanceReference
        protected Rol rol;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "deactivate");
            this.setLocalizedLabel(SPANISH, "desactivar");
            this.setLocalizedDescription(ENGLISH, "deactivate an active role");
            this.setLocalizedDescription(SPANISH, "desactivar un rol activo");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.rol.esRolInactivo.setCurrentValue(true);
            this.rol.setLocalizedLabel(ENGLISH, "role");
            this.rol.setLocalizedLabel(SPANISH, "rol");
            this.rol.setLocalizedDescription(ENGLISH, "Code of the role you want to deactivate; it is a required datum and has no default value");
            this.rol.setLocalizedDescription(SPANISH, "C\u00f3digo del rol que desea desactivar; es un dato obligatorio y no tiene valor por omisi\u00f3n");
        }
    }

    @ProcessOperationClass
    @ConstructionOperationClass(type=Rol.class)
    public class Copiar
    extends ProcessOperation {
        @InstanceReference
        protected Rol rol;
        @ParameterField(required=Kleenean.TRUE)
        @StringField(maxLength=100)
        protected StringParameter codigo;
        @ParameterField(required=Kleenean.FALSE)
        @StringField(maxLength=100)
        protected StringParameter nombre;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "copy");
            this.setLocalizedLabel(SPANISH, "copiar");
            this.setLocalizedDescription(ENGLISH, "copy a role with another code and name; the copy includes filters, views, functions, and favorites of the original role, but not users");
            this.setLocalizedDescription(SPANISH, "copiar un rol con otro c\u00f3digo y nombre; la copia incluye los filtros, vistas, funciones y favoritos asociados al rol original, pero no los usuarios");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.rol.setLocalizedLabel(ENGLISH, "role");
            this.rol.setLocalizedLabel(SPANISH, "rol");
            this.rol.setLocalizedDescription(ENGLISH, "Code of the role you want to copy; it is a required datum and has no default value");
            this.rol.setLocalizedDescription(SPANISH, "C\u00f3digo del rol que desea copiar; es un dato obligatorio y no tiene valor por omisi\u00f3n");
            this.codigo.setLocalizedLabel(ENGLISH, "code");
            this.codigo.setLocalizedLabel(SPANISH, "c\u00f3digo");
            this.codigo.setLocalizedDescription(ENGLISH, "Code of the new role produced when copying; it is a required datum and has no default value");
            this.codigo.setLocalizedDescription(SPANISH, "C\u00f3digo del nuevo rol que produce la copia; es un dato obligatorio y no tiene valor por omisi\u00f3n");
            this.nombre.setLocalizedLabel(ENGLISH, "name");
            this.nombre.setLocalizedLabel(SPANISH, "nombre");
            this.nombre.setLocalizedDescription(ENGLISH, "Name of the new role produced when copying; it is an optional datum; by default, the name of the original role is used");
            this.nombre.setLocalizedDescription(SPANISH, "Nombre del nuevo rol que produce la copia; es un dato opcional; por omisi\u00f3n se utiliza el nombre del rol original");
        }
    }
}

