/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.control.acceso;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.annotations.Allocation;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.QuickAddingFilter;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.properties.LongProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.Pagina;
import meta.entidad.comun.control.acceso.Rol;

@EntityClass(independent=Kleenean.FALSE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.FEMININE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.TRUE)
@EntityDetailView(enabled=Kleenean.FALSE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
public class RolPagina
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @ForeignKey(onDelete=OnDeleteAction.CASCADE, onUpdate=OnUpdateAction.CASCADE)
    @ManyToOne(navigability=Navigability.BIDIRECTIONAL, view=MasterDetailView.TABLE)
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(required=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    @Allocation(maxDepth=1, maxRound=0)
    public Rol rol;
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE, quickAdding=QuickAddingFilter.MISSING)
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(required=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    @Allocation(maxDepth=2, maxRound=0)
    public Pagina pagina;
    protected Key uk_rol_pagina_0001;
    protected Check check101;

    @Deprecated
    RolPagina() {
        this(null, null);
    }

    public RolPagina(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "role/page association");
        this.setLocalizedLabel(SPANISH, "asociaci\u00f3n Rol/P\u00e1gina");
        this.setLocalizedCollectionLabel(ENGLISH, "Role/Page Associations");
        this.setLocalizedCollectionLabel(SPANISH, "Asociaciones Rol/P\u00e1gina");
        this.setLocalizedCollectionLabel(ENGLISH, this.rol, "Favorites by Role");
        this.setLocalizedCollectionLabel(SPANISH, this.rol, "Favoritos por Rol");
        this.setLocalizedCollectionShortLabel(ENGLISH, this.rol, "Favorites");
        this.setLocalizedCollectionShortLabel(SPANISH, this.rol, "Favoritos");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.rol.setLocalizedLabel(ENGLISH, "role");
        this.rol.setLocalizedLabel(SPANISH, "rol");
        this.pagina.setLocalizedLabel(ENGLISH, "page");
        this.pagina.setLocalizedLabel(SPANISH, "p\u00e1gina");
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        this.uk_rol_pagina_0001.setUnique(true);
        this.uk_rol_pagina_0001.newKeyField(this.rol, this.pagina);
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.check101 = RolPagina.and(this.pagina.esEspecial.isFalse(), this.pagina.tipoPagina.isNotEqualTo(this.pagina.tipoPagina.DETALLE), this.pagina.tipoPagina.isNotEqualTo(this.pagina.tipoPagina.CONSULTA_DETALLE), this.pagina.dominio.isNotNull(), this.pagina.dominioMaestro.isNull(), this.pagina.parametro.isNull());
        this.check101.setLocalizedLabel(ENGLISH, "check page");
        this.check101.setLocalizedLabel(SPANISH, "chequear p\u00e1gina");
        this.check101.setLocalizedDescription(ENGLISH, "the page should not be a special or detail or master/detail page");
        this.check101.setLocalizedDescription(SPANISH, "la p\u00e1gina no debe ser una p\u00e1gina especial, ni de detalle, ni de maestro/detalle");
        this.check101.setLocalizedErrorMessage(ENGLISH, "the page is a special or detail or master/detail page");
        this.check101.setLocalizedErrorMessage(SPANISH, "la p\u00e1gina es una p\u00e1gina especial, o de detalle, o de maestro/detalle");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.pagina.setSearchQueryFilter(this.check101);
    }
}

