/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.control.prueba;

import adalid.core.Key;
import adalid.core.ProcessOperation;
import adalid.core.Tab;
import adalid.core.annotations.Allocation;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.ParentProperty;
import adalid.core.annotations.ProcessOperationClass;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.DefaultCondition;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Segment;
import adalid.core.parameters.StringParameter;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;
import meta.entidad.comun.auditoria.RastroFuncion;
import meta.entidad.comun.configuracion.basica.CondicionEjeFun;
import meta.entidad.comun.control.prueba.EjecucionPrueba;
import meta.entidad.comun.control.prueba.EscenarioPrueba;
import meta.entidad.comun.control.prueba.ProgramaPrueba;
import meta.entidad.comun.control.prueba.TipoResultadoPrueba;

@EntityClass(independent=Kleenean.FALSE, resourceType=ResourceType.TESTING, resourceGender=ResourceGender.FEMININE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE, onload=SelectOnloadOption.EXECUTE)
@EntityInsertOperation(enabled=Kleenean.FALSE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.FALSE)
@EntityTableView(enabled=Kleenean.TRUE, inserts=Kleenean.FALSE)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.TRUE)
public class EjecucionLineaPrueba
extends PersistentEntityBase {
    @BusinessKey
    @StringField(maxLength=100)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.FALSE, defaultCondition=DefaultCondition.UNCONDITIONALLY, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public StringProperty codigo;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public IntegerProperty numero;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public IntegerProperty nivel;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.TABLE_AND_DETAIL)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public EjecucionPrueba ejecucion;
    @Allocation(maxDepth=1, maxRound=0)
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public ProgramaPrueba programa;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public EscenarioPrueba escenario;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public ProgramaPrueba subprograma;
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public StringProperty condiciones;
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public StringProperty repeticiones;
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public StringProperty comentarios;
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public StringProperty resultados;
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.TRUE)
    public StringProperty observaciones;
    @FileReference
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public StringProperty archivo;
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public RastroFuncion rastro;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public CondicionEjeFun condicionEjecucion;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public TimestampProperty fechaHoraCondicionEjecucion;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public TipoResultadoPrueba tipoResultado;
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public BooleanProperty resultadoEsperado;
    @ParentProperty
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    public EjecucionLineaPrueba superior;
    protected Key key1;
    protected Tab tab1;
    protected Tab tab2;
    protected Tab tab3;
    protected Tab tab4;
    protected Segment funcional;
    protected Check check0101;
    protected Cargar cargar;
    protected RegistrarResultadoConRastro registrarResultadoConRastro;
    protected RegistrarResultadoSinRastro registrarResultadoSinRastro;
    protected ReversarResultado reversarResultado;

    @Deprecated
    EjecucionLineaPrueba() {
        this(null, null);
    }

    public EjecucionLineaPrueba(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings("ejecucion.responsable", "escenario.caso.funcion");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "test program line execution");
        this.setLocalizedLabel(SPANISH, "ejecuci\u00f3n de l\u00ednea de programa de prueba");
        this.setLocalizedShortLabel(ENGLISH, "line execution");
        this.setLocalizedShortLabel(SPANISH, "ejecuci\u00f3n de l\u00ednea");
        this.setLocalizedCollectionLabel(ENGLISH, "Test Program Line Executions");
        this.setLocalizedCollectionLabel(SPANISH, "Ejecuciones de L\u00edneas de Programas de Prueba");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Line Executions");
        this.setLocalizedCollectionShortLabel(SPANISH, "Ejecuciones de L\u00edneas");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.codigo.setDefaultValue(this.ejecucion.codigo.concat("-").concat(this.numero));
        this.condicionEjecucion.setInitialValue(this.condicionEjecucion.EJECUCION_PENDIENTE);
        this.condicionEjecucion.setDefaultValue(this.condicionEjecucion.EJECUCION_PENDIENTE);
        this.fechaHoraCondicionEjecucion.setInitialValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.fechaHoraCondicionEjecucion.setDefaultValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.codigo.setLocalizedLabel(ENGLISH, "test program line execution code");
        this.codigo.setLocalizedLabel(SPANISH, "c\u00f3digo de la ejecuci\u00f3n de l\u00ednea de programa de prueba");
        this.codigo.setLocalizedShortLabel(ENGLISH, "code");
        this.codigo.setLocalizedShortLabel(SPANISH, "c\u00f3digo");
        this.numero.setLocalizedLabel(ENGLISH, "number");
        this.numero.setLocalizedLabel(SPANISH, "n\u00famero");
        this.nivel.setLocalizedLabel(ENGLISH, "level");
        this.nivel.setLocalizedLabel(SPANISH, "nivel");
        this.ejecucion.setLocalizedLabel(ENGLISH, "program execution");
        this.ejecucion.setLocalizedLabel(SPANISH, "ejecuci\u00f3n de programa");
        this.programa.setLocalizedLabel(ENGLISH, "program");
        this.programa.setLocalizedLabel(SPANISH, "programa");
        this.escenario.setLocalizedLabel(ENGLISH, "scenario");
        this.escenario.setLocalizedLabel(SPANISH, "escenario");
        this.subprograma.setLocalizedLabel(ENGLISH, "subprogram");
        this.subprograma.setLocalizedLabel(SPANISH, "subprograma");
        this.condiciones.setLocalizedLabel(ENGLISH, "conditions");
        this.condiciones.setLocalizedLabel(SPANISH, "condiciones");
        this.repeticiones.setLocalizedLabel(ENGLISH, "repetitions");
        this.repeticiones.setLocalizedLabel(SPANISH, "repeticiones");
        this.comentarios.setLocalizedLabel(ENGLISH, "comments");
        this.comentarios.setLocalizedLabel(SPANISH, "comentarios");
        this.resultados.setLocalizedLabel(ENGLISH, "results");
        this.resultados.setLocalizedLabel(SPANISH, "resultados");
        this.observaciones.setLocalizedLabel(ENGLISH, "remarks");
        this.observaciones.setLocalizedLabel(SPANISH, "observaciones");
        this.archivo.setLocalizedLabel(ENGLISH, "file");
        this.archivo.setLocalizedLabel(SPANISH, "archivo");
        this.archivo.setLocalizedTooltip(ENGLISH, "open the file");
        this.archivo.setLocalizedTooltip(SPANISH, "abrir el archivo");
        this.rastro.setLocalizedLabel(ENGLISH, "trail");
        this.rastro.setLocalizedLabel(SPANISH, "rastro");
        this.condicionEjecucion.setLocalizedLabel(ENGLISH, "condition");
        this.condicionEjecucion.setLocalizedLabel(SPANISH, "condici\u00f3n ejecuci\u00f3n");
        this.fechaHoraCondicionEjecucion.setLocalizedLabel(ENGLISH, "condition timestamp");
        this.fechaHoraCondicionEjecucion.setLocalizedLabel(SPANISH, "fecha hora condici\u00f3n ejecuci\u00f3n");
        this.tipoResultado.setLocalizedLabel(ENGLISH, "result type");
        this.tipoResultado.setLocalizedLabel(SPANISH, "tipo resultado");
        this.resultadoEsperado.setLocalizedLabel(ENGLISH, "expected result");
        this.resultadoEsperado.setLocalizedLabel(SPANISH, "resultado esperado");
        this.superior.setLocalizedLabel(ENGLISH, "test program line execution parent");
        this.superior.setLocalizedLabel(SPANISH, "superior de la ejecuci\u00f3n de l\u00ednea de programa de prueba");
        this.superior.setLocalizedShortLabel(ENGLISH, "parent");
        this.superior.setLocalizedShortLabel(SPANISH, "superior");
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
        this.linkForeignOwnerProperty(this.ejecucion.responsable);
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        this.key1.newKeyField(this.ejecucion, this.numero, this.id);
        this.key1.setUnique(true);
        this.setOrderBy(this.key1);
    }

    @Override
    protected void settleTabs() {
        super.settleTabs();
        this.tab1.newTabField(this.codigo, this.ejecucion, this.numero, this.nivel, this.programa, this.escenario, this.subprograma);
        this.tab2.newTabField(this.condiciones, this.repeticiones, this.comentarios);
        this.tab3.newTabField(this.condicionEjecucion, this.fechaHoraCondicionEjecucion, this.tipoResultado, this.resultadoEsperado);
        this.tab4.newTabField(this.resultados, this.observaciones, this.archivo, this.rastro);
        this.tab1.setLocalizedLabel(ENGLISH, "basic data");
        this.tab1.setLocalizedLabel(SPANISH, "datos b\u00e1sicos");
        this.tab2.setLocalizedLabel(ENGLISH, "additional data");
        this.tab2.setLocalizedLabel(SPANISH, "datos adicionales");
        this.tab3.setLocalizedLabel(ENGLISH, "condition");
        this.tab3.setLocalizedLabel(SPANISH, "condici\u00f3n");
        this.tab4.setLocalizedLabel(ENGLISH, "result");
        this.tab4.setLocalizedLabel(SPANISH, "resultado");
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.funcional = this.escenario.caso.funcion.isNotNull();
        this.check0101 = this.escenario.isNotNull().xor(this.subprograma.isNotNull());
        this.funcional.setLocalizedLabel(ENGLISH, "check the function of the case of the scenario");
        this.funcional.setLocalizedLabel(SPANISH, "chequear la funci\u00f3n del caso del escenario");
        this.funcional.setLocalizedDescription(ENGLISH, "the function of the case of the scenario should be defined");
        this.funcional.setLocalizedDescription(SPANISH, "la funci\u00f3n del caso del escenario deber\u00eda estar definida");
        this.funcional.setLocalizedErrorMessage(ENGLISH, "the function of the case of the scenario is not defined");
        this.funcional.setLocalizedErrorMessage(SPANISH, "la funci\u00f3n del caso del escenario no est\u00e1 definida");
        this.check0101.setLocalizedDescription(ENGLISH, "scenario and subprogram are mutually exclusive");
        this.check0101.setLocalizedDescription(SPANISH, "escenario y subprograma son mutuamente excluyentes");
        this.check0101.setLocalizedErrorMessage(ENGLISH, "scenario and subprogram are mutually exclusive");
        this.check0101.setLocalizedErrorMessage(SPANISH, "escenario y subprograma son mutuamente excluyentes");
    }

    @ProcessOperationClass
    public class ReversarResultado
    extends ProcessOperation {
        @InstanceReference
        protected EjecucionLineaPrueba ejecucion;
        protected Check check0101;
        protected Check check0102;
        protected Check check0103;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "reverse result");
            this.setLocalizedLabel(SPANISH, "reversar resultado");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.ejecucion.setLocalizedLabel(ENGLISH, "execution");
            this.ejecucion.setLocalizedLabel(SPANISH, "ejecuci\u00f3n");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check0101 = this.ejecucion.condicionEjecucion.isNotEqualTo(EjecucionLineaPrueba.this.condicionEjecucion.EJECUCION_PENDIENTE);
            this.check0102 = this.ejecucion.subprograma.isNull();
            this.check0103 = this.ejecucion.escenario.isNotNull();
            this.check0101.setLocalizedDescription(ENGLISH, "check0101");
            this.check0101.setLocalizedDescription(SPANISH, "check0101");
            this.check0101.setLocalizedErrorMessage(ENGLISH, "the result of the execution of the line is not registered");
            this.check0101.setLocalizedErrorMessage(SPANISH, "el resultado de la ejecuci\u00f3n de la l\u00ednea no est\u00e1 registrado");
            this.check0102.setLocalizedDescription(ENGLISH, "check0102");
            this.check0102.setLocalizedDescription(SPANISH, "check0102");
            this.check0102.setLocalizedErrorMessage(ENGLISH, "the line corresponds to the execution of a subprogram");
            this.check0102.setLocalizedErrorMessage(SPANISH, "la l\u00ednea corresponde a la ejecuci\u00f3n de un subprograma");
            this.check0103.setLocalizedDescription(ENGLISH, "check0103");
            this.check0103.setLocalizedDescription(SPANISH, "check0103");
            this.check0103.setLocalizedErrorMessage(ENGLISH, "the line does not correspond to the execution of a scenario");
            this.check0103.setLocalizedErrorMessage(SPANISH, "la l\u00ednea no corresponde a la ejecuci\u00f3n de un escenario");
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            this.ejecucion.setSearchQueryFilter(ReversarResultado.and(this.check0101, this.check0102, this.check0103));
        }
    }

    @ProcessOperationClass
    public class RegistrarResultadoSinRastro
    extends ProcessOperation {
        @InstanceReference
        protected EjecucionLineaPrueba ejecucion;
        @ParameterField(required=Kleenean.TRUE, linkedField="condicionEjecucion")
        protected CondicionEjeFun condicionEjecucion;
        @ParameterField(required=Kleenean.FALSE, linkedField="resultados")
        protected StringParameter resultados;
        @ParameterField(required=Kleenean.FALSE, linkedField="observaciones")
        protected StringParameter observaciones;
        @FileReference
        @ParameterField(required=Kleenean.FALSE, linkedField="archivo")
        protected StringParameter archivo;
        @ParameterField(required=Kleenean.FALSE)
        protected StringParameter descripcionArchivo;
        protected Check check0101;
        protected Check check0102;
        protected Check check0103;
        protected Check check0104;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "record result without a trail");
            this.setLocalizedLabel(SPANISH, "registrar resultado sin rastro");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.ejecucion.fechaHoraCondicionEjecucion.setCurrentValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
            this.ejecucion.setLocalizedLabel(ENGLISH, "execution");
            this.ejecucion.setLocalizedLabel(SPANISH, "ejecuci\u00f3n");
            this.condicionEjecucion.setLocalizedLabel(ENGLISH, "condition");
            this.condicionEjecucion.setLocalizedLabel(SPANISH, "condici\u00f3n ejecuci\u00f3n");
            this.resultados.setLocalizedLabel(ENGLISH, "results");
            this.resultados.setLocalizedLabel(SPANISH, "resultados");
            this.observaciones.setLocalizedLabel(ENGLISH, "remarks");
            this.observaciones.setLocalizedLabel(SPANISH, "observaciones");
            this.archivo.setLocalizedLabel(ENGLISH, "file");
            this.archivo.setLocalizedLabel(SPANISH, "archivo");
            this.archivo.setLocalizedTooltip(ENGLISH, "file");
            this.archivo.setLocalizedTooltip(SPANISH, "archivo");
            this.descripcionArchivo.setLocalizedLabel(ENGLISH, "file description");
            this.descripcionArchivo.setLocalizedLabel(SPANISH, "descripci\u00f3n archivo");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check0101 = this.ejecucion.condicionEjecucion.isEqualTo(this.condicionEjecucion.EJECUCION_PENDIENTE);
            this.check0102 = this.ejecucion.subprograma.isNull();
            this.check0103 = this.ejecucion.escenario.isNotNull();
            this.check0104 = this.ejecucion.escenario.isNotNull().implies(this.ejecucion.escenario.caso.funcion.isNull());
            this.check0101.setLocalizedDescription(ENGLISH, "check0101");
            this.check0101.setLocalizedDescription(SPANISH, "check0101");
            this.check0101.setLocalizedErrorMessage(ENGLISH, "the result of the execution of the line is already registered");
            this.check0101.setLocalizedErrorMessage(SPANISH, "el resultado de la ejecuci\u00f3n de la l\u00ednea ya est\u00e1 registrado");
            this.check0102.setLocalizedDescription(ENGLISH, "check0102");
            this.check0102.setLocalizedDescription(SPANISH, "check0102");
            this.check0102.setLocalizedErrorMessage(ENGLISH, "the line corresponds to the execution of a subprogram");
            this.check0102.setLocalizedErrorMessage(SPANISH, "la l\u00ednea corresponde a la ejecuci\u00f3n de un subprograma");
            this.check0103.setLocalizedDescription(ENGLISH, "check0103");
            this.check0103.setLocalizedDescription(SPANISH, "check0103");
            this.check0103.setLocalizedErrorMessage(ENGLISH, "the line does not correspond to the execution of a scenario");
            this.check0103.setLocalizedErrorMessage(SPANISH, "la l\u00ednea no corresponde a la ejecuci\u00f3n de un escenario");
            this.check0104.setLocalizedDescription(ENGLISH, "check0104");
            this.check0104.setLocalizedDescription(SPANISH, "check0104");
            this.check0104.setLocalizedErrorMessage(ENGLISH, "the line corresponds to the execution of a scenario whose case is linked to a function");
            this.check0104.setLocalizedErrorMessage(SPANISH, "la l\u00ednea corresponde a la ejecuci\u00f3n de un escenario cuyo caso est\u00e1 enlazado a una funci\u00f3n");
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            this.ejecucion.setSearchQueryFilter(RegistrarResultadoSinRastro.and(this.check0101, this.check0102, this.check0103, this.check0104));
            this.condicionEjecucion.setSearchInstanceArray(this.condicionEjecucion.EJECUTADO_SIN_ERRORES, this.condicionEjecucion.EJECUTADO_CON_ERRORES, this.condicionEjecucion.EJECUCION_CANCELADA);
        }
    }

    @ProcessOperationClass
    public class RegistrarResultadoConRastro
    extends ProcessOperation {
        @InstanceReference
        protected EjecucionLineaPrueba ejecucion;
        @ParameterField(required=Kleenean.TRUE, linkedField="rastro")
        protected RastroFuncion rastro;
        @ParameterField(required=Kleenean.FALSE, linkedField="observaciones")
        protected StringParameter observaciones;
        @FileReference
        @ParameterField(required=Kleenean.FALSE, linkedField="archivo")
        protected StringParameter archivo;
        @ParameterField(required=Kleenean.FALSE)
        protected StringParameter descripcionArchivo;
        protected Check check0101;
        protected Check check0102;
        protected Check check0103;
        protected Check check0104;
        protected Check check0201;
        protected Check check0202;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "register result with trail");
            this.setLocalizedLabel(SPANISH, "registrar resultado con rastro");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.ejecucion.setLocalizedLabel(ENGLISH, "execution");
            this.ejecucion.setLocalizedLabel(SPANISH, "ejecuci\u00f3n");
            this.rastro.setLocalizedLabel(ENGLISH, "trail");
            this.rastro.setLocalizedLabel(SPANISH, "rastro");
            this.observaciones.setLocalizedLabel(ENGLISH, "remarks");
            this.observaciones.setLocalizedLabel(SPANISH, "observaciones");
            this.archivo.setLocalizedLabel(ENGLISH, "file");
            this.archivo.setLocalizedLabel(SPANISH, "archivo");
            this.archivo.setLocalizedTooltip(ENGLISH, "file");
            this.archivo.setLocalizedTooltip(SPANISH, "archivo");
            this.descripcionArchivo.setLocalizedLabel(ENGLISH, "file description");
            this.descripcionArchivo.setLocalizedLabel(SPANISH, "descripci\u00f3n archivo");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check0101 = this.ejecucion.condicionEjecucion.isEqualTo(EjecucionLineaPrueba.this.condicionEjecucion.EJECUCION_PENDIENTE);
            this.check0102 = this.ejecucion.subprograma.isNull();
            this.check0103 = this.ejecucion.escenario.isNotNull();
            this.check0104 = this.ejecucion.escenario.isNotNull().implies(this.ejecucion.escenario.caso.funcion.isNotNull());
            this.check0201 = this.rastro.condicionEjeFun.isIn(EjecucionLineaPrueba.this.condicionEjecucion.EJECUTADO_SIN_ERRORES, EjecucionLineaPrueba.this.condicionEjecucion.EJECUTADO_CON_ERRORES, EjecucionLineaPrueba.this.condicionEjecucion.EJECUCION_CANCELADA);
            this.check0202 = this.rastro.funcion.isEqualTo(this.ejecucion.escenario.caso.funcion);
            this.check0101.setLocalizedDescription(ENGLISH, "check0101");
            this.check0101.setLocalizedDescription(SPANISH, "check0101");
            this.check0101.setLocalizedErrorMessage(ENGLISH, "the result of the execution of the line is already registered");
            this.check0101.setLocalizedErrorMessage(SPANISH, "el resultado de la ejecuci\u00f3n de la l\u00ednea ya est\u00e1 registrado");
            this.check0102.setLocalizedDescription(ENGLISH, "check0102");
            this.check0102.setLocalizedDescription(SPANISH, "check0102");
            this.check0102.setLocalizedErrorMessage(ENGLISH, "the line corresponds to the execution of a subprogram");
            this.check0102.setLocalizedErrorMessage(SPANISH, "la l\u00ednea corresponde a la ejecuci\u00f3n de un subprograma");
            this.check0103.setLocalizedDescription(ENGLISH, "check0103");
            this.check0103.setLocalizedDescription(SPANISH, "check0103");
            this.check0103.setLocalizedErrorMessage(ENGLISH, "the line does not correspond to the execution of a scenario");
            this.check0103.setLocalizedErrorMessage(SPANISH, "la l\u00ednea no corresponde a la ejecuci\u00f3n de un escenario");
            this.check0104.setLocalizedDescription(ENGLISH, "check0104");
            this.check0104.setLocalizedDescription(SPANISH, "check0104");
            this.check0104.setLocalizedErrorMessage(ENGLISH, "the line corresponds to the execution of a scenario whose case is not linked to a function");
            this.check0104.setLocalizedErrorMessage(SPANISH, "la l\u00ednea corresponde a la ejecuci\u00f3n de un escenario cuyo caso no est\u00e1 enlazado a una funci\u00f3n");
            this.check0201.setLocalizedDescription(ENGLISH, "check0201");
            this.check0201.setLocalizedDescription(SPANISH, "check0201");
            this.check0201.setLocalizedErrorMessage(ENGLISH, "the trail corresponds to an execution that has not been completed (is pending or in progress)");
            this.check0201.setLocalizedErrorMessage(SPANISH, "el rastro corresponde a una ejecuci\u00f3n que no ha conclu\u00eddo (est\u00e1 pendiente o en progreso)");
            this.check0202.setLocalizedDescription(ENGLISH, "check0202");
            this.check0202.setLocalizedDescription(SPANISH, "check0202");
            this.check0202.setLocalizedErrorMessage(ENGLISH, "the trail corresponds to a function different from the one linked to the case of the line scenario");
            this.check0202.setLocalizedErrorMessage(SPANISH, "el rastro corresponde a una funci\u00f3n diferente a la enlazada al caso del escenario de la l\u00ednea");
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            this.ejecucion.setSearchQueryFilter(RegistrarResultadoConRastro.and(this.check0101, this.check0102, this.check0103, this.check0104));
            this.rastro.setSearchQueryFilter(RegistrarResultadoConRastro.and(this.check0201, this.check0202));
        }
    }

    @ProcessOperationClass
    public class Cargar
    extends ProcessOperation {
        @InstanceReference
        protected EjecucionLineaPrueba ejecucion;
        @FileReference
        @ParameterField(required=Kleenean.TRUE)
        protected StringParameter archivo;
        @ParameterField(required=Kleenean.FALSE)
        protected StringParameter descripcionArchivo;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "upload");
            this.setLocalizedLabel(SPANISH, "cargar");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.ejecucion.setLocalizedLabel(ENGLISH, "execution");
            this.ejecucion.setLocalizedLabel(SPANISH, "ejecuci\u00f3n");
            this.archivo.setLocalizedLabel(ENGLISH, "file");
            this.archivo.setLocalizedLabel(SPANISH, "archivo");
            this.descripcionArchivo.setLocalizedLabel(ENGLISH, "file description");
            this.descripcionArchivo.setLocalizedLabel(SPANISH, "descripci\u00f3n archivo");
        }
    }
}

