/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.operacion.basica;

import adalid.core.AbstractPersistentEntity;
import adalid.core.ProcessOperation;
import adalid.core.annotations.Allocation;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.DefaultCondition;
import adalid.core.enums.Kleenean;
import adalid.core.enums.ListStyle;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SearchType;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.ViewMenuOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Segment;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.ext.Funcion;
import meta.entidad.comun.control.acceso.Usuario;

@EntityClass(base=Kleenean.TRUE, independent=Kleenean.FALSE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.FEMININE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.TRUE, menu=ViewMenuOption.NONE)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.TRUE, menu=Kleenean.FALSE)
public class VistaFuncion
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @BusinessKey
    @StringField(maxLength=100)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.FALSE, heading=Kleenean.FALSE, defaultCondition=DefaultCondition.UNCONDITIONALLY_ON_INSERT, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public StringProperty codigo;
    @NameProperty
    public StringProperty nombre;
    @DescriptionProperty
    public StringProperty descripcion;
    @ManyToOne(navigability=Navigability.BIDIRECTIONAL, view=MasterDetailView.TABLE_AND_DETAIL)
    @ColumnField(nullable=Kleenean.FALSE)
    public Funcion funcion;
    @OwnerProperty
    @ForeignKey(onDelete=OnDeleteAction.CASCADE, onUpdate=OnUpdateAction.CASCADE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @ColumnField(nullable=Kleenean.TRUE)
    @Allocation(maxDepth=1, maxRound=0)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, search=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE, defaultCondition=DefaultCondition.IF_NULL_ON_INSERT, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public Usuario propietario;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, search=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.FALSE)
    public Usuario remitente;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, search=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public BooleanProperty publica;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, search=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public BooleanProperty especial;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(hidden=Kleenean.TRUE)
    public BooleanProperty valida;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(hidden=Kleenean.TRUE)
    public IntegerProperty secuencia;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idVistaFuncionOriginal;
    protected Segment privadas;
    protected EnviarCopia enviarCopia;
    protected Publicar publicar;
    protected Privatizar privatizar;

    @Deprecated
    VistaFuncion() {
        this(null, null);
    }

    public VistaFuncion(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings("funcion.dominio");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setOrderBy(this.funcion, this.publica, this.especial, this.nombre);
        this.setLocalizedLabel(ENGLISH, "view");
        this.setLocalizedLabel(SPANISH, "vista");
        this.setLocalizedCollectionLabel(ENGLISH, "Views");
        this.setLocalizedCollectionLabel(SPANISH, "Vistas");
        this.setLocalizedDescription(ENGLISH, "view to generate files and reports defined by the end user");
        this.setLocalizedDescription(SPANISH, "vista para generar archivos e informes definida por el usuario final");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.codigo.setDefaultValue(this.funcion.dominio.codigoDominio.concat("-").concat(this.id));
        this.publica.setInitialValue(false);
        this.publica.setDefaultValue(false);
        this.especial.setInitialValue(false);
        this.especial.setDefaultValue(false);
        this.valida.setInitialValue(false);
        this.valida.setDefaultValue(false);
        this.secuencia.setInitialValue(0);
        this.secuencia.setDefaultValue(0);
        this.codigo.setLocalizedLabel(ENGLISH, "view code");
        this.codigo.setLocalizedLabel(SPANISH, "c\u00f3digo de la vista");
        this.codigo.setLocalizedShortLabel(ENGLISH, "code");
        this.codigo.setLocalizedShortLabel(SPANISH, "c\u00f3digo");
        this.nombre.setLocalizedLabel(ENGLISH, "view name");
        this.nombre.setLocalizedLabel(SPANISH, "nombre de la vista");
        this.nombre.setLocalizedShortLabel(ENGLISH, "name");
        this.nombre.setLocalizedShortLabel(SPANISH, "nombre");
        this.descripcion.setLocalizedLabel(ENGLISH, "view description");
        this.descripcion.setLocalizedLabel(SPANISH, "descripci\u00f3n de la vista");
        this.descripcion.setLocalizedShortLabel(ENGLISH, "description");
        this.descripcion.setLocalizedShortLabel(SPANISH, "descripci\u00f3n");
        this.funcion.setLocalizedLabel(ENGLISH, "function");
        this.funcion.setLocalizedLabel(SPANISH, "funci\u00f3n");
        this.propietario.setLocalizedLabel(ENGLISH, "view owner");
        this.propietario.setLocalizedLabel(SPANISH, "propietario de la vista");
        this.propietario.setLocalizedShortLabel(ENGLISH, "owner");
        this.propietario.setLocalizedShortLabel(SPANISH, "propietario");
        this.remitente.setLocalizedLabel(ENGLISH, "sender");
        this.remitente.setLocalizedLabel(SPANISH, "remitente");
        this.publica.setLocalizedLabel(ENGLISH, "public");
        this.publica.setLocalizedLabel(SPANISH, "p\u00fablica");
        this.especial.setLocalizedLabel(ENGLISH, "special");
        this.especial.setLocalizedLabel(SPANISH, "especial");
        this.valida.setLocalizedLabel(ENGLISH, "valid");
        this.valida.setLocalizedLabel(SPANISH, "v\u00e1lida");
        this.secuencia.setLocalizedLabel(ENGLISH, "sequence");
        this.secuencia.setLocalizedLabel(SPANISH, "secuencia");
        this.idVistaFuncionOriginal.setLocalizedLabel(ENGLISH, "original view");
        this.idVistaFuncionOriginal.setLocalizedLabel(SPANISH, "vista original");
        this.idVistaFuncionOriginal.setLocalizedShortLabel(ENGLISH, "original");
        this.idVistaFuncionOriginal.setLocalizedShortLabel(SPANISH, "original");
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.privadas = this.publica.isFalse().and(this.especial.isFalse());
        this.privadas.setLocalizedErrorMessage(ENGLISH, "the view is public or special");
        this.privadas.setLocalizedErrorMessage(SPANISH, "la vista es p\u00fablica o especial");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.setUpdateFilter(this.privadas);
        this.setDeleteFilter(this.privadas);
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    public class Privatizar
    extends ProcessOperation {
        @InstanceReference
        @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME)
        protected VistaFuncion vista;
        Check check101;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "privatize");
            this.setLocalizedLabel(SPANISH, "privatizar");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.vista.publica.setCurrentValue(false);
            this.vista.propietario.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            this.vista.setLocalizedLabel(ENGLISH, "view");
            this.vista.setLocalizedLabel(SPANISH, "vista");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.vista.publica.isTrue();
            this.check101.setLocalizedErrorMessage(ENGLISH, "the view is already private");
            this.check101.setLocalizedErrorMessage(SPANISH, "la vista ya es privada");
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            this.vista.setSearchQueryFilter(this.check101);
        }
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    public class Publicar
    extends ProcessOperation {
        @InstanceReference
        @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME)
        protected VistaFuncion vista;
        Check check101;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "publish");
            this.setLocalizedLabel(SPANISH, "publicar");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.vista.publica.setCurrentValue(true);
            this.vista.propietario.setCurrentValue(SpecialEntityValue.NULL);
            this.vista.setLocalizedLabel(ENGLISH, "view");
            this.vista.setLocalizedLabel(SPANISH, "vista");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.vista.publica.isFalse();
            this.check101.setLocalizedErrorMessage(ENGLISH, "the view is already public");
            this.check101.setLocalizedErrorMessage(SPANISH, "la vista ya es p\u00fablica");
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            this.vista.setSearchQueryFilter(this.check101);
        }
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    public class EnviarCopia
    extends ProcessOperation {
        @InstanceReference
        @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME)
        protected VistaFuncion vista;
        @ParameterField(required=Kleenean.TRUE)
        @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.CHARACTER_KEY_AND_NAME)
        protected Usuario destinatario;
        Check check101;
        Check check102;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "send a copy");
            this.setLocalizedLabel(SPANISH, "enviar copia");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.vista.setLocalizedLabel(ENGLISH, "view");
            this.vista.setLocalizedLabel(SPANISH, "vista");
            this.destinatario.setLocalizedLabel(ENGLISH, "recipient user");
            this.destinatario.setLocalizedLabel(SPANISH, "usuario destinatario");
            this.destinatario.setLocalizedShortLabel(ENGLISH, "recipient");
            this.destinatario.setLocalizedShortLabel(SPANISH, "destinatario");
            this.destinatario.setLocalizedShortDescription(ENGLISH, "view recipient");
            this.destinatario.setLocalizedShortDescription(SPANISH, "destinatario de la vista");
            this.destinatario.setLocalizedTooltip(ENGLISH, "user code of the view recipient");
            this.destinatario.setLocalizedTooltip(SPANISH, "c\u00f3digo de usuario del destinatario de la vista");
            this.destinatario.codigoUsuario.setLocalizedShortLabel(ENGLISH, "recipient code");
            this.destinatario.codigoUsuario.setLocalizedShortLabel(SPANISH, "destinatario");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.vista.publica.isFalse();
            this.check102 = this.destinatario.esUsuarioEspecial.isFalse();
            this.check101.setLocalizedErrorMessage(ENGLISH, "it is not allowed to send copies of public views");
            this.check101.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido enviar copias de vistas p\u00fablicas");
            this.check102.setLocalizedErrorMessage(ENGLISH, "it is not allowed to send copies of views to special users");
            this.check102.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido enviar copias de vistas a usuarios especiales");
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            this.vista.setSearchQueryFilter(this.check101);
            this.destinatario.setSearchQueryFilter(this.destinatario.esUsuarioEspecial.isFalse());
        }
    }
}

