/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.operacion.basica;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.annotations.Allocation;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceDisplay;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityTriggers;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.Filter;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.MasterSequence;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyAggregation;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.AggregateFunction;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.DefaultCondition;
import adalid.core.enums.EntityReferenceStyle;
import adalid.core.enums.Kleenean;
import adalid.core.enums.ListStyle;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.NextValueRule;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.QuickAddingFilter;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SearchType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Segment;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.FuncionParametro;
import meta.entidad.comun.operacion.basica.TipoAgregacion;
import meta.entidad.comun.operacion.basica.VistaFuncion;

@EntityClass(base=Kleenean.TRUE, independent=Kleenean.FALSE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.FEMININE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.FALSE)
@EntityDetailView(enabled=Kleenean.FALSE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
@EntityTriggers(afterValue=Kleenean.TRUE)
public class VistaFuncionCol
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @NameProperty
    @PropertyField(hidden=Kleenean.TRUE, defaultCondition=DefaultCondition.UNCONDITIONALLY, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    @StringField(maxLength=200)
    public StringProperty nombre;
    @ForeignKey(onDelete=OnDeleteAction.CASCADE, onUpdate=OnUpdateAction.CASCADE)
    @ManyToOne(navigability=Navigability.BIDIRECTIONAL, view=MasterDetailView.TABLE_AND_DETAIL)
    @ColumnField(nullable=Kleenean.FALSE)
    @Allocation(maxDepth=2, maxRound=0)
    @Filter(owner=Kleenean.FALSE, segment=Kleenean.FALSE)
    public VistaFuncion vista;
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE, quickAdding=QuickAddingFilter.MISSING)
    @ColumnField(nullable=Kleenean.FALSE)
    @EntityReferenceDisplay(style=EntityReferenceStyle.NAME_AND_CHARACTER_KEY)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME)
    @PropertyField(required=Kleenean.TRUE, table=Kleenean.TRUE, create=Kleenean.TRUE, update=Kleenean.FALSE)
    public FuncionParametro columna;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.FALSE, defaultCondition=DefaultCondition.UNCONDITIONALLY, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    @StringField(maxLength=200)
    public StringProperty alias;
    @PropertyField(table=Kleenean.TRUE, create=Kleenean.TRUE)
    @StringField(maxLength=30)
    public StringProperty etiqueta;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(required=Kleenean.FALSE, table=Kleenean.TRUE, create=Kleenean.TRUE)
    @MasterSequence(masterField="vista", start=10, step=10, nextValueRule=NextValueRule.CEILING)
    public IntegerProperty secuencia;
    @Allocation(maxDepth=1, maxRound=0)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(required=Kleenean.FALSE, table=Kleenean.TRUE, create=Kleenean.TRUE)
    public TipoAgregacion agregacion;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @EntityReferenceDisplay(style=EntityReferenceStyle.NAME)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME)
    @PropertyField(required=Kleenean.FALSE, table=Kleenean.TRUE, create=Kleenean.TRUE)
    public VistaFuncionCol grupo;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(required=Kleenean.FALSE, table=Kleenean.TRUE, create=Kleenean.TRUE)
    public BooleanProperty orden;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(hidden=Kleenean.TRUE)
    public BooleanProperty visible;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(hidden=Kleenean.TRUE)
    public BooleanProperty graficable;
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(hidden=Kleenean.TRUE, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public IntegerProperty pixeles;
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(required=Kleenean.FALSE, table=Kleenean.TRUE, create=Kleenean.TRUE, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    @PropertyAggregation(function=AggregateFunction.CUSTOM_MADE, title="ancho disponible para columnas del detalle")
    public IntegerProperty anchoPorMil;
    protected Key uk_vista_funcion_col_0001;
    protected Check check101;
    protected Segment privadas;

    @Deprecated
    VistaFuncionCol() {
        this(null, null);
    }

    public VistaFuncionCol(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings("columna.funcion", "columna.parametro.tipoParametroDom", "columna.rangoAgregacion", "grupo.agregacion", "grupo.vista");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setOrderBy(this.vista, this.secuencia, this.id);
        this.setLocalizedLabel(ENGLISH, "view column");
        this.setLocalizedLabel(SPANISH, "columna de vista");
        this.setLocalizedShortLabel(ENGLISH, "column");
        this.setLocalizedShortLabel(SPANISH, "columna");
        this.setLocalizedCollectionLabel(ENGLISH, "View Columns");
        this.setLocalizedCollectionLabel(SPANISH, "Columnas de Vista");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Columns");
        this.setLocalizedCollectionShortLabel(SPANISH, "Columnas");
        this.setLocalizedDescription(ENGLISH, "column of view defined by the end user");
        this.setLocalizedDescription(SPANISH, "columna de vista definida por el usuario final");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.nombre.setDefaultValue(this.columna.nombreFuncionParametro);
        this.alias.setDefaultValue(this.columna.codigoFuncionParametro);
        this.secuencia.setMinValue(0);
        this.secuencia.setMaxValue(10000);
        this.agregacion.setInitialValue(this.columna.indice.isGreaterThan(0).and(this.columna.parametro.tipoParametroDom.isEqualTo(this.columna.parametro.tipoParametroDom.CODIGO)).then(this.agregacion.GRUPO));
        this.orden.setInitialValue(false);
        this.orden.setDefaultValue(false);
        this.visible.setInitialValue(true);
        this.visible.setDefaultValue(true);
        this.graficable.setInitialValue(true);
        this.graficable.setDefaultValue(true);
        this.pixeles.setDefaultValue(this.columna.parametro.pixeles);
        this.pixeles.setMinValue(0);
        this.pixeles.setMaxValue(960);
        this.anchoPorMil.setDefaultValue(this.columna.parametro.pixeles.times(1000).over(960).toInteger());
        this.anchoPorMil.setMinValue(0);
        this.anchoPorMil.setMaxValue(1000);
        this.nombre.setLocalizedLabel(ENGLISH, "view column name");
        this.nombre.setLocalizedLabel(SPANISH, "nombre de la columna de vista");
        this.nombre.setLocalizedShortLabel(ENGLISH, "name");
        this.nombre.setLocalizedShortLabel(SPANISH, "nombre");
        this.vista.setLocalizedLabel(ENGLISH, "view");
        this.vista.setLocalizedLabel(SPANISH, "vista");
        this.columna.setLocalizedLabel(ENGLISH, "column");
        this.columna.setLocalizedLabel(SPANISH, "columna");
        this.alias.setLocalizedLabel(ENGLISH, "alias");
        this.alias.setLocalizedLabel(SPANISH, "alias");
        this.etiqueta.setLocalizedLabel(ENGLISH, "label");
        this.etiqueta.setLocalizedLabel(SPANISH, "etiqueta");
        this.secuencia.setLocalizedLabel(ENGLISH, "sequence");
        this.secuencia.setLocalizedLabel(SPANISH, "secuencia");
        this.agregacion.setLocalizedLabel(ENGLISH, "aggregation");
        this.agregacion.setLocalizedLabel(SPANISH, "agregaci\u00f3n");
        this.grupo.setLocalizedLabel(ENGLISH, "group");
        this.grupo.setLocalizedLabel(SPANISH, "grupo");
        this.orden.setLocalizedLabel(ENGLISH, "order");
        this.orden.setLocalizedLabel(SPANISH, "orden");
        this.visible.setLocalizedLabel(ENGLISH, "visible");
        this.visible.setLocalizedLabel(SPANISH, "visible");
        this.graficable.setLocalizedLabel(ENGLISH, "chartable");
        this.graficable.setLocalizedLabel(SPANISH, "graficable");
        this.pixeles.setLocalizedLabel(ENGLISH, "width");
        this.pixeles.setLocalizedLabel(SPANISH, "ancho");
        this.pixeles.setLocalizedTooltip(ENGLISH, "width of the column in pixels");
        this.pixeles.setLocalizedTooltip(SPANISH, "anchura de la columna expresada en pixeles");
        this.anchoPorMil.setLocalizedLabel(ENGLISH, "width");
        this.anchoPorMil.setLocalizedLabel(SPANISH, "ancho");
        this.anchoPorMil.setLocalizedTooltip(ENGLISH, "column width as a fraction of 1000");
        this.anchoPorMil.setLocalizedTooltip(SPANISH, "anchura de la columna expresada como una fracci\u00f3n de 1000");
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        this.uk_vista_funcion_col_0001.setUnique(true);
        this.uk_vista_funcion_col_0001.newKeyField(this.vista, this.columna);
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
        this.linkForeignOwnerProperty(this.vista.propietario);
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.check101 = this.grupo.isNotNull().implies(this.grupo.isNotEqualTo(this));
        this.privadas = this.vista.publica.isFalse().and(this.vista.especial.isFalse());
        this.check101.setLocalizedLabel(ENGLISH, "check group");
        this.check101.setLocalizedLabel(SPANISH, "chequear grupo");
        this.check101.setLocalizedDescription(ENGLISH, "the group can not be the same column");
        this.check101.setLocalizedDescription(SPANISH, "el grupo no puede ser la misma columna");
        this.check101.setLocalizedErrorMessage(ENGLISH, "the group is the same column");
        this.check101.setLocalizedErrorMessage(SPANISH, "el grupo es la misma columna");
        this.privadas.setLocalizedErrorMessage(ENGLISH, "the view is public or special");
        this.privadas.setLocalizedErrorMessage(SPANISH, "la vista es p\u00fablica o especial");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.setInsertFilter(this.vista.privadas);
        this.setUpdateFilter(this.privadas);
        this.setDeleteFilter(this.privadas);
        this.columna.setSearchQueryFilter(this.columna.funcion.isEqualTo(this.vista.funcion).and(this.columna.parametro.pixeles.isGreaterThan(0)));
        this.agregacion.setSearchQueryFilter(this.agregacion.rangos.contains(this.columna.rangoAgregacion.numero));
        this.grupo.setSearchQueryFilter(this.grupo.agregacion.isEqualTo(this.grupo.agregacion.GRUPO).and(this.grupo.vista.isEqualTo(this.vista)));
    }
}

