/*
 * Decompiled with CFR 0.152.
 */
package meta.paquete.base;

import adalid.core.annotations.ProjectModuleDocGen;
import adalid.core.enums.Kleenean;
import adalid.core.predicates.IsEntityNameIncluded;
import meta.enumeracion.base.TipoModuloBase;
import meta.modulo.base.ModuloBase;
import meta.predicado.base.IsModuloConsultaDisplay;
import meta.predicado.base.IsModuloProcesamientoDisplay;
import meta.predicado.base.IsModuloRegistroDisplay;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

@ProjectModuleDocGen(classDiagram=Kleenean.FALSE)
public abstract class PaqueteBase
extends ModuloBase {
    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        String[] names = this.getLocallyDeclaredEntityClassSimpleNamesArray();
        IsEntityNameIncluded entityPredicate = new IsEntityNameIncluded();
        entityPredicate.setIncludedNames(names);
        Predicate pagePredicate = this.newPagePredicate(entityPredicate);
        this.setPagePredicate(pagePredicate);
    }

    @Override
    public void setAlias(String alias) {
        String apodo = StringUtils.isBlank((String)alias) ? this.getClass().getSimpleName() : StringUtils.capitalize((String)alias);
        TipoModuloBase tipo = this.getTipo();
        String prefijo = tipo == null ? null : StringUtils.capitalize((String)tipo.name().toLowerCase());
        String mote = tipo == null || StringUtils.startsWithIgnoreCase((String)apodo, (String)prefijo) ? apodo : prefijo + apodo;
        super.setAlias(mote);
    }

    private Predicate newPagePredicate(Predicate entityPredicate) {
        Object predicate;
        TipoModuloBase tipo = this.getTipo();
        if (tipo == null) {
            return null;
        }
        switch (tipo) {
            case CONSULTA: {
                predicate = new IsModuloConsultaDisplay(entityPredicate);
                break;
            }
            case PROCESAMIENTO: {
                predicate = new IsModuloProcesamientoDisplay(entityPredicate);
                break;
            }
            case REGISTRO: {
                predicate = new IsModuloRegistroDisplay(entityPredicate);
                break;
            }
            default: {
                predicate = null;
            }
        }
        return predicate;
    }
}

