/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.util.io;

import adalid.commons.properties.*;
import adalid.commons.util.*;
import adalid.util.*;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/**
 * @author Jorge Campins
 */
class SysCmdCommand {

    private static final Logger logger = Logger.getLogger(Utility.class);

    private static final String HOME = System.getProperty("user.home");

    private static final String WIN_CLI = "cmd.exe";

    private static final String WIN_CMD = "cmd.exe /c start ";

    String command;

    List<String> env;

    File dir;

    SysCmdCommand(String command, List<String> env, File dir) {
        this.command = command;
        this.env = env != null ? env : new ArrayList<>();
        this.dir = dir;
    }

    String[] command() {
        return StringUtils.split(command, ' ');
    }

    String[] env() {
        return env == null || env.isEmpty() ? null : env.toArray(new String[env.size()]);
    }

    SysCmdCommand forWindows() {
        logger.debug("cmd=" + command);
        logger.debug("dir=" + dir);
        if (StringUtils.endsWithIgnoreCase(command, ".bat") && !StringUtils.startsWithIgnoreCase(command, WIN_CLI)) {
            String comando = StringUtils.startsWithIgnoreCase(command, dir.getAbsolutePath()) ? command : dir.getAbsolutePath() + File.separator + command;
            String hyphens = StringUtils.repeat("-", comando.length());
            List<String> list = new ArrayList<>();
            list.add("@cd /d " + dir.getAbsolutePath());
            list.add("@echo " + hyphens);
            list.add("@echo " + comando);
            list.add("@echo " + hyphens);
            list.add("@call " + command);
            list.add("@exit");
            logger.trace("bat=" + list);
            File cf = new File(command);
            File pf = cf.isAbsolute() ? cf.getParentFile() : dir;
            String dp = delimitedPath(pf);
            String nx = cf.getName();
            File file = new File(HOME, "resources/scripts/windows/runtime/" + dp + nx);
            Path path = Paths.get(file.getPath());
            try {
                Files.createDirectories(path.getParent());
                Files.write(path, list, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                command = WIN_CMD + file.getName();
                dir = file.getParentFile();
            } catch (IOException ex) {
                logger.fatal(ex);
            }
        }
        logger.debug("cmd=" + command);
        logger.debug("dir=" + dir);
        return this;
    }

    String delimitedPath(File dir) {
        String root = PropertiesHandler.getRootFolder().getAbsolutePath();
        String path = dir.getAbsolutePath();
        if (path.startsWith(root)) {
            path = path.substring(root.length());
        }
        char separator = '$';
        String dp = FilUtils.delimitedPath(path, separator);
        return dp == null ? "" : dp + separator;
    }

}
