/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package meta.entidad.comun.configuracion.basica;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;

/**
 * @author Jorge Campins
 */
@EntityClass(catalog = Kleenean.TRUE, independent = Kleenean.FALSE, resourceType = ResourceType.CONFIGURATION, resourceGender = ResourceGender.MASCULINE)
@EntityCodeGen(bws = Kleenean.FALSE, fws = Kleenean.FALSE)
@EntitySelectOperation(enabled = Kleenean.TRUE, access = OperationAccess.PUBLIC, rowsLimit = 0)
@EntityInsertOperation(enabled = Kleenean.FALSE)
@EntityUpdateOperation(enabled = Kleenean.FALSE)
@EntityDeleteOperation(enabled = Kleenean.FALSE)
@EntityTableView(enabled = Kleenean.TRUE)
@EntityDetailView(enabled = Kleenean.TRUE)
@EntityTreeView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.FALSE)
public class FuncionParametro extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public FuncionParametro(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @PrimaryKey
    public LongProperty id;

    @VersionProperty
    public LongProperty version;

    @BusinessKey
//  @PropertyField(table = Kleenean.FALSE)
    @StringField(maxLength = 200)
    public StringProperty codigoFuncionParametro;

    @NameProperty
    @StringField(maxLength = 200)
    public StringProperty nombreFuncionParametro;

    @StringField(maxLength = 200)
    public StringProperty aliasFuncionParametro;

//  @StringField(maxLength = 200)
    public StringProperty columnaFuncionParametro;

    @StringField(maxLength = 200)
    public StringProperty detalleFuncionParametro;

    @DescriptionProperty
    public StringProperty descripcionFuncionParametro;

    @StringField(maxLength = 200)
    public StringProperty claseJavaFuncionParametro;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public TipoDatoPar tipoDatoPar;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty idListaValor;

    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty idClaseObjetoValor;

    @PropertyField(hidden = Kleenean.TRUE)
    @StringField(maxLength = 100)
    public StringProperty valorMinimo;

    @PropertyField(hidden = Kleenean.TRUE)
    @StringField(maxLength = 100)
    public StringProperty valorMaximo;

    @PropertyField(hidden = Kleenean.TRUE)
    @StringField(maxLength = 100)
    public StringProperty valorOmision;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty criterioBusqueda;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE)
    public BooleanProperty accesoRestringido;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty esParametroSinRastro;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty esParametroSegmento;

    @ColumnField(nullable = Kleenean.FALSE)
    public BooleanProperty esParametroHeredado;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE)
    public BooleanProperty esParametroVinculado;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.FALSE)
    public IntegerProperty indice;

    @ForeignKey(onDelete = OnDeleteAction.CASCADE, onUpdate = OnUpdateAction.CASCADE)
    @ManyToOne(navigability = Navigability.BIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.FALSE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public Funcion funcion;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.CASCADE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.FALSE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public Parametro parametro;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.FALSE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public TipoParametro tipoParametro;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @Allocation(maxDepth = 1, maxRound = 0)
    @PropertyField(hidden = Kleenean.TRUE)
    public TipoComparacion tipoComparacion;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public TipoValor tipoValor;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.FALSE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public RangoAgregacion rangoAgregacion;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.FALSE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public RangoComparacion rangoComparacion;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public Funcion funcionReferencia;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(table = Kleenean.TRUE)
    @Allocation(maxDepth = 1, maxRound = 0)
    public ClaseRecurso claseRecursoValor;

    protected Key ix_funcion_parametro_0001, ix_funcion_parametro_0002;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
//      setOrderBy(codigoFuncionParametro);
//      setSchema(ProyectoBase.getEsquemaEntidadesComunes());
        // <editor-fold defaultstate="collapsed" desc="localization of FuncionParametro's attributes">
        setLocalizedLabel(ENGLISH, "function parameter");
        setLocalizedLabel(SPANISH, "parámetro de función");
        setLocalizedShortLabel(ENGLISH, "parameter");
        setLocalizedShortLabel(SPANISH, "parámetro");
        setLocalizedCollectionLabel(ENGLISH, "Function Parameters");
        setLocalizedCollectionLabel(SPANISH, "Parámetros de Función");
        setLocalizedCollectionShortLabel(ENGLISH, "Parameters");
        setLocalizedCollectionShortLabel(SPANISH, "Parámetros");
        setLocalizedDescription(ENGLISH, "parameter of an application function");
        setLocalizedDescription(SPANISH, "parámetro de una función de la aplicación");
        // </editor-fold>
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        criterioBusqueda.setInitialValue(false);
        criterioBusqueda.setDefaultValue(false);
        accesoRestringido.setInitialValue(false);
        accesoRestringido.setDefaultValue(false);
        esParametroSinRastro.setInitialValue(false);
        esParametroSinRastro.setDefaultValue(false);
        esParametroSegmento.setInitialValue(false);
        esParametroSegmento.setDefaultValue(false);
        esParametroHeredado.setInitialValue(false);
        esParametroHeredado.setDefaultValue(false);
        esParametroVinculado.setInitialValue(false);
        esParametroVinculado.setDefaultValue(false);
        indice.setInitialValue(0);
        indice.setDefaultValue(0);
        tipoValor.setInitialValue(tipoValor.CONTINUO);
        tipoValor.setDefaultValue(tipoValor.CONTINUO);
        // <editor-fold defaultstate="collapsed" desc="localization of FuncionParametro's properties">
        codigoFuncionParametro.setLocalizedLabel(ENGLISH, "function parameter code");
        codigoFuncionParametro.setLocalizedLabel(SPANISH, "código del parámetro de función");
        codigoFuncionParametro.setLocalizedShortLabel(ENGLISH, "code");
        codigoFuncionParametro.setLocalizedShortLabel(SPANISH, "código");
        /**/
        nombreFuncionParametro.setLocalizedLabel(ENGLISH, "function parameter name");
        nombreFuncionParametro.setLocalizedLabel(SPANISH, "nombre del parámetro de función");
        nombreFuncionParametro.setLocalizedShortLabel(ENGLISH, "name");
        nombreFuncionParametro.setLocalizedShortLabel(SPANISH, "nombre");
        /**/
        aliasFuncionParametro.setLocalizedLabel(ENGLISH, "function parameter alias");
        aliasFuncionParametro.setLocalizedLabel(SPANISH, "alias función parámetro");
        aliasFuncionParametro.setLocalizedShortLabel(ENGLISH, "alias");
        aliasFuncionParametro.setLocalizedShortLabel(SPANISH, "alias");
        /**/
        columnaFuncionParametro.setLocalizedLabel(ENGLISH, "function parameter column");
        columnaFuncionParametro.setLocalizedLabel(SPANISH, "columna función parámetro");
        columnaFuncionParametro.setLocalizedShortLabel(ENGLISH, "column");
        columnaFuncionParametro.setLocalizedShortLabel(SPANISH, "columna");
        /**/
        detalleFuncionParametro.setLocalizedLabel(ENGLISH, "function parameter detail");
        detalleFuncionParametro.setLocalizedLabel(SPANISH, "detalle función parámetro");
        detalleFuncionParametro.setLocalizedShortLabel(ENGLISH, "detail");
        detalleFuncionParametro.setLocalizedShortLabel(SPANISH, "detalle");
        /**/
        descripcionFuncionParametro.setLocalizedLabel(ENGLISH, "function parameter description");
        descripcionFuncionParametro.setLocalizedLabel(SPANISH, "descripción del parámetro de función");
        descripcionFuncionParametro.setLocalizedShortLabel(ENGLISH, "description");
        descripcionFuncionParametro.setLocalizedShortLabel(SPANISH, "descripción");
        /**/
        tipoDatoPar.setLocalizedLabel(ENGLISH, "parameter data type");
        tipoDatoPar.setLocalizedLabel(SPANISH, "tipo de dato de parámetro");
        tipoDatoPar.setLocalizedShortLabel(ENGLISH, "data type");
        tipoDatoPar.setLocalizedShortLabel(SPANISH, "tipo de dato");
        /**/
        idListaValor.setLocalizedLabel(ENGLISH, "value list");
        idListaValor.setLocalizedLabel(SPANISH, "lista de valores");
        /**/
        idClaseObjetoValor.setLocalizedLabel(ENGLISH, "value object class");
        idClaseObjetoValor.setLocalizedLabel(SPANISH, "clase de objeto valor");
        /**/
        valorMinimo.setLocalizedLabel(ENGLISH, "minimum value");
        valorMinimo.setLocalizedLabel(SPANISH, "valor minimo");
        /**/
        valorMaximo.setLocalizedLabel(ENGLISH, "maximum value");
        valorMaximo.setLocalizedLabel(SPANISH, "valor maximo");
        /**/
        valorOmision.setLocalizedLabel(ENGLISH, "default value");
        valorOmision.setLocalizedLabel(SPANISH, "valor por omisión");
        /**/
        criterioBusqueda.setLocalizedLabel(ENGLISH, "search criterion");
        criterioBusqueda.setLocalizedLabel(SPANISH, "criterio de búsqueda");
        criterioBusqueda.setLocalizedShortLabel(ENGLISH, "criterion");
        criterioBusqueda.setLocalizedShortLabel(SPANISH, "criterio");
        /**/
        accesoRestringido.setLocalizedLabel(ENGLISH, "restricted access");
        accesoRestringido.setLocalizedLabel(SPANISH, "acceso restringido");
        accesoRestringido.setLocalizedShortLabel(ENGLISH, "restricted");
        accesoRestringido.setLocalizedShortLabel(SPANISH, "restringido");
        /**/
        esParametroSinRastro.setLocalizedLabel(ENGLISH, "parameter without trail");
        esParametroSinRastro.setLocalizedLabel(SPANISH, "parámetro sin rastro");
        esParametroSinRastro.setLocalizedShortLabel(ENGLISH, "without trail");
        esParametroSinRastro.setLocalizedShortLabel(SPANISH, "sin rastro");
        /**/
        esParametroSegmento.setLocalizedLabel(ENGLISH, "parameter segment");
        esParametroSegmento.setLocalizedLabel(SPANISH, "parámetro segmento");
        esParametroSegmento.setLocalizedShortLabel(ENGLISH, "segment");
        esParametroSegmento.setLocalizedShortLabel(SPANISH, "segmento");
        /**/
        esParametroHeredado.setLocalizedLabel(ENGLISH, "inherited parameter");
        esParametroHeredado.setLocalizedLabel(SPANISH, "parámetro heredado");
        esParametroHeredado.setLocalizedShortLabel(ENGLISH, "inherited");
        esParametroHeredado.setLocalizedShortLabel(SPANISH, "heredado");
        /**/
        esParametroVinculado.setLocalizedLabel(ENGLISH, "linked parameter");
        esParametroVinculado.setLocalizedLabel(SPANISH, "parámetro vinculado");
        esParametroVinculado.setLocalizedShortLabel(ENGLISH, "linked");
        esParametroVinculado.setLocalizedShortLabel(SPANISH, "vinculado");
        /**/
        indice.setLocalizedLabel(ENGLISH, "index");
        indice.setLocalizedLabel(SPANISH, "índice");
        indice.setLocalizedShortLabel(ENGLISH, "index");
        indice.setLocalizedShortLabel(SPANISH, "índice");
        /**/
        funcion.setLocalizedLabel(ENGLISH, "function");
        funcion.setLocalizedLabel(SPANISH, "función");
        /**/
        parametro.setLocalizedLabel(ENGLISH, "parameter");
        parametro.setLocalizedLabel(SPANISH, "parámetro");
        /**/
        tipoParametro.setLocalizedLabel(ENGLISH, "parameter type");
        tipoParametro.setLocalizedLabel(SPANISH, "tipo de parámetro");
        /**/
        tipoComparacion.setLocalizedLabel(ENGLISH, "comparison type");
        tipoComparacion.setLocalizedLabel(SPANISH, "tipo de comparación");
        /**/
        tipoValor.setLocalizedLabel(ENGLISH, "value type");
        tipoValor.setLocalizedLabel(SPANISH, "tipo de valor");
        /**/
        rangoAgregacion.setLocalizedLabel(ENGLISH, "aggregation operator range");
        rangoAgregacion.setLocalizedLabel(SPANISH, "rango de operadores de agregación");
        /**/
        rangoComparacion.setLocalizedLabel(ENGLISH, "comparison operator range");
        rangoComparacion.setLocalizedLabel(SPANISH, "rango de operadores de comparación");
        /**/
        funcionReferencia.setLocalizedLabel(ENGLISH, "reference function");
        funcionReferencia.setLocalizedLabel(SPANISH, "función de referencia");
        /**/
        claseRecursoValor.setLocalizedLabel(ENGLISH, "resource class");
        claseRecursoValor.setLocalizedLabel(SPANISH, "clase de recurso");
        claseRecursoValor.setLocalizedShortLabel(ENGLISH, "class");
        claseRecursoValor.setLocalizedShortLabel(SPANISH, "clase");
        // </editor-fold>
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        /**/
        ix_funcion_parametro_0001.setUnique(false);
        ix_funcion_parametro_0001.newKeyField(funcion, parametro);
        /**/
        ix_funcion_parametro_0002.setUnique(false);
        ix_funcion_parametro_0002.newKeyField(funcion, nombreFuncionParametro);
        /**/
    }

}
