/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import adalid.commons.util.StrUtils;
import adalid.commons.util.TimeUtils;

public class LongUtils {
    public static final long FALSE = 0L;
    public static final long TRUE = 1L;

    public static long valueOf(Boolean b) {
        return b == null || b == false ? 0L : 1L;
    }

    public static long valueOf(Integer i) {
        return i == null ? 0L : (long)i.intValue();
    }

    public static long valueOf(Integer i, long j) {
        return i == null ? j : (long)i.intValue();
    }

    public static long valueOf(Long l) {
        return l == null ? 0L : l;
    }

    public static long valueOf(Long l, long j) {
        return l == null ? j : l;
    }

    public static Long valueOf(String string, Long defaultValue) {
        if (string != null && !string.isEmpty() && string.matches("^-?\\d{1,19}$")) {
            try {
                return Long.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Long valueOf(Object o) {
        return o instanceof Long ? (Long)o : null;
    }

    public static long defaultIfNull(Long l, long defaultValue) {
        return l == null ? defaultValue : l;
    }

    public static long getNewId(String string) {
        String number = StrUtils.getLongNumericCode(string);
        return number == null ? LongUtils.getNewId() : Long.valueOf(number);
    }

    public static long getNewId() {
        long millis = TimeUtils.currentTimeMillis();
        long thread = Thread.currentThread().getId();
        return 100000L * millis + 10L * (thread % 10000L);
    }
}

