/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class MarkupUtils {
    public static final String AX = "<::";
    public static final String AY = ">:>";
    public static final String AZ = "::>";
    public static final String B1 = "<**";
    public static final String B2 = "**>";
    public static final String CX = "<;;";
    public static final String CY = ">;>";
    public static final String CZ = ";;>";
    public static final String G1 = "<++";
    public static final String G2 = "++>";
    public static final String I1 = "<//";
    public static final String I2 = "//>";
    public static final String M1 = "<~~";
    public static final String M2 = "~~>";
    public static final String S1 = "<--";
    public static final String S2 = "-->";
    public static final String U1 = "<__";
    public static final String U2 = "__>";
    public static final String H1T1 = "<!!";
    public static final String H1T2 = "!!>";
    public static final String H2T1 = "<@@";
    public static final String H2T2 = "@@>";
    public static final String H3T1 = "<##";
    public static final String H3T2 = "##>";
    public static final String H4T1 = "<$$";
    public static final String H4T2 = "$$>";
    public static final String H5T1 = "<%%";
    public static final String H5T2 = "%%>";
    public static final String H6T1 = "<^^";
    public static final String H6T2 = "^^>";
    public static final String BR = "\n";
    public static final String HT = "\t";
    public static final String ULLI = "\n\r\n\t";
    public static final String LILI = "\n\t";
    public static final String LIUL = "\n\r\n\b";
    public static final String NBSP = "\u00a0";
    public static final String LAQUO = "\u00ab";
    public static final String RAQUO = "\u00bb";
    public static final String FWLTS = "\uff1c";
    public static final String FWGTS = "\uff1e";
    public static final String BULLET = "\u2022";
    public static final String MIDDOT = "\u00b7";
    public static final String bb = "**";
    public static final String hh = "~~";
    public static final String ii = "//";
    public static final String ss = "--";
    public static final String uu = "__";
    public static final String ax = "<a href=\"";
    public static final String ay = "\">";
    public static final String az = "</a>";
    public static final String b1 = "<b>";
    public static final String b2 = "</b>";
    public static final String br = "<br>";
    public static final String cx = "<i class=\"";
    public static final String cy = "\">";
    public static final String cz = "</i>";
    public static final String g1 = "<img";
    public static final String g2 = "></img>";
    public static final String ht = StringUtils.repeat((String)"&nbsp;", (int)4);
    public static final String i1 = "<i>";
    public static final String i2 = "</i>";
    public static final String m1 = "<mark>";
    public static final String m2 = "</mark>";
    public static final String s1 = "<del>";
    public static final String s2 = "</del>";
    public static final String u1 = "<ins>";
    public static final String u2 = "</ins>";
    public static final String h1t1 = "<h1>";
    public static final String h1t2 = "</h1>";
    public static final String h2t1 = "<h2>";
    public static final String h2t2 = "</h2>";
    public static final String h3t1 = "<h3>";
    public static final String h3t2 = "</h3>";
    public static final String h4t1 = "<h4>";
    public static final String h4t2 = "</h4>";
    public static final String h5t1 = "<h5>";
    public static final String h5t2 = "</h5>";
    public static final String h6t1 = "<h6>";
    public static final String h6t2 = "</h6>";
    public static final String ulli = "<ul><li>";
    public static final String lili = "</li><li>";
    public static final String liul = "</li></ul>";
    public static final String nbsp = "&nbsp;";
    public static final String bullet = "&bull;";
    public static final String middot = "&middot;";
    private static final String request_context_path = "#{request.contextPath}";
    private static final String webapp_image_library = "#{request.contextPath}/resources/images/base";
    private static final String img_argument_pattern = "src=\"{0}\" width=\"{1}\" height=\"{2}\"";
    private static final char img_argument_begin = '[';
    private static final char img_argument_close = ']';
    private static final char img_argument_delim = '|';
    private static final String lorem_ipsum = MarkupUtils.m("Lorem ipsum dolor sit amet, consectetur adipiscing elit:");

    public static boolean isPseudoHTML(String string) {
        String[] tags;
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        for (String tag : tags = new String[]{ULLI, LIUL, AX, AY, AZ, B1, B2, CX, CY, CZ, G1, G2, I1, I2, M1, M2, S1, S2, U1, U2, H1T1, H1T2, H2T1, H2T2, H3T1, H3T2, H4T1, H4T2, H5T1, H5T2, H6T1, H6T2}) {
            if (!string.contains(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsHTML(String string) {
        return string != null && string.matches("(?s)([^<]*<\\w+(\\s[^>]*)?>)+.*");
    }

    public static String img(String name, int w, int h) {
        return MarkupUtils.img(webapp_image_library, name, w, h);
    }

    public static String img(String path, String name, int w, int h) {
        String prefix = "<++[";
        String suffix = "]++>";
        String src = StringUtils.trimToEmpty((String)path) + "/" + name;
        Object[] arguments = new String[]{src, "" + w, "" + h};
        return "<++[" + StringUtils.join((Object[])arguments, (char)'|') + "]++>";
    }

    private static String img(String html) {
        String prefix = "<img[";
        String suffix = "]></img>";
        String[] substrings = StringUtils.substringsBetween((String)html, (String)"<img[", (String)"]></img>");
        if (substrings != null) {
            for (String substring : substrings) {
                Object[] arguments = StringUtils.split((String)substring, (char)'|');
                if (arguments == null || arguments.length != 3) continue;
                String attributes = MessageFormat.format(img_argument_pattern, arguments);
                html = StringUtils.replaceOnce((String)html, (String)("<img[" + substring + "]></img>"), (String)("<img " + attributes + g2));
            }
        }
        return html;
    }

    public static String a(String href, String text) {
        return AX + href + AY + text + AZ;
    }

    public static String b(String string) {
        return MarkupUtils.x(B1, B2, string);
    }

    public static String b(String separator, String ... strings) {
        return MarkupUtils.x(B1, B2, separator, strings);
    }

    public static String ic(String clazz) {
        return MarkupUtils.ic(clazz, null);
    }

    public static String ic(String clazz, String text) {
        return CX + clazz + CY + StringUtils.trimToEmpty((String)text) + CZ;
    }

    public static String i(String string) {
        return MarkupUtils.x(I1, I2, string);
    }

    public static String i(String separator, String ... strings) {
        return MarkupUtils.x(I1, I2, separator, strings);
    }

    public static String m(String string) {
        return MarkupUtils.x(M1, M2, string);
    }

    public static String m(String separator, String ... strings) {
        return MarkupUtils.x(M1, M2, separator, strings);
    }

    public static String s(String string) {
        return MarkupUtils.x(S1, S2, string);
    }

    public static String s(String separator, String ... strings) {
        return MarkupUtils.x(S1, S2, separator, strings);
    }

    public static String u(String string) {
        return MarkupUtils.x(U1, U2, string);
    }

    public static String u(String separator, String ... strings) {
        return MarkupUtils.x(U1, U2, separator, strings);
    }

    public static String ul(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        Object ul = "";
        Object li = ULLI;
        for (String string : strings) {
            if (string.startsWith(ULLI)) {
                li = ((String)li).equals(ULLI) ? ULLI + lorem_ipsum : "";
            }
            ul = (String)ul + (String)li + string;
            li = LILI;
        }
        return (String)ul + LIUL;
    }

    public static String h1(String string) {
        return MarkupUtils.x(H1T1, H1T2, string);
    }

    public static String h2(String string) {
        return MarkupUtils.x(H2T1, H2T2, string);
    }

    public static String h3(String string) {
        return MarkupUtils.x(H3T1, H3T2, string);
    }

    public static String h4(String string) {
        return MarkupUtils.x(H4T1, H4T2, string);
    }

    public static String h5(String string) {
        return MarkupUtils.x(H5T1, H5T2, string);
    }

    public static String h6(String string) {
        return MarkupUtils.x(H6T1, H6T2, string);
    }

    private static String x(String open, String close, String string) {
        return StringUtils.isBlank((String)string) ? "" : open + string + close;
    }

    private static String x(String open, String close, String separator, String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        String sep = StringUtils.defaultIfBlank((String)separator, (String)MIDDOT);
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (String string : strings) {
            if (StringUtils.isBlank((String)string)) continue;
            list.add((CallSite)((Object)(open + string + close)));
        }
        return StringUtils.join(list, (String)sep);
    }

    public static String getXhtmlFormattedString(String string) {
        String br1 = br;
        String br2 = "<br/>";
        String html = MarkupUtils.getHtmlFormattedString(string);
        return StringUtils.replace((String)html, (String)br, (String)"<br/>");
    }

    public static String getHtmlFormattedString(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        String html = StringUtils.removeEnd((String)string, (String)"\b\u00a0");
        if (MarkupUtils.isPseudoHTML(html)) {
            html = MarkupUtils.htmlFormattedString(html);
        } else {
            html = html.replace("<<", LAQUO);
            html = html.replace(">>", RAQUO);
            html = html.replace(FWLTS, "&lt;");
            html = html.replace(FWGTS, "&gt;");
        }
        return html;
    }

    private static String htmlFormattedString(String string) {
        String html = StringEscapeUtils.escapeHtml((String)string);
        String[] bullets = new String[]{"*", "-", bullet, middot};
        String seudoULLI = StringEscapeUtils.escapeHtml((String)ULLI);
        String seudoLILI = StringEscapeUtils.escapeHtml((String)LILI);
        for (String b : bullets) {
            html = StringUtils.replace((String)html, (String)(seudoULLI + b + HT), (String)seudoULLI);
            html = StringUtils.replace((String)html, (String)(seudoULLI + b), (String)seudoULLI);
        }
        for (String b : bullets) {
            html = StringUtils.replace((String)html, (String)(seudoLILI + b + HT), (String)seudoLILI);
            html = StringUtils.replace((String)html, (String)(seudoLILI + b), (String)seudoLILI);
        }
        String[] TAGS = new String[]{ULLI, LILI, LIUL, AX, AY, AZ, B1, B2, CX, CY, CZ, G1, G2, I1, I2, M1, M2, S1, S2, U1, U2, H1T1, H1T2, H2T1, H2T2, H3T1, H3T2, H4T1, H4T2, H5T1, H5T2, H6T1, H6T2, BR, HT};
        String[] tags = new String[]{ulli, lili, liul, ax, "\">", az, b1, b2, cx, "\">", "</i>", g1, g2, i1, "</i>", m1, m2, s1, s2, u1, u2, h1t1, h1t2, h2t1, h2t2, h3t1, h3t2, h4t1, h4t2, h5t1, h5t2, h6t1, h6t2, br, ht};
        for (int i = 0; i < tags.length; ++i) {
            html = StringUtils.replace((String)html, (String)StringEscapeUtils.escapeHtml((String)TAGS[i]), (String)tags[i]);
        }
        html = MarkupUtils.img(html);
        html = html.replace("&lt;&lt;", LAQUO);
        html = html.replace("&gt;&gt;", RAQUO);
        html = html.replace(StringEscapeUtils.escapeHtml((String)FWLTS), "&lt;");
        html = html.replace(StringEscapeUtils.escapeHtml((String)FWGTS), "&gt;");
        html = html.replaceAll("\\p{Cntrl}", "");
        html = html.trim();
        return html;
    }

    public static String getCreoleFormattedString(String string) {
        String[] NCPT;
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        String creole = StringUtils.removeEnd((String)string, (String)"\b\u00a0");
        String[] BMUC = new String[]{"<**<~~", "~~>**>", "<~~<**", "**>~~>", "<~~<__", "__>~~>", "<__<~~", "~~>__>"};
        String[] UBBU = new String[]{"<__<**", "**>__>", "<__<**", "**>__>", "<__<**", "**>__>", "<__<**", "**>__>"};
        for (int i = 0; i < UBBU.length; ++i) {
            creole = StringUtils.replace((String)creole, (String)BMUC[i], (String)UBBU[i]);
        }
        creole = creole.replaceAll("<::.*>:>", "");
        creole = creole.replaceAll("<;;.*>;>", "");
        for (String tag : NCPT = new String[]{AZ, CZ, G1, G2, H1T1, H1T2, H2T1, H2T2, H3T1, H3T2, H4T1, H4T2, H5T1, H5T2, H6T1, H6T2}) {
            creole = StringUtils.remove((String)creole, (String)tag);
        }
        String ub = "__**";
        String bu = "**__";
        String[] TAGS = new String[]{B1, B2, I1, I2, M1, M2, S1, S2, U1, U2};
        String[] tags = new String[]{bb, bb, ii, ii, "__**", "**__", ss, ss, uu, uu};
        for (int i = 0; i < tags.length; ++i) {
            creole = StringUtils.replace((String)creole, (String)TAGS[i], (String)tags[i]);
        }
        creole = creole.replace("<<", LAQUO);
        creole = creole.replace(">>", RAQUO);
        creole = creole.replace(FWLTS, "<");
        creole = creole.replace(FWGTS, ">");
        creole = creole.replace(" + ", " <&plus> ");
        creole = creole.replace(" - ", " <&minus> ");
        creole = creole.trim();
        return creole;
    }

    public static String getPlainTextString(String string) {
        return MarkupUtils.getTextFormattedString(string);
    }

    public static String getTextFormattedString(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        String text = StringUtils.removeEnd((String)string, (String)"\b\u00a0");
        if (MarkupUtils.isPseudoHTML(string)) {
            String[] TAGS;
            text = text.replaceAll("<::.*>:>", "");
            text = text.replaceAll("<;;.*>;>", "");
            for (String tag : TAGS = new String[]{AZ, B1, B2, CZ, G1, G2, I1, I2, M1, M2, S1, S2, U1, U2, H1T1, H1T2, H2T1, H2T2, H3T1, H3T2, H4T1, H4T2, H5T1, H5T2, H6T1, H6T2}) {
                text = StringUtils.remove((String)text, (String)tag);
            }
        }
        text = text.replace("<<", LAQUO);
        text = text.replace(">>", RAQUO);
        text = text.replace(FWLTS, "<");
        text = text.replace(FWGTS, ">");
        text = text.trim();
        return text;
    }
}

