/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.velocity;

import adalid.commons.bundles.Bundle;
import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.ArrUtils;
import adalid.commons.util.FilUtils;
import adalid.commons.util.StrUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.commons.util.XmlUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class VelocityEngineer {
    private static final boolean V17 = true;
    private static final Logger logger = Logger.getLogger(VelocityEngineer.class);
    private static final String FILE_RESOURCE_LOADER_PATH = "file.resource.loader.path";
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String LF = "\n";
    private static final String CRLF = "\r\n";
    private static final String LF_REGEX = "(?<!\\r)\\n";
    private static final String CRLF_REGEX = "\\r\\n";
    private static final String VELOCITY_FILE_KEY = "velocity.properties.file";
    private static final String VELOCITY_SUP_FILE_KEY = "velocity.supplementary.properties.file";
    private static final String VELOCIMACRO_LIBRARY = "velocimacro.library";
    private static final String VELOCITY_TEMPLATE_ENCODING = "velocity.template.encoding";
    private static final String VELOCITY_DOCUMENT_ENCODING = "velocity.document.encoding";
    private static final String VELOCITY_DOCUMENT_EOL = "velocity.document.eol";
    private static final String VELOCITY_TEMPLATE_DEFAULT_ENCODING;
    private static final String VELOCITY_DOCUMENT_DEFAULT_ENCODING;
    private static String[] fileResourceLoaderPathArray;
    private static final Properties supplementaryProperties;
    private static final boolean handwriting = false;
    private static final String[] pretty_xml_extensions;

    private static void init() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            File[] velocityFolders = PropertiesHandler.getVelocityFolders();
            if (velocityFolders != null && velocityFolders.length > 0) {
                for (File velocityFolder : velocityFolders) {
                    list.add(velocityFolder.getPath());
                }
            }
            File file = PropertiesHandler.getVelocityPropertiesFile();
            Properties properties = PropertiesHandler.loadProperties(file);
            if (list.isEmpty()) {
                file = new File(USER_DIR);
                list.add(file.getPath());
            }
            VelocityEngineer.setFileResourceLoaderPath(list);
            String value = StringUtils.join(list, (String)", ");
            properties.setProperty(FILE_RESOURCE_LOADER_PATH, value);
            String libraries = VelocityEngineer.velocimacroLibraries(list);
            if (StringUtils.isNotBlank((String)libraries)) {
                properties.setProperty(VELOCIMACRO_LIBRARY, libraries);
            }
            logger.info((Object)("velocity.properties.file=" + file.getCanonicalPath()));
            logger.info((Object)("velocity.supplementary.properties.file=" + PropertiesHandler.getVelocitySupplementaryPropertiesFile().getCanonicalPath()));
            Velocity.init((Properties)properties);
        }
        catch (IOException ex) {
            logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
        }
    }

    private static void setFileResourceLoaderPath(List<String> list) {
        fileResourceLoaderPathArray = list.toArray((String[])ArrUtils.arrayOf(String.class));
        logger.trace((Object)"file.resource.loader.path = ");
        for (String dir : fileResourceLoaderPathArray) {
            logger.trace((Object)("\t" + dir));
        }
    }

    private static String velocimacroLibraries(List<String> list) {
        FileFilter macrosFileFilter = FilUtils.nameEndsWithFilter(".vm");
        LinkedHashSet<CallSite> libraries = new LinkedHashSet<CallSite>();
        String macros = "macros";
        for (String path : list) {
            File[] files;
            File folder = new File(path + FILE_SEPARATOR + macros);
            if (!FilUtils.isVisibleDirectory(folder)) continue;
            for (File file : files = folder.listFiles(macrosFileFilter)) {
                if (!FilUtils.isVisibleFile(file)) continue;
                libraries.add((CallSite)((Object)(macros + "/" + file.getName())));
            }
        }
        String value = StringUtils.join(libraries, (String)", ");
        logger.trace((Object)("velocimacro.library = " + value));
        return value;
    }

    public static String[] getFileResourceLoaderPathArray() {
        return fileResourceLoaderPathArray;
    }

    public static void check() {
    }

    public static StringWriter merge(VelocityContext context, String tempname) throws Exception {
        return VelocityEngineer.merge(context, tempname, VelocityEngineer.getTemplateEncoding(tempname));
    }

    public static StringWriter merge(VelocityContext context, String tempname, String encoding) throws Exception {
        encoding = StringUtils.defaultIfBlank((String)encoding, (String)VelocityEngineer.getTemplateEncoding(tempname));
        Template template = Velocity.getTemplate((String)tempname, (String)encoding);
        StringWriter sw = new StringWriter();
        template.merge((Context)context, (Writer)sw);
        return sw;
    }

    public static void write(VelocityContext context, String tempname, String filename) throws Exception {
        VelocityEngineer.write(context, tempname, filename, VelocityEngineer.getTemplateEncoding(tempname), null);
    }

    public static void write(VelocityContext context, String tempname, String filename, String charset1, String charset2) throws Exception {
        VelocityEngineer.write(context, tempname, filename, charset1, charset2, false);
    }

    public static void write(VelocityContext context, String tempname, String filename, String charset1, String charset2, boolean pretty) throws Exception {
        charset1 = StringUtils.defaultIfBlank((String)charset1, (String)VelocityEngineer.getTemplateEncoding(tempname));
        charset2 = StringUtils.defaultIfBlank((String)charset2, (String)VelocityEngineer.getDocumentEncoding(filename));
        StringWriter sw = VelocityEngineer.merge(context, tempname, charset1);
        VelocityEngineer.write(sw, filename, charset2, pretty);
    }

    public static void write(StringWriter sw, String filename, String charset2, boolean pretty) throws Exception {
        if (sw == null) {
            return;
        }
        charset2 = StringUtils.defaultIfBlank((String)charset2, (String)VelocityEngineer.getDocumentEncoding(filename));
        try {
            Path path = Paths.get(filename, new String[0]);
            Charset charset = Charset.forName(charset2);
            OpenOption[] options = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
            try (OutputStreamWriter fileWriter = new OutputStreamWriter(Files.newOutputStream(path, options), charset);
                 BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
                bufferedWriter.write(VelocityEngineer.stringOf(sw, filename, pretty));
                bufferedWriter.flush();
            }
        }
        catch (IllegalCharsetNameException | UnmappableCharacterException | UnsupportedCharsetException ex) {
            FileUtils.deleteQuietly((File)new File(filename));
            throw new Exception("charset " + charset2 + " -> " + ex.getClass().getSimpleName() + ": " + ThrowableUtils.getString(ex));
        }
        catch (IOException | IllegalArgumentException ex) {
            FileUtils.deleteQuietly((File)new File(filename));
            throw new Exception(ex.getClass().getSimpleName() + ": " + ThrowableUtils.getString(ex));
        }
    }

    private static String stringOf(StringWriter sw, String filename, boolean pretty) {
        String eol;
        String string = sw.toString();
        String lcname = filename.toLowerCase();
        String extension = StringUtils.substringAfterLast((String)lcname, (String)".");
        boolean extended = StringUtils.isNotBlank((String)extension);
        if (extended) {
            if (extension.equals("bat")) {
                return string.replaceAll(LF_REGEX, CRLF);
            }
            if (extension.equals("sh")) {
                return string.replaceAll(CRLF_REGEX, LF);
            }
            if (pretty && ArrayUtils.contains((Object[])pretty_xml_extensions, (Object)extension)) {
                string = XmlUtils.toPrettyString(string);
            }
        }
        if ((eol = VelocityEngineer.getDocumentEndOfLine(filename)).equals(CRLF)) {
            return string.replaceAll(LF_REGEX, CRLF);
        }
        if (eol.equals(LF)) {
            return string.replaceAll(CRLF_REGEX, LF);
        }
        return string;
    }

    private static String getTemplateEncoding(String filename) {
        String extension = StringUtils.substringAfterLast((String)filename, (String)".");
        if (StringUtils.isBlank((String)extension)) {
            return VELOCITY_TEMPLATE_DEFAULT_ENCODING;
        }
        String key = "velocity.template.encoding." + extension.toLowerCase();
        String property = supplementaryProperties.getProperty(key);
        return StringUtils.isBlank((String)property) ? VELOCITY_TEMPLATE_DEFAULT_ENCODING : property;
    }

    private static String getDocumentEncoding(String filename) {
        String extension = StringUtils.substringAfterLast((String)filename, (String)".");
        if (StringUtils.isBlank((String)extension)) {
            return VELOCITY_DOCUMENT_DEFAULT_ENCODING;
        }
        String key = "velocity.document.encoding." + extension.toLowerCase();
        String property = supplementaryProperties.getProperty(key);
        return StringUtils.isBlank((String)property) ? VELOCITY_DOCUMENT_DEFAULT_ENCODING : property;
    }

    private static String getDocumentEndOfLine(String filename) {
        String extension = StringUtils.substringAfterLast((String)filename, (String)".");
        if (StringUtils.isBlank((String)extension)) {
            return LINE_SEPARATOR;
        }
        String key = "velocity.document.eol." + extension.toLowerCase();
        String property = supplementaryProperties.getProperty(key);
        return StringUtils.isBlank((String)property) ? LINE_SEPARATOR : (property.equalsIgnoreCase("CRLF") ? CRLF : (property.equalsIgnoreCase("LF") ? LF : LINE_SEPARATOR));
    }

    static {
        VelocityEngineer.init();
        supplementaryProperties = PropertiesHandler.getVelocitySupplementaryProperties();
        Object property = Velocity.getProperty((String)"input.encoding");
        String str = StrUtils.getString(property);
        String defaultStr = Bundle.getString(VELOCITY_TEMPLATE_ENCODING);
        VELOCITY_TEMPLATE_DEFAULT_ENCODING = StringUtils.defaultIfBlank((String)str, (String)defaultStr);
        property = Velocity.getProperty((String)"output.encoding");
        str = StrUtils.getString(property);
        defaultStr = Bundle.getString(VELOCITY_DOCUMENT_ENCODING);
        VELOCITY_DOCUMENT_DEFAULT_ENCODING = StringUtils.defaultIfBlank((String)str, (String)defaultStr);
        pretty_xml_extensions = new String[]{"xml", "xhtml", "jrxml", "jrtx"};
    }
}

