/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class TemporalAddend
implements Comparable {
    static final char OTHER_YEARS_1 = 'y';
    static final char OTHER_YEARS_2 = 'A';
    static final char OTHER_YEARS_3 = 'a';
    static final char OTHER_DAYS_1 = 'd';
    static final char OTHER_HOURS_1 = 'H';
    static final char OTHER_SECONDS_1 = 'S';
    public static final char YEARS = 'Y';
    public static final char MONTHS = 'M';
    public static final char DAYS = 'D';
    public static final char HOURS = 'h';
    public static final char MINUTES = 'm';
    public static final char SECONDS = 's';
    public static final char DEFAULT_UNIT = 'D';
    public static final char[] DATE_UNITS = new char[]{'Y', 'M', 'D'};
    public static final char[] TIME_UNITS = new char[]{'h', 'm', 's'};
    public static final char[] DATE_TIME_UNITS = new char[]{'Y', 'M', 'D', 'h', 'm', 's'};
    public static final TemporalAddend MIN_VALUE = new TemporalAddend(-1000, 'Y');
    public static final TemporalAddend MAX_VALUE = new TemporalAddend(1000, 'Y');
    public static final TemporalAddend MIN_INT_VALUE = new TemporalAddend(-60, 'Y');
    public static final TemporalAddend MAX_INT_VALUE = new TemporalAddend(60, 'Y');
    private final int quantity;
    private final char unitCode;
    private final TemporalAddend minValue;
    private final TemporalAddend maxValue;
    private final boolean badValue;

    public static TemporalAddend temporalAddendValueOf(String string) {
        return TemporalAddend.temporalAddendValueOf(string, DATE_TIME_UNITS, 'D', MIN_VALUE, MAX_VALUE);
    }

    public static TemporalAddend temporalAddendValueOf(String string, char[] validUnits, char defaultUnit) {
        return TemporalAddend.temporalAddendValueOf(string, validUnits, defaultUnit, MIN_VALUE, MAX_VALUE);
    }

    public static TemporalAddend temporalAddendValueOf(String string, char[] validUnits, char defaultUnit, String min, String max) {
        TemporalAddend minimum = TemporalAddend.temporalAddendValueOf(min, validUnits, defaultUnit, MIN_VALUE, MAX_VALUE);
        TemporalAddend maximum = TemporalAddend.temporalAddendValueOf(max, validUnits, defaultUnit, MIN_VALUE, MAX_VALUE);
        return TemporalAddend.temporalAddendValueOf(string, validUnits, defaultUnit, minimum, maximum);
    }

    public static TemporalAddend temporalAddendValueOf(String string, char[] validUnits, char defaultUnit, TemporalAddend min, TemporalAddend max) {
        String chopped;
        int end;
        char unit;
        String trimmed = StringUtils.trimToNull((String)string);
        if (trimmed == null) {
            return null;
        }
        if (validUnits == null) {
            validUnits = DATE_TIME_UNITS;
        } else if (!TemporalAddend.valid(validUnits = TemporalAddend.fix(validUnits))) {
            validUnits = DATE_TIME_UNITS;
        }
        defaultUnit = TemporalAddend.fix(defaultUnit);
        if (!TemporalAddend.valid(defaultUnit)) {
            defaultUnit = (char)68;
        }
        if (min == null) {
            min = MIN_VALUE;
        }
        if (max == null) {
            max = MAX_VALUE;
        }
        if (min.compareTo(max) > 0) {
            min = MIN_VALUE;
            max = MAX_VALUE;
        }
        if (Character.isDigit(unit = TemporalAddend.fix(trimmed.charAt(end = trimmed.length() - 1)))) {
            chopped = trimmed;
            unit = defaultUnit;
        } else if (end > 0 && ArrayUtils.contains((char[])validUnits, (char)unit)) {
            chopped = trimmed.substring(0, end);
        } else {
            return null;
        }
        try {
            Integer number = Integer.valueOf(chopped);
            return new TemporalAddend(number, unit, min, max);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static char[] fix(char[] units) {
        if (units == null || units.length == 0) {
            return null;
        }
        for (int i = 0; i < units.length; ++i) {
            units[i] = TemporalAddend.fix(units[i]);
        }
        return units;
    }

    private static char fix(char unit) {
        switch (unit) {
            case 'S': {
                return 's';
            }
            case 'H': {
                return 'h';
            }
            case 'd': {
                return 'D';
            }
            case 'A': 
            case 'a': 
            case 'y': {
                return 'Y';
            }
        }
        return unit;
    }

    private static boolean valid(char[] units) {
        if (units == null || units.length == 0) {
            return false;
        }
        for (int i = 0; i < units.length; ++i) {
            if (TemporalAddend.valid(units[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean valid(char unit) {
        return ArrayUtils.contains((char[])DATE_TIME_UNITS, (char)unit);
    }

    private TemporalAddend(int quantity, char unitCode) {
        this(quantity, unitCode, null, null);
    }

    private TemporalAddend(int quantity, char unitCode, TemporalAddend minValue, TemporalAddend maxValue) {
        this.quantity = quantity;
        this.unitCode = unitCode;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.badValue = minValue != null && maxValue != null && (this.compareTo(minValue) < 0 || this.compareTo(maxValue) > 0);
    }

    public int getQuantity() {
        return this.quantity;
    }

    public char getUnitCode() {
        return this.unitCode;
    }

    public String getUnitName() {
        switch (this.unitCode) {
            case 's': {
                return "seconds";
            }
            case 'm': {
                return "minutes";
            }
            case 'h': {
                return "hours";
            }
            case 'D': {
                return "days";
            }
            case 'M': {
                return "months";
            }
            case 'Y': {
                return "years";
            }
        }
        return null;
    }

    public TemporalAddend getMinValue() {
        return this.minValue;
    }

    public TemporalAddend getMaxValue() {
        return this.maxValue;
    }

    public boolean isBadValue() {
        return this.badValue;
    }

    public long toSeconds() {
        return (long)this.seconds();
    }

    private double seconds() {
        switch (this.unitCode) {
            case 's': {
                return this.quantity;
            }
            case 'm': {
                return this.quantity * 60;
            }
            case 'h': {
                return this.quantity * 60 * 60;
            }
            case 'D': {
                return this.quantity * 60 * 60 * 24;
            }
            case 'M': {
                return (double)(this.quantity * 60 * 60 * 24) * 30.4375;
            }
            case 'Y': {
                return (double)(this.quantity * 60 * 60 * 24) * 365.25;
            }
        }
        return 0.0;
    }

    public long toMinutes() {
        return (long)this.minutes();
    }

    private double minutes() {
        switch (this.unitCode) {
            case 's': {
                return (double)this.quantity / 60.0;
            }
            case 'm': {
                return this.quantity;
            }
            case 'h': {
                return this.quantity * 60;
            }
            case 'D': {
                return this.quantity * 60 * 24;
            }
            case 'M': {
                return (double)(this.quantity * 60 * 24) * 30.4375;
            }
            case 'Y': {
                return (double)(this.quantity * 60 * 24) * 365.25;
            }
        }
        return 0.0;
    }

    public long toHours() {
        return (long)this.hours();
    }

    private double hours() {
        switch (this.unitCode) {
            case 's': {
                return (double)this.quantity / 60.0 / 60.0;
            }
            case 'm': {
                return (double)this.quantity / 60.0;
            }
            case 'h': {
                return this.quantity;
            }
            case 'D': {
                return this.quantity * 24;
            }
            case 'M': {
                return (double)(this.quantity * 24) * 30.4375;
            }
            case 'Y': {
                return (double)(this.quantity * 24) * 365.25;
            }
        }
        return 0.0;
    }

    public long toDays() {
        return (long)this.days();
    }

    private double days() {
        switch (this.unitCode) {
            case 's': {
                return (double)this.quantity / 24.0 / 60.0 / 60.0;
            }
            case 'm': {
                return (double)this.quantity / 24.0 / 60.0;
            }
            case 'h': {
                return (double)this.quantity / 24.0;
            }
            case 'D': {
                return this.quantity;
            }
            case 'M': {
                return (double)this.quantity * 30.4375;
            }
            case 'Y': {
                return (double)this.quantity * 365.25;
            }
        }
        return 0.0;
    }

    public long toMonths() {
        return (long)this.months();
    }

    private double months() {
        switch (this.unitCode) {
            case 's': {
                return (double)this.quantity / 30.4375 / 24.0 / 60.0 / 60.0;
            }
            case 'm': {
                return (double)this.quantity / 30.4375 / 24.0 / 60.0;
            }
            case 'h': {
                return (double)this.quantity / 30.4375 / 24.0;
            }
            case 'D': {
                return (double)this.quantity / 30.4375;
            }
            case 'M': {
                return this.quantity;
            }
            case 'Y': {
                return this.quantity * 12;
            }
        }
        return 0.0;
    }

    public long toYears() {
        return (long)this.years();
    }

    private double years() {
        switch (this.unitCode) {
            case 's': {
                return (double)this.quantity / 365.25 / 24.0 / 60.0 / 60.0;
            }
            case 'm': {
                return (double)this.quantity / 365.25 / 24.0 / 60.0;
            }
            case 'h': {
                return (double)this.quantity / 365.25 / 24.0;
            }
            case 'D': {
                return (double)this.quantity / 365.25;
            }
            case 'M': {
                return (double)this.quantity / 12.0;
            }
            case 'Y': {
                return this.quantity;
            }
        }
        return 0.0;
    }

    public int compareTo(Object object) {
        if (object instanceof TemporalAddend) {
            TemporalAddend that = (TemporalAddend)object;
            return this.compareTo(that);
        }
        throw new IllegalArgumentException();
    }

    private int compareTo(TemporalAddend that) {
        Double seconds = this.seconds();
        return seconds.compareTo(that.seconds());
    }

    public String toString() {
        return "" + this.quantity + this.unitCode;
    }
}

