/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.comparators;

import adalid.core.Display;
import adalid.core.Project;
import adalid.core.XS2;
import adalid.core.interfaces.Entity;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ByDisplayEntityDeclaringFieldName
implements Comparator<Display> {
    private final Map<String, String> _map = new LinkedHashMap<String, String>();
    private static final String HIGH = "\uffff";

    public static ByDisplayEntityDeclaringFieldName getInstance(Project module) {
        return new ByDisplayEntityDeclaringFieldName(module);
    }

    private ByDisplayEntityDeclaringFieldName(Project module) {
        if (module != null) {
            for (Field field : XS2.getFields(module.getClass(), Project.class)) {
                if (!Entity.class.isAssignableFrom(field.getType())) continue;
                String fieldType = field.getType().getSimpleName();
                String fieldName = field.getName();
                this._map.put(fieldType, fieldName);
            }
        }
    }

    @Override
    public int compare(Display o1, Display o2) {
        if (o1 != null && o2 != null) {
            String n1 = o1.getName();
            String n2 = o2.getName();
            if (!this._map.isEmpty()) {
                Entity e1 = o1.getEntity();
                Entity e2 = o2.getEntity();
                String f1 = e1 == null ? null : this._map.get(e1.getDataClass().getSimpleName());
                String f2 = e2 == null ? null : this._map.get(e2.getDataClass().getSimpleName());
                String x1 = f1 == null ? HIGH : f1;
                String x2 = f2 == null ? HIGH : f2;
                return x1.equals(x2) ? n1.compareTo(n2) : x1.compareTo(x2);
            }
            return n1.compareTo(n2);
        }
        return 0;
    }
}

