/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.setup;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class ZipUtils {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final int BUFFER_SIZE = 1024;

    public static byte[] deflate(String string) throws IOException {
        return StringUtils.isBlank((String)string) ? null : ZipUtils.deflate(string.getBytes(CHARSET));
    }

    public static byte[] deflate(byte[] inputBytes) throws IOException {
        byte[] outputBytes;
        if (inputBytes == null || inputBytes.length == 0) {
            return null;
        }
        Deflater deflater = new Deflater();
        deflater.setInput(inputBytes);
        deflater.finish();
        int outputLength = 0;
        byte[] outputBuffer = new byte[1024];
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            while (!deflater.finished()) {
                int n = deflater.deflate(outputBuffer);
                outputLength += n;
                outputStream.write(outputBuffer, 0, n);
            }
            outputBytes = outputStream.toByteArray();
        }
        deflater.end();
        return ArrayUtils.subarray((byte[])outputBytes, (int)0, (int)outputLength);
    }

    public static String inflateToString(byte[] inputBytes) throws DataFormatException, IOException {
        byte[] outputBytes = ZipUtils.inflate(inputBytes);
        return outputBytes == null || outputBytes.length == 0 ? null : new String(outputBytes, 0, outputBytes.length, CHARSET);
    }

    public static byte[] inflate(byte[] inputBytes) throws DataFormatException, IOException {
        byte[] outputBytes;
        if (inputBytes == null || inputBytes.length == 0) {
            return null;
        }
        Inflater inflater = new Inflater();
        inflater.setInput(inputBytes);
        int outputLength = 0;
        byte[] outputBuffer = new byte[1024];
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            while (!inflater.finished()) {
                int n = inflater.inflate(outputBuffer);
                outputLength += n;
                outputStream.write(outputBuffer, 0, n);
            }
            outputBytes = outputStream.toByteArray();
        }
        inflater.end();
        return ArrayUtils.subarray((byte[])outputBytes, (int)0, (int)outputLength);
    }

    public static boolean zipFile(String pathName) throws IOException {
        File f;
        if (StringUtils.isNotBlank((String)pathName) && (f = new File(pathName)).isFile() && f.canRead() && !f.isHidden()) {
            return ZipUtils.zip(f);
        }
        return false;
    }

    public static boolean zipFolder(String pathName) throws IOException {
        File f;
        if (StringUtils.isNotBlank((String)pathName) && (f = new File(pathName)).isDirectory() && f.canRead() && !f.isHidden()) {
            return ZipUtils.zip(f);
        }
        return false;
    }

    private static boolean zip(File f) throws IOException {
        String zipPathName = f.getCanonicalPath() + ".zip";
        try (FileOutputStream fos = new FileOutputStream(zipPathName);
             ZipOutputStream zipOut = new ZipOutputStream(fos);){
            ZipUtils.zip(f, f.getName(), zipOut);
        }
        return true;
    }

    public static boolean zipFileAndFolder(String filePathName) throws IOException {
        return ZipUtils.zipFileAndFolder(filePathName, null);
    }

    public static boolean zipFileAndFolder(String filePathName, String folderPathName) throws IOException {
        return ZipUtils.zipFileAndFolder(filePathName, folderPathName, false);
    }

    public static boolean zipFileAndFolder(String filePathName, String folderPathName, boolean siblings) throws IOException {
        File d;
        File f;
        if (StringUtils.isNotBlank((String)filePathName) && (f = new File(filePathName)).isFile() && f.canRead() && !f.isHidden() && (d = ZipUtils.oldFile(folderPathName, filePathName, "_files")).isDirectory() && d.canRead() && !d.isHidden() && (!siblings || ObjectUtils.equals((Object)f.getParent(), (Object)d.getParent()))) {
            String zipPathName = f.getCanonicalPath() + ".zip";
            return ZipUtils.zip(zipPathName, f.getCanonicalPath(), d.getCanonicalPath());
        }
        return false;
    }

    public static boolean zip(String zipPathName, String ... pathNames) throws IOException {
        if (StringUtils.isNotBlank((String)zipPathName) && pathNames != null && pathNames.length > 0) {
            boolean zip = false;
            try (FileOutputStream fos = new FileOutputStream(zipPathName);
                 ZipOutputStream zipOut = new ZipOutputStream(fos);){
                for (String pathName : pathNames) {
                    if (!StringUtils.isNotBlank((String)pathName)) continue;
                    File f = new File(pathName);
                    zip |= ZipUtils.zip(f, f.getName(), zipOut);
                }
            }
            return zip;
        }
        return false;
    }

    private static boolean zip(File file, String filePath, ZipOutputStream zipOut) throws IOException {
        if (file.exists() && file.canRead() && !file.isHidden()) {
            if (file.isDirectory()) {
                File[] children;
                Object dirName = filePath.endsWith("/") ? filePath : filePath + "/";
                zipOut.putNextEntry(new ZipEntry((String)dirName));
                zipOut.closeEntry();
                for (File child : children = file.listFiles()) {
                    ZipUtils.zip(child, (String)dirName + child.getName(), zipOut);
                }
            } else {
                try (FileInputStream fis = new FileInputStream(file);){
                    int length;
                    zipOut.putNextEntry(new ZipEntry(filePath));
                    byte[] bytes = new byte[1024];
                    while ((length = fis.read(bytes)) >= 0) {
                        zipOut.write(bytes, 0, length);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static boolean unzip(String zipPathName) throws IOException {
        return ZipUtils.unzip(zipPathName, null);
    }

    public static boolean unzip(String zipPathName, String dirPathName) throws IOException {
        if (StringUtils.isNotBlank((String)zipPathName)) {
            File zip = new File(zipPathName);
            if (zip.isFile() && zip.canRead() && !zip.isHidden()) {
                byte[] buffer = new byte[1024];
                File dir = ZipUtils.newFile(dirPathName, zipPathName, ".dir");
                try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipPathName));){
                    ZipEntry zipEntry = zipIn.getNextEntry();
                    while (zipEntry != null) {
                        File file = ZipUtils.newFile(dir, zipEntry);
                        if (zipEntry.isDirectory()) {
                            ZipUtils.verifyDir(file);
                        } else {
                            ZipUtils.verifyDir(file.getParentFile());
                            try (FileOutputStream fos = new FileOutputStream(file);){
                                int len;
                                while ((len = zipIn.read(buffer)) > 0) {
                                    fos.write(buffer, 0, len);
                                }
                            }
                        }
                        zipEntry = zipIn.getNextEntry();
                    }
                    zipIn.closeEntry();
                }
                return true;
            }
            throw new IOException("Failed to access file " + zip);
        }
        return false;
    }

    private static File oldFile(String pathName, String rootPathName, String suffix) {
        if (StringUtils.isBlank((String)pathName) || pathName.equals(rootPathName)) {
            String x1 = rootPathName + suffix;
            String x2 = StringUtils.substringBeforeLast((String)rootPathName, (String)".") + suffix;
            File file = new File(x1);
            return file.exists() || x1.equals(x2) ? file : new File(x2);
        }
        return new File(pathName);
    }

    private static File newFile(String pathName, String rootPathName, String suffix) {
        Object pdq = StringUtils.isBlank((String)pathName) || pathName.equals(rootPathName) ? rootPathName + suffix : pathName;
        return new File((String)pdq);
    }

    private static File newFile(File dir, ZipEntry zipEntry) throws IOException {
        File file = new File(dir, zipEntry.getName());
        String dirPath = dir.getCanonicalPath();
        String filePath = file.getCanonicalPath();
        if (filePath.startsWith(dirPath + File.separator)) {
            return file;
        }
        throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
    }

    private static boolean verifyDir(File file) throws IOException {
        if (file != null) {
            if (file.isDirectory()) {
                if (!file.canWrite() || file.isHidden()) {
                    throw new IOException("Failed to access directory " + file);
                }
            } else if (!file.mkdirs()) {
                throw new IOException("Failed to create directory " + file);
            }
        }
        return true;
    }
}

