/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.commons.util.FilUtils;
import adalid.commons.util.StrUtils;
import adalid.commons.velocity.Writer;
import adalid.util.sql.SqlColumn;
import adalid.util.sql.SqlColumnPair;
import adalid.util.sql.SqlReader;
import adalid.util.sql.SqlRow;
import adalid.util.sql.SqlRowPair;
import adalid.util.sql.SqlRowValue;
import adalid.util.sql.SqlRowValuePair;
import adalid.util.sql.SqlTable;
import adalid.util.sql.SqlTableWrapper;
import adalid.util.sql.SqlUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SqlMerger
extends SqlUtil {
    private static final Logger logger = Logger.getLogger(SqlMerger.class);
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private boolean _infoLogging;
    private boolean _detailLogging;
    private boolean _testingPhase;
    private String _oldHost;
    private String _oldPort;
    private String _oldUser;
    private String _oldPassword;
    private String _oldDatabase;
    private String _oldSchema;
    private String _projectAlias;
    private String _oldDataFolder;
    private SqlReader _reader1;
    private SqlReader _reader2;
    private Map<String, String> _tablesLoadMap;
    private Map<String, String> _catalogTablesMap;
    private final Set<String> _tableNames;
    private final Set<String> _currentKeyTableNames;
    private final Set<String> _mutableKeyTableNames;
    private final Set<String> _addedKeyTableNames;
    private final Set<String> _updatedKeyTableNames;
    private final Set<String> _updatedRowTableNames;
    private final Set<String> _deletedRowTableNames;
    private final List<SqlTable> _addedTables;
    private final List<SqlTable> _droppedTables;
    private final Map<String, SqlColumn> _newColumns;
    private final Map<String, SqlColumn> _oldColumns;
    private final List<SqlColumnPair> _oddColumns;
    private final List<SqlColumn> _addedColumns;
    private final List<SqlColumn> _droppedColumns;
    private final List<SqlRow> _addedRows;
    private final List<SqlRow> _deletedRows;
    private final List<SqlRowValue> _addedValues;
    private final Map<String, SqlRowPair> _updatedRows;
    private final List<SqlTableWrapper> _sharedTables;
    private final Map<String, Set<String>> _messages;
    private final Map<String, Set<String>> _warnings;
    private static String PROJECT_ALIAS_PATTERN = "^[a-z][a-z0-9]*$";
    private static final String DATA_CONV_REQD = "; data conversion might be required";
    private static final String END_USER_VALUE = "; it could also have been updated by the end user";

    public SqlMerger() {
        this._detailLogging = this._infoLogging = true;
        this._tablesLoadMap = new LinkedHashMap<String, String>();
        this._catalogTablesMap = new LinkedHashMap<String, String>();
        this._tableNames = new TreeSet<String>();
        this._currentKeyTableNames = new TreeSet<String>();
        this._mutableKeyTableNames = new TreeSet<String>();
        this._addedKeyTableNames = new TreeSet<String>();
        this._updatedKeyTableNames = new TreeSet<String>();
        this._updatedRowTableNames = new TreeSet<String>();
        this._deletedRowTableNames = new TreeSet<String>();
        this._addedTables = new ArrayList<SqlTable>();
        this._droppedTables = new ArrayList<SqlTable>();
        this._newColumns = new LinkedHashMap<String, SqlColumn>();
        this._oldColumns = new LinkedHashMap<String, SqlColumn>();
        this._oddColumns = new ArrayList<SqlColumnPair>();
        this._addedColumns = new ArrayList<SqlColumn>();
        this._droppedColumns = new ArrayList<SqlColumn>();
        this._addedRows = new ArrayList<SqlRow>();
        this._deletedRows = new ArrayList<SqlRow>();
        this._addedValues = new ArrayList<SqlRowValue>();
        this._updatedRows = new LinkedHashMap<String, SqlRowPair>();
        this._sharedTables = new ArrayList<SqlTableWrapper>();
        this._messages = new LinkedHashMap<String, Set<String>>();
        this._warnings = new LinkedHashMap<String, Set<String>>();
        this.init();
    }

    public SqlMerger(String[] args) {
        super(args);
        this._detailLogging = this._infoLogging = true;
        this._tablesLoadMap = new LinkedHashMap<String, String>();
        this._catalogTablesMap = new LinkedHashMap<String, String>();
        this._tableNames = new TreeSet<String>();
        this._currentKeyTableNames = new TreeSet<String>();
        this._mutableKeyTableNames = new TreeSet<String>();
        this._addedKeyTableNames = new TreeSet<String>();
        this._updatedKeyTableNames = new TreeSet<String>();
        this._updatedRowTableNames = new TreeSet<String>();
        this._deletedRowTableNames = new TreeSet<String>();
        this._addedTables = new ArrayList<SqlTable>();
        this._droppedTables = new ArrayList<SqlTable>();
        this._newColumns = new LinkedHashMap<String, SqlColumn>();
        this._oldColumns = new LinkedHashMap<String, SqlColumn>();
        this._oddColumns = new ArrayList<SqlColumnPair>();
        this._addedColumns = new ArrayList<SqlColumn>();
        this._droppedColumns = new ArrayList<SqlColumn>();
        this._addedRows = new ArrayList<SqlRow>();
        this._deletedRows = new ArrayList<SqlRow>();
        this._addedValues = new ArrayList<SqlRowValue>();
        this._updatedRows = new LinkedHashMap<String, SqlRowPair>();
        this._sharedTables = new ArrayList<SqlTableWrapper>();
        this._messages = new LinkedHashMap<String, Set<String>>();
        this._warnings = new LinkedHashMap<String, Set<String>>();
        this.init();
    }

    private void init() {
        this._initialised = this._initialised && this.oldSchema(this._argIndex++, this._args);
        this._initialised = this._initialised && this.oldHost(this._argIndex++, this._args);
        this._initialised = this._initialised && this.oldPort(this._argIndex++, this._args);
        this._initialised = this._initialised && this.oldUser(this._argIndex++, this._args);
        this._initialised = this._initialised && this.oldPassword(this._argIndex++, this._args);
        this._initialised = this._initialised && this.oldDatabase(this._argIndex++, this._args);
        this._initialised = this._initialised && this.projectAlias(this._argIndex++, this._args);
    }

    private boolean oldHost(int i, String[] args) {
        this._oldHost = StringUtils.defaultIfBlank((String)this.arg(i, args), (String)this._host);
        if (StringUtils.isNotBlank((String)this._oldHost)) {
            this.logValidArgument(this.old() + " host", this._oldHost);
            return true;
        }
        this.logInvalidArgument(this.old() + " host", this._oldHost);
        this.logSyntaxError();
        return false;
    }

    private boolean oldPort(int i, String[] args) {
        this._oldPort = StringUtils.defaultIfBlank((String)this.arg(i, args), (String)this._port);
        if (StringUtils.isNotBlank((String)this._oldPort)) {
            this.logValidArgument(this.old() + " port", this._oldPort);
            return true;
        }
        this.logInvalidArgument(this.old() + " port", this._oldPort);
        this.logSyntaxError();
        return false;
    }

    private boolean oldUser(int i, String[] args) {
        this._oldUser = StringUtils.defaultIfBlank((String)this.arg(i, args), (String)this._user);
        if (StringUtils.isNotBlank((String)this._oldUser)) {
            this.logValidArgument(this.old() + " user", this._oldUser);
            return true;
        }
        this.logInvalidArgument(this.old() + " user", this._oldUser);
        this.logSyntaxError();
        return false;
    }

    private boolean oldPassword(int i, String[] args) {
        this._oldPassword = StringUtils.defaultIfBlank((String)this.arg(i, args), (String)this._password);
        if (StringUtils.isNotBlank((String)this._oldPassword)) {
            return true;
        }
        this.logInvalidArgument(this.old() + " password", this._oldPassword);
        this.logSyntaxError();
        return false;
    }

    private boolean oldDatabase(int i, String[] args) {
        this._oldDatabase = StringUtils.defaultIfBlank((String)this.arg(i, args), (String)this._database);
        if (StringUtils.isNotBlank((String)this._oldDatabase)) {
            this.logValidArgument(this.old() + " database", this._oldDatabase);
            return true;
        }
        this.logInvalidArgument(this.old() + " database", this._oldDatabase);
        this.logSyntaxError();
        return false;
    }

    private boolean oldSchema(int i, String[] args) {
        this._oldSchema = this.arg(i, args);
        if (StringUtils.isNotBlank((String)this._oldSchema)) {
            this.logValidArgument(this.old() + " schema", this._oldSchema);
            return true;
        }
        this.logInvalidArgument(this.old() + " schema", this._oldSchema);
        this.logSyntaxError();
        return false;
    }

    private boolean projectAlias(int i, String[] args) {
        String alias = this.arg(i, args);
        if (StringUtils.isBlank((String)alias)) {
            return true;
        }
        this.setProjectAlias(alias);
        if (alias.equals(this._projectAlias)) {
            this.logValidArgument("project alias", alias);
            return true;
        }
        this.logInvalidArgument("project alias", alias);
        this.logSyntaxError();
        return false;
    }

    protected String old() {
        return "old";
    }

    @Override
    protected String getSyntax() {
        return this.getSqlUtilSyntax() + ", old schema, [old host], [old port], [old user], [old password], [old database]";
    }

    public boolean isInfoLoggingEnabled() {
        return this._infoLogging;
    }

    public void enableInfoLogging() {
        this._infoLogging = true;
    }

    public void disableInfoLogging() {
        this._infoLogging = false;
    }

    public boolean isDetailLoggingEnabled() {
        return this._infoLogging && this._detailLogging;
    }

    public void enableDetailLogging() {
        this._detailLogging = true;
    }

    public void disableDetailLogging() {
        this._detailLogging = false;
    }

    public boolean isThereChanceOfRenamedTables() {
        return !this._addedTables.isEmpty() && !this._droppedTables.isEmpty();
    }

    public boolean isThereChanceOfRenamedColumns() {
        for (SqlTableWrapper sharedTable : this._sharedTables) {
            if (!sharedTable.hasAddedColumns() || !sharedTable.hasDroppedColumns()) continue;
            return true;
        }
        return false;
    }

    public boolean isIncrementallyUpgradeable() {
        return this._droppedTables.isEmpty() && this._droppedColumns.isEmpty() && this._oddColumns.isEmpty() && this._updatedKeyTableNames.isEmpty() && this._deletedRows.isEmpty();
    }

    public boolean isTestingPhase() {
        return this._testingPhase;
    }

    public String getNewSchema() {
        return this._schema;
    }

    public String getOldSchema() {
        return this._oldSchema;
    }

    public String getOldHost() {
        return this._oldHost;
    }

    public String getOldPort() {
        return this._oldPort;
    }

    public String getOldUser() {
        return this._oldUser;
    }

    public String getOldPassword() {
        return this._oldPassword;
    }

    public String getOldDatabase() {
        return this._oldDatabase;
    }

    public String getProjectAlias() {
        return this._projectAlias == null ? this.defaultProjectAlias() : this._projectAlias;
    }

    public void setProjectAlias(String alias) {
        if (StringUtils.isBlank((String)alias)) {
            logger.warn((Object)("null value for alias parameter; project alias remains " + this.getProjectAlias()));
        } else if (!alias.matches(PROJECT_ALIAS_PATTERN)) {
            logger.warn((Object)(alias + " is an invalid project alias; project alias remains " + this.getProjectAlias()));
        } else if (alias.equalsIgnoreCase("meta") || alias.equalsIgnoreCase("workspace")) {
            logger.warn((Object)(alias + " is a restricted project alias; project alias remains " + this.getProjectAlias()));
        } else {
            this._projectAlias = alias;
        }
    }

    private String defaultProjectAlias() {
        boolean oracle = StringUtils.equalsIgnoreCase((String)this._dbms, (String)"oracle");
        return (oracle ? this._schema : this._database).toLowerCase();
    }

    private boolean checkProjectAlias() {
        String alias = this.getProjectAlias();
        if (StringUtils.isBlank((String)alias)) {
            logger.error((Object)"invalid project alias; generation aborted");
            return false;
        }
        if (!alias.matches(PROJECT_ALIAS_PATTERN)) {
            logger.error((Object)(alias + " is an invalid project alias; generation aborted"));
            return false;
        }
        if (alias.equalsIgnoreCase("meta") || alias.equalsIgnoreCase("workspace")) {
            logger.error((Object)(alias + " is a restricted project alias; generation aborted"));
            return false;
        }
        return true;
    }

    public String getOldDataFolder() {
        return this._oldDataFolder == null ? this.defaultOldDataFolder() : this._oldDataFolder;
    }

    public void setOldDataFolder(String folder) {
        if (StringUtils.isBlank((String)folder)) {
            logger.warn((Object)("null value for folder parameter; old data folder remains " + this.getOldDataFolder()));
        } else {
            if (!((String)(folder = ((String)folder).replace("\\", "/"))).endsWith("/")) {
                folder = (String)folder + "/";
            }
            this._oldDataFolder = folder;
        }
    }

    private String defaultOldDataFolder() {
        Object folder = FilUtils.getWorkspaceFolderPath();
        folder = (String)folder + FILE_SEPARATOR + this.getProjectAlias();
        folder = (String)folder + FILE_SEPARATOR + "source";
        folder = (String)folder + FILE_SEPARATOR + "management";
        folder = (String)folder + FILE_SEPARATOR + "backup";
        folder = (String)folder + FILE_SEPARATOR + this._dbms;
        folder = (String)folder + FILE_SEPARATOR + this._oldSchema;
        folder = (String)folder + FILE_SEPARATOR;
        folder = ((String)folder).replace("\\", "/");
        return folder;
    }

    public Set<String> getTableNames() {
        return this._tableNames;
    }

    public Set<String> getCurrentKeyTableNames() {
        return this._currentKeyTableNames;
    }

    public Set<String> getMutableKeyTableNames() {
        return this._mutableKeyTableNames;
    }

    private boolean mutableKey(String tableName) {
        return this._mutableKeyTableNames.contains(tableName);
    }

    public Set<String> getAddedKeyTableNames() {
        return this._addedKeyTableNames;
    }

    public Set<String> getUpdatedKeyTableNames() {
        return this._updatedKeyTableNames;
    }

    public Set<String> getUpdatedRowTableNames() {
        return this._updatedRowTableNames;
    }

    public Set<String> getDeletedRowTableNames() {
        return this._deletedRowTableNames;
    }

    public List<SqlTable> getAddedTables() {
        return this._addedTables;
    }

    public List<SqlTable> getDroppedTables() {
        return this._droppedTables;
    }

    public Map<String, SqlColumn> getNewColumns() {
        return this._newColumns;
    }

    public Map<String, SqlColumn> getOldColumns() {
        return this._oldColumns;
    }

    public List<SqlColumnPair> getOddColumns() {
        return this._oddColumns;
    }

    public Set<String> getModifiedColumnNames() {
        return this._newColumns.keySet();
    }

    public List<SqlColumn> getAddedColumns() {
        return this._addedColumns;
    }

    public List<SqlColumn> getDroppedColumns() {
        return this._droppedColumns;
    }

    public List<SqlRow> getAddedRows() {
        return this._addedRows;
    }

    public List<SqlRow> getDeletedRows() {
        return this._deletedRows;
    }

    public List<SqlRowValue> getAddedValues() {
        return this._addedValues;
    }

    public Map<String, SqlRowPair> getUpdatedRows() {
        return this._updatedRows;
    }

    public List<SqlTableWrapper> getSharedTables() {
        return this._sharedTables;
    }

    public Map<String, Set<String>> getMessages() {
        return this._messages;
    }

    public Map<String, Set<String>> getWarnings() {
        return this._warnings;
    }

    public synchronized void clear() {
        logger.info((Object)"clear");
        this._tableNames.clear();
        this._currentKeyTableNames.clear();
        this._mutableKeyTableNames.clear();
        this._addedKeyTableNames.clear();
        this._updatedKeyTableNames.clear();
        this._updatedRowTableNames.clear();
        this._deletedRowTableNames.clear();
        this._addedTables.clear();
        this._droppedTables.clear();
        this._newColumns.clear();
        this._oldColumns.clear();
        this._oddColumns.clear();
        this._addedColumns.clear();
        this._droppedColumns.clear();
        this._addedRows.clear();
        this._deletedRows.clear();
        this._addedValues.clear();
        this._updatedRows.clear();
    }

    public synchronized boolean merge() {
        return this.merge(false);
    }

    public synchronized boolean merge(boolean testing) {
        logger.info((Object)"merge");
        boolean ok = this.checkProjectAlias();
        if (ok) {
            this.beforeMerging();
            this._testingPhase = testing;
            boolean merge = this._initialised;
            merge = merge && this.read1();
            merge = merge && this.read2();
            merge = merge && this.mergeTables();
            merge = merge && this.write();
            this.stats(merge);
            return merge;
        }
        return false;
    }

    private void beforeMerging() {
    }

    protected boolean read1() {
        return this.read1(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean read1(boolean simple) {
        boolean read = this.initReader1();
        if (read) {
            if (simple) {
                return this._reader1.read(true);
            }
            SqlReader.SqlAid aid = this._reader1.getSqlAid();
            if (aid != null && this._reader1.connect()) {
                try {
                    aid.createDefaults();
                    read = this._reader1.read(false);
                    aid.dropDefaults();
                    boolean bl = read;
                    return bl;
                }
                catch (SQLException sQLException) {
                }
                finally {
                    this._reader1.close();
                }
            }
        }
        return false;
    }

    private boolean initReader1() {
        String[] args = this.reader1_args();
        this._reader1 = new SqlReader(args);
        this._reader1.setSelectTemplatesPath("templates/meta/sql");
        this._reader1.setTablesLoadMap(this._tablesLoadMap);
        this._reader1.setCatalogTablesMap(this._catalogTablesMap);
        return this._reader1.isInitialised();
    }

    protected String[] reader1_args() {
        return new String[]{this._dbms, this._host, this._port, this._user, this._password, this._database, this._schema};
    }

    private boolean read2() {
        boolean read = this.initReader2();
        return read && this._reader2.read(true);
    }

    private boolean initReader2() {
        String[] args = this.reader2_args();
        this._reader2 = new SqlReader(args);
        this._reader2.setSelectTemplatesPath("templates/meta/sql");
        this._reader2.setTablesLoadMap(this._tablesLoadMap);
        this._reader2.setCatalogTablesMap(this._catalogTablesMap);
        return this._reader2.isInitialised();
    }

    protected String[] reader2_args() {
        return new String[]{this._dbms, this._oldHost, this._oldPort, this._oldUser, this._oldPassword, this._oldDatabase, this._oldSchema};
    }

    public Set<String> getTablesLoadSet() {
        return this._tablesLoadMap.keySet();
    }

    public Map<String, String> getTablesLoadMap() {
        return this._tablesLoadMap;
    }

    public void setTablesLoadMap(Map<String, String> map) {
        this._tablesLoadMap = map;
    }

    public Set<String> getCatalogTablesSet() {
        return this._catalogTablesMap.keySet();
    }

    public Map<String, String> getCatalogTablesMap() {
        return this._catalogTablesMap;
    }

    public void setCatalogTablesMap(Map<String, String> map) {
        this._catalogTablesMap = map;
    }

    private boolean mergeTables() {
        Map<String, SqlTable> map1 = this._reader1.getTablesMap();
        Map<String, SqlTable> map2 = this._reader2.getTablesMap();
        if (map1.isEmpty()) {
            logger.warn((Object)("schema " + this._reader1.getSchema() + " contains no tables"));
        } else {
            logger.info((Object)("schema " + this._reader1.getSchema() + " contains " + map1.size() + " tables"));
        }
        if (map2.isEmpty()) {
            logger.warn((Object)("schema " + this._reader2.getSchema() + " contains no tables"));
        } else {
            logger.info((Object)("schema " + this._reader2.getSchema() + " contains " + map2.size() + " tables"));
        }
        if (map1.isEmpty() && map2.isEmpty()) {
            logger.error((Object)"none of the schemas contains tables");
            return false;
        }
        if (map1.isEmpty() || map2.isEmpty()) {
            logger.error((Object)"one of the schemas contains no tables");
            return false;
        }
        this._tableNames.addAll(map1.keySet());
        this._tableNames.addAll(map2.keySet());
        Set<String> catalog = this.getCatalogTablesSet();
        for (String key : this._tableNames) {
            SqlTable table2;
            SqlTable table1;
            if (catalog.contains(key)) {
                this.logDetails(key, key + " is a catalog table and will be fully regenerated");
                continue;
            }
            if (map1.containsKey(key) && map2.containsKey(key)) {
                table1 = map1.get(key);
                table2 = map2.get(key);
                this.mergeColumns(table1, table2);
                continue;
            }
            if (map1.containsKey(key)) {
                table1 = map1.get(key);
                this.createTable(table1);
                continue;
            }
            table2 = map2.get(key);
            this.dropTable(table2);
        }
        if (this.isThereChanceOfRenamedTables()) {
            this.logWarning("*", "there could be renamed tables; check CREATE and DROP TABLE statements");
        }
        if (this.isThereChanceOfRenamedColumns()) {
            this.logWarning("*", "there could be renamed columns; check ADD and DROP COLUMN statements");
        }
        return true;
    }

    private boolean mergeColumns(SqlTable table1, SqlTable table2) {
        String text;
        SqlTableWrapper sharedTable = this.newSharedTable(table1);
        Map<String, SqlColumn> map1 = table1.getColumnsMap();
        Map<String, SqlColumn> map2 = table2.getColumnsMap();
        TreeSet<String> keySet = new TreeSet<String>();
        keySet.addAll(map1.keySet());
        keySet.addAll(map2.keySet());
        String tableName = table1.getName();
        boolean upgradeable = true;
        boolean compareRows = !this.mutableKey(tableName) && table1.isLoaded() && table2.isLoaded();
        for (String key : keySet) {
            String sqlx1;
            String name1;
            SqlColumnPair columnPair;
            SqlColumn column2;
            SqlColumn column1;
            if (map1.containsKey(key) && map2.containsKey(key)) {
                String xref3;
                column1 = map1.get(key);
                columnPair = sharedTable.addColumnPair(column1, column2 = map2.get(key));
                if (columnPair.equals()) continue;
                this.modifyColumn(column1, column2);
                sharedTable.setSlightlyModifiedColumns(true);
                if (columnPair.equates()) continue;
                sharedTable.setHeavilyModifiedColumns(true);
                name1 = tableName + "." + column1.getName();
                String type1 = column1.getType();
                String type2 = column2.getType();
                sqlx1 = column1.getSqlType();
                String sqlx2 = column2.getSqlType();
                String xref1 = column1.getForeignTableName();
                String xref2 = column2.getForeignTableName();
                String string = xref3 = xref2 == null ? "nothing" : xref2;
                if (!upgradeable) continue;
                this._oddColumns.add(columnPair);
                text = columnPair.casts() ? (String)name1 + " now is a not nullable " + sqlx1 + " column with no default value; data conversion might be required" : (type1.equals(type2) && columnPair.refers() ? (String)name1 + " now is " + sqlx1 + "; it previously was " + sqlx2 + DATA_CONV_REQD : (type1.equals(type2) ? (String)name1 + " now references " + xref1 + "; it previously referenced " + xref3 + DATA_CONV_REQD : (String)name1 + " now is " + sqlx1 + "; it previously was " + sqlx2 + DATA_CONV_REQD));
                this.logWarning(tableName, text);
                continue;
            }
            if (map1.containsKey(key)) {
                column1 = map1.get(key);
                this.addColumn(column1);
                sharedTable.setAddedColumns(true);
                name1 = tableName + "." + column1.getName();
                sqlx1 = column1.getSqlType();
                boolean nullable1 = column1.isNullable();
                String default1 = column1.getSqlDefaultValue();
                if (nullable1 || default1 != null) continue;
                columnPair = sharedTable.addColumnPair(column1, null);
                if (!upgradeable) continue;
                this._oddColumns.add(columnPair);
                text = name1 + " is a new not nullable " + sqlx1 + " column with no default value";
                this.logWarning(tableName, text);
                continue;
            }
            column2 = map2.get(key);
            this.dropColumn(column2);
            sharedTable.setDroppedColumns(true);
        }
        if (sharedTable.hasAddedColumns() && sharedTable.hasDroppedColumns()) {
            text = tableName + " could have renamed columns; check its ADD and DROP COLUMN statements";
            this.logWarning(tableName, text);
        }
        if (compareRows) {
            this.compareRows(table1, table2, keySet);
        }
        return true;
    }

    private void compareRows(SqlTable table1, SqlTable table2, Set<String> colnames) {
        Map<String, SqlRow> map1 = table1.getRowsByPrimaryKeyMap();
        Map<String, SqlRow> map2 = table2.getRowsByPrimaryKeyMap();
        Map<String, SqlRow> mbk1 = table1.getRowsMap();
        Map<String, SqlRow> mbk2 = table2.getRowsMap();
        Map<String, SqlColumn> colmap1 = table1.getColumnsMap();
        Map<String, SqlColumn> colmap2 = table2.getColumnsMap();
        TreeSet<String> keySet = new TreeSet<String>();
        keySet.addAll(map1.keySet());
        keySet.addAll(map2.keySet());
        String tableName = table1.getName();
        String bk1 = table1.getBusinessKey().getName();
        String bk2 = table2.getBusinessKey().getName();
        String vn1 = table1.getVersion() == null ? null : table1.getVersion().getName();
        String vn2 = table2.getVersion() == null ? null : table2.getVersion().getName();
        for (String key : keySet) {
            String bkv;
            Object text;
            Object subject;
            SqlRow row2;
            SqlRow row1;
            String strKey = "#" + key;
            if (map1.containsKey(key) && map2.containsKey(key)) {
                row1 = map1.get(key);
                row2 = map2.get(key);
                SqlRowPair rowPair = new SqlRowPair(row1, row2);
                List<SqlRowValuePair> rowValuePairs = rowPair.getUpdatedRowValues();
                Map<String, SqlRowValue> valuesMap1 = row1.getValuesMap();
                Map<String, SqlRowValue> valuesMap2 = row2.getValuesMap();
                for (String colname : colnames) {
                    String predicate;
                    boolean bk;
                    SqlRowValue rowValue2;
                    String strValue2;
                    if (colname.equals(vn1) && colname.equals(vn2)) continue;
                    SqlColumn column1 = colmap1.get(colname);
                    SqlColumn column2 = colmap2.get(colname);
                    if (column1 == null) continue;
                    SqlRowValue rowValue1 = valuesMap1.get(colname);
                    String strValue1 = rowValue1 == null ? null : rowValue1.getValue();
                    if (StringUtils.equals((String)strValue1, (String)(strValue2 = (rowValue2 = valuesMap2.get(colname)) == null ? null : rowValue2.getValue()))) continue;
                    boolean oldColumn = column2 != null;
                    boolean newColumn = column2 == null;
                    boolean newColumnWithValue = newColumn && rowValue1 != null && strValue1 != null;
                    SqlRowValuePair rowValuePair = new SqlRowValuePair(rowValue1, rowValue2);
                    if (oldColumn) {
                        rowValuePairs.add(rowValuePair);
                    }
                    this._updatedRows.put(tableName + "/" + key, rowPair);
                    this._updatedRowTableNames.add(tableName);
                    boolean bl = bk = colname.equals(bk1) || colname.equals(bk2);
                    if (bk) {
                        subject = strKey;
                        this._currentKeyTableNames.add(tableName);
                        if (oldColumn) {
                            predicate = "business key modified";
                            this._updatedKeyTableNames.add(tableName);
                        } else {
                            predicate = "business key added";
                            this._addedKeyTableNames.add(tableName);
                        }
                    } else {
                        subject = this.isDetailLoggingEnabled() ? strKey : "rows";
                        predicate = "modified";
                    }
                    text = this.join(new String[]{tableName, subject, predicate});
                    if (bk || this.isDetailLoggingEnabled()) {
                        text = oldColumn ? (String)text + " (" + colname + ": " + StrUtils.enclose(strValue2, '\"') + " -> " + StrUtils.enclose(strValue1, '\"') + ")" : (String)text + " (" + colname + ": " + StrUtils.enclose(strValue1, '\"') + ")";
                    }
                    if (bk && oldColumn) {
                        this.logWarning(tableName, (String)text + DATA_CONV_REQD);
                        continue;
                    }
                    this.logDetails(tableName, (String)text);
                    if (newColumnWithValue) {
                        logger.trace((Object)this.getUpdateStatement(rowValue1));
                        this._addedValues.add(rowValue1);
                        continue;
                    }
                    if (!rowValuePair.isUpdatableColumn()) continue;
                    text = this.join(tableName, strKey, colname, "has a new value; it could also have been updated by the end user");
                    this.logWarning(tableName, (String)text);
                }
                continue;
            }
            if (map1.containsKey(key)) {
                row1 = map1.get(key);
                this._addedRows.add(row1);
                bkv = row1.getBusinessKeyValue();
                subject = this.isDetailLoggingEnabled() ? "[" + key + ", " + StrUtils.enclose(bkv, '\"') + "]" : "rows";
                text = this.join(new String[]{tableName, subject, "added"});
                if (mbk2.containsKey(bkv)) {
                    this._updatedKeyTableNames.add(tableName);
                    this._currentKeyTableNames.add(tableName);
                    this.logWarning(tableName, (String)text + DATA_CONV_REQD);
                    continue;
                }
                this.logMessage(tableName, (String)text);
                continue;
            }
            row2 = map2.get(key);
            this._deletedRows.add(row2);
            this._deletedRowTableNames.add(tableName);
            this._currentKeyTableNames.add(tableName);
            bkv = row2.getBusinessKeyValue();
            subject = this.isDetailLoggingEnabled() ? "[" + key + ", " + StrUtils.enclose(bkv, '\"') + "]" : "rows";
            text = this.join(new String[]{tableName, subject, "deleted"});
            if (mbk1.containsKey(bkv)) {
                this._updatedKeyTableNames.add(tableName);
            }
            this.logWarning(tableName, (String)text + DATA_CONV_REQD);
        }
    }

    private String getUpdateStatement(SqlRowValue rowValue) {
        return rowValue.getUpdateStatement();
    }

    private String join(String ... texts) {
        Object join = "";
        for (String text : texts) {
            if (!StringUtils.isNotBlank((String)text)) continue;
            join = (String)join + text + " ";
        }
        return ((String)join).trim();
    }

    private SqlTableWrapper newSharedTable(SqlTable table) {
        SqlTableWrapper sharedTable = new SqlTableWrapper(table, this);
        this._sharedTables.add(sharedTable);
        return sharedTable;
    }

    private void createTable(SqlTable table) {
        String tableName = table.getName();
        String statement = "create table " + tableName;
        boolean log = this.logMessage(tableName, statement);
        this._addedTables.add(table);
        if (this._testingPhase) {
            Collection<SqlColumn> columns = table.getColumns();
            for (SqlColumn column : columns) {
                String name = column.getName();
                String type = column.getSqlDataType();
                int length = column.getLength();
                int precision = column.getPrecision();
                int scale = column.getScale();
                boolean nullable = column.isNullable();
                String defaultValue = column.getSqlDefaultValue();
                statement = name + "(" + type + "," + length + "," + precision + "," + scale + "," + nullable + "," + defaultValue + ")";
                if (!log || !this.isDetailLoggingEnabled()) continue;
                logger.info((Object)statement);
            }
        }
        this.insertRows(table);
    }

    private void insertRows(SqlTable table) {
        Map<String, SqlRow> map = table.getRowsMap();
        String tableName = table.getName();
        if (map.isEmpty()) {
            this.logDetails(tableName, this.join("no rows added to table", tableName));
        } else {
            for (String key : map.keySet()) {
                SqlRow row = map.get(key);
                this._addedRows.add(row);
                String strKey = row.getPrimaryKeyValue();
                String subject = this.isDetailLoggingEnabled() ? "[" + strKey + ", " + StrUtils.enclose(key, '\"') + "]" : "rows";
                String text = this.join(tableName, subject, "added");
                this.logMessage(tableName, text);
            }
        }
    }

    private void dropTable(SqlTable table) {
        String tableName = table.getName();
        String statement = "drop table " + tableName + ";";
        this.logWarning(tableName, statement);
        this._droppedTables.add(table);
    }

    private void modifyColumn(SqlColumn column1, SqlColumn column2) {
        String tableName = column1.getTable().getName();
        String columnName = column1.getName();
        String name = tableName + "." + columnName;
        this._newColumns.put(name, column1);
        this._oldColumns.put(name, column2);
    }

    private void addColumn(SqlColumn column) {
        String tableName = column.getTable().getName();
        String columnName = column.getName();
        String type = column.getSqlDataType();
        int length = column.getLength();
        int precision = column.getPrecision();
        int scale = column.getScale();
        boolean nullable = column.isNullable();
        String defaultValue = column.getSqlDefaultValue();
        String statement = "alter table " + tableName + " add column " + columnName + " [" + type + "(" + length + "," + precision + "," + scale + "," + nullable + "," + defaultValue + ")];";
        this.logMessage(tableName, statement);
        this._addedColumns.add(column);
    }

    private void dropColumn(SqlColumn column) {
        String tableName = column.getTable().getName();
        String columnName = column.getName();
        String statement = "alter table " + tableName + " drop column " + columnName + ";";
        this.logWarning(tableName, statement);
        this._droppedColumns.add(column);
    }

    static boolean equals(SqlColumn column1, SqlColumn column2) {
        String type1 = column1.getType();
        int length1 = column1.getLength();
        int precision1 = column1.getPrecision();
        int scale1 = column1.getScale();
        boolean nullable1 = column1.isNullable();
        String type2 = column2.getType();
        int length2 = column2.getLength();
        int precision2 = column2.getPrecision();
        int scale2 = column2.getScale();
        boolean nullable2 = column2.isNullable();
        return type1.equals(type2) && length1 == length2 && precision1 == precision2 && scale1 == scale2 && nullable1 == nullable2 && SqlMerger.refers(column1, column2);
    }

    static boolean equates(SqlColumn column1, SqlColumn column2) {
        boolean casts = SqlMerger.casts(column1, column2);
        if (!casts) {
            return false;
        }
        boolean nullable1 = column1.isNullable();
        String default1 = column1.getSqlDefaultValue();
        boolean nullable2 = column2.isNullable();
        return nullable1 || !nullable2 || default1 != null;
    }

    static boolean casts(SqlColumn column1, SqlColumn column2) {
        boolean refers = SqlMerger.refers(column1, column2);
        if (!refers) {
            return false;
        }
        String type1 = column1.getType();
        int length1 = column1.getLength();
        int precision1 = column1.getPrecision();
        int scale1 = column1.getScale();
        int characters1 = SqlMerger.characters(type1, length1);
        int digits1 = SqlMerger.digits(type1, precision1, scale1);
        String type2 = column2.getType();
        int length2 = column2.getLength();
        int precision2 = column2.getPrecision();
        int scale2 = column2.getScale();
        int characters2 = SqlMerger.characters(type2, length2);
        int digits2 = SqlMerger.digits(type2, precision2, scale2);
        switch (type1) {
            case "char": 
            case "string": {
                return characters1 >= characters2 && characters2 > 0;
            }
            case "byte": 
            case "short": 
            case "integer": 
            case "long": 
            case "decimal": 
            case "float": 
            case "double": {
                return digits1 >= digits2 && digits2 > 0;
            }
            case "timestamp": {
                return type2.equals(type1) || type2.equals("date") || type2.equals("time");
            }
        }
        return type2.equals(type1);
    }

    static boolean refers(SqlColumn column1, SqlColumn column2) {
        boolean foreign1 = column1.isForeign();
        boolean foreign2 = column2.isForeign();
        if (foreign1) {
            String foreignTableName1 = column1.getForeignTableName();
            String foreignTableName2 = column2.getForeignTableName();
            return foreign2 && foreignTableName1.equals(foreignTableName2);
        }
        return true;
    }

    private static int characters(String type, int length) {
        switch (type) {
            case "char": 
            case "string": {
                return length == 0 ? Integer.MAX_VALUE : length;
            }
        }
        return 0;
    }

    private static int digits(String type, int precision, int scale) {
        switch (type) {
            case "byte": {
                return 3;
            }
            case "short": {
                return 5;
            }
            case "integer": {
                return 10;
            }
            case "long": {
                return 19;
            }
            case "decimal": 
            case "float": 
            case "double": {
                return precision == 0 ? Integer.MAX_VALUE : precision - scale;
            }
        }
        return 0;
    }

    private boolean logDetails(String name, String text) {
        return this.isDetailLoggingEnabled() && this.logMessage(name, text);
    }

    private boolean logMessage(String name, String text) {
        return this.logMessage(name, text, false);
    }

    private boolean logMessage(String name, String text, boolean notable) {
        if (this.isInfoLoggingEnabled()) {
            String prefix;
            String string = prefix = notable ? "<!>" : "";
            if (this.addMessage(name, prefix + text)) {
                logger.info((Object)text);
                return true;
            }
        }
        return false;
    }

    private boolean logWarning(String name, String text) {
        if (this.addWarning(name, text)) {
            logger.warn((Object)SqlUtil.highlight(text));
            return true;
        }
        return false;
    }

    private boolean addMessage(String name, String text) {
        Set<Object> set;
        if (this._messages.containsKey(name)) {
            set = this._messages.get(name);
        } else {
            set = new LinkedHashSet();
            this._messages.put(name, set);
        }
        return set.add(text);
    }

    private boolean addWarning(String name, String text) {
        Set<Object> set;
        if (this._warnings.containsKey(name)) {
            set = this._warnings.get(name);
        } else {
            set = new LinkedHashSet();
            this._warnings.put(name, set);
        }
        return set.add(text);
    }

    private void stats(boolean merge) {
        if (merge) {
            logger.info((Object)("added tables=" + this._addedTables.size()));
            logger.info((Object)("dropped tables=" + this._droppedTables.size()));
            if (!this._addedKeyTableNames.isEmpty()) {
                logger.warn((Object)("added-key tables=" + this._addedKeyTableNames.size() + " " + this._addedKeyTableNames));
            }
            if (!this._updatedKeyTableNames.isEmpty()) {
                logger.warn((Object)("updated-key tables=" + this._updatedKeyTableNames.size() + " " + this._updatedKeyTableNames));
            }
            if (!this._updatedRowTableNames.isEmpty()) {
                logger.info((Object)("updated-row tables=" + this._updatedRowTableNames.size() + " " + this._updatedRowTableNames));
            }
            if (!this._deletedRowTableNames.isEmpty()) {
                logger.warn((Object)("deleted-row tables=" + this._deletedRowTableNames.size() + " " + this._deletedRowTableNames));
            }
            logger.info((Object)("added columns=" + this._addedColumns.size()));
            logger.info((Object)("dropped columns=" + this._droppedColumns.size()));
            logger.info((Object)("altered columns=" + this._newColumns.size()));
            if (!this._oddColumns.isEmpty()) {
                logger.warn((Object)("odd columns=" + this._oddColumns.size()));
            }
            logger.info((Object)("added rows=" + this._addedRows.size()));
            logger.info((Object)("deleted rows=" + this._deletedRows.size()));
            logger.info((Object)("updated rows=" + this._updatedRows.size()));
            if (this.isIncrementallyUpgradeable()) {
                logger.info((Object)"an incremental upgrade should work!");
            } else {
                logger.warn((Object)"AN INCREMENTAL UPGRADE COULD FAIL!");
            }
        } else {
            logger.error((Object)"MERGE OPERATION FAILED!");
        }
    }

    private boolean write() {
        logger.info((Object)"write");
        Writer writer = new Writer(this, "merger");
        writer.write(this.platform());
        return true;
    }

    protected String platform() {
        return "meta-sql-" + this._dbms + "-1st";
    }
}

