/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.commons.util.BitUtils;
import adalid.commons.util.IntUtils;
import adalid.commons.util.NumUtils;
import adalid.commons.util.StrUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.commons.util.TimeUtils;
import adalid.commons.velocity.VelocityEngineer;
import adalid.util.sql.SqlArtifact;
import adalid.util.sql.SqlColumn;
import adalid.util.sql.SqlIndex;
import adalid.util.sql.SqlIndexColumn;
import adalid.util.sql.SqlRoutine;
import adalid.util.sql.SqlRoutineParameter;
import adalid.util.sql.SqlRow;
import adalid.util.sql.SqlRowValue;
import adalid.util.sql.SqlTab;
import adalid.util.sql.SqlTabColumn;
import adalid.util.sql.SqlTable;
import adalid.util.sql.SqlUtil;
import java.io.File;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.velocity.VelocityContext;

public class SqlReader
extends SqlUtil {
    private static final Logger logger = Logger.getLogger(SqlReader.class);
    private static final boolean INFO = true;
    private static final boolean DETAIL = false;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final int ROW_LIMIT = 30000;
    private final Map<String, SqlTable> _tables = new LinkedHashMap<String, SqlTable>();
    private Set<String> _tablesExcludeSet = new LinkedHashSet<String>();
    private Map<String, String> _tablesInheritMap = new LinkedHashMap<String, String>();
    private Map<String, String> _tablesLoadMap = new LinkedHashMap<String, String>();
    private Map<String, String> _catalogTablesMap = new LinkedHashMap<String, String>();
    private List<String> _updatableColumns;
    private boolean _checkUpdatableColumns;
    private boolean _loadConfigurationTables;
    private boolean _loadOperationTables;
    private boolean _coverIndexes;
    private boolean _coverTabs;
    private boolean _coverRoutines;
    private String _selectTemplatesPath = "templates/meta/sql";
    private SqlAid _sqlAid;

    public SqlReader() {
    }

    public SqlReader(String[] args) {
        super(args);
    }

    protected SqlAid getSqlAid() {
        if (this._sqlAid == null) {
            switch (this._dbms) {
                case "oracle": {
                    this._sqlAid = new OracleAid();
                    break;
                }
                case "postgresql": {
                    this._sqlAid = new PostgreSqlAid();
                    break;
                }
                default: {
                    this._sqlAid = null;
                }
            }
        }
        return this._sqlAid;
    }

    public Map<String, SqlTable> getTablesMap() {
        return this._tables;
    }

    public Collection<SqlTable> getTables() {
        return this._tables.values();
    }

    public Set<String> getTablesExcludeSet() {
        return this._tablesExcludeSet;
    }

    public void setTablesExcludeSet(Set<String> set) {
        this._tablesExcludeSet = set;
    }

    public void setTablesExcludeSet(String[] set) {
        this._tablesExcludeSet = set == null ? null : new LinkedHashSet<String>(Arrays.asList(set));
    }

    public Set<String> getTablesInheritSet() {
        return this._tablesInheritMap.keySet();
    }

    public Map<String, String> getTablesInheritMap() {
        return this._tablesInheritMap;
    }

    public void setTablesInheritMap(Map<String, String> map) {
        this._tablesInheritMap = map;
    }

    public Set<String> getTablesLoadSet() {
        return this._tablesLoadMap.keySet();
    }

    public Map<String, String> getTablesLoadMap() {
        return this._tablesLoadMap;
    }

    public void setTablesLoadMap(Map<String, String> map) {
        this._tablesLoadMap = map;
    }

    public Set<String> getCatalogTablesSet() {
        return this._catalogTablesMap.keySet();
    }

    public Map<String, String> getCatalogTablesMap() {
        return this._catalogTablesMap;
    }

    public void setCatalogTablesMap(Map<String, String> map) {
        this._catalogTablesMap = map;
    }

    public boolean isLoadConfigurationTables() {
        return this._loadConfigurationTables;
    }

    public void setLoadConfigurationTables(boolean loadConfigurationTables) {
        this._loadConfigurationTables = loadConfigurationTables;
    }

    public boolean isLoadOperationTables() {
        return this._loadOperationTables;
    }

    public void setLoadOperationTables(boolean loadOperationTables) {
        this._loadOperationTables = loadOperationTables;
    }

    public boolean isCoverIndexes() {
        return this._coverIndexes;
    }

    public void setCoverIndexes(boolean b) {
        this._coverIndexes = b;
    }

    public boolean isCoverTabs() {
        return this._coverTabs;
    }

    public void setCoverTabs(boolean b) {
        this._coverTabs = b;
    }

    public boolean isCoverRoutines() {
        return this._coverRoutines;
    }

    public void setCoverRoutines(boolean b) {
        this._coverRoutines = b;
    }

    public String getSelectTemplatesPath() {
        return this._selectTemplatesPath;
    }

    public void setSelectTemplatesPath(String selectTemplatesPath) {
        this._selectTemplatesPath = selectTemplatesPath;
    }

    public boolean read(boolean close) {
        boolean read = this._initialised;
        read = read && this.connect();
        read = read && this.beforeReadBuild();
        read = read && this.build();
        boolean bl = read = read && this.beforeReadClose();
        if (close) {
            this.close();
        }
        return read;
    }

    protected boolean beforeReadBuild() {
        return true;
    }

    protected boolean beforeReadClose() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean build() {
        Iterator<SqlTable> iterator;
        SqlTable sqlTable2;
        int columns;
        SqlAid aid;
        block51: {
            boolean bl;
            SqlUtil.PreparedStatementWrapper selectRows;
            SqlUtil.PreparedStatementWrapper selectRoutines;
            SqlUtil.PreparedStatementWrapper selectTabs;
            SqlUtil.PreparedStatementWrapper selectIndexes;
            SqlUtil.PreparedStatementWrapper selectColumns;
            SqlUtil.PreparedStatementWrapper selectTables;
            block49: {
                boolean bl2;
                block48: {
                    logger.info((Object)"build");
                    aid = this.getSqlAid();
                    if (aid == null) {
                        return false;
                    }
                    SqlUtil.PreparedStatementWrapper select = null;
                    selectTables = null;
                    selectColumns = null;
                    selectIndexes = null;
                    selectTabs = null;
                    selectRoutines = null;
                    selectRows = null;
                    Level tableNameLogLevel = this.isRemoteConnection() ? Level.INFO : Level.TRACE;
                    int tables = 0;
                    columns = 0;
                    int indexes = 0;
                    int tabs = 0;
                    int rows = 0;
                    int routines = 0;
                    int enum2 = 0;
                    int enum3 = 0;
                    int load2 = 0;
                    try {
                        selectTables = aid.getSelectTablesStatement();
                        if (selectTables == null) {
                            logger.error((Object)"tables=?");
                            this.close(selectTables);
                            boolean bl3 = false;
                            return bl3;
                        }
                        select = selectTables;
                        ResultSet tablesResultSet = selectTables.executeQuery();
                        boolean next = tablesResultSet.next();
                        if (!next) {
                            logger.error((Object)"tables=0");
                            this.close(selectTables);
                            bl2 = false;
                            this.close(selectTables);
                            break block48;
                        }
                        selectColumns = aid.getSelectColumnsStatement();
                        if (selectColumns == null) {
                            logger.error((Object)"columns=?");
                            this.close(selectTables);
                            this.close(selectColumns);
                            bl = false;
                            this.close(selectTables);
                            break block49;
                        }
                        this.setUpdatableColumns(aid);
                        if (this._coverIndexes) {
                            selectIndexes = aid.getSelectIndexesStatement();
                        }
                        if (this._coverTabs) {
                            selectTabs = aid.getSelectTabsStatement();
                        }
                        if (this._coverRoutines) {
                            selectRoutines = aid.getSelectRoutinesStatement();
                        }
                        do {
                            String name;
                            if (this.foul(sqlTable2 = aid.getSqlTable(tablesResultSet)) || !this.add(sqlTable2)) continue;
                            ++tables;
                            String tableName = sqlTable2.getName();
                            logger.log((Priority)tableNameLogLevel, (Object)tableName);
                            Object[] executeQueryArgs = new Object[]{tableName};
                            select = selectColumns;
                            ResultSet columnsResultSet = selectColumns.executeQuery(executeQueryArgs);
                            if (columnsResultSet.next()) {
                                do {
                                    SqlColumn sqlColumn;
                                    if ((sqlColumn = aid.getSqlColumn(columnsResultSet, sqlTable2)) == null) continue;
                                    ++columns;
                                    sqlTable2.add(sqlColumn);
                                } while (columnsResultSet.next());
                            }
                            if (selectIndexes != null) {
                                select = selectIndexes;
                                ResultSet indexesResultSet = selectIndexes.executeQuery(executeQueryArgs);
                                if (indexesResultSet.next()) {
                                    SqlArtifact sqlIndex = null;
                                    do {
                                        if ((name = aid.getSqlIndexName(indexesResultSet)) == null) continue;
                                        if (sqlIndex != null && name.equals(sqlIndex.getName())) {
                                            aid.getSqlIndex(indexesResultSet, (SqlIndex)sqlIndex);
                                            continue;
                                        }
                                        sqlIndex = aid.getSqlIndex(indexesResultSet, sqlTable2);
                                        if (sqlIndex == null) continue;
                                        ++indexes;
                                        sqlTable2.add((SqlIndex)sqlIndex);
                                    } while (indexesResultSet.next());
                                }
                            }
                            if (selectTabs != null) {
                                select = selectTabs;
                                ResultSet tabsResultSet = selectTabs.executeQuery(executeQueryArgs);
                                if (tabsResultSet.next()) {
                                    SqlArtifact sqlTab = null;
                                    do {
                                        if ((name = aid.getSqlTabName(tabsResultSet)) == null) continue;
                                        if (sqlTab != null && name.equals(sqlTab.getName())) {
                                            aid.getSqlTab(tabsResultSet, (SqlTab)sqlTab);
                                            continue;
                                        }
                                        sqlTab = aid.getSqlTab(tabsResultSet, sqlTable2);
                                        if (sqlTab == null) continue;
                                        ++tabs;
                                        sqlTable2.add((SqlTab)sqlTab);
                                    } while (tabsResultSet.next());
                                }
                            }
                            if (selectRoutines != null) {
                                select = selectRoutines;
                                ResultSet routinesResultSet = selectRoutines.executeQuery(executeQueryArgs);
                                if (routinesResultSet.next()) {
                                    SqlArtifact sqlRoutine = null;
                                    do {
                                        if ((name = aid.getSqlRoutineName(routinesResultSet)) == null) continue;
                                        if (sqlRoutine != null && name.equals(sqlRoutine.getName())) {
                                            aid.getSqlRoutine(routinesResultSet, (SqlRoutine)sqlRoutine);
                                            continue;
                                        }
                                        sqlRoutine = aid.getSqlRoutine(routinesResultSet, sqlTable2);
                                        if (sqlRoutine == null) continue;
                                        ++routines;
                                        sqlTable2.add((SqlRoutine)sqlRoutine);
                                    } while (routinesResultSet.next());
                                }
                            }
                            if ((sqlTable2.isEnumeration() || sqlTable2.isLoadable()) && (selectRows = aid.getSelectRowsStatement(sqlTable2)) != null) {
                                select = selectRows;
                                try {
                                    int n = 0;
                                    ResultSet rowsResultSet = selectRows.executeQuery();
                                    if (rowsResultSet.next()) {
                                        do {
                                            SqlRow sqlRow;
                                            if ((sqlRow = aid.getSqlRow(rowsResultSet, sqlTable2)) == null) continue;
                                            ++n;
                                            ++rows;
                                            sqlTable2.add(sqlRow);
                                        } while (rowsResultSet.next());
                                        if (n >= 30000) {
                                            this.warnRowLimit(sqlTable2);
                                        }
                                    }
                                    sqlTable2.setLoaded(true);
                                }
                                catch (SQLException ex) {
                                    logger.info((Object)(select + " / " + ThrowableUtils.getString(ex)));
                                }
                                finally {
                                    this.close(selectRows);
                                    selectRows = null;
                                }
                            }
                            select = selectTables;
                            if (sqlTable2.isEnumeration()) {
                                ++enum2;
                            }
                            if (sqlTable2.isUpdatableEnumeration()) {
                                ++enum3;
                            }
                            if (!sqlTable2.isLoaded()) continue;
                            ++load2;
                        } while (tablesResultSet.next());
                        logger.info((Object)("tables=" + tables));
                        logger.info((Object)("enumeration-tables=" + enum2));
                        logger.info((Object)("updatable-enumeration-tables=" + enum3));
                        logger.info((Object)("loaded-tables=" + load2));
                        logger.info((Object)("columns=" + columns));
                        if (this._coverIndexes) {
                            logger.info((Object)("indexes=" + indexes));
                        }
                        if (this._coverTabs) {
                            logger.info((Object)("tabs=" + tabs));
                        }
                        logger.info((Object)("rows=" + rows));
                        if (this._coverRoutines) {
                            logger.info((Object)("routines=" + routines));
                        }
                        this.close(selectTables);
                    }
                    catch (SQLException ex) {
                        logger.fatal((Object)(select == null ? this._url : select.toString()), (Throwable)ex);
                        boolean sqlTable2 = false;
                        return sqlTable2;
                    }
                }
                this.close(selectColumns);
                this.close(selectIndexes);
                this.close(selectTabs);
                this.close(selectRows);
                this.close(selectRoutines);
                return bl2;
            }
            this.close(selectColumns);
            this.close(selectIndexes);
            this.close(selectTabs);
            this.close(selectRows);
            this.close(selectRoutines);
            return bl;
            this.close(selectColumns);
            this.close(selectIndexes);
            this.close(selectTabs);
            this.close(selectRows);
            this.close(selectRoutines);
            iterator = this._tables.values().iterator();
            break block51;
            finally {
                this.close(selectTables);
                this.close(selectColumns);
                this.close(selectIndexes);
                this.close(selectTabs);
                this.close(selectRows);
                this.close(selectRoutines);
            }
        }
        while (iterator.hasNext()) {
            sqlTable2 = iterator.next();
            aid.finalize(sqlTable2);
        }
        for (SqlTable sqlTable2 : this._tables.values()) {
            sqlTable2.settleColumns();
        }
        for (SqlTable sqlTable2 : this._tables.values()) {
            for (SqlTable extension : this._tables.values()) {
                if (!sqlTable2.equals(extension.getRootTable())) continue;
                sqlTable2.add(extension);
            }
        }
        if (columns <= 0) return false;
        return true;
    }

    private boolean add(SqlTable sqlTable) {
        String name = sqlTable.getName();
        if (StringUtils.isBlank((String)name)) {
            String text = "a null name table will not be added ";
            logger.error((Object)SqlUtil.highlight(text));
            return false;
        }
        if (this._tables.containsKey(name)) {
            String text = "table " + name + " already added ";
            logger.error((Object)SqlUtil.highlight(text));
            return false;
        }
        this._tables.put(name, sqlTable);
        return true;
    }

    private void warnRowLimit(SqlTable sqlTable) {
        String name = sqlTable.getName();
        String text = name + " reached 30000 rows limit";
        logger.warn((Object)SqlUtil.highlight(text));
    }

    private boolean foul(SqlTable sqlTable) {
        if (sqlTable == null) {
            return true;
        }
        if (this._tablesExcludeSet == null) {
            return false;
        }
        String name = sqlTable.getName();
        return this._tablesExcludeSet.contains(name) || this._tablesExcludeSet.contains(name.toLowerCase()) || this._tablesExcludeSet.contains(name.toUpperCase());
    }

    private String merge(String template, VelocityContext context) {
        String message = "failed to merge \"" + template + "\"";
        try {
            return VelocityEngineer.merge(context, template).toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(message, ex);
        }
    }

    private void setUpdatableColumns(SqlAid aid) {
        this._updatableColumns = null;
        this._checkUpdatableColumns = false;
        SqlUtil.PreparedStatementWrapper selectUpdatableColumns = aid.getSelectUpdatableColumnsStatement();
        if (selectUpdatableColumns != null) {
            try {
                ResultSet resultSet = selectUpdatableColumns.executeQuery();
                boolean next = resultSet.next();
                if (next) {
                    this._updatableColumns = new ArrayList<String>();
                    this._checkUpdatableColumns = true;
                    do {
                        String table_name = resultSet.getString(1);
                        String column_name = resultSet.getString(2);
                        this._updatableColumns.add(this.updatableColumnName(table_name, column_name));
                    } while (resultSet.next());
                }
            }
            catch (SQLException ex) {
                this._updatableColumns = null;
                this._checkUpdatableColumns = false;
                logger.warn((Object)(ThrowableUtils.getString(ex) + "\n" + selectUpdatableColumns));
                logger.warn((Object)"all columns will be considered updatable");
            }
        }
    }

    private boolean isUpdatableColumn(String table, String column) {
        return this._updatableColumns == null || this._checkUpdatableColumns && this._updatableColumns.contains(this.updatableColumnName(table, column));
    }

    private String updatableColumnName(String table, String column) {
        return table + "." + column;
    }

    class PostgreSqlAid
    extends SqlAid {
        PostgreSqlAid() {
        }

        @Override
        protected boolean createDefaults() throws SQLException {
            String statement = "select " + SqlReader.this._schema + ".create_defaults();";
            return SqlReader.this.executeStatement(statement);
        }

        @Override
        protected boolean dropDefaults() throws SQLException {
            String statement = "select " + SqlReader.this._schema + ".drop_defaults();";
            return SqlReader.this.executeStatement(statement);
        }

        @Override
        protected SqlUtil.PreparedStatementWrapper getSelectRowsStatement(SqlTable sqlTable) {
            String name = sqlTable.getName();
            String pk = sqlTable.getPrimaryKey().getName();
            String sql = "select * from " + SqlReader.this._schema + "." + name + " order by " + pk + " limit 30000";
            logger.debug((Object)sql);
            return this.prepareSelectStatement(sql);
        }

        @Override
        protected SqlTable getSqlTable(ResultSet resultSet) throws SQLException {
            String table_name = resultSet.getString(1);
            String default_label = resultSet.getString(2);
            String default_collection_label = resultSet.getString(3);
            String resource_type = resultSet.getString(4);
            boolean is_enumerable = this.booleanValueOf(resultSet.getObject(5));
            boolean is_insertable = this.booleanValueOf(resultSet.getObject(6));
            boolean is_updatable = this.booleanValueOf(resultSet.getObject(7));
            boolean is_deletable = this.booleanValueOf(resultSet.getObject(8));
            boolean is_independent = this.booleanValueOf(resultSet.getObject(9));
            SqlTable sqlTable = new SqlTable(SqlReader.this);
            sqlTable.setName(table_name);
            sqlTable.setDefaultLabel(default_label);
            sqlTable.setDefaultCollectionLabel(default_collection_label);
            sqlTable.setResourceType(resource_type);
            sqlTable.setEnumerable(is_enumerable);
            sqlTable.setInsertable(is_insertable);
            sqlTable.setUpdatable(is_updatable);
            sqlTable.setDeletable(is_deletable);
            sqlTable.setIndependent(is_independent);
            return sqlTable;
        }

        @Override
        protected SqlColumn getSqlColumn(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String table_name = sqlTable.getName();
            String column_name = resultSet.getString(1);
            int ordinal_position = this.intValueOf(resultSet.getObject(2));
            String data_type = StringUtils.trimToEmpty((String)resultSet.getString(3));
            int character_maximum_length = this.intValueOf(resultSet.getObject(4));
            int numeric_precision = this.intValueOf(resultSet.getObject(5));
            int numeric_scale = this.intValueOf(resultSet.getObject(6));
            int datetime_precision = this.intValueOf(resultSet.getObject(7));
            String column_default = StringUtils.trimToNull((String)resultSet.getString(8));
            String string_default = this.stringValueOf(column_default);
            boolean is_updatable = SqlReader.this.isUpdatableColumn(table_name, column_name);
            boolean is_nullable = this.booleanValueOf(resultSet.getObject(9));
            boolean is_primary_key = this.booleanValueOf(resultSet.getObject(10));
            boolean is_unique_key = this.booleanValueOf(resultSet.getObject(11));
            boolean is_booleanish = this.booleanValueOf(resultSet.getObject(12));
            String foreign_table_name = StringUtils.trimToNull((String)resultSet.getString(13));
            String default_label = resultSet.getString(14);
            SqlColumn sqlColumn = new SqlColumn(sqlTable);
            sqlColumn.setName(column_name);
            sqlColumn.setPosition(ordinal_position);
            sqlColumn.setDefaultLabel(default_label);
            data_type = data_type.replaceAll("\\(.*\\)", "");
            sqlColumn.setSqlDataType(data_type);
            sqlColumn.setSqlType(data_type);
            sqlColumn.setType(data_type);
            switch (data_type) {
                case "boolean": {
                    sqlColumn.setType("boolean");
                    break;
                }
                case "blob": 
                case "bytea": {
                    sqlColumn.setType("blob");
                    break;
                }
                case "\"char\"": {
                    sqlColumn.setType("char");
                    sqlColumn.setSqlType("char(1)");
                    break;
                }
                case "char": 
                case "character": 
                case "character varying": 
                case "varchar": 
                case "text": {
                    sqlColumn.setType("string");
                    sqlColumn.setLength(character_maximum_length);
                    if (character_maximum_length <= 0) break;
                    sqlColumn.setSqlType(data_type + "(" + character_maximum_length + ")");
                    break;
                }
                case "smallint": 
                case "smallserial": {
                    sqlColumn.setType("short");
                    break;
                }
                case "integer": 
                case "serial": {
                    sqlColumn.setType("integer");
                    break;
                }
                case "bigint": 
                case "bigserial": {
                    sqlColumn.setType("long");
                    break;
                }
                case "decimal": 
                case "numeric": 
                case "money": {
                    sqlColumn.setType("decimal");
                    sqlColumn.setPrecision(numeric_precision);
                    sqlColumn.setScale(numeric_scale);
                    if (numeric_precision <= 0) break;
                    if (numeric_scale > 0) {
                        sqlColumn.setSqlType(data_type + "(" + numeric_precision + ", " + numeric_scale + ")");
                        break;
                    }
                    sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                    break;
                }
                case "real": {
                    sqlColumn.setType("float");
                    break;
                }
                case "double precision": {
                    sqlColumn.setType("double");
                    break;
                }
                case "date": {
                    sqlColumn.setType("date");
                    break;
                }
                case "time": 
                case "time with time zone": 
                case "time without time zone": {
                    sqlColumn.setType("time");
                    sqlColumn.setPrecision(datetime_precision);
                    if (datetime_precision <= 0) break;
                    int i = data_type.indexOf(" ");
                    if (i < 0) {
                        sqlColumn.setSqlType(data_type + "(" + datetime_precision + ")");
                        break;
                    }
                    sqlColumn.setSqlType(data_type.substring(0, i) + "(" + datetime_precision + ")" + data_type.substring(i));
                    break;
                }
                case "timestamp": 
                case "timestamp with time zone": 
                case "timestamp without time zone": {
                    sqlColumn.setType("timestamp");
                    sqlColumn.setPrecision(datetime_precision);
                    if (datetime_precision <= 0) break;
                    int i = data_type.indexOf(" ");
                    if (i < 0) {
                        sqlColumn.setSqlType(data_type + "(" + datetime_precision + ")");
                        break;
                    }
                    sqlColumn.setSqlType(data_type.substring(0, i) + "(" + datetime_precision + ")" + data_type.substring(i));
                }
            }
            sqlColumn.setDefault(string_default);
            sqlColumn.setSqlDefaultValue(column_default);
            sqlColumn.setUpdatable(is_updatable);
            sqlColumn.setNullable(is_nullable);
            sqlColumn.setPrimary(is_primary_key);
            sqlColumn.setUnique(is_unique_key);
            sqlColumn.setBooleanish(is_booleanish);
            if (foreign_table_name != null) {
                sqlColumn.setForeign(true);
                sqlColumn.setForeignTableName(foreign_table_name);
            }
            return sqlColumn;
        }

        @Override
        protected String literalOf(Object obj) {
            String string = this.unquotedLiteralOf(obj);
            if (string == null) {
                return "null";
            }
            if (obj instanceof Boolean) {
                return string;
            }
            if (obj instanceof Number) {
                return string;
            }
            if (obj instanceof Date) {
                return "date" + StrUtils.enclose(string, '\'');
            }
            if (obj instanceof Time) {
                return "time" + StrUtils.enclose(string, '\'');
            }
            if (obj instanceof java.util.Date) {
                return "timestamp" + StrUtils.enclose(string, '\'');
            }
            return StrUtils.enclose(string, '\'');
        }

        protected String unquotedLiteralOf(Object obj) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof Clob) {
                return StrUtils.getSubString((Clob)obj);
            }
            if (obj instanceof Date) {
                return TimeUtils.jdbcDateString(obj);
            }
            if (obj instanceof Time) {
                return TimeUtils.jdbcTimeString(obj);
            }
            if (obj instanceof java.util.Date) {
                return TimeUtils.jdbcTimestampString(obj);
            }
            return obj.toString();
        }

        protected String stringValueOf(String string) {
            String trimmed = StringUtils.trimToNull((String)string);
            if (trimmed == null) {
                return null;
            }
            if (StringUtils.startsWithIgnoreCase((String)trimmed, (String)"null")) {
                return null;
            }
            if (StringUtils.startsWithIgnoreCase((String)trimmed, (String)"nextval")) {
                return null;
            }
            if (StringUtils.containsIgnoreCase((String)trimmed, (String)"'now'")) {
                return "now()";
            }
            int i = trimmed.indexOf("::");
            if (i > 0) {
                trimmed = trimmed.substring(0, i);
            }
            return StrUtils.disclose(trimmed, '\'');
        }

        @Override
        protected String stringValueOf(SqlColumn sqlColumn, String string) {
            String trimmed = sqlColumn.isForeign() ? null : StringUtils.trimToNull((String)string);
            String value = trimmed == null ? null : this.stringValueOf(trimmed.toLowerCase(), sqlColumn.getTrueType());
            return value == null ? super.stringValueOf(sqlColumn, string) : value;
        }

        @Override
        protected SqlIndex getSqlIndex(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String index_name = resultSet.getString(1);
            boolean is_unique = this.booleanValueOf(resultSet.getObject(2));
            SqlIndex sqlIndex = new SqlIndex(sqlTable);
            sqlIndex.setName(index_name);
            sqlIndex.setUnique(is_unique);
            return this.getSqlIndex(resultSet, sqlIndex);
        }

        @Override
        protected SqlIndex getSqlIndex(ResultSet resultSet, SqlIndex sqlIndex) throws SQLException {
            int ordinal_position = this.intValueOf(resultSet.getObject(3));
            String column_name = resultSet.getString(4);
            String column_option = resultSet.getString(5);
            SqlIndexColumn sqlIndexColumn = new SqlIndexColumn(sqlIndex, sqlIndex.getTable().getSqlColumn(column_name));
            sqlIndexColumn.setName(column_name);
            sqlIndexColumn.setPosition(ordinal_position);
            sqlIndexColumn.setOption(column_option);
            sqlIndex.add(sqlIndexColumn);
            return sqlIndex;
        }

        @Override
        protected SqlTab getSqlTab(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String tab_name = resultSet.getString(1);
            String default_label = resultSet.getString(2);
            SqlTab sqlTab = new SqlTab(sqlTable);
            sqlTab.setName(tab_name);
            sqlTab.setDefaultLabel(default_label);
            return this.getSqlTab(resultSet, sqlTab);
        }

        @Override
        protected SqlTab getSqlTab(ResultSet resultSet, SqlTab sqlTab) throws SQLException {
            String column_name = resultSet.getString(3);
            SqlTabColumn sqlTabColumn = new SqlTabColumn(sqlTab, sqlTab.getTable().getSqlColumn(column_name));
            sqlTabColumn.setName(column_name);
            sqlTab.add(sqlTabColumn);
            return sqlTab;
        }

        @Override
        protected SqlRoutine getSqlRoutine(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String routine_name = resultSet.getString(1);
            SqlRoutine sqlRoutine = new SqlRoutine(sqlTable);
            sqlRoutine.setName(routine_name);
            return this.getSqlRoutine(resultSet, sqlRoutine);
        }

        @Override
        protected SqlRoutine getSqlRoutine(ResultSet resultSet, SqlRoutine sqlRoutine) throws SQLException {
            String parameter_name = resultSet.getString(3);
            if (StringUtils.isBlank((String)parameter_name)) {
                return sqlRoutine;
            }
            String data_type = StringUtils.trimToEmpty((String)resultSet.getString(4));
            boolean is_required = this.booleanValueOf(resultSet.getObject(5));
            boolean is_hidden = this.booleanValueOf(resultSet.getObject(6));
            String parameter_default = StringUtils.trimToNull((String)resultSet.getString(7));
            SqlRoutineParameter sqlRoutineParameter = new SqlRoutineParameter(sqlRoutine);
            sqlRoutineParameter.setName(parameter_name);
            switch (data_type) {
                case "boolean": {
                    sqlRoutineParameter.setType("boolean");
                    break;
                }
                case "\"char\"": {
                    sqlRoutineParameter.setType("char");
                    break;
                }
                case "char": 
                case "character": 
                case "character varying": 
                case "varchar": 
                case "text": {
                    sqlRoutineParameter.setType("string");
                    break;
                }
                case "smallint": 
                case "smallserial": {
                    sqlRoutineParameter.setType("short");
                    break;
                }
                case "integer": 
                case "serial": {
                    sqlRoutineParameter.setType("integer");
                    break;
                }
                case "bigint": 
                case "bigserial": {
                    sqlRoutineParameter.setType("long");
                    break;
                }
                case "decimal": 
                case "numeric": 
                case "money": {
                    sqlRoutineParameter.setType("decimal");
                    break;
                }
                case "real": {
                    sqlRoutineParameter.setType("float");
                    break;
                }
                case "double precision": {
                    sqlRoutineParameter.setType("double");
                    break;
                }
                case "date": {
                    sqlRoutineParameter.setType("date");
                    break;
                }
                case "time": 
                case "time with time zone": 
                case "time without time zone": {
                    sqlRoutineParameter.setType("time");
                    break;
                }
                case "timestamp": 
                case "timestamp with time zone": 
                case "timestamp without time zone": {
                    sqlRoutineParameter.setType("timestamp");
                    break;
                }
                default: {
                    sqlRoutineParameter.setType("string");
                }
            }
            sqlRoutineParameter.setSqlDataType(data_type);
            sqlRoutineParameter.setRequired(is_required);
            sqlRoutineParameter.setHidden(is_hidden);
            sqlRoutineParameter.setDefault(parameter_default);
            sqlRoutineParameter.setSqlDefaultValue(parameter_default);
            sqlRoutine.add(sqlRoutineParameter);
            return sqlRoutine;
        }

        @Override
        protected String stringValueOf(SqlRoutineParameter sqlRoutineParameter, String string) {
            String trimmed = sqlRoutineParameter.isForeign() ? null : StringUtils.trimToNull((String)string);
            String value = trimmed == null ? null : this.stringValueOf(trimmed.toLowerCase(), sqlRoutineParameter.getTrueType());
            return value == null ? super.stringValueOf(sqlRoutineParameter, string) : value;
        }

        protected String stringValueOf(String string, String type) {
            return string == null || type == null ? null : (string.equals("current_date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("current_time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("current_timestamp") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("current_timestamp") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("current_timestamp") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("localtime") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("localtimestamp") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("localtimestamp") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("localtimestamp") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("now()") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("now()") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("now()") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("getdate()") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("getdate()") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("getdate()") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("getuser()") && type.equals("long") ? "SpecialNumericValue.CURRENT_USER_ID" : (string.equals("getuser()") && type.equals("string") ? "SpecialCharacterValue.CURRENT_USER" : null)))))))))))))))));
        }
    }

    class OracleAid
    extends SqlAid {
        OracleAid() {
        }

        @Override
        protected boolean createDefaults() throws SQLException {
            String statement = "call " + SqlReader.this._schema + ".create_defaults()";
            return SqlReader.this.executeStatement(statement);
        }

        @Override
        protected boolean dropDefaults() throws SQLException {
            String statement = "call " + SqlReader.this._schema + ".drop_defaults()";
            return SqlReader.this.executeStatement(statement);
        }

        @Override
        protected SqlUtil.PreparedStatementWrapper getSelectRowsStatement(SqlTable sqlTable) {
            String name = sqlTable.getName();
            String pk = sqlTable.getPrimaryKey().getName();
            String sql = "select * from " + SqlReader.this._schema + "." + name + " where ROWNUM<=30000 order by " + pk;
            logger.debug((Object)sql);
            return this.prepareSelectStatement(sql);
        }

        @Override
        protected SqlTable getSqlTable(ResultSet resultSet) throws SQLException {
            String table_name = resultSet.getString(1);
            String default_label = resultSet.getString(2);
            String default_collection_label = resultSet.getString(3);
            String resource_type = resultSet.getString(4);
            boolean is_enumerable = this.booleanValueOf(resultSet.getObject(5));
            boolean is_insertable = this.booleanValueOf(resultSet.getObject(6));
            boolean is_updatable = this.booleanValueOf(resultSet.getObject(7));
            boolean is_deletable = this.booleanValueOf(resultSet.getObject(8));
            boolean is_independent = this.booleanValueOf(resultSet.getObject(9));
            SqlTable sqlTable = new SqlTable(SqlReader.this);
            sqlTable.setName(table_name);
            sqlTable.setDefaultLabel(default_label);
            sqlTable.setDefaultCollectionLabel(default_collection_label);
            sqlTable.setResourceType(resource_type);
            sqlTable.setEnumerable(is_enumerable);
            sqlTable.setInsertable(is_insertable);
            sqlTable.setUpdatable(is_updatable);
            sqlTable.setDeletable(is_deletable);
            sqlTable.setIndependent(is_independent);
            return sqlTable;
        }

        @Override
        protected SqlColumn getSqlColumn(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String table_name = sqlTable.getName();
            String column_name = resultSet.getString(1);
            int ordinal_position = this.intValueOf(resultSet.getObject(2));
            String data_type = StringUtils.trimToEmpty((String)resultSet.getString(3));
            int character_maximum_length = this.intValueOf(resultSet.getObject(4));
            int numeric_precision = this.intValueOf(resultSet.getObject(5));
            int numeric_scale = this.intValueOf(resultSet.getObject(6));
            int datetime_precision = this.intValueOf(resultSet.getObject(7));
            String column_default = StrUtils.disclose(StringUtils.trimToNull((String)resultSet.getString(8)), '(', ')');
            String string_default = this.stringValueOf(column_default);
            boolean is_updatable = SqlReader.this.isUpdatableColumn(table_name, column_name);
            boolean is_nullable = this.booleanValueOf(resultSet.getObject(9));
            boolean is_primary_key = this.booleanValueOf(resultSet.getObject(10));
            boolean is_unique_key = this.booleanValueOf(resultSet.getObject(11));
            boolean is_booleanish = this.booleanValueOf(resultSet.getObject(12));
            String foreign_table_name = StringUtils.trimToNull((String)resultSet.getString(13));
            String default_label = resultSet.getString(14);
            SqlColumn sqlColumn = new SqlColumn(sqlTable);
            sqlColumn.setName(column_name);
            sqlColumn.setPosition(ordinal_position);
            sqlColumn.setDefaultLabel(default_label);
            data_type = data_type.replaceAll("\\(.*\\)", "");
            sqlColumn.setSqlDataType(data_type);
            sqlColumn.setSqlType(data_type);
            sqlColumn.setType(data_type);
            switch (data_type) {
                case "number": {
                    if (numeric_precision <= 0) break;
                    if (numeric_scale == 0) {
                        if (numeric_precision <= 3) {
                            sqlColumn.setType("byte");
                            sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                            break;
                        }
                        if (numeric_precision <= 5) {
                            sqlColumn.setType("short");
                            sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                            break;
                        }
                        if (numeric_precision <= 10) {
                            sqlColumn.setType("integer");
                            sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                            break;
                        }
                        if (numeric_precision <= 19) {
                            sqlColumn.setType("long");
                            sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                            break;
                        }
                        sqlColumn.setType("decimal");
                        sqlColumn.setPrecision(numeric_precision);
                        sqlColumn.setScale(numeric_scale);
                        if (numeric_precision <= 0) break;
                        if (numeric_scale > 0) {
                            sqlColumn.setSqlType(data_type + "(" + numeric_precision + ", " + numeric_scale + ")");
                            break;
                        }
                        sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                        break;
                    }
                    sqlColumn.setType("decimal");
                    sqlColumn.setPrecision(numeric_precision);
                    sqlColumn.setScale(numeric_scale);
                    if (numeric_scale > 0) {
                        sqlColumn.setSqlType(data_type + "(" + numeric_precision + ", " + numeric_scale + ")");
                        break;
                    }
                    sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                    break;
                }
                case "blob": 
                case "bytea": {
                    sqlColumn.setType("blob");
                    break;
                }
                case "\"char\"": {
                    sqlColumn.setType("char");
                    sqlColumn.setSqlType("char(1)");
                    break;
                }
                case "char": 
                case "character": 
                case "character varying": 
                case "nchar": 
                case "nvarchar": 
                case "nvarchar2": 
                case "varchar": 
                case "varchar2": 
                case "text": {
                    sqlColumn.setType("string");
                    sqlColumn.setLength(character_maximum_length);
                    if (character_maximum_length <= 0) break;
                    sqlColumn.setSqlType(data_type + "(" + character_maximum_length + ")");
                    break;
                }
                case "smallint": 
                case "smallserial": {
                    sqlColumn.setType("short");
                    break;
                }
                case "integer": 
                case "serial": {
                    sqlColumn.setType("integer");
                    break;
                }
                case "bigint": 
                case "bigserial": {
                    sqlColumn.setType("long");
                    break;
                }
                case "decimal": 
                case "numeric": 
                case "money": {
                    sqlColumn.setType("decimal");
                    sqlColumn.setPrecision(numeric_precision);
                    sqlColumn.setScale(numeric_scale);
                    if (numeric_precision <= 0) break;
                    if (numeric_scale > 0) {
                        sqlColumn.setSqlType(data_type + "(" + numeric_precision + ", " + numeric_scale + ")");
                        break;
                    }
                    sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                    break;
                }
                case "real": {
                    sqlColumn.setType("float");
                    break;
                }
                case "double precision": {
                    sqlColumn.setType("double");
                    break;
                }
                case "date": {
                    sqlColumn.setType("date");
                    break;
                }
                case "timestamp": 
                case "timestamp with time zone": 
                case "timestamp without time zone": {
                    sqlColumn.setType("timestamp");
                    sqlColumn.setPrecision(datetime_precision);
                    if (datetime_precision <= 0) break;
                    int i = data_type.indexOf(" ");
                    if (i < 0) {
                        sqlColumn.setSqlType(data_type + "(" + datetime_precision + ")");
                        break;
                    }
                    sqlColumn.setSqlType(data_type.substring(0, i) + "(" + datetime_precision + ")" + data_type.substring(i));
                }
            }
            sqlColumn.setDefault(string_default);
            sqlColumn.setSqlDefaultValue(column_default);
            sqlColumn.setUpdatable(is_updatable);
            sqlColumn.setNullable(is_nullable);
            sqlColumn.setPrimary(is_primary_key);
            sqlColumn.setUnique(is_unique_key);
            sqlColumn.setBooleanish(is_booleanish);
            if (foreign_table_name != null) {
                sqlColumn.setForeign(true);
                sqlColumn.setForeignTableName(foreign_table_name);
            }
            return sqlColumn;
        }

        @Override
        protected String literalOf(Object obj) {
            String string = this.unquotedLiteralOf(obj);
            if (string == null) {
                return "null";
            }
            if (obj instanceof Number) {
                return string;
            }
            if (obj instanceof Date) {
                return "date" + StrUtils.enclose(string, '\'');
            }
            if (obj instanceof Time) {
                return "timestamp" + StrUtils.enclose(string, '\'');
            }
            if (obj instanceof java.util.Date) {
                return "timestamp" + StrUtils.enclose(string, '\'');
            }
            return StrUtils.enclose(string, '\'');
        }

        protected String unquotedLiteralOf(Object obj) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof Clob) {
                return StrUtils.getSubString((Clob)obj);
            }
            if (obj instanceof Date) {
                return TimeUtils.jdbcDateString(obj);
            }
            if (obj instanceof Time) {
                return TimeUtils.jdbcTimestampString(obj);
            }
            if (obj instanceof java.util.Date) {
                return TimeUtils.jdbcTimestampString(obj);
            }
            return obj.toString();
        }

        protected String stringValueOf(String string) {
            String trimmed = StringUtils.trimToNull((String)string);
            if (trimmed == null) {
                return null;
            }
            if (StringUtils.startsWithIgnoreCase((String)(trimmed = StrUtils.disclose(trimmed, '(', ')')), (String)"null")) {
                return null;
            }
            if (StringUtils.startsWithIgnoreCase((String)trimmed, (String)"nextval")) {
                return null;
            }
            if (StringUtils.containsIgnoreCase((String)trimmed, (String)"'now'")) {
                return "now()";
            }
            int i = trimmed.indexOf("::");
            if (i > 0) {
                trimmed = trimmed.substring(0, i);
            }
            return StrUtils.disclose(trimmed, '\'');
        }

        @Override
        protected String stringValueOf(SqlColumn sqlColumn, String string) {
            String trimmed = sqlColumn.isForeign() ? null : StringUtils.trimToNull((String)string);
            String value = trimmed == null ? null : this.stringValueOf(trimmed.toLowerCase(), sqlColumn.getTrueType());
            return value == null ? super.stringValueOf(sqlColumn, string) : value;
        }

        @Override
        protected SqlIndex getSqlIndex(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String index_name = resultSet.getString(1);
            boolean is_unique = this.booleanValueOf(resultSet.getObject(2));
            SqlIndex sqlIndex = new SqlIndex(sqlTable);
            sqlIndex.setName(index_name);
            sqlIndex.setUnique(is_unique);
            return this.getSqlIndex(resultSet, sqlIndex);
        }

        @Override
        protected SqlIndex getSqlIndex(ResultSet resultSet, SqlIndex sqlIndex) throws SQLException {
            int ordinal_position = this.intValueOf(resultSet.getObject(3));
            String column_name = resultSet.getString(4);
            String column_option = resultSet.getString(5);
            SqlIndexColumn sqlIndexColumn = new SqlIndexColumn(sqlIndex, sqlIndex.getTable().getSqlColumn(column_name));
            sqlIndexColumn.setName(column_name);
            sqlIndexColumn.setPosition(ordinal_position);
            sqlIndexColumn.setOption(column_option);
            sqlIndex.add(sqlIndexColumn);
            return sqlIndex;
        }

        @Override
        protected SqlTab getSqlTab(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String tab_name = resultSet.getString(1);
            String default_label = resultSet.getString(2);
            SqlTab sqlTab = new SqlTab(sqlTable);
            sqlTab.setName(tab_name);
            sqlTab.setDefaultLabel(default_label);
            return this.getSqlTab(resultSet, sqlTab);
        }

        @Override
        protected SqlTab getSqlTab(ResultSet resultSet, SqlTab sqlTab) throws SQLException {
            String column_name = resultSet.getString(3);
            SqlTabColumn sqlTabColumn = new SqlTabColumn(sqlTab, sqlTab.getTable().getSqlColumn(column_name));
            sqlTabColumn.setName(column_name);
            sqlTab.add(sqlTabColumn);
            return sqlTab;
        }

        @Override
        protected SqlRoutine getSqlRoutine(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String routine_name = resultSet.getString(1);
            String routine_type = resultSet.getString(2);
            SqlRoutine sqlRoutine = new SqlRoutine(sqlTable);
            sqlRoutine.setName(routine_name);
            sqlRoutine.setOperationType(routine_type);
            return this.getSqlRoutine(resultSet, sqlRoutine);
        }

        @Override
        protected SqlRoutine getSqlRoutine(ResultSet resultSet, SqlRoutine sqlRoutine) throws SQLException {
            String parameter_name = resultSet.getString(3);
            if (StringUtils.isBlank((String)parameter_name)) {
                return sqlRoutine;
            }
            String data_type = StringUtils.trimToEmpty((String)resultSet.getString(4));
            boolean is_required = this.booleanValueOf(resultSet.getObject(5));
            boolean is_hidden = this.booleanValueOf(resultSet.getObject(6));
            Object parameter_default = StringUtils.trimToNull((String)resultSet.getString(7));
            SqlRoutineParameter sqlRoutineParameter = new SqlRoutineParameter(sqlRoutine);
            sqlRoutineParameter.setName(parameter_name);
            switch (data_type) {
                case "boolean": {
                    sqlRoutineParameter.setType("boolean");
                    break;
                }
                case "\"char\"": {
                    sqlRoutineParameter.setType("char");
                    break;
                }
                case "char": 
                case "character": 
                case "character varying": 
                case "nchar": 
                case "nvarchar": 
                case "nvarchar2": 
                case "varchar": 
                case "varchar2": 
                case "text": {
                    sqlRoutineParameter.setType("string");
                    break;
                }
                case "smallint": 
                case "smallserial": {
                    sqlRoutineParameter.setType("short");
                    break;
                }
                case "integer": {
                    if (StringUtils.startsWithIgnoreCase((String)parameter_name, (String)"es_")) {
                        sqlRoutineParameter.setType("boolean");
                        parameter_default = "" + this.booleanValueOf(parameter_default);
                        break;
                    }
                    sqlRoutineParameter.setType("integer");
                    break;
                }
                case "serial": {
                    sqlRoutineParameter.setType("integer");
                    break;
                }
                case "bigint": 
                case "bigserial": {
                    sqlRoutineParameter.setType("long");
                    break;
                }
                case "decimal": 
                case "numeric": 
                case "money": {
                    sqlRoutineParameter.setType("decimal");
                    break;
                }
                case "real": {
                    sqlRoutineParameter.setType("float");
                    break;
                }
                case "double precision": {
                    sqlRoutineParameter.setType("double");
                    break;
                }
                case "date": {
                    sqlRoutineParameter.setType("date");
                    break;
                }
                case "time": 
                case "time with time zone": 
                case "time without time zone": {
                    sqlRoutineParameter.setType("time");
                    break;
                }
                case "timestamp": 
                case "timestamp with time zone": 
                case "timestamp without time zone": {
                    sqlRoutineParameter.setType("timestamp");
                    break;
                }
                default: {
                    sqlRoutineParameter.setType("string");
                }
            }
            sqlRoutineParameter.setSqlDataType(data_type);
            sqlRoutineParameter.setRequired(is_required);
            sqlRoutineParameter.setHidden(is_hidden);
            sqlRoutineParameter.setDefault((String)parameter_default);
            sqlRoutineParameter.setSqlDefaultValue((String)parameter_default);
            sqlRoutine.add(sqlRoutineParameter);
            return sqlRoutine;
        }

        @Override
        protected String stringValueOf(SqlRoutineParameter sqlRoutineParameter, String string) {
            String trimmed = sqlRoutineParameter.isForeign() ? null : StringUtils.trimToNull((String)string);
            String value = trimmed == null ? null : this.stringValueOf(trimmed.toLowerCase(), sqlRoutineParameter.getTrueType());
            return value == null ? super.stringValueOf(sqlRoutineParameter, string) : value;
        }

        protected String stringValueOf(String string, String type) {
            return string == null || type == null ? null : (string.equals("current_date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("current_time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("current_timestamp") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("current_timestamp") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("current_timestamp") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("localtime") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("localtimestamp") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("localtimestamp") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("localtimestamp") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("now()") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("now()") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("now()") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("getdate()") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("getdate()") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("getdate()") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("getuser()") && type.equals("long") ? "SpecialNumericValue.CURRENT_USER_ID" : (string.equals("getuser()") && type.equals("string") ? "SpecialCharacterValue.CURRENT_USER" : null)))))))))))))))));
        }
    }

    protected abstract class SqlAid {
        protected SqlAid() {
        }

        protected abstract boolean createDefaults() throws SQLException;

        protected abstract boolean dropDefaults() throws SQLException;

        protected SqlUtil.PreparedStatementWrapper getSelectTablesStatement() {
            String template = this.getTemplateName("tables");
            return this.getSelectStatement(template);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectColumnsStatement() {
            String template = this.getTemplateName("columns");
            return this.getSelectStatement(template);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectIndexesStatement() {
            String template = this.getTemplateName("indexes");
            return this.getSelectStatement(template);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectTabsStatement() {
            String template = this.getTemplateName("tabs");
            return this.getSelectStatement(template);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectRoutinesStatement() {
            String template = this.getTemplateName("routines");
            return this.getSelectStatement(template);
        }

        protected abstract SqlUtil.PreparedStatementWrapper getSelectRowsStatement(SqlTable var1);

        protected SqlUtil.PreparedStatementWrapper getSelectUpdatableColumnsStatement() {
            String template = this.getTemplateName("updatable-columns");
            return this.getSelectStatement(template);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectStatement(String template) {
            VelocityContext context = new VelocityContext();
            return this.getSelectStatement(template, context);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectStatement(String template, SqlTable sqlTable) {
            VelocityContext context = new VelocityContext();
            String name = sqlTable.getName();
            context.put("table", (Object)name);
            return this.getSelectStatement(template, context);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectStatement(String template, VelocityContext context) {
            String[] fileResourceLoaderPathArray;
            context.put("database", (Object)SqlReader.this._database);
            context.put("schema", (Object)SqlReader.this._schema);
            for (String path : fileResourceLoaderPathArray = VelocityEngineer.getFileResourceLoaderPathArray()) {
                String templatePath = path + FILE_SEPARATOR + template.replaceAll("/", "\\" + FILE_SEPARATOR);
                File templateFile = new File(templatePath);
                if (!templateFile.exists()) continue;
                logger.info((Object)("select-template=" + templatePath));
                String string = SqlReader.this.merge(template, context);
                if (StringUtils.startsWithIgnoreCase((String)string, (String)"select")) {
                    String sql = string.replace("\r\n", " ");
                    return this.prepareSelectStatement(sql);
                }
                logger.info((Object)("template file \"" + template + "\" does not contain a SQL select statement"));
                return null;
            }
            logger.warn((Object)("template file \"" + template + "\" is missing"));
            return null;
        }

        protected SqlUtil.PreparedStatementWrapper prepareSelectStatement(String statement) {
            return new SqlUtil.PreparedStatementWrapper(SqlReader.this, statement);
        }

        protected String getTemplateName(String type) {
            return SqlReader.this._selectTemplatesPath + "/" + SqlReader.this._dbms + "/select-" + type + ".vm";
        }

        protected String getSqlTableName(ResultSet resultSet) throws SQLException {
            return resultSet.getString(1);
        }

        protected SqlTable getSqlTable(ResultSet resultSet) throws SQLException {
            SqlTable sqlTable = new SqlTable(SqlReader.this);
            sqlTable.setName(resultSet.getString(1));
            return sqlTable;
        }

        protected String getSqlColumnName(ResultSet resultSet) throws SQLException {
            return resultSet.getString(1);
        }

        protected SqlColumn getSqlColumn(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            SqlColumn sqlColumn = new SqlColumn(sqlTable);
            sqlColumn.setName(resultSet.getString(1));
            return sqlColumn;
        }

        protected String getSqlIndexName(ResultSet resultSet) throws SQLException {
            return resultSet.getString(1);
        }

        protected SqlIndex getSqlIndex(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            SqlIndex sqlIndex = new SqlIndex(sqlTable);
            sqlIndex.setName(resultSet.getString(1));
            return sqlIndex;
        }

        protected SqlIndex getSqlIndex(ResultSet resultSet, SqlIndex sqlIndex) throws SQLException {
            return sqlIndex;
        }

        protected String getSqlTabName(ResultSet resultSet) throws SQLException {
            return resultSet.getString(1);
        }

        protected SqlTab getSqlTab(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            SqlTab sqlTab = new SqlTab(sqlTable);
            sqlTab.setName(resultSet.getString(1));
            return sqlTab;
        }

        protected SqlTab getSqlTab(ResultSet resultSet, SqlTab sqlTab) throws SQLException {
            return sqlTab;
        }

        protected String getSqlRowName(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            int position = sqlTable.getBusinessKey().getPosition();
            return resultSet.getString(position);
        }

        protected SqlRow getSqlRow(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            int position = sqlTable.getBusinessKey().getPosition();
            String name = resultSet.getString(position);
            SqlRow sqlRow = new SqlRow(sqlTable);
            sqlRow.setName(name);
            for (SqlColumn sqlColumn : sqlTable.getColumns()) {
                Object object;
                String type;
                String column = sqlColumn.getName();
                switch (type = sqlColumn.getType()) {
                    case "boolean": 
                    case "char": 
                    case "string": 
                    case "byte": 
                    case "short": 
                    case "integer": 
                    case "long": 
                    case "decimal": 
                    case "float": 
                    case "double": {
                        object = resultSet.getObject(sqlColumn.getPosition());
                        break;
                    }
                    case "clob": {
                        object = resultSet.getClob(sqlColumn.getPosition());
                        break;
                    }
                    case "date": {
                        object = resultSet.getDate(sqlColumn.getPosition());
                        break;
                    }
                    case "time": {
                        object = resultSet.getTime(sqlColumn.getPosition());
                        break;
                    }
                    case "timestamp": {
                        object = resultSet.getTimestamp(sqlColumn.getPosition());
                        break;
                    }
                    default: {
                        object = null;
                    }
                }
                if (object == null) continue;
                String string = StrUtils.getString(object);
                SqlRowValue sqlRowValue = new SqlRowValue(sqlRow, sqlColumn);
                sqlRowValue.setName(column);
                sqlRowValue.setObject(object);
                sqlRowValue.setValue(string);
                sqlRow.add(sqlRowValue);
            }
            return sqlRow;
        }

        protected String getSqlRoutineName(ResultSet resultSet) throws SQLException {
            return resultSet.getString(1);
        }

        protected SqlRoutine getSqlRoutine(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            SqlRoutine sqlRoutine = new SqlRoutine(sqlTable);
            sqlRoutine.setName(resultSet.getString(1));
            return sqlRoutine;
        }

        protected SqlRoutine getSqlRoutine(ResultSet resultSet, SqlRoutine sqlRoutine) throws SQLException {
            return sqlRoutine;
        }

        protected void finalize(SqlTable sqlTable) {
            for (SqlColumn sqlColumn : sqlTable.getColumns()) {
                this.finalizeColumn(sqlColumn);
            }
            for (SqlRow sqlRow : sqlTable.getRows()) {
                for (SqlRowValue sqlRowValue : sqlRow.getValues()) {
                    this.finalizeRowValue(sqlRowValue);
                }
            }
            for (SqlRoutine sqlRoutine : sqlTable.getRoutines()) {
                for (SqlRoutineParameter sqlRoutineParameter : sqlRoutine.getParameters()) {
                    this.finalizeParameter(sqlRoutineParameter);
                }
            }
        }

        protected void finalizeColumn(SqlColumn sqlColumn) {
            String foreignTableName = sqlColumn.getForeignTableName();
            if (foreignTableName != null && SqlReader.this._tables.containsKey(foreignTableName)) {
                sqlColumn.setForeignTable(SqlReader.this._tables.get(foreignTableName));
            }
            sqlColumn.setDefault(this.stringValueOf(sqlColumn, sqlColumn.getDefault()));
        }

        protected void finalizeRowValue(SqlRowValue sqlRowValue) {
            sqlRowValue.setValue(this.stringValueOf(sqlRowValue.getColumn(), sqlRowValue.getValue()));
            sqlRowValue.setLiteral(this.literalOf(sqlRowValue.getObject()));
        }

        protected void finalizeParameter(SqlRoutineParameter sqlRoutineParameter) {
            sqlRoutineParameter.setDefault(this.stringValueOf(sqlRoutineParameter, sqlRoutineParameter.getDefault()));
        }

        protected int intValueOf(Object object) {
            return IntUtils.valueOf(NumUtils.newInteger(object));
        }

        protected boolean booleanValueOf(Object object) {
            return BitUtils.valueOf(object);
        }

        protected abstract String literalOf(Object var1);

        protected String stringValueOf(SqlColumn sqlColumn, String string) {
            String ctype = sqlColumn.getType();
            String value = StringUtils.trimToNull((String)string);
            return value == null ? null : (sqlColumn.getForeignTable() != null ? this.instanceValueOf(sqlColumn, string) : (sqlColumn.isForeign() ? null : (ctype.equals("date") ? null : (ctype.equals("time") ? null : (ctype.equals("timestamp") ? null : value)))));
        }

        protected String stringValueOf(SqlRoutineParameter sqlRoutineParameter, String string) {
            String ctype = sqlRoutineParameter.getType();
            SqlColumn namesake = sqlRoutineParameter.getNamesakeColumn();
            String value = StringUtils.trimToNull((String)string);
            return value == null ? null : (sqlRoutineParameter.getForeignTable() != null ? this.instanceValueOf(namesake, string) : (sqlRoutineParameter.isForeign() ? null : (ctype.equals("date") ? null : (ctype.equals("time") ? null : (ctype.equals("timestamp") ? null : value)))));
        }

        protected String instanceValueOf(SqlColumn sqlColumn, String string) {
            SqlColumn primaryKey;
            SqlTable foreignTable;
            String value = StringUtils.trimToNull((String)string);
            if (value != null && (foreignTable = sqlColumn.getForeignTable()) != null && (primaryKey = foreignTable.getPrimaryKey()) != null) {
                for (SqlRow sqlRow : foreignTable.getRows()) {
                    for (SqlRowValue sqlRowValue : sqlRow.getValues()) {
                        if (!primaryKey.equals(sqlRowValue.getColumn()) || !value.equals(sqlRowValue.getValue())) continue;
                        return sqlColumn.getDecapitalizedJavaName() + "." + sqlRow.getJavaConstantName();
                    }
                }
            }
            return null;
        }
    }
}

