/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.control.acceso;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.QuickAddingFilter;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.properties.LongProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.ModuloAplicacion;
import meta.entidad.comun.control.acceso.Usuario;

@EntityClass(independent=Kleenean.FALSE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.FEMININE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.TRUE)
@EntityDetailView(enabled=Kleenean.FALSE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
public class UsuarioModulo
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @ForeignKey(onDelete=OnDeleteAction.CASCADE, onUpdate=OnUpdateAction.CASCADE)
    @ManyToOne(navigability=Navigability.BIDIRECTIONAL, view=MasterDetailView.TABLE)
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(table=Kleenean.TRUE, detail=Kleenean.TRUE, report=Kleenean.TRUE, export=Kleenean.TRUE)
    public Usuario usuario;
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE, quickAdding=QuickAddingFilter.MISSING)
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(table=Kleenean.TRUE, detail=Kleenean.TRUE, report=Kleenean.TRUE, export=Kleenean.TRUE)
    public ModuloAplicacion modulo;
    protected Key uk_usuario_modulo_0001;
    protected Check checkUsuarioOrdinario;

    public UsuarioModulo(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings("usuario.grupo");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "user/module association");
        this.setLocalizedLabel(SPANISH, "asociaci\u00f3n Usuario/M\u00f3dulo");
        this.setLocalizedCollectionLabel(ENGLISH, "User/Module Associations");
        this.setLocalizedCollectionLabel(SPANISH, "Asociaciones Usuario/M\u00f3dulo");
        this.setLocalizedCollectionLabel(ENGLISH, this.usuario, "M\u00f3dulos by User");
        this.setLocalizedCollectionLabel(SPANISH, this.usuario, "M\u00f3dulos por Usuario");
        this.setLocalizedCollectionShortLabel(ENGLISH, this.usuario, "M\u00f3dulos");
        this.setLocalizedCollectionShortLabel(SPANISH, this.usuario, "M\u00f3dulos");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("User/Module Associations") + " represents a module associated with an application user.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Asociaciones Usuario/M\u00f3dulo") + " representa un m\u00f3dulo asociado con un usuario de la aplicaci\u00f3n.");
        this.setLocalizedShortDescription(ENGLISH, "module associated with an application user");
        this.setLocalizedShortDescription(SPANISH, "m\u00f3dulo asociado con un usuario de la aplicaci\u00f3n");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.usuario.setLocalizedLabel(ENGLISH, "user");
        this.usuario.setLocalizedLabel(SPANISH, "usuario");
        this.modulo.setLocalizedLabel(ENGLISH, "module");
        this.modulo.setLocalizedLabel(SPANISH, "m\u00f3dulo");
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
        this.linkForeignSegmentProperty(this.usuario.grupo);
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        this.uk_usuario_modulo_0001.setUnique(true);
        this.uk_usuario_modulo_0001.newKeyField(this.usuario, this.modulo);
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.checkUsuarioOrdinario = this.usuario.esUsuarioEspecial.isFalse();
        this.checkUsuarioOrdinario.setLocalizedDescription(ENGLISH, "the user is not a special user");
        this.checkUsuarioOrdinario.setLocalizedDescription(SPANISH, "el usuario no es un usuario especial");
        this.checkUsuarioOrdinario.setLocalizedErrorMessage(ENGLISH, "the user is a special user");
        this.checkUsuarioOrdinario.setLocalizedErrorMessage(SPANISH, "el usuario es un usuario especial");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.setInsertFilter(this.usuario.usuariosOrdinarios);
        this.setMasterDetailFilter(this.usuario.usuariosOrdinarios);
        this.modulo.setSearchQueryFilter(this.modulo.menusPredefinidos);
    }
}

