/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.operacion.basica;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceDisplay;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityTriggers;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.MasterSequence;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyAggregation;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.AggregateFunction;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.DefaultCondition;
import adalid.core.enums.EntityReferenceStyle;
import adalid.core.enums.Kleenean;
import adalid.core.enums.ListStyle;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.NextValueRule;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.QuickAddingFilter;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SearchType;
import adalid.core.expressions.NumericOrderedPairX;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Segment;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.ext.FuncionParametro;
import meta.entidad.comun.operacion.basica.TipoAgregacion;
import meta.entidad.comun.operacion.basica.VistaFuncion;

@EntityClass(base=Kleenean.TRUE, independent=Kleenean.FALSE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.FEMININE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.FALSE, rowsLimit=100, rows=100, writingViewWesternToolbarSnippet="/resources/snippets/base/entity/VistaFuncionCol/botonOpenMasterUpdateDialog")
@EntityDetailView(enabled=Kleenean.FALSE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
@EntityTriggers(afterValue=Kleenean.TRUE)
public class VistaFuncionCol
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @NameProperty
    @PropertyField(hidden=Kleenean.TRUE, defaultCondition=DefaultCondition.UNCONDITIONALLY, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    @StringField(maxLength=200)
    public StringProperty nombre;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.BIDIRECTIONAL, view=MasterDetailView.TABLE_AND_DETAIL)
    @ColumnField(nullable=Kleenean.FALSE)
    public VistaFuncion vista;
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE, quickAdding=QuickAddingFilter.MISSING)
    @ColumnField(nullable=Kleenean.FALSE)
    @EntityReferenceDisplay(style=EntityReferenceStyle.NAME)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME)
    @PropertyField(required=Kleenean.TRUE, table=Kleenean.TRUE, create=Kleenean.TRUE, update=Kleenean.FALSE)
    public FuncionParametro columna;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.FALSE, defaultCondition=DefaultCondition.UNCONDITIONALLY, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    @StringField(maxLength=200)
    public StringProperty alias;
    @PropertyField(table=Kleenean.TRUE, create=Kleenean.TRUE)
    @StringField(maxLength=30)
    public StringProperty etiqueta;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(required=Kleenean.FALSE, table=Kleenean.TRUE, create=Kleenean.TRUE)
    @MasterSequence(masterField="vista", start=10, step=10, nextValueRule=NextValueRule.CEILING)
    public IntegerProperty secuencia;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(required=Kleenean.FALSE, table=Kleenean.TRUE, create=Kleenean.TRUE)
    public TipoAgregacion agregacion;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @EntityReferenceDisplay(style=EntityReferenceStyle.NAME)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME)
    @PropertyField(required=Kleenean.FALSE, table=Kleenean.TRUE, create=Kleenean.TRUE)
    public VistaFuncionCol grupo;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(required=Kleenean.FALSE, table=Kleenean.TRUE, create=Kleenean.TRUE)
    public BooleanProperty orden;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(hidden=Kleenean.TRUE)
    public BooleanProperty visible;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(hidden=Kleenean.TRUE)
    public BooleanProperty graficable;
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(table=Kleenean.TRUE, create=Kleenean.TRUE, update=Kleenean.TRUE, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    @PropertyAggregation(function=AggregateFunction.CUSTOM_MADE)
    public IntegerProperty pixeles;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(hidden=Kleenean.TRUE, defaultCondition=DefaultCondition.UNCONDITIONALLY)
    public IntegerProperty detalle;
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(hidden=Kleenean.TRUE, defaultCheckpoint=Checkpoint.USER_INTERFACE, defaultCondition=DefaultCondition.UNCONDITIONALLY)
    @PropertyAggregation(function=AggregateFunction.CUSTOM_MADE)
    public IntegerProperty anchoPorMil;
    protected Key uk_vista_funcion_col_0001;
    protected Check check101;
    protected Segment conGrupo;
    protected Segment sinGrupo;
    protected Segment privadas;

    public VistaFuncionCol(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings("vista.funcion", "vista.propietario", "columna.funcion", "columna.parametro.tipoParametroDom", "columna.rangoAgregacion", "grupo.agregacion", "grupo.vista");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setOrderBy(this.vista, this.secuencia, this.id);
        this.setLocalizedLabel(ENGLISH, "view column");
        this.setLocalizedLabel(SPANISH, "columna de vista");
        this.setLocalizedShortLabel(ENGLISH, "column");
        this.setLocalizedShortLabel(SPANISH, "columna");
        this.setLocalizedCollectionLabel(ENGLISH, "View Columns");
        this.setLocalizedCollectionLabel(SPANISH, "Columnas de Vista");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Columns");
        this.setLocalizedCollectionShortLabel(SPANISH, "Columnas");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("View Columns") + " represents a column of a view defined by the user.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Columnas de Vista") + " representa una columna de una vista definida por el usuario.");
        this.setLocalizedShortDescription(ENGLISH, "column of view defined by the user");
        this.setLocalizedShortDescription(SPANISH, "columna de vista definida por el usuario");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.nombre.setDefaultValue(this.columna.nombreFuncionParametro);
        this.alias.setDefaultValue(this.columna.codigoFuncionParametro);
        this.secuencia.setMinValue(0);
        this.secuencia.setMaxValue(10000);
        this.agregacion.setInitialValue(this.columna.indice.isGreaterThan(0).and(this.columna.parametro.tipoParametroDom.isEqualTo(this.columna.parametro.tipoParametroDom.CODIGO)).then(this.agregacion.GRUPO));
        this.orden.setInitialValue(false);
        this.orden.setDefaultValue(false);
        this.visible.setInitialValue(true);
        this.visible.setDefaultValue(true);
        this.graficable.setInitialValue(true);
        this.graficable.setDefaultValue(true);
        NumericOrderedPairX anchoColumna = this.vista.anchoPagina.minus(this.vista.margenIzquierdo.plus(this.vista.margenDerecho));
        this.pixeles.setInitialValue(this.columna.parametro.pixeles);
        this.pixeles.setDefaultValue(this.columna.parametro.pixeles);
        this.pixeles.setMinValue(0);
        this.pixeles.setMaxValue(anchoColumna);
        this.pixeles.setPrimalMinValue(0);
        this.pixeles.setPrimalMaxValue(1260);
        this.detalle.setInitialValue(this.agregacion.isEqualTo(this.agregacion.GRUPO).or(this.grupo.isNotNull()).then(0).otherwise(this.pixeles));
        this.detalle.setDefaultValue(this.agregacion.isEqualTo(this.agregacion.GRUPO).or(this.grupo.isNotNull()).then(0).otherwise(this.pixeles));
        this.detalle.keepSumOn(this.vista.anchoDetalle);
        this.anchoPorMil.setInitialValue(this.pixeles.times(1000).over(anchoColumna).toInteger());
        this.anchoPorMil.setDefaultValue(this.pixeles.times(1000).over(anchoColumna).toInteger());
        this.anchoPorMil.setMinValue(0);
        this.anchoPorMil.setMaxValue(1000);
        this.nombre.setLocalizedLabel(ENGLISH, "view column name");
        this.nombre.setLocalizedLabel(SPANISH, "nombre de la columna de vista");
        this.nombre.setLocalizedShortLabel(ENGLISH, "name");
        this.nombre.setLocalizedShortLabel(SPANISH, "nombre");
        this.vista.setLocalizedLabel(ENGLISH, "view");
        this.vista.setLocalizedLabel(SPANISH, "vista");
        this.columna.setLocalizedLabel(ENGLISH, "column");
        this.columna.setLocalizedLabel(SPANISH, "columna");
        this.alias.setLocalizedLabel(ENGLISH, "alias");
        this.alias.setLocalizedLabel(SPANISH, "alias");
        this.etiqueta.setLocalizedLabel(ENGLISH, "label");
        this.etiqueta.setLocalizedLabel(SPANISH, "etiqueta");
        this.secuencia.setLocalizedLabel(ENGLISH, "sequence");
        this.secuencia.setLocalizedLabel(SPANISH, "secuencia");
        this.agregacion.setLocalizedLabel(ENGLISH, "aggregation");
        this.agregacion.setLocalizedLabel(SPANISH, "agregaci\u00f3n");
        this.agregacion.setLocalizedInitialValueTag(ENGLISH, "If " + this.b("index") + " of " + this.b("column") + " > 0 and " + this.b("type") + " of " + this.b("parameter") + " of " + this.b("column") + " = CODE then GROUP");
        this.agregacion.setLocalizedInitialValueTag(SPANISH, "S\u00ed " + this.b("\u00edndice") + " de " + this.b("columna") + " > 0 y " + this.b("tipo") + " de " + this.b("par\u00e1metro") + " de " + this.b("columna") + " = CODIGO entonces GRUPO");
        this.grupo.setLocalizedLabel(ENGLISH, "group");
        this.grupo.setLocalizedLabel(SPANISH, "grupo");
        this.orden.setLocalizedLabel(ENGLISH, "order");
        this.orden.setLocalizedLabel(SPANISH, "orden");
        this.visible.setLocalizedLabel(ENGLISH, "visible");
        this.visible.setLocalizedLabel(SPANISH, "visible");
        this.graficable.setLocalizedLabel(ENGLISH, "chartable");
        this.graficable.setLocalizedLabel(SPANISH, "graficable");
        this.pixeles.setLocalizedLabel(ENGLISH, "width");
        this.pixeles.setLocalizedLabel(SPANISH, "ancho");
        this.pixeles.setLocalizedTooltip(ENGLISH, "width of the column in pixels");
        this.pixeles.setLocalizedTooltip(SPANISH, "anchura de la columna expresada en pixeles");
        this.pixeles.setLocalizedAggregateTitle(ENGLISH, "pixels available for detail columns");
        this.pixeles.setLocalizedAggregateTitle(SPANISH, "pixeles disponibles para columnas del detalle");
        String english = this.b("pixels") + " of " + this.b("parameter") + " of " + this.b("column");
        String spanish = this.b("p\u00edxeles") + " de " + this.b("par\u00e1metro") + " de " + this.b("columna");
        this.pixeles.setLocalizedInitialValueTag(ENGLISH, english);
        this.pixeles.setLocalizedInitialValueTag(SPANISH, spanish);
        this.pixeles.setLocalizedDefaultValueTag(ENGLISH, english);
        this.pixeles.setLocalizedDefaultValueTag(SPANISH, spanish);
        this.pixeles.setLocalizedMaximumValueTag(ENGLISH, this.b("print area width") + " of " + this.b("view"));
        this.pixeles.setLocalizedMaximumValueTag(SPANISH, this.b("ancho de impresi\u00f3n") + " de " + this.b("vista"));
        this.detalle.setLocalizedLabel(ENGLISH, "width in detail");
        this.detalle.setLocalizedLabel(SPANISH, "ancho en el detalle");
        this.detalle.setLocalizedShortLabel(ENGLISH, "@detail");
        this.detalle.setLocalizedShortLabel(SPANISH, "@detalle");
        this.anchoPorMil.setLocalizedLabel(ENGLISH, "width \u2030");
        this.anchoPorMil.setLocalizedLabel(SPANISH, "ancho \u2030");
        this.anchoPorMil.setLocalizedShortLabel(ENGLISH, "\u2030");
        this.anchoPorMil.setLocalizedShortLabel(SPANISH, "\u2030");
        this.anchoPorMil.setLocalizedTooltip(ENGLISH, "column width as a fraction of 1000 (\u2030)");
        this.anchoPorMil.setLocalizedTooltip(SPANISH, "anchura de la columna expresada como una fracci\u00f3n de 1000 (\u2030)");
        this.anchoPorMil.setLocalizedAggregateTitle(ENGLISH, "per mille (\u2030) of the width available for detail columns");
        this.anchoPorMil.setLocalizedAggregateTitle(SPANISH, "por mil (\u2030) del ancho disponible para columnas del detalle");
        english = "1000 * " + this.b("pixels") + " / " + this.b("print area width") + " of " + this.b("view");
        spanish = "1000 * " + this.b("p\u00edxeles") + " / " + this.b("ancho de impresi\u00f3n") + " de " + this.b("vista");
        this.anchoPorMil.setLocalizedInitialValueTag(ENGLISH, english);
        this.anchoPorMil.setLocalizedInitialValueTag(SPANISH, spanish);
        this.anchoPorMil.setLocalizedDefaultValueTag(ENGLISH, english);
        this.anchoPorMil.setLocalizedDefaultValueTag(SPANISH, spanish);
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        this.uk_vista_funcion_col_0001.setUnique(true);
        this.uk_vista_funcion_col_0001.newKeyField(this.vista, this.columna);
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
        this.linkForeignOwnerProperty(this.vista.propietario);
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.check101 = this.grupo.isNotNull().implies(this.grupo.isNotEqualTo(this));
        this.conGrupo = this.agregacion.isEqualTo(this.agregacion.GRUPO).or(this.grupo.isNotNull());
        this.sinGrupo = this.agregacion.isNullOrNotEqualTo(this.agregacion.GRUPO).and(this.grupo.isNull());
        this.privadas = this.vista.publica.isFalse().and(this.vista.especial.isFalse());
        this.check101.setLocalizedLabel(ENGLISH, "check group");
        this.check101.setLocalizedLabel(SPANISH, "chequear grupo");
        this.check101.setLocalizedDescription(ENGLISH, "the group can not be the same column");
        this.check101.setLocalizedDescription(SPANISH, "el grupo no puede ser la misma columna");
        this.check101.setLocalizedErrorMessage(ENGLISH, "the group is the same column");
        this.check101.setLocalizedErrorMessage(SPANISH, "el grupo es la misma columna");
        this.conGrupo.setLocalizedCollectionLabel(ENGLISH, "columns that belong to one of the report groups");
        this.conGrupo.setLocalizedCollectionLabel(SPANISH, "columnas que pertenecen a uno de los grupos del informe");
        this.conGrupo.setLocalizedCollectionShortLabel(ENGLISH, "Group columns");
        this.conGrupo.setLocalizedCollectionShortLabel(SPANISH, "Columnas de grupo");
        this.sinGrupo.setLocalizedCollectionLabel(ENGLISH, "columns that belong to the report detail");
        this.sinGrupo.setLocalizedCollectionLabel(SPANISH, "columnas que pertenecen al detalle del informe");
        this.sinGrupo.setLocalizedCollectionShortLabel(ENGLISH, "Detail columns");
        this.sinGrupo.setLocalizedCollectionShortLabel(SPANISH, "Columnas del detalle");
        this.privadas.setLocalizedErrorMessage(ENGLISH, "the view is public or special");
        this.privadas.setLocalizedErrorMessage(SPANISH, "la vista es p\u00fablica o especial");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.setInsertFilter(this.vista.privadas);
        this.setUpdateFilter(this.privadas);
        this.setDeleteFilter(this.privadas);
        this.addSelectSegment(this.conGrupo, this.sinGrupo);
        this.columna.setSearchQueryFilter(this.columna.funcion.isEqualTo(this.vista.funcion).and(this.columna.parametro.pixeles.isGreaterThan(0)));
        this.agregacion.setSearchQueryFilter(this.agregacion.rangos.contains(this.columna.rangoAgregacion.numero));
        this.grupo.setSearchQueryFilter(this.grupo.agregacion.isEqualTo(this.grupo.agregacion.GRUPO).and(this.grupo.vista.isEqualTo(this.vista)));
    }
}

