/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.list;

import adalid.commons.bundles.Bundle;
import adalid.commons.list.ListOption;
import adalid.commons.list.ListOptionBean;
import adalid.commons.list.ListOptionLabelComparator;
import adalid.commons.list.ListOptionValueComparator;
import java.util.ArrayList;
import java.util.Collections;

public class ListOptions {
    private ArrayList<ListOption> list;
    private boolean addNullOption;
    private boolean sortedByLabel;
    boolean alreadySorted;

    public ListOptions(boolean anulable, boolean ordenado) {
        this.init(anulable, ordenado);
    }

    private void init(boolean anulable, boolean ordenado) {
        this.list = new ArrayList();
        this.addNullOption = anulable;
        this.sortedByLabel = ordenado;
        this.alreadySorted = true;
        if (this.addNullOption) {
            this.add("", Bundle.getString("null_value.string"));
        }
    }

    public boolean isAnulable() {
        return this.addNullOption;
    }

    public boolean isOrdenado() {
        return this.sortedByLabel;
    }

    public boolean add(ListOption option) {
        this.alreadySorted = false;
        return this.add(option.getOptionValue(), option.getOptionLabel(), option.getOptionDescription(), option.isOptionDisabled());
    }

    public boolean add(ListOption[] options) {
        boolean ok = true;
        for (ListOption option : options) {
            ok &= this.add(option);
        }
        return ok;
    }

    public boolean add(Object value, String label) {
        this.alreadySorted = false;
        return this.add(value, label, null);
    }

    public boolean add(Object value, String label, String description) {
        this.alreadySorted = false;
        return this.add(value, label, description, false);
    }

    public boolean add(Object value, String label, String description, boolean disabled) {
        this.alreadySorted = false;
        return this.list.add(new ListOptionBean(value, label, description, disabled));
    }

    public ArrayList<ListOption> getList() {
        this.sort();
        return this.list;
    }

    private void sort() {
        if (this.list.size() > 1 && !this.alreadySorted) {
            if (this.sortedByLabel) {
                Collections.sort(this.list, new ListOptionLabelComparator());
            } else {
                Collections.sort(this.list, new ListOptionValueComparator());
            }
            this.alreadySorted = true;
        }
    }
}

