/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.bundles.Bundle;
import adalid.commons.util.BitUtils;
import adalid.commons.util.ColUtils;
import adalid.commons.util.IntUtils;
import adalid.commons.util.ObjUtils;
import adalid.commons.util.StrUtils;
import adalid.commons.util.TimeUtils;
import adalid.core.AbstractArtifact;
import adalid.core.EntityCollection;
import adalid.core.ExportOperation;
import adalid.core.Key;
import adalid.core.NumericAggregate;
import adalid.core.Operation;
import adalid.core.Primitive;
import adalid.core.ProcessOperation;
import adalid.core.Project;
import adalid.core.ReportOperation;
import adalid.core.Step;
import adalid.core.StepField;
import adalid.core.TLC;
import adalid.core.Tab;
import adalid.core.TabField;
import adalid.core.TemporalAddend;
import adalid.core.WHR;
import adalid.core.XS1;
import adalid.core.annotations.BaseField;
import adalid.core.annotations.BigDecimalField;
import adalid.core.annotations.BigIntegerField;
import adalid.core.annotations.BooleanDataGen;
import adalid.core.annotations.BooleanField;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.CharacterDataGen;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DateField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.DiscriminatorColumn;
import adalid.core.annotations.EmbeddedDocument;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.GraphicImage;
import adalid.core.annotations.ImageProperty;
import adalid.core.annotations.InactiveIndicator;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.MasterSequence;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.NumericDataGen;
import adalid.core.annotations.NumericField;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.ParentProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyAggregation;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.SegmentProperty;
import adalid.core.annotations.SequenceProperty;
import adalid.core.annotations.StateProperty;
import adalid.core.annotations.StringField;
import adalid.core.annotations.TemporalDataGen;
import adalid.core.annotations.TimeField;
import adalid.core.annotations.TimestampField;
import adalid.core.annotations.UniformResourceLocator;
import adalid.core.annotations.UniqueKey;
import adalid.core.annotations.UrlProperty;
import adalid.core.annotations.UserProperty;
import adalid.core.annotations.VariantString;
import adalid.core.annotations.VersionProperty;
import adalid.core.comparators.ByParameterSequence;
import adalid.core.comparators.ByPropertyDisplaySortKey;
import adalid.core.data.types.BigDecimalData;
import adalid.core.data.types.BigIntegerData;
import adalid.core.data.types.BinaryData;
import adalid.core.data.types.BooleanData;
import adalid.core.data.types.ByteData;
import adalid.core.data.types.CharacterData;
import adalid.core.data.types.DateData;
import adalid.core.data.types.DoubleData;
import adalid.core.data.types.FloatData;
import adalid.core.data.types.IntegerData;
import adalid.core.data.types.LongData;
import adalid.core.data.types.ShortData;
import adalid.core.data.types.StringData;
import adalid.core.data.types.TimeData;
import adalid.core.data.types.TimestampData;
import adalid.core.enums.AggregateFunction;
import adalid.core.enums.AnchorType;
import adalid.core.enums.AutoComplete;
import adalid.core.enums.AvatarDefault;
import adalid.core.enums.AvatarShape;
import adalid.core.enums.BooleanDisplayType;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.DataGenNumericAction;
import adalid.core.enums.DataGenTemporalInterval;
import adalid.core.enums.DataGenType;
import adalid.core.enums.DefaultCondition;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.DivisorRule;
import adalid.core.enums.EmbeddedDocumentLoading;
import adalid.core.enums.EmbeddedDocumentPolicy;
import adalid.core.enums.EmbeddedDocumentSandbox;
import adalid.core.enums.EmbeddedDocumentStyle;
import adalid.core.enums.EmbeddedDocumentType;
import adalid.core.enums.EncodingType;
import adalid.core.enums.ExportQueryType;
import adalid.core.enums.InheritanceMappingStrategy;
import adalid.core.enums.KeyProperty;
import adalid.core.enums.LetterCase;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.MimeType;
import adalid.core.enums.NextValueRule;
import adalid.core.enums.NumericFieldType;
import adalid.core.enums.OperationKind;
import adalid.core.enums.PropertyAccess;
import adalid.core.enums.ReportQueryType;
import adalid.core.enums.RowsAggregateOp;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.enums.StandardRelationalOp;
import adalid.core.enums.SymbolPosition;
import adalid.core.enums.UploadStorageOption;
import adalid.core.enums.UrlDisplayType;
import adalid.core.enums.UrlType;
import adalid.core.expressions.CharacterConditionalX;
import adalid.core.interfaces.AnnotatableArtifact;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CalculableProperty;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.ContextualEntity;
import adalid.core.interfaces.DataArtifact;
import adalid.core.interfaces.DatabaseEntity;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityReference;
import adalid.core.interfaces.EnumerationEntity;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.IntervalizedArtifact;
import adalid.core.interfaces.Parameter;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.PersistentEnumerationEntity;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.TypedArtifact;
import adalid.core.parameters.BigDecimalParameter;
import adalid.core.parameters.BigIntegerParameter;
import adalid.core.parameters.BooleanParameter;
import adalid.core.parameters.DateParameter;
import adalid.core.parameters.StringParameter;
import adalid.core.parameters.TimeParameter;
import adalid.core.parameters.TimestampParameter;
import adalid.core.primitives.BinaryPrimitive;
import adalid.core.primitives.BooleanPrimitive;
import adalid.core.primitives.CharacterPrimitive;
import adalid.core.primitives.NumericPrimitive;
import adalid.core.primitives.TemporalPrimitive;
import adalid.core.properties.BigDecimalProperty;
import adalid.core.properties.BigIntegerProperty;
import adalid.core.properties.BinaryProperty;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.ByteProperty;
import adalid.core.properties.CharacterProperty;
import adalid.core.properties.DateProperty;
import adalid.core.properties.DoubleProperty;
import adalid.core.properties.FloatProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.ShortProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimeProperty;
import adalid.core.properties.TimestampProperty;
import adalid.core.wrappers.DataArtifactWrapper;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractDataArtifact
extends AbstractArtifact
implements AnnotatableArtifact,
DataArtifact,
Parameter,
CalculableProperty {
    private static final Logger logger = Logger.getLogger(DataArtifact.class);
    private static final String EOL = "\n";
    private static final int L = 0;
    private static final int M = 1;
    private static final int S = 2;
    public static final String CONVERTER_REGEX = "^[a-zA-Z]\\w*$";
    public static final String VALIDATOR_REGEX = "^[a-zA-Z]\\w*$";
    private Class<?> _dataClass;
    private Class<?> _dataType;
    private Class<?> _segmentEntityClass;
    private PropertyAccess _propertyAccess = PropertyAccess.UNSPECIFIED;
    private boolean _auditable = true;
    private boolean _password;
    private Boolean _required;
    private boolean _hiddenField;
    private Boolean _createField;
    private Boolean _updateField;
    private Boolean _searchField;
    private Boolean _filterField;
    private Boolean _sortField;
    private Boolean _tableField;
    private boolean _detailField = true;
    private Boolean _columnField;
    private Boolean _reportField;
    private Boolean _exportField;
    private boolean _headertextlessField;
    private Boolean _headingField;
    private Boolean _overlayField;
    private Boolean _prominentField;
    private Boolean _immutableField;
    Boolean _serializableField;
    Boolean _serializableIUID;
    private DefaultCondition _defaultCondition = DefaultCondition.IF_NULL;
    private Checkpoint _defaultCheckpoint = Checkpoint.UNSPECIFIED;
    private String _defaultFunction;
    private String _anchorFieldName;
    private Field _anchorField;
    private Property _anchorProperty;
    private Parameter _anchorParameter;
    private AnchorType _anchorType = AnchorType.UNLINKED;
    private AnchorType _firstAnchoredFieldAnchorType = AnchorType.UNLINKED;
    private boolean _anchoringLinkedDetailFields;
    private boolean _anchoringLinkedParameters;
    private final Map<Locale, String> _localizedAnchorLabel = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedAnchoredLabel = new LinkedHashMap<Locale, String>();
    private int _sequenceNumber;
    private String _displaySortKey = "";
    private AggregateFunction _aggregateFunction = AggregateFunction.UNSPECIFIED;
    private String _aggregateTitle = "";
    private final Map<Locale, String> _localizedAggregateTitle = new LinkedHashMap<Locale, String>();
    private boolean _calculable;
    private boolean _nullable = true;
    private boolean _insertable = true;
    private boolean _updateable = true;
    private boolean _unique;
    private boolean _indexed;
    private String _linkedFieldName;
    private Field _linkedField;
    private Entity _linkedEntity;
    private Property _linkedProperty;
    private String _linkedColumnName;
    private StandardRelationalOp _linkedColumnOperator = StandardRelationalOp.EQ;
    private String _masterHeadingSnippetFileName = "";
    private String _readingTableSnippetFileName = "";
    private String _writingTableSnippetFileName = "";
    private String _readingDetailSnippetFileName = "";
    private String _writingDetailSnippetFileName = "";
    private String _processingConsoleSnippetFileName = "";
    private String _missingValueGraphicImageName;
    private String _nullValueGraphicImageName;
    private String _unnecessaryValueGraphicImageName;
    private CharacterExpression _graphicImageNameExpression;
    private boolean _nullValueGraphicImageNameExpression;
    private boolean _graphicImageStyleClassNameExpression;
    private final Map<Locale, Map<String, String>> _localizedGraphicImageTooltip = new LinkedHashMap<Locale, Map<String, String>>();
    private long _sequencePropertyStart = 1L;
    private long _sequencePropertyStop = Long.MAX_VALUE;
    private long _sequencePropertyStep = 1L;
    DataGenType _dataGenType = DataGenType.UNSPECIFIED;
    private Boolean _loremIpsum;
    private int _dataGenSeriesStart = 1;
    private int _dataGenSeriesStop = 2100000000;
    private int _dataGenSeriesStep = 1;
    private String _dataGenFunction;
    int _dataGenNullable = 10;
    private int _dataGenTrueable = 50;
    private String _dataGenPattern;
    private String _dataGenPrefix;
    private String _dataGenSuffix;
    private String _dataGenMin;
    private String _dataGenMax;
    private TemporalAddend _dataGenMinTemporalAddend;
    private TemporalAddend _dataGenMaxTemporalAddend;
    private Object _dataGenMinValue;
    private Object _dataGenMaxValue;
    private DataGenTemporalInterval _dataGenTemporalInterval = DataGenTemporalInterval.UNSPECIFIED;
    private DataGenNumericAction _dataGenNumericAction = DataGenNumericAction.UNSPECIFIED;
    private Object _dataGenFactor;
    private boolean _renderingFilterReadOnly;
    private BooleanExpression _renderingFilter;
    private BooleanExpression _requiringFilter;
    private BooleanExpression _modifyingFilter;
    private BooleanExpression _nullifyingFilter;
    private boolean _annotatedWithBaseField;
    private boolean _annotatedWithPrimaryKey;
    private boolean _annotatedWithSequenceProperty;
    private boolean _annotatedWithVersionProperty;
    private boolean _annotatedWithNameProperty;
    private boolean _annotatedWithDescriptionProperty;
    private boolean _annotatedWithImageProperty;
    private boolean _annotatedWithInactiveIndicator;
    private boolean _annotatedWithUrlProperty;
    private boolean _annotatedWithParentProperty;
    private boolean _annotatedWithOwnerProperty;
    private boolean _annotatedWithUserProperty;
    private boolean _annotatedWithSegmentProperty;
    private boolean _annotatedWithUniqueKey;
    private boolean _annotatedWithBusinessKey;
    private boolean _annotatedWithDiscriminatorColumn;
    private boolean _annotatedWithStateProperty;
    private boolean _annotatedWithColumnField;
    private boolean _annotatedWithBigDecimalField;
    private boolean _annotatedWithBigIntegerField;
    private boolean _annotatedWithBooleanField;
    private boolean _annotatedWithNumericField;
    private boolean _annotatedWithStringField;
    private boolean _annotatedWithDateField;
    private boolean _annotatedWithTimeField;
    private boolean _annotatedWithTimestampField;
    private boolean _annotatedWithParameterField;
    private boolean _annotatedWithPropertyField;
    private boolean _annotatedWithPropertyAggregation;
    private boolean _annotatedWithInstanceReference;
    private boolean _annotatedWithEmbeddedDocument;
    private boolean _annotatedWithFileReference;
    private boolean _annotatedWithGraphicImage;
    private boolean _annotatedWithMasterSequence;
    private boolean _annotatedWithUniformResourceLocator;
    private boolean _annotatedWithVariantString;
    private boolean _annotatedWithDataGen;
    private final java.sql.Date currentDate = TimeUtils.currentDate();
    private final Time currentTime = TimeUtils.currentTime();
    private final Timestamp currentTimestamp = TimeUtils.currentTimestamp();
    private final List<Parameter> _initialValueReferencingParametersList = new ArrayList<Parameter>();
    private final List<Property> _initialValueReferencingPropertiesList = new ArrayList<Property>();
    private final Map<Locale, String> _localizedRenderingFilterTag = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedRequiringFilterTag = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedModifyingFilterTag = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedNullifyingFilterTag = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedCalculableValueTag = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedInitialValueTag = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedDefaultValueTag = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedCurrentValueTag = new LinkedHashMap<Locale, String>();
    private final List<NumericAggregate> _aggregates = new ArrayList<NumericAggregate>();

    @Override
    public String getSqlName() {
        if (this.isProperty()) {
            Entity declaringEntity = this.getDeclaringEntity();
            if (declaringEntity.isRootInstance()) {
                return super.getSqlName();
            }
            String name = this.getName();
            if (name != null) {
                Entity root = declaringEntity.getRoot();
                for (Property rootProperty : root.getPropertiesList()) {
                    if (!name.equals(rootProperty.getName())) continue;
                    return rootProperty.getSqlName();
                }
            }
        }
        return super.getSqlName();
    }

    public List<KeyProperty> getKeyProperties() {
        ArrayList<KeyProperty> list = new ArrayList<KeyProperty>();
        if (this.isPrimaryKeyProperty()) {
            list.add(KeyProperty.PRIMARY_KEY);
        }
        if (this.isSequenceProperty()) {
            list.add(KeyProperty.SEQUENCE);
        }
        if (this.isVersionProperty()) {
            list.add(KeyProperty.VERSION);
        }
        if (this.isNumericKeyProperty()) {
            list.add(KeyProperty.NUMERIC_KEY);
        }
        if (this.isCharacterKeyProperty()) {
            list.add(KeyProperty.CHARACTER_KEY);
        }
        if (this.isNameProperty()) {
            list.add(KeyProperty.NAME);
        }
        if (this.isDescriptionProperty()) {
            list.add(KeyProperty.DESCRIPTION);
        }
        if (this.isImageProperty()) {
            list.add(KeyProperty.IMAGE);
        }
        if (this.isInactiveIndicatorProperty()) {
            list.add(KeyProperty.INACTIVE_INDICATOR);
        }
        if (this.isUrlProperty()) {
            list.add(KeyProperty.URL);
        }
        if (this.isParentProperty()) {
            list.add(KeyProperty.PARENT);
        }
        if (this.isOwnerProperty()) {
            list.add(KeyProperty.OWNER);
        }
        if (this.isUserProperty()) {
            list.add(KeyProperty.USER);
        }
        if (this.isSegmentProperty()) {
            list.add(KeyProperty.SEGMENT);
        }
        if (this.isUniqueKeyProperty()) {
            list.add(KeyProperty.UNIQUE_KEY);
        }
        if (this.isBusinessKeyProperty()) {
            list.add(KeyProperty.BUSINESS_KEY);
        }
        if (this.isDiscriminatorProperty()) {
            list.add(KeyProperty.DISCRIMINATOR);
        }
        if (this.isStateProperty()) {
            list.add(KeyProperty.STATE);
        }
        return list;
    }

    @Override
    public Property getPropertyAtRoot() {
        if (this.isProperty()) {
            Entity declaringEntity = this.getDeclaringEntity();
            if (declaringEntity.isRootInstance()) {
                return this;
            }
            String name = this.getName();
            if (name != null) {
                Entity root = declaringEntity.getRoot();
                for (Property property : root.getPropertiesList()) {
                    if (!name.equals(property.getName())) continue;
                    return property;
                }
            }
        }
        return null;
    }

    @Override
    public Class<?> getDataClass() {
        return this._dataClass;
    }

    void setDataClass(Class<?> clazz) {
        this._dataClass = clazz;
    }

    @Override
    public Class<?> getDataType() {
        return this._dataType;
    }

    void setDataType(Class<?> type) {
        this._dataType = type;
    }

    @Override
    public Class<?> getSegmentEntityClass() {
        return this._segmentEntityClass == null ? null : (this._segmentEntityClass.equals(Entity.class) ? this.getDataType() : this._segmentEntityClass);
    }

    @Override
    public Long getSerialVersionUID() {
        return this.getSerialVersionUID(this.getDataClass());
    }

    protected Long getSerialVersionUID(Class<?> dataClass) {
        ObjectStreamClass objectStreamClass = dataClass == null ? null : ObjectStreamClass.lookup(dataClass);
        return objectStreamClass == null ? null : Long.valueOf(objectStreamClass.getSerialVersionUID());
    }

    @Override
    public boolean isBaseField() {
        return this._annotatedWithBaseField || this.isPrimaryKeyProperty();
    }

    @Override
    public boolean isKeyField() {
        return this.isPrimaryKeyProperty() || this.isSequenceProperty() || this.isUniqueKeyProperty() || this.isBusinessKeyProperty() || this.isCharacterKeyProperty() || this.isNumericKeyProperty();
    }

    @Override
    public PropertyAccess getPropertyAccess() {
        return this._password ? PropertyAccess.RESTRICTED_READING : (this._propertyAccess == null || this._propertyAccess.equals((Object)PropertyAccess.UNSPECIFIED) ? PropertyAccess.UNRESTRICTED : this._propertyAccess);
    }

    private boolean unrestrictedReadingField() {
        return !this.restrictedReadingField();
    }

    private boolean restrictedReadingField() {
        return this.restrictedReadingAccess() || this.isFileReferenceField();
    }

    private boolean restrictedReadingAccess() {
        return PropertyAccess.RESTRICTED_READING.equals((Object)this.getPropertyAccess());
    }

    protected void setPropertyAccess(PropertyAccess propertyAccess) {
        this._propertyAccess = this.coalesce(propertyAccess, PropertyAccess.UNSPECIFIED);
    }

    @Override
    public boolean isAuditable() {
        return this._auditable && !this._password && !this.isBinaryData();
    }

    protected void setAuditable(boolean auditable) {
        this._auditable = auditable;
    }

    @Override
    public boolean isPassword() {
        return this._password;
    }

    protected void setPassword(boolean password) {
        this._password = password;
    }

    @Override
    public boolean isReadOnly() {
        return !this.isCreateField() && !this.isUpdateField();
    }

    protected Boolean isRequired() {
        return this.isParameter() ? Boolean.valueOf(this.isRequiredParameter()) : (this.isProperty() ? Boolean.valueOf(this.isRequiredProperty()) : this.coalesce(this._required, false));
    }

    @Override
    public boolean isRequiredParameter() {
        return !this.isHiddenField() && !this.isBinaryData() && BitUtils.valueOf(this._required);
    }

    @Override
    public boolean isRequiredProperty() {
        return !this.isHiddenField() && !this.isBinaryData() && BitUtils.valueOf(this._required, this.implicitRequiredProperty());
    }

    private boolean implicitRequiredProperty() {
        return !this._calculable && !this._nullable && !this.isDiscriminatorProperty() && this.getDefaultValue() == null;
    }

    protected void setRequired(Boolean required) {
        this._required = required;
    }

    @Override
    public boolean isHiddenField() {
        return this._hiddenField;
    }

    @Override
    public boolean isHiddenEntityReferenceField() {
        return this.isHiddenField() && this.isEntity();
    }

    protected void setHiddenField(boolean hiddenField) {
        this._hiddenField = hiddenField;
    }

    @Override
    public boolean isCreateField() {
        return !this.isHiddenField() && !this.isPrimaryKeyProperty() && !this.isSequenceProperty() && !this.isVersionProperty() && !this.isBinaryData() && (this._calculable ? !this.isFileReferenceFieldWithoutBlob() : this._insertable) && BitUtils.valueOf(this._createField, this.implicitCreateField());
    }

    private boolean implicitCreateField() {
        return this.isInsertable() && !this.defaultUnconditionallyOnInsert() && this.isUnlinkedProperty() && this.isRequiredProperty() && !this.isEnumerationEntityProperty();
    }

    private boolean defaultUnconditionallyOnInsert() {
        return this.getDefaultValue() != null && (DefaultCondition.UNCONDITIONALLY.equals((Object)this._defaultCondition) || DefaultCondition.UNCONDITIONALLY_ON_INSERT.equals((Object)this._defaultCondition));
    }

    protected void setCreateField(Boolean createField) {
        this._createField = createField;
    }

    @Override
    public boolean isUpdateField() {
        return !this.isHiddenField() && !this.isPrimaryKeyProperty() && !this.isSequenceProperty() && !this.isVersionProperty() && !this.isBinaryData() && (this._calculable ? !this.isFileReferenceFieldWithoutBlob() : this._updateable) && BitUtils.valueOf(this._updateField, this.implicitUpdateField());
    }

    private boolean implicitUpdateField() {
        return this.isUpdateable() && !this.defaultUnconditionallyOnUpdate() && this.isUnlinkedProperty() && !this.isEnumerationEntityProperty();
    }

    private boolean defaultUnconditionallyOnUpdate() {
        return this.getDefaultValue() != null && (DefaultCondition.UNCONDITIONALLY.equals((Object)this._defaultCondition) || DefaultCondition.UNCONDITIONALLY_ON_UPDATE.equals((Object)this._defaultCondition));
    }

    private boolean isUnlinkedProperty() {
        if (this.isProperty()) {
            Entity declaringEntity = this.getDeclaringEntity();
            List<Operation> businessOperationsList = declaringEntity.getBusinessOperationsList();
            for (Operation operation : businessOperationsList) {
                if (!(operation instanceof ProcessOperation) || !OperationKind.INSTANCE.equals((Object)operation.getOperationKind())) continue;
                List<Parameter> parametersList = operation.getParametersList();
                for (Parameter parameter : parametersList) {
                    if (!this.equals(parameter.getLinkedProperty())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected void setUpdateField(Boolean updateField) {
        this._updateField = updateField;
    }

    @Override
    public boolean isSearchField() {
        return !this.isHiddenField() && !this.isBinaryData() && !this.isCharacterLargeObject() && !this.isVariantStringField() && !this._password && BitUtils.valueOf(this._searchField, this.implicitSearchField());
    }

    private boolean implicitSearchField() {
        return this.implicitSearchFieldDisjunction() && this.unrestrictedReadingField();
    }

    private boolean implicitSearchFieldDisjunction() {
        return this.isTableField() || this.isUniqueKeyProperty() || this.isBusinessKeyProperty() || this.isCharacterKeyProperty() || this.isNumericKeyProperty() || this.isDiscriminatorProperty() || this.isNameProperty() || this.isInactiveIndicatorProperty();
    }

    protected void setSearchField(Boolean searchField) {
        this._searchField = searchField;
    }

    @Override
    public boolean isFilterField() {
        return !this.isHiddenField() && !this.isBinaryData() && !this.isCharacterLargeObject() && !this.isVariantStringField() && !this._password && BitUtils.valueOf(this._filterField, this.implicitFilterField());
    }

    private boolean implicitFilterField() {
        return this.isSearchField() || this.unrestrictedReadingField();
    }

    protected void setFilterField(Boolean filterField) {
        this._filterField = filterField;
    }

    @Override
    public boolean isSortField() {
        return !this.isHiddenField() && !this.isBinaryData() && !this.isCharacterLargeObject() && !this._password && BitUtils.valueOf(this._sortField, this.unrestrictedReadingField());
    }

    protected void setSortField(Boolean sortField) {
        this._sortField = sortField;
    }

    @Override
    public boolean isTableField() {
        return !this.isHiddenField() && !this.isUndisplayableBinaryData() && !this._password && BitUtils.valueOf(this._tableField, this.implicitTableField());
    }

    private boolean implicitTableField() {
        return this.isRequiredProperty() || this.isUniqueKeyProperty() || this.isBusinessKeyProperty() || this.isCharacterKeyProperty() || this.isNumericKeyProperty() || this.isDiscriminatorProperty() || this.isNameProperty() || this.isStateProperty() || this.isInactiveIndicatorProperty();
    }

    private boolean requiredTableField() {
        return this.isTableField() && this.isRequiredProperty();
    }

    protected void setTableField(Boolean tableField) {
        this._tableField = tableField;
    }

    @Override
    public boolean isDetailField() {
        return !this.isHiddenField() && !this.isUndisplayableBinaryData() && this._detailField;
    }

    protected void setDetailField(boolean detailField) {
        this._detailField = detailField;
    }

    @Override
    public boolean isColumnField() {
        return !this.isHiddenField() && !this.isBinaryData() && !this._password && BitUtils.valueOf(this._columnField, !this.isFileReferenceField());
    }

    protected void setColumnField(Boolean columnField) {
        this._columnField = columnField;
    }

    @Override
    public boolean isReportField() {
        return !this.isHiddenField() && !this.isBinaryData() && !this._password && BitUtils.valueOf(this._reportField, this.implicitReportField());
    }

    private boolean implicitReportField() {
        return this.implicitReportFieldDisjunction() && this.unrestrictedReadingField();
    }

    private boolean implicitReportFieldDisjunction() {
        return this.isRequiredProperty() || this.isUniqueKeyProperty() || this.isBusinessKeyProperty() || this.isCharacterKeyProperty() || this.isNumericKeyProperty() || this.isDiscriminatorProperty() || this.isNameProperty() || this.isInactiveIndicatorProperty();
    }

    protected void setReportField(Boolean reportField) {
        this._reportField = reportField;
    }

    @Override
    public boolean isExportField() {
        return !this.isHiddenField() && !this.isBinaryData() && !this._password && BitUtils.valueOf(this._exportField, this.unrestrictedReadingField());
    }

    protected void setExportField(Boolean exportField) {
        this._exportField = exportField;
    }

    @Override
    public boolean isHeadertextlessField() {
        return !this.isHiddenField() && !this.isBinaryData() && this._headertextlessField;
    }

    protected void setHeadertextlessField(boolean headertextlessField) {
        this._headertextlessField = headertextlessField;
    }

    @Override
    public boolean isHeadingField() {
        return !this.isHiddenField() && !this.isUndisplayableBinaryData() && !this.isCharacterLargeObject() && !this.isVariantStringField() && this.unrestrictedReadingField() && !this._password && BitUtils.valueOf(this._headingField, this.implicitHeadingField());
    }

    private boolean implicitHeadingField() {
        return this.isBusinessKeyProperty() || this.isNameProperty() || this.isDiscriminatorProperty() || this.isInactiveIndicatorProperty() || this.isUniqueKeyProperty() || this.isCharacterKeyProperty() || this.isNumericKeyProperty() || this.isStateProperty() || this.isCodelessNamelessEntityUniqueKeyProperty();
    }

    protected void setHeadingField(Boolean headingField) {
        this._headingField = headingField;
    }

    @Override
    public boolean isOverlayField() {
        return !this.isHiddenField() && !this.isUndisplayableBinaryData() && !this.isCharacterLargeObject() && !this.isVariantStringField() && this.unrestrictedReadingField() && !this._password && BitUtils.valueOf(this._overlayField, this.implicitOverlayField());
    }

    private boolean implicitOverlayField() {
        return this.implicitOverlayFieldDisjunction();
    }

    private boolean implicitOverlayFieldDisjunction() {
        if (this.isBusinessKeyProperty() || this.isNameProperty()) {
            return false;
        }
        return this.isImplicitOverlayImageProperty() || this.isDiscriminatorProperty() || this.isStateProperty() || this.isInactiveIndicatorProperty() || this.isUniqueKeyProperty() || this.isCharacterKeyProperty() || this.isNumericKeyProperty() || this.isCodelessNamelessEntityUniqueKeyProperty();
    }

    protected boolean isImplicitOverlayImageProperty() {
        return this.isImageProperty();
    }

    private boolean isCodelessNamelessEntityUniqueKeyProperty() {
        PersistentEntity pent = this.getDeclaringPersistentEntityRoot();
        return pent != null && pent.getBusinessKeyProperty() == null && pent.getNameProperty() == null && pent.getUniqueKeyPropertiesList().contains(this);
    }

    protected void setOverlayField(Boolean overlayField) {
        this._overlayField = overlayField;
    }

    public boolean isProminentField() {
        return !this.isHiddenField() && !this.isUndisplayableBinaryData() && !this.restrictedReadingAccess() && BitUtils.valueOf(this._prominentField, this.implicitProminentField());
    }

    private boolean implicitProminentField() {
        return this.requiredTableField() || this.isBusinessKeyProperty() || this.isCharacterKeyProperty() || this.isNumericKeyProperty() || this.isUniqueKeyProperty() || this.isDiscriminatorProperty() || this.isInactiveIndicatorProperty() || this.isNameProperty() || this.isOwnerProperty() || this.isParentProperty() || this.isSegmentProperty() || this.isStateProperty() || this.isHeadingField();
    }

    protected void setProminentField(Boolean prominentField) {
        this._prominentField = prominentField;
    }

    @Override
    public boolean isImmutableField() {
        return !this.isUpdateField() && BitUtils.valueOf(this._immutableField);
    }

    protected void setImmutableField(Boolean immutableField) {
        this._immutableField = immutableField;
    }

    @Override
    public boolean isSerializableField() {
        return BitUtils.valueOf(this._serializableField, this.implicitSerializableField());
    }

    private boolean implicitSerializableField() {
        return !this.isCalculable() && !this.isPassword() && !this.isBinaryData();
    }

    @Override
    public boolean isTransientField() {
        return !this.isSerializableField();
    }

    protected void setSerializableField(Boolean serializableField) {
        this._serializableField = serializableField;
    }

    @Override
    public boolean isSerializableIUID() {
        return this.isEntity() && BitUtils.valueOf(this._serializableIUID, this.isTransientField());
    }

    protected void setSerializableIUID(Boolean serializableIUID) {
        this._serializableIUID = serializableIUID;
    }

    @Override
    public DefaultCondition getDefaultCondition() {
        return this._defaultCondition;
    }

    protected void setDefaultCondition(DefaultCondition defaultCondition) {
        this._defaultCondition = this.coalesce(defaultCondition, DefaultCondition.IF_NULL);
    }

    @Override
    public Checkpoint getDefaultCheckpoint() {
        return this._defaultCheckpoint == null || this._defaultCheckpoint.equals((Object)Checkpoint.UNSPECIFIED) ? Checkpoint.WHEREVER_POSSIBLE : this._defaultCheckpoint;
    }

    Checkpoint defaultCheckpoint() {
        return this.coalesce(this._defaultCheckpoint, Checkpoint.UNSPECIFIED);
    }

    protected void setDefaultCheckpoint(Checkpoint defaultCheckpoint) {
        this._defaultCheckpoint = this.coalesce(defaultCheckpoint, Checkpoint.UNSPECIFIED);
    }

    @Override
    public String getDefaultFunction() {
        return this._defaultFunction;
    }

    protected void setDefaultFunction(String defaultFunction) {
        this._defaultFunction = StringUtils.trimToNull((String)defaultFunction);
    }

    @Override
    public String getAnchorFieldName() {
        return this._anchorFieldName;
    }

    @Override
    public Field getAnchorField() {
        return this._anchorField;
    }

    @Override
    public Property getAnchorProperty() {
        return this._anchorProperty;
    }

    @Override
    public Parameter getAnchorParameter() {
        return this._anchorParameter;
    }

    @Override
    public AnchorType getAnchorType() {
        return this._anchorType;
    }

    @Override
    public AnchorType getFirstAnchoredFieldAnchorType() {
        return this._firstAnchoredFieldAnchorType;
    }

    @Override
    public void setFirstAnchoredFieldAnchorType(AnchorType anchorType) {
        this._firstAnchoredFieldAnchorType = anchorType;
    }

    @Override
    public boolean isAnchoringLinkedDetailFields() {
        return this._anchoringLinkedDetailFields;
    }

    @Override
    public void setAnchoringLinkedDetailFields(boolean b) {
        this._anchoringLinkedDetailFields = b;
    }

    @Override
    public boolean isAnchoringLinkedParameters() {
        return this._anchoringLinkedParameters;
    }

    @Override
    public void setAnchoringLinkedParameters(boolean b) {
        this._anchoringLinkedParameters = b;
    }

    @Override
    public String getDefaultAnchorLabel() {
        return this.getLocalizedAnchorLabel(null);
    }

    @Override
    public void setDefaultAnchorLabel(String defaultAnchorLabel) {
        this.setLocalizedAnchorLabel(null, defaultAnchorLabel);
    }

    @Override
    public String getLocalizedAnchorLabel(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedAnchorLabel.get(l);
    }

    @Override
    public void setLocalizedAnchorLabel(Locale locale, String localizedAnchorLabel) {
        Locale l = this.localeWritingKey(locale);
        if (localizedAnchorLabel == null) {
            this._localizedAnchorLabel.remove(l);
        } else {
            this._localizedAnchorLabel.put(l, localizedAnchorLabel);
        }
    }

    @Override
    public String getDefaultAnchoredLabel() {
        return this.getLocalizedAnchoredLabel(null);
    }

    @Override
    public void setDefaultAnchoredLabel(String defaultAnchoredLabel) {
        this.setLocalizedAnchoredLabel(null, defaultAnchoredLabel);
    }

    @Override
    public String getLocalizedAnchoredLabel(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedAnchoredLabel.get(l);
    }

    @Override
    public void setLocalizedAnchoredLabel(Locale locale, String localizedAnchoredLabel) {
        Locale l = this.localeWritingKey(locale);
        if (localizedAnchoredLabel == null) {
            this._localizedAnchoredLabel.remove(l);
        } else {
            this._localizedAnchoredLabel.put(l, localizedAnchoredLabel);
        }
    }

    @Override
    protected void copyLocalizedStrings(Artifact artifact) {
        super.copyLocalizedStrings(artifact);
        if (artifact instanceof AbstractDataArtifact && artifact != this) {
            AbstractDataArtifact that = (AbstractDataArtifact)artifact;
            this._localizedAnchorLabel.clear();
            this._localizedAnchorLabel.putAll(that._localizedAnchorLabel);
            this._localizedAnchoredLabel.clear();
            this._localizedAnchoredLabel.putAll(that._localizedAnchoredLabel);
        }
    }

    @Override
    public int getSequenceNumber() {
        if (this._sequenceNumber == 0) {
            if (this.isParameter()) {
                Operation declaringOperation = this.getDeclaringOperation();
                List<Parameter> parameters = declaringOperation == null ? null : declaringOperation.getParametersList();
                return parameters == null || parameters.isEmpty() ? 0 : parameters.indexOf(this) + 1;
            }
            if (this.isProperty()) {
                Entity declaringEntity = this.getDeclaringEntity();
                List<Property> properties = declaringEntity == null ? null : declaringEntity.getPropertiesList();
                return properties == null || properties.isEmpty() ? 0 : properties.indexOf(this) + 1;
            }
        }
        return this._sequenceNumber;
    }

    @Override
    public String getDisplaySortKey() {
        return this._displaySortKey;
    }

    @Override
    public void setDisplaySortKey(String key) {
        this._displaySortKey = StringUtils.trimToEmpty((String)key);
    }

    @Override
    public AggregateFunction getAggregateFunction() {
        return AggregateFunction.UNSPECIFIED.equals((Object)this._aggregateFunction) ? null : this._aggregateFunction;
    }

    protected void setAggregateFunction(AggregateFunction aggregateFunction) {
        this._aggregateFunction = this.coalesce(aggregateFunction, AggregateFunction.UNSPECIFIED);
    }

    @Override
    public String getAggregateTitle() {
        return this._aggregateFunction == null ? "" : StrUtils.coalesce(this.getLocalizedAggregateTitle(null), this._aggregateFunction.getNameTag(), this._aggregateTitle);
    }

    protected void setAggregateTitle(String aggregateTitle) {
        this.setLocalizedAggregateTitle(null, StringUtils.trimToEmpty((String)aggregateTitle));
    }

    public String getLocalizedAggregateTitle(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedAggregateTitle.get(l);
    }

    public void setLocalizedAggregateTitle(Locale locale, String localizedAggregateTitle) {
        Locale l = this.localeWritingKey(locale);
        if (localizedAggregateTitle == null) {
            this._localizedAggregateTitle.remove(l);
        } else {
            this._localizedAggregateTitle.put(l, localizedAggregateTitle);
        }
    }

    @Override
    public boolean isCalculable() {
        return this._calculable || this.isCalculable(this.getDeclaringField());
    }

    protected boolean isCalculable(Field field) {
        ColumnField annotation = field == null ? null : field.getAnnotation(ColumnField.class);
        return annotation != null && annotation.calculable().toBoolean(this._calculable);
    }

    protected void setCalculable(boolean calculable) {
        this._calculable = calculable;
    }

    @Override
    public boolean isCalculatedProperty() {
        return this.calculatedProperty(this);
    }

    @Override
    public boolean isNullable() {
        return this._nullable;
    }

    protected void setNullable(boolean nullable) {
        this._nullable = nullable;
    }

    @Override
    public boolean isInsertable() {
        return this._insertable;
    }

    protected void setInsertable(boolean insertable) {
        this._insertable = insertable;
    }

    @Override
    public boolean isUpdateable() {
        return this._updateable;
    }

    protected void setUpdateable(boolean updateable) {
        this._updateable = updateable;
    }

    @Override
    public boolean isMandatoryForInsert() {
        return !this.isOptionalForInsert();
    }

    @Override
    public boolean isOptionalForInsert() {
        if (this.isCalculable() || this.isNullable()) {
            return true;
        }
        if (StringUtils.isNotBlank((String)this.getDefaultFunction()) || this.getDefaultValue() != null) {
            switch (this.getDefaultCheckpoint()) {
                case DATABASE_TRIGGER: 
                case WHEREVER_POSSIBLE: {
                    switch (this.getDefaultCondition()) {
                        case IF_NULL: 
                        case IF_NULL_ON_INSERT: 
                        case UNCONDITIONALLY: 
                        case UNCONDITIONALLY_ON_INSERT: {
                            return true;
                        }
                    }
                }
            }
            return true;
        }
        Entity declaringEntity = this.getDeclaringEntity();
        if (declaringEntity != null) {
            if (this.isSequenceProperty() || this.isVersionProperty()) {
                return true;
            }
            if (this.isPrimaryKeyProperty() && declaringEntity.isNonEnumerationEntity()) {
                return true;
            }
            if (this.isDiscriminatorProperty()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isUnique() {
        return this._unique || this._annotatedWithUniqueKey || this.isPrimaryKeyProperty() || this.isSequenceProperty() || this.isBusinessKeyProperty() || this.isCharacterKeyProperty() || this.isNumericKeyProperty();
    }

    protected void setUnique(boolean unique) {
        this._unique = unique;
    }

    @Override
    public boolean isIndexed() {
        return this._indexed || this.isNameProperty() || this.isIndexableEntityReference();
    }

    protected void setIndexed(boolean indexed) {
        this._indexed = indexed;
    }

    protected boolean isIndexableEntityReference() {
        return this.isEntity() && ((Entity)((Object)this)).getRoot().isInvariantEntity();
    }

    @Override
    public boolean isInstanceReferenceField() {
        return this._annotatedWithInstanceReference;
    }

    @Override
    public boolean isEmbeddedDocumentField() {
        return this._annotatedWithEmbeddedDocument;
    }

    @Override
    public boolean isFileReferenceField() {
        return this._annotatedWithFileReference;
    }

    private boolean isFileReferenceFieldWithoutBlob() {
        if (this.isFileReferenceField() && this.isStringData()) {
            StringData data = (StringData)this;
            Property blobProperty = data.getBlobProperty();
            return blobProperty == null || blobProperty.isCalculable() || blobProperty.isCalculatedProperty();
        }
        return false;
    }

    @Override
    public boolean isGraphicImageField() {
        return this._annotatedWithGraphicImage || this._annotatedWithImageProperty;
    }

    @Override
    public boolean isMasterSequenceField() {
        return this._annotatedWithMasterSequence;
    }

    @Override
    public boolean isUniformResourceLocatorField() {
        return this._annotatedWithUniformResourceLocator;
    }

    @Override
    public boolean isVariantStringField() {
        return this._annotatedWithVariantString;
    }

    @Override
    public String getLinkedFieldName() {
        return this._linkedFieldName;
    }

    @Override
    public Field getLinkedField() {
        return this._linkedField;
    }

    @Override
    public Property getLinkedProperty() {
        if (this._linkedProperty == null && this._linkedField != null && this._linkedEntity != null) {
            this._linkedProperty = XS1.getProperty(this._linkedField, this._linkedEntity, true);
        }
        return this._linkedProperty;
    }

    @Override
    public String getLinkedColumnName() {
        return this._linkedColumnName;
    }

    @Override
    public StandardRelationalOp getLinkedColumnOperator() {
        return this._linkedColumnOperator;
    }

    public String getMasterHeadingSnippetFileName() {
        return this._masterHeadingSnippetFileName;
    }

    protected void setMasterHeadingSnippetFileName(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            this._masterHeadingSnippetFileName = "";
        } else if (this.isValidSnippetFileName(fileName)) {
            this._masterHeadingSnippetFileName = fileName;
        } else if (this.isLoggableProperty()) {
            logger.error((Object)(this.getName() + " master heading snippet is invalid "));
            Project.increaseParserErrorCount();
        }
    }

    public String getReadingTableSnippetFileName() {
        return this._readingTableSnippetFileName;
    }

    protected void setReadingTableSnippetFileName(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            this._readingTableSnippetFileName = "";
        } else if (this.isValidSnippetFileName(fileName)) {
            this._readingTableSnippetFileName = fileName;
        } else if (this.isLoggableProperty()) {
            logger.error((Object)(this.getName() + " reading table snippet is invalid "));
            Project.increaseParserErrorCount();
        }
    }

    public String getWritingTableSnippetFileName() {
        return this._writingTableSnippetFileName;
    }

    protected void setWritingTableSnippetFileName(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            this._writingTableSnippetFileName = "";
        } else if (this.isValidSnippetFileName(fileName)) {
            this._writingTableSnippetFileName = fileName;
        } else if (this.isLoggableProperty()) {
            logger.error((Object)(this.getName() + " writing table snippet is invalid "));
            Project.increaseParserErrorCount();
        }
    }

    public String getReadingDetailSnippetFileName() {
        return this._readingDetailSnippetFileName;
    }

    protected void setReadingDetailSnippetFileName(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            this._readingDetailSnippetFileName = "";
        } else if (this.isValidSnippetFileName(fileName)) {
            this._readingDetailSnippetFileName = fileName;
        } else if (this.isLoggableProperty()) {
            logger.error((Object)(this.getName() + " reading detail snippet is invalid "));
            Project.increaseParserErrorCount();
        }
    }

    public String getWritingDetailSnippetFileName() {
        return this._writingDetailSnippetFileName;
    }

    protected void setWritingDetailSnippetFileName(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            this._writingDetailSnippetFileName = "";
        } else if (this.isValidSnippetFileName(fileName)) {
            this._writingDetailSnippetFileName = fileName;
        } else if (this.isLoggableProperty()) {
            logger.error((Object)(this.getName() + " writing detail snippet is invalid "));
            Project.increaseParserErrorCount();
        }
    }

    public String getProcessingConsoleSnippetFileName() {
        return this._processingConsoleSnippetFileName;
    }

    protected void setProcessingConsoleSnippetFileName(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            this._processingConsoleSnippetFileName = "";
        } else if (this.isValidSnippetFileName(fileName)) {
            this._processingConsoleSnippetFileName = fileName;
        } else if (this.isParameter()) {
            logger.error((Object)(this.getName() + " processing console snippet is invalid "));
            Project.increaseParserErrorCount();
        }
    }

    public String getMissingValueGraphicImageName() {
        if (this.isProperty() && this._nullable) {
            if (this._missingValueGraphicImageName != null) {
                return this._missingValueGraphicImageName;
            }
            return TLC.getProject().getMissingValueGraphicImageName();
        }
        return null;
    }

    public void setMissingValueGraphicImageName(String name) {
        this._missingValueGraphicImageName = this.fairGraphicImageName(name);
    }

    public boolean isMissingValueGraphicImageNameFontAwesomeClass() {
        return this.isFontAwesomeClass(this.getMissingValueGraphicImageName());
    }

    public String getNullValueGraphicImageName() {
        if (this.isProperty() && this._nullable) {
            if (this._nullValueGraphicImageName != null) {
                return this._nullValueGraphicImageName;
            }
            return TLC.getProject().getNullValueGraphicImageName();
        }
        return null;
    }

    public void setNullValueGraphicImageName(String name) {
        this._nullValueGraphicImageName = this.fairGraphicImageName(name);
    }

    public boolean isNullValueGraphicImageNameFontAwesomeClass() {
        return this.isFontAwesomeClass(this.getNullValueGraphicImageName());
    }

    @Override
    public void setNullValueGraphicImageExpression() {
        String name = this.getNullValueGraphicImageName();
        if (name != null && this._graphicImageNameExpression == null) {
            CharacterConditionalX expression = this.isNull().then(name);
            this._nullValueGraphicImageNameExpression = true;
            if (this.isFontAwesomeClass(name)) {
                this.setGraphicImageFontAwesomeClassNameExpression(expression);
            } else {
                this.setGraphicImageNameExpression(expression);
            }
            this.setNullValueGraphicImageTooltip(name, ENGLISH);
            this.setNullValueGraphicImageTooltip(name, SPANISH);
        }
    }

    public boolean isNullValueGraphicImageNameExpression() {
        return this._nullValueGraphicImageNameExpression;
    }

    private void setNullValueGraphicImageTooltip(String name, Locale locale) {
        String tooltip = Bundle.getTrimmedToNullString("BundleParametros.null.value.graphic.image.tooltip", locale);
        this.setLocalizedGraphicImageTooltip(locale, name, tooltip);
    }

    public String getUnnecessaryValueGraphicImageName() {
        if (this.isProperty()) {
            if (this._unnecessaryValueGraphicImageName != null) {
                return this._unnecessaryValueGraphicImageName;
            }
            return TLC.getProject().getUnnecessaryValueGraphicImageName();
        }
        return null;
    }

    public void setUnnecessaryValueGraphicImageName(String name) {
        this._unnecessaryValueGraphicImageName = this.fairGraphicImageName(name);
    }

    public boolean isUnnecessaryValueGraphicImageNameFontAwesomeClass() {
        return this.isFontAwesomeClass(this.getUnnecessaryValueGraphicImageName());
    }

    @Override
    public CharacterExpression getGraphicImageNameExpression() {
        return this._graphicImageNameExpression;
    }

    public void setGraphicImageNameExpression(CharacterExpression expression) {
        this._graphicImageStyleClassNameExpression = false;
        this.setGraphicImageNameCharacterExpression(expression);
    }

    public void setGraphicImageFontAwesomeClassNameExpression(CharacterExpression expression) {
        this.setGraphicImageStyleClassNameExpression(expression);
    }

    public void setGraphicImageStyleClassNameExpression(CharacterExpression expression) {
        this._graphicImageStyleClassNameExpression = true;
        this.setGraphicImageNameCharacterExpression(expression);
    }

    private void setGraphicImageNameCharacterExpression(CharacterExpression expression) {
        String message = "failed to set graphic image name expression of " + this.getFullName();
        if (this.isParameter()) {
            message = message + "; graphic image name expressions are not valid for parameters; setting ignored";
            logger.warn((Object)message);
            Project.increaseParserWarningCount();
        } else if (expression == null) {
            if (this.isLoggable()) {
                message = message + "; supplied expression is null";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
        } else {
            this._graphicImageNameExpression = expression;
        }
    }

    public boolean isGraphicImageFontAwesomeClassNameExpression() {
        return this.isGraphicImageStyleClassNameExpression();
    }

    public boolean isGraphicImageStyleClassNameExpression() {
        return this._graphicImageStyleClassNameExpression;
    }

    public String getDefaultGraphicImageTooltip(String graphicImageName) {
        return this.getLocalizedGraphicImageTooltip(null, graphicImageName);
    }

    public void setDefaultGraphicImageTooltip(String graphicImageName, String defaultTooltip) {
        this.setLocalizedGraphicImageTooltip(null, graphicImageName, defaultTooltip);
    }

    public Map<String, String> getDefaultGraphicImageTooltipMap() {
        return this.getLocalizedGraphicImageTooltipMap(null);
    }

    public String getLocalizedGraphicImageTooltip(Locale locale, String graphicImageName) {
        if (StringUtils.isBlank((String)graphicImageName)) {
            return null;
        }
        Locale l = this.localeReadingKey(locale);
        String g = StrUtils.escapeBundleKey(graphicImageName);
        Map<String, String> map = this._localizedGraphicImageTooltip.get(l);
        return map == null ? null : map.get(g);
    }

    public void setLocalizedGraphicImageTooltip(Locale locale, String graphicImageName, String localizedTooltip) {
        if (StringUtils.isBlank((String)graphicImageName)) {
            return;
        }
        Locale l = this.localeWritingKey(locale);
        String g = StrUtils.escapeBundleKey(graphicImageName);
        String t = StringUtils.trimToNull((String)localizedTooltip);
        Map<String, String> map = this._localizedGraphicImageTooltip.get(l);
        if (map == null) {
            if (t == null) {
                return;
            }
            map = new LinkedHashMap<String, String>();
            this._localizedGraphicImageTooltip.put(l, map);
        }
        if (t == null) {
            map.remove(g);
        } else {
            map.put(g, t);
        }
    }

    public Map<String, String> getLocalizedGraphicImageTooltipMap(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedGraphicImageTooltip.get(l);
    }

    public long getSequencePropertyStart() {
        return this._sequencePropertyStart;
    }

    public void setSequencePropertyStart(long value) {
        boolean log;
        boolean bl = log = this.depth() == 0;
        if (this.isSequenceProperty()) {
            this._sequencePropertyStart = Math.min(Long.MAX_VALUE, Math.max(1L, value));
            if (log && value != this._sequencePropertyStart) {
                logger.warn((Object)(this.getFullName() + ".setSequencePropertyStart argument is out of range; set to " + this._sequencePropertyStart));
                Project.increaseParserWarningCount();
            }
        } else if (log) {
            logger.warn((Object)("method setSequencePropertyStart is not valid for " + this.getFullName() + "; setting ignored"));
            Project.increaseParserWarningCount();
        }
    }

    public long getSequencePropertyStop() {
        return this._sequencePropertyStop;
    }

    public void setSequencePropertyStop(long value) {
        boolean log;
        boolean bl = log = this.depth() == 0;
        if (this.isSequenceProperty()) {
            this._sequencePropertyStop = Math.min(Long.MAX_VALUE, Math.max(1L, value));
            if (log && value != this._sequencePropertyStop) {
                logger.warn((Object)(this.getFullName() + ".setSequencePropertyStop argument is out of range; set to " + this._sequencePropertyStop));
                Project.increaseParserWarningCount();
            }
        } else if (log) {
            logger.warn((Object)("method setSequencePropertyStop is not valid for " + this.getFullName() + "; setting ignored"));
            Project.increaseParserWarningCount();
        }
    }

    public long getSequencePropertyStep() {
        return this._sequencePropertyStep;
    }

    public void setSequencePropertyStep(long value) {
        boolean log;
        boolean bl = log = this.depth() == 0;
        if (this.isSequenceProperty()) {
            this._sequencePropertyStep = Math.min(Long.MAX_VALUE, Math.max(1L, value));
            if (log && value != this._sequencePropertyStep) {
                logger.warn((Object)(this.getFullName() + ".setSequencePropertyStep argument is out of range; set to " + this._sequencePropertyStep));
                Project.increaseParserWarningCount();
            }
        } else if (log) {
            logger.warn((Object)("method setSequencePropertyStep is not valid for " + this.getFullName() + "; setting ignored"));
            Project.increaseParserWarningCount();
        }
    }

    public boolean isSequencePropertyEnabled() {
        return this._annotatedWithSequenceProperty && this.validStartStopStep(this._sequencePropertyStart, this._sequencePropertyStop, this._sequencePropertyStep);
    }

    @Override
    public boolean isSequencePropertyDataGenDisabled() {
        return !this.validStartStopStep(this._sequencePropertyStart, this._dataGenSeriesStop, this._sequencePropertyStep) || this._sequencePropertyStart > 2000000000L || this._sequencePropertyStep > 1000000L;
    }

    boolean validStartStopStep(long start, long stop, long step) {
        return start < stop && step <= stop - start;
    }

    public DataGenType getDataGenType() {
        return this._dataGenType;
    }

    public boolean isDataGenTypeSpecified() {
        return !DataGenType.UNSPECIFIED.equals((Object)this._dataGenType);
    }

    public Boolean isLoremIpsum() {
        return this._loremIpsum;
    }

    public int getDataGenSeriesStart() {
        return this._dataGenSeriesStart;
    }

    public int getDataGenSeriesStop() {
        return this._dataGenSeriesStop;
    }

    public int getDataGenSeriesStep() {
        return this._dataGenSeriesStep;
    }

    public boolean isDataGenSeriesEnabled() {
        return this._annotatedWithDataGen && this.validStartStopStep(this._dataGenSeriesStart, this._dataGenSeriesStop, this._dataGenSeriesStep);
    }

    public String getDataGenFunction() {
        return this._dataGenFunction;
    }

    public void setDataGenFunction(String function) {
        String f = StringUtils.trimToNull((String)function);
        if (f != null) {
            this._dataGenFunction = f.equalsIgnoreCase("null") ? null : f;
        } else if (this.isDataGenTypeSpecified()) {
            this._dataGenFunction = null;
        }
    }

    public int getDataGenNullable() {
        return this._dataGenNullable;
    }

    public int getDataGenTrueable() {
        return this._dataGenTrueable;
    }

    public String getDataGenPattern() {
        return this._dataGenPattern;
    }

    public String getDataGenPrefix() {
        return this._dataGenPrefix;
    }

    public String getDataGenSuffix() {
        return this._dataGenSuffix;
    }

    public String getDataGenMin() {
        return this._dataGenMin;
    }

    public TemporalAddend getDataGenMinTemporalAddend() {
        return this._dataGenMinTemporalAddend;
    }

    public Object getDataGenMinValue() {
        return this._dataGenMinValue;
    }

    public String getDataGenMax() {
        return this._dataGenMax;
    }

    public TemporalAddend getDataGenMaxTemporalAddend() {
        return this._dataGenMaxTemporalAddend;
    }

    public Object getDataGenMaxValue() {
        return this._dataGenMaxValue;
    }

    public DataGenTemporalInterval getDataGenTemporalInterval() {
        return this._dataGenTemporalInterval;
    }

    public DataGenNumericAction getDataGenNumericAction() {
        return this._dataGenNumericAction;
    }

    public Object getDataGenFactor() {
        return this._dataGenFactor == null && this.isNumericPrimitive() ? Integer.valueOf(1) : this._dataGenFactor;
    }

    @Override
    public boolean isRenderingFilterReadOnly() {
        return this._renderingFilterReadOnly;
    }

    @Override
    public BooleanExpression getRenderingFilter() {
        return this._renderingFilter;
    }

    @Override
    public void setRenderingFilter(BooleanExpression renderingFilter) {
        this.setRenderingFilter(renderingFilter, false);
    }

    @Override
    public void setRenderingFilter(BooleanExpression renderingFilter, boolean readOnly) {
        boolean log = this.isParameter() || this.isLoggableProperty();
        String message = "failed to set rendering filter of " + this.getFullName();
        if (renderingFilter == null) {
            if (log) {
                message = message + "; supplied expression is null";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
        } else {
            this._renderingFilter = renderingFilter instanceof BooleanPrimitive ? renderingFilter.isTrue() : renderingFilter;
        }
        this._renderingFilterReadOnly = readOnly;
    }

    @Override
    public BooleanExpression getRequiringFilter() {
        return this._requiringFilter;
    }

    @Override
    public void setRequiringFilter(BooleanExpression requiringFilter) {
        boolean log = this.isParameter() || this.isLoggableProperty();
        String message = "failed to set requiring filter of " + this.getFullName();
        if (requiringFilter == null) {
            if (log) {
                message = message + "; supplied expression is null";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
        } else {
            this._requiringFilter = requiringFilter instanceof BooleanPrimitive ? requiringFilter.isTrue() : requiringFilter;
        }
    }

    @Override
    public BooleanExpression getModifyingFilter() {
        return this._modifyingFilter;
    }

    @Override
    public void setModifyingFilter(BooleanExpression modifyingFilter) {
        boolean log = this.isParameter() || this.isLoggableProperty();
        String message = "failed to set modifying filter of " + this.getFullName();
        if (modifyingFilter == null) {
            if (log) {
                message = message + "; supplied expression is null";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
        } else {
            this._modifyingFilter = modifyingFilter instanceof BooleanPrimitive ? modifyingFilter.isTrue() : modifyingFilter;
        }
    }

    @Override
    public BooleanExpression getNullifyingFilter() {
        return this._nullifyingFilter;
    }

    @Override
    public void setNullifyingFilter(BooleanExpression nullifyingFilter) {
        boolean log = this.isParameter() || this.isLoggableProperty();
        String message = "failed to set nullifying filter of " + this.getFullName();
        if (nullifyingFilter == null) {
            if (log) {
                message = message + "; supplied expression is null";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
        } else {
            this._nullifyingFilter = nullifyingFilter instanceof BooleanPrimitive ? nullifyingFilter.isTrue() : nullifyingFilter;
        }
    }

    @Override
    public List<Step> getEnclosingSteps() {
        ArrayList<Step> list = new ArrayList<Step>();
        if (this.isProperty()) {
            Entity declaringEntity = this.getDeclaringEntity();
            List<Step> stepsList = declaringEntity.getStepsList();
            block0: for (Step step : stepsList) {
                List<StepField> stepFieldsList = step.getStepFieldsList();
                for (StepField stepField : stepFieldsList) {
                    Property sfp = stepField.getProperty();
                    if (sfp == null || !sfp.equals(this)) continue;
                    list.add(step);
                    continue block0;
                }
            }
        }
        return list;
    }

    public boolean isEnclosedInAtLeastOneStep() {
        if (this.isProperty()) {
            Entity declaringEntity = this.getDeclaringEntity();
            List<Step> stepsList = declaringEntity.getStepsList();
            for (Step step : stepsList) {
                List<StepField> stepFieldsList = step.getStepFieldsList();
                for (StepField stepField : stepFieldsList) {
                    Property sfp = stepField.getProperty();
                    if (sfp == null || !sfp.equals(this)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<Tab> getEnclosingTabs() {
        ArrayList<Tab> list = new ArrayList<Tab>();
        if (this.isProperty()) {
            Entity declaringEntity = this.getDeclaringEntity();
            List<Tab> tabsList = declaringEntity.getTabsList();
            block0: for (Tab tab : tabsList) {
                List<TabField> tabFieldsList = tab.getTabFieldsList();
                for (TabField tabField : tabFieldsList) {
                    Property tfp = tabField.getProperty();
                    if (tfp == null || !tfp.equals(this)) continue;
                    list.add(tab);
                    continue block0;
                }
            }
        }
        return list;
    }

    public boolean isEnclosedInAtLeastOneTab() {
        if (this.isProperty()) {
            Entity declaringEntity = this.getDeclaringEntity();
            List<Tab> tabsList = declaringEntity.getTabsList();
            for (Tab tab : tabsList) {
                List<TabField> tabFieldsList = tab.getTabFieldsList();
                for (TabField tabField : tabFieldsList) {
                    Property tfp = tabField.getProperty();
                    if (tfp == null || !tfp.equals(this)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isAnnotatedWithBaseField() {
        return this._annotatedWithBaseField;
    }

    public boolean isAnnotatedWithPrimaryKey() {
        return this._annotatedWithPrimaryKey;
    }

    public boolean isAnnotatedWithSequenceProperty() {
        return this._annotatedWithSequenceProperty;
    }

    public boolean isAnnotatedWithVersionProperty() {
        return this._annotatedWithVersionProperty;
    }

    public boolean isAnnotatedWithNameProperty() {
        return this._annotatedWithNameProperty;
    }

    public boolean isAnnotatedWithDescriptionProperty() {
        return this._annotatedWithDescriptionProperty;
    }

    public boolean isAnnotatedWithImageProperty() {
        return this._annotatedWithImageProperty;
    }

    public boolean isAnnotatedWithInactiveIndicator() {
        return this._annotatedWithInactiveIndicator;
    }

    public boolean isAnnotatedWithUrlProperty() {
        return this._annotatedWithUrlProperty;
    }

    public boolean isAnnotatedWithParentProperty() {
        return this._annotatedWithParentProperty;
    }

    public boolean isAnnotatedWithOwnerProperty() {
        return this._annotatedWithOwnerProperty;
    }

    public boolean isAnnotatedWithUserProperty() {
        return this._annotatedWithUserProperty;
    }

    public boolean isAnnotatedWithSegmentProperty() {
        return this._annotatedWithSegmentProperty;
    }

    public boolean isAnnotatedWithUniqueKey() {
        return this._annotatedWithUniqueKey;
    }

    public boolean isAnnotatedWithBusinessKey() {
        return this._annotatedWithBusinessKey;
    }

    public boolean isAnnotatedWithDiscriminatorColumn() {
        return this._annotatedWithDiscriminatorColumn;
    }

    public boolean isAnnotatedWithStateProperty() {
        return this._annotatedWithStateProperty;
    }

    public boolean isAnnotatedWithColumnField() {
        return this._annotatedWithColumnField;
    }

    public boolean isAnnotatedWithBigDecimalField() {
        return this._annotatedWithBigDecimalField;
    }

    public boolean isAnnotatedWithBigIntegerField() {
        return this._annotatedWithBigIntegerField;
    }

    public boolean isAnnotatedWithBooleanField() {
        return this._annotatedWithBooleanField;
    }

    public boolean isAnnotatedWithNumericField() {
        return this._annotatedWithNumericField;
    }

    public boolean isAnnotatedWithStringField() {
        return this._annotatedWithStringField;
    }

    public boolean isAnnotatedWithDateField() {
        return this._annotatedWithDateField;
    }

    public boolean isAnnotatedWithTimeField() {
        return this._annotatedWithTimeField;
    }

    public boolean isAnnotatedWithTimestampField() {
        return this._annotatedWithTimestampField;
    }

    public boolean isAnnotatedWithParameterField() {
        return this._annotatedWithParameterField;
    }

    public boolean isAnnotatedWithPropertyField() {
        return this._annotatedWithPropertyField;
    }

    public boolean isAnnotatedWithPropertyAggregation() {
        return this._annotatedWithPropertyAggregation;
    }

    public boolean isAnnotatedWithInstanceReference() {
        return this._annotatedWithInstanceReference;
    }

    public boolean isAnnotatedWithEmbeddedDocument() {
        return this._annotatedWithEmbeddedDocument;
    }

    public boolean isAnnotatedWithFileReference() {
        return this._annotatedWithFileReference;
    }

    public boolean isAnnotatedWithUniformResourceLocator() {
        return this._annotatedWithUniformResourceLocator;
    }

    public boolean isAnnotatedWithVariantString() {
        return this._annotatedWithVariantString;
    }

    public boolean isAnnotatedWithDataGen() {
        return this._annotatedWithDataGen;
    }

    @Override
    public boolean finish() {
        boolean ok = super.finish();
        if (ok) {
            this.checkColumnFieldElements();
        }
        return ok;
    }

    @Override
    void annotate(Class<?> type) {
        super.annotate(type);
    }

    @Override
    void annotate(Field field) {
        super.annotate(field);
        if (field != null) {
            if (this.isParameter()) {
                this.annotateBigDecimalField(field);
                this.annotateBigIntegerField(field);
                this.annotateBooleanField(field);
                this.annotateNumericField(field);
                this.annotateStringField(field);
                this.annotateDateField(field);
                this.annotateTimeField(field);
                this.annotateTimestampField(field);
                this.annotateParameterField(field);
                this.annotateFileReference(field);
                this.annotateInstanceReference(field);
            }
            if (this.isProperty()) {
                this.annotateKeyProperties(field);
                this.annotateBaseField(field);
                this.annotateColumnField(field);
                this.annotateBigDecimalField(field);
                this.annotateBigIntegerField(field);
                this.annotateBooleanField(field);
                this.annotateNumericField(field);
                this.annotateStringField(field);
                this.annotateDateField(field);
                this.annotateTimeField(field);
                this.annotateTimestampField(field);
                this.annotateEmbeddedDocument(field);
                this.annotateFileReference(field);
                this.annotateGraphicImage(field);
                this.annotateMasterSequenceProperty(field);
                this.annotateUniformResourceLocator(field);
                this.annotateVariantString(field);
                this.annotatePropertyField(field);
                this.annotatePropertyAggregation(field);
                this.annotateDataGen(field);
            }
        }
    }

    private void annotateKeyProperties(Field field) {
        this.annotatePrimaryKey(field);
        this.annotateSequenceProperty(field);
        this.annotateVersionProperty(field);
        this.annotateNameProperty(field);
        this.annotateDescriptionProperty(field);
        this.annotateImageProperty(field);
        this.annotateInactiveIndicator(field);
        this.annotateUrlProperty(field);
        this.annotateParentProperty(field);
        this.annotateOwnerProperty(field);
        this.annotateUserProperty(field);
        this.annotateSegmentProperty(field);
        this.annotateUniqueKey(field);
        this.annotateBusinessKey(field);
        this.annotateDiscriminatorColumn(field);
        this.annotateStateProperty(field);
        this.initializeKeyPropertyAnnotations();
    }

    private void annotatePrimaryKey(Field field) {
        PrimaryKey annotation = field.getAnnotation(PrimaryKey.class);
        if (annotation != null && annotation.value()) {
            Class<PrimaryKey> annotationClass = PrimaryKey.class;
            boolean log = this.depth() == 0;
            boolean aye = XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.PRIMARY_KEY);
            if (aye) {
                Field previous = this.getDeclaringArtifact().put(annotationClass, field);
                if (previous == null) {
                    this._annotatedWithPrimaryKey = true;
                } else if (log) {
                    XS1.logDuplicateAnnotation(field, annotationClass, previous);
                }
            }
        }
    }

    private void annotateSequenceProperty(Field field) {
        SequenceProperty annotation = field.getAnnotation(SequenceProperty.class);
        if (annotation != null) {
            Class<SequenceProperty> annotationClass = SequenceProperty.class;
            boolean log = this.depth() == 0;
            boolean aye = XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.SEQUENCE);
            if (aye) {
                Field previous = this.getDeclaringArtifact().put(annotationClass, field);
                if (previous == null) {
                    this._annotatedWithSequenceProperty = true;
                    this._sequencePropertyStart = Math.min(Long.MAX_VALUE, Math.max(1L, annotation.start()));
                    this._sequencePropertyStop = Math.min(Long.MAX_VALUE, Math.max(1L, annotation.stop()));
                    this._sequencePropertyStep = Math.min(Long.MAX_VALUE, Math.max(1L, annotation.step()));
                    if (log && !this.isSequencePropertyEnabled()) {
                        String message = this.getFullName() + " has invalid values for elements start/stop/step of its SequenceProperty annotation: " + this._sequencePropertyStart + "/" + this._sequencePropertyStop + "/" + this._sequencePropertyStep;
                        logger.error((Object)message);
                        Project.increaseParserErrorCount();
                    }
                } else if (log) {
                    XS1.logDuplicateAnnotation(field, annotationClass, previous);
                }
            }
        }
    }

    private void annotateVersionProperty(Field field) {
        VersionProperty annotation = field.getAnnotation(VersionProperty.class);
        if (annotation != null && annotation.value()) {
            Class<VersionProperty> annotationClass = VersionProperty.class;
            boolean log = this.depth() == 0;
            boolean aye = XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.VERSION);
            if (aye) {
                Field previous = this.getDeclaringArtifact().put(annotationClass, field);
                if (previous == null) {
                    this._annotatedWithVersionProperty = true;
                } else if (log) {
                    XS1.logDuplicateAnnotation(field, annotationClass, previous);
                }
            }
        }
    }

    private void annotateNameProperty(Field field) {
        NameProperty annotation = field.getAnnotation(NameProperty.class);
        if (annotation != null && annotation.value()) {
            Class<NameProperty> annotationClass = NameProperty.class;
            boolean log = this.depth() == 0;
            boolean aye = XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.NAME);
            if (aye) {
                Field previous = this.getDeclaringArtifact().put(annotationClass, field);
                if (previous == null) {
                    this._annotatedWithNameProperty = true;
                } else if (log) {
                    XS1.logDuplicateAnnotation(field, annotationClass, previous);
                }
            }
        }
    }

    private void annotateDescriptionProperty(Field field) {
        DescriptionProperty annotation = field.getAnnotation(DescriptionProperty.class);
        if (annotation != null && annotation.value()) {
            Class<DescriptionProperty> annotationClass = DescriptionProperty.class;
            boolean log = this.depth() == 0;
            boolean aye = XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.DESCRIPTION);
            if (aye) {
                Field previous = this.getDeclaringArtifact().put(annotationClass, field);
                if (previous == null) {
                    this._annotatedWithDescriptionProperty = true;
                } else if (log) {
                    XS1.logDuplicateAnnotation(field, annotationClass, previous);
                }
            }
        }
    }

    private void annotateImageProperty(Field field) {
        boolean aye;
        String fieldName = this.fullFieldName(field);
        Class<ImageProperty> annotationClass = ImageProperty.class;
        boolean log = this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.IMAGE);
        if (aye) {
            Field previous = this.getDeclaringArtifact().put(annotationClass, field);
            if (previous == null) {
                this._annotatedWithImageProperty = true;
                BinaryData data = (BinaryData)this;
                ImageProperty annotation = field.getAnnotation(ImageProperty.class);
                AvatarShape avatarShape = (AvatarShape)this.specified(AvatarShape.NONE.name(), new AvatarShape[]{annotation.avatarShape(), data.getAvatarShape()});
                AvatarDefault avatarDefault = (AvatarDefault)this.specified(AvatarDefault.NONE.name(), new AvatarDefault[]{annotation.avatarDefault(), data.getAvatarDefault()});
                int avatarWidth = this.greaterThanZero(annotation.avatarWidth(), data.getAvatarWidth());
                int avatarHeight = this.greaterThanZero(annotation.avatarHeight(), data.getAvatarHeight());
                int[] displayWidth = Arrays.copyOf(annotation.displayWidth(), WHR.COMPONENT_DISPLAY_SIZE.length);
                int[] displayHeight = Arrays.copyOf(annotation.displayHeight(), WHR.COMPONENT_DISPLAY_SIZE.length);
                boolean resizable = annotation.resizable().toBoolean(data.isResizable());
                WHR whrL = new WHR(fieldName, log, 0, displayWidth[0], displayHeight[0], 24, 24, WHR.DEF_IMG_W[0], WHR.DEF_IMG_H[0]);
                WHR whrM = new WHR(fieldName, log, 1, displayWidth[1], displayHeight[1], 24, 24, WHR.DEF_IMG_W[1], WHR.DEF_IMG_H[1]);
                WHR whrS = new WHR(fieldName, log, 2, displayWidth[2], displayHeight[2], 24, 24, WHR.DEF_IMG_W[2], WHR.DEF_IMG_H[2]);
                data.setAvatarShape(avatarShape);
                data.setAvatarDefault(avatarDefault);
                data.setAvatarWidth(avatarWidth);
                data.setAvatarHeight(avatarHeight);
                data.setLargeDisplayWidth(whrL.displayWidth);
                data.setLargeDisplayHeight(whrL.displayHeight);
                data.setMediumDisplayWidth(whrM.displayWidth);
                data.setMediumDisplayHeight(whrM.displayHeight);
                data.setSmallDisplayWidth(whrS.displayWidth);
                data.setSmallDisplayHeight(whrS.displayHeight);
                data.setResizable(resizable || whrL.resizable || whrM.resizable || whrS.resizable);
            } else if (log) {
                XS1.logDuplicateAnnotation(field, annotationClass, previous);
            }
        }
    }

    private void annotateInactiveIndicator(Field field) {
        InactiveIndicator annotation = field.getAnnotation(InactiveIndicator.class);
        if (annotation != null && annotation.value()) {
            Class<InactiveIndicator> annotationClass = InactiveIndicator.class;
            boolean log = this.depth() == 0;
            boolean aye = XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.INACTIVE_INDICATOR);
            if (aye) {
                Field previous = this.getDeclaringArtifact().put(annotationClass, field);
                if (previous == null) {
                    this._annotatedWithInactiveIndicator = true;
                } else if (log) {
                    XS1.logDuplicateAnnotation(field, annotationClass, previous);
                }
            }
        }
    }

    private void annotateUrlProperty(Field field) {
        boolean aye;
        Class<UrlProperty> annotationClass = UrlProperty.class;
        boolean log = this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.URL);
        if (aye) {
            Field previous = this.getDeclaringArtifact().put(annotationClass, field);
            if (previous == null) {
                this._annotatedWithUrlProperty = true;
                StringData data = (StringData)this;
                UrlProperty annotation = field.getAnnotation(UrlProperty.class);
                UrlType urlType = (UrlType)this.specified(new UrlType[]{annotation.urlType(), data.getUrlType()});
                DisplayMode urlDisplayMode = (DisplayMode)this.specified(new DisplayMode[]{annotation.urlDisplayMode(), data.getUrlDisplayMode()});
                UrlDisplayType urlDisplayType = (UrlDisplayType)this.specified(new UrlDisplayType[]{annotation.urlDisplayType(), data.getUrlDisplayType()});
                String[] sourceURLs = null;
                String searchURL = null;
                Pattern pattern = data.getPattern();
                boolean encoding = annotation.encoding().toBoolean(data.isEncodingEnabled());
                if (UrlType.EXTERNAL.equals((Object)urlType)) {
                    sourceURLs = this.specified(annotation.sourceURLs(), data.getSourceURLs());
                    searchURL = this.specified(annotation.searchURL(), data.getSearchURL());
                    if (pattern == null) {
                        pattern = Pattern.compile("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]$");
                    }
                }
                data.setUrlType(urlType);
                data.setUrlDisplayMode(urlDisplayMode);
                data.setUrlDisplayType(urlDisplayType);
                data.setSourceURLs(sourceURLs);
                data.setSearchURL(searchURL);
                data.setPattern(pattern);
                data.setEncodingEnabled(encoding);
            } else if (log) {
                XS1.logDuplicateAnnotation(field, annotationClass, previous);
            }
        }
    }

    private void annotateParentProperty(Field field) {
        ParentProperty annotation = field.getAnnotation(ParentProperty.class);
        if (annotation != null && annotation.value()) {
            Class<ParentProperty> annotationClass = ParentProperty.class;
            Class<?> declaringClass = field.getDeclaringClass();
            Class[] validTypes = new Class[]{declaringClass};
            boolean log = this.depth() == 1;
            boolean aye = XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.PARENT, validTypes);
            if (aye) {
                Field previous = this.getDeclaringArtifact().put(annotationClass, field);
                if (previous == null) {
                    this._annotatedWithParentProperty = true;
                } else if (log) {
                    XS1.logDuplicateAnnotation(field, annotationClass, previous);
                }
            }
        }
    }

    private void annotateOwnerProperty(Field field) {
        OwnerProperty annotation = field.getAnnotation(OwnerProperty.class);
        if (annotation != null && annotation.value()) {
            Class<OwnerProperty> annotationClass = OwnerProperty.class;
            boolean log = this.depth() == 1;
            boolean aye = XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.OWNER);
            if (aye) {
                Class<?> fieldType = field.getType();
                Class<? extends Entity> userEntityClass = TLC.getProject().getUserEntityClass();
                if (userEntityClass != null && userEntityClass.isAssignableFrom(fieldType)) {
                    Field previous = this.getDeclaringArtifact().put(annotationClass, field);
                    if (previous == null) {
                        this._annotatedWithOwnerProperty = true;
                    } else if (log) {
                        XS1.logDuplicateAnnotation(field, annotationClass, previous);
                    }
                } else if (log) {
                    String message = userEntityClass + " is not assignable from " + fieldType;
                    XS1.logFieldAnnotationErrorMessage(field, annotationClass, message);
                }
            }
        }
    }

    private void annotateUserProperty(Field field) {
        UserProperty annotation = field.getAnnotation(UserProperty.class);
        if (annotation != null && annotation.value()) {
            Class<UserProperty> annotationClass = UserProperty.class;
            boolean log = this.depth() == 1;
            boolean aye = XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.USER);
            if (aye) {
                Class<?> fieldType = field.getType();
                Class<? extends Entity> userEntityClass = TLC.getProject().getUserEntityClass();
                if (userEntityClass != null && userEntityClass.isAssignableFrom(fieldType)) {
                    Field previous = this.getDeclaringArtifact().put(annotationClass, field);
                    if (previous == null) {
                        this._annotatedWithUserProperty = true;
                    } else if (log) {
                        XS1.logDuplicateAnnotation(field, annotationClass, previous);
                    }
                } else if (log) {
                    String message = userEntityClass + " is not assignable from " + fieldType;
                    XS1.logFieldAnnotationErrorMessage(field, annotationClass, message);
                }
            }
        }
    }

    private void annotateSegmentProperty(Field field) {
        SegmentProperty annotation = field.getAnnotation(SegmentProperty.class);
        if (annotation != null && annotation.value()) {
            Class<SegmentProperty> annotationClass = SegmentProperty.class;
            boolean log = this.isLoggable();
            boolean aye = XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.SEGMENT);
            if (aye) {
                Field previous = this.getDeclaringArtifact().put(annotationClass, field);
                if (previous == null) {
                    Class<?> declaringClass;
                    this._annotatedWithSegmentProperty = true;
                    this._segmentEntityClass = annotation.entityClass();
                    if (field.isAnnotationPresent(PrimaryKey.class) && !this._segmentEntityClass.equals(declaringClass = field.getDeclaringClass())) {
                        if (this._segmentEntityClass.equals(Entity.class)) {
                            this._segmentEntityClass = declaringClass;
                        } else {
                            if (log) {
                                String message = this.getDeclaringEntity() + " is not assignable from " + this._segmentEntityClass;
                                XS1.logFieldAnnotationErrorMessage(field, annotationClass, message);
                                String declaringClassSimpleName = declaringClass.getSimpleName();
                                String hint = "remove element entityClass from the SegmentProperty annotation of " + declaringClassSimpleName + "." + field.getName() + "; alternatively, set it to either Entity.class or " + declaringClassSimpleName + ".class";
                                TLC.getProject().getParser().info(hint);
                            }
                            this._segmentEntityClass = declaringClass;
                        }
                    }
                } else if (log) {
                    XS1.logDuplicateAnnotation(field, annotationClass, previous);
                }
            }
        }
    }

    private void annotateUniqueKey(Field field) {
        UniqueKey annotation = field.getAnnotation(UniqueKey.class);
        if (annotation != null && annotation.value()) {
            boolean log = this.isLoggable();
            this._annotatedWithUniqueKey = XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.UNIQUE_KEY);
        }
    }

    private void annotateBusinessKey(Field field) {
        BusinessKey annotation = field.getAnnotation(BusinessKey.class);
        if (annotation != null && annotation.value()) {
            Class<BusinessKey> annotationClass = BusinessKey.class;
            boolean log = this.depth() == 0;
            boolean aye = XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.BUSINESS_KEY);
            if (aye) {
                Field previous = this.getDeclaringArtifact().put(annotationClass, field);
                if (previous == null) {
                    this._annotatedWithBusinessKey = true;
                } else if (log) {
                    XS1.logDuplicateAnnotation(field, annotationClass, previous);
                }
            }
        }
    }

    private void annotateDiscriminatorColumn(Field field) {
        DiscriminatorColumn annotation = field.getAnnotation(DiscriminatorColumn.class);
        if (annotation != null && annotation.value()) {
            Class<DiscriminatorColumn> annotationClass = DiscriminatorColumn.class;
            boolean log = this.isLoggable();
            boolean aye = XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.DISCRIMINATOR);
            if (aye) {
                Field previous = this.getDeclaringArtifact().put(annotationClass, field);
                if (previous == null) {
                    this._annotatedWithDiscriminatorColumn = true;
                } else if (log) {
                    XS1.logDuplicateAnnotation(field, annotationClass, previous);
                }
            }
        }
    }

    private void annotateStateProperty(Field field) {
        StateProperty annotation = field.getAnnotation(StateProperty.class);
        if (annotation != null && annotation.value()) {
            Class<StateProperty> annotationClass = StateProperty.class;
            boolean log = this.depth() == 1;
            boolean aye = XS1.checkKeyPropertyFieldAnnotation(log, field, KeyProperty.STATE);
            if (aye) {
                Field previous = this.getDeclaringArtifact().put(annotationClass, field);
                if (previous == null) {
                    this._annotatedWithStateProperty = true;
                } else if (log) {
                    XS1.logDuplicateAnnotation(field, annotationClass, previous);
                }
            }
        }
    }

    private void initializeKeyPropertyAnnotations() {
        StringData data;
        Primitive primitive;
        if (this.isKeyField()) {
            this._nullable = false;
            this._unique = true;
        }
        if (this.isPrimaryKeyProperty()) {
            this._updateable = false;
            this.hideKeyProperty();
        }
        if (this.isSequenceProperty()) {
            this._updateable = false;
            this.hideKeyProperty();
        }
        if (this.isVersionProperty()) {
            this._nullable = false;
            this.hideKeyProperty();
            primitive = (NumericPrimitive)this;
            ((NumericPrimitive)primitive).setInitialValue(0);
            ((NumericPrimitive)primitive).setDefaultValue(0);
            ((NumericPrimitive)primitive).setMinValue(0);
        }
        if (this.isNumericKeyProperty()) {
            primitive = (NumericPrimitive)this;
            ((NumericPrimitive)primitive).setMinValue(0);
        }
        if (this.isCharacterKeyProperty()) {
            data = (StringData)this;
            data.setMaxLength(Project.getDefaultCharacterKeyMaxLength());
        }
        if (this.isBusinessKeyProperty()) {
            if (this.isNumericPrimitive()) {
                primitive = (NumericPrimitive)this;
                ((NumericPrimitive)primitive).setMinValue(0);
            }
            if (this.isStringData()) {
                data = (StringData)this;
                data.setMaxLength(Project.getDefaultCharacterKeyMaxLength());
                data.setDataGenFunction("util.string_codigo_entidad");
            }
        }
        if (this.isNameProperty()) {
            this._nullable = false;
            data = (StringData)this;
            data.setMaxLength(Project.getDefaultNamePropertyMaxLength());
            data.setDataGenFunction("util.string_nombre_entidad");
        }
        if (this.isDescriptionProperty()) {
            data = (StringData)this;
            data.setMaxLength(Project.getDefaultDescriptionPropertyMaxLength());
            data.setDataGenFunction("util.string_descripcion_entidad");
        }
        if (this.isUrlProperty()) {
            data = (StringData)this;
            data.setMaxLength(Project.getDefaultUrlPropertyMaxLength());
        }
        if (this.isInactiveIndicatorProperty()) {
            this._nullable = false;
            primitive = (BooleanPrimitive)this;
            if (((BooleanPrimitive)primitive).getInitialValue() == null) {
                ((BooleanPrimitive)primitive).setInitialValue(false);
            }
            if (((BooleanPrimitive)primitive).getDefaultValue() == null) {
                ((BooleanPrimitive)primitive).setDefaultValue(false);
            }
        }
        if (this.isOwnerProperty()) {
            this._nullable = false;
            this._createField = false;
            this._updateField = false;
            this._defaultCondition = DefaultCondition.IF_NULL;
            this._defaultCheckpoint = Checkpoint.USER_INTERFACE;
            Entity owner = (Entity)((Object)this);
            if (owner.getInitialValue() == null) {
                owner.setInitialValue(SpecialEntityValue.CURRENT_USER);
            }
            if (owner.getDefaultValue() == null) {
                owner.setDefaultValue(SpecialEntityValue.CURRENT_USER);
            }
        }
        if (this.isUserProperty()) {
            this._nullable = true;
            this._createField = false;
            this._updateField = false;
            this._defaultCondition = DefaultCondition.UNCONDITIONALLY;
            this._defaultCheckpoint = Checkpoint.USER_INTERFACE;
            Entity user = (Entity)((Object)this);
            user.setInitialValue(SpecialEntityValue.CURRENT_USER);
            user.setDefaultValue(SpecialEntityValue.CURRENT_USER);
        }
        if (this.isDiscriminatorProperty()) {
            this._nullable = false;
            this._updateable = false;
            this._hiddenField = this.getDeclaringEntityRoot().getSubclassesMap().isEmpty();
            this._createField = false;
            this._updateField = false;
        }
    }

    private void hideKeyProperty() {
        this._hiddenField = true;
        this._createField = false;
        this._updateField = false;
        this._searchField = false;
        this._filterField = false;
        this._tableField = false;
        this._columnField = false;
        this._reportField = false;
        this._exportField = false;
        this._headertextlessField = false;
        this._headingField = false;
        this._overlayField = false;
        this._prominentField = false;
        this._immutableField = false;
    }

    private void annotateBaseField(Field field) {
        BaseField annotation = field.getAnnotation(BaseField.class);
        if (annotation != null && annotation.value()) {
            Class<BaseField> annotationClass = BaseField.class;
            Class[] validTypes = new Class[]{Property.class};
            boolean log = this.isLoggable();
            this._annotatedWithBaseField = XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        }
    }

    private void annotateColumnField(Field field) {
        boolean aye;
        Class<ColumnField> annotationClass = ColumnField.class;
        Class[] validTypes = new Class[]{Property.class};
        boolean log = this.isLoggable();
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            ColumnField annotation = field.getAnnotation(ColumnField.class);
            this._annotatedWithColumnField = true;
            this._calculable = annotation.calculable().toBoolean(this._calculable);
            this._nullable = annotation.nullable().toBoolean(this._calculable || this._nullable);
            this._insertable = annotation.insertable().toBoolean(!this._calculable && this._insertable);
            this._updateable = annotation.updateable().toBoolean(!this._calculable && this._updateable);
            this._unique = annotation.unique().toBoolean(!this._calculable && this._unique);
            this._indexed = annotation.indexed().toBoolean(!this._calculable && this._indexed);
        }
        if (log) {
            this.checkColumnFieldElements(field);
        }
    }

    private void checkColumnFieldElements(Field field) {
        String fieldName = this.fullFieldName(field);
        if (this._calculable) {
            if (!this._nullable) {
                logger.error((Object)(fieldName + " is calculable and therefore must be nullable"));
                Project.increaseParserErrorCount();
            }
            if (this._insertable) {
                logger.error((Object)(fieldName + " is calculable and therefore cannot be insertable"));
                Project.increaseParserErrorCount();
            }
            if (this._updateable) {
                logger.error((Object)(fieldName + " is calculable and therefore cannot be updateable"));
                Project.increaseParserErrorCount();
            }
            if (this.isUnique()) {
                logger.error((Object)(fieldName + " is calculable and therefore cannot be unique"));
                Project.increaseParserErrorCount();
            }
            if (this._indexed) {
                logger.error((Object)(fieldName + " is calculable and therefore cannot be indexed"));
                Project.increaseParserErrorCount();
            }
        }
    }

    private void checkColumnFieldElements() {
        if (this.isProperty() && this.isLoggable() && !this.isCalculable()) {
            StringData data;
            int maxLength;
            String fieldName = this.getFullName();
            if (this._nullable && this.isUnique()) {
                logger.error((Object)(fieldName + " is nullable and therefore cannot be unique"));
                Project.increaseParserErrorCount();
            }
            if (this._indexed && this instanceof StringData && (maxLength = IntUtils.valueOf((data = (StringData)this).getMaxLength())) < 1) {
                logger.error((Object)(fieldName + " is a CLOB property and therefore cannot be indexed"));
                Project.increaseParserErrorCount();
            }
        }
    }

    private void annotateBigDecimalField(Field field) {
        boolean aye;
        BigDecimalData data = null;
        int precision = -1;
        int scale = -1;
        if (this instanceof BigDecimalData) {
            data = (BigDecimalData)this;
            precision = data.getRawPrecision();
            scale = data.getRawScale();
        }
        String fieldName = this.fullFieldName(field);
        Class<BigDecimalField> annotationClass = BigDecimalField.class;
        Class[] validTypes = new Class[]{BigDecimalParameter.class, BigDecimalProperty.class};
        boolean log = this.isParameter() || this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            this._annotatedWithBigDecimalField = true;
            BigDecimalField annotation = field.getAnnotation(BigDecimalField.class);
            precision = this.specified(annotation.precision(), precision);
            scale = this.specified(annotation.scale(), scale);
        }
        if (data != null) {
            if (precision < 1) {
                precision = 16;
            } else if (precision > 60) {
                precision = 60;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid decimal precision"));
                    Project.increaseParserErrorCount();
                }
            }
            if (scale < 0) {
                scale = precision > 2 ? 2 : precision;
            } else if (scale > precision) {
                scale = precision;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid decimal scale"));
                    Project.increaseParserErrorCount();
                }
            }
            data.setPrecision(precision);
            data.setScale(scale);
        }
    }

    private void annotateBigIntegerField(Field field) {
        boolean aye;
        BigIntegerData data = null;
        int precision = -1;
        if (this instanceof BigIntegerData) {
            data = (BigIntegerData)this;
            precision = data.getRawPrecision();
        }
        String fieldName = this.fullFieldName(field);
        Class<BigIntegerField> annotationClass = BigIntegerField.class;
        Class[] validTypes = new Class[]{BigIntegerParameter.class, BigIntegerProperty.class};
        boolean log = this.isParameter() || this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            this._annotatedWithBigIntegerField = true;
            BigIntegerField annotation = field.getAnnotation(BigIntegerField.class);
            precision = this.specified(annotation.precision(), precision);
        }
        if (data != null) {
            if (precision < 1) {
                precision = 16;
            } else if (precision > 60) {
                precision = 60;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid numeric precision"));
                    Project.increaseParserErrorCount();
                }
            }
            data.setPrecision(precision);
        }
    }

    private void annotateBooleanField(Field field) {
        boolean aye;
        BooleanData data = null;
        BooleanDisplayType displayType = BooleanDisplayType.UNSPECIFIED;
        if (this instanceof BooleanData) {
            data = (BooleanData)this;
            displayType = data.rawBooleanDisplayType();
        }
        Class<BooleanField> annotationClass = BooleanField.class;
        Class[] validTypes = new Class[]{BooleanParameter.class, BooleanProperty.class};
        boolean log = this.isParameter() || this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            this._annotatedWithBooleanField = true;
            BooleanField annotation = field.getAnnotation(BooleanField.class);
            displayType = (BooleanDisplayType)this.specified(new BooleanDisplayType[]{annotation.displayType(), displayType});
        }
        if (data != null) {
            data.setBooleanDisplayType(displayType);
        }
    }

    private void annotateNumericField(Field field) {
        boolean aye;
        NumericPrimitive data = null;
        NumericFieldType type = null;
        int divisor = -1;
        DivisorRule divisorRule = null;
        String symbol = "";
        SymbolPosition symbolPosition = null;
        Boolean symbolSeparator = null;
        String converter = "";
        String validator = "";
        if (this instanceof NumericPrimitive) {
            data = (NumericPrimitive)this;
            type = data.getConverterType();
            divisor = data.getDivisor();
            divisorRule = data.getDivisorRule();
            symbol = data.getSymbol();
            symbolPosition = data.getSymbolPosition();
            symbolSeparator = data.isSymbolSeparator();
            converter = data.getSpecialConverterName();
            validator = data.getSpecialValidatorName();
        }
        String fieldName = this.fullFieldName(field);
        Class<NumericField> annotationClass = NumericField.class;
        Class[] validTypes = new Class[]{NumericPrimitive.class};
        boolean log = this.isParameter() || this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            this._annotatedWithNumericField = true;
            NumericField annotation = field.getAnnotation(NumericField.class);
            type = (NumericFieldType)this.specified(new NumericFieldType[]{annotation.type(), type});
            divisor = this.specified(annotation.divisor(), divisor);
            divisorRule = (DivisorRule)this.specified(new DivisorRule[]{annotation.divisorRule(), divisorRule});
            symbol = this.specified(annotation.symbol(), symbol);
            symbolPosition = (SymbolPosition)this.specified(new SymbolPosition[]{annotation.symbolPosition(), symbolPosition});
            symbolSeparator = annotation.symbolSeparator().toBoolean(symbolSeparator);
            converter = this.specified(annotation.converter(), converter);
            validator = this.specified(annotation.validator(), validator);
        }
        if (data != null) {
            if (divisorRule == null || divisorRule.equals((Object)DivisorRule.UNSPECIFIED)) {
                divisor = 0;
            } else if (divisor < 0) {
                divisor = 100;
            } else if (divisor < 1 || divisor > this.maxDivisor()) {
                divisor = 1;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid divisor"));
                    Project.increaseParserErrorCount();
                }
            }
            if (StringUtils.isNotBlank((String)converter) && !converter.matches("^[a-zA-Z]\\w*$")) {
                converter = "";
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid converter name"));
                    Project.increaseParserErrorCount();
                }
            }
            if (StringUtils.isNotBlank((String)validator) && !validator.matches("^[a-zA-Z]\\w*$")) {
                validator = "";
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid validator name"));
                    Project.increaseParserErrorCount();
                }
            }
            data.setConverterType(type);
            data.setDivisor(divisor);
            data.setDivisorRule(divisorRule);
            data.setSymbol(symbol);
            data.setSymbolPosition(symbolPosition);
            data.setSymbolSeparator(this.coalesce(symbolSeparator, this.defaultSymbolSeparator(symbol, symbolPosition, type)));
            data.setSpecialConverterName(converter);
            data.setSpecialValidatorName(validator);
        }
    }

    private int maxDivisor() {
        if (this instanceof ByteData) {
            return 100;
        }
        if (this instanceof ShortData) {
            return 10000;
        }
        return 1000000;
    }

    private boolean defaultSymbolSeparator(String symbol, SymbolPosition symbolPosition, NumericFieldType type) {
        int i;
        int l = symbol.length();
        int n = l > 0 ? (SymbolPosition.PREFIX.equals((Object)symbolPosition) ? l - 1 : 0) : (i = -1);
        return i >= 0 ? Character.isLetterOrDigit(symbol.charAt(i)) : !NumericFieldType.CURRENCY.equals((Object)type) && !NumericFieldType.PERCENT.equals((Object)type);
    }

    private void annotateStringField(Field field) {
        boolean aye;
        StringData data = null;
        int maxLength = -1;
        int minLength = -1;
        String mask = "";
        char slotChar = '_';
        String regex = "";
        String converter = "";
        String validator = "";
        AutoComplete autoComplete = AutoComplete.UNSPECIFIED;
        LetterCase letterCase = LetterCase.UNSPECIFIED;
        boolean allowDiacritics = false;
        boolean richTextFormat = false;
        if (this instanceof StringData) {
            data = (StringData)this;
            maxLength = IntUtils.valueOf(data.getMaxLength(), -1);
            minLength = data.getMinLength();
            mask = data.getInputMask();
            slotChar = data.getSlotChar();
            regex = data.getPatternRegex();
            converter = data.getSpecialConverterName();
            validator = data.getSpecialValidatorName();
            autoComplete = data.getAutoComplete();
            letterCase = data.getLetterCase();
            allowDiacritics = data.getAllowDiacritics();
            richTextFormat = data.getRichTextFormat();
        }
        String fieldName = this.fullFieldName(field);
        Class<StringField> annotationClass = StringField.class;
        Class[] validTypes = new Class[]{StringParameter.class, StringProperty.class};
        boolean log = this.isParameter() || this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            this._annotatedWithStringField = true;
            StringField annotation = field.getAnnotation(StringField.class);
            int aml = annotation.maxLength();
            if (aml < -1000000000 || aml > -1) {
                maxLength = aml;
            }
            minLength = this.specified(annotation.minLength(), minLength);
            mask = this.specified(annotation.mask(), mask);
            slotChar = this.specified(Character.valueOf(annotation.slotChar()), Character.valueOf(slotChar)).charValue();
            regex = this.specified(annotation.regex(), regex);
            converter = this.specified(annotation.converter(), converter);
            validator = this.specified(annotation.validator(), validator);
            autoComplete = (AutoComplete)this.specified(new AutoComplete[]{annotation.autoComplete(), autoComplete});
            letterCase = (LetterCase)this.specified(new LetterCase[]{annotation.letterCase(), letterCase});
            allowDiacritics = annotation.allowDiacritics().toBoolean(allowDiacritics);
            richTextFormat = annotation.richTextFormat().toBoolean(richTextFormat);
            if (richTextFormat) {
                maxLength = 0;
                if (log && aml > 0) {
                    logger.warn((Object)("max length of " + fieldName + " was ignored; rich text format properties must be defined with no limit"));
                    Project.increaseParserWarningCount();
                }
            }
        }
        if (data != null) {
            Pattern pattern;
            block30: {
                int projectMaximumStringFieldMaxLength = Project.getMaximumStringFieldMaxLength();
                int projectMaximumStringIndexMaxLength = Project.getMaximumStringIndexMaxLength();
                if (maxLength < 0) {
                    maxLength = this.positiveStringFieldMaxLength(field, maxLength);
                } else if (maxLength > projectMaximumStringFieldMaxLength) {
                    maxLength = projectMaximumStringFieldMaxLength;
                    if (log) {
                        logger.error((Object)("max length of " + fieldName + " exceeds the defined string field limit (" + projectMaximumStringFieldMaxLength + ")"));
                        Project.increaseParserErrorCount();
                    }
                } else if ((maxLength == 0 || maxLength > projectMaximumStringIndexMaxLength) && (this.isUnique() || this.isIndexed())) {
                    maxLength = projectMaximumStringIndexMaxLength;
                    if (log) {
                        logger.error((Object)("max length of " + fieldName + " exceeds the defined string index limit (" + projectMaximumStringIndexMaxLength + ")"));
                        Project.increaseParserErrorCount();
                    }
                }
                if (minLength < 0) {
                    minLength = 0;
                } else if (maxLength > 0 && minLength > maxLength) {
                    minLength = maxLength;
                    if (log) {
                        logger.error((Object)(fieldName + " has an invalid min length"));
                        Project.increaseParserErrorCount();
                    }
                }
                if (StringUtils.isBlank((String)mask)) {
                    mask = "";
                    slotChar = '_';
                } else {
                    if (!StrUtils.isASCII(mask)) {
                        mask = "";
                        if (log) {
                            logger.error((Object)(fieldName + " has an invalid input mask"));
                            Project.increaseParserErrorCount();
                        }
                    }
                    if (!StrUtils.isASCII(slotChar)) {
                        slotChar = '_';
                        if (log) {
                            logger.error((Object)(fieldName + " has an invalid slot char"));
                            Project.increaseParserErrorCount();
                        }
                    }
                }
                pattern = null;
                if (StringUtils.isNotBlank((String)regex)) {
                    try {
                        pattern = Pattern.compile(regex);
                    }
                    catch (PatternSyntaxException ex) {
                        if (!log) break block30;
                        logger.error((Object)(fieldName + " has an invalid regular expression"));
                        Project.increaseParserErrorCount();
                    }
                }
            }
            if (StringUtils.isNotBlank((String)converter) && !converter.matches("^[a-zA-Z]\\w*$")) {
                converter = "";
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid converter name"));
                    Project.increaseParserErrorCount();
                }
            }
            if (StringUtils.isNotBlank((String)validator) && !validator.matches("^[a-zA-Z]\\w*$")) {
                validator = "";
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid validator name"));
                    Project.increaseParserErrorCount();
                }
            }
            data.setMaxLength(maxLength < 1 ? null : Integer.valueOf(maxLength));
            data.setMinLength(minLength);
            data.setInputMask(mask);
            data.setSlotChar(slotChar);
            data.setAutoComplete(autoComplete);
            data.setLetterCase(letterCase);
            data.setAllowDiacritics(allowDiacritics);
            data.setRichTextFormat(richTextFormat);
            data.setPattern(pattern);
            data.setSpecialConverterName(converter);
            data.setSpecialValidatorName(validator);
        }
    }

    private int positiveStringFieldMaxLength(Field field, int maxLength) {
        if (maxLength >= 0) {
            return maxLength;
        }
        if (maxLength == -1000000030) {
            return Project.getDefaultCharacterKeyMaxLength();
        }
        if (maxLength == -1000000100) {
            return Project.getDefaultNamePropertyMaxLength();
        }
        if (maxLength == -1000001596 || this.isUnique() || this.isIndexed()) {
            return Project.getDefaultStringIndexMaxLength();
        }
        if (maxLength == Integer.MIN_VALUE) {
            return Project.getDefaultDescriptionPropertyMaxLength();
        }
        if (maxLength == -1000002002 || field.isAnnotationPresent(UniformResourceLocator.class)) {
            return Project.getDefaultUrlPropertyMaxLength();
        }
        if (maxLength == -1000002003 || field.isAnnotationPresent(EmbeddedDocument.class)) {
            return Project.getDefaultEmbeddedDocumentMaxLength();
        }
        if (maxLength == -1000002001 || field.isAnnotationPresent(FileReference.class)) {
            return Project.getDefaultFileReferenceMaxLength();
        }
        if (maxLength == -1000032767) {
            return Project.getMaximumStringFieldMaxLength();
        }
        return Project.getDefaultStringFieldMaxLength();
    }

    private void annotateDateField(Field field) {
        boolean aye;
        DateData data = null;
        boolean disabledWeekends = false;
        boolean disabledWeekdays = false;
        boolean disabledHolidays = false;
        int yearRange = -1;
        String converter = "";
        String validator = "";
        if (this instanceof DateData) {
            data = (DateData)this;
            disabledWeekends = data.isDisabledWeekends();
            disabledWeekdays = data.isDisabledWeekdays();
            disabledHolidays = data.isDisabledHolidays();
            yearRange = data.getYearRange();
            converter = data.getSpecialConverterName();
            validator = data.getSpecialValidatorName();
        }
        String fieldName = this.fullFieldName(field);
        Class<DateField> annotationClass = DateField.class;
        Class[] validTypes = new Class[]{DateParameter.class, DateProperty.class};
        boolean log = this.isParameter() || this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            this._annotatedWithDateField = true;
            DateField annotation = field.getAnnotation(DateField.class);
            disabledWeekends = annotation.disabledWeekends().toBoolean(disabledWeekends);
            disabledWeekdays = annotation.disabledWeekdays().toBoolean(disabledWeekdays);
            disabledHolidays = annotation.disabledHolidays().toBoolean(disabledHolidays);
            yearRange = this.specified(annotation.yearRange(), yearRange);
            converter = this.specified(annotation.converter(), converter);
            validator = this.specified(annotation.validator(), validator);
        }
        if (data != null) {
            if (yearRange < 0) {
                yearRange = 5;
            } else if (yearRange < 1 || yearRange > 100) {
                yearRange = 100;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid decimal precision"));
                    Project.increaseParserErrorCount();
                }
            }
            if (StringUtils.isNotBlank((String)converter) && !converter.matches("^[a-zA-Z]\\w*$")) {
                converter = "";
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid converter name"));
                    Project.increaseParserErrorCount();
                }
            }
            if (StringUtils.isNotBlank((String)validator) && !validator.matches("^[a-zA-Z]\\w*$")) {
                validator = "";
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid validator name"));
                    Project.increaseParserErrorCount();
                }
            }
            data.setDisabledWeekends(disabledWeekends);
            data.setDisabledWeekdays(disabledWeekdays);
            data.setDisabledHolidays(disabledHolidays);
            data.setYearRange(yearRange);
            data.setSpecialConverterName(converter);
            data.setSpecialValidatorName(validator);
        }
    }

    private void annotateTimeField(Field field) {
        boolean aye;
        TimeData data = null;
        int precision = -1;
        int minHour = -1;
        int maxHour = -1;
        int stepHour = -1;
        int minMinute = -1;
        int maxMinute = -1;
        int stepMinute = -1;
        int minSecond = -1;
        int maxSecond = -1;
        int stepSecond = -1;
        String converter = "";
        String validator = "";
        if (this instanceof TimeData) {
            data = (TimeData)this;
            precision = data.getPrecision();
            minHour = data.getMinHour();
            maxHour = data.getMaxHour();
            stepHour = data.getStepHour();
            minMinute = data.getMinMinute();
            maxMinute = data.getMaxMinute();
            stepMinute = data.getStepMinute();
            minSecond = data.getMinSecond();
            maxSecond = data.getMaxSecond();
            stepSecond = data.getStepSecond();
            converter = data.getSpecialConverterName();
            validator = data.getSpecialValidatorName();
        }
        String fieldName = this.fullFieldName(field);
        Class<TimeField> annotationClass = TimeField.class;
        Class[] validTypes = new Class[]{TimeParameter.class, TimeProperty.class};
        boolean log = this.isParameter() || this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            this._annotatedWithTimeField = true;
            TimeField annotation = field.getAnnotation(TimeField.class);
            precision = this.specified(annotation.precision(), precision);
            minHour = this.specified(annotation.minHour(), minHour);
            maxHour = this.specified(annotation.maxHour(), maxHour);
            stepHour = this.specified(annotation.stepHour(), stepHour);
            minMinute = this.specified(annotation.minMinute(), minMinute);
            maxMinute = this.specified(annotation.maxMinute(), maxMinute);
            stepMinute = this.specified(annotation.stepMinute(), stepMinute);
            minSecond = this.specified(annotation.minSecond(), minSecond);
            maxSecond = this.specified(annotation.maxSecond(), maxSecond);
            stepSecond = this.specified(annotation.stepSecond(), stepSecond);
            converter = this.specified(annotation.converter(), converter);
            validator = this.specified(annotation.validator(), validator);
            if (precision < 0) {
                precision = 3;
            } else if (precision > 6) {
                precision = 6;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid precision"));
                    Project.increaseParserErrorCount();
                }
            }
            if (maxHour < 0) {
                maxHour = 23;
            } else if (maxHour > 23) {
                maxHour = 23;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid maximum hour"));
                    Project.increaseParserErrorCount();
                }
            }
            if (minHour < 0) {
                minHour = 0;
            } else if (minHour > maxHour) {
                minHour = 0;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid minimum hour"));
                    Project.increaseParserErrorCount();
                }
            }
            if (stepHour < 0) {
                stepHour = 1;
            } else if (stepHour < 1 || stepHour > 23) {
                stepHour = 1;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid hour step"));
                    Project.increaseParserErrorCount();
                }
            }
            if (maxMinute < 0) {
                maxMinute = 59;
            } else if (maxMinute > 59) {
                maxMinute = 59;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid maximum minute"));
                    Project.increaseParserErrorCount();
                }
            }
            if (minMinute < 0) {
                minMinute = 0;
            } else if (minMinute > maxMinute) {
                minMinute = 0;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid minimum minute"));
                    Project.increaseParserErrorCount();
                }
            }
            if (stepMinute < 0) {
                stepMinute = 1;
            } else if (stepMinute < 1 || stepMinute > 59) {
                stepMinute = 1;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid minute step"));
                    Project.increaseParserErrorCount();
                }
            }
            if (maxSecond < 0) {
                maxSecond = 59;
            } else if (maxSecond > 59) {
                maxSecond = 59;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid maximum second"));
                    Project.increaseParserErrorCount();
                }
            }
            if (minSecond < 0) {
                minSecond = 0;
            } else if (minSecond > maxSecond) {
                minSecond = 0;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid minimum second"));
                    Project.increaseParserErrorCount();
                }
            }
            if (stepSecond < 0) {
                stepSecond = 1;
            } else if (stepSecond < 1 || stepSecond > 59) {
                stepSecond = 1;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid second step"));
                    Project.increaseParserErrorCount();
                }
            }
            if (StringUtils.isNotBlank((String)converter) && !converter.matches("^[a-zA-Z]\\w*$")) {
                converter = "";
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid converter name"));
                    Project.increaseParserErrorCount();
                }
            }
            if (StringUtils.isNotBlank((String)validator) && !validator.matches("^[a-zA-Z]\\w*$")) {
                validator = "";
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid validator name"));
                    Project.increaseParserErrorCount();
                }
            }
        }
        if (data != null) {
            data.setPrecision(precision);
            data.setMinHour(minHour);
            data.setMaxHour(maxHour);
            data.setStepHour(stepHour);
            data.setMinMinute(minMinute);
            data.setMaxMinute(maxMinute);
            data.setStepMinute(stepMinute);
            data.setMinSecond(minSecond);
            data.setMaxSecond(maxSecond);
            data.setStepSecond(stepSecond);
            data.setSpecialConverterName(converter);
            data.setSpecialValidatorName(validator);
        }
    }

    private void annotateTimestampField(Field field) {
        boolean aye;
        TimestampData data = null;
        boolean disabledWeekends = false;
        boolean disabledWeekdays = false;
        boolean disabledHolidays = false;
        int yearRange = -1;
        int precision = -1;
        int minHour = -1;
        int maxHour = -1;
        int stepHour = -1;
        int minMinute = -1;
        int maxMinute = -1;
        int stepMinute = -1;
        int minSecond = -1;
        int maxSecond = -1;
        int stepSecond = -1;
        String converter = "";
        String validator = "";
        if (this instanceof TimestampData) {
            data = (TimestampData)this;
            disabledWeekends = data.isDisabledWeekends();
            disabledWeekdays = data.isDisabledWeekdays();
            disabledHolidays = data.isDisabledHolidays();
            yearRange = data.getYearRange();
            precision = data.getPrecision();
            minHour = data.getMinHour();
            maxHour = data.getMaxHour();
            stepHour = data.getStepHour();
            minMinute = data.getMinMinute();
            maxMinute = data.getMaxMinute();
            stepMinute = data.getStepMinute();
            minSecond = data.getMinSecond();
            maxSecond = data.getMaxSecond();
            stepSecond = data.getStepSecond();
            converter = data.getSpecialConverterName();
            validator = data.getSpecialValidatorName();
        }
        String fieldName = this.fullFieldName(field);
        Class<TimestampField> annotationClass = TimestampField.class;
        Class[] validTypes = new Class[]{TimestampParameter.class, TimestampProperty.class};
        boolean log = this.isParameter() || this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            this._annotatedWithTimestampField = true;
            TimestampField annotation = field.getAnnotation(TimestampField.class);
            disabledWeekends = annotation.disabledWeekends().toBoolean(disabledWeekends);
            disabledWeekdays = annotation.disabledWeekdays().toBoolean(disabledWeekdays);
            disabledHolidays = annotation.disabledHolidays().toBoolean(disabledHolidays);
            yearRange = this.specified(annotation.yearRange(), yearRange);
            precision = this.specified(annotation.precision(), precision);
            minHour = this.specified(annotation.minHour(), minHour);
            maxHour = this.specified(annotation.maxHour(), maxHour);
            stepHour = this.specified(annotation.stepHour(), stepHour);
            minMinute = this.specified(annotation.minMinute(), minMinute);
            maxMinute = this.specified(annotation.maxMinute(), maxMinute);
            stepMinute = this.specified(annotation.stepMinute(), stepMinute);
            minSecond = this.specified(annotation.minSecond(), minSecond);
            maxSecond = this.specified(annotation.maxSecond(), maxSecond);
            stepSecond = this.specified(annotation.stepSecond(), stepSecond);
            converter = this.specified(annotation.converter(), converter);
            validator = this.specified(annotation.validator(), validator);
            if (yearRange < 0) {
                yearRange = 5;
            } else if (yearRange < 1 || yearRange > 100) {
                yearRange = 100;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid decimal precision"));
                    Project.increaseParserErrorCount();
                }
            }
            if (precision < 0) {
                precision = 3;
            } else if (precision > 6) {
                precision = 6;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid precision"));
                    Project.increaseParserErrorCount();
                }
            }
            if (maxHour < 0) {
                maxHour = 23;
            } else if (maxHour > 23) {
                maxHour = 23;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid maximum hour"));
                    Project.increaseParserErrorCount();
                }
            }
            if (minHour < 0) {
                minHour = 0;
            } else if (minHour > maxHour) {
                minHour = 0;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid minimum hour"));
                    Project.increaseParserErrorCount();
                }
            }
            if (stepHour < 0) {
                stepHour = 1;
            } else if (stepHour < 1 || stepHour > 23) {
                stepHour = 1;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid hour step"));
                    Project.increaseParserErrorCount();
                }
            }
            if (maxMinute < 0) {
                maxMinute = 59;
            } else if (maxMinute > 59) {
                maxMinute = 59;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid maximum minute"));
                    Project.increaseParserErrorCount();
                }
            }
            if (minMinute < 0) {
                minMinute = 0;
            } else if (minMinute > maxMinute) {
                minMinute = 0;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid minimum minute"));
                    Project.increaseParserErrorCount();
                }
            }
            if (stepMinute < 0) {
                stepMinute = 1;
            } else if (stepMinute < 1 || stepMinute > 59) {
                stepMinute = 1;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid minute step"));
                    Project.increaseParserErrorCount();
                }
            }
            if (maxSecond < 0) {
                maxSecond = 59;
            } else if (maxSecond > 59) {
                maxSecond = 59;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid maximum second"));
                    Project.increaseParserErrorCount();
                }
            }
            if (minSecond < 0) {
                minSecond = 0;
            } else if (minSecond > maxSecond) {
                minSecond = 0;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid minimum second"));
                    Project.increaseParserErrorCount();
                }
            }
            if (stepSecond < 0) {
                stepSecond = 1;
            } else if (stepSecond < 1 || stepSecond > 59) {
                stepSecond = 1;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid second step"));
                    Project.increaseParserErrorCount();
                }
            }
            if (StringUtils.isNotBlank((String)converter) && !converter.matches("^[a-zA-Z]\\w*$")) {
                converter = "";
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid converter name"));
                    Project.increaseParserErrorCount();
                }
            }
            if (StringUtils.isNotBlank((String)validator) && !validator.matches("^[a-zA-Z]\\w*$")) {
                validator = "";
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid validator name"));
                    Project.increaseParserErrorCount();
                }
            }
        }
        if (data != null) {
            data.setDisabledWeekends(disabledWeekends);
            data.setDisabledWeekdays(disabledWeekdays);
            data.setDisabledHolidays(disabledHolidays);
            data.setYearRange(yearRange);
            data.setPrecision(precision);
            data.setMinHour(minHour);
            data.setMaxHour(maxHour);
            data.setStepHour(stepHour);
            data.setMinMinute(minMinute);
            data.setMaxMinute(maxMinute);
            data.setStepMinute(stepMinute);
            data.setMinSecond(minSecond);
            data.setMaxSecond(maxSecond);
            data.setStepSecond(stepSecond);
            data.setSpecialConverterName(converter);
            data.setSpecialValidatorName(validator);
        }
    }

    private void annotateEmbeddedDocument(Field field) {
        boolean aye;
        String fieldName = this.fullFieldName(field);
        Class<EmbeddedDocument> annotationClass = EmbeddedDocument.class;
        Class[] validTypes = new Class[]{StringProperty.class};
        boolean log = this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            this._annotatedWithEmbeddedDocument = true;
            StringData data = (StringData)this;
            EmbeddedDocument annotation = field.getAnnotation(EmbeddedDocument.class);
            String searchURL = this.specified(annotation.searchURL(), data.getSearchURL());
            String[] sourceURLs = this.specified(annotation.sourceURLs(), data.getEmbeddedDocumentURLs());
            EmbeddedDocumentType sourceType = (EmbeddedDocumentType)this.specified(new EmbeddedDocumentType[]{annotation.sourceType(), data.getEmbeddedDocumentType()});
            EmbeddedDocumentStyle style = (EmbeddedDocumentStyle)this.specified(new EmbeddedDocumentStyle[]{annotation.style(), data.getEmbeddedDocumentStyle()});
            int[] displayWidth = Arrays.copyOf(annotation.displayWidth(), WHR.COMPONENT_DISPLAY_SIZE.length);
            int[] displayHeight = Arrays.copyOf(annotation.displayHeight(), WHR.COMPONENT_DISPLAY_SIZE.length);
            boolean resizable = annotation.resizable().toBoolean(data.isResizable());
            Boolean frameBorder = annotation.frameBorder().toBoolean(data.getFrameBorder());
            Boolean encryptedMedia = annotation.encryptedMedia().toBoolean(data.getEncryptedMedia());
            Boolean accelerometer = annotation.accelerometer().toBoolean(data.getAccelerometer());
            Boolean autoplay = annotation.autoplay().toBoolean(data.getAutoplay());
            Boolean gyroscope = annotation.gyroscope().toBoolean(data.getGyroscope());
            Boolean pictureInPicture = annotation.pictureInPicture().toBoolean(data.getPictureInPicture());
            Boolean fullScreen = annotation.fullScreen().toBoolean(data.getFullScreen());
            EmbeddedDocumentLoading loading = annotation.loading();
            EmbeddedDocumentPolicy referrerPolicy = annotation.referrerPolicy();
            EmbeddedDocumentSandbox sandbox = annotation.sandbox();
            boolean encoding = annotation.encoding().toBoolean(data.isEncodingEnabled());
            data.setSearchURL(searchURL);
            data.setEmbeddedDocumentURLs(sourceURLs);
            data.setEmbeddedDocumentType(sourceType);
            data.setEmbeddedDocumentStyle(style);
            WHR whrL = new WHR(fieldName, log, 0, displayWidth[0], displayHeight[0], 144, 144, WHR.DEF_DOC_W[0], WHR.DEF_DOC_H[0]);
            WHR whrM = new WHR(fieldName, log, 1, displayWidth[1], displayHeight[1], 144, 144, WHR.DEF_DOC_W[1], WHR.DEF_DOC_H[1]);
            WHR whrS = new WHR(fieldName, log, 2, displayWidth[2], displayHeight[2], 144, 144, WHR.DEF_DOC_W[2], WHR.DEF_DOC_H[2]);
            data.setLargeDisplayWidth(whrL.displayWidth);
            data.setLargeDisplayHeight(whrL.displayHeight);
            data.setMediumDisplayWidth(whrM.displayWidth);
            data.setMediumDisplayHeight(whrM.displayHeight);
            data.setSmallDisplayWidth(whrS.displayWidth);
            data.setSmallDisplayHeight(whrS.displayHeight);
            data.setResizable(resizable || whrL.resizable || whrM.resizable || whrS.resizable);
            data.setFrameBorder(frameBorder);
            data.setEncryptedMedia(encryptedMedia);
            data.setAccelerometer(accelerometer);
            data.setAutoplay(autoplay);
            data.setGyroscope(gyroscope);
            data.setPictureInPicture(pictureInPicture);
            data.setFullScreen(fullScreen);
            data.setLoading(loading);
            data.setReferrerPolicy(referrerPolicy);
            data.setSandbox(sandbox);
            data.setEncodingEnabled(encoding);
        }
    }

    private void annotateFileReference(Field field) {
        boolean aye;
        String fieldName = this.fullFieldName(field);
        Class<FileReference> annotationClass = FileReference.class;
        Class[] validTypes = new Class[]{StringParameter.class, StringProperty.class};
        boolean log = this.isParameter() || this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            Pattern pattern;
            String textFieldName;
            String loadFieldName;
            String joinFieldName;
            String blobFieldName;
            UploadStorageOption uploadStorageOption;
            MimeType[] types;
            int max;
            int fileLimit;
            boolean autoStart;
            StringData data;
            block11: {
                this._annotatedWithFileReference = true;
                data = (StringData)this;
                FileReference annotation = field.getAnnotation(FileReference.class);
                autoStart = annotation.autoStart().toBoolean(data.isFileUploadAutoStart());
                fileLimit = this.specified(annotation.fileLimit(), data.getFileUploadFileLimit());
                max = this.specified(annotation.max(), data.getMaxInputFileSize());
                types = this.specified(annotation.types(), data.getValidInputFileTypes());
                String regex = this.specified(annotation.regex(), data.getValidInputFilePatternRegex());
                uploadStorageOption = (UploadStorageOption)this.specified(new UploadStorageOption[]{annotation.storage(), data.getUploadStorageOption()});
                blobFieldName = this.specified(annotation.blobField(), data.getBlobFieldName());
                joinFieldName = this.specified(annotation.joinField(), data.getJoinFieldName());
                loadFieldName = this.specified(annotation.loadField(), data.getLoadFieldName());
                textFieldName = this.specified(annotation.textField(), data.getTextFieldName());
                if (fileLimit < 0) {
                    fileLimit = 1;
                } else if (fileLimit < 1 || fileLimit > 100) {
                    fileLimit = 1;
                    if (log) {
                        logger.error((Object)(fieldName + " has an invalid file limit"));
                        Project.increaseParserErrorCount();
                    }
                }
                if (max < 0) {
                    max = 100000;
                }
                pattern = null;
                if (StringUtils.isNotBlank((String)regex)) {
                    try {
                        pattern = Pattern.compile(regex);
                    }
                    catch (PatternSyntaxException ex) {
                        if (!log) break block11;
                        logger.error((Object)(fieldName + " has an invalid regular expression"));
                        Project.increaseParserErrorCount();
                    }
                }
            }
            if (UploadStorageOption.FILE.equals((Object)uploadStorageOption) && StringUtils.isNotBlank((String)blobFieldName)) {
                uploadStorageOption = UploadStorageOption.UNSPECIFIED;
                if (log) {
                    logger.error((Object)(fieldName + " has an invalid file reference: blob field cannot be specified if storage is FILE"));
                    Project.increaseParserErrorCount();
                }
            }
            data.setFileUploadAutoStart(autoStart);
            data.setFileUploadFileLimit(fileLimit);
            data.setMaxInputFileSize(max);
            data.setValidInputFileTypes(types);
            data.setValidInputFilePattern(pattern);
            data.setUploadStorageOption(uploadStorageOption);
            this.setFieldReferenceBlobProperty(blobFieldName, fieldName);
            this.setFieldReferenceJoinProperty(joinFieldName, fieldName);
            this.setFieldReferenceLoadProperty(loadFieldName, fieldName);
            this.setFieldReferenceTextProperty(textFieldName, fieldName);
            this.setFieldReferenceLoadPropertyCurrentValue();
        }
    }

    private void setFieldReferenceBlobProperty(String blobFieldName, String fieldName) {
        StringData data = (StringData)this;
        if (StringUtils.isNotBlank((String)blobFieldName)) {
            data.setBlobFieldName(blobFieldName);
            boolean log = this.isParameter() || this.depth() == 0;
            Operation declaringOperation = this.getDeclaringOperation();
            Entity declaringEntity = declaringOperation == null ? this.getDeclaringEntity() : declaringOperation.getDeclaringEntity();
            Comparable<Entity> declaringArtifact = declaringOperation == null ? declaringEntity : declaringOperation;
            ProcessOperation process = declaringOperation instanceof ProcessOperation ? (ProcessOperation)declaringOperation : null;
            Class<? extends Entity> constructionType = process == null ? null : process.getConstructionType();
            boolean differentEntity = false;
            if (constructionType != null && !constructionType.equals(declaringEntity.getDataClass())) {
                declaringEntity = TLC.getProject().getEntity(constructionType);
                differentEntity = true;
            }
            Object[] strings = new String[]{declaringArtifact.getName(), this.getName(), "blobField"};
            String role = StringUtils.join((Object[])strings, (String)".");
            Class[] validTypes = new Class[]{BinaryProperty.class};
            Field blobField = XS1.getField(log, role, blobFieldName, declaringEntity.getClass(), Entity.class, validTypes);
            if (blobField != null) {
                Field previous = data.setBlobField(blobField);
                if (log && previous != null && previous != blobField) {
                    logger.warn((Object)(fieldName + " blob field was previously assigned to another file reference"));
                    Project.increaseParserWarningCount();
                }
                data.setBlobEntity(declaringEntity);
                Property blobProperty = XS1.getProperty(blobField, declaringEntity, differentEntity);
                if (blobProperty != null) {
                    data.setBlobProperty(blobProperty);
                }
            }
        }
    }

    private void setFieldReferenceJoinProperty(String joinFieldName, String fieldName) {
        StringData data = (StringData)this;
        if (StringUtils.isNotBlank((String)joinFieldName)) {
            data.setJoinFieldName(joinFieldName);
            boolean log = this.isParameter() || this.depth() == 0;
            Operation declaringOperation = this.getDeclaringOperation();
            Entity declaringEntity = declaringOperation == null ? this.getDeclaringEntity() : declaringOperation.getDeclaringEntity();
            Comparable<Entity> declaringArtifact = declaringOperation == null ? declaringEntity : declaringOperation;
            ProcessOperation process = declaringOperation instanceof ProcessOperation ? (ProcessOperation)declaringOperation : null;
            Class<? extends Entity> constructionType = process == null ? null : process.getConstructionType();
            boolean differentEntity = false;
            if (constructionType != null && !constructionType.equals(declaringEntity.getDataClass())) {
                declaringEntity = TLC.getProject().getEntity(constructionType);
                differentEntity = true;
            }
            Object[] strings = new String[]{declaringArtifact.getName(), this.getName(), "joinField"};
            String role = StringUtils.join((Object[])strings, (String)".");
            Class<?>[] validTypes = this.joinFieldValidTypes();
            Field joinField = XS1.getField(log, role, joinFieldName, declaringEntity.getClass(), Entity.class, validTypes);
            if (joinField != null) {
                Field previous = data.setJoinField(joinField);
                if (log && previous != null && previous != joinField) {
                    logger.warn((Object)(fieldName + " join field was previously assigned to another file reference"));
                    Project.increaseParserWarningCount();
                }
                data.setJoinEntity(declaringEntity);
                Property joinProperty = XS1.getProperty(joinField, declaringEntity, differentEntity);
                if (joinProperty != null) {
                    data.setJoinProperty(joinProperty);
                }
            }
        }
    }

    private void setFieldReferenceLoadProperty(String loadFieldName, String fieldName) {
        StringData data = (StringData)this;
        if (StringUtils.isNotBlank((String)loadFieldName)) {
            data.setLoadFieldName(loadFieldName);
            boolean log = this.isParameter() || this.depth() == 0;
            Operation declaringOperation = this.getDeclaringOperation();
            Entity declaringEntity = declaringOperation == null ? this.getDeclaringEntity() : declaringOperation.getDeclaringEntity();
            Comparable<Entity> declaringArtifact = declaringOperation == null ? declaringEntity : declaringOperation;
            ProcessOperation process = declaringOperation instanceof ProcessOperation ? (ProcessOperation)declaringOperation : null;
            Class<? extends Entity> constructionType = process == null ? null : process.getConstructionType();
            boolean differentEntity = false;
            if (constructionType != null && !constructionType.equals(declaringEntity.getDataClass())) {
                declaringEntity = TLC.getProject().getEntity(constructionType);
                differentEntity = true;
            }
            Object[] strings = new String[]{declaringArtifact.getName(), this.getName(), "loadField"};
            String role = StringUtils.join((Object[])strings, (String)".");
            Class[] validTypes = new Class[]{DateProperty.class, TimestampProperty.class};
            Field loadField = XS1.getField(log, role, loadFieldName, declaringEntity.getClass(), Entity.class, validTypes);
            if (loadField != null) {
                Field previous = data.setLoadField(loadField);
                if (log && previous != null && previous != loadField) {
                    logger.warn((Object)(fieldName + " load field was previously assigned to another file reference"));
                    Project.increaseParserWarningCount();
                }
                data.setLoadEntity(declaringEntity);
                Property loadProperty = XS1.getProperty(loadField, declaringEntity, differentEntity);
                if (loadProperty != null) {
                    data.setLoadProperty(loadProperty);
                }
            }
        }
    }

    private void setFieldReferenceTextProperty(String textFieldName, String fieldName) {
        StringData data = (StringData)this;
        if (StringUtils.isNotBlank((String)textFieldName)) {
            data.setTextFieldName(textFieldName);
            boolean log = this.isParameter() || this.depth() == 0;
            Operation declaringOperation = this.getDeclaringOperation();
            Entity declaringEntity = declaringOperation == null ? this.getDeclaringEntity() : declaringOperation.getDeclaringEntity();
            Comparable<Entity> declaringArtifact = declaringOperation == null ? declaringEntity : declaringOperation;
            ProcessOperation process = declaringOperation instanceof ProcessOperation ? (ProcessOperation)declaringOperation : null;
            Class<? extends Entity> constructionType = process == null ? null : process.getConstructionType();
            boolean differentEntity = false;
            if (constructionType != null && !constructionType.equals(declaringEntity.getDataClass())) {
                declaringEntity = TLC.getProject().getEntity(constructionType);
                differentEntity = true;
            }
            Object[] strings = new String[]{declaringArtifact.getName(), this.getName(), "textField"};
            String role = StringUtils.join((Object[])strings, (String)".");
            Class[] validTypes = new Class[]{StringProperty.class};
            Field textField = XS1.getField(log, role, textFieldName, declaringEntity.getClass(), Entity.class, validTypes);
            if (textField != null) {
                Field previous = data.setTextField(textField);
                if (log && previous != null && previous != textField) {
                    logger.warn((Object)(fieldName + " text field was previously assigned to another file reference"));
                    Project.increaseParserWarningCount();
                }
                data.setTextEntity(declaringEntity);
                Property textProperty = XS1.getProperty(textField, declaringEntity, differentEntity);
                if (textProperty != null) {
                    data.setTextProperty(textProperty);
                }
            }
        }
    }

    private void setFieldReferenceLoadPropertyCurrentValue() {
        Parameter instanceParameter;
        StringData data = (StringData)this;
        Operation declaringOperation = this.getDeclaringOperation();
        if (declaringOperation != null && (instanceParameter = declaringOperation.getInstanceParameter()) instanceof Entity) {
            String loadFieldName;
            Entity instanceEntity = (Entity)((Object)instanceParameter);
            Property loadProperty = data.getLoadProperty();
            if (loadProperty != null && StringUtils.isNotBlank((String)(loadFieldName = loadProperty.getName()))) {
                for (Property instanceProperty : instanceEntity.getPropertiesList()) {
                    if (!loadFieldName.equals(instanceProperty.getName())) continue;
                    if (instanceProperty instanceof DateProperty) {
                        ((DateProperty)instanceProperty).setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
                        break;
                    }
                    if (!(instanceProperty instanceof TimestampProperty)) break;
                    ((TimestampProperty)instanceProperty).setCurrentValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
                    break;
                }
            }
        }
    }

    private Class<?>[] joinFieldValidTypes() {
        Class<? extends Entity> clazz = TLC.getProject().getUploadedFileEntityClass();
        Class valid = clazz == null ? Entity.class : clazz;
        return new Class[]{valid};
    }

    private void annotateGraphicImage(Field field) {
        boolean aye;
        String fieldName = this.fullFieldName(field);
        Class<GraphicImage> annotationClass = GraphicImage.class;
        Class[] validTypes = new Class[]{BinaryProperty.class};
        boolean log = this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            this._annotatedWithGraphicImage = true;
            BinaryData data = (BinaryData)this;
            GraphicImage annotation = field.getAnnotation(GraphicImage.class);
            int[] displayWidth = Arrays.copyOf(annotation.displayWidth(), WHR.COMPONENT_DISPLAY_SIZE.length);
            int[] displayHeight = Arrays.copyOf(annotation.displayHeight(), WHR.COMPONENT_DISPLAY_SIZE.length);
            boolean resizable = annotation.resizable().toBoolean(data.isResizable());
            WHR whrL = new WHR(fieldName, log, 0, displayWidth[0], displayHeight[0], 24, 24, WHR.DEF_IMG_W[0], WHR.DEF_IMG_H[0]);
            WHR whrM = new WHR(fieldName, log, 1, displayWidth[1], displayHeight[1], 24, 24, WHR.DEF_IMG_W[1], WHR.DEF_IMG_H[1]);
            WHR whrS = new WHR(fieldName, log, 2, displayWidth[2], displayHeight[2], 24, 24, WHR.DEF_IMG_W[2], WHR.DEF_IMG_H[2]);
            data.setLargeDisplayWidth(whrL.displayWidth);
            data.setLargeDisplayHeight(whrL.displayHeight);
            data.setMediumDisplayWidth(whrM.displayWidth);
            data.setMediumDisplayHeight(whrM.displayHeight);
            data.setSmallDisplayWidth(whrS.displayWidth);
            data.setSmallDisplayHeight(whrS.displayHeight);
            data.setResizable(resizable || whrL.resizable || whrM.resizable || whrS.resizable);
        }
    }

    private void annotateMasterSequenceProperty(Field field) {
        boolean aye;
        Class<MasterSequence> annotationClass = MasterSequence.class;
        Class[] validTypes = new Class[]{IntegerProperty.class};
        boolean log = this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            this._annotatedWithMasterSequence = true;
            IntegerProperty property = (IntegerProperty)this;
            MasterSequence annotation = field.getAnnotation(MasterSequence.class);
            String fieldName = annotation.masterField();
            int start = Math.min(10000, Math.max(1, annotation.start()));
            int step = Math.min(10000, Math.max(1, annotation.step()));
            NextValueRule rule = annotation.nextValueRule();
            this.setMasterSequenceMasterProperty(fieldName);
            property.setMasterSequenceStart(start);
            property.setMasterSequenceStep(step);
            property.setMasterSequenceNextValueRule(rule);
        }
    }

    private void setMasterSequenceMasterProperty(String masterFieldName) {
        IntegerProperty property = (IntegerProperty)this;
        if (StringUtils.isNotBlank((String)masterFieldName)) {
            property.setMasterSequenceMasterFieldName(masterFieldName);
            boolean log = this.depth() == 0;
            Entity declaringEntity = this.getDeclaringEntity();
            Object[] strings = new String[]{declaringEntity.getName(), this.getName(), "masterField"};
            String role = StringUtils.join((Object[])strings, (String)".");
            Class[] validTypes = new Class[]{EntityReference.class};
            Field masterField = XS1.getField(log, role, masterFieldName, declaringEntity.getClass(), Entity.class, validTypes);
            if (masterField != null) {
                property.setMasterSequenceMasterField(masterField);
                Property masterProperty = XS1.getProperty(masterField, declaringEntity);
                if (masterProperty instanceof EntityReference) {
                    EntityReference masterEntityReference = (EntityReference)masterProperty;
                    MasterDetailView masterDetailView = masterEntityReference.getMasterDetailView();
                    if (MasterDetailView.TABLE.equals((Object)masterDetailView) || MasterDetailView.TABLE_AND_DETAIL.equals((Object)masterDetailView)) {
                        property.setMasterSequenceMasterProperty(masterProperty);
                        masterEntityReference.setMasterSequenceMasterField(true);
                    } else if (log) {
                        String message = this.getFullName() + " has an invalid master field in its MasterSequence annotation";
                        logger.error((Object)message);
                        Project.increaseParserErrorCount();
                    }
                } else if (log) {
                    String message = this.getFullName() + " has an invalid master field name in its MasterSequence annotation";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                }
            }
        }
    }

    private void annotateUniformResourceLocator(Field field) {
        boolean aye;
        Class<UniformResourceLocator> annotationClass = UniformResourceLocator.class;
        Class[] validTypes = new Class[]{StringProperty.class};
        boolean log = this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            this._annotatedWithUniformResourceLocator = true;
            StringData data = (StringData)this;
            UniformResourceLocator annotation = field.getAnnotation(UniformResourceLocator.class);
            UrlType urlType = (UrlType)this.specified(new UrlType[]{annotation.urlType(), data.getUrlType()});
            DisplayMode urlDisplayMode = (DisplayMode)this.specified(new DisplayMode[]{annotation.urlDisplayMode(), data.getUrlDisplayMode()});
            UrlDisplayType urlDisplayType = (UrlDisplayType)this.specified(new UrlDisplayType[]{annotation.urlDisplayType(), data.getUrlDisplayType()});
            String[] sourceURLs = null;
            String searchURL = null;
            Pattern pattern = data.getPattern();
            boolean encoding = annotation.encoding().toBoolean(data.isEncodingEnabled());
            if (UrlType.EXTERNAL.equals((Object)urlType)) {
                sourceURLs = this.specified(annotation.sourceURLs(), data.getSourceURLs());
                searchURL = this.specified(annotation.searchURL(), data.getSearchURL());
                if (pattern == null) {
                    pattern = Pattern.compile("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]$");
                }
            }
            data.setUrlType(urlType);
            data.setUrlDisplayMode(urlDisplayMode);
            data.setUrlDisplayType(urlDisplayType);
            data.setSourceURLs(sourceURLs);
            data.setSearchURL(searchURL);
            data.setPattern(pattern);
            data.setEncodingEnabled(encoding);
        }
    }

    private void annotateVariantString(Field field) {
        VariantString annotation = field.getAnnotation(VariantString.class);
        if (annotation != null && annotation.value()) {
            Class<VariantString> annotationClass = VariantString.class;
            Class[] validTypes = new Class[]{StringProperty.class};
            boolean log = this.depth() == 0;
            this._annotatedWithVariantString = XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        }
    }

    private void annotateInstanceReference(Field field) {
        Operation declaringOperation;
        Class<?> declaringClass;
        Class[] validTypes;
        Class<InstanceReference> annotationClass;
        boolean log;
        boolean aye;
        InstanceReference annotation = field.getAnnotation(InstanceReference.class);
        if (annotation != null && annotation.value() && (aye = XS1.checkFieldAnnotation(log = true, field, annotationClass = InstanceReference.class, validTypes = new Class[]{declaringClass = (declaringOperation = this.getDeclaringOperation()).getDeclaringField().getDeclaringClass()}))) {
            Field previous = this.getDeclaringArtifact().put(annotationClass, field);
            if (previous == null) {
                this._annotatedWithInstanceReference = true;
                declaringOperation.setOperationKind(OperationKind.INSTANCE);
            } else if (log) {
                XS1.logDuplicateAnnotation(field, annotationClass, previous);
            }
        }
        if (this._annotatedWithInstanceReference) {
            this._required = true;
        }
    }

    private void annotateParameterField(Field field) {
        Class<ParameterField> annotationClass = ParameterField.class;
        boolean aye = field.isAnnotationPresent(annotationClass);
        if (aye) {
            ParameterField annotation = field.getAnnotation(ParameterField.class);
            this._annotatedWithParameterField = true;
            this._auditable = annotation.auditable().toBoolean(this._auditable);
            this._password = annotation.password().toBoolean(this._password);
            this._required = this._annotatedWithInstanceReference ? Boolean.TRUE : annotation.required().toBoolean(this._required);
            this._hiddenField = !this._annotatedWithInstanceReference && annotation.hidden().toBoolean(this._hiddenField);
            this._linkedFieldName = annotation.linkedField();
            this._linkedColumnName = annotation.linkedColumn();
            this._linkedColumnOperator = annotation.operator();
            this.setAnchorParameter(annotation);
            this._sequenceNumber = annotation.sequence();
            this.linkField(this.namesakable() ? this.getName() : this._linkedFieldName);
            String fileName = annotation.snippet();
            if (StringUtils.isNotBlank((String)fileName)) {
                this.setProcessingConsoleSnippetFileName(fileName);
            }
        }
    }

    private void setAnchorParameter(ParameterField annotation) {
        String anchorFieldName = annotation.anchor();
        if (StringUtils.isNotBlank((String)anchorFieldName)) {
            boolean log = this.isLoggable();
            if (anchorFieldName.equals(this.getName())) {
                if (log) {
                    String message = "no anchor defined for " + this.getFullName() + "; a parameter cannot be anchored to itself.";
                    logger.warn((Object)message);
                    Project.increaseParserWarningCount();
                }
            } else {
                this._anchorFieldName = anchorFieldName;
                Operation declaringOperation = this.getDeclaringOperation();
                Object[] strings = new String[]{declaringOperation.getName(), this.getName(), "anchorField"};
                String role = StringUtils.join((Object[])strings, (String)".");
                Class<?>[] validTypes = null;
                Field anchorField = XS1.getField(log, role, anchorFieldName, declaringOperation.getClass(), Operation.class, validTypes);
                if (anchorField == null) {
                    if (log) {
                        String message = "no anchor defined for " + this.getFullName() + "; it has an invalid anchor field name.";
                        logger.warn((Object)message);
                        Project.increaseParserWarningCount();
                    }
                } else {
                    this._anchorField = anchorField;
                    Parameter anchorParameter = XS1.getParameter(anchorField, declaringOperation);
                    if (anchorParameter == null) {
                        if (log) {
                            String message = "no anchor defined for " + this.getFullName() + "; it has an invalid anchor parameter name.";
                            logger.warn((Object)message);
                            Project.increaseParserWarningCount();
                        }
                    } else {
                        this._anchorParameter = anchorParameter;
                        this._anchorType = annotation.anchorType();
                    }
                }
            }
        }
    }

    private boolean namesakable() {
        if (StringUtils.isBlank((String)this._linkedFieldName) && StringUtils.isBlank((String)this._linkedColumnName)) {
            Operation declaringOperation = this.getDeclaringOperation();
            if (declaringOperation instanceof ExportOperation) {
                ExportOperation export = (ExportOperation)declaringOperation;
                return ExportQueryType.DYNAMIC.equals((Object)export.getQueryType());
            }
            if (declaringOperation instanceof ReportOperation) {
                ReportOperation report = (ReportOperation)declaringOperation;
                return ReportQueryType.DYNAMIC.equals((Object)report.getQueryType());
            }
        }
        return false;
    }

    private void linkField(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            Class[] classArray;
            Operation declaringOperation = this.getDeclaringOperation();
            Entity declaringEntity = declaringOperation.getDeclaringEntity();
            ProcessOperation process = declaringOperation instanceof ProcessOperation ? (ProcessOperation)declaringOperation : null;
            Class<? extends Entity> constructionType = process == null ? null : process.getConstructionType();
            boolean differentEntity = false;
            if (constructionType != null && !constructionType.equals(declaringEntity.getDataClass())) {
                declaringEntity = TLC.getProject().getEntity(constructionType);
                differentEntity = true;
            }
            Object[] strings = new String[]{declaringOperation.getName(), this.getName(), "linkedField"};
            String role = StringUtils.join((Object[])strings, (String)".");
            if (this._dataClass == null) {
                classArray = new Class[]{};
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = this._dataClass;
            }
            Class[] validTypes = classArray;
            this._linkedField = XS1.getField(true, role, name, declaringEntity.getClass(), Entity.class, validTypes);
            if (this._linkedField != null) {
                this._linkedFieldName = name;
                this._linkedEntity = declaringEntity;
                this._linkedProperty = XS1.getProperty(this._linkedField, declaringEntity, differentEntity);
            }
        }
    }

    private void annotatePropertyField(Field field) {
        Class<PropertyField> annotationClass = PropertyField.class;
        boolean log = this.isLoggable();
        boolean aye = field.isAnnotationPresent(annotationClass);
        if (aye) {
            PropertyField annotation = field.getAnnotation(PropertyField.class);
            this._annotatedWithPropertyField = true;
            this._propertyAccess = (PropertyAccess)this.specified(new PropertyAccess[]{annotation.access(), this._propertyAccess});
            this._auditable = annotation.auditable().toBoolean(this._auditable);
            this._password = annotation.password().toBoolean(this._password);
            this._required = annotation.required().toBoolean(this._required);
            this._hiddenField = annotation.hidden().toBoolean(this._hiddenField);
            this._createField = annotation.create().toBoolean(this._createField);
            this._updateField = annotation.update().toBoolean(this._updateField);
            this._searchField = annotation.search().toBoolean(this._searchField);
            this._filterField = annotation.filter().toBoolean(this._filterField);
            this._sortField = annotation.sort().toBoolean(this._sortField);
            this._tableField = annotation.table().toBoolean(this._tableField);
            this._detailField = annotation.detail().toBoolean(this._detailField);
            this._columnField = annotation.column().toBoolean(this._columnField);
            this._reportField = annotation.report().toBoolean(this._reportField);
            this._exportField = annotation.export().toBoolean(this._exportField);
            this._headertextlessField = annotation.headertextless().toBoolean(this._headertextlessField);
            this._headingField = annotation.heading().toBoolean(this._headingField);
            this._overlayField = annotation.overlay().toBoolean(this._overlayField);
            this._prominentField = annotation.prominent().toBoolean(this._prominentField);
            this._immutableField = annotation.immutable().toBoolean(this._immutableField);
            this._serializableField = annotation.serializable().toBoolean(this._serializableField);
            this._serializableIUID = annotation.serializableIUID().toBoolean(this._serializableIUID);
            this._defaultCondition = (DefaultCondition)this.specified(new DefaultCondition[]{annotation.defaultCondition(), this._defaultCondition});
            this._defaultCheckpoint = (Checkpoint)this.specified(new Checkpoint[]{annotation.defaultCheckpoint(), this._defaultCheckpoint});
            this._defaultFunction = StringUtils.defaultIfBlank((String)StringUtils.trimToNull((String)annotation.defaultFunction()), (String)this._defaultFunction);
            this.setAnchorProperty(annotation);
            this._sequenceNumber = annotation.sequence();
            String fileName = annotation.masterHeadingSnippet();
            if (StringUtils.isNotBlank((String)fileName)) {
                this.setMasterHeadingSnippetFileName(fileName);
            }
            if (StringUtils.isNotBlank((String)(fileName = annotation.readingTableSnippet()))) {
                this.setReadingTableSnippetFileName(fileName);
            }
            if (StringUtils.isNotBlank((String)(fileName = annotation.writingTableSnippet()))) {
                this.setWritingTableSnippetFileName(fileName);
            }
            if (StringUtils.isNotBlank((String)(fileName = annotation.readingDetailSnippet()))) {
                this.setReadingDetailSnippetFileName(fileName);
            }
            if (StringUtils.isNotBlank((String)(fileName = annotation.writingDetailSnippet()))) {
                this.setWritingDetailSnippetFileName(fileName);
            }
        }
        if (log) {
            this.checkPropertyFieldElements();
        }
    }

    private void setAnchorProperty(PropertyField annotation) {
        String anchorFieldName = annotation.anchor();
        if (StringUtils.isNotBlank((String)anchorFieldName)) {
            boolean log = this.isLoggable();
            if (anchorFieldName.equals(this.getName())) {
                if (log) {
                    String message = "no anchor defined for " + this.getFullName() + "; a property cannot be anchored to itself.";
                    logger.warn((Object)message);
                    Project.increaseParserWarningCount();
                }
            } else {
                this._anchorFieldName = anchorFieldName;
                Entity declaringEntity = this.getDeclaringEntity();
                Object[] strings = new String[]{declaringEntity.getName(), this.getName(), "anchorField"};
                String role = StringUtils.join((Object[])strings, (String)".");
                Class<?>[] validTypes = null;
                Field anchorField = XS1.getField(log, role, anchorFieldName, declaringEntity.getClass(), Entity.class, validTypes);
                if (anchorField == null) {
                    if (log) {
                        String message = "no anchor defined for " + this.getFullName() + "; it has an invalid anchor field name.";
                        logger.warn((Object)message);
                        Project.increaseParserWarningCount();
                    }
                } else {
                    this._anchorField = anchorField;
                    Property anchorProperty = XS1.getProperty(anchorField, declaringEntity);
                    if (anchorProperty == null) {
                        if (log) {
                            String message = "no anchor defined for " + this.getFullName() + "; it has an invalid anchor property name.";
                            logger.warn((Object)message);
                            Project.increaseParserWarningCount();
                        }
                    } else {
                        this._anchorProperty = anchorProperty;
                        this._anchorType = annotation.anchorType();
                    }
                }
            }
        }
    }

    private void checkPropertyFieldElements() {
        String message;
        if (this._defaultFunction != null && this._defaultFunction.matches("^.*\\bold\\..*$")) {
            switch (this._defaultCondition) {
                case IF_NULL_ON_UPDATE: 
                case UNCONDITIONALLY_ON_UPDATE: {
                    break;
                }
                default: {
                    message = this.getFullName() + " default function cannot reference \"old\" pseudo-record due to its default condition; old is valid only for IF_NULL_ON_UPDATE and UNCONDITIONALLY_ON_UPDATE";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                }
            }
        }
        if (this.restrictedReadingAccess()) {
            if (BitUtils.valueOf(this._headingField)) {
                message = this.getFullName() + " cannot be a heading property due to its restricted reading access";
                logger.warn((Object)message);
                Project.increaseParserWarningCount();
            }
            if (BitUtils.valueOf(this._overlayField)) {
                message = this.getFullName() + " cannot be an overlay property due to its restricted reading access";
                logger.warn((Object)message);
                Project.increaseParserWarningCount();
            }
            if (BitUtils.valueOf(this._prominentField)) {
                message = this.getFullName() + " cannot be a prominent property due to its restricted reading access";
                logger.warn((Object)message);
                Project.increaseParserWarningCount();
            }
        }
    }

    private void annotatePropertyAggregation(Field field) {
        Class<PropertyAggregation> annotationClass = PropertyAggregation.class;
        boolean aye = field.isAnnotationPresent(annotationClass);
        if (aye) {
            PropertyAggregation annotation = field.getAnnotation(PropertyAggregation.class);
            this._annotatedWithPropertyAggregation = true;
            this._aggregateFunction = (AggregateFunction)this.specified(new AggregateFunction[]{annotation.function(), this._aggregateFunction});
            this._aggregateTitle = this.specified(annotation.title(), this._aggregateTitle);
            if (!this._aggregateTitle.isEmpty()) {
                this.setAggregateTitle(this._aggregateTitle);
            }
        }
        this._aggregateFunction = this.validAggregateFunction();
    }

    private AggregateFunction validAggregateFunction() {
        if (this._aggregateFunction == null || this._aggregateFunction.equals((Object)AggregateFunction.UNSPECIFIED)) {
            return AggregateFunction.UNSPECIFIED;
        }
        if (this.isNumericPrimitive()) {
            return this._aggregateFunction;
        }
        if (this.isTemporalPrimitive()) {
            switch (this._aggregateFunction) {
                case COUNT: 
                case MINIMUM: 
                case MAXIMUM: {
                    return this._aggregateFunction;
                }
            }
            this.logUsingCountAggregation();
            return AggregateFunction.COUNT;
        }
        if (this.isEntity() || this.isBooleanPrimitive() || this.isCharacterPrimitive()) {
            if (this._aggregateFunction.equals((Object)AggregateFunction.COUNT)) {
                return this._aggregateFunction;
            }
            this.logUsingCountAggregation();
            return AggregateFunction.COUNT;
        }
        this.logNonAggregable();
        return AggregateFunction.UNSPECIFIED;
    }

    private void logUsingCountAggregation() {
        if (this.isLoggable()) {
            String message = this._aggregateFunction + " cannot be applied to " + this.getFullName() + "; using COUNT instead";
            logger.warn((Object)message);
            Project.increaseParserWarningCount();
        }
    }

    private void logNonAggregable() {
        if (this.isLoggable()) {
            String message = "no aggregation can be applied to " + this.getFullName();
            logger.error((Object)message);
            Project.increaseParserErrorCount();
        }
    }

    private void annotateDataGen(Field field) {
        this.annotateBooleanDataGen(field);
        this.annotateCharacterDataGen(field);
        this.annotateNumericDataGen(field);
        this.annotateTemporalDataGen(field);
    }

    private void annotateBooleanDataGen(Field field) {
        boolean aye;
        Class<BooleanDataGen> annotationClass = BooleanDataGen.class;
        Class[] validTypes = new Class[]{BooleanProperty.class};
        boolean log = this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            BooleanDataGen annotation = field.getAnnotation(BooleanDataGen.class);
            this._annotatedWithDataGen = true;
            this._dataGenType = annotation.type();
            this.setDataGenFunction(annotation.function());
            this._dataGenNullable = Math.min(100, Math.max(0, annotation.nullable()));
            this._dataGenTrueable = Math.min(100, Math.max(0, annotation.trueable()));
            if (this._dataGenNullable + this._dataGenTrueable > 100) {
                this._dataGenNullable = 100 - this._dataGenTrueable;
            }
        }
    }

    private void annotateCharacterDataGen(Field field) {
        boolean aye;
        Class<CharacterDataGen> annotationClass = CharacterDataGen.class;
        Class[] validTypes = new Class[]{CharacterProperty.class, StringProperty.class};
        boolean log = this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            CharacterDataGen annotation = field.getAnnotation(CharacterDataGen.class);
            this._annotatedWithDataGen = true;
            this._dataGenType = annotation.type();
            this._loremIpsum = annotation.loremIpsum().toBoolean();
            this._dataGenSeriesStart = Math.min(2000000000, Math.max(1, annotation.start()));
            this._dataGenSeriesStop = Math.min(2100000000, Math.max(1, annotation.stop()));
            this._dataGenSeriesStep = Math.min(1000000, Math.max(1, annotation.step()));
            if (log && !this.isDataGenSeriesEnabled()) {
                String message = this.getFullName() + " has invalid values for elements start/stop/step of its CharacterDataGen annotation: " + this._dataGenSeriesStart + "/" + this._dataGenSeriesStop + "/" + this._dataGenSeriesStep;
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
            this.setDataGenFunction(annotation.function());
            this._dataGenNullable = Math.min(100, Math.max(0, annotation.nullable()));
            this._dataGenPattern = StringUtils.trimToNull((String)annotation.pattern());
            this._dataGenPrefix = StrUtils.ltrimToNull(annotation.prefix());
            this._dataGenSuffix = StrUtils.rtrimToNull(annotation.suffix());
        }
    }

    private void annotateNumericDataGen(Field field) {
        boolean aye;
        Class<NumericDataGen> annotationClass = NumericDataGen.class;
        Class[] validTypes = new Class[]{BigDecimalProperty.class, BigIntegerProperty.class, ByteProperty.class, ShortProperty.class, IntegerProperty.class, LongProperty.class, FloatProperty.class, DoubleProperty.class};
        boolean log = this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            NumericDataGen annotation = field.getAnnotation(NumericDataGen.class);
            this._annotatedWithDataGen = true;
            this._dataGenType = annotation.type();
            this._dataGenSeriesStart = Math.min(2000000000, Math.max(1, annotation.start()));
            this._dataGenSeriesStop = Math.min(2100000000, Math.max(1, annotation.stop()));
            this._dataGenSeriesStep = Math.min(1000000, Math.max(1, annotation.step()));
            if (log && !this.isDataGenSeriesEnabled()) {
                String message = this.getFullName() + " has invalid values for elements start/stop/step of its NumericDataGen annotation: " + this._dataGenSeriesStart + "/" + this._dataGenSeriesStop + "/" + this._dataGenSeriesStep;
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
            this.setDataGenFunction(annotation.function());
            this._dataGenNullable = Math.min(100, Math.max(0, annotation.nullable()));
            this._dataGenMin = StringUtils.trimToNull((String)annotation.min());
            this._dataGenMax = StringUtils.trimToNull((String)annotation.max());
            this._dataGenMinValue = this.someIntegerValue(field, this._dataGenMin);
            this._dataGenMaxValue = this.someIntegerValue(field, this._dataGenMax);
            this._dataGenNumericAction = annotation.action();
            this._dataGenFactor = this.someBigDecimalValue(field, annotation.factor());
        }
    }

    private void annotateTemporalDataGen(Field field) {
        boolean aye;
        Class<TemporalDataGen> annotationClass = TemporalDataGen.class;
        Class[] validTypes = new Class[]{DateProperty.class, TimeProperty.class, TimestampProperty.class};
        boolean log = this.depth() == 0;
        boolean bl = aye = field.isAnnotationPresent(annotationClass) && XS1.checkFieldAnnotation(log, field, annotationClass, validTypes);
        if (aye) {
            TemporalDataGen annotation = field.getAnnotation(TemporalDataGen.class);
            this._annotatedWithDataGen = true;
            this._dataGenType = annotation.type();
            this._dataGenSeriesStart = Math.min(2000000000, Math.max(1, annotation.start()));
            this._dataGenSeriesStop = Math.min(2100000000, Math.max(1, annotation.stop()));
            this._dataGenSeriesStep = Math.min(1000000, Math.max(1, annotation.step()));
            if (log && !this.isDataGenSeriesEnabled()) {
                String message = this.getFullName() + " has invalid values for elements start/stop/step of its TemporalDataGen annotation: " + this._dataGenSeriesStart + "/" + this._dataGenSeriesStop + "/" + this._dataGenSeriesStep;
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
            this.setDataGenFunction(annotation.function());
            this._dataGenNullable = Math.min(100, Math.max(0, annotation.nullable()));
            this._dataGenMin = StringUtils.trimToNull((String)annotation.min());
            this._dataGenMax = StringUtils.trimToNull((String)annotation.max());
            this._dataGenMinTemporalAddend = this.someTemporalAddend(this._dataGenMin);
            this._dataGenMaxTemporalAddend = this.someTemporalAddend(this._dataGenMax);
            this._dataGenMinValue = this.someTemporalValue(field, this._dataGenMin);
            this._dataGenMaxValue = this.someTemporalValue(field, this._dataGenMax);
            this._dataGenTemporalInterval = annotation.interval();
        }
    }

    private Integer someIntegerValue(Field field, String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            this.logInvalidDataExpression(field, "integer", e);
            return null;
        }
    }

    private BigDecimal someBigDecimalValue(Field field, String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        try {
            return new BigDecimal(string);
        }
        catch (Exception e) {
            this.logInvalidDataExpression(field, "decimal", e);
            return null;
        }
    }

    private TemporalAddend someTemporalAddend(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        if (this instanceof DateData) {
            TemporalAddend addend = this.someDateTemporalAddend(string);
            return addend == null || addend.isBadValue() ? null : addend;
        }
        if (this instanceof TimeData) {
            TemporalAddend addend = this.someTimeTemporalAddend(string);
            return addend == null || addend.isBadValue() ? null : addend;
        }
        if (this instanceof TimestampData) {
            TemporalAddend addend = this.someTimestampTemporalAddend(string);
            return addend == null || addend.isBadValue() ? null : addend;
        }
        return null;
    }

    private Date someTemporalValue(Field field, String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        if (this instanceof DateData) {
            return this.someDateValue(field, string);
        }
        if (this instanceof TimeData) {
            return this.someTimeValue(field, string);
        }
        if (this instanceof TimestampData) {
            return this.someTimestampValue(field, string);
        }
        return null;
    }

    private java.sql.Date someDateValue(Field field, String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        TemporalAddend addend = this.someDateTemporalAddend(string);
        if (addend == null) {
            try {
                return java.sql.Date.valueOf(string);
            }
            catch (Exception e) {
                this.logInvalidDataExpression(field, "date", e);
                return null;
            }
        }
        if (addend.isBadValue()) {
            this.logBadTemporalAddend(field, "date", addend);
            return null;
        }
        return TimeUtils.addDate(this.currentDate, Math.toIntExact(addend.getQuantity()), addend.getUnitCode());
    }

    private Time someTimeValue(Field field, String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        TemporalAddend addend = this.someTimeTemporalAddend(string);
        if (addend == null) {
            try {
                return Time.valueOf(string);
            }
            catch (Exception e) {
                this.logInvalidDataExpression(field, "time", e);
                return null;
            }
        }
        if (addend.isBadValue()) {
            this.logBadTemporalAddend(field, "time", addend);
            return null;
        }
        return TimeUtils.addTime(this.currentTime, Math.toIntExact(addend.getQuantity()), addend.getUnitCode());
    }

    private Timestamp someTimestampValue(Field field, String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        TemporalAddend addend = this.someTimestampTemporalAddend(string);
        if (addend == null) {
            try {
                return Timestamp.valueOf(string);
            }
            catch (Exception e) {
                this.logInvalidDataExpression(field, "timestamp", e);
                return null;
            }
        }
        if (addend.isBadValue()) {
            this.logBadTemporalAddend(field, "timestamp", addend);
            return null;
        }
        return TimeUtils.addTimestamp(this.currentTimestamp, Math.toIntExact(addend.getQuantity()), addend.getUnitCode());
    }

    private TemporalAddend someDateTemporalAddend(String string) {
        return TemporalAddend.temporalAddendValueOf(string, TemporalAddend.DATE_UNITS, 'D', TemporalAddend.MIN_INT_VALUE, TemporalAddend.MAX_INT_VALUE);
    }

    private TemporalAddend someTimeTemporalAddend(String string) {
        return TemporalAddend.temporalAddendValueOf(string, TemporalAddend.TIME_UNITS, 'h', TemporalAddend.MIN_INT_VALUE, TemporalAddend.MAX_INT_VALUE);
    }

    private TemporalAddend someTimestampTemporalAddend(String string) {
        return TemporalAddend.temporalAddendValueOf(string, TemporalAddend.DATE_TIME_UNITS, 'D', TemporalAddend.MIN_INT_VALUE, TemporalAddend.MAX_INT_VALUE);
    }

    private void logInvalidDataExpression(Field field, String string, Exception e) {
        boolean log;
        assert (e != null);
        boolean bl = log = this.depth() == 0;
        if (log) {
            String fieldName = this.fullFieldName(field);
            logger.error((Object)(fieldName + " has an invalid " + string + " data expression"));
            Project.increaseParserErrorCount();
        }
    }

    private void logBadTemporalAddend(Field field, String string, TemporalAddend addend) {
        boolean log;
        boolean bl = log = this.depth() == 0;
        if (log) {
            String fieldName = this.fullFieldName(field);
            logger.error((Object)(fieldName + " has an invalid " + string + " data expression; allowed value range is \"" + addend.getMinValue() + "\" to \"" + addend.getMaxValue() + "\""));
            Project.increaseParserErrorCount();
        }
    }

    private String fullFieldName(Field field) {
        return this.getDeclaringArtifactClassSimpleName() + "." + field.getName();
    }

    @Override
    public boolean isPrimitive() {
        return this instanceof Primitive;
    }

    @Override
    public boolean isBinaryPrimitive() {
        return this instanceof BinaryPrimitive;
    }

    @Override
    public boolean isBooleanPrimitive() {
        return this instanceof BooleanPrimitive;
    }

    @Override
    public boolean isCharacterPrimitive() {
        return this instanceof CharacterPrimitive;
    }

    @Override
    public boolean isNumericPrimitive() {
        return this instanceof NumericPrimitive;
    }

    @Override
    public boolean isTemporalPrimitive() {
        return this instanceof TemporalPrimitive;
    }

    @Override
    public boolean isBigDecimalData() {
        return this instanceof BigDecimalData;
    }

    @Override
    public boolean isBigIntegerData() {
        return this instanceof BigIntegerData;
    }

    @Override
    public boolean isBinaryData() {
        return this instanceof BinaryData;
    }

    private boolean isUndisplayableBinaryData() {
        return this.isBinaryData() && !this.isGraphicImageField();
    }

    @Override
    public boolean isBooleanData() {
        return this instanceof BooleanData;
    }

    @Override
    public boolean isByteData() {
        return this instanceof ByteData;
    }

    @Override
    public boolean isCharacterData() {
        return this instanceof CharacterData;
    }

    @Override
    public boolean isDateData() {
        return this instanceof DateData;
    }

    @Override
    public boolean isDoubleData() {
        return this instanceof DoubleData;
    }

    @Override
    public boolean isFloatData() {
        return this instanceof FloatData;
    }

    @Override
    public boolean isIntegerData() {
        return this instanceof IntegerData;
    }

    @Override
    public boolean isLongData() {
        return this instanceof LongData;
    }

    @Override
    public boolean isShortData() {
        return this instanceof ShortData;
    }

    @Override
    public boolean isStringData() {
        return this instanceof StringData;
    }

    private boolean isCharacterLargeObject() {
        return this instanceof StringData && ((StringData)this).isLargeObject();
    }

    @Override
    public boolean isTimeData() {
        return this instanceof TimeData;
    }

    @Override
    public boolean isTimestampData() {
        return this instanceof TimestampData;
    }

    @Override
    public boolean isEntity() {
        return this instanceof Entity;
    }

    @Override
    public boolean isContextualEntity() {
        return this instanceof ContextualEntity;
    }

    @Override
    public boolean isEnumerationEntity() {
        return this instanceof EnumerationEntity;
    }

    @Override
    public boolean isNonEnumerationEntity() {
        return this.isEntity() && !this.isEnumerationEntity();
    }

    @Override
    public boolean isDatabaseEntity() {
        return this instanceof DatabaseEntity;
    }

    @Override
    public boolean isPersistentEntity() {
        return this instanceof PersistentEntity;
    }

    @Override
    public boolean isPersistentEnumerationEntity() {
        return this instanceof PersistentEnumerationEntity;
    }

    @Override
    public boolean isPersistentNonEnumerationEntity() {
        return this.isPersistentEntity() && !this.isPersistentEnumerationEntity();
    }

    @Override
    public boolean isOverlayableEntityReference() {
        return false;
    }

    @Override
    public boolean isParameter() {
        return this instanceof Parameter && this.getDeclaringField() != null && this.getDeclaringArtifact() instanceof Operation;
    }

    public boolean isInstanceParameter() {
        if (this.isParameter()) {
            Operation operation = (Operation)this.getDeclaringArtifact();
            AbstractDataArtifact parameter = this;
            return OperationKind.INSTANCE.equals((Object)operation.getOperationKind()) && parameter.isInstanceReferenceField();
        }
        return false;
    }

    @Override
    public boolean isProperty() {
        return this instanceof Property && this.getDeclaringField() != null && this.getDeclaringArtifact() instanceof Entity;
    }

    private boolean isLoggableProperty() {
        return this.isProperty() && this.isLoggable();
    }

    private boolean isLoggable() {
        return this instanceof Entity ? this.depth() == 1 : this.depth() == 0;
    }

    private boolean isEnumerationEntityProperty() {
        return this.isProperty() && this.getDeclaringArtifact() instanceof EnumerationEntity;
    }

    @Override
    public boolean isPrimaryKeyProperty() {
        return this.isProperty() && (this._annotatedWithPrimaryKey || this.getDeclaringField().equals(this.getDeclaringEntity().getPrimaryKeyField()));
    }

    @Override
    public boolean isSequenceProperty() {
        return this.isProperty() && (this._annotatedWithSequenceProperty || this.getDeclaringField().equals(this.getDeclaringEntity().getSequenceField()));
    }

    @Override
    public boolean isVersionProperty() {
        return this.isProperty() && (this._annotatedWithVersionProperty || this.getDeclaringField().equals(this.getDeclaringEntity().getVersionField()));
    }

    @Override
    public boolean isNumericKeyProperty() {
        return this.isProperty() && this.getDeclaringField().equals(this.getDeclaringEntity().getNumericKeyField());
    }

    @Override
    public boolean isCharacterKeyProperty() {
        return this.isProperty() && this.getDeclaringField().equals(this.getDeclaringEntity().getCharacterKeyField());
    }

    @Override
    public boolean isNameProperty() {
        return this.isProperty() && (this._annotatedWithNameProperty || this.getDeclaringField().equals(this.getDeclaringEntity().getNameField()));
    }

    @Override
    public boolean isDescriptionProperty() {
        return this.isProperty() && (this._annotatedWithDescriptionProperty || this.getDeclaringField().equals(this.getDeclaringEntity().getDescriptionField()));
    }

    @Override
    public boolean isImageProperty() {
        return this.isProperty() && (this._annotatedWithImageProperty || this.getDeclaringField().equals(this.getDeclaringEntity().getImageField()));
    }

    @Override
    public boolean isInactiveIndicatorProperty() {
        return this.isProperty() && (this._annotatedWithInactiveIndicator || this.getDeclaringField().equals(this.getDeclaringEntity().getInactiveIndicatorField()));
    }

    @Override
    public boolean isUrlProperty() {
        return this.isProperty() && (this._annotatedWithUrlProperty || this.getDeclaringField().equals(this.getDeclaringEntity().getUrlField()));
    }

    @Override
    public boolean isParentProperty() {
        return this.isProperty() && (this._annotatedWithParentProperty || this.getDeclaringField().equals(this.getDeclaringEntity().getParentField()));
    }

    @Override
    public boolean isOwnerProperty() {
        return this.isProperty() && (this._annotatedWithOwnerProperty || this.getDeclaringField().equals(this.getDeclaringEntity().getOwnerField()));
    }

    @Override
    public boolean isUserProperty() {
        return this.isProperty() && (this._annotatedWithUserProperty || this.getDeclaringField().equals(this.getDeclaringEntity().getUserField()));
    }

    @Override
    public boolean isSegmentProperty() {
        return this.isProperty() && (this._annotatedWithSegmentProperty || this.getDeclaringField().equals(this.getDeclaringEntity().getSegmentField()));
    }

    @Override
    public boolean isUniqueKeyProperty() {
        return this.isProperty() && this.isUnique();
    }

    @Override
    public boolean isBusinessKeyProperty() {
        return this.isProperty() && (this._annotatedWithBusinessKey || this.getDeclaringField().equals(this.getDeclaringEntity().getBusinessKeyField()));
    }

    @Override
    public boolean isDiscriminatorProperty() {
        return this._annotatedWithDiscriminatorColumn;
    }

    @Override
    public boolean isStateProperty() {
        return this._annotatedWithStateProperty;
    }

    @Override
    public List<Artifact> getParameterPathList() {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        this.addToParameterPathList(list, this);
        return list;
    }

    private void addToParameterPathList(List<Artifact> list, Artifact artifact) {
        Artifact declaringArtifact = artifact.getDeclaringArtifact();
        if (declaringArtifact != null && !(declaringArtifact instanceof Operation)) {
            this.addToParameterPathList(list, declaringArtifact);
        }
        list.add(artifact);
    }

    public List<Artifact> getParameterPropertyPathList() {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        this.addToParameterPropertyPathList(list, this);
        return list;
    }

    private void addToParameterPropertyPathList(List<Artifact> list, Artifact artifact) {
        Artifact declaringArtifact = artifact.getDeclaringArtifact();
        if (declaringArtifact == null || declaringArtifact instanceof Operation) {
            return;
        }
        this.addToParameterPropertyPathList(list, declaringArtifact);
        list.add(artifact);
    }

    @Override
    public List<Artifact> getPropertyPathList() {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        this.addToPropertyPathList(list, this);
        return list;
    }

    private void addToPropertyPathList(List<Artifact> list, Artifact artifact) {
        Artifact declaringArtifact = artifact.getDeclaringArtifact();
        if (declaringArtifact == null) {
            if (!(artifact instanceof Entity)) {
                list.add(artifact);
            }
        } else {
            this.addToPropertyPathList(list, declaringArtifact);
            list.add(artifact);
        }
    }

    @Override
    public List<Artifact> getPropertyParameterPathList() {
        return this.getParameterPathList();
    }

    public boolean isMasterDependentPropertyOf(EntityReference master) {
        if (this.isProperty()) {
            Expression calculableValue;
            String fullName = this.getFullName();
            if (master == null || master.getFullName().equals(fullName)) {
                return false;
            }
            List<Property> masterDependentProperties = master.getMasterDependentProperties();
            if (masterDependentProperties != null && masterDependentProperties.contains(this)) {
                logger.trace((Object)(fullName + " is a master-dependent property of " + master.getName()));
                return true;
            }
            if (this.isCalculable() && this.referencedByExpression(calculableValue = this.calculableValueExpression(this.getCalculableValue()), master)) {
                logger.trace((Object)(fullName + " is a master-dependent property of " + master.getName() + " \u00b7 " + calculableValue.getDataType()));
                return true;
            }
        }
        return false;
    }

    private Expression calculableValueExpression(Object calculableValueObject) {
        return calculableValueObject instanceof Primitive ? (Primitive)calculableValueObject : (calculableValueObject instanceof Entity ? ((Entity)calculableValueObject).self() : null);
    }

    public Map<String, ? extends DataArtifact> getInitialValueReferencingSiblings() {
        return this.getInitialValueReferencingSiblings(false);
    }

    public Map<String, ? extends DataArtifact> getInitialValueReferencingSiblings(boolean recursively) {
        return this.isProperty() ? this.getInitialValueReferencingProperties(recursively) : (this.isParameter() ? this.getInitialValueReferencingParameters(recursively) : new LinkedHashMap());
    }

    public Map<String, ? extends DataArtifact> getInstanceParameterInitialValueReferencingSiblings() {
        return this.getInstanceParameterInitialValueReferencingSiblings(false);
    }

    public Map<String, ? extends DataArtifact> getInstanceParameterInitialValueReferencingSiblings(boolean recursively) {
        return this.isInstanceParameter() ? this.getInitialValueReferencingParameters(recursively) : new LinkedHashMap();
    }

    @Override
    public Map<String, Parameter> getInitialValueReferencingParameters() {
        return this.getInitialValueReferencingParameters(false);
    }

    @Override
    public Map<String, Parameter> getInitialValueReferencingParameters(boolean recursively) {
        Map<String, Parameter> initialValueReferencingParameters = this.initialValueReferencingParametersMap();
        String fullName = this.getFullName();
        Operation declaringOperation = this.getDeclaringOperation();
        List<Parameter> parametersList = declaringOperation.getParametersList();
        for (Parameter parameter : parametersList) {
            Expression initialValue;
            if (parameter.getFullName().equals(fullName) || !this.referencedByExpression(initialValue = this.initialValueExpression(parameter.getInitialValue()))) continue;
            logger.trace((Object)("parameter " + fullName + " is referenced by the initial value expression of " + parameter.getName()));
            initialValueReferencingParameters.put(parameter.getPathString(), parameter);
            if (!recursively) continue;
            initialValueReferencingParameters.putAll(parameter.getInitialValueReferencingParameters(recursively));
        }
        return initialValueReferencingParameters;
    }

    public Map<String, Parameter> getInitialValueReferencingParametersSortedBySequence(boolean recursively) {
        LinkedHashMap<String, Parameter> sorted = new LinkedHashMap<String, Parameter>();
        Map<String, Parameter> unsorted = this.getInitialValueReferencingParameters(recursively);
        List<Parameter> list = new ArrayList<Parameter>(unsorted.values());
        list = (List)ColUtils.sort(list, new ByParameterSequence());
        for (Parameter parameter : list) {
            sorted.put(parameter.getPathString(), parameter);
        }
        return sorted;
    }

    private Map<String, Parameter> initialValueReferencingParametersMap() {
        LinkedHashMap<String, Parameter> initialValueReferencingParameters = new LinkedHashMap<String, Parameter>();
        String fullName = this.getFullName();
        Operation declaringOperation = this.getDeclaringOperation();
        List<Parameter> parametersList = declaringOperation.getParametersList();
        for (Parameter parameter : this._initialValueReferencingParametersList) {
            if (parameter.getFullName().equals(fullName) || !parametersList.contains(parameter)) continue;
            initialValueReferencingParameters.put(parameter.getPathString(), parameter);
        }
        return initialValueReferencingParameters;
    }

    @Override
    public List<Parameter> getInitialValueReferencingParametersList() {
        return this._initialValueReferencingParametersList;
    }

    public void addInitialValueReferencedParameters(Parameter ... parameters) {
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                if (parameter == null) continue;
                parameter.getInitialValueReferencingParametersList().add(this);
            }
        }
    }

    @Override
    public Map<String, Property> getInitialValueReferencingProperties() {
        return this.getInitialValueReferencingProperties(false);
    }

    @Override
    public Map<String, Property> getInitialValueReferencingProperties(boolean recursively) {
        Map<String, Property> initialValueReferencingProperties = this.initialValueReferencingPropertiesMap();
        String fullName = this.getFullName();
        Entity declaringEntity = this.getDeclaringEntity();
        List<Property> propertiesList = declaringEntity.getPropertiesList();
        for (Property property : propertiesList) {
            Expression initialValue;
            if (property.getFullName().equals(fullName) || !this.referencedByExpression(initialValue = this.initialValueExpression(property.getInitialValue()))) continue;
            logger.trace((Object)("property " + fullName + " is referenced by the initial value expression of " + property.getName()));
            initialValueReferencingProperties.put(property.getPathString(), property);
            if (!recursively) continue;
            initialValueReferencingProperties.putAll(property.getInitialValueReferencingProperties(recursively));
        }
        return initialValueReferencingProperties;
    }

    public Map<String, Property> getInitialValueReferencingPropertiesSortedBySequence(boolean recursively) {
        LinkedHashMap<String, Property> sorted = new LinkedHashMap<String, Property>();
        Map<String, Property> unsorted = this.getInitialValueReferencingProperties(recursively);
        List<Property> list = new ArrayList<Property>(unsorted.values());
        list = (List)ColUtils.sort(list, new ByPropertyDisplaySortKey());
        for (Property property : list) {
            sorted.put(property.getPathString(), property);
        }
        return sorted;
    }

    private Map<String, Property> initialValueReferencingPropertiesMap() {
        LinkedHashMap<String, Property> initialValueReferencingProperties = new LinkedHashMap<String, Property>();
        String fullName = this.getFullName();
        Entity declaringEntity = this.getDeclaringEntity();
        List<Property> propertiesList = declaringEntity.getPropertiesList();
        for (Property property : this._initialValueReferencingPropertiesList) {
            if (property.getFullName().equals(fullName) || !propertiesList.contains(property)) continue;
            initialValueReferencingProperties.put(property.getPathString(), property);
        }
        return initialValueReferencingProperties;
    }

    @Override
    public List<Property> getInitialValueReferencingPropertiesList() {
        return this._initialValueReferencingPropertiesList;
    }

    public void addInitialValueReferencedProperties(Property ... properties) {
        if (properties != null) {
            for (Property property : properties) {
                if (property == null) continue;
                property.getInitialValueReferencingPropertiesList().add(this);
            }
        }
    }

    private Expression initialValueExpression(Object initialValueObject) {
        return initialValueObject instanceof Expression ? (Expression)initialValueObject : (initialValueObject instanceof Entity ? ((Entity)initialValueObject).self() : null);
    }

    public Map<String, ? extends DataArtifact> getMaxValueReferencingSiblings() {
        return this.getMaxValueReferencingSiblings(false);
    }

    public Map<String, ? extends DataArtifact> getMaxValueReferencingSiblings(boolean recursively) {
        return this.isProperty() ? this.getMaxValueReferencingProperties(recursively) : (this.isParameter() ? this.getMaxValueReferencingParameters(recursively) : new LinkedHashMap());
    }

    @Override
    public Map<String, Parameter> getMaxValueReferencingParameters() {
        return this.getMaxValueReferencingParameters(false);
    }

    @Override
    public Map<String, Parameter> getMaxValueReferencingParameters(boolean recursively) {
        LinkedHashMap<String, Parameter> maxValueReferencingParameters = new LinkedHashMap<String, Parameter>();
        String fullName = this.getFullName();
        Operation declaringOperation = this.getDeclaringOperation();
        List<Parameter> parametersList = declaringOperation.getParametersList();
        for (Parameter parameter : parametersList) {
            Expression maxValue;
            if (parameter.getFullName().equals(fullName) || !this.referencedByExpression(maxValue = this.maxValueExpression(parameter))) continue;
            logger.trace((Object)("parameter " + fullName + " is referenced by the max value expression of " + parameter.getName()));
            maxValueReferencingParameters.put(parameter.getPathString(), parameter);
            if (!recursively) continue;
            maxValueReferencingParameters.putAll(parameter.getMaxValueReferencingParameters(recursively));
        }
        return maxValueReferencingParameters;
    }

    @Override
    public Map<String, Property> getMaxValueReferencingProperties() {
        return this.getMaxValueReferencingProperties(false);
    }

    @Override
    public Map<String, Property> getMaxValueReferencingProperties(boolean recursively) {
        LinkedHashMap<String, Property> maxValueReferencingProperties = new LinkedHashMap<String, Property>();
        String fullName = this.getFullName();
        Entity declaringEntity = this.getDeclaringEntity();
        List<Property> propertiesList = declaringEntity.getPropertiesList();
        for (Property property : propertiesList) {
            Expression maxValue;
            if (property.getFullName().equals(fullName) || !this.referencedByExpression(maxValue = this.maxValueExpression(property))) continue;
            logger.trace((Object)("property " + fullName + " is referenced by the max value expression of " + property.getName()));
            maxValueReferencingProperties.put(property.getPathString(), property);
            if (!recursively) continue;
            maxValueReferencingProperties.putAll(property.getMaxValueReferencingProperties(recursively));
        }
        return maxValueReferencingProperties;
    }

    private Expression maxValueExpression(DataArtifact da) {
        if (da instanceof IntervalizedArtifact) {
            IntervalizedArtifact ia = (IntervalizedArtifact)da;
            Object maxValueObject = ia.getMaxValue();
            return maxValueObject instanceof Expression ? (Expression)maxValueObject : (maxValueObject instanceof Entity ? ((Entity)maxValueObject).self() : null);
        }
        return null;
    }

    public Map<String, ? extends DataArtifact> getMinValueReferencingSiblings() {
        return this.getMinValueReferencingSiblings(false);
    }

    public Map<String, ? extends DataArtifact> getMinValueReferencingSiblings(boolean recursively) {
        return this.isProperty() ? this.getMinValueReferencingProperties(recursively) : (this.isParameter() ? this.getMinValueReferencingParameters(recursively) : new LinkedHashMap());
    }

    @Override
    public Map<String, Parameter> getMinValueReferencingParameters() {
        return this.getMinValueReferencingParameters(false);
    }

    @Override
    public Map<String, Parameter> getMinValueReferencingParameters(boolean recursively) {
        LinkedHashMap<String, Parameter> minValueReferencingParameters = new LinkedHashMap<String, Parameter>();
        String fullName = this.getFullName();
        Operation declaringOperation = this.getDeclaringOperation();
        List<Parameter> parametersList = declaringOperation.getParametersList();
        for (Parameter parameter : parametersList) {
            Expression minValue;
            if (parameter.getFullName().equals(fullName) || !this.referencedByExpression(minValue = this.minValueExpression(parameter))) continue;
            logger.trace((Object)("parameter " + fullName + " is referenced by the min value expression of " + parameter.getName()));
            minValueReferencingParameters.put(parameter.getPathString(), parameter);
            if (!recursively) continue;
            minValueReferencingParameters.putAll(parameter.getMinValueReferencingParameters(recursively));
        }
        return minValueReferencingParameters;
    }

    @Override
    public Map<String, Property> getMinValueReferencingProperties() {
        return this.getMinValueReferencingProperties(false);
    }

    @Override
    public Map<String, Property> getMinValueReferencingProperties(boolean recursively) {
        LinkedHashMap<String, Property> minValueReferencingProperties = new LinkedHashMap<String, Property>();
        String fullName = this.getFullName();
        Entity declaringEntity = this.getDeclaringEntity();
        List<Property> propertiesList = declaringEntity.getPropertiesList();
        for (Property property : propertiesList) {
            Expression minValue;
            if (property.getFullName().equals(fullName) || !this.referencedByExpression(minValue = this.minValueExpression(property))) continue;
            logger.trace((Object)("property " + fullName + " is referenced by the min value expression of " + property.getName()));
            minValueReferencingProperties.put(property.getPathString(), property);
            if (!recursively) continue;
            minValueReferencingProperties.putAll(property.getMinValueReferencingProperties(recursively));
        }
        return minValueReferencingProperties;
    }

    private Expression minValueExpression(DataArtifact da) {
        if (da instanceof IntervalizedArtifact) {
            IntervalizedArtifact ia = (IntervalizedArtifact)da;
            Object minValueObject = ia.getMinValue();
            return minValueObject instanceof Expression ? (Expression)minValueObject : (minValueObject instanceof Entity ? ((Entity)minValueObject).self() : null);
        }
        return null;
    }

    public Map<String, ? extends DataArtifact> getModifyingFilterReferencingSiblings() {
        return this.getModifyingFilterReferencingSiblings(false);
    }

    public Map<String, ? extends DataArtifact> getModifyingFilterReferencingSiblings(boolean recursively) {
        return this.isProperty() ? this.getModifyingFilterReferencingProperties(recursively) : (this.isParameter() ? this.getModifyingFilterReferencingParameters(recursively) : new LinkedHashMap());
    }

    @Override
    public Map<String, Parameter> getModifyingFilterReferencingParameters() {
        return this.getModifyingFilterReferencingParameters(false);
    }

    @Override
    public Map<String, Parameter> getModifyingFilterReferencingParameters(boolean recursively) {
        LinkedHashMap<String, Parameter> modifyingFilterReferencingParameters = new LinkedHashMap<String, Parameter>();
        String fullName = this.getFullName();
        Operation declaringOperation = this.getDeclaringOperation();
        List<Parameter> parametersList = declaringOperation.getParametersList();
        for (Parameter parameter : parametersList) {
            BooleanExpression modifyingFilter;
            if (parameter.getFullName().equals(fullName) || !this.referencedByExpression(modifyingFilter = parameter.getModifyingFilter())) continue;
            logger.trace((Object)("parameter " + fullName + " is referenced by the modifying filter of " + parameter.getName()));
            modifyingFilterReferencingParameters.put(parameter.getPathString(), parameter);
            if (!recursively) continue;
            modifyingFilterReferencingParameters.putAll(parameter.getModifyingFilterReferencingParameters(recursively));
        }
        return modifyingFilterReferencingParameters;
    }

    @Override
    public Map<String, Property> getModifyingFilterReferencingProperties() {
        return this.getModifyingFilterReferencingProperties(false);
    }

    @Override
    public Map<String, Property> getModifyingFilterReferencingProperties(boolean recursively) {
        LinkedHashMap<String, Property> modifyingFilterReferencingProperties = new LinkedHashMap<String, Property>();
        String fullName = this.getFullName();
        Entity declaringEntity = this.getDeclaringEntity();
        List<Property> propertiesList = declaringEntity.getPropertiesList();
        for (Property property : propertiesList) {
            BooleanExpression modifyingFilter;
            if (property.getFullName().equals(fullName) || !this.referencedByExpression(modifyingFilter = property.getModifyingFilter())) continue;
            logger.trace((Object)("property " + fullName + " is referenced by the modifying filter of " + property.getName()));
            modifyingFilterReferencingProperties.put(property.getPathString(), property);
            if (!recursively) continue;
            modifyingFilterReferencingProperties.putAll(property.getModifyingFilterReferencingProperties(recursively));
        }
        return modifyingFilterReferencingProperties;
    }

    public Map<String, ? extends DataArtifact> getRenderingFilterReferencingSiblings() {
        return this.getRenderingFilterReferencingSiblings(false);
    }

    public Map<String, ? extends DataArtifact> getRenderingFilterReferencingSiblings(boolean recursively) {
        return this.isProperty() ? this.getRenderingFilterReferencingProperties(recursively) : (this.isParameter() ? this.getRenderingFilterReferencingParameters(recursively) : new LinkedHashMap());
    }

    public Map<String, ? extends DataArtifact> getReadingRenderingFilterReferencingSiblings() {
        return this.getReadingRenderingFilterReferencingSiblings(false);
    }

    public Map<String, ? extends DataArtifact> getReadingRenderingFilterReferencingSiblings(boolean recursively) {
        return this.isProperty() ? this.getRenderingFilterReferencingProperties(recursively, true) : (this.isParameter() ? this.getRenderingFilterReferencingParameters(recursively, true) : new LinkedHashMap());
    }

    public Map<String, ? extends DataArtifact> getWritingRenderingFilterReferencingSiblings() {
        return this.getWritingRenderingFilterReferencingSiblings(false);
    }

    public Map<String, ? extends DataArtifact> getWritingRenderingFilterReferencingSiblings(boolean recursively) {
        return this.isProperty() ? this.getRenderingFilterReferencingProperties(recursively, false) : (this.isParameter() ? this.getRenderingFilterReferencingParameters(recursively, false) : new LinkedHashMap());
    }

    @Override
    public Map<String, Parameter> getRenderingFilterReferencingParameters() {
        return this.getRenderingFilterReferencingParameters(false);
    }

    @Override
    public Map<String, Parameter> getRenderingFilterReferencingParameters(boolean recursively) {
        return this.getRenderingFilterReferencingParameters(recursively, null);
    }

    @Override
    public Map<String, Parameter> getRenderingFilterReferencingParameters(boolean recursively, Boolean readOnly) {
        LinkedHashMap<String, Parameter> renderingFilterReferencingParameters = new LinkedHashMap<String, Parameter>();
        String fullName = this.getFullName();
        Operation declaringOperation = this.getDeclaringOperation();
        List<Parameter> parametersList = declaringOperation.getParametersList();
        for (Parameter parameter : parametersList) {
            if (parameter.getFullName().equals(fullName)) continue;
            BooleanExpression renderingFilter = parameter.getRenderingFilter();
            if (!this.checkRenderingFilter(readOnly, parameter.isRenderingFilterReadOnly()) || !this.referencedByExpression(renderingFilter)) continue;
            logger.trace((Object)("parameter " + fullName + " is referenced by the rendering filter of " + parameter.getName()));
            renderingFilterReferencingParameters.put(parameter.getPathString(), parameter);
            if (!recursively) continue;
            renderingFilterReferencingParameters.putAll(parameter.getRenderingFilterReferencingParameters(recursively, readOnly));
        }
        return renderingFilterReferencingParameters;
    }

    @Override
    public Map<String, Property> getRenderingFilterReferencingProperties() {
        return this.getRenderingFilterReferencingProperties(false);
    }

    @Override
    public Map<String, Property> getRenderingFilterReferencingProperties(boolean recursively) {
        return this.getRenderingFilterReferencingProperties(recursively, null);
    }

    @Override
    public Map<String, Property> getRenderingFilterReferencingProperties(boolean recursively, Boolean readOnly) {
        LinkedHashMap<String, Property> renderingFilterReferencingProperties = new LinkedHashMap<String, Property>();
        String fullName = this.getFullName();
        Entity declaringEntity = this.getDeclaringEntity();
        List<Property> propertiesList = declaringEntity.getPropertiesList();
        for (Property property : propertiesList) {
            if (property.getFullName().equals(fullName)) continue;
            BooleanExpression renderingFilter = property.getRenderingFilter();
            if (!this.checkRenderingFilter(readOnly, property.isRenderingFilterReadOnly()) || !this.referencedByExpression(renderingFilter)) continue;
            logger.trace((Object)("property " + fullName + " is referenced by the rendering filter of " + property.getName()));
            renderingFilterReferencingProperties.put(property.getPathString(), property);
            if (!recursively) continue;
            renderingFilterReferencingProperties.putAll(property.getRenderingFilterReferencingProperties(recursively, readOnly));
        }
        return renderingFilterReferencingProperties;
    }

    private boolean checkRenderingFilter(Boolean readOnly, boolean renderingFilterReadOnly) {
        return readOnly == null || readOnly == renderingFilterReadOnly;
    }

    public Map<String, EntityCollection> getRenderingFilterReferencingCollections() {
        LinkedHashMap<String, EntityCollection> renderingFilterReferencingCollections = new LinkedHashMap<String, EntityCollection>();
        String fullName = this.getFullName();
        Entity declaringEntity = this.getDeclaringEntity();
        List<EntityCollection> entityCollectionsList = declaringEntity.getEntityCollectionsList();
        for (EntityCollection collection : entityCollectionsList) {
            BooleanExpression renderingFilter = collection.getRenderingFilter();
            if (!this.referencedByExpression(renderingFilter)) continue;
            logger.trace((Object)("property " + fullName + " is referenced by the rendering filter of " + collection.getName()));
            renderingFilterReferencingCollections.put(collection.getPathString(), collection);
        }
        return renderingFilterReferencingCollections;
    }

    public Map<String, ? extends DataArtifact> getRequiringFilterReferencingSiblings() {
        return this.getRequiringFilterReferencingSiblings(false);
    }

    public Map<String, ? extends DataArtifact> getRequiringFilterReferencingSiblings(boolean recursively) {
        return this.isProperty() ? this.getRequiringFilterReferencingProperties(recursively) : (this.isParameter() ? this.getRequiringFilterReferencingParameters(recursively) : new LinkedHashMap());
    }

    @Override
    public Map<String, Parameter> getRequiringFilterReferencingParameters() {
        return this.getRequiringFilterReferencingParameters(false);
    }

    @Override
    public Map<String, Parameter> getRequiringFilterReferencingParameters(boolean recursively) {
        LinkedHashMap<String, Parameter> requiringFilterReferencingParameters = new LinkedHashMap<String, Parameter>();
        String fullName = this.getFullName();
        Operation declaringOperation = this.getDeclaringOperation();
        List<Parameter> parametersList = declaringOperation.getParametersList();
        for (Parameter parameter : parametersList) {
            BooleanExpression requiringFilter;
            if (parameter.getFullName().equals(fullName) || !this.referencedByExpression(requiringFilter = parameter.getRequiringFilter())) continue;
            logger.trace((Object)("parameter " + fullName + " is referenced by the requiring filter of " + parameter.getName()));
            requiringFilterReferencingParameters.put(parameter.getPathString(), parameter);
            if (!recursively) continue;
            requiringFilterReferencingParameters.putAll(parameter.getRequiringFilterReferencingParameters(recursively));
        }
        return requiringFilterReferencingParameters;
    }

    @Override
    public Map<String, Property> getRequiringFilterReferencingProperties() {
        return this.getRequiringFilterReferencingProperties(false);
    }

    @Override
    public Map<String, Property> getRequiringFilterReferencingProperties(boolean recursively) {
        LinkedHashMap<String, Property> requiringFilterReferencingProperties = new LinkedHashMap<String, Property>();
        String fullName = this.getFullName();
        Entity declaringEntity = this.getDeclaringEntity();
        List<Property> propertiesList = declaringEntity.getPropertiesList();
        for (Property property : propertiesList) {
            BooleanExpression requiringFilter;
            if (property.getFullName().equals(fullName) || !this.referencedByExpression(requiringFilter = property.getRequiringFilter())) continue;
            logger.trace((Object)("property " + fullName + " is referenced by the requiring filter of " + property.getName()));
            requiringFilterReferencingProperties.put(property.getPathString(), property);
            if (!recursively) continue;
            requiringFilterReferencingProperties.putAll(property.getRequiringFilterReferencingProperties(recursively));
        }
        return requiringFilterReferencingProperties;
    }

    public Map<String, ? extends DataArtifact> getSearchQueryFilterReferencingSiblings() {
        return this.getSearchQueryFilterReferencingSiblings(false);
    }

    public Map<String, ? extends DataArtifact> getSearchQueryFilterReferencingSiblings(boolean recursively) {
        return this.isProperty() ? this.getSearchQueryFilterReferencingProperties(recursively) : (this.isParameter() ? this.getSearchQueryFilterReferencingParameters(recursively) : new LinkedHashMap());
    }

    @Override
    public Map<String, Parameter> getSearchQueryFilterReferencingParameters() {
        return this.getSearchQueryFilterReferencingParameters(false);
    }

    @Override
    public Map<String, Parameter> getSearchQueryFilterReferencingParameters(boolean recursively) {
        LinkedHashMap<String, Parameter> searchQueryFilterReferencingParameters = new LinkedHashMap<String, Parameter>();
        String fullName = this.getFullName();
        Operation declaringOperation = this.getDeclaringOperation();
        List<Parameter> parametersList = declaringOperation.getParametersList();
        for (Parameter parameter : parametersList) {
            Entity entity;
            BooleanExpression searchQueryFilter;
            if (!(parameter instanceof Entity) || parameter.getFullName().equals(fullName) || !this.referencedByExpression(searchQueryFilter = (entity = (Entity)((Object)parameter)).getSearchQueryFilter())) continue;
            logger.trace((Object)("parameter " + fullName + " is referenced by the search query filter of " + parameter.getName()));
            searchQueryFilterReferencingParameters.put(parameter.getPathString(), parameter);
            if (!recursively) continue;
            searchQueryFilterReferencingParameters.putAll(parameter.getSearchQueryFilterReferencingParameters(recursively));
        }
        return searchQueryFilterReferencingParameters;
    }

    @Override
    public Map<String, Property> getSearchQueryFilterReferencingProperties() {
        return this.getSearchQueryFilterReferencingProperties(false);
    }

    @Override
    public Map<String, Property> getSearchQueryFilterReferencingProperties(boolean recursively) {
        LinkedHashMap<String, Property> searchQueryFilterReferencingProperties = new LinkedHashMap<String, Property>();
        String fullName = this.getFullName();
        Entity declaringEntity = this.getDeclaringEntity();
        List<Property> propertiesList = declaringEntity.getPropertiesList();
        for (Property property : propertiesList) {
            Entity entity;
            BooleanExpression searchQueryFilter;
            if (!(property instanceof Entity) || property.getFullName().equals(fullName) || !this.referencedByExpression(searchQueryFilter = (entity = (Entity)((Object)property)).getSearchQueryFilter())) continue;
            logger.trace((Object)("property " + fullName + " is referenced by the search query filter of " + property.getName()));
            searchQueryFilterReferencingProperties.put(property.getPathString(), property);
            if (!recursively) continue;
            searchQueryFilterReferencingProperties.putAll(property.getSearchQueryFilterReferencingProperties(recursively));
        }
        return searchQueryFilterReferencingProperties;
    }

    private boolean referencedByExpression(Expression expression) {
        return this.referencedByExpression(expression, this);
    }

    private boolean referencedByExpression(Expression expression, Artifact artifact) {
        if (expression != null) {
            String pathString = artifact == null ? this.getPathString() : artifact.getPathString();
            String pathPrefix = pathString + ".";
            Set<String> keys = expression.getReferencedColumnsMap().keySet();
            for (String key : keys) {
                if (!key.equals(pathString) && !key.startsWith(pathPrefix)) continue;
                return true;
            }
        }
        return false;
    }

    public Class<? extends DataArtifactWrapper> getDefaultWrapperClass() {
        return DataArtifactWrapper.class;
    }

    @Override
    public Object getCalculableValue() {
        return null;
    }

    public String getRenderingFilterTag() {
        return this.getLocalizedRenderingFilterTag(null);
    }

    public void setRenderingFilterTag(String tag) {
        this.setLocalizedRenderingFilterTag(null, tag);
    }

    public String getRequiringFilterTag() {
        return this.getLocalizedRequiringFilterTag(null);
    }

    public void setRequiringFilterTag(String tag) {
        this.setLocalizedRequiringFilterTag(null, tag);
    }

    public String getModifyingFilterTag() {
        return this.getLocalizedModifyingFilterTag(null);
    }

    public void setModifyingFilterTag(String tag) {
        this.setLocalizedModifyingFilterTag(null, tag);
    }

    public String getNullifyingFilterTag() {
        return this.getLocalizedNullifyingFilterTag(null);
    }

    public void setNullifyingFilterTag(String tag) {
        this.setLocalizedNullifyingFilterTag(null, tag);
    }

    public String getLocalizedRenderingFilterTag(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedRenderingFilterTag.get(l);
    }

    public void setLocalizedRenderingFilterTag(Locale locale, String tag) {
        Locale l = this.localeWritingKey(locale);
        if (tag == null) {
            this._localizedRenderingFilterTag.remove(l);
        } else {
            this._localizedRenderingFilterTag.put(l, tag);
        }
    }

    public String getLocalizedRequiringFilterTag(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedRequiringFilterTag.get(l);
    }

    public void setLocalizedRequiringFilterTag(Locale locale, String tag) {
        Locale l = this.localeWritingKey(locale);
        if (tag == null) {
            this._localizedRequiringFilterTag.remove(l);
        } else {
            this._localizedRequiringFilterTag.put(l, tag);
        }
    }

    public String getLocalizedModifyingFilterTag(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedModifyingFilterTag.get(l);
    }

    public void setLocalizedModifyingFilterTag(Locale locale, String tag) {
        Locale l = this.localeWritingKey(locale);
        if (tag == null) {
            this._localizedModifyingFilterTag.remove(l);
        } else {
            this._localizedModifyingFilterTag.put(l, tag);
        }
    }

    public String getLocalizedNullifyingFilterTag(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedNullifyingFilterTag.get(l);
    }

    public void setLocalizedNullifyingFilterTag(Locale locale, String tag) {
        Locale l = this.localeWritingKey(locale);
        if (tag == null) {
            this._localizedNullifyingFilterTag.remove(l);
        } else {
            this._localizedNullifyingFilterTag.put(l, tag);
        }
    }

    @Override
    public String getCalculableValueTag() {
        return this.getLocalizedCalculableValueTag(null);
    }

    @Override
    public void setCalculableValueTag(String tag) {
        this.setLocalizedCalculableValueTag(null, tag);
    }

    @Override
    public String getInitialValueTag() {
        return this.getLocalizedInitialValueTag(null);
    }

    @Override
    public void setInitialValueTag(String tag) {
        this.setLocalizedInitialValueTag(null, tag);
    }

    @Override
    public String getDefaultValueTag() {
        return this.getLocalizedDefaultValueTag(null);
    }

    @Override
    public void setDefaultValueTag(String tag) {
        this.setLocalizedDefaultValueTag(null, tag);
    }

    @Override
    public String getCurrentValueTag() {
        return this.getLocalizedCurrentValueTag(null);
    }

    @Override
    public void setCurrentValueTag(String tag) {
        this.setLocalizedCurrentValueTag(null, tag);
    }

    public String getLocalizedCalculableValueTag(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedCalculableValueTag.get(l);
    }

    public void setLocalizedCalculableValueTag(Locale locale, String tag) {
        Locale l = this.localeWritingKey(locale);
        if (tag == null) {
            this._localizedCalculableValueTag.remove(l);
        } else {
            this._localizedCalculableValueTag.put(l, tag);
        }
    }

    public String getLocalizedInitialValueTag(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedInitialValueTag.get(l);
    }

    public void setLocalizedInitialValueTag(Locale locale, String tag) {
        Locale l = this.localeWritingKey(locale);
        if (tag == null) {
            this._localizedInitialValueTag.remove(l);
        } else {
            this._localizedInitialValueTag.put(l, tag);
        }
    }

    public String getLocalizedDefaultValueTag(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedDefaultValueTag.get(l);
    }

    public void setLocalizedDefaultValueTag(Locale locale, String tag) {
        Locale l = this.localeWritingKey(locale);
        if (tag == null) {
            this._localizedDefaultValueTag.remove(l);
        } else {
            this._localizedDefaultValueTag.put(l, tag);
        }
    }

    public String getLocalizedCurrentValueTag(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedCurrentValueTag.get(l);
    }

    public void setLocalizedCurrentValueTag(Locale locale, String tag) {
        Locale l = this.localeWritingKey(locale);
        if (tag == null) {
            this._localizedCurrentValueTag.remove(l);
        } else {
            this._localizedCurrentValueTag.put(l, tag);
        }
    }

    protected boolean validCalculableValue(Object object) {
        if (this.isParameter()) {
            String message = "failed to set calculable value of " + this.getFullName();
            message = message + "; method setCalculableValueExpression is not valid for parameters; setting ignored";
            logger.warn((Object)message);
            Project.increaseParserWarningCount();
            return true;
        }
        if (object == null) {
            if (this.isLoggable()) {
                logger.error((Object)("null is not a valid calculable value for " + this.getFullName()));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        if (this.incompatibleValueType(object)) {
            if (this.isLoggable()) {
                logger.error((Object)this.incompatibleValueTypeMessage(object, "calculable"));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        return true;
    }

    protected boolean validInitialValue(Object object) {
        boolean log;
        boolean bl = log = this.isParameter() || this.isLoggableProperty();
        if (object == null) {
            if (log) {
                logger.error((Object)("null is not a valid initial value for " + this.getFullName()));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        if (this.incompatibleValueType(object)) {
            if (this.isLoggable()) {
                logger.error((Object)this.incompatibleValueTypeMessage(object, "initial"));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        if (object instanceof SpecialTemporalValue && !this.validSpecialTemporalValue((SpecialTemporalValue)object)) {
            if (log) {
                logger.error((Object)(object + " is not a valid initial value for " + this.getFullName()));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        return true;
    }

    protected boolean validDefaultValue(Object object) {
        Entity thisDeclaringEntity;
        boolean log;
        boolean bl = log = this.isParameter() || this.isLoggableProperty();
        if (this.isCalculable()) {
            if (log) {
                logger.error((Object)(this.getFullName() + " is calculable and therefore does not support default value"));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        if (object == null) {
            if (log) {
                logger.error((Object)("null is not a valid default value for " + this.getFullName()));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        if (this.incompatibleValueType(object)) {
            if (this.isLoggable()) {
                logger.error((Object)this.incompatibleValueTypeMessage(object, "default"));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        if (object instanceof SpecialTemporalValue && !this.validSpecialTemporalValue((SpecialTemporalValue)object)) {
            if (log) {
                logger.error((Object)(object + " is not a valid default value for " + this.getFullName()));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        if (TLC.getProject().isDatabaseDefaultValuesMustBeSingleEntityExpression() && (thisDeclaringEntity = this.getDeclaringEntity()) != null) {
            Expression expression;
            if (object instanceof Primitive) {
                Primitive primitive = (Primitive)object;
                Entity thatDeclaringEntity = primitive.getDeclaringEntity();
                if (thatDeclaringEntity != null && thatDeclaringEntity != thisDeclaringEntity) {
                    this.setDefaultCheckpointToUserInterface(log);
                }
            } else if (object instanceof Expression && !(expression = (Expression)object).isSingleEntityExpression(thisDeclaringEntity)) {
                this.setDefaultCheckpointToUserInterface(log);
            }
        }
        return true;
    }

    private void setDefaultCheckpointToUserInterface(boolean log) {
        if (Checkpoint.UNSPECIFIED.equals((Object)this.defaultCheckpoint())) {
            this.setDefaultCheckpoint(Checkpoint.USER_INTERFACE);
            if (log) {
                logger.warn((Object)(this.getFullName() + " default value checkpoint set to USER_INTERFACE"));
                Project.increaseParserWarningCount();
            }
        }
    }

    protected boolean validCurrentValue(Object object) {
        boolean log;
        boolean bl = log = this.isParameter() || this.isLoggableProperty();
        if (object == null) {
            if (log) {
                logger.error((Object)("null is not a valid current value for " + this.getFullName()));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        if (this.incompatibleValueType(object)) {
            if (this.isLoggable()) {
                logger.error((Object)this.incompatibleValueTypeMessage(object, "current"));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        if (object instanceof SpecialTemporalValue && !this.validSpecialTemporalValue((SpecialTemporalValue)object)) {
            if (log) {
                logger.error((Object)(object + " is not a valid current value for " + this.getFullName()));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        return true;
    }

    protected boolean validMinimumValue(Object object) {
        boolean log;
        boolean bl = log = this.isParameter() || this.depth() == 0;
        if (object == null) {
            if (log) {
                logger.error((Object)("null is not a valid minimum value for " + this.getFullName()));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        if (this.incompatibleValueType(object)) {
            if (this.isLoggable()) {
                logger.error((Object)this.incompatibleValueTypeMessage(object, "minimum"));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        return true;
    }

    protected boolean validMaximumValue(Object object) {
        boolean log;
        boolean bl = log = this.isParameter() || this.depth() == 0;
        if (object == null) {
            if (log) {
                logger.error((Object)("null is not a valid maximum value for " + this.getFullName()));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        if (this.incompatibleValueType(object)) {
            if (this.isLoggable()) {
                logger.error((Object)this.incompatibleValueTypeMessage(object, "maximum"));
                Project.increaseParserErrorCount();
            }
            return false;
        }
        return true;
    }

    protected boolean validSpecialTemporalValue(SpecialTemporalValue value) {
        switch (value) {
            case CURRENT_DATE: {
                return this.isDateData() || this.isTimestampData();
            }
            case CURRENT_TIME: {
                return this.isTimeData() || this.isTimestampData();
            }
            case CURRENT_TIMESTAMP: {
                return this.isTimestampData();
            }
        }
        return this.isTemporalPrimitive();
    }

    private boolean incompatibleValueType(Object object) {
        Class<?> dataType;
        if (this._dataType != null && object instanceof TypedArtifact && (dataType = ((TypedArtifact)object).getDataType()) != null && !dataType.equals(this._dataType)) {
            Class[] types;
            if (Entity.class.isAssignableFrom(dataType)) {
                return !this._dataType.isAssignableFrom(dataType) && !this.sameEntitySimpleName(dataType);
            }
            for (Class type : types = new Class[]{Boolean.class, String.class, Number.class, Date.class}) {
                if (!type.isAssignableFrom(dataType)) continue;
                return !type.isAssignableFrom(this._dataType);
            }
        }
        return false;
    }

    private boolean sameEntitySimpleName(Class<?> dataType) {
        return Entity.class.isAssignableFrom(this._dataType) && dataType.getSimpleName().equals(this._dataType.getSimpleName());
    }

    private String incompatibleValueTypeMessage(Object object, String adjective) {
        TypedArtifact typedArtifact = (TypedArtifact)object;
        Class<?> objClass = typedArtifact.getClass();
        Class<?> dataType = typedArtifact.getDataType();
        String objectName = typedArtifact.getPartialName();
        String fee = "the value of " + (String)(objClass.equals(dataType) ? "" : objClass.getName() + " ");
        String faa = "(" + dataType.getName() + ") " + (String)(StringUtils.isBlank((String)objectName) ? "" : objectName + " ");
        String foo = "is not a valid " + (String)(StringUtils.isBlank((String)adjective) ? "" : adjective + " ");
        String fum = "value for (" + this._dataType.getName() + ") " + this.getFullName();
        return fee + faa + foo + fum;
    }

    @Override
    public String getTableColumnEntityName() {
        PersistentEntity pent = this.isProperty() ? this.getDeclaringFieldPersistentEntityTableRoot() : null;
        return pent == null ? null : this.tableColumnEntityName(pent);
    }

    private String tableColumnEntityName(Entity entity) {
        Entity base = entity.getBaseRoot();
        PersistentEntity pent = base instanceof PersistentEntity ? (PersistentEntity)base : null;
        InheritanceMappingStrategy ims = pent == null ? null : pent.getInheritanceMappingStrategy();
        return InheritanceMappingStrategy.SINGLE_TABLE.equals((Object)ims) ? this.tableColumnEntityName(pent) : entity.getRoot().getName();
    }

    @Override
    public int getPixels() {
        if (this.isEnumerationEntityPrimaryKey()) {
            return 48;
        }
        if (this.isEntity() || this.isHiddenField() || this.isBinaryData() || this.isPassword()) {
            return 0;
        }
        if (this instanceof BooleanPrimitive) {
            return 48;
        }
        if (this instanceof CharacterData) {
            return 48;
        }
        if (this instanceof StringData) {
            StringData data = (StringData)this;
            EncodingType encoding = data.getEncodingType();
            if (encoding != null && !encoding.equals((Object)EncodingType.UNSPECIFIED)) {
                return 0;
            }
            if (this.isVariantStringField()) {
                return 120;
            }
            Integer maxLength = data.getMaxLength();
            if (maxLength == null) {
                return 384;
            }
            if (maxLength > 500) {
                return 384;
            }
            if (maxLength > 100) {
                return 240;
            }
            if (maxLength > 50) {
                return 192;
            }
            if (maxLength > 20) {
                return 144;
            }
            if (maxLength > 10) {
                return 120;
            }
            return 72;
        }
        if (this instanceof ByteData || this instanceof ShortData || this instanceof IntegerData) {
            return 72;
        }
        if (this instanceof LongData) {
            return 128;
        }
        if (this instanceof NumericPrimitive) {
            return 120;
        }
        if (this instanceof TimestampData) {
            return 120;
        }
        if (this instanceof TemporalPrimitive) {
            return 72;
        }
        return 0;
    }

    @Override
    public int getColumnPixels() {
        return this.isEnumerationEntityPrimaryKey() || this.isColumnField() ? this.getPixels() : 0;
    }

    private boolean isEnumerationEntityPrimaryKey() {
        return this.isPrimaryKeyProperty() && this.getDeclaringEntity() instanceof EnumerationEntity;
    }

    public boolean isSinglePropertyOfUniqueKey() {
        Entity root = this.getDeclaringEntityRoot();
        if (root != null) {
            List<Key> keys = root.getKeysList();
            for (Key key : keys) {
                if (!key.isUnique() || !key.isSingleProperty() || !this.equals(key.getTheProperty())) continue;
                return true;
            }
        }
        return false;
    }

    public List<NumericAggregate> getAggregates() {
        return this._aggregates;
    }

    public void keepCountOn(Property ... properties) {
        this.addAggregate(RowsAggregateOp.COUNT, properties);
    }

    protected void addAggregate(RowsAggregateOp operator, Property ... properties) {
        boolean log = this.depth() == 0;
        String message = "failed to set aggregate property of " + this.getFullName();
        String xIsNotY = " is not a non-calculable numerical property of an entity stored in the same table as ";
        if (!this.isProperty() || this.isCalculable(this.getDeclaringField())) {
            message = message + "; methods keepCountOn, keepTallyOn and keepSumOn are not valid for parameters or calculable properties; setting ignored";
            logger.warn((Object)message);
            Project.increaseParserWarningCount();
        } else {
            Entity thisDeclaringEntity = this.getDeclaringEntity();
            String thisTableColumnEntityName = this.getTableColumnEntityName();
            for (Property property : properties) {
                if (property instanceof NumericPrimitive && property.isProperty() && !this.isCalculable(property.getDeclaringField())) {
                    boolean ok;
                    Entity thatDeclaringEntity = property.getDeclaringEntity();
                    Entity thenDeclaringEntity = thatDeclaringEntity.getDeclaringEntity();
                    String thatDeclaringEntityTableColumnEntityName = ((Property)((Object)thatDeclaringEntity)).getTableColumnEntityName();
                    boolean bl = ok = !this.isCalculable(thatDeclaringEntity.getDeclaringField());
                    if (ok && thisDeclaringEntity == thenDeclaringEntity && thisTableColumnEntityName.equals(thatDeclaringEntityTableColumnEntityName)) {
                        this._aggregates.add(new NumericAggregate(operator, property));
                        continue;
                    }
                    if (!log) continue;
                    String hint = "; " + property.getFullName() + xIsNotY + thisDeclaringEntity.getFullName();
                    logger.error((Object)(message + hint));
                    Project.increaseParserErrorCount();
                    continue;
                }
                if (!log) continue;
                String name = property == null ? "null property argument" : property.getFullName();
                String hint = "; " + name + xIsNotY + thisDeclaringEntity.getFullName();
                logger.error((Object)(message + hint));
                Project.increaseParserErrorCount();
            }
        }
    }

    protected void checkAggregates() {
        if (!this._aggregates.isEmpty()) {
            Integer ZERO = 0;
            String message = "failed to set aggregate property of " + this.getFullName();
            String warning = "check aggregate properties of " + this.getFullName();
            for (NumericAggregate aggregate : this._aggregates) {
                String hint;
                RowsAggregateOp operator = aggregate.getOperator();
                Property property = aggregate.getProperty();
                String fullName = property.getFullName();
                if (!(property instanceof NumericPrimitive)) continue;
                NumericPrimitive propertyAtRoot = (NumericPrimitive)property.getPropertyAtRoot();
                if (propertyAtRoot.isPrimaryKeyProperty()) {
                    hint = "; " + fullName + " is the primary key property";
                    logger.error((Object)(message + hint));
                    Project.increaseParserErrorCount();
                }
                if (propertyAtRoot.isNumericKeyProperty() && !propertyAtRoot.isPrimaryKeyProperty()) {
                    hint = "; " + fullName + " is the numeric key property";
                    logger.error((Object)(message + hint));
                    Project.increaseParserErrorCount();
                }
                if (propertyAtRoot.isSequenceProperty()) {
                    hint = "; " + fullName + " is the sequence property";
                    logger.error((Object)(message + hint));
                    Project.increaseParserErrorCount();
                }
                if (propertyAtRoot.isDiscriminatorProperty()) {
                    hint = "; " + fullName + " is the discriminator property";
                    logger.error((Object)(message + hint));
                    Project.increaseParserErrorCount();
                }
                if (propertyAtRoot.isVersionProperty()) {
                    hint = "; " + fullName + " is the version property";
                    logger.error((Object)(message + hint));
                    Project.increaseParserErrorCount();
                }
                if (propertyAtRoot.isUniqueKeyProperty()) {
                    hint = "; " + fullName + " is a unique key property";
                    logger.error((Object)(message + hint));
                    Project.increaseParserErrorCount();
                }
                if (propertyAtRoot.isCalculable()) {
                    hint = "; " + fullName + " is calculable";
                    logger.error((Object)(message + hint));
                    Project.increaseParserErrorCount();
                }
                if (propertyAtRoot.isCreateField()) {
                    hint = "; " + fullName + " is creatable";
                    logger.warn((Object)(warning + hint));
                    Project.increaseParserWarningCount();
                }
                if (propertyAtRoot.isUpdateField()) {
                    hint = "; " + fullName + " is updatable";
                    logger.warn((Object)(warning + hint));
                    Project.increaseParserWarningCount();
                }
                if (!RowsAggregateOp.COUNT.equals(operator) && !RowsAggregateOp.SUM.equals(operator)) continue;
                if (!ZERO.equals(propertyAtRoot.getDefaultValue())) {
                    hint = "; " + fullName + " default value is not 0";
                    logger.warn((Object)(warning + hint));
                    Project.increaseParserWarningCount();
                }
                if (RowsAggregateOp.COUNT.equals(operator)) {
                    if (propertyAtRoot instanceof IntegerProperty || propertyAtRoot instanceof LongProperty) continue;
                    hint = "; " + fullName + " is not an Integer or Long property";
                    logger.warn((Object)(warning + hint));
                    Project.increaseParserWarningCount();
                    continue;
                }
                if (!(this instanceof NumericPrimitive)) continue;
                NumericPrimitive numericPrimitive = (NumericPrimitive)this;
                Number maxNumber1 = numericPrimitive.getMaxNumber();
                Number minNumber1 = numericPrimitive.getMinNumber();
                if (maxNumber1 == null || minNumber1 == null) continue;
                Number maxNumber2 = propertyAtRoot.getMaxNumber();
                Number minNumber2 = propertyAtRoot.getMinNumber();
                if (maxNumber2 == null || minNumber2 == null || ObjUtils.lteq(maxNumber1, maxNumber2).booleanValue() && ObjUtils.gteq(minNumber1, minNumber2).booleanValue()) continue;
                hint = "; " + fullName + " is not large enough to store the aggregation";
                logger.warn((Object)(warning + hint));
                Project.increaseParserWarningCount();
            }
        }
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            string = (String)string + fee + tab + "dataType" + faa + this._dataType + foo;
            if (this.getDeclaringField() != null && this.getDeclaringArtifact() != null) {
                if (this.isParameter()) {
                    string = (String)string + fee + tab + "auditable" + faa + this._auditable + foo;
                    string = (String)string + fee + tab + "password" + faa + this._password + foo;
                    string = (String)string + fee + tab + "required" + faa + this._required + foo;
                    string = (String)string + fee + tab + "linkedFieldName" + faa + this._linkedFieldName + foo;
                    string = (String)string + fee + tab + "linkedField" + faa + this._linkedField + foo;
                    string = (String)string + fee + tab + "linkedProperty" + faa + this._linkedProperty + foo;
                    string = (String)string + fee + tab + "linkedColumnName" + faa + this._linkedColumnName + foo;
                    string = (String)string + fee + tab + "linkedColumnOperator" + faa + this._linkedColumnOperator + foo;
                }
                if (this.isProperty()) {
                    string = (String)string + fee + tab + "baseField" + faa + this.isBaseField() + foo;
                    string = (String)string + fee + tab + "keyField" + faa + this.isKeyField() + foo;
                    string = (String)string + fee + tab + "auditable" + faa + this._auditable + foo;
                    string = (String)string + fee + tab + "password" + faa + this._password + foo;
                    string = (String)string + fee + tab + "required" + faa + this._required + foo;
                    string = (String)string + fee + tab + "hiddenField" + faa + this._hiddenField + foo;
                    string = (String)string + fee + tab + "createField" + faa + this._createField + foo;
                    string = (String)string + fee + tab + "updateField" + faa + this._updateField + foo;
                    string = (String)string + fee + tab + "searchField" + faa + this._searchField + foo;
                    string = (String)string + fee + tab + "filterField" + faa + this._filterField + foo;
                    string = (String)string + fee + tab + "tableField" + faa + this._tableField + foo;
                    string = (String)string + fee + tab + "detailField" + faa + this._detailField + foo;
                    string = (String)string + fee + tab + "columnField" + faa + this._columnField + foo;
                    string = (String)string + fee + tab + "reportField" + faa + this._reportField + foo;
                    string = (String)string + fee + tab + "exportField" + faa + this._exportField + foo;
                    string = (String)string + fee + tab + "calculable" + faa + this._calculable + foo;
                    string = (String)string + fee + tab + "nullable" + faa + this._nullable + foo;
                    string = (String)string + fee + tab + "insertable" + faa + this._insertable + foo;
                    string = (String)string + fee + tab + "updateable" + faa + this._updateable + foo;
                    string = (String)string + fee + tab + "unique" + faa + this._unique + foo;
                    string = (String)string + fee + tab + "indexed" + faa + this._indexed + foo;
                }
            }
        }
        return string;
    }
}

