/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.StrUtils;
import adalid.commons.util.TimeUtils;
import adalid.core.AbstractArtifact;
import adalid.core.InstanceField;
import adalid.core.InstanceTag;
import adalid.core.Project;
import adalid.core.XS1;
import adalid.core.annotations.InstanceDataGen;
import adalid.core.expressions.EntityScalarX;
import adalid.core.expressions.XB;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.PersistentEntityReference;
import adalid.core.interfaces.Property;
import adalid.core.properties.StringProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Instance
extends AbstractArtifact {
    private static final Logger logger = Logger.getLogger(Instance.class);
    private int _index;
    private InstanceTag _customTag;
    private final List<InstanceField> _instanceFieldsList = new ArrayList<InstanceField>();
    private boolean _usualArgumentInExpressions = false;
    private boolean _annotatedWithInstanceDataGen;
    private int _dataGenWeight = 1;

    public InstanceTag getCustomTag() {
        return this._customTag;
    }

    public void setCustomTag(InstanceTag tag) {
        this._customTag = tag;
    }

    public List<InstanceField> getInstanceFieldsList() {
        return this._instanceFieldsList;
    }

    public Class<?> getInstanceKeyType() {
        InstanceField field = this.getInstanceKeyField();
        return field == null ? null : field.getProperty().getDataType();
    }

    public Object getInstanceKeyValue() {
        InstanceField field = this.getInstanceKeyField();
        return field == null ? null : field.getValue();
    }

    public Object getInstanceKeyLabel() {
        Entity declaringEntity = this.getDeclaringEntity();
        StringProperty property = declaringEntity == null ? null : declaringEntity.getCharacterKeyProperty();
        return property == null ? null : this.getInstanceFieldValue(property.getName());
    }

    public Object getInstanceKeyDescription() {
        StringProperty property;
        Entity declaringEntity = this.getDeclaringEntity();
        StringProperty stringProperty = property = declaringEntity == null ? null : declaringEntity.getNameProperty();
        return declaringEntity == null ? null : (property == null ? this.descriptionValueOf(declaringEntity) : this.getInstanceFieldValue(property.getName()));
    }

    private Object descriptionValueOf(Entity declaringEntity) {
        StringProperty property = declaringEntity.getDescriptionProperty();
        return property == null ? null : this.getInstanceFieldValue(property.getName());
    }

    public Object getInstanceFieldValue(String name) {
        return name == null ? null : this.getInstanceFieldValue(name, null);
    }

    public Object getInstanceFieldValue(String name, Locale locale) {
        Property property;
        Instance instanceAtRoot;
        Instance instance = instanceAtRoot = name == null ? null : this.getInstanceAtRoot();
        if (instanceAtRoot != null && (property = instanceAtRoot.getDeclaringEntity().getProperty(name)) != null) {
            for (InstanceField field : instanceAtRoot.getInstanceFieldsList()) {
                if (!property.equals(field.getProperty())) continue;
                return property instanceof StringProperty && locale != null ? field.getLocalizedValue(locale) : field.getValue();
            }
        }
        return null;
    }

    private InstanceField getInstanceKeyField() {
        Instance instanceAtRoot = this.getInstanceAtRoot();
        if (instanceAtRoot != null) {
            Map<String, Class<?>> map = this.getKeysMap();
            for (String s : map.keySet()) {
                Class<?> c = map.get(s);
                for (InstanceField instanceField : instanceAtRoot.getInstanceFieldsList()) {
                    Property p = instanceField.getProperty();
                    if (!s.equals(p.getName()) || !c.equals(p.getDataType())) continue;
                    return instanceField;
                }
            }
        }
        return null;
    }

    public boolean isUsualArgumentInExpressions() {
        Instance instanceAtRoot = this.getInstanceAtRoot();
        return instanceAtRoot == null || instanceAtRoot == this ? this._usualArgumentInExpressions : instanceAtRoot.isUsualArgumentInExpressions();
    }

    public void setUsualArgumentInExpressions(boolean usual) {
        this._usualArgumentInExpressions = usual;
    }

    private Map<String, Class<?>> getKeysMap() {
        LinkedHashMap map = new LinkedHashMap();
        Entity declaringEntity = this.getDeclaringEntity();
        if (declaringEntity != null) {
            this.putKeyProperty(map, declaringEntity.getPrimaryKeyProperty());
            this.putKeyProperty(map, declaringEntity.getSequenceProperty());
            this.putKeyProperty(map, declaringEntity.getNumericKeyProperty());
            this.putKeyProperty(map, declaringEntity.getCharacterKeyProperty());
        }
        return map;
    }

    private void putKeyProperty(Map<String, Class<?>> map, Property property) {
        if (property != null) {
            String name = property.getName();
            Class<?> clazz = property.getDataType();
            if (name != null && clazz != null) {
                map.put(name, clazz);
            }
        }
    }

    private Instance getInstanceAtRoot() {
        Entity declaringEntity = this.getDeclaringEntity();
        if (declaringEntity != null) {
            if (declaringEntity.isRootInstance()) {
                return this;
            }
            String name = this.getName();
            if (name != null) {
                Entity root = declaringEntity.getRoot();
                List<Instance> list = root.getInstancesList();
                if (list.isEmpty()) {
                    return this.instanceAt(root);
                }
                for (Instance instance : list) {
                    if (!name.equals(instance.getName())) continue;
                    return instance;
                }
            }
        }
        return null;
    }

    private Instance instanceAt(Entity root) {
        Field field = XS1.getField(false, this.getName(), this.getName(), root.getClass(), Entity.class, Instance.class);
        if (field == null) {
            return null;
        }
        try {
            Object obj = field.get(root);
            return obj instanceof Instance ? (Instance)obj : null;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            return null;
        }
    }

    boolean finalise(int index) {
        boolean ok = super.finalise();
        if (ok) {
            this._index = index;
            this.finaliseInstanceMissingFields();
        }
        return ok;
    }

    private void finaliseInstanceMissingFields() {
        Entity declaringEntity = this.getDeclaringEntity();
        if (declaringEntity instanceof PersistentEntity && this.depth() == 0 && this.round() == 0) {
            PersistentEntity pent = (PersistentEntity)declaringEntity;
            String name = StringUtils.capitalize((String)StrUtils.getWordyString(this.getName()));
            String code = pent.getBusinessKeyValueOf(this);
            Date currentDate = TimeUtils.currentDate();
            Time currentTime = TimeUtils.currentTime();
            Timestamp currentTimestamp = TimeUtils.currentTimestamp();
            List<Property> columnsList = pent.getColumnsList();
            for (Property property : columnsList) {
                InstanceField instanceField;
                if (property.isNullable() || property.getDefaultValue() != null || this.propertyAlreadyAdded(property)) continue;
                Class<?> dataType = property.getDataType();
                boolean keyField = property.isKeyField();
                Object dpv = pent.getDefaultPropertyValueOf(this, property);
                if (Boolean.class.isAssignableFrom(dataType)) {
                    Boolean logico = dpv instanceof Boolean ? (Boolean)dpv : false;
                    instanceField = new InstanceField(this, property, logico);
                    this._instanceFieldsList.add(instanceField);
                    continue;
                }
                if (Number.class.isAssignableFrom(dataType)) {
                    Integer number = keyField ? this._index : (dpv instanceof Integer ? (Integer)dpv : 0);
                    instanceField = new InstanceField(this, property, number);
                    this._instanceFieldsList.add(instanceField);
                    continue;
                }
                if (String.class.isAssignableFrom(dataType)) {
                    String string = keyField ? code : (dpv instanceof String ? (String)dpv : name);
                    instanceField = new InstanceField(this, property, string);
                    this._instanceFieldsList.add(instanceField);
                    continue;
                }
                if (Date.class.isAssignableFrom(dataType)) {
                    Date date = keyField ? TimeUtils.currentDate() : (dpv instanceof Date ? (Date)dpv : currentDate);
                    instanceField = new InstanceField(this, property, date);
                    this._instanceFieldsList.add(instanceField);
                    continue;
                }
                if (Time.class.isAssignableFrom(dataType)) {
                    Time time = keyField ? TimeUtils.currentTime() : (dpv instanceof Time ? (Time)dpv : currentTime);
                    instanceField = new InstanceField(this, property, time);
                    this._instanceFieldsList.add(instanceField);
                    continue;
                }
                if (!Timestamp.class.isAssignableFrom(dataType)) continue;
                Timestamp timestamp = keyField ? TimeUtils.currentTimestamp() : (dpv instanceof Timestamp ? (Timestamp)dpv : currentTimestamp);
                instanceField = new InstanceField(this, property, timestamp);
                this._instanceFieldsList.add(instanceField);
            }
        }
    }

    private boolean propertyAlreadyAdded(Property property) {
        for (InstanceField f : this._instanceFieldsList) {
            if (!f.getProperty().equals(property)) continue;
            return true;
        }
        return false;
    }

    public void newInstanceField(PersistentEntityReference property, Instance value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(Property property, BigDecimal value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(Property property, BigInteger value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(Property property, Boolean value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(Property property, Byte value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(Property property, Character value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(Property property, Date value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(Property property, Double value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(Property property, Float value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(Property property, Integer value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(Property property, Long value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(Property property, Short value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(Property property, String value) {
        Class<?> dataType = property.getDataType();
        if (java.util.Date.class.isAssignableFrom(dataType)) {
            java.util.Date valor = TimeUtils.jdbcObject(value, dataType);
            if (valor instanceof Date) {
                this.newInstanceField(property, (Date)valor);
            } else if (valor instanceof Time) {
                this.newInstanceField(property, (Time)valor);
            } else if (valor instanceof Timestamp) {
                this.newInstanceField(property, (Timestamp)valor);
            } else {
                logger.error((Object)("invalid date/time value for field " + this.getFullName() + "." + property.getName()));
                Project.increaseParserErrorCount();
            }
        } else {
            InstanceField instanceField = new InstanceField(this, property, value);
            this._instanceFieldsList.add(instanceField);
        }
    }

    public void newInstanceField(StringProperty property, String value) {
        this.newInstanceField(property, value, null);
    }

    public void newInstanceField(StringProperty property, String value, Locale locale) {
        for (InstanceField field : this._instanceFieldsList) {
            if (!property.equals(field.getProperty())) continue;
            field.addLocalizedValue(locale, value);
            return;
        }
        InstanceField instanceField = new InstanceField(this, property, value, locale);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(Property property, Time value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(Property property, Timestamp value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public boolean isAnnotatedWithInstanceDataGen() {
        return this._annotatedWithInstanceDataGen;
    }

    public int getDataGenWeight() {
        return this._dataGenWeight;
    }

    @Override
    void annotate(Field field) {
        super.annotate(field);
        if (field != null) {
            this.annotateInstanceDataGen(field);
        }
    }

    @Override
    protected List<Class<? extends Annotation>> getValidFieldAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidFieldAnnotations();
        valid.add(InstanceDataGen.class);
        return valid;
    }

    private void annotateInstanceDataGen(Field field) {
        Class<InstanceDataGen> annotationClass = InstanceDataGen.class;
        this._annotatedWithInstanceDataGen = field.isAnnotationPresent(annotationClass);
        if (this._annotatedWithInstanceDataGen) {
            InstanceDataGen annotation = field.getAnnotation(InstanceDataGen.class);
            this._dataGenWeight = Math.min(100, Math.max(0, annotation.weight()));
        }
    }

    public EntityScalarX toEntityExpression() {
        return XB.toEntity(this);
    }
}

