/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.AbstractArtifact;
import adalid.core.KeyField;
import adalid.core.enums.SortOption;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.Property;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Key
extends AbstractArtifact {
    private final List<KeyField> _keyFieldsList = new ArrayList<KeyField>();
    private boolean _unique;
    private boolean _containsNullProperties;

    public List<KeyField> getKeyFieldsList() {
        return this._keyFieldsList;
    }

    public boolean isUnique() {
        return this._unique;
    }

    public void setUnique(boolean unique) {
        this._unique = unique;
    }

    public void newKeyField(Property property) {
        KeyField keyField = new KeyField(this, property);
        this._keyFieldsList.add(keyField);
    }

    public void newKeyField(Property property, SortOption sortOption) {
        KeyField keyField = new KeyField(this, property, sortOption);
        this._keyFieldsList.add(keyField);
    }

    public void newKeyField(Property ... property) {
        Property[] properties = property;
        if (properties != null) {
            for (Property p : properties) {
                KeyField keyField = new KeyField(this, p);
                this._keyFieldsList.add(keyField);
            }
        }
    }

    public boolean isValidKeyFor(PersistentEntity entity) {
        if (this._containsNullProperties) {
            return false;
        }
        List<Property> columns = entity.getColumnsList();
        List<KeyField> fields = this.getKeyFieldsList();
        for (KeyField field : fields) {
            Property property = field.getProperty();
            if (property != null && !property.isCalculable() && columns.contains(property)) continue;
            return false;
        }
        return true;
    }

    public List<String> invalidPropertyNames(PersistentEntity entity) {
        String prefix = entity.getName() + ".";
        ArrayList<String> invalidPropertyNames = new ArrayList<String>();
        List<Property> invalidProperties = this.invalidProperties(entity);
        for (Property property : invalidProperties) {
            if (property == null) {
                invalidPropertyNames.add("null");
                continue;
            }
            invalidPropertyNames.add(StringUtils.removeStart((String)property.getFullName(), (String)prefix));
        }
        return invalidPropertyNames;
    }

    public List<Property> invalidProperties(PersistentEntity entity) {
        List<Property> columns = entity.getColumnsList();
        List<KeyField> fields = this.getKeyFieldsList();
        ArrayList<Property> properties = new ArrayList<Property>();
        for (KeyField field : fields) {
            Property property = field.getProperty();
            if (property != null && !property.isCalculable() && columns.contains(property)) continue;
            properties.add(property);
        }
        return properties;
    }

    public List<String> dubiousPropertyNames(PersistentEntity entity) {
        String prefix = entity.getName() + ".";
        ArrayList<String> dubiousPropertyNames = new ArrayList<String>();
        List<Property> dubiousProperties = this.dubiousProperties(entity);
        for (Property property : dubiousProperties) {
            if (property == null) {
                dubiousPropertyNames.add("null");
                continue;
            }
            dubiousPropertyNames.add(StringUtils.removeStart((String)property.getFullName(), (String)prefix));
        }
        return dubiousPropertyNames;
    }

    public List<Property> dubiousProperties(PersistentEntity entity) {
        List<Property> columns = entity.getColumnsList();
        List<KeyField> fields = this.getKeyFieldsList();
        ArrayList<Property> properties = new ArrayList<Property>();
        for (KeyField field : fields) {
            Property property = field.getProperty();
            if (property == null || property.isCalculable() || !columns.contains(property) || !this._unique || !property.isNullable()) continue;
            properties.add(property);
        }
        return properties;
    }

    public boolean isSingleProperty() {
        return this._keyFieldsList.size() == 1;
    }

    public Property getTheProperty() {
        return this._keyFieldsList.size() == 1 ? this._keyFieldsList.get(0).getProperty() : null;
    }
}

