/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.StrUtils;
import adalid.core.Operation;
import adalid.core.Project;
import adalid.core.TLC;
import adalid.core.TemporalAddend;
import adalid.core.Transition;
import adalid.core.Trigger;
import adalid.core.XS1;
import adalid.core.annotations.ConstructionOperationClass;
import adalid.core.annotations.ProcessOperationClass;
import adalid.core.enums.Kleenean;
import adalid.core.enums.OnConstructionOperationSuccess;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityReference;
import adalid.core.interfaces.Parameter;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.State;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class ProcessOperation
extends Operation {
    private static final Logger logger = Logger.getLogger(Operation.class);
    private boolean _annotatedWithProcessOperationClass;
    private String _processName;
    private String _processingGroup;
    private TemporalAddend _newTaskNotification;
    private boolean _notifySupervisor;
    private boolean _notifyAssignment;
    private boolean _notifyAssumption;
    private boolean _notifyRelief;
    private boolean _notifyAbandonment;
    private boolean _notifyCancellation;
    private boolean _notifyCompletion;
    private TemporalAddend _unassignedTaskNotification;
    private TemporalAddend _unfinishedTaskNotification;
    private TemporalAddend _unassignedTaskEscalation;
    private TemporalAddend _unfinishedTaskEscalation;
    private TemporalAddend _nextUnassignedTaskNotification;
    private TemporalAddend _nextUnfinishedTaskNotification;
    private TemporalAddend _nextUnassignedTaskEscalation;
    private TemporalAddend _nextUnfinishedTaskEscalation;
    private TemporalAddend _deadlineAddend;
    private boolean _automaticAssumption;
    private boolean _builtIn;
    private boolean _treeStructureModifier;
    private int _jobPriority;
    private Boolean _bplCodeGenEnabled;
    private Boolean _sqlCodeGenEnabled;
    private Kleenean _overloading = Kleenean.UNSPECIFIED;
    private Kleenean _serviceable = Kleenean.UNSPECIFIED;
    private boolean _annotatedWithConstructionOperationClass;
    private Class<? extends Entity> _constructionType;
    private OnConstructionOperationSuccess _onConstructionSuccess = OnConstructionOperationSuccess.UNSPECIFIED;
    private boolean _validConstructionOperationLinkedPropertiesMap;

    @Override
    public boolean finalise() {
        boolean ok = super.finalise();
        if (ok) {
            this.checkConstructionType();
        }
        return ok;
    }

    private void checkConstructionType() {
        if (this._constructionType != null) {
            String detail = "\"" + this._constructionType.getSimpleName() + "\" in ConstructionOperationClass annotation of " + this.getFullName();
            int modifiers = this._constructionType.getModifiers();
            if (Modifier.isAbstract(modifiers)) {
                String message = "abstract class " + detail;
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            } else {
                TLC.getProject().addConstructor(this._constructionType, this);
            }
        }
    }

    public boolean isAnnotatedWithProcessOperationClass() {
        return this._annotatedWithProcessOperationClass;
    }

    @Override
    public String getProperName() {
        return this._processName;
    }

    public String getProcessName() {
        return this._processName;
    }

    public String getProcessingGroup() {
        return this._processingGroup;
    }

    public TemporalAddend getNewTaskNotification() {
        return this._newTaskNotification;
    }

    public boolean isNotifySupervisor() {
        return this._notifySupervisor;
    }

    public boolean isNotifyAssignment() {
        return this._notifyAssignment;
    }

    public boolean isNotifyAssumption() {
        return this._notifyAssumption;
    }

    public boolean isNotifyRelief() {
        return this._notifyRelief;
    }

    public boolean isNotifyAbandonment() {
        return this._notifyAbandonment;
    }

    public boolean isNotifyCancellation() {
        return this._notifyCancellation;
    }

    public boolean isNotifyCompletion() {
        return this._notifyCompletion;
    }

    public TemporalAddend getUnassignedTaskNotification() {
        return this._unassignedTaskNotification;
    }

    public TemporalAddend getUnfinishedTaskNotification() {
        return this._unfinishedTaskNotification;
    }

    public TemporalAddend getUnassignedTaskEscalation() {
        return this._unassignedTaskEscalation;
    }

    public TemporalAddend getUnfinishedTaskEscalation() {
        return this._unfinishedTaskEscalation;
    }

    public TemporalAddend getNextUnassignedTaskNotification() {
        return this._nextUnassignedTaskNotification;
    }

    public TemporalAddend getNextUnfinishedTaskNotification() {
        return this._nextUnfinishedTaskNotification;
    }

    public TemporalAddend getNextUnassignedTaskEscalation() {
        return this._nextUnassignedTaskEscalation;
    }

    public TemporalAddend getNextUnfinishedTaskEscalation() {
        return this._nextUnfinishedTaskEscalation;
    }

    public TemporalAddend getDeadlineAddend() {
        return this._deadlineAddend;
    }

    public boolean isAutomaticAssumption() {
        return this._automaticAssumption;
    }

    public boolean isBuiltIn() {
        return this._builtIn;
    }

    public boolean isTreeStructureModifier() {
        return this._treeStructureModifier;
    }

    public int getJobPriority() {
        return this._jobPriority;
    }

    public boolean isExtensionBplCodeGenEnabled() {
        return this.isBplCodeGenEnabled() || this.isExtensionBplCodeGenEnabled(this.getDeclaringEntityRoot());
    }

    private boolean isExtensionBplCodeGenEnabled(Entity entity) {
        if (entity != null) {
            for (Entity e : entity.getExtensionsList()) {
                ProcessOperation o = (ProcessOperation)e.getOperation(this.getClass());
                if (o == null || !o.isExtensionBplCodeGenEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBplCodeGenEnabled() {
        if (this._bplCodeGenEnabled == null) {
            Entity operationEntityRoot = this.getDeclaringEntityRoot();
            return operationEntityRoot == null || operationEntityRoot.isBplCodeGenEnabled();
        }
        return this._bplCodeGenEnabled;
    }

    public void setBplCodeGenEnabled(boolean enabled) {
        this._bplCodeGenEnabled = enabled;
    }

    private boolean isBwsCodeGenEnabled() {
        Entity operationEntityRoot = this.getDeclaringEntityRoot();
        return operationEntityRoot == null || operationEntityRoot.isBwsCodeGenEnabled();
    }

    public boolean isSqlCodeGenEnabled() {
        if (this._sqlCodeGenEnabled == null) {
            Entity operationEntityRoot = this.getDeclaringEntityRoot();
            return operationEntityRoot == null || operationEntityRoot.isSqlCodeGenEnabled();
        }
        return this._sqlCodeGenEnabled;
    }

    public void setSqlCodeGenEnabled(boolean enabled) {
        this._sqlCodeGenEnabled = enabled;
    }

    public Kleenean getOverloading() {
        return this.isSqlCodeGenEnabled() ? this._overloading : Kleenean.UNSPECIFIED;
    }

    public Kleenean getServiceable() {
        return this.isBplCodeGenEnabled() && this.isBwsCodeGenEnabled() ? this._serviceable : Kleenean.UNSPECIFIED;
    }

    public void setServiceable(Kleenean serviceable) {
        this._serviceable = serviceable;
    }

    public boolean isAnnotatedWithConstructionOperationClass() {
        return this._annotatedWithConstructionOperationClass;
    }

    @Override
    public boolean isConstructor() {
        return this._constructionType != null;
    }

    @Override
    public boolean isSelfConstructor() {
        Entity declaringEntity = this.isConstructor() ? this.getDeclaringEntity() : null;
        return declaringEntity != null && declaringEntity.getClass().getSimpleName().equals(this._constructionType.getSimpleName());
    }

    public Class<? extends Entity> getConstructionType() {
        return this._constructionType;
    }

    public Map<String, Property> getConstructionOperationLinkedPropertiesMap() {
        Entity constructionEntityRoot;
        if (this._constructionType == null) {
            return null;
        }
        Map<String, Parameter> parameters = this.getParametersMap();
        if (parameters.isEmpty()) {
            return null;
        }
        Entity operationEntityRoot = this.getDeclaringEntityRoot();
        if (operationEntityRoot == null) {
            return null;
        }
        if (this._constructionType.equals(operationEntityRoot.getDataClass())) {
            constructionEntityRoot = operationEntityRoot;
        } else {
            EntityReference constructionEntityReference = operationEntityRoot.getMainEntityReferenceFrom(this._constructionType);
            Entity entity = constructionEntityRoot = constructionEntityReference == null ? null : constructionEntityReference.getDeclaringEntityRoot();
        }
        if (constructionEntityRoot == null) {
            return null;
        }
        Map<String, Property> constructionEntityRootProperties = constructionEntityRoot.getPropertiesMap();
        if (constructionEntityRootProperties.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Property> properties = new LinkedHashMap<String, Property>();
        for (String key : parameters.keySet()) {
            Parameter parameter = parameters.get(key);
            Property property = parameter.getLinkedProperty();
            if (property == null || property.isCalculable()) continue;
            properties.put(key, property);
        }
        this.setValidConstructionOperationLinkedPropertiesMap(properties, constructionEntityRootProperties);
        return properties.isEmpty() ? null : properties;
    }

    public boolean isValidConstructionOperationLinkedPropertiesMap() {
        return this._validConstructionOperationLinkedPropertiesMap;
    }

    private void setValidConstructionOperationLinkedPropertiesMap(Map<String, Property> linkedProperties, Map<String, Property> entityProperties) {
        this._validConstructionOperationLinkedPropertiesMap = false;
        if (linkedProperties.isEmpty()) {
            return;
        }
        for (String key : entityProperties.keySet()) {
            Property property;
            if (linkedProperties.containsKey(key) || !(property = entityProperties.get(key)).isMandatoryForInsert()) continue;
            return;
        }
        this._validConstructionOperationLinkedPropertiesMap = true;
    }

    public OnConstructionOperationSuccess getOnConstructionSuccess() {
        return this._constructionType != null ? this._onConstructionSuccess : OnConstructionOperationSuccess.UNSPECIFIED;
    }

    public Transition addTransition(State x, State y) {
        Transition transition = new Transition(x, y);
        this.addTransition(transition);
        return transition;
    }

    public void addTransition(Transition transition) {
        Map<String, Transition> map;
        String key;
        if (transition != null && (key = transition.getName()) != null && !(map = this.getTransitionsMap()).containsKey(key)) {
            map.put(key, transition);
        }
    }

    public Trigger trigger(State state) {
        return new Trigger(state, this);
    }

    public void addTriggerOn(State ... states) {
        for (State state : states) {
            Trigger trigger = new Trigger(state, this);
            this.addTriggerOn(trigger);
        }
    }

    private void addTriggerOn(Trigger trigger) {
        Map<String, Trigger> map;
        String key = trigger.getName();
        if (key != null && !(map = this.getTriggersMap()).containsKey(key)) {
            map.put(key, trigger);
        }
    }

    @Override
    public String signature() {
        String fullName = this.getFullName();
        String signature = super.signature();
        String construct = this._constructionType == null ? "" : this._constructionType.getSimpleName() + " ";
        return signature.replace(fullName, construct + fullName);
    }

    @Override
    void initializeAnnotations() {
        super.initializeAnnotations();
        this._processName = StringUtils.defaultIfBlank((String)this._processName, (String)this.getName());
    }

    @Override
    void annotate(Class<?> type) {
        super.annotate(type);
        if (type != null) {
            this.annotateProcessOperationClass(type);
            this.annotateConstructionOperationClass(type);
        }
    }

    @Override
    protected List<Class<? extends Annotation>> getValidTypeAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidTypeAnnotations();
        valid.add(ProcessOperationClass.class);
        valid.add(ConstructionOperationClass.class);
        return valid;
    }

    private void annotateProcessOperationClass(Class<?> type) {
        ProcessOperationClass annotation;
        Class<?> annotatedClass = XS1.getAnnotatedClass(type, ProcessOperationClass.class);
        if (annotatedClass != null && (annotation = annotatedClass.getAnnotation(ProcessOperationClass.class)) != null) {
            String message;
            String group;
            String name = annotation.name();
            if (StringUtils.isNotBlank((String)name)) {
                this._processName = name;
            }
            if (StringUtils.isNotBlank((String)(group = annotation.processingGroup()))) {
                String message2;
                if (StrUtils.esIdentificadorSqlValido(group)) {
                    if (group.length() <= Project.getDefaultCharacterKeyMaxLength()) {
                        this._processingGroup = group;
                        TLC.getProject().getProcessingGroups().add(group);
                    } else {
                        message2 = "invalid processing group identifier \"" + group + "\" at " + this.getFullName();
                        message2 = (String)message2 + "; identifier length cannot be greater than " + Project.getDefaultCharacterKeyMaxLength();
                        logger.error((Object)message2);
                        Project.increaseParserErrorCount();
                    }
                } else {
                    message2 = "invalid processing group identifier \"" + group + "\" at " + this.getFullName();
                    logger.error((Object)message2);
                    Project.increaseParserErrorCount();
                }
            }
            char[] validUnits = new char[]{'m', 'h', 'D'};
            int defaultUnit = 68;
            TemporalAddend min = TemporalAddend.temporalAddendValueOf("0m");
            TemporalAddend max = TemporalAddend.temporalAddendValueOf("365D");
            String previousString = null;
            TemporalAddend previousAddend = null;
            String string = annotation.newTaskNotification();
            if (StringUtils.isNotBlank((String)string)) {
                this._newTaskNotification = TemporalAddend.temporalAddendValueOf(string, validUnits, 'D', min, max);
                if (this._newTaskNotification == null) {
                    message = "invalid new task notification expression \"" + string + "\" at " + this.getFullName();
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else if (this._newTaskNotification.isBadValue()) {
                    message = "invalid new task notification expression \"" + string + "\" at " + this.getFullName();
                    message = message + "; allowed range is \"" + min + "\" to \"" + max + "\"";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else {
                    previousString = "the new task notification expression";
                    previousAddend = this._newTaskNotification;
                }
            }
            this._notifySupervisor = annotation.notifySupervisor();
            this._notifyAssignment = annotation.notifyAssignment();
            this._notifyAssumption = annotation.notifyAssumption();
            this._notifyRelief = annotation.notifyRelief();
            this._notifyAbandonment = annotation.notifyAbandonment();
            this._notifyCancellation = annotation.notifyCancellation();
            this._notifyCompletion = annotation.notifyCompletion();
            string = annotation.unassignedTaskNotification();
            if (StringUtils.isNotBlank((String)string)) {
                this._unassignedTaskNotification = TemporalAddend.temporalAddendValueOf(string, validUnits, 'D', min, max);
                if (this._unassignedTaskNotification == null) {
                    message = "invalid unassigned task notification expression \"" + string + "\" at " + this.getFullName();
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else if (this._unassignedTaskNotification.isBadValue()) {
                    message = "invalid unassigned task notification expression \"" + string + "\" at " + this.getFullName();
                    message = message + "; allowed range is \"" + min + "\" to \"" + max + "\"";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else if (previousAddend != null && previousAddend.compareTo((Object)this._unassignedTaskNotification) > 0) {
                    message = "invalid unassigned task notification expression \"" + string + "\" at " + this.getFullName();
                    message = message + "; its value is less than the value of " + previousString + " \"" + previousAddend + "\"";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else {
                    previousString = "the unassigned task notification expression";
                    previousAddend = this._unassignedTaskNotification;
                }
            }
            if (StringUtils.isNotBlank((String)(string = annotation.unfinishedTaskNotification()))) {
                this._unfinishedTaskNotification = TemporalAddend.temporalAddendValueOf(string, validUnits, 'D', min, max);
                if (this._unfinishedTaskNotification == null) {
                    message = "invalid unfinished task notification expression \"" + string + "\" at " + this.getFullName();
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else if (this._unfinishedTaskNotification.isBadValue()) {
                    message = "invalid unfinished task notification expression \"" + string + "\" at " + this.getFullName();
                    message = message + "; allowed range is \"" + min + "\" to \"" + max + "\"";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else if (previousAddend != null && previousAddend.compareTo((Object)this._unfinishedTaskNotification) > 0) {
                    message = "invalid unfinished task notification expression \"" + string + "\" at " + this.getFullName();
                    message = message + "; its value is less than the value of " + previousString + " \"" + previousAddend + "\"";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else {
                    previousString = "the unfinished task notification expression";
                    previousAddend = this._unfinishedTaskNotification;
                }
            }
            if (StringUtils.isNotBlank((String)(string = annotation.unassignedTaskEscalation()))) {
                this._unassignedTaskEscalation = TemporalAddend.temporalAddendValueOf(string, validUnits, 'D', min, max);
                if (this._unassignedTaskEscalation == null) {
                    message = "invalid unassigned task escalation expression \"" + string + "\" at " + this.getFullName();
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else if (this._unassignedTaskEscalation.isBadValue()) {
                    message = "invalid unassigned task escalation expression \"" + string + "\" at " + this.getFullName();
                    message = message + "; allowed range is \"" + min + "\" to \"" + max + "\"";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else if (previousAddend != null && previousAddend.compareTo((Object)this._unassignedTaskEscalation) > 0) {
                    message = "invalid unassigned task escalation expression \"" + string + "\" at " + this.getFullName();
                    message = message + "; its value is less than the value of " + previousString + " \"" + previousAddend + "\"";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else {
                    previousString = "the unassigned task escalation expression";
                    previousAddend = this._unassignedTaskEscalation;
                }
            }
            if (StringUtils.isNotBlank((String)(string = annotation.unfinishedTaskEscalation()))) {
                this._unfinishedTaskEscalation = TemporalAddend.temporalAddendValueOf(string, validUnits, 'D', min, max);
                if (this._unfinishedTaskEscalation == null) {
                    message = "invalid unfinished task escalation expression \"" + string + "\" at " + this.getFullName();
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else if (this._unfinishedTaskEscalation.isBadValue()) {
                    message = "invalid unfinished task escalation expression \"" + string + "\" at " + this.getFullName();
                    message = message + "; allowed range is \"" + min + "\" to \"" + max + "\"";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else if (previousAddend != null && previousAddend.compareTo((Object)this._unfinishedTaskEscalation) > 0) {
                    message = "invalid unfinished task escalation expression \"" + string + "\" at " + this.getFullName();
                    message = message + "; its value is less than the value of " + previousString + " \"" + previousAddend + "\"";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                }
            }
            if (StringUtils.isNotBlank((String)(string = annotation.nextUnassignedTaskNotification()))) {
                this._nextUnassignedTaskNotification = TemporalAddend.temporalAddendValueOf(string, validUnits, 'D', min, max);
                if (this._nextUnassignedTaskNotification == null) {
                    message = "invalid next unassigned task notification expression \"" + string + "\" at " + this.getFullName();
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else if (this._nextUnassignedTaskNotification.isBadValue()) {
                    message = "invalid next unassigned task notification expression \"" + string + "\" at " + this.getFullName();
                    message = message + "; allowed range is \"" + min + "\" to \"" + max + "\"";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                }
            }
            if (StringUtils.isNotBlank((String)(string = annotation.nextUnfinishedTaskNotification()))) {
                this._nextUnfinishedTaskNotification = TemporalAddend.temporalAddendValueOf(string, validUnits, 'D', min, max);
                if (this._nextUnfinishedTaskNotification == null) {
                    message = "invalid next unfinished task notification expression \"" + string + "\" at " + this.getFullName();
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else if (this._nextUnfinishedTaskNotification.isBadValue()) {
                    message = "invalid next unfinished task notification expression \"" + string + "\" at " + this.getFullName();
                    message = message + "; allowed range is \"" + min + "\" to \"" + max + "\"";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                }
            }
            if (StringUtils.isNotBlank((String)(string = annotation.nextUnassignedTaskEscalation()))) {
                this._nextUnassignedTaskEscalation = TemporalAddend.temporalAddendValueOf(string, validUnits, 'D', min, max);
                if (this._nextUnassignedTaskEscalation == null) {
                    message = "invalid next unassigned task escalation expression \"" + string + "\" at " + this.getFullName();
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else if (this._nextUnassignedTaskEscalation.isBadValue()) {
                    message = "invalid next unassigned task escalation expression \"" + string + "\" at " + this.getFullName();
                    message = message + "; allowed range is \"" + min + "\" to \"" + max + "\"";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                }
            }
            if (StringUtils.isNotBlank((String)(string = annotation.nextUnfinishedTaskEscalation()))) {
                this._nextUnfinishedTaskEscalation = TemporalAddend.temporalAddendValueOf(string, validUnits, 'D', min, max);
                if (this._nextUnfinishedTaskEscalation == null) {
                    message = "invalid next unfinished task escalation expression \"" + string + "\" at " + this.getFullName();
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else if (this._nextUnfinishedTaskEscalation.isBadValue()) {
                    message = "invalid next unfinished task escalation expression \"" + string + "\" at " + this.getFullName();
                    message = message + "; allowed range is \"" + min + "\" to \"" + max + "\"";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                }
            }
            if (StringUtils.isNotBlank((String)(string = annotation.deadline()))) {
                this._deadlineAddend = TemporalAddend.temporalAddendValueOf(string, validUnits, 'D', min, max);
                if (this._deadlineAddend == null) {
                    message = "invalid deadline expression \"" + string + "\" at " + this.getFullName();
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                } else if (this._deadlineAddend.isBadValue()) {
                    message = "invalid deadline expression \"" + string + "\" at " + this.getFullName();
                    message = message + "; allowed range is \"" + min + "\" to \"" + max + "\"";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                }
            }
            this._automaticAssumption = annotation.automaticAssumption();
            this._builtIn = annotation.builtIn();
            this._treeStructureModifier = annotation.treeStructureModifier();
            this._jobPriority = Math.max(0, annotation.priority());
            this._bplCodeGenEnabled = annotation.bpl().toBoolean(this._bplCodeGenEnabled);
            this._sqlCodeGenEnabled = annotation.sql().toBoolean(this._sqlCodeGenEnabled);
            this._serviceable = (Kleenean)this.specified(new Kleenean[]{annotation.serviceable(), this._serviceable});
            this._overloading = (Kleenean)this.specified(new Kleenean[]{annotation.overloading(), this._overloading});
            this._annotatedWithProcessOperationClass = true;
        }
    }

    private void annotateConstructionOperationClass(Class<?> type) {
        ConstructionOperationClass annotation;
        Class<?> annotatedClass = XS1.getAnnotatedClass(type, ConstructionOperationClass.class);
        if (annotatedClass != null && (annotation = annotatedClass.getAnnotation(ConstructionOperationClass.class)) != null) {
            this._constructionType = annotation.type();
            this._onConstructionSuccess = annotation.onsuccess();
            this._annotatedWithConstructionOperationClass = true;
        }
    }
}

