/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.AbstractArtifact;
import adalid.core.Project;
import adalid.core.View;
import adalid.core.enums.SortOption;
import adalid.core.enums.ViewFieldAggregation;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.Property;
import adalid.core.primitives.NumericPrimitive;
import adalid.core.sql.QueryTable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ViewField
extends AbstractArtifact {
    private static final Logger logger = Logger.getLogger(ViewField.class);
    private static final String EOL = "\n";
    private final View _view;
    private final Property _column;
    private final Property _group;
    private final boolean _control;
    private final boolean _chartable;
    private final ViewFieldAggregation _aggregation;
    private final SortOption _sortOption;
    private Integer _pixels;

    ViewField(View view, Property column, SortOption sort) {
        this._view = view;
        this._column = column;
        this._group = column;
        this._control = true;
        this._chartable = false;
        this._aggregation = null;
        this._sortOption = sort == null ? SortOption.ASC : sort;
        this.init(view);
    }

    ViewField(View view, Property column, Property group) {
        this._view = view;
        this._column = column;
        this._group = group;
        this._control = false;
        this._chartable = false;
        this._aggregation = null;
        this._sortOption = null;
        this.init(view);
    }

    ViewField(View view, Property column, ViewFieldAggregation aggregation, SortOption sort) {
        this._view = view;
        this._column = column;
        this._group = null;
        this._control = false;
        if (aggregation == null) {
            this._chartable = false;
            this._aggregation = null;
        } else if (this._column.isEntity() || this._column.isBooleanPrimitive() || this._column.isCharacterPrimitive()) {
            this._chartable = true;
            this._aggregation = ViewFieldAggregation.COUNT;
            this.logNotCountAggregation(aggregation);
        } else if (this._column.isNumericPrimitive()) {
            this._chartable = true;
            this._aggregation = aggregation;
        } else if (this._column.isTemporalPrimitive()) {
            switch (aggregation) {
                case MINIMUM: 
                case MAXIMUM: 
                case COUNT_MINIMUM_MAXIMUM: 
                case MINIMUM_MAXIMUM: {
                    this._chartable = false;
                    this._aggregation = aggregation;
                    break;
                }
                default: {
                    this._chartable = true;
                    this._aggregation = ViewFieldAggregation.COUNT;
                    this.logNotCountAggregation(aggregation);
                    break;
                }
            }
        } else {
            this._chartable = false;
            this._aggregation = null;
            this.logNotValidAggregation();
        }
        this._sortOption = sort;
        this.init(view);
    }

    private void init(View view) {
        this.initDeclaringArtifact(view);
    }

    private void logNotCountAggregation(ViewFieldAggregation aggregation) {
        if (!ViewFieldAggregation.COUNT.equals((Object)aggregation)) {
            String message = aggregation + " cannot be applied to " + this._column.getFullName() + "; using COUNT instead";
            logger.warn((Object)message);
            Project.increaseParserWarningCount();
        }
    }

    private void logNotValidAggregation() {
        String message = "no aggregation cannot be applied to " + this._column.getFullName();
        logger.error((Object)message);
        Project.increaseParserErrorCount();
    }

    @Override
    public String getName() {
        return this._column == null ? super.getName() : this._column.getName();
    }

    @Override
    public String getAlias() {
        PersistentEntity entity = this._view.getEntity();
        QueryTable queryTable = entity == null ? null : entity.getQueryTable();
        return queryTable == null ? super.getAlias() : queryTable.getSqlAlias(this._column);
    }

    public Property getColumn() {
        return this._column;
    }

    public Property getGroup() {
        return this._group;
    }

    public ViewField getGroupField() {
        if (this._group != null) {
            for (ViewField field : this._view.getViewControlFields()) {
                if (!field.getColumn().equals(this._group)) continue;
                return field;
            }
        }
        return null;
    }

    public boolean isControlField() {
        return this._control;
    }

    public ViewFieldAggregation getAggregation() {
        return this._aggregation;
    }

    public boolean isAggregationField() {
        return this._aggregation != null;
    }

    public boolean isNumericAggregationField() {
        return this._aggregation != null && (this._aggregation.equals((Object)ViewFieldAggregation.COUNT) || this._column instanceof NumericPrimitive);
    }

    public boolean isNonNumericAggregationField() {
        return this._aggregation != null && !this.isNumericAggregationField();
    }

    public SortOption getSortOption() {
        return this._sortOption;
    }

    public boolean isChartable() {
        return this._chartable;
    }

    public Integer getPixels() {
        return this._pixels;
    }

    public void setPixels(Integer pixels) {
        this._pixels = pixels == null || pixels < 0 || pixels > 1260 ? null : pixels;
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            String column = this._column == null ? "" : this._column.getName();
            string = (String)string + fee + tab + "column" + faa + column + foo;
        }
        return string;
    }
}

