/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.wrappers;

import adalid.commons.util.StrUtils;
import adalid.core.ExportOperation;
import adalid.core.Operation;
import adalid.core.ReportOperation;
import adalid.core.View;
import adalid.core.interfaces.SqlProgrammer;
import adalid.core.programmers.ChiefProgrammer;
import adalid.core.wrappers.ArtifactWrapper;
import org.apache.commons.lang.StringUtils;

public class OperationWrapper
extends ArtifactWrapper {
    private final Operation _operation;

    public OperationWrapper(Operation operation) {
        super(operation);
        this._operation = operation;
    }

    @Override
    public Operation getWrapped() {
        return this._operation;
    }

    public String getValidDefaultConfirmationMessage() {
        return StringUtils.trimToEmpty((String)this.getDefaultConfirmationMessage());
    }

    protected String getDefaultConfirmationMessage() {
        return this._operation.getDefaultConfirmationMessage();
    }

    public String getBundleDefaultConfirmationMessage() {
        return this.getBundleValueString(this.getDefaultConfirmationMessage());
    }

    public String getBundleValidDefaultConfirmationMessage() {
        return this.getBundleValueString(this.getValidDefaultConfirmationMessage());
    }

    public String getJavaDefaultConfirmationMessage() {
        return this.getJavaString(this.getDefaultConfirmationMessage());
    }

    public String getJavaValidDefaultConfirmationMessage() {
        return this.getJavaString(this.getValidDefaultConfirmationMessage());
    }

    public String getHtmlDefaultConfirmationMessage() {
        return this.getHtmlString(this.getDefaultConfirmationMessage());
    }

    public String getHtmlValidDefaultConfirmationMessage() {
        return this.getHtmlString(this.getValidDefaultConfirmationMessage());
    }

    public String getXmlDefaultConfirmationMessage() {
        return this.getXmlString(this.getDefaultConfirmationMessage());
    }

    public String getXmlValidDefaultConfirmationMessage() {
        return this.getXmlString(this.getValidDefaultConfirmationMessage());
    }

    public String getSqlDefaultConfirmationMessage() {
        return this.getSqlString(this.getDefaultConfirmationMessage());
    }

    public String getSqlValidDefaultConfirmationMessage() {
        return this.getSqlString(this.getValidDefaultConfirmationMessage());
    }

    public String getValidDefaultSuccessMessage() {
        return StringUtils.trimToEmpty((String)this.getDefaultSuccessMessage());
    }

    protected String getDefaultSuccessMessage() {
        return this._operation.getDefaultSuccessMessage();
    }

    public String getBundleDefaultSuccessMessage() {
        return this.getBundleValueString(this.getDefaultSuccessMessage());
    }

    public String getBundleValidDefaultSuccessMessage() {
        return this.getBundleValueString(this.getValidDefaultSuccessMessage());
    }

    public String getJavaDefaultSuccessMessage() {
        return this.getJavaString(this.getDefaultSuccessMessage());
    }

    public String getJavaValidDefaultSuccessMessage() {
        return this.getJavaString(this.getValidDefaultSuccessMessage());
    }

    public String getHtmlDefaultSuccessMessage() {
        return this.getHtmlString(this.getDefaultSuccessMessage());
    }

    public String getHtmlValidDefaultSuccessMessage() {
        return this.getHtmlString(this.getValidDefaultSuccessMessage());
    }

    public String getXmlDefaultSuccessMessage() {
        return this.getXmlString(this.getDefaultSuccessMessage());
    }

    public String getXmlValidDefaultSuccessMessage() {
        return this.getXmlString(this.getValidDefaultSuccessMessage());
    }

    public String getSqlDefaultSuccessMessage() {
        return this.getSqlString(this.getDefaultSuccessMessage());
    }

    public String getSqlValidDefaultSuccessMessage() {
        return this.getSqlString(this.getValidDefaultSuccessMessage());
    }

    public String getBundleExportReportOperationLabel() {
        return this.getBundleValueString(this.getExportReportOperationLabel());
    }

    public String getExportReportOperationLabel() {
        View view;
        String label = this._operation.getDefaultCollectionLabel();
        if (StringUtils.isNotBlank((String)label)) {
            return label;
        }
        View view2 = this._operation instanceof ExportOperation ? ((ExportOperation)this._operation).getView() : (view = this._operation instanceof ReportOperation ? ((ReportOperation)this._operation).getView() : null);
        if (view != null && StringUtils.isNotBlank((String)(label = view.getDefaultLabel()))) {
            return label;
        }
        return null;
    }

    public String getUnderscoredProperName() {
        String string = this._operation.getProperName();
        return StrUtils.getLowerCaseIdentifier(string, '_');
    }

    public String getSqlOperationFunctionName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlOperationFunctionName(this._operation);
    }

    public String getSqlOperationFunctionName(int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlOperationFunctionName(this._operation, maxIdentifierLength);
    }

    public String getSqlSchemaQualifiedOperationFunctionName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedOperationFunctionName(this._operation);
    }

    public String getSqlSchemaQualifiedOperationFunctionName(int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedOperationFunctionName(this._operation, maxIdentifierLength);
    }

    public String getSqlSchemaQualifiedShortOperationFunctionName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedShortOperationFunctionName(this._operation);
    }

    public String getSqlSchemaQualifiedShortOperationFunctionName(int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedShortOperationFunctionName(this._operation, maxIdentifierLength);
    }
}

