/*
 * Decompiled with CFR 0.152.
 */
package adalid.jee2.meta.proyecto.base;

import adalid.commons.util.BitUtils;
import adalid.commons.util.StrUtils;
import adalid.jee2.meta.proyecto.base.ProyectoMaven;
import meta.psm.PrimeFacesThemes;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class ProyectoMavenPrime
extends ProyectoMaven {
    private static final Logger logger = Logger.getLogger(ProyectoMavenPrime.class);
    protected static final String PRIMEFACES_THEME = "primefaces.theme";
    protected static final String PRIMEFACES_THEME_GROUP_ID = "primefaces.theme.groupId";
    protected static final String PRIMEFACES_THEME_ARTIFACT_ID = "primefaces.theme.artifactId";
    protected static final String PRIMEFACES_THEME_VERSION = "primefaces.theme.version";
    protected static final String PRIMEFACES_THEME_SWITCHING_ENABLED = "primefaces.theme.switching.enabled";
    protected static final String PRIMEFACES_VERSION = "primefaces.version";
    protected static final String PRIMEFACES_EXTENSIONS_VERSION = "primefaces.extensions.version";
    protected static final String GOOGLE_GSON_VERSION = "google.gson.version";
    protected static final String VERSION_PRIMEFACES = "primefaces.version";
    protected static final String VERSION_PRIMEFACES_EXTENSIONS = "primefaces.extensions.version";
    protected static final String VERSION_GOOGLE_GSON = "google.gson.version";
    protected static final String DEFAULT_THEME = "saga";
    protected static final String DEFAULT_THEME_GROUP_ID = "org.primefaces.themes";
    private String _theme;
    private String _themeGroupId;
    private String _themeArtifactId;
    private String _themeVersion;
    private Boolean _themeSwitchingEnabled;
    private int _themeDialogWidthSubtrahend = 32;
    private int _themeDialogHeightSubtrahend = 40;
    private DialogPosition _themeDialogPosition = DialogPosition.CENTER;

    @Override
    protected void loadPrivateProperties(Level level, ExtendedProperties properties) {
        String s;
        super.loadPrivateProperties(level, properties);
        if (this._themeSwitchingEnabled == null && (s = properties.getString(PRIMEFACES_THEME_SWITCHING_ENABLED)) != null) {
            this.setThemeSwitchingEnabled(BitUtils.valueOf(s));
            logger.log((Priority)level, (Object)("primefaces.theme.switching.enabled=" + this.isThemeSwitchingEnabled()));
        }
        if (this._theme == null && (s = properties.getString(PRIMEFACES_THEME)) != null) {
            this.setTheme(s);
            logger.log((Priority)level, (Object)("primefaces.theme=" + this.getTheme()));
        }
        if (this._themeGroupId == null && (s = properties.getString(PRIMEFACES_THEME_GROUP_ID)) != null) {
            this.setThemeGroupId(s);
            logger.log((Priority)level, (Object)("primefaces.theme.groupId=" + this.getThemeGroupId()));
        }
        if (this._themeArtifactId == null && (s = properties.getString(PRIMEFACES_THEME_ARTIFACT_ID)) != null) {
            this.setThemeArtifactId(s);
            logger.log((Priority)level, (Object)("primefaces.theme.artifactId=" + this.getThemeArtifactId()));
        }
        if (this._themeVersion == null && (s = properties.getString(PRIMEFACES_THEME_VERSION)) != null) {
            this.setThemeVersion(s);
            logger.log((Priority)level, (Object)("primefaces.theme.version=" + this.getThemeVersion()));
        }
    }

    public boolean allThemesContains(String theme) {
        return PrimeFacesThemes.allThemesContains(theme);
    }

    public boolean primefacesJarContains(String version, String theme) {
        return PrimeFacesThemes.primefacesJarContains(version, theme);
    }

    public String getTheme() {
        return StringUtils.defaultIfBlank((String)this._theme, (String)this.getDefaultTheme());
    }

    public void setTheme(String theme) {
        this._theme = StrUtils.getMavenIdentifier(theme);
    }

    protected String getDefaultTheme() {
        return DEFAULT_THEME;
    }

    public int getThemeDialogWidthSubtrahend() {
        return this._themeDialogWidthSubtrahend;
    }

    public void setThemeDialogWidthSubtrahend(int subtrahend) {
        this._themeDialogWidthSubtrahend = subtrahend < 0 ? 0 : (subtrahend > 320 ? 320 : subtrahend);
    }

    public int getThemeDialogHeightSubtrahend() {
        return this._themeDialogHeightSubtrahend;
    }

    public void setThemeDialogHeightSubtrahend(int subtrahend) {
        this._themeDialogHeightSubtrahend = subtrahend < 0 ? 0 : (subtrahend > 240 ? 240 : subtrahend);
    }

    public DialogPosition getThemeDialogPosition() {
        return this._themeDialogPosition;
    }

    public void setThemeDialogPosition(DialogPosition position) {
        this._themeDialogPosition = position == null ? DialogPosition.CENTER : position;
    }

    public String getThemeGroupId() {
        return StringUtils.defaultIfBlank((String)this._themeGroupId, (String)this.getDefaultThemeGroupId());
    }

    public void setThemeGroupId(String groupId) {
        this._themeGroupId = StrUtils.getMavenIdentifier(groupId);
    }

    protected String getDefaultThemeGroupId() {
        return DEFAULT_THEME_GROUP_ID;
    }

    public String getThemeArtifactId() {
        return StringUtils.defaultIfBlank((String)this._themeArtifactId, (String)this.getDefaultThemeArtifactId());
    }

    public void setThemeArtifactId(String artifactId) {
        this._themeArtifactId = StrUtils.getMavenIdentifier(artifactId);
    }

    protected String getDefaultThemeArtifactId() {
        return null;
    }

    public String getThemeVersion() {
        return StringUtils.defaultIfBlank((String)this._themeVersion, (String)this.getDefaultThemeVersion());
    }

    public void setThemeVersion(String version) {
        this._themeVersion = StrUtils.getMavenVersion(version);
    }

    protected String getDefaultThemeVersion() {
        return null;
    }

    public boolean isThemeSwitchingEnabled() {
        return this._themeSwitchingEnabled == null || BitUtils.valueOf(this._themeSwitchingEnabled);
    }

    public void setThemeSwitchingEnabled(boolean enabled) {
        this._themeSwitchingEnabled = enabled;
    }

    protected static enum DialogPosition {
        CENTER,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        LEFT_TOP,
        LEFT_BOTTOM,
        RIGHT_TOP,
        RIGHT_BOTTOM;

    }
}

