/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.io;

import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.FilUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.util.Utility;
import adalid.util.io.SysCmd;
import adalid.util.io.SysCmdRunner;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

class SysCmdCommand {
    private static final Logger logger = Logger.getLogger(SysCmdCommand.class);
    private static final String WIN_CLI = "cmd.exe";
    private static final File RUNTIME = SysCmd.singleRuntimeFile ? FilUtils.getUserHomeFile(new String[0]) : FilUtils.getUserHomeFile("runtime");
    private static final boolean WINDOWS = Utility.WINDOWS;
    String command;
    final List<String> commands;
    final List<String> env;
    File dir;
    File run;
    FileFilter filter;
    Exception exception;

    SysCmdCommand(String command, List<String> env, File dir) {
        this.command = command;
        this.commands = new ArrayList<String>();
        this.env = env != null ? env : new ArrayList();
        this.dir = dir;
        this.init();
    }

    String[] command() {
        return StringUtils.split((String)this.command, (char)' ');
    }

    String[] env() {
        if (this.env == null || this.env.isEmpty()) {
            return new String[0];
        }
        String[] array = new String[this.env.size()];
        return this.env.toArray(array);
    }

    private void init() {
        File f1 = null;
        SysCmd os = null;
        if (this.command != null && this.dir != null && !StringUtils.startsWithIgnoreCase((String)this.command, (String)WIN_CLI)) {
            if (StringUtils.endsWithIgnoreCase((String)this.command, (String)".sh")) {
                f1 = new File(this.command);
                os = WINDOWS ? SysCmd.WSL : SysCmd.Linux;
                this.filter = FilUtils.nameEndsWithFilter(".sh");
            } else if (WINDOWS && StringUtils.endsWithIgnoreCase((String)this.command, (String)".bat")) {
                f1 = new File(this.command);
                os = SysCmd.Windows;
                this.filter = FilUtils.nameEndsWithFilter(".bat");
            }
        }
        if (f1 == null || os == null) {
            return;
        }
        String pdqName = f1.getName();
        String pdqPath = f1.getAbsolutePath();
        String dirPath = f1.isAbsolute() ? f1.getParent() : this.dir.getAbsolutePath();
        Object comando = f1.isAbsolute() ? pdqPath : dirPath + File.separator + pdqName;
        File f2 = this.cf((String)comando);
        if (f2 == null) {
            return;
        }
        this.addCommands(os, pdqName, dirPath, (String)comando);
        this.run = this.write(f2, pdqName);
        if (this.run != null) {
            String pattern = StringUtils.defaultIfBlank((String)os.commandPattern, (String)os.defaultPattern);
            this.command = pattern.replace("$SCRIPT", this.run.getName());
            this.dir = this.run.getParentFile();
        }
    }

    private void addCommands(SysCmd os, String pdqName, String dirPath, String comando) {
        switch (os) {
            case Linux: {
                this.addCommandsForLinux(pdqName, dirPath, comando);
                break;
            }
            case Windows: {
                this.addCommandsForWindows(pdqName, dirPath, comando);
                break;
            }
            case WSL: {
                this.addCommandsForLinux(pdqName, this.wslPath(dirPath), this.wslPath(comando));
            }
        }
    }

    private void addCommandsForLinux(String pdqName, String dirPath, String comando) {
        String hyphens = StringUtils.repeat((String)"-", (int)comando.length());
        this.commands.add("#!/bin/bash");
        this.commands.add("echo " + hyphens);
        this.commands.add("echo " + comando);
        this.commands.add("echo " + hyphens);
        this.commands.add("cd " + dirPath);
        this.commands.add("source " + pdqName);
        this.commands.add("read -p \"Press any key to continue . . . \" -n 1");
        this.commands.add("exit");
    }

    private void addCommandsForWindows(String pdqName, String dirPath, String comando) {
        String hyphens = StringUtils.repeat((String)"-", (int)comando.length());
        this.commands.add("@echo " + hyphens);
        this.commands.add("@echo " + comando);
        this.commands.add("@echo " + hyphens);
        this.commands.add("@set first_bat=\"%~f0\"");
        this.commands.add("@cd/d " + dirPath);
        this.commands.add("@call " + pdqName);
        this.commands.add("@if defined first_bat pause");
        this.commands.add("@exit");
    }

    private String wslPath(String path) {
        String after = StringUtils.substringAfter((String)path, (String)":");
        String before = StringUtils.substringBefore((String)path, (String)":");
        String wslPath = StringUtils.isBlank((String)after) ? before : "/mnt/" + before.toLowerCase() + after;
        return wslPath.replace('\\', '/');
    }

    private File cf(String comando) {
        File cf = new File(comando);
        if (!cf.isFile()) {
            this.exception = new FileNotFoundException(comando);
            logger.error((Object)this.exception);
            return null;
        }
        return cf;
    }

    private File write(File cf, String batName) {
        File file = this.runnerFile(cf, batName);
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        OpenOption[] options = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, options);){
                for (String line : this.commands) {
                    writer.write(line);
                    writer.write(10);
                }
                writer.flush();
            }
            return file;
        }
        catch (IOException ex) {
            this.exception = ex;
            logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            return null;
        }
    }

    private File runnerFile(File cf, String batName) {
        if (SysCmd.singleRuntimeFile) {
            String x1 = StringUtils.substringAfterLast((String)batName, (String)".");
            Object x2 = x1.isBlank() ? x1 : "." + x1;
            return new File(RUNTIME, SysCmdRunner.class.getCanonicalName() + (String)x2);
        }
        String dp = this.delimitedPath(cf.getParentFile());
        return new File(RUNTIME, dp + batName);
    }

    private String delimitedPath(File dir) {
        char separator;
        String dp;
        String root = PropertiesHandler.getRootFolder().getAbsolutePath();
        String path = dir.getAbsolutePath();
        if (path.startsWith(root)) {
            path = path.substring(root.length());
        }
        return (dp = FilUtils.delimitedPath(path, separator = '@')) == null ? "" : dp + separator;
    }
}

