/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.control.acceso;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Instance;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityDocGen;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityTriggers;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ImageProperty;
import adalid.core.annotations.InactiveIndicator;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.SegmentProperty;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.AvatarDefault;
import adalid.core.enums.AvatarShape;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.Kleenean;
import adalid.core.enums.ListStyle;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.MimeType;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SearchType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.UploadStorageOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.Segment;
import adalid.core.properties.BinaryProperty;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.control.acceso.GrupoUsuario;

@EntityClass(independent=Kleenean.TRUE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.MASCULINE)
@EntityCodeGen(fws=Kleenean.FALSE)
@EntityDocGen(stateDiagram=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE, onload=SelectOnloadOption.EXECUTE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.TRUE, inserts=Kleenean.TRUE, updates=Kleenean.TRUE)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.TRUE)
@EntityTriggers(afterValue=Kleenean.TRUE)
public class Usuario
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @BusinessKey
    @PropertyField(update=Kleenean.FALSE, overlay=Kleenean.FALSE)
    @StringField(maxLength=36)
    public StringProperty codigoUsuario;
    @NameProperty
    public StringProperty nombreUsuario;
    @PropertyField(auditable=Kleenean.FALSE, password=Kleenean.TRUE, hidden=Kleenean.TRUE, filter=Kleenean.FALSE, sort=Kleenean.FALSE)
    @StringField(maxLength=128)
    public StringProperty passwordUsuario;
    @ImageProperty(displayWidth={144, 96, 72}, displayHeight={192, 128, 96}, avatarShape=AvatarShape.CIRCLE, avatarDefault=AvatarDefault.USER)
    @PropertyField(table=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public BinaryProperty octetos;
    @FileReference(types={MimeType.IMAGE}, storage=UploadStorageOption.ROW, blobField="octetos", max=131072)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.FALSE, report=Kleenean.FALSE)
    public StringProperty archivo;
    @StringField(maxLength=100, regex="^[\\w!#$%&\u2019*+/=?`{|}~^-]+(?:\\.[\\w!#$%&\u2019*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$")
    @PropertyField(create=Kleenean.TRUE, overlay=Kleenean.TRUE, table=Kleenean.FALSE, report=Kleenean.FALSE)
    public StringProperty correoElectronico;
    @StringField(maxLength=20, regex="^\\+(?:\\d{1,3})[-\\s](?:\\d{1,4})(?:[-\\s]?\\d{6,10})$", validator="phoneNumberValidator")
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.FALSE, report=Kleenean.FALSE)
    public StringProperty numeroTelefonoMovil;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public BooleanProperty esSuperUsuario;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public BooleanProperty esSuperAuditor;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public BooleanProperty esUsuarioEspecial;
    @InactiveIndicator
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE, overlay=Kleenean.TRUE, heading=Kleenean.FALSE)
    public BooleanProperty esUsuarioInactivo;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, hidden=Kleenean.TRUE)
    public BooleanProperty esUsuarioModificado;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public BooleanProperty esUsuarioAutomatico;
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public TimestampProperty fechaHoraRegistro;
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public TimestampProperty fechaHoraSincronizacion;
    @SegmentProperty
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.CHARACTER_KEY_AND_NAME, displayMode=DisplayMode.WRITING)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.TABLE_AND_DETAIL)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, required=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public GrupoUsuario grupo;
    public Instance ADMINISTRADOR;
    public Instance AUDITOR;
    public Instance OPERADOR;
    protected Segment usuariosEspeciales;
    protected Segment usuariosOrdinarios;

    public Usuario(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "user");
        this.setLocalizedLabel(SPANISH, "usuario");
        this.setLocalizedCollectionLabel(ENGLISH, "Users");
        this.setLocalizedCollectionLabel(SPANISH, "Usuarios");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("Users") + " represents an application user.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Usuarios") + " representa un usuario de la aplicaci\u00f3n.");
        this.setLocalizedShortDescription(ENGLISH, "application user");
        this.setLocalizedShortDescription(SPANISH, "usuario de la aplicaci\u00f3n");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.esSuperUsuario.setInitialValue(false);
        this.esSuperUsuario.setDefaultValue(false);
        this.esSuperAuditor.setInitialValue(false);
        this.esSuperAuditor.setDefaultValue(false);
        this.esUsuarioEspecial.setInitialValue(false);
        this.esUsuarioEspecial.setDefaultValue(false);
        this.esUsuarioInactivo.setInitialValue(false);
        this.esUsuarioInactivo.setDefaultValue(false);
        this.esUsuarioModificado.setInitialValue(false);
        this.esUsuarioModificado.setDefaultValue(false);
        this.esUsuarioAutomatico.setInitialValue(false);
        this.esUsuarioAutomatico.setDefaultValue(false);
        this.codigoUsuario.setLocalizedLabel(ENGLISH, "user code");
        this.codigoUsuario.setLocalizedLabel(SPANISH, "c\u00f3digo del usuario");
        this.codigoUsuario.setLocalizedShortLabel(ENGLISH, "code");
        this.codigoUsuario.setLocalizedShortLabel(SPANISH, "c\u00f3digo");
        this.nombreUsuario.setLocalizedLabel(ENGLISH, "user name");
        this.nombreUsuario.setLocalizedLabel(SPANISH, "nombre del usuario");
        this.nombreUsuario.setLocalizedShortLabel(ENGLISH, "name");
        this.nombreUsuario.setLocalizedShortLabel(SPANISH, "nombre");
        this.passwordUsuario.setLocalizedLabel(ENGLISH, "user password");
        this.passwordUsuario.setLocalizedLabel(SPANISH, "password usuario");
        this.passwordUsuario.setLocalizedShortLabel(ENGLISH, "password");
        this.passwordUsuario.setLocalizedShortLabel(SPANISH, "contrase\u00f1a");
        this.octetos.setLocalizedLabel(ENGLISH, "portrait");
        this.octetos.setLocalizedLabel(SPANISH, "retrato");
        this.octetos.setLocalizedTooltip(ENGLISH, "user portrait");
        this.octetos.setLocalizedTooltip(SPANISH, "retrato del usuario");
        this.archivo.setLocalizedLabel(ENGLISH, "portrait");
        this.archivo.setLocalizedLabel(SPANISH, "retrato");
        this.archivo.setLocalizedTooltip(ENGLISH, "user portrait");
        this.archivo.setLocalizedTooltip(SPANISH, "retrato del usuario");
        this.correoElectronico.setLocalizedLabel(ENGLISH, "e-mail");
        this.correoElectronico.setLocalizedLabel(SPANISH, "correo electr\u00f3nico");
        this.correoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "e-mail does not meet the required pattern");
        this.correoElectronico.setLocalizedRegexErrorMessage(SPANISH, "correo electr\u00f3nico no cumple con el patr\u00f3n requerido");
        this.numeroTelefonoMovil.setLocalizedLabel(ENGLISH, "SMS phone number");
        this.numeroTelefonoMovil.setLocalizedLabel(SPANISH, "n\u00famero de tel\u00e9fono SMS");
        this.numeroTelefonoMovil.setLocalizedDescription(ENGLISH, "mobile phone number capable of receiving SMS messages; this is an international phone number; it must start with a country code, followed by a global subscriber number or an area code and a subscriber number; for example: +58 4121234567, +58-412-1234567");
        this.numeroTelefonoMovil.setLocalizedDescription(SPANISH, "n\u00famero de tel\u00e9fono m\u00f3vil capaz de recibir mensajes SMS; este es un n\u00famero de tel\u00e9fono internacional; debe comenzar con un c\u00f3digo de pa\u00eds, seguido de un n\u00famero de suscriptor global o un c\u00f3digo de \u00e1rea y un n\u00famero de suscriptor; por ejemplo: +58 4121234567, +58-412-1234567");
        this.numeroTelefonoMovil.setLocalizedRegexErrorMessage(ENGLISH, "the phone number does not meet the required pattern; it must start with a country code, i.e. a plus sign and a group of 1 to 3 digits, followed by a global subscriber number, i.e. a group of 7 to 14 digits; country code and global subscriber number must be separated by a single white space or hyphen; global subscriber number can be divided into area code, a group of 1 to 4 digits, and subscriber number, a group of 6 to 10 digits; the area code and subscriber number must be separated by a single blank space or hyphen; whatever their distribution among the groups, the total number of digits must be between 8 and 15.");
        this.numeroTelefonoMovil.setLocalizedRegexErrorMessage(SPANISH, "el n\u00famero de tel\u00e9fono no cumple con el patr\u00f3n requerido; \u00e9ste debe comenzar con un c\u00f3digo de pa\u00eds, es decir, un signo m\u00e1s y un grupo de 1 hasta 3 d\u00edgitos, seguido de un n\u00famero de suscriptor global, es decir, un grupo de 7 hasta 14 d\u00edgitos; el c\u00f3digo de pa\u00eds y el n\u00famero de suscriptor global deben estar separados por un solo espacio en blanco o gui\u00f3n; el n\u00famero de suscriptor global se puede dividir en c\u00f3digo de \u00e1rea, un grupo de 1 hasta 4 d\u00edgitos, y n\u00famero de suscriptor, un grupo de 6 a 10 d\u00edgitos; el c\u00f3digo de \u00e1rea y el n\u00famero de suscriptor deben estar separados por un solo espacio en blanco o gui\u00f3n; cualquiera que sea su distribuci\u00f3n entre los grupos, el n\u00famero total de d\u00edgitos debe estar entre 8 y 15.");
        this.esSuperUsuario.setLocalizedLabel(ENGLISH, "super-user");
        this.esSuperUsuario.setLocalizedLabel(SPANISH, "s\u00faper-usuario");
        this.esSuperUsuario.setLocalizedShortLabel(ENGLISH, "super");
        this.esSuperUsuario.setLocalizedShortLabel(SPANISH, "s\u00faper");
        this.esSuperUsuario.setLocalizedDescription(ENGLISH, "designated as super-user");
        this.esSuperUsuario.setLocalizedDescription(SPANISH, "designado como s\u00faper-usuario");
        this.esSuperAuditor.setLocalizedLabel(ENGLISH, "super-auditor");
        this.esSuperAuditor.setLocalizedLabel(SPANISH, "s\u00faper-auditor");
        this.esSuperAuditor.setLocalizedShortLabel(ENGLISH, "auditor");
        this.esSuperAuditor.setLocalizedShortLabel(SPANISH, "auditor");
        this.esSuperAuditor.setLocalizedDescription(ENGLISH, "designated as super-auditor");
        this.esSuperAuditor.setLocalizedDescription(SPANISH, "designado como s\u00faper-auditor");
        this.esUsuarioEspecial.setLocalizedLabel(ENGLISH, "special user");
        this.esUsuarioEspecial.setLocalizedLabel(SPANISH, "usuario especial");
        this.esUsuarioEspecial.setLocalizedShortLabel(ENGLISH, "special");
        this.esUsuarioEspecial.setLocalizedShortLabel(SPANISH, "especial");
        this.esUsuarioEspecial.setLocalizedDescription(ENGLISH, "special user");
        this.esUsuarioEspecial.setLocalizedDescription(SPANISH, "usuario especial");
        this.esUsuarioInactivo.setLocalizedLabel(ENGLISH, "inactive user");
        this.esUsuarioInactivo.setLocalizedLabel(SPANISH, "usuario inactivo");
        this.esUsuarioInactivo.setLocalizedShortLabel(ENGLISH, "inactive");
        this.esUsuarioInactivo.setLocalizedShortLabel(SPANISH, "inactivo");
        this.esUsuarioInactivo.setLocalizedDescription(ENGLISH, "inactive user");
        this.esUsuarioInactivo.setLocalizedDescription(SPANISH, "usuario inactivo");
        this.esUsuarioModificado.setLocalizedLabel(ENGLISH, "modified user");
        this.esUsuarioModificado.setLocalizedLabel(SPANISH, "usuario modificado");
        this.esUsuarioModificado.setLocalizedShortLabel(ENGLISH, "modified");
        this.esUsuarioModificado.setLocalizedShortLabel(SPANISH, "modificado");
        this.esUsuarioModificado.setLocalizedDescription(ENGLISH, "modified user");
        this.esUsuarioModificado.setLocalizedDescription(SPANISH, "usuario modificado");
        this.esUsuarioAutomatico.setLocalizedLabel(ENGLISH, "automatically registered user");
        this.esUsuarioAutomatico.setLocalizedLabel(SPANISH, "usuario registrado autom\u00e1ticamente");
        this.esUsuarioAutomatico.setLocalizedShortLabel(ENGLISH, "automatic");
        this.esUsuarioAutomatico.setLocalizedShortLabel(SPANISH, "autom\u00e1tico");
        this.esUsuarioAutomatico.setLocalizedDescription(ENGLISH, "automatically registered user");
        this.esUsuarioAutomatico.setLocalizedDescription(SPANISH, "usuario registrado autom\u00e1ticamente");
        this.fechaHoraRegistro.setLocalizedLabel(ENGLISH, "automatic registration timestamp");
        this.fechaHoraRegistro.setLocalizedLabel(SPANISH, "fecha/hora registro autom\u00e1tico");
        this.fechaHoraRegistro.setLocalizedShortLabel(ENGLISH, "registration timestamp");
        this.fechaHoraRegistro.setLocalizedShortLabel(SPANISH, "fecha/hora registro");
        this.fechaHoraRegistro.setLocalizedDescription(ENGLISH, "automatic registration timestamp");
        this.fechaHoraRegistro.setLocalizedDescription(SPANISH, "fecha/hora de registro autom\u00e1tico");
        this.fechaHoraSincronizacion.setLocalizedLabel(ENGLISH, "last synchronization timestamp");
        this.fechaHoraSincronizacion.setLocalizedLabel(SPANISH, "fecha/hora \u00faltima sincronizaci\u00f3n");
        this.fechaHoraSincronizacion.setLocalizedShortLabel(ENGLISH, "synchronization timestamp");
        this.fechaHoraSincronizacion.setLocalizedShortLabel(SPANISH, "fecha/hora sincronizaci\u00f3n");
        this.fechaHoraSincronizacion.setLocalizedDescription(ENGLISH, "timestamp of last synchronization");
        this.fechaHoraSincronizacion.setLocalizedDescription(SPANISH, "fecha/hora de la \u00faltima sincronizaci\u00f3n");
        this.grupo.setLocalizedLabel(ENGLISH, "user group");
        this.grupo.setLocalizedLabel(SPANISH, "grupo de usuarios");
        this.grupo.setLocalizedShortLabel(ENGLISH, "group");
        this.grupo.setLocalizedShortLabel(SPANISH, "grupo");
        this.grupo.setLocalizedDescription(ENGLISH, "group to which this user belongs");
        this.grupo.setLocalizedDescription(SPANISH, "grupo al que pertenece este usuario");
        this.grupo.setLocalizedTooltip(ENGLISH, "code of the group to which this user belongs");
        this.grupo.setLocalizedTooltip(SPANISH, "c\u00f3digo del grupo al que pertenece este usuario");
    }

    public Instance getAdministratorUserInstance() {
        return this.ADMINISTRADOR;
    }

    public Instance getAuditorUserInstance() {
        return this.AUDITOR;
    }

    public Instance getBasicUserInstance() {
        return this.OPERADOR;
    }

    @Override
    protected void settleInstances() {
        super.settleInstances();
        this.ADMINISTRADOR.newInstanceField((Property)this.id, 101);
        this.ADMINISTRADOR.newInstanceField(this.codigoUsuario, "admin");
        this.ADMINISTRADOR.newInstanceField(this.nombreUsuario, "Administrador");
        this.ADMINISTRADOR.newInstanceField(this.passwordUsuario, "sesamo");
        this.ADMINISTRADOR.newInstanceField((Property)this.esSuperUsuario, true);
        this.ADMINISTRADOR.newInstanceField((Property)this.esSuperAuditor, false);
        this.ADMINISTRADOR.newInstanceField((Property)this.esUsuarioEspecial, true);
        this.AUDITOR.newInstanceField((Property)this.id, 102);
        this.AUDITOR.newInstanceField(this.codigoUsuario, "audit");
        this.AUDITOR.newInstanceField(this.nombreUsuario, "Auditor");
        this.AUDITOR.newInstanceField(this.passwordUsuario, "sesamo");
        this.AUDITOR.newInstanceField((Property)this.esSuperUsuario, false);
        this.AUDITOR.newInstanceField((Property)this.esSuperAuditor, true);
        this.AUDITOR.newInstanceField((Property)this.esUsuarioEspecial, true);
        this.OPERADOR.newInstanceField((Property)this.id, 103);
        this.OPERADOR.newInstanceField(this.codigoUsuario, "oper");
        this.OPERADOR.newInstanceField(this.nombreUsuario, "Operador");
        this.OPERADOR.newInstanceField((Property)this.esSuperUsuario, false);
        this.OPERADOR.newInstanceField((Property)this.esSuperAuditor, false);
        this.OPERADOR.newInstanceField((Property)this.esUsuarioEspecial, true);
        this.ADMINISTRADOR.newInstanceField(this.codigoUsuario, "admin", ENGLISH);
        this.ADMINISTRADOR.newInstanceField(this.codigoUsuario, "admin", SPANISH);
        this.ADMINISTRADOR.newInstanceField(this.nombreUsuario, "Administrator", ENGLISH);
        this.ADMINISTRADOR.newInstanceField(this.nombreUsuario, "Administrador", SPANISH);
        this.AUDITOR.newInstanceField(this.codigoUsuario, "audit", ENGLISH);
        this.AUDITOR.newInstanceField(this.codigoUsuario, "audit", SPANISH);
        this.AUDITOR.newInstanceField(this.nombreUsuario, "Auditor", ENGLISH);
        this.AUDITOR.newInstanceField(this.nombreUsuario, "Auditor", SPANISH);
        this.OPERADOR.newInstanceField(this.codigoUsuario, "oper", ENGLISH);
        this.OPERADOR.newInstanceField(this.codigoUsuario, "oper", SPANISH);
        this.OPERADOR.newInstanceField(this.nombreUsuario, "Operator", ENGLISH);
        this.OPERADOR.newInstanceField(this.nombreUsuario, "Operador", SPANISH);
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.usuariosEspeciales = this.esUsuarioEspecial.isTrue();
        this.usuariosOrdinarios = this.esUsuarioEspecial.isFalse();
        this.usuariosEspeciales.setLocalizedDescription(ENGLISH, "the user is a special user");
        this.usuariosEspeciales.setLocalizedDescription(SPANISH, "el usuario es un usuario especial");
        this.usuariosEspeciales.setLocalizedErrorMessage(ENGLISH, "the user is not a special user");
        this.usuariosEspeciales.setLocalizedErrorMessage(SPANISH, "el usuario no es un usuario especial");
        this.usuariosOrdinarios.setLocalizedDescription(ENGLISH, "the user is not a special user");
        this.usuariosOrdinarios.setLocalizedDescription(SPANISH, "el usuario no es un usuario especial");
        this.usuariosOrdinarios.setLocalizedErrorMessage(ENGLISH, "the user is a special user");
        this.usuariosOrdinarios.setLocalizedErrorMessage(SPANISH, "el usuario es un usuario especial");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.archivo.setRenderingFilter(UNTRUTH, true);
    }
}

