/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.operacion.basica;

import adalid.core.AbstractPersistentEntity;
import adalid.core.EntityCollection;
import adalid.core.ProcessOperation;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityCollectionField;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceConversionValidation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.OneToMany;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.CascadeType;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.DefaultCondition;
import adalid.core.enums.FetchType;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.ViewMenuOption;
import adalid.core.expressions.BooleanComparisonX;
import adalid.core.expressions.CharacterOtherwiseX;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Segment;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.FormatoPaginaInforme;
import meta.entidad.comun.configuracion.basica.ext.Funcion;
import meta.entidad.comun.control.acceso.Usuario;
import meta.entidad.comun.operacion.basica.VistaFuncionCol;

@EntityClass(base=Kleenean.TRUE, independent=Kleenean.FALSE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.FEMININE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.TRUE, menu=ViewMenuOption.NONE, inserts=Kleenean.FALSE, updates=Kleenean.FALSE)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.TRUE, menu=Kleenean.FALSE)
public class VistaFuncion
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @BusinessKey
    @StringField(maxLength=100)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.FALSE, heading=Kleenean.FALSE, defaultCondition=DefaultCondition.UNCONDITIONALLY_ON_INSERT, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public StringProperty codigo;
    @NameProperty
    public StringProperty nombre;
    @DescriptionProperty
    @StringField(maxLength=0)
    public StringProperty descripcion;
    @ManyToOne(navigability=Navigability.BIDIRECTIONAL, view=MasterDetailView.TABLE_AND_DETAIL)
    @ColumnField(nullable=Kleenean.FALSE)
    public Funcion funcion;
    @OwnerProperty
    @ForeignKey(onDelete=OnDeleteAction.CASCADE, onUpdate=OnUpdateAction.CASCADE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, search=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE, defaultCondition=DefaultCondition.IF_NULL_ON_INSERT, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public Usuario propietario;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, search=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.FALSE)
    public Usuario remitente;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, search=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public BooleanProperty publica;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, search=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public BooleanProperty especial;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, heading=Kleenean.TRUE, search=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public FormatoPaginaInforme formato;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public IntegerProperty anchoPagina;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public IntegerProperty largoPagina;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(hidden=Kleenean.TRUE)
    public BooleanProperty orientacionHorizontal;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(hidden=Kleenean.TRUE)
    public BooleanProperty orientacionVertical;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public IntegerProperty margenSuperior;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public IntegerProperty margenInferior;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public IntegerProperty margenIzquierdo;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public IntegerProperty margenDerecho;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(prominent=Kleenean.TRUE)
    public IntegerProperty anchoColumna;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(hidden=Kleenean.TRUE)
    public IntegerProperty largoColumna;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, prominent=Kleenean.TRUE)
    public IntegerProperty anchoDetalle;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(prominent=Kleenean.TRUE, table=Kleenean.TRUE)
    public IntegerProperty anchoDisponible;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(hidden=Kleenean.TRUE)
    public BooleanProperty valida;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(hidden=Kleenean.TRUE)
    public IntegerProperty secuencia;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idVistaFuncionOriginal;
    @EntityCollectionField
    @OneToMany(targetEntity=VistaFuncionCol.class, mappedBy="vista")
    EntityCollection columnas;
    protected Segment privadas;
    protected Segment ordinarias;
    protected Segment personales;
    protected EnviarCopia enviarCopia;
    protected Publicar publicar;
    protected Privatizar privatizar;

    public VistaFuncion(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings("funcion.dominio");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "view");
        this.setLocalizedLabel(SPANISH, "vista");
        this.setLocalizedCollectionLabel(ENGLISH, "Views");
        this.setLocalizedCollectionLabel(SPANISH, "Vistas");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("Views") + " represents a view to generate files and reports defined by the user.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Vistas") + " representa una vista para generar archivos e informes definida por el usuario.");
        this.setLocalizedShortDescription(ENGLISH, "view to generate files and reports defined by the user");
        this.setLocalizedShortDescription(SPANISH, "vista para generar archivos e informes definida por el usuario");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.setOrderBy(this.funcion, this.publica, this.especial, this.nombre);
        this.codigo.setDefaultValue(this.funcion.dominio.codigoDominio.concat("-").concat(this.id));
        this.publica.setInitialValue(false);
        this.publica.setDefaultValue(false);
        this.especial.setInitialValue(false);
        this.especial.setDefaultValue(false);
        this.formato.setInitialValue(this.formato.PERSONALIZADO);
        this.formato.setDefaultValue(this.formato.PERSONALIZADO);
        BooleanComparisonX personalizado = this.formato.isEqualTo(this.formato.PERSONALIZADO);
        this.anchoPagina.setInitialValue(this.formato.anchoPagina);
        this.anchoPagina.setDefaultValue(this.formato.anchoPagina);
        this.anchoPagina.setMinValue(360);
        this.anchoPagina.setMaxValue(1296);
        this.anchoPagina.setPrimalInitialValue(1008);
        this.anchoPagina.setPrimalDefaultValue(1008);
        this.largoPagina.setInitialValue(this.formato.largoPagina);
        this.largoPagina.setDefaultValue(this.formato.largoPagina);
        this.largoPagina.setMinValue(360);
        this.largoPagina.setMaxValue(1296);
        this.largoPagina.setPrimalInitialValue(774);
        this.largoPagina.setPrimalDefaultValue(774);
        this.orientacionHorizontal.setCalculableValueExpression(this.anchoPagina.isGreaterThan(this.largoPagina));
        this.orientacionHorizontal.setInitialValue(personalizado.then(this.anchoPagina.isGreaterThan(this.largoPagina)).otherwise(this.formato.anchoPagina.isGreaterThan(this.formato.largoPagina)));
        this.orientacionVertical.setCalculableValueExpression(this.anchoPagina.isLessThan(this.largoPagina));
        this.orientacionVertical.setInitialValue(personalizado.then(this.anchoPagina.isLessThan(this.largoPagina)).otherwise(this.formato.anchoPagina.isLessThan(this.formato.largoPagina)));
        this.margenSuperior.setInitialValue(this.formato.margenSuperior);
        this.margenSuperior.setDefaultValue(this.formato.margenSuperior);
        this.margenSuperior.setMinValue(18);
        this.margenSuperior.setMaxValue(144);
        this.margenSuperior.setPrimalInitialValue(24);
        this.margenSuperior.setPrimalDefaultValue(24);
        this.margenInferior.setInitialValue(this.formato.margenInferior);
        this.margenInferior.setDefaultValue(this.formato.margenInferior);
        this.margenInferior.setMinValue(18);
        this.margenInferior.setMaxValue(144);
        this.margenInferior.setPrimalInitialValue(24);
        this.margenInferior.setPrimalDefaultValue(24);
        this.margenIzquierdo.setInitialValue(this.formato.margenIzquierdo);
        this.margenIzquierdo.setDefaultValue(this.formato.margenIzquierdo);
        this.margenIzquierdo.setMinValue(18);
        this.margenIzquierdo.setMaxValue(144);
        this.margenIzquierdo.setPrimalInitialValue(24);
        this.margenIzquierdo.setPrimalDefaultValue(24);
        this.margenDerecho.setInitialValue(this.formato.margenDerecho);
        this.margenDerecho.setDefaultValue(this.formato.margenDerecho);
        this.margenDerecho.setMinValue(18);
        this.margenDerecho.setMaxValue(144);
        this.margenDerecho.setPrimalInitialValue(24);
        this.margenDerecho.setPrimalDefaultValue(24);
        this.anchoColumna.setMinValue(324);
        this.anchoColumna.setMaxValue(1260);
        this.anchoColumna.setCalculableValueExpression(this.anchoPagina.minus(this.margenIzquierdo.plus(this.margenDerecho)));
        this.anchoColumna.setInitialValue(personalizado.then(this.anchoPagina.minus(this.margenIzquierdo.plus(this.margenDerecho))).otherwise(this.formato.anchoPagina.minus(this.formato.margenIzquierdo.plus(this.formato.margenDerecho))));
        this.largoColumna.setMinValue(324);
        this.largoColumna.setMaxValue(1260);
        this.largoColumna.setCalculableValueExpression(this.largoPagina.minus(this.margenSuperior.plus(this.margenInferior)));
        this.largoColumna.setInitialValue(personalizado.then(this.largoPagina.minus(this.margenSuperior.plus(this.margenInferior))).otherwise(this.formato.largoPagina.minus(this.formato.margenSuperior.plus(this.formato.margenInferior))));
        this.anchoDetalle.setInitialValue(0);
        this.anchoDetalle.setDefaultValue(0);
        this.anchoDetalle.setMinValue(0);
        this.anchoDetalle.setMaxValue(999999999);
        String imagenAnchoDisponible1 = this.fa(" fa fa-question-circle-o  fa-fw  xs-status-null-value-image ");
        String imagenAnchoDisponible2 = this.fa(" w3-text-green  fa fa-check-circle  fa-lg ");
        String imagenAnchoDisponible3 = this.fa(" w3-text-deep-orange  fa fa-exclamation-circle  fa-lg ");
        CharacterOtherwiseX imagenAnchoDisponibleX = this.anchoDisponible.isNull().then(imagenAnchoDisponible1).otherwise(this.anchoDisponible.isGreaterOrEqualTo(0).then(imagenAnchoDisponible2).otherwise(imagenAnchoDisponible3));
        this.anchoDisponible.setMinValue(-999999999);
        this.anchoDisponible.setMaxValue(1260);
        this.anchoDisponible.setGraphicImageFontAwesomeClassNameExpression(imagenAnchoDisponibleX);
        this.anchoDisponible.setCalculableValueExpression(this.anchoPagina.minus(this.margenIzquierdo.plus(this.margenDerecho).plus(this.anchoDetalle)));
        this.anchoDisponible.setInitialValue(personalizado.then(this.anchoPagina.minus(this.margenIzquierdo.plus(this.margenDerecho).plus(this.anchoDetalle))).otherwise(this.formato.anchoPagina.minus(this.formato.margenIzquierdo.plus(this.formato.margenDerecho).plus(this.anchoDetalle))));
        this.valida.setInitialValue(false);
        this.valida.setDefaultValue(false);
        this.secuencia.setInitialValue(0);
        this.secuencia.setDefaultValue(0);
        this.codigo.setLocalizedLabel(ENGLISH, "view code");
        this.codigo.setLocalizedLabel(SPANISH, "c\u00f3digo de la vista");
        this.codigo.setLocalizedShortLabel(ENGLISH, "code");
        this.codigo.setLocalizedShortLabel(SPANISH, "c\u00f3digo");
        this.codigo.setLocalizedDefaultValueTag(ENGLISH, this.b("code") + " of " + this.b("domain") + " of " + this.b("function") + " + " + this.b("id"));
        this.codigo.setLocalizedDefaultValueTag(SPANISH, this.b("c\u00f3digo") + " de " + this.b("dominio") + " de " + this.b("funci\u00f3n") + " + " + this.b("id"));
        this.nombre.setLocalizedLabel(ENGLISH, "view name");
        this.nombre.setLocalizedLabel(SPANISH, "nombre de la vista");
        this.nombre.setLocalizedShortLabel(ENGLISH, "name");
        this.nombre.setLocalizedShortLabel(SPANISH, "nombre");
        this.descripcion.setLocalizedLabel(ENGLISH, "view description");
        this.descripcion.setLocalizedLabel(SPANISH, "descripci\u00f3n de la vista");
        this.descripcion.setLocalizedShortLabel(ENGLISH, "description");
        this.descripcion.setLocalizedShortLabel(SPANISH, "descripci\u00f3n");
        this.funcion.setLocalizedLabel(ENGLISH, "function");
        this.funcion.setLocalizedLabel(SPANISH, "funci\u00f3n");
        this.propietario.setLocalizedLabel(ENGLISH, "view owner");
        this.propietario.setLocalizedLabel(SPANISH, "propietario de la vista");
        this.propietario.setLocalizedShortLabel(ENGLISH, "owner");
        this.propietario.setLocalizedShortLabel(SPANISH, "propietario");
        this.remitente.setLocalizedLabel(ENGLISH, "sender");
        this.remitente.setLocalizedLabel(SPANISH, "remitente");
        this.publica.setLocalizedLabel(ENGLISH, "public");
        this.publica.setLocalizedLabel(SPANISH, "p\u00fablica");
        this.publica.setLocalizedDescription(ENGLISH, "Public view indicator; public views can be used by all users authorized to query the entity");
        this.publica.setLocalizedDescription(SPANISH, "indicador de vista p\u00fablica; las vistas p\u00fablicas pueden ser utilizadas por todos los usuarios autorizados a hacer consultas sobre la entidad");
        this.especial.setLocalizedLabel(ENGLISH, "special");
        this.especial.setLocalizedLabel(SPANISH, "especial");
        this.especial.setLocalizedDescription(ENGLISH, "Special view indicator; special views are predefined views of the application; they are initially public, but can be privatized");
        this.especial.setLocalizedDescription(SPANISH, "indicador de vista especial; las vistas especiales son vistas predefinidas de la aplicaci\u00f3n; inicialmente son p\u00fablicas, pero pueden ser privatizadas");
        this.formato.setLocalizedLabel(ENGLISH, "preconfigured page format");
        this.formato.setLocalizedLabel(SPANISH, "formato de p\u00e1gina preconfigurado");
        this.formato.setLocalizedShortLabel(ENGLISH, "format");
        this.formato.setLocalizedShortLabel(SPANISH, "formato");
        this.formato.setLocalizedDescription(ENGLISH, "Preconfigured page format; the preconfigured page formats define paper size, orientation (landscape or portrait) and margins of the report");
        this.formato.setLocalizedDescription(SPANISH, "Formato de p\u00e1gina preconfigurado; los formatos de p\u00e1gina preconfigurados definen el tama\u00f1o del papel, la orientaci\u00f3n (horizontal o vertical) y los m\u00e1rgenes del informe");
        String appendix = "; one pixel equals one typographic dot and 72 typographic dots equals one inch.";
        String apendice = "; un pixel equivale a un punto tipogr\u00e1fico y 72 puntos tipogr\u00e1ficos equivalen a una pulgada.";
        this.anchoPagina.setLocalizedLabel(ENGLISH, "page width");
        this.anchoPagina.setLocalizedLabel(SPANISH, "ancho de p\u00e1gina");
        this.anchoPagina.setLocalizedDescription(ENGLISH, "Width of the sheet of paper, in pixels" + appendix);
        this.anchoPagina.setLocalizedDescription(SPANISH, "Ancho de la hoja de papel, expresado en pixeles" + apendice);
        String english = this.b("page width") + " of " + this.b("format");
        String spanish = this.b("ancho de p\u00e1gina") + " de " + this.b("formato");
        this.anchoPagina.setLocalizedInitialValueTag(ENGLISH, english);
        this.anchoPagina.setLocalizedInitialValueTag(SPANISH, spanish);
        this.anchoPagina.setLocalizedDefaultValueTag(ENGLISH, english);
        this.anchoPagina.setLocalizedDefaultValueTag(SPANISH, spanish);
        this.largoPagina.setLocalizedLabel(ENGLISH, "page height");
        this.largoPagina.setLocalizedLabel(SPANISH, "altura de p\u00e1gina");
        this.largoPagina.setLocalizedDescription(ENGLISH, "Height of the sheet of paper, in pixels" + appendix);
        this.largoPagina.setLocalizedDescription(SPANISH, "Altura de la hoja de papel, expresado en pixeles" + apendice);
        english = this.b("page height") + " of " + this.b("format");
        spanish = this.b("altura de p\u00e1gina") + " de " + this.b("formato");
        this.largoPagina.setLocalizedInitialValueTag(ENGLISH, english);
        this.largoPagina.setLocalizedInitialValueTag(SPANISH, spanish);
        this.largoPagina.setLocalizedDefaultValueTag(ENGLISH, english);
        this.largoPagina.setLocalizedDefaultValueTag(SPANISH, spanish);
        this.orientacionHorizontal.setLocalizedLabel(ENGLISH, "landscape orientation");
        this.orientacionHorizontal.setLocalizedLabel(SPANISH, "orientaci\u00f3n horizontal");
        this.orientacionVertical.setLocalizedLabel(ENGLISH, "portrait orientation");
        this.orientacionVertical.setLocalizedLabel(SPANISH, "orientaci\u00f3n vertical");
        this.margenSuperior.setLocalizedLabel(ENGLISH, "top margin");
        this.margenSuperior.setLocalizedLabel(SPANISH, "margen superior");
        this.margenSuperior.setLocalizedDescription(ENGLISH, "Top margin, in pixels" + appendix);
        this.margenSuperior.setLocalizedDescription(SPANISH, "Margen superior, expresado en pixeles" + apendice);
        english = this.b("top margin") + " of " + this.b("format");
        spanish = this.b("margen superior") + " de " + this.b("formato");
        this.margenSuperior.setLocalizedInitialValueTag(ENGLISH, english);
        this.margenSuperior.setLocalizedInitialValueTag(SPANISH, spanish);
        this.margenSuperior.setLocalizedDefaultValueTag(ENGLISH, english);
        this.margenSuperior.setLocalizedDefaultValueTag(SPANISH, spanish);
        this.margenInferior.setLocalizedLabel(ENGLISH, "bottom margin");
        this.margenInferior.setLocalizedLabel(SPANISH, "margen inferior");
        this.margenInferior.setLocalizedDescription(ENGLISH, "Bottom margin, in pixels" + appendix);
        this.margenInferior.setLocalizedDescription(SPANISH, "Margen inferior, expresado en pixeles" + apendice);
        english = this.b("bottom margin") + " of " + this.b("format");
        spanish = this.b("margen inferior") + " de " + this.b("formato");
        this.margenInferior.setLocalizedInitialValueTag(ENGLISH, english);
        this.margenInferior.setLocalizedInitialValueTag(SPANISH, spanish);
        this.margenInferior.setLocalizedDefaultValueTag(ENGLISH, english);
        this.margenInferior.setLocalizedDefaultValueTag(SPANISH, spanish);
        this.margenIzquierdo.setLocalizedLabel(ENGLISH, "left margin");
        this.margenIzquierdo.setLocalizedLabel(SPANISH, "margen izquierdo");
        this.margenIzquierdo.setLocalizedDescription(ENGLISH, "Left margin, in pixels" + appendix);
        this.margenIzquierdo.setLocalizedDescription(SPANISH, "Margen izquierdo, expresado en pixeles" + apendice);
        english = this.b("left margin") + " of " + this.b("format");
        spanish = this.b("margen izquierdo") + " de " + this.b("formato");
        this.margenIzquierdo.setLocalizedInitialValueTag(ENGLISH, english);
        this.margenIzquierdo.setLocalizedInitialValueTag(SPANISH, spanish);
        this.margenIzquierdo.setLocalizedDefaultValueTag(ENGLISH, english);
        this.margenIzquierdo.setLocalizedDefaultValueTag(SPANISH, spanish);
        this.margenDerecho.setLocalizedLabel(ENGLISH, "right margin");
        this.margenDerecho.setLocalizedLabel(SPANISH, "margen derecho");
        this.margenDerecho.setLocalizedDescription(ENGLISH, "Right margin, in pixels" + appendix);
        this.margenDerecho.setLocalizedDescription(SPANISH, "Margen derecho, expresado en pixeles" + apendice);
        english = this.b("right margin") + " of " + this.b("format");
        spanish = this.b("margen derecho") + " de " + this.b("formato");
        this.margenDerecho.setLocalizedInitialValueTag(ENGLISH, english);
        this.margenDerecho.setLocalizedInitialValueTag(SPANISH, spanish);
        this.margenDerecho.setLocalizedDefaultValueTag(ENGLISH, english);
        this.margenDerecho.setLocalizedDefaultValueTag(SPANISH, spanish);
        this.anchoColumna.setLocalizedLabel(ENGLISH, "print area width");
        this.anchoColumna.setLocalizedLabel(SPANISH, "ancho del \u00e1rea de impresi\u00f3n");
        this.anchoColumna.setLocalizedShortLabel(SPANISH, "ancho de impresi\u00f3n");
        this.anchoColumna.setLocalizedDescription(ENGLISH, "Width of the print area, in pixels; it is equal to: page width - left margin - right margin");
        this.anchoColumna.setLocalizedDescription(SPANISH, "Ancho del \u00e1rea de impresi\u00f3n, expresado en pixeles; es igual a: ancho de p\u00e1gina - margen izquierdo - margen derecho");
        this.anchoColumna.setLocalizedInitialValueTag(ENGLISH, this.b("page width") + " minus " + this.b("left margin") + " minus " + this.b("right margin"));
        this.anchoColumna.setLocalizedInitialValueTag(SPANISH, this.b("ancho de p\u00e1gina") + " menos " + this.b("margen izquierdo") + " menos " + this.b("margen derecho"));
        this.largoColumna.setLocalizedLabel(ENGLISH, "print area height");
        this.largoColumna.setLocalizedLabel(SPANISH, "altura del \u00e1rea de impresi\u00f3n");
        this.largoColumna.setLocalizedShortLabel(SPANISH, "altura de impresi\u00f3n");
        this.largoColumna.setLocalizedDescription(ENGLISH, "Height of the print area, in pixels; it is equal to: page height - top margin - bottom margin");
        this.largoColumna.setLocalizedDescription(SPANISH, "Altura del \u00e1rea de impresi\u00f3n, expresado en pixeles; es igual a: altura de p\u00e1gina - margen superior - margen inferior");
        this.anchoDetalle.setLocalizedLabel(ENGLISH, "detail width");
        this.anchoDetalle.setLocalizedLabel(SPANISH, "ancho del detalle");
        this.anchoDetalle.setLocalizedDescription(ENGLISH, "Width of the detail group, in pixels; it is the sum of the witdh of all fields in the group");
        this.anchoDetalle.setLocalizedDescription(SPANISH, "Ancho del grupo de detalle, en p\u00edxeles; es la suma del ancho de todos los campos del grupo");
        this.anchoDisponible.setLocalizedLabel(ENGLISH, "available in detail");
        this.anchoDisponible.setLocalizedLabel(SPANISH, "disponible en detalle");
        this.anchoDisponible.setLocalizedDescription(ENGLISH, "Available width for fields in detail group, in pixels; it is equal to: print area width - detail width");
        this.anchoDisponible.setLocalizedDescription(SPANISH, "Ancho disponible para campos en el grupo de detalle, en p\u00edxeles; es igual a: ancho de impresi\u00f3n - ancho del detalle");
        this.anchoDisponible.setLocalizedInitialValueTag(ENGLISH, this.b("page width") + " minus " + this.b("left margin") + " minus " + this.b("right margin") + " minus " + this.b("detail width"));
        this.anchoDisponible.setLocalizedInitialValueTag(SPANISH, this.b("ancho de p\u00e1gina") + " menos " + this.b("margen izquierdo") + " menos " + this.b("margen derecho") + " menos " + this.b("ancho del detalle"));
        this.anchoDisponible.setLocalizedGraphicImageTooltip(ENGLISH, imagenAnchoDisponible1, "unspecified value");
        this.anchoDisponible.setLocalizedGraphicImageTooltip(ENGLISH, imagenAnchoDisponible2, "the detail is wide enough");
        this.anchoDisponible.setLocalizedGraphicImageTooltip(ENGLISH, imagenAnchoDisponible3, "the detail is not wide enough to fit all the columns in the view");
        this.anchoDisponible.setLocalizedGraphicImageTooltip(SPANISH, imagenAnchoDisponible1, "valor no especificado");
        this.anchoDisponible.setLocalizedGraphicImageTooltip(SPANISH, imagenAnchoDisponible2, "el detalle es lo suficientemente ancho");
        this.anchoDisponible.setLocalizedGraphicImageTooltip(SPANISH, imagenAnchoDisponible3, "el detalle no es lo suficientemente ancho para poder incluir todas las columnas de la vista");
        this.valida.setLocalizedLabel(ENGLISH, "valid");
        this.valida.setLocalizedLabel(SPANISH, "v\u00e1lida");
        this.secuencia.setLocalizedLabel(ENGLISH, "sequence");
        this.secuencia.setLocalizedLabel(SPANISH, "secuencia");
        this.idVistaFuncionOriginal.setLocalizedLabel(ENGLISH, "original view");
        this.idVistaFuncionOriginal.setLocalizedLabel(SPANISH, "vista original");
        this.idVistaFuncionOriginal.setLocalizedShortLabel(ENGLISH, "original");
        this.idVistaFuncionOriginal.setLocalizedShortLabel(SPANISH, "original");
    }

    @Override
    protected void settleCollections() {
        super.settleCollections();
        this.columnas.setCreateField(false);
        this.columnas.setDetailField(false);
        this.columnas.setFetchType(FetchType.LAZY);
        this.columnas.setOrphanRemoval(true);
        this.columnas.setUpdateField(true);
        this.columnas.setCascadeType(CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.REFRESH);
        this.columnas.setLocalizedLabel(ENGLISH, "view columns");
        this.columnas.setLocalizedLabel(SPANISH, "columnas de la vista");
        this.columnas.setLocalizedShortLabel(ENGLISH, "columns");
        this.columnas.setLocalizedShortLabel(SPANISH, "columnas");
        this.columnas.setLocalizedDescription(ENGLISH, "view column collection");
        this.columnas.setLocalizedDescription(SPANISH, "colecci\u00f3n de columnas de la vista");
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.privadas = this.publica.isFalse();
        this.ordinarias = this.especial.isFalse();
        this.personales = this.privadas.and(this.ordinarias);
        this.privadas.setLocalizedErrorMessage(ENGLISH, "the view is public");
        this.privadas.setLocalizedErrorMessage(SPANISH, "la vista es p\u00fablica");
        this.ordinarias.setLocalizedErrorMessage(ENGLISH, "the view is special");
        this.ordinarias.setLocalizedErrorMessage(SPANISH, "la vista es especial");
        this.personales.setLocalizedErrorMessage(ENGLISH, "the view is public or special");
        this.personales.setLocalizedErrorMessage(SPANISH, "la vista es p\u00fablica o especial");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.setUpdateFilter(this.personales);
        this.setDeleteFilter(this.personales);
        BooleanComparisonX formatoPersonalizado = this.formato.isEqualTo(this.formato.PERSONALIZADO);
        this.anchoPagina.setModifyingFilter(formatoPersonalizado);
        this.anchoPagina.setRequiringFilter(formatoPersonalizado);
        this.largoPagina.setModifyingFilter(formatoPersonalizado);
        this.largoPagina.setRequiringFilter(formatoPersonalizado);
        this.margenSuperior.setModifyingFilter(formatoPersonalizado);
        this.margenSuperior.setRequiringFilter(formatoPersonalizado);
        this.margenInferior.setModifyingFilter(formatoPersonalizado);
        this.margenInferior.setRequiringFilter(formatoPersonalizado);
        this.margenIzquierdo.setModifyingFilter(formatoPersonalizado);
        this.margenIzquierdo.setRequiringFilter(formatoPersonalizado);
        this.margenDerecho.setModifyingFilter(formatoPersonalizado);
        this.margenDerecho.setRequiringFilter(formatoPersonalizado);
        String english = "If " + this.b("format") + " is PERSONALIZADO";
        String spanish = "S\u00ed " + this.b("formato") + " es PERSONALIZADO";
        this.anchoPagina.setLocalizedRequiringFilterTag(ENGLISH, english);
        this.anchoPagina.setLocalizedRequiringFilterTag(SPANISH, spanish);
        this.largoPagina.setLocalizedRequiringFilterTag(ENGLISH, english);
        this.largoPagina.setLocalizedRequiringFilterTag(SPANISH, spanish);
        this.margenSuperior.setLocalizedRequiringFilterTag(ENGLISH, english);
        this.margenSuperior.setLocalizedRequiringFilterTag(SPANISH, spanish);
        this.margenInferior.setLocalizedRequiringFilterTag(ENGLISH, english);
        this.margenInferior.setLocalizedRequiringFilterTag(SPANISH, spanish);
        this.margenIzquierdo.setLocalizedRequiringFilterTag(ENGLISH, english);
        this.margenIzquierdo.setLocalizedRequiringFilterTag(SPANISH, spanish);
        this.margenDerecho.setLocalizedRequiringFilterTag(ENGLISH, english);
        this.margenDerecho.setLocalizedRequiringFilterTag(SPANISH, spanish);
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    public class Privatizar
    extends ProcessOperation {
        @InstanceReference
        protected VistaFuncion vista;
        protected Check check101;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "privatize");
            this.setLocalizedLabel(SPANISH, "privatizar");
            this.setLocalizedDescription(ENGLISH, "make a public view private");
            this.setLocalizedDescription(SPANISH, "convertir una vista p\u00fablica en privada");
            this.setLocalizedSuccessMessage(ENGLISH, "the view was successfully privatized");
            this.setLocalizedSuccessMessage(SPANISH, "la vista se privatiz\u00f3 con \u00e9xito");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.vista.publica.setCurrentValue(false);
            this.vista.propietario.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            this.vista.setLocalizedLabel(ENGLISH, "view");
            this.vista.setLocalizedLabel(SPANISH, "vista");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.vista.propietario.isNull().and(this.vista.publica.isTrue());
            this.check101.setLocalizedDescription(ENGLISH, "the view is not a private view");
            this.check101.setLocalizedDescription(SPANISH, "la vista no es una vista privada");
            this.check101.setLocalizedErrorMessage(ENGLISH, "the view is already private");
            this.check101.setLocalizedErrorMessage(SPANISH, "la vista ya es privada");
        }
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    public class Publicar
    extends ProcessOperation {
        @InstanceReference
        protected VistaFuncion vista;
        protected Check check101;
        protected Check check102;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "publish");
            this.setLocalizedLabel(SPANISH, "publicar");
            this.setLocalizedDescription(ENGLISH, "make a private view public");
            this.setLocalizedDescription(SPANISH, "convertir una vista privada en p\u00fablica");
            this.setLocalizedSuccessMessage(ENGLISH, "the view was successfully published");
            this.setLocalizedSuccessMessage(SPANISH, "la vista se public\u00f3 con \u00e9xito");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.vista.publica.setCurrentValue(true);
            this.vista.propietario.setCurrentValue(SpecialEntityValue.NULL);
            this.vista.setLocalizedLabel(ENGLISH, "view");
            this.vista.setLocalizedLabel(SPANISH, "vista");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.vista.publica.isFalse();
            this.check102 = this.vista.propietario.id.isEqualTo(CURRENT_USER_ID);
            this.check101.setLocalizedDescription(ENGLISH, "the view is not a public view");
            this.check101.setLocalizedDescription(SPANISH, "la vista no es una vista p\u00fablica");
            this.check101.setLocalizedErrorMessage(ENGLISH, "the view is already public");
            this.check101.setLocalizedErrorMessage(SPANISH, "la vista ya es p\u00fablica");
            this.check102.setLocalizedDescription(ENGLISH, "the view belongs to the current user");
            this.check102.setLocalizedDescription(SPANISH, "la vista le pertenece al usuario actual");
            this.check102.setLocalizedErrorMessage(ENGLISH, "it is not allowed to publish views that do not belong to you");
            this.check102.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido publicar vistas que no le pertenecen");
        }
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    public class EnviarCopia
    extends ProcessOperation {
        @InstanceReference
        protected VistaFuncion vista;
        @ParameterField(required=Kleenean.TRUE)
        @EntityReferenceConversionValidation(restrictedAccess=Kleenean.FALSE)
        protected Usuario destinatario;
        protected Check check101;
        protected Check check102;
        protected Check check201;
        protected Check check202;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "send a copy");
            this.setLocalizedLabel(SPANISH, "enviar copia");
            this.setLocalizedDescription(ENGLISH, "send a copy of the view to the specified recipient");
            this.setLocalizedDescription(SPANISH, "enviar una copia de la vista al destinatario especificado");
            this.setLocalizedSuccessMessage(ENGLISH, "a copy of the view was sent to the specified recipient");
            this.setLocalizedSuccessMessage(SPANISH, "se envi\u00f3 una copia de la vista al destinatario especificado");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.vista.setLocalizedLabel(ENGLISH, "view");
            this.vista.setLocalizedLabel(SPANISH, "vista");
            this.destinatario.setLocalizedLabel(ENGLISH, "recipient user");
            this.destinatario.setLocalizedLabel(SPANISH, "usuario destinatario");
            this.destinatario.setLocalizedShortLabel(ENGLISH, "recipient");
            this.destinatario.setLocalizedShortLabel(SPANISH, "destinatario");
            this.destinatario.setLocalizedShortDescription(ENGLISH, "view recipient");
            this.destinatario.setLocalizedShortDescription(SPANISH, "destinatario de la vista");
            this.destinatario.setLocalizedTooltip(ENGLISH, "user code of the view recipient");
            this.destinatario.setLocalizedTooltip(SPANISH, "c\u00f3digo de usuario del destinatario de la vista");
            this.destinatario.codigoUsuario.setLocalizedShortLabel(ENGLISH, "recipient code");
            this.destinatario.codigoUsuario.setLocalizedShortLabel(SPANISH, "destinatario");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.vista.publica.isFalse();
            this.check102 = this.vista.propietario.id.isEqualTo(CURRENT_USER_ID);
            this.check201 = this.destinatario.esUsuarioEspecial.isFalse();
            this.check202 = this.destinatario.id.isNotEqualTo(CURRENT_USER_ID);
            this.check101.setLocalizedDescription(ENGLISH, "the view is not a public view");
            this.check101.setLocalizedDescription(SPANISH, "la vista no es una vista p\u00fablica");
            this.check101.setLocalizedErrorMessage(ENGLISH, "it is not allowed to send copies of public views");
            this.check101.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido enviar copias de vistas p\u00fablicas");
            this.check102.setLocalizedDescription(ENGLISH, "the view belongs to the current user");
            this.check102.setLocalizedDescription(SPANISH, "la vista le pertenece al usuario actual");
            this.check102.setLocalizedErrorMessage(ENGLISH, "it is not allowed to send copies of views that do not belong to you");
            this.check102.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido enviar copias de vistas que no le pertenecen");
            this.check201.setLocalizedDescription(ENGLISH, "the recipient is not a special user");
            this.check201.setLocalizedDescription(SPANISH, "el destinatario no es un usuario especial");
            this.check201.setLocalizedErrorMessage(ENGLISH, "it is not allowed to send copies of views to special users");
            this.check201.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido enviar copias de vistas a usuarios especiales");
            this.check202.setLocalizedDescription(ENGLISH, "the recipient is not the current user");
            this.check202.setLocalizedDescription(SPANISH, "el destinatario no es el usuario actual");
            this.check202.setLocalizedErrorMessage(ENGLISH, "it is not allowed to send copies of views to yourself");
            this.check202.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido enviarse copias de vistas a uno mismo");
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            this.destinatario.setSearchQueryFilter(EnviarCopia.and(this.check201, this.check202));
        }
    }
}

