/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;

public class ColUtils {
    public static <T> Collection<T> filter(Collection<T> collection, Predicate predicate) {
        return collection == null || collection.isEmpty() || predicate == null ? collection : ColUtils._filter(collection, predicate);
    }

    public static <T> Collection<T> filter(Collection<T> collection, Predicate ... predicates) {
        return ColUtils.allFilter(collection, predicates);
    }

    public static <T> Collection<T> allFilter(Collection<T> collection, Predicate ... predicates) {
        return collection == null || collection.isEmpty() || predicates == null || predicates.length == 0 ? collection : ColUtils._filter(collection, PredicateUtils.allPredicate((Predicate[])predicates));
    }

    public static <T> Collection<T> anyFilter(Collection<T> collection, Predicate ... predicates) {
        return collection == null || collection.isEmpty() || predicates == null || predicates.length == 0 ? collection : ColUtils._filter(collection, PredicateUtils.anyPredicate((Predicate[])predicates));
    }

    public static <T> Collection<T> oneFilter(Collection<T> collection, Predicate ... predicates) {
        return collection == null || collection.isEmpty() || predicates == null || predicates.length == 0 ? collection : ColUtils._filter(collection, PredicateUtils.onePredicate((Predicate[])predicates));
    }

    public static <T> Collection<T> noneFilter(Collection<T> collection, Predicate ... predicates) {
        return collection == null || collection.isEmpty() || predicates == null || predicates.length == 0 ? collection : ColUtils._filter(collection, PredicateUtils.nonePredicate((Predicate[])predicates));
    }

    private static <T> List<T> _filter(Collection<T> collection, Predicate predicate) {
        ArrayList<T> list = new ArrayList<T>(collection);
        CollectionUtils.filter(list, (Predicate)predicate);
        return list;
    }

    public static <T extends Comparable<? super T>> Collection<T> sort(Collection<T> collection) {
        return collection == null || collection.isEmpty() ? collection : ColUtils._sort(collection, null);
    }

    public static <T> Collection<T> sort(Collection<T> collection, Comparator<T> comparator) {
        return collection == null || collection.isEmpty() || comparator == null ? collection : ColUtils._sort(collection, comparator);
    }

    public static <T> Collection<T> sort(Collection<T> collection, Comparator<T> ... comparators) {
        return collection == null || collection.isEmpty() || comparators == null || comparators.length == 0 ? collection : ColUtils._sort(collection, ComparatorUtils.chainedComparator((Comparator[])comparators));
    }

    private static <T> List<T> _sort(Collection<T> collection, Comparator<T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(comparator);
        return list;
    }

    public static <T> List<T> toList(Collection<T> collection) {
        return collection == null ? null : (collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection));
    }
}

