/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;

public class JavaUtils {
    private static final Logger logger = Logger.getLogger(JavaUtils.class);
    private static final String[] KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    public static String[] getJavaKeywordArray() {
        return KEYWORDS;
    }

    public static Set<String> getJavaKeywordSet() {
        return new TreeSet<String>(Arrays.asList(KEYWORDS));
    }

    public static Set<String> getCanonicalNames(Collection<Class<?>> types) {
        TreeSet<String> names = new TreeSet<String>();
        for (Class<?> type : types) {
            names.add(type.getCanonicalName());
        }
        return names;
    }

    public static <T extends Enum<T>> T getEnumOfEquals(String name, T ... values) {
        if (name != null && values != null) {
            for (T t : values) {
                if (!name.equals(((Enum)t).name())) continue;
                return t;
            }
        }
        return null;
    }

    public static <T extends Enum<T>> T getEnumOfEqualsIgnoreCase(String name, T ... values) {
        if (name != null && values != null) {
            for (T t : values) {
                if (!name.equalsIgnoreCase(((Enum)t).name())) continue;
                return t;
            }
        }
        return null;
    }

    public static Boolean getStaticBooleanValue(Object object, String fieldName) {
        Boolean value;
        if (object == null || fieldName == null) {
            return null;
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        try {
            Field field = clazz.getField(fieldName);
            Class<?> fieldType = field.getType();
            value = fieldType == Boolean.TYPE ? Boolean.valueOf(field.getBoolean(null)) : (fieldType == Boolean.class ? field.get(null) : null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            value = null;
        }
        return value;
    }

    public static String getStaticStringValue(Object object, String fieldName) {
        Object value;
        if (object == null || fieldName == null) {
            return null;
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        try {
            Field field = clazz.getField(fieldName);
            Class<?> fieldType = field.getType();
            value = fieldType == String.class ? field.get(null) : null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            value = null;
        }
        return (String)value;
    }

    public static Set<Class<?>> getTypes(String prefix, Class<? extends Annotation> annotation) {
        logger.trace((Object)("getTypes(" + prefix + ", " + annotation + ")"));
        Reflections reflections = new Reflections(prefix, new Scanner[]{Scanners.TypesAnnotated});
        return reflections.getTypesAnnotatedWith(annotation).stream().collect(Collectors.toSet());
    }

    public static Set<Class<?>> getSubTypes(String prefix, Class<?> type) {
        logger.trace((Object)("getSubTypes(" + prefix + ", " + type + ")"));
        Reflections reflections = new Reflections(prefix, new Scanner[]{Scanners.SubTypes.filterResultsBy(s -> true)});
        return reflections.getSubTypesOf(type).stream().collect(Collectors.toSet());
    }

    public static Set<Method> getVoidMethods(String prefix) {
        logger.trace((Object)("getVoidMethods(" + prefix + ")"));
        Reflections reflections = new Reflections(prefix, new Scanner[]{Scanners.MethodsReturn});
        return reflections.getMethodsReturn(Void.TYPE).stream().collect(Collectors.toSet());
    }
}

