/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.Project;
import adalid.core.TLC;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Property;
import adalid.core.sql.QueryTable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

class EntityData {
    private static final Logger logger = Logger.getLogger(EntityData.class);
    private final String name;
    private int instances;
    private int referencesCount;
    private int referredByCount;
    private int queries;
    private int maxColumnCount;
    private int minColumnCount;
    private int sumColumnCount;

    static void log(Map<String, EntityData> entities) {
        if (entities != null && !entities.isEmpty()) {
            EntityData.updateReferenceFields(entities);
            String hyphens = EntityData.hyphens();
            logger.info((Object)hyphens);
            logger.info((Object)EntityData.labels1());
            logger.info((Object)hyphens);
            int i = 0;
            int q = 0;
            int s = 0;
            for (String name : entities.keySet()) {
                EntityData ed = entities.get(name);
                i += ed.instances;
                q += ed.queries;
                s += ed.sumColumnCount;
                logger.info((Object)ed);
            }
            logger.info((Object)hyphens);
            logger.info((Object)(StringUtils.repeat((String)" ", (int)100) + StringUtils.repeat((String)" ", (int)20) + String.format("%10d", i) + String.format("%10d", q) + StringUtils.repeat((String)" ", (int)20) + String.format("%10d", s)));
            logger.info((Object)hyphens);
        }
    }

    static void log(List<String> allocations) {
        if (allocations != null && !allocations.isEmpty()) {
            String hyphens = EntityData.hyphens();
            logger.info((Object)hyphens);
            logger.info((Object)EntityData.labels2());
            logger.info((Object)hyphens);
            for (String allocation : allocations) {
                logger.info((Object)allocation);
            }
            logger.info((Object)hyphens);
        }
    }

    static String log(String name, int depth, int round, int maxDepth, int maxRound) {
        return StringUtils.rightPad((String)name, (int)100) + StringUtils.leftPad((String)(depth + "/" + maxDepth), (int)10) + StringUtils.leftPad((String)(round + "/" + maxRound), (int)10);
    }

    private static void updateReferenceFields(Map<String, EntityData> entities) {
        Project project = TLC.getProject();
        if (project != null) {
            for (String name : entities.keySet()) {
                Entity entity;
                String simpleName = StringUtils.substringAfterLast((String)name, (String)".");
                if (simpleName.isEmpty() || (entity = project.getEntity(simpleName)) == null) continue;
                EntityData ed = entities.get(name);
                ed.referencesCount = entity.getReferencePropertiesCount();
                List<Property> references = entity.getReferencesList();
                if (references == null || references.isEmpty()) continue;
                ed.referredByCount = references.size();
            }
        }
    }

    private static String labels1() {
        return StringUtils.rightPad((String)"CLASS", (int)100) + StringUtils.leftPad((String)"REFERS", (int)10) + StringUtils.leftPad((String)"REFERRED", (int)10) + StringUtils.leftPad((String)"OBJECTS", (int)10) + StringUtils.leftPad((String)"QUERIES", (int)10) + StringUtils.leftPad((String)"MINCOLS", (int)10) + StringUtils.leftPad((String)"MAXCOLS", (int)10) + StringUtils.leftPad((String)"SUMCOLS", (int)10);
    }

    private static String labels2() {
        return StringUtils.rightPad((String)"CLASS", (int)100) + StringUtils.leftPad((String)"DEPTH", (int)10) + StringUtils.leftPad((String)"ROUND", (int)10);
    }

    private static String hyphens() {
        return StringUtils.repeat((String)"-", (int)100) + StringUtils.repeat((String)(" " + StringUtils.repeat((String)"-", (int)9)), (int)7);
    }

    EntityData(Entity entity) {
        this.name = entity.getClass().getName();
        this.init(entity);
    }

    EntityData(QueryTable queryTable) {
        this.name = queryTable.getEntity().getClass().getName();
        this.init(queryTable);
    }

    private void init(Entity entity) {
        assert (entity != null);
        this.instances = 1;
    }

    private void init(QueryTable queryTable) {
        int columnCount = queryTable.getSelectColumnCount();
        this.queries = 1;
        this.maxColumnCount = columnCount;
        this.minColumnCount = columnCount;
        this.sumColumnCount = columnCount;
    }

    void add(Entity entity) {
        ++this.instances;
    }

    void add(QueryTable queryTable) {
        int columnCount = queryTable.getSelectColumnCount();
        ++this.queries;
        if (columnCount > this.maxColumnCount) {
            this.maxColumnCount = columnCount;
        }
        if (columnCount < this.minColumnCount) {
            this.minColumnCount = columnCount;
        } else if (this.minColumnCount == 0) {
            this.minColumnCount = columnCount;
        }
        this.sumColumnCount += columnCount;
    }

    public String toString() {
        return StringUtils.rightPad((String)this.name, (int)100) + String.format("%10d", this.referencesCount) + String.format("%10d", this.referredByCount) + String.format("%10d", this.instances) + String.format("%10d", this.queries) + String.format("%10d", this.minColumnCount) + String.format("%10d", this.maxColumnCount) + String.format("%10d", this.sumColumnCount);
    }
}

