/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.programmers;

import adalid.commons.util.BitUtils;
import adalid.commons.util.IntUtils;
import adalid.commons.util.StrUtils;
import adalid.commons.util.TimeUtils;
import adalid.core.Primitive;
import adalid.core.Project;
import adalid.core.TLC;
import adalid.core.TemporalAddend;
import adalid.core.data.types.BigDecimalData;
import adalid.core.data.types.BigIntegerData;
import adalid.core.data.types.BinaryData;
import adalid.core.data.types.BooleanData;
import adalid.core.data.types.ByteData;
import adalid.core.data.types.CharacterData;
import adalid.core.data.types.DateData;
import adalid.core.data.types.DoubleData;
import adalid.core.data.types.FloatData;
import adalid.core.data.types.IntegerData;
import adalid.core.data.types.LongData;
import adalid.core.data.types.ShortData;
import adalid.core.data.types.StringData;
import adalid.core.data.types.TimeData;
import adalid.core.data.types.TimestampData;
import adalid.core.enums.ComparisonOp;
import adalid.core.enums.DataAggregateOp;
import adalid.core.enums.NaryVectorOp;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OrderedPairOp;
import adalid.core.enums.ScalarOp;
import adalid.core.enums.SqlQualifierType;
import adalid.core.expressions.XB;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CalculableProperty;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.DataAggregateX;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NaryVectorX;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Operator;
import adalid.core.interfaces.OrderedPairX;
import adalid.core.interfaces.PersistentEntityReference;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.ScalarX;
import adalid.core.interfaces.TemporalExpression;
import adalid.core.primitives.BooleanPrimitive;
import adalid.core.programmers.AbstractSqlProgrammer;
import adalid.core.programmers.ParameterizedExpression;
import adalid.core.properties.IntegerProperty;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OracleProgrammer
extends AbstractSqlProgrammer {
    private static final Logger logger = Logger.getLogger(OracleProgrammer.class);
    private static final String ORACLE_VERSION = "oracle.version";
    private final String[] NEVER_NULL = new String[]{"current_user", "current_user_code()", "current_user_id()", "current_date", "current_time", "current_timestamp", "localtimestamp"};
    protected static final boolean AVOID_LONG_IDENTIFIERS = BitUtils.valueOf(bootstrapping.getString("oracle.database.avoid.long.identifiers", "false"));
    protected static final boolean NATIONAL_CHARACTER_SET = BitUtils.valueOf(bootstrapping.getString("oracle.database.national.character.set", "false"));
    protected static final boolean EXTENDED_MAX_STRING_SIZE = BitUtils.valueOf(bootstrapping.getString("oracle.database.extended.max.string.size", "false"));
    protected static final int MAX_DECIMAL_DIGITS = 38;
    protected static final int MAX_UNICODE_LENGTH = EXTENDED_MAX_STRING_SIZE ? 16383 : 2000;
    protected static final int MAX_NON_UNI_LENGTH = EXTENDED_MAX_STRING_SIZE ? Short.MAX_VALUE : 4000;
    protected static final int MAX_VARCHAR_LENGTH = NATIONAL_CHARACTER_SET ? MAX_UNICODE_LENGTH : MAX_NON_UNI_LENGTH;
    private int maxIdentifierLength;
    protected static final String BINARY = "blob";
    protected static final String BOOLEANX = "varchar2";
    protected static final String BOOLEAN = "varchar2(5)";
    protected static final String CHARX = NATIONAL_CHARACTER_SET ? "nchar" : "char";
    protected static final String CHAR = CHARX + "(1)";
    protected static final String VARCHARX = NATIONAL_CHARACTER_SET ? "nvarchar2" : "varchar2";
    protected static final String VARCHAR = VARCHARX + "({0})";
    protected static final String TEXT = VARCHARX + "(" + MAX_VARCHAR_LENGTH + ")";
    protected static final String CLOB = NATIONAL_CHARACTER_SET ? "nclob" : "clob";
    protected static final String BYTE = "number(3)";
    protected static final String SMALLINT = "number(5)";
    protected static final String INTEGER = "number(10)";
    protected static final String LONG = "number(19)";
    protected static final String FLOAT = "number";
    protected static final String DOUBLE = "number";
    protected static final String BIGINT = "number({0})";
    protected static final String DECIMAL = "number({0},{1})";
    protected static final String NUMERIC = "number";
    protected static final String DATE = "date";
    protected static final String TIMEX = "timestamp";
    protected static final String TIME = "timestamp({0})";
    protected static final String TIMESTAMPX = "timestamp";
    protected static final String TIMESTAMP = "timestamp({0})";
    protected static final String RECORD = "record";
    protected static final String VOID = "void";
    private static final String YM_INTERVAL_ADDEND_PATTERN = "{0} {1} TO_YMINTERVAL(''{2}-{3}'')";
    private static final String DS_INTERVAL_ADDEND_PATTERN = "{0} {1} TO_DSINTERVAL(''{2} {3}:{4}:{5}'')";

    @Override
    public String getDBMS() {
        return "Oracle";
    }

    @Override
    protected String[] neverNull() {
        return this.NEVER_NULL;
    }

    @Override
    protected boolean validExpressionOperator(ComparisonOp operator) {
        switch (operator) {
            case IS_NULL: 
            case IS_NOT_NULL: 
            case IS_NULL_OR_TRUE: 
            case IS_NULL_OR_FALSE: 
            case IS_NULL_OR_EQ: 
            case IS_NULL_OR_NEQ: 
            case IS_NULL_OR_GT: 
            case IS_NULL_OR_LTEQ: 
            case IS_NULL_OR_GTEQ: 
            case IS_NULL_OR_LT: 
            case IS_NULL_OR_STARTS_WITH: 
            case IS_NULL_OR_NOT_STARTS_WITH: 
            case IS_NULL_OR_CONTAINS: 
            case IS_NULL_OR_NOT_CONTAINS: 
            case IS_NULL_OR_ENDS_WITH: 
            case IS_NULL_OR_NOT_ENDS_WITH: 
            case IS_NULL_OR_IN: 
            case IS_NULL_OR_NOT_IN: 
            case IS_NULL_OR_BETWEEN: 
            case IS_NULL_OR_NOT_BETWEEN: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected String primitiveIsTruePattern() {
        return "{0} = 'true'";
    }

    @Override
    protected String primitiveIsFalsePattern() {
        return "{0} = 'false'";
    }

    @Override
    protected String getRestricted() {
        return null;
    }

    @Override
    protected String getCascade() {
        return "cascade";
    }

    @Override
    protected String getNullify() {
        return "set null";
    }

    @Override
    protected String getNoAction() {
        return null;
    }

    @Override
    protected String getTrue() {
        return "'true'";
    }

    @Override
    protected String getFalse() {
        return "'false'";
    }

    @Override
    protected String getCurrentDate() {
        return "current_date";
    }

    @Override
    protected String getCurrentTime() {
        return "localtimestamp";
    }

    @Override
    protected String getCurrentTimestamp() {
        return "localtimestamp";
    }

    @Override
    public int getMaxIdentifierLength() {
        if (this.maxIdentifierLength == 0) {
            if (AVOID_LONG_IDENTIFIERS) {
                this.maxIdentifierLength = 30;
            } else {
                Object version;
                Project project = TLC.getProject();
                if (project != null && StringUtils.isNotBlank((String)(version = project.getEnvironmentVariable(ORACLE_VERSION)))) {
                    version = this.dottedVersionNumber((String)version);
                    int major = IntUtils.valueOf(StringUtils.substringBefore((String)(version = (String)version + ".0.0"), (String)"."), (Integer)0);
                    if (major > 0) {
                        int minor = IntUtils.valueOf(StringUtils.substringBetween((String)version, (String)"."), (Integer)0);
                        this.maxIdentifierLength = major < 12 || major == 12 && minor < 2 ? 30 : 128;
                        logger.info((Object)("oracle.version.max.identifier.length=" + this.maxIdentifierLength));
                        return this.maxIdentifierLength;
                    }
                }
                return 30;
            }
        }
        return this.maxIdentifierLength;
    }

    private String dottedVersionNumber(String version) {
        String v1 = version.trim().toLowerCase();
        logger.info((Object)("oracle.version=" + v1));
        String v2 = StrUtils.getOracleVersionNumber(v1);
        if (v1.equals(v2)) {
            return v1;
        }
        logger.info((Object)("oracle.version=" + v2));
        return v2;
    }

    @Override
    public int getMaxVarcharLength() {
        return MAX_VARCHAR_LENGTH;
    }

    @Override
    protected String getVariablesPrefix() {
        return "x$";
    }

    @Override
    protected String getVariablesSuffix() {
        return "";
    }

    @Override
    public String getString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Time) {
            return TimeUtils.jdbcTimestampString(obj);
        }
        return super.getString(obj);
    }

    @Override
    public String getDelimitedString(Object obj) {
        String string = this.getString(obj);
        if (string == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? this.getTrue() : this.getFalse();
        }
        if (obj instanceof String) {
            return "'" + string + "'";
        }
        if (obj instanceof Date) {
            return "date'" + string + "'";
        }
        if (obj instanceof Time) {
            return "timestamp'" + string + "'";
        }
        if (obj instanceof java.util.Date) {
            return "timestamp'" + string + "'";
        }
        return super.getDelimitedString(obj);
    }

    @Override
    public String getDelimitedString(TemporalAddend addend) {
        String base;
        if (addend == null || addend.isBadValue()) {
            return null;
        }
        int anys = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int quantity = addend.getQuantity();
        int absolute = Math.abs(quantity);
        char sign = quantity < 0 ? (char)'-' : '+';
        char unit = addend.getUnitCode();
        boolean b = false;
        switch (unit) {
            case 'A': 
            case 'Y': {
                base = "CURRENT_DATE";
                anys = absolute;
                b = true;
                break;
            }
            case 'M': {
                base = "CURRENT_DATE";
                anys = absolute / 12;
                months = absolute % 12;
                b = true;
                break;
            }
            case 'D': {
                base = "CURRENT_DATE";
                days = absolute;
                break;
            }
            case 'h': {
                base = "LOCALTIMESTAMP";
                days = absolute / 24;
                hours = absolute % 24;
                break;
            }
            case 'm': {
                base = "LOCALTIMESTAMP";
                days = absolute / 1440;
                int remainder = absolute % 1440;
                hours = remainder / 60;
                minutes = remainder % 60;
                break;
            }
            case 's': {
                base = "LOCALTIMESTAMP";
                days = absolute / 86400;
                int remainder = absolute % 86400;
                hours = remainder / 3600;
                minutes = (remainder %= 3600) / 60;
                seconds = remainder % 60;
                break;
            }
            default: {
                return null;
            }
        }
        String string = absolute == 0 ? base : (b ? MessageFormat.format(YM_INTERVAL_ADDEND_PATTERN, base, Character.valueOf(sign), "" + anys, months) : MessageFormat.format(DS_INTERVAL_ADDEND_PATTERN, base, Character.valueOf(sign), "" + days, hours, minutes, seconds));
        return absolute == 0 ? string : StrUtils.encloseSqlExpression(string);
    }

    @Override
    public String getSqlParameterType(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        if (artifact instanceof BinaryData) {
            return BINARY;
        }
        if (artifact instanceof BooleanData) {
            return BOOLEANX;
        }
        if (artifact instanceof CharacterData) {
            return CHARX;
        }
        if (artifact instanceof StringData) {
            return VARCHARX;
        }
        if (artifact instanceof ByteData) {
            return "number";
        }
        if (artifact instanceof ShortData) {
            return "number";
        }
        if (artifact instanceof IntegerData) {
            return "number";
        }
        if (artifact instanceof LongData) {
            return "number";
        }
        if (artifact instanceof FloatData) {
            return "number";
        }
        if (artifact instanceof DoubleData) {
            return "number";
        }
        if (artifact instanceof BigIntegerData) {
            return "number";
        }
        if (artifact instanceof BigDecimalData) {
            return "number";
        }
        if (artifact instanceof DateData) {
            return DATE;
        }
        if (artifact instanceof TimeData) {
            return "timestamp";
        }
        if (artifact instanceof TimestampData) {
            return "timestamp";
        }
        if (artifact instanceof Entity) {
            return "number";
        }
        return null;
    }

    @Override
    public String getSqlType(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        if (artifact instanceof BinaryData) {
            return BINARY;
        }
        if (artifact instanceof BooleanData) {
            return BOOLEAN;
        }
        if (artifact instanceof CharacterData) {
            return CHAR;
        }
        if (artifact instanceof StringData) {
            StringData data = (StringData)artifact;
            int l = IntUtils.valueOf(data.getMaxLength());
            return l < 1 || l > MAX_VARCHAR_LENGTH ? CLOB : OracleProgrammer.format(VARCHAR, l);
        }
        if (artifact instanceof ByteData) {
            return BYTE;
        }
        if (artifact instanceof ShortData) {
            return SMALLINT;
        }
        if (artifact instanceof IntegerData) {
            return INTEGER;
        }
        if (artifact instanceof LongData) {
            return LONG;
        }
        if (artifact instanceof FloatData) {
            return "number";
        }
        if (artifact instanceof DoubleData) {
            return "number";
        }
        if (artifact instanceof BigIntegerData) {
            BigIntegerData data = (BigIntegerData)artifact;
            int p = data.getPrecision();
            return OracleProgrammer.format(BIGINT, p > 38 ? 38 : p);
        }
        if (artifact instanceof BigDecimalData) {
            BigDecimalData data = (BigDecimalData)artifact;
            int p = data.getPrecision();
            int s = data.getScale();
            if (p > 38) {
                p = 38;
                if (s > 38) {
                    s = 38;
                }
            }
            return OracleProgrammer.format(DECIMAL, p, s);
        }
        if (artifact instanceof DateData) {
            return DATE;
        }
        if (artifact instanceof TimeData) {
            TimeData data = (TimeData)artifact;
            int p = IntUtils.valueOf(data.getPrecision(), 3);
            return OracleProgrammer.format("timestamp({0})", p);
        }
        if (artifact instanceof TimestampData) {
            TimestampData data = (TimestampData)artifact;
            int p = IntUtils.valueOf(data.getPrecision(), 3);
            return OracleProgrammer.format("timestamp({0})", p);
        }
        if (artifact instanceof Expression) {
            return this.getExpressionType((Expression)artifact);
        }
        if (artifact instanceof Entity) {
            return this.getEntityReferenceType((Entity)artifact);
        }
        return null;
    }

    protected String getExpressionType(Expression expression) {
        Class<?> clazz = expression.getDataType();
        if (clazz == null) {
            return VOID;
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return BINARY;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return BOOLEAN;
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return CHAR;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return TEXT;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return BYTE;
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return SMALLINT;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return INTEGER;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return LONG;
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return "number";
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return "number";
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return "number";
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return "number";
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DATE;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return OracleProgrammer.format("timestamp({0})", 3);
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return OracleProgrammer.format("timestamp({0})", 3);
        }
        if (expression instanceof BooleanExpression) {
            return BOOLEAN;
        }
        if (expression instanceof CharacterExpression) {
            return TEXT;
        }
        if (expression instanceof NumericExpression) {
            return "number";
        }
        if (expression instanceof TemporalExpression) {
            return OracleProgrammer.format("timestamp({0})", 3);
        }
        return TEXT;
    }

    protected String getEntityReferenceType(Entity entity) {
        return entity.getPrimaryKeyProperty() instanceof IntegerProperty ? INTEGER : LONG;
    }

    @Override
    public String getSqlOnDeleteAction(PersistentEntityReference entity) {
        if (entity == null) {
            return null;
        }
        OnDeleteAction onDeleteAction = entity.getOnDeleteAction();
        if (onDeleteAction == null) {
            return null;
        }
        switch (onDeleteAction) {
            case CASCADE: {
                return this.getCascade();
            }
            case NULLIFY: {
                return this.getNullify();
            }
        }
        return null;
    }

    @Override
    public String getSqlOnUpdateAction(PersistentEntityReference entity) {
        if (entity == null) {
            return null;
        }
        OnUpdateAction onUpdateAction = entity.getOnUpdateAction();
        if (onUpdateAction == null) {
            return null;
        }
        switch (onUpdateAction) {
            case CASCADE: {
                return this.getCascade();
            }
            case NULLIFY: {
                return this.getNullify();
            }
        }
        return null;
    }

    @Override
    protected String getSqlDataAggregateExpression(DataAggregateX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        String string;
        DataAggregateOp operator = expression.getOperator();
        Object[] operands = expression.getOperands();
        if (operator == null || operands == null || operands.length < 2) {
            return null;
        }
        String[] arguments = new String[operands.length];
        String[] booleanArguments = new String[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            arguments[i] = this.getSqlExpression(operands[i], queryObject, qualifier, px, false);
            Object bcxi = operands[i] instanceof BooleanPrimitive ? XB.Boolean.Comparison.isTrue((BooleanPrimitive)operands[i]) : operands[i];
            booleanArguments[i] = this.getSqlExpression(bcxi, queryObject, qualifier, px, true);
        }
        switch (operator) {
            case COALESCE: {
                string = this.call("coalesce", arguments);
                break;
            }
            case MAXIMUM: {
                string = this.call("greatest", arguments);
                break;
            }
            case MINIMUM: {
                string = this.call("least", arguments);
                break;
            }
            case AND: {
                string = this.and(booleanArguments);
                break;
            }
            case NAND: {
                string = this.not(this.and(booleanArguments));
                break;
            }
            case OR: {
                string = this.or(booleanArguments);
                break;
            }
            case NOR: {
                string = this.not(this.or(booleanArguments));
                break;
            }
            case NAXOR: {
                string = this.xor(booleanArguments);
                break;
            }
            case NAXNOR: {
                string = this.not(this.xor(booleanArguments));
                break;
            }
            case NOR_OR_NAXOR: {
                string = this.or(this.not(this.or(booleanArguments)), this.xor(booleanArguments));
                break;
            }
            default: {
                string = super.getSqlDataAggregateExpression(expression, queryObject, qualifier, px);
            }
        }
        return string;
    }

    @Override
    protected String getSqlNaryVectorExpression(NaryVectorX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        String pattern;
        int length;
        NaryVectorOp operator = expression.getOperator();
        Object[] operands = expression.getOperands();
        int n = length = operands == null ? 0 : operands.length;
        if (operator == null || length == 0) {
            return null;
        }
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            strings[i] = this.getSqlExpression(operands[i], queryObject, qualifier, px, true);
        }
        Object[] arguments = new Object[length];
        for (int i = 0; i < length; ++i) {
            arguments[i] = StrUtils.discloseSqlExpression(strings[i]);
        }
        switch (operator) {
            case SUBSTR: {
                pattern = length > 1 ? this.call((Operator)operator, length) : "null";
                break;
            }
            default: {
                pattern = this.call((Operator)operator, length);
            }
        }
        return OracleProgrammer.format(pattern, arguments);
    }

    @Override
    protected String getSqlOrderedPairExpression(OrderedPairX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        String pattern;
        OrderedPairOp operator = expression.getOperator();
        Object x = expression.getX();
        Object y = expression.getY();
        if (operator == null || x == null || y == null) {
            return null;
        }
        String arg1 = this.getSqlExpression(x, queryObject, qualifier, px, true);
        String arg2 = this.getSqlExpression(y, queryObject, qualifier, px, true);
        Object bcx1 = x instanceof BooleanPrimitive ? XB.Boolean.Comparison.isTrue((BooleanPrimitive)x) : x;
        Object bcx2 = y instanceof BooleanPrimitive ? XB.Boolean.Comparison.isTrue((BooleanPrimitive)y) : y;
        String boo1 = this.getSqlExpression(bcx1, queryObject, qualifier, px, true);
        String boo2 = this.getSqlExpression(bcx2, queryObject, qualifier, px, true);
        switch (operator) {
            case COALESCE: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "coalesce({0}, {1})";
                break;
            }
            case NULLIF: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "nullif({0}, {1})";
                break;
            }
            case MAXIMUM: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "greatest({0}, {1})";
                break;
            }
            case MINIMUM: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "least({0}, {1})";
                break;
            }
            case AND: {
                arg1 = boo1;
                arg2 = boo2;
                pattern = "{0} and {1}";
                break;
            }
            case NAND: {
                arg1 = boo1;
                arg2 = boo2;
                pattern = "not({0} and {1})";
                break;
            }
            case OR: {
                arg1 = boo1;
                arg2 = boo2;
                pattern = "{0} or {1}";
                break;
            }
            case NOR: {
                arg1 = boo1;
                arg2 = boo2;
                pattern = "not({0} or {1})";
                break;
            }
            case XOR: {
                arg1 = boo1;
                arg2 = boo2;
                pattern = "not({0} and {1}) and ({0} or {1})";
                break;
            }
            case XNOR: {
                arg1 = boo1;
                arg2 = boo2;
                pattern = "not({0} or {1}) or ({0} and {1})";
                break;
            }
            case X_IMPLIES_Y: {
                arg1 = boo1;
                arg2 = boo2;
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "not({0}) or {1}";
                break;
            }
            case ASCII: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_ascii_string_2({0}, {1})";
                break;
            }
            case DIACRITICLESS_ASCII: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_diacriticless_ascii_2({0}, {1})";
                break;
            }
            case CONCAT: {
                pattern = "{0} || {1}";
                break;
            }
            case FORMAT: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_string_format({0}, {1})";
                break;
            }
            case LEFT: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "substr({0}, 1, {1})";
                break;
            }
            case RIGHT: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "substr({0}, 0-({1}))";
                break;
            }
            case SUBSTR: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "substr({0}, {1})";
                break;
            }
            case TO_ZERO_PADDED_STRING: {
                pattern = this.toZeroPaddedStringPattern(x, y);
                break;
            }
            case X_PLUS_Y: {
                pattern = "{0} + {1}";
                break;
            }
            case X_MINUS_Y: {
                pattern = "{0} - {1}";
                break;
            }
            case X_MULTIPLIED_BY_Y: {
                pattern = "{0} * {1}";
                break;
            }
            case X_DIVIDED_INTO_Y: {
                pattern = "{0} / {1}";
                break;
            }
            case X_RAISED_TO_THE_Y: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "power({0}, {1})";
                break;
            }
            case ADD_YEARS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_dateadd({0}, {1}, 'years')";
                break;
            }
            case ADD_MONTHS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_dateadd({0}, {1}, 'months')";
                break;
            }
            case ADD_WEEKS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_dateadd({0}, {1}, 'weeks')";
                break;
            }
            case ADD_DAYS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_dateadd({0}, {1}, 'days')";
                break;
            }
            case ADD_HOURS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_dateadd({0}, {1}, 'hours')";
                break;
            }
            case ADD_MINUTES: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_dateadd({0}, {1}, 'minutes')";
                break;
            }
            case ADD_SECONDS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_dateadd({0}, {1}, 'seconds')";
                break;
            }
            case DIFF_IN_YEARS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_datediff({0}, {1}, 'years')";
                break;
            }
            case DIFF_IN_MONTHS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_datediff({0}, {1}, 'months')";
                break;
            }
            case DIFF_IN_WEEKS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_datediff({0}, {1}, 'weeks')";
                break;
            }
            case DIFF_IN_DAYS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_datediff({0}, {1}, 'days')";
                break;
            }
            case DIFF_IN_HOURS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_datediff({0}, {1}, 'hours')";
                break;
            }
            case DIFF_IN_MINUTES: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_datediff({0}, {1}, 'minutes')";
                break;
            }
            case DIFF_IN_SECONDS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "util_datediff({0}, {1}, 'seconds')";
                break;
            }
            default: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = this.call((Operator)operator, 2);
            }
        }
        return OracleProgrammer.format(pattern, arg1, arg2);
    }

    @Override
    protected String getSqlScalarExpression(ScalarX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        Object pattern;
        ScalarOp operator = expression.getOperator();
        Object operand = expression.getOperand();
        if (operand == null) {
            return null;
        }
        String arg1 = this.getSqlExpression(operand, queryObject, qualifier, px, false);
        String arg2 = this.getSqlExpressionDefaultValue(expression);
        if (operator == null || operator.equals(ScalarOp.SELF)) {
            return arg1;
        }
        boolean varchar = operand instanceof String || operand instanceof CharacterExpression;
        switch (operator) {
            case DEFAULT_WHEN_NULL: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "coalesce({0}, {1})";
                break;
            }
            case NULL_WHEN_DEFAULT: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                pattern = "nullif({0}, {1})";
                break;
            }
            case TO_BOOLEAN: {
                pattern = "cast({0} as varchar2(5))";
                break;
            }
            case TO_CHARACTER: {
                pattern = "cast({0} as " + CHAR + ")";
                break;
            }
            case TO_STRING: 
            case TO_LOCALE_STRING: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = this.toCharStringPattern(operand);
                break;
            }
            case TO_BYTE: {
                pattern = "cast({0} as number(5))";
                break;
            }
            case TO_SHORT: {
                pattern = "cast({0} as number(5))";
                break;
            }
            case TO_INTEGER: {
                pattern = "cast({0} as number(10))";
                break;
            }
            case TO_LONG: {
                pattern = "cast({0} as number(19))";
                break;
            }
            case TO_FLOAT: {
                pattern = "cast({0} as number)";
                break;
            }
            case TO_DOUBLE: {
                pattern = "cast({0} as number)";
                break;
            }
            case TO_BIG_INTEGER: {
                pattern = "cast({0} as number)";
                break;
            }
            case TO_BIG_DECIMAL: {
                pattern = "cast({0} as number)";
                break;
            }
            case TO_DATE: {
                if (varchar) {
                    arg1 = StrUtils.discloseSqlExpression(arg1);
                }
                pattern = this.getCurrentDate().equals(arg1) ? arg1 : (varchar ? "util_cast_varchar_as_date({0})" : "cast({0} as date)");
                break;
            }
            case TO_TIME: {
                if (varchar) {
                    arg1 = StrUtils.discloseSqlExpression(arg1);
                }
                pattern = this.getCurrentTime().equals(arg1) ? arg1 : (varchar ? "util_cast_varchar_as_time({0})" : "cast({0} as timestamp)");
                break;
            }
            case TO_TIMESTAMP: {
                if (varchar) {
                    arg1 = StrUtils.discloseSqlExpression(arg1);
                }
                pattern = this.getCurrentTimestamp().equals(arg1) ? arg1 : (varchar ? "util_cast_varchar_as_timestamp({0})" : "cast({0} as timestamp)");
                break;
            }
            case NOT: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                String is_true = operand instanceof Primitive ? this.primitiveIsTruePattern() : this.expressionIsTruePattern();
                pattern = "not(" + is_true + ")";
                break;
            }
            case ASCII: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "util_ascii_string_1({0})";
                break;
            }
            case DIACRITICLESS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "util_diacriticless({0})";
                break;
            }
            case DIACRITICLESS_ASCII: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "util_diacriticless_ascii_1({0})";
                break;
            }
            case LOWER: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "lower({0})";
                break;
            }
            case UPPER: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "upper({0})";
                break;
            }
            case CAPITALIZE: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "initcap({0})";
                break;
            }
            case UNCAPITALIZE: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "uncap({0})";
                break;
            }
            case TRIM: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "trim({0})";
                break;
            }
            case LTRIM: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "ltrim({0})";
                break;
            }
            case RTRIM: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "rtrim({0})";
                break;
            }
            case MODULUS: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "abs({0})";
                break;
            }
            case OPPOSITE: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "-({0})";
                break;
            }
            case RECIPROCAL: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "1/({0})";
                break;
            }
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "extract(" + operator.name().toLowerCase() + " from {0})";
                break;
            }
            case FIRST_DATE_OF_MONTH: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "util_first_date_of_month({0})";
                break;
            }
            case FIRST_DATE_OF_QUARTER: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "util_first_date_of_quarter({0})";
                break;
            }
            case FIRST_DATE_OF_SEMESTER: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "util_first_date_of_semester({0})";
                break;
            }
            case FIRST_DATE_OF_YEAR: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "util_first_date_of_year({0})";
                break;
            }
            case LAST_DATE_OF_MONTH: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "util_last_date_of_month({0})";
                break;
            }
            case LAST_DATE_OF_QUARTER: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "util_last_date_of_quarter({0})";
                break;
            }
            case LAST_DATE_OF_SEMESTER: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "util_last_date_of_semester({0})";
                break;
            }
            case LAST_DATE_OF_YEAR: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = "util_last_date_of_year({0})";
                break;
            }
            default: {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                pattern = this.call((Operator)operator, 1);
            }
        }
        return OracleProgrammer.format((String)pattern, arg1, arg2);
    }

    @Override
    protected String getSqlExpressionDefaultValue(Expression expression) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = expression == null ? null : expression.getDataType();
        if (clazz == null) {
            return this.getNull();
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DATE + this.getZeroDate();
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return "time" + this.getZeroTime();
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return "timestamp" + this.getZeroTimestamp();
        }
        return super.getSqlExpressionDefaultValue(expression);
    }

    @Override
    protected String fixCalculableColumnValueExpression(String expression, Property property) {
        Object calculableValue;
        if (expression != null && !expression.equals(this.getNull()) && property instanceof CalculableProperty && (calculableValue = ((CalculableProperty)property).getCalculableValue()) instanceof BooleanExpression && !(calculableValue instanceof BooleanPrimitive)) {
            return OracleProgrammer.format(this.getCaseWhenThenElsePattern(), expression, this.getTrue(), this.getFalse());
        }
        return super.fixCalculableColumnValueExpression(expression, property);
    }

    @Override
    protected String defaultCharStringPattern() {
        return "to_char({0})";
    }

    @Override
    protected String defaultZeroPaddedStringPattern(int width) {
        return "lpad({0}, " + width + ", '0')";
    }
}

