/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.sql;

import adalid.core.sql.NativeQuery;
import adalid.core.sql.QualifiedQuery;

public class NamedQuery
extends NativeQuery {
    static final String NAMED_QUERY_FUNCTION = "NamedQuery";
    private final String queryName;

    public static String getJavaExpressionOfSqlExpression(String sqlExpression) {
        return sqlExpression == null ? null : sqlExpression.replaceAll("NamedQuery\\('(\\w+)'\\)", "(\" + $1() + \")");
    }

    public static NamedQuery of(String queryName) {
        return new NamedQuery(queryName);
    }

    public static NamedQuery of(String queryName, String unqualifiedStatement) {
        return new NamedQuery(queryName, unqualifiedStatement);
    }

    public static NamedQuery of(String queryName, QualifiedQuery ... qualifiedQueries) {
        return new NamedQuery(queryName, qualifiedQueries);
    }

    NamedQuery(String queryName) {
        super("NamedQuery('" + queryName + "')");
        this.queryName = queryName;
    }

    NamedQuery(String queryName, String unqualifiedStatement) {
        super(unqualifiedStatement);
        this.queryName = queryName;
    }

    NamedQuery(String queryName, QualifiedQuery ... qualifiedQueries) {
        super(qualifiedQueries);
        this.queryName = queryName;
    }

    public String getQueryName() {
        return this.queryName;
    }
}

