/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.meta.sql;

import adalid.commons.TLB;
import adalid.commons.enums.LoggingLevel;
import adalid.commons.interfaces.Programmer;
import adalid.commons.interfaces.Wrapper;
import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.ArrUtils;
import adalid.commons.util.BitUtils;
import adalid.commons.util.FilUtils;
import adalid.commons.util.LogUtils;
import adalid.commons.util.ManUtils;
import adalid.commons.util.StrUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.commons.util.TimeUtils;
import adalid.commons.velocity.VelocityAid;
import adalid.commons.velocity.VelocityEngineer;
import adalid.commons.velocity.Writer;
import adalid.util.meta.sql.PlatformBean;
import adalid.util.meta.sql.TemplateBean;
import java.io.File;
import java.io.FileFilter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.velocity.VelocityContext;

public class MetaPlatformSql {
    private static Level _alertLevel = Level.WARN;
    private static Level _detailLevel = Level.OFF;
    private static Level _trackingLevel = Level.OFF;
    private static final Logger logger = Logger.getLogger(MetaPlatformSql.class);
    private static final String FILE_RESOURCE_LOADER_PATH = "file.resource.loader.path";
    private static final String FILE_RESOURCE_LOADER_PATH_FILTER = "file.resource.loader.path.filter";
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String FILE_SEPARATOR_CHARS = "/\\";
    private static final String[] FILE_SEPARATOR_STRINGS = new String[]{"/", "\\"};
    private static final String EOL = "\n";
    private static final String HINT = "\nhint: ";
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static final String DOT_STRING = ".string";
    private static final String DOT_CLASS = ".class";
    private static final String DOT_INSTANCE = ".instance";
    private static final String DOT_PROGRAMMER = ".programmer";
    private static final String DOT_WRAPPER = ".wrapper";
    private static final String[] DOT_SUFFIXES = new String[]{".string", ".class", ".instance", ".programmer", ".wrapper"};
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final FileFilter propertiesFileFilter = FilUtils.nameEndsWithFilter(".properties");
    private static final File bootstrappingRootFolder = PropertiesHandler.getRootFolder();
    private static final File[] bootstrappingVelocityFolders = PropertiesHandler.getVelocityFolders();
    private static final File bootstrappingVelocityPropertiesFile = PropertiesHandler.getVelocityPropertiesFile();
    private static final File[] bootstrappingPlatformsFolders = PropertiesHandler.getPlatformsFolders();
    private static final boolean bootstrappingRootFolderNotVisible = FilUtils.isNotVisibleDirectory(bootstrappingRootFolder);
    private static final boolean bootstrappingVelocityPropertiesFileNotVisible = FilUtils.isNotVisibleFile(bootstrappingVelocityPropertiesFile);
    private static final boolean WINDOWS = StringUtils.containsIgnoreCase((String)OS_NAME, (String)"windows");
    private static final String TP_DISABLED = "disabled";
    private static final String TP_DISABLED_MISSING = "disabled-when-missing";
    private static final String TP_TEMPLATE = "template";
    private static final String TP_TYPE = "template-type";
    private static final String TP_TYPE_DOCUMENT = "document";
    private static final String TP_TYPE_VELOCITY = "velocity";
    private static final String[] TP_TYPE_ARRAY = new String[]{"document", "velocity"};
    private static final String TP_PATH = "path";
    private static final String TP_PACKAGE = "package";
    private static final String TP_FILE = "file";
    private static final String TP_PRESERVE = "preserve";
    private static final String TP_ENCODING = "template-encoding";
    private static final String TP_CHARSET = "file-encoding";
    private static final String TP_EXECUTE_COMMAND = "execute-" + (WINDOWS ? "windows" : "linux") + "-command";
    private static final String TP_EXECUTE_DIRECTORY = "execute-directory";
    private static final String TP_FOR_EACH = "for-each";
    private static final String VC_PLATFORM = "platform";
    private static final String VC_TEMPLATE = "template";
    private static final String VC_TEMPLATE_PATH = "templatePath";
    private static final String VC_PATH = "path";
    private static final String VC_PACKAGE = "package";
    private static final String VC_FILE = "file";
    private static final String VC_ROOT_PATH = "rootFolderPath";
    private static final String VC_ROOT_SLASHED_PATH = "rootFolderSlashedPath";
    private static final String VC_USER_PATH = "userFolderPath";
    private static final String VC_USER_SLASHED_PATH = "userFolderSlashedPath";
    private static final String VC_BUILD_DATE = "buildDate";
    private static final String VC_BUILD_TIMESTAMP = "buildTimestamp";
    private static final String VC_FILE_PATH = "filePath";
    private static final String VC_FILE_NAME = "fileName";
    private static final String VC_FILE_PATH_NAME = "filePathName";
    private static final String VC_FILE_PATH_FILE = "filePathFile";
    private final String platform;
    private PlatformBean platformBean;
    private int platforms = 0;
    private int templates = 0;
    private int disabledTemplates = 0;
    private int preservedFiles = 0;
    private int copiedFiles = 0;
    private int mergedFiles = 0;
    private int warnings = 0;
    private int errors = 0;
    private Set<String> optionalResourceNames;

    public static Level getAlertLevel() {
        return _alertLevel;
    }

    public static void setAlertLevel(Level level) {
        _alertLevel = LogUtils.check(level, Level.WARN, Level.WARN);
    }

    public static Level getDetailLevel() {
        return _detailLevel;
    }

    public static void setDetailLevel(Level level) {
        _detailLevel = LogUtils.check(level, Level.OFF, Level.INFO);
    }

    public static Level getTrackingLevel() {
        return _trackingLevel;
    }

    public static void setTrackingLevel(Level level) {
        _trackingLevel = LogUtils.check(level, Level.OFF, Level.INFO);
    }

    public static LoggingLevel getAlertLoggingLevel() {
        return LoggingLevel.getLoggingLevel(_alertLevel);
    }

    public static void setAlertLoggingLevel(LoggingLevel logginglevel) {
        MetaPlatformSql.setAlertLevel(logginglevel.getLevel());
    }

    public static LoggingLevel getDetailLoggingLevel() {
        return LoggingLevel.getLoggingLevel(_detailLevel);
    }

    public static void setDetailLoggingLevel(LoggingLevel logginglevel) {
        MetaPlatformSql.setDetailLevel(logginglevel.getLevel());
    }

    public static LoggingLevel getTrackingLoggingLevel() {
        return LoggingLevel.getLoggingLevel(_trackingLevel);
    }

    public static void setTrackingLoggingLevel(LoggingLevel logginglevel) {
        MetaPlatformSql.setTrackingLevel(logginglevel.getLevel());
    }

    public Set<String> getOptionalResourceNames() {
        return this.optionalResourceNames;
    }

    public void setOptionalResourceNames(Set<String> optionalResourceNames) {
        this.optionalResourceNames = optionalResourceNames;
    }

    public MetaPlatformSql(String platform) {
        this.platform = platform;
    }

    public boolean read() {
        this.log(Level.INFO, "read", "platform=" + this.platform);
        this.resetCounters();
        if (this.isInvalidBootstrapping()) {
            return false;
        }
        String platformPropertiesFileName = this.platform + PROPERTIES_SUFFIX;
        for (File bootstrappingPlatformsFolder : bootstrappingPlatformsFolders) {
            File platformPropertiesFile = new File(bootstrappingPlatformsFolder, platformPropertiesFileName);
            if (!FilUtils.isVisibleFile(platformPropertiesFile)) continue;
            this.platformBean = new PlatformBean(this.platform, platformPropertiesFile);
            WriterContext basicWriterContext = this.newWriterContext();
            this.readPlatform(basicWriterContext);
            return this.errors == 0;
        }
        return false;
    }

    private void readPlatform(WriterContext basicWriterContext) {
        File platformPropertiesFile = this.platformBean.getPropertiesFile();
        logger.info((Object)("propertiesFile=" + platformPropertiesFile.getPath()));
        try {
            VelocityContext platformContext = basicWriterContext.getVelocityContextClone();
            platformContext.put(VC_PLATFORM, (Object)this.platform);
            TLB.setProgrammers(basicWriterContext.programmers);
            TLB.setWrapperClasses(basicWriterContext.wrapperClasses);
            this.putProperties(platformContext, platformPropertiesFile);
            Properties properties = this.mergeProperties(platformContext, platformPropertiesFile);
            this.putStrings(platformContext, properties);
            WriterContext platformWriterContext = this.newWriterContext(platformContext);
            File platformsFolder = platformPropertiesFile.getParentFile();
            ExtendedProperties platformExtendedProperties = PropertiesHandler.getExtendedProperties(platformPropertiesFile);
            String[] pathnames = platformExtendedProperties.getStringArray(FILE_RESOURCE_LOADER_PATH);
            String[] pathfilters = platformExtendedProperties.getStringArray(FILE_RESOURCE_LOADER_PATH_FILTER);
            LinkedHashMap<String, File> folders = new LinkedHashMap<String, File>();
            if (pathnames != null && pathnames.length != 0) {
                for (File folder : bootstrappingPlatformsFolders) {
                    folders.putAll(FilUtils.directoriesMap(folder, pathnames, folder));
                }
            }
            if (pathfilters != null && pathfilters.length > 0) {
                String[] keyArray = folders.keySet().toArray((String[])ArrUtils.arrayOf(String.class));
                for (String pathfilter : pathfilters) {
                    String slashedFilter = pathfilter.replace(FILE_SEPARATOR, SLASH);
                    for (String key : keyArray) {
                        String slashedPath = key.replace(FILE_SEPARATOR, SLASH) + SLASH;
                        if (!slashedPath.contains(slashedFilter)) continue;
                        folders.remove(key);
                        logger.debug((Object)(pathfilter + " excludes " + key));
                    }
                }
            }
            String platformsFolderPath = platformsFolder.getPath();
            for (File folder : folders.values()) {
                this.log(_detailLevel, "read", "path=" + StringUtils.removeStart((String)folder.getPath(), (String)platformsFolderPath));
                Object[] templateFiles = folder.listFiles(propertiesFileFilter);
                Arrays.sort(templateFiles);
                for (Object templatePropertiesFile : templateFiles) {
                    TemplateBean templateBean = new TemplateBean(this.platformBean, (File)templatePropertiesFile);
                    this.readTemplate(platformWriterContext, templateBean);
                    ++this.templates;
                }
            }
            ++this.platforms;
        }
        catch (Throwable throwable) {
            this.error(throwable);
        }
        this.printSummary();
    }

    private void readTemplate(WriterContext platformWriterContext, TemplateBean templateBean) {
        File templatePropertiesFile = templateBean.getPropertiesFile();
        this.log(_trackingLevel, "read", "template=" + templatePropertiesFile);
        VelocityContext templateContext = platformWriterContext.getVelocityContextClone();
        this.putProperties(templateContext, templatePropertiesFile);
        WriterContext templateWriterContext = this.newWriterContext(templateContext);
        try {
            this.readFile(templateWriterContext, templateBean);
        }
        catch (Throwable throwable) {
            this.error(throwable);
        }
    }

    private void readFile(WriterContext templateWriterContext, TemplateBean templateBean) {
        File templatePropertiesFile = templateBean.getPropertiesFile();
        VelocityContext fileContext = templateWriterContext.getVelocityContextClone();
        Properties properties = this.mergeProperties(fileContext, templatePropertiesFile);
        this.putStrings(fileContext, properties);
        String userPath = this.pathString(USER_DIR);
        String temptype = StringUtils.defaultIfBlank((String)properties.getProperty(TP_TYPE), (String)TP_TYPE_VELOCITY);
        String template = StringUtils.trimToNull((String)properties.getProperty("template"));
        Object filePath = StringUtils.trimToNull((String)properties.getProperty("path"));
        String filePack = StringUtils.trimToNull((String)properties.getProperty("package"));
        String fileName = StringUtils.trimToNull((String)properties.getProperty("file"));
        String preserve = StringUtils.trimToNull((String)properties.getProperty(TP_PRESERVE));
        String charset1 = StringUtils.trimToNull((String)properties.getProperty(TP_ENCODING));
        String charset2 = StringUtils.trimToNull((String)properties.getProperty(TP_CHARSET));
        String disabled = properties.getProperty(TP_DISABLED, Boolean.FALSE.toString());
        String disabledMissing = properties.getProperty(TP_DISABLED_MISSING);
        String executeCommand = StringUtils.trimToNull((String)properties.getProperty(TP_EXECUTE_COMMAND));
        String executeDirectory = StringUtils.trimToNull((String)properties.getProperty(TP_EXECUTE_DIRECTORY));
        String forEach = StringUtils.trimToNull((String)properties.getProperty(TP_FOR_EACH));
        String hint = ", check property \"{0}\" at file \"{1}\"";
        if (!ArrayUtils.contains((Object[])TP_TYPE_ARRAY, (Object)temptype)) {
            String pattern = "failed to obtain a valid template type" + hint;
            String message = MessageFormat.format(pattern, TP_TYPE, templatePropertiesFile);
            logger.error((Object)message);
            ++this.errors;
            return;
        }
        if (template == null) {
            String pattern = "failed to obtain a valid template name" + hint;
            String message = MessageFormat.format(pattern, "template", templatePropertiesFile);
            logger.error((Object)message);
            ++this.errors;
            return;
        }
        if (fileName == null) {
            String pattern = "failed to obtain a valid file name" + hint;
            String message = MessageFormat.format(pattern, "file", templatePropertiesFile);
            logger.error((Object)message);
            ++this.errors;
            return;
        }
        String templatePathString = this.pathString(template);
        String templatePath = StringUtils.substringBeforeLast((String)templatePathString, (String)FILE_SEPARATOR);
        fileContext.put("template", (Object)StringEscapeUtils.escapeJava((String)templatePathString));
        fileContext.put(VC_TEMPLATE_PATH, (Object)StringUtils.replace((String)templatePath, (String)FILE_SEPARATOR, (String)SLASH));
        fileContext.put("file", (Object)fileName);
        if (filePath == null) {
            filePath = userPath;
        } else if (this.isRelativePath((String)(filePath = this.pathString((String)filePath)))) {
            filePath = ((String)filePath).startsWith(FILE_SEPARATOR) ? userPath + (String)filePath : userPath + FILE_SEPARATOR + (String)filePath;
        }
        fileContext.put("path", (Object)StringEscapeUtils.escapeJava((String)filePath));
        if (filePack != null) {
            filePath = (String)filePath + FILE_SEPARATOR + this.pathString(StringUtils.replace((String)filePack, (String)DOT, (String)SLASH));
            fileContext.put("package", (Object)this.dottedString(filePack));
        }
        File path = new File((String)filePath);
        String fullname = path.getPath() + FILE_SEPARATOR + fileName;
        fileContext.put(VC_FILE_PATH, (Object)StringEscapeUtils.escapeJava((String)filePath));
        fileContext.put(VC_FILE_NAME, (Object)StringEscapeUtils.escapeJava((String)fileName));
        fileContext.put(VC_FILE_PATH_NAME, (Object)StringEscapeUtils.escapeJava((String)fullname));
        fileContext.put(VC_FILE_PATH_FILE, (Object)path);
        templateBean.setPath(templatePathString);
        templateBean.setType(temptype);
        templateBean.setEncoding(charset1);
        templateBean.setForEach(forEach);
        templateBean.setTargetPath((String)filePath);
        templateBean.setTargetPackage(filePack);
        templateBean.setTargetFile(fileName);
        templateBean.setTargetFileEncoding(charset2);
        templateBean.setExecuteCommand(executeCommand);
        templateBean.setExecuteDirectory(executeDirectory);
        templateBean.setDisabled(BitUtils.valueOf(disabled));
        templateBean.setDisabledWhenMissing(BitUtils.valueOf(disabledMissing));
        templateBean.setPreserveExistingFile(BitUtils.valueOf(preserve));
        templateBean.setBytes(0);
        templateBean.setLines(0);
    }

    private WriterContext newWriterContext() {
        TLB.clearProgrammers();
        TLB.clearWrapperClasses();
        WriterContext context = new WriterContext();
        context.velocityContext = this.newVelocityContext();
        context.programmers = TLB.getProgrammers();
        context.wrapperClasses = TLB.getWrapperClasses();
        return context;
    }

    private WriterContext newWriterContext(VelocityContext velocityContext) {
        WriterContext context = new WriterContext();
        context.velocityContext = velocityContext;
        context.programmers = TLB.getProgrammersClone();
        context.wrapperClasses = TLB.getWrapperClassesClone();
        return context;
    }

    private VelocityContext newVelocityContext() {
        VelocityContext context = new VelocityContext();
        this.putClass(context, VelocityAid.class);
        this.putClass(context, FilUtils.class);
        this.putClass(context, ManUtils.class);
        this.putClass(context, StrUtils.class);
        this.putClass(context, TimeUtils.class);
        this.putClass(context, StringUtils.class);
        this.putClass(context, StringEscapeUtils.class);
        this.putClass(context, Boolean.class);
        this.putClass(context, Byte.class);
        this.putClass(context, Character.class);
        this.putClass(context, Double.class);
        this.putClass(context, Float.class);
        this.putClass(context, Integer.class);
        this.putClass(context, Long.class);
        this.putClass(context, Short.class);
        this.putClass(context, String.class);
        this.putClass(context, System.class);
        this.putClass(context, BigDecimal.class);
        this.putClass(context, BigInteger.class);
        this.putClass(context, Date.class);
        this.putClass(context, Time.class);
        this.putClass(context, Timestamp.class);
        String path = this.getRoot().getPath();
        context.put(VC_ROOT_PATH, (Object)StringEscapeUtils.escapeJava((String)path));
        context.put(VC_ROOT_SLASHED_PATH, (Object)path.replace('\\', '/'));
        context.put(VC_USER_PATH, (Object)StringEscapeUtils.escapeJava((String)USER_DIR));
        context.put(VC_USER_SLASHED_PATH, (Object)USER_DIR.replace('\\', '/'));
        context.put(VC_BUILD_DATE, (Object)TimeUtils.simpleDateString());
        context.put(VC_BUILD_TIMESTAMP, (Object)TimeUtils.simpleTimestampString());
        logger.info((Object)("rootFolderPath=" + path));
        logger.info((Object)("userFolderPath=" + USER_DIR));
        return context;
    }

    private void putClass(VelocityContext context, Class<?> clazz) {
        context.put(clazz.getSimpleName(), clazz);
    }

    private void putProperties(VelocityContext context, File propertiesFile) {
        String hint = "\nhint: check property \"{0}\" at file \"{1}\"";
        String pattern1 = "failed to load {2}" + hint;
        Properties properties = PropertiesHandler.loadProperties(propertiesFile);
        Set<String> stringPropertyNames = properties.stringPropertyNames();
        for (String name : stringPropertyNames) {
            String velocityKey;
            String string2;
            String string1;
            this.checkPropertyName(name, propertiesFile);
            if (StringUtils.endsWithIgnoreCase((String)name, (String)DOT_STRING)) {
                string1 = StringUtils.removeEndIgnoreCase((String)name, (String)DOT_STRING);
                string2 = StringUtils.trimToEmpty((String)properties.getProperty(name));
                velocityKey = StrUtils.getCamelCase(string1, true);
                context.put(velocityKey, (Object)string2);
                continue;
            }
            if (!StringUtils.endsWithIgnoreCase((String)name, (String)DOT_CLASS)) continue;
            string1 = StringUtils.removeEndIgnoreCase((String)name, (String)DOT_CLASS);
            string2 = StringUtils.trimToEmpty((String)properties.getProperty(name));
            String message = MessageFormat.format(pattern1, name, propertiesFile, string2);
            Class<?> object2 = this.getClassForName(string2, message);
            if (object2 != null) {
                velocityKey = StrUtils.getCamelCase(string1, true);
                context.put(velocityKey, object2);
                continue;
            }
            throw new RuntimeException(message, new IllegalArgumentException(string2));
        }
    }

    private void checkPropertyName(String name, File file) {
        int endIndex;
        String pattern = "invalid property name \"{0}\" at file \"{1}\"";
        String message = MessageFormat.format(pattern, StringUtils.trimToEmpty((String)name), file);
        if (StringUtils.isBlank((String)name)) {
            throw new RuntimeException(message);
        }
        String low = name.toLowerCase();
        if (StringUtils.endsWithAny((String)low, (String[])DOT_SUFFIXES) && (endIndex = StringUtils.lastIndexOfAny((String)low, (String[])DOT_SUFFIXES)) == 0) {
            throw new RuntimeException(message);
        }
    }

    private Class<?> getClassForName(String className, String message) {
        if (StringUtils.isBlank((String)className)) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(message, ex);
        }
    }

    private Properties mergeProperties(VelocityContext context, File propertiesFile) {
        String template = this.getTemplate(propertiesFile);
        StringWriter sw = this.mergeTemplate(context, template);
        if (sw != null) {
            byte[] buffer = sw.toString().getBytes();
            Properties properties = PropertiesHandler.loadProperties(buffer);
            return properties;
        }
        return null;
    }

    private String getTemplate(File propertiesFile) {
        String shortestPath = null;
        String propertiesFilePath = propertiesFile.getPath().replace(FILE_SEPARATOR, SLASH);
        String[] velocityFileResourceLoaderPathArray = VelocityEngineer.getFileResourceLoaderPathArray();
        if (velocityFileResourceLoaderPathArray != null && velocityFileResourceLoaderPathArray.length > 0) {
            for (String path : velocityFileResourceLoaderPathArray) {
                String slashedPath = StringUtils.removeEnd((String)path.replace(FILE_SEPARATOR, SLASH), (String)SLASH) + SLASH;
                if (!StringUtils.startsWithIgnoreCase((String)propertiesFilePath, (String)slashedPath) || shortestPath != null && slashedPath.length() >= shortestPath.length()) continue;
                shortestPath = slashedPath;
            }
        }
        if (shortestPath == null) {
            return propertiesFile.getName();
        }
        String template = StringUtils.removeStartIgnoreCase((String)propertiesFilePath, shortestPath);
        return StringUtils.removeStartIgnoreCase((String)template, (String)SLASH);
    }

    private StringWriter mergeTemplate(VelocityContext context, String template) {
        String message = "failed to merge \"" + template + "\"";
        try {
            return VelocityEngineer.merge(context, template);
        }
        catch (Exception ex) {
            throw new RuntimeException(message, ex);
        }
    }

    private void putStrings(VelocityContext context, Properties properties) {
        Set<String> stringPropertyNames = properties.stringPropertyNames();
        for (String name : stringPropertyNames) {
            if (!StringUtils.endsWithIgnoreCase((String)name, (String)DOT_STRING)) continue;
            String string1 = StringUtils.removeEndIgnoreCase((String)name, (String)DOT_STRING);
            String string2 = StringUtils.trimToEmpty((String)properties.getProperty(name));
            String velocityKey = StrUtils.getCamelCase(string1, true);
            context.put(velocityKey, (Object)string2);
        }
    }

    private File getRoot() {
        File root = PropertiesHandler.getRootFolder();
        if (FilUtils.isVisibleDirectory(root)) {
            return root;
        }
        root = new File(USER_DIR + FILE_SEPARATOR + "test");
        if (FilUtils.isVisibleDirectory(root) || root.mkdirs()) {
            return root;
        }
        return new File(USER_DIR);
    }

    private String dottedString(String string) {
        return this.trimSplitJoin(string, FILE_SEPARATOR_CHARS, DOT);
    }

    private String pathString(String string) {
        String trimmed = StringUtils.trimToNull((String)string);
        if (trimmed == null) {
            return null;
        }
        String trimSplitJoin = this.trimSplitJoin(trimmed, FILE_SEPARATOR_CHARS, FILE_SEPARATOR);
        return StringUtils.startsWithAny((String)trimmed, (String[])FILE_SEPARATOR_STRINGS) ? FILE_SEPARATOR + trimSplitJoin : trimSplitJoin;
    }

    private String trimSplitJoin(Object object, String separatorChars, String separator) {
        String casted = object == null ? null : (object instanceof String ? (String)object : object.toString());
        String string = StringUtils.trimToNull(casted);
        if (string == null) {
            return null;
        }
        Object[] tokens = StringUtils.split((String)string, (String)separatorChars);
        String join = StringUtils.join((Object[])tokens, (String)separator);
        return join;
    }

    private boolean isAbsolutePath(String string) {
        String trimmed = StringUtils.trimToNull((String)string);
        if (trimmed == null) {
            return false;
        }
        if (WINDOWS) {
            String left = StringUtils.left((String)trimmed, (int)2);
            return left.matches("[a-zA-Z]\\:");
        }
        return StringUtils.startsWithAny((String)trimmed, (String[])FILE_SEPARATOR_STRINGS);
    }

    private boolean isRelativePath(String string) {
        return StringUtils.isNotBlank((String)string) && !this.isAbsolutePath(string);
    }

    private void printSummary() {
        logger.info((Object)("platforms=" + this.platforms));
        logger.info((Object)("templates=" + this.templates));
        logger.info((Object)("disabled-templates=" + this.disabledTemplates));
        logger.info((Object)("enabled-templates=" + (this.templates - this.disabledTemplates)));
        logger.info((Object)("files=" + (this.preservedFiles + this.copiedFiles + this.mergedFiles)));
        logger.info((Object)("preserved-files=" + this.preservedFiles));
        logger.info((Object)("written-files=" + (this.copiedFiles + this.mergedFiles)));
        logger.info((Object)("copied-files=" + this.copiedFiles));
        logger.info((Object)("generated-files=" + this.mergedFiles));
        if (this.warnings == 0) {
            logger.info((Object)("warnings=" + this.warnings));
        } else {
            logger.warn((Object)("warnings=" + this.warnings));
        }
        if (this.errors == 0) {
            logger.info((Object)("errors=" + this.errors));
        } else {
            logger.warn((Object)("errors=" + this.errors));
        }
    }

    private void resetCounters() {
        this.platforms = 0;
        this.templates = 0;
        this.disabledTemplates = 0;
        this.preservedFiles = 0;
        this.copiedFiles = 0;
        this.mergedFiles = 0;
        this.warnings = 0;
        this.errors = 0;
    }

    private boolean isInvalidBootstrapping() {
        boolean invalid = false;
        if (bootstrappingRootFolderNotVisible) {
            logger.error((Object)"root folder is missing or invalid");
            invalid = true;
        }
        if (bootstrappingVelocityFolders == null || bootstrappingVelocityFolders.length == 0) {
            logger.error((Object)"velocity folder is missing or invalid");
            invalid = true;
        }
        if (bootstrappingVelocityPropertiesFileNotVisible) {
            logger.error((Object)"velocity properties file is missing or invalid");
            invalid = true;
        }
        if (bootstrappingPlatformsFolders == null || bootstrappingPlatformsFolders.length == 0) {
            logger.error((Object)"platforms folder is missing or invalid");
            invalid = true;
        }
        return invalid;
    }

    private void log(Level level, String method, Object ... parameters) {
        if (LogUtils.foul(logger, level)) {
            return;
        }
        String message = this.signature(method, parameters);
        logger.log((Priority)level, (Object)message);
    }

    private String signature(String method, Object ... parameters) {
        String pattern = "{0}({1})";
        return MessageFormat.format(pattern, method, StringUtils.join((Object[])parameters, (String)", "));
    }

    private void error(Throwable throwable) {
        Throwable cause = ThrowableUtils.getCause(throwable);
        String message = throwable.equals(cause) ? throwable.getClass().getSimpleName() : throwable.getMessage();
        logger.error((Object)message, cause);
        ++this.errors;
    }

    public void write() {
        this.log(Level.INFO, "write", "platform=" + this.platform);
        Writer writer = new Writer(this.platformBean, "root");
        writer.write("meta-platform-sql");
    }

    private class WriterContext {
        private VelocityContext velocityContext;
        Map<String, Programmer> programmers;
        Map<String, Class<? extends Wrapper>> wrapperClasses;

        private WriterContext() {
        }

        private VelocityContext getVelocityContextClone() {
            return (VelocityContext)this.velocityContext.clone();
        }
    }
}

